package Sandbox::FakeBSInfo;

# $Id$

=head1 NAME

    Sandbox::FakeBSInfo

=head1 DESCRIPTION

    Эмуляция крутилки для песочницы

=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use HttpTools;

use utf8;

sub handler {
    my ($r, $multiform) = @_;

    my $form = multiform2directform($multiform);
    my @orders = split(/\s+/, $form->{'order-id'});

    my $camps_data = get_hashes_hash_sql(PPC, [
        "select c.OrderID,
            IF(c.statusShow = 'Yes', 1, 0) as is_shown,
            IF(IF(c.wallet_cid > 0, w.sum+c.sum-w.sum_spent-c.sum_spent, c.sum-c.sum_spent>0.009), 1, 0) as money_on_camp,
            SUM(IF(b.statusActive = 'Yes', 1, 0)) as active_banners
        from campaigns c
            left join banners b using (cid)
            left join campaigns w on (c.wallet_cid = w.cid)",
        where => { 'c.OrderId' => \@orders },
        "group by c.cid"
    ]);

    my $result;

    while(my ($order_id, $d) = each %$camps_data) {
        my $camp_statusActive = $d && $d->{is_shown} && $d->{money_on_camp} && $d->{active_banners} ? 0 : 1;
        $result .= $order_id."\t".$camp_statusActive."\n";
    }

    return {text => $result, content_type => 'text/xml'};
}

1;
