package Sandbox::FakeBSSOAP;
## no critic (TestingAndDebugging::RequireUseWarnings)

# $Id$

=head1 NAME

Sandbox::FakeBSSOAP - модуль для ответов ненастоящего БК

=head1 DESCRIPTION

    Эмуляция БК для сбора статистики и активизации кампаний

=cut

use strict;

use JSON;
use SOAP::Transport::HTTP;
use SOAP::Transport::HTTP::Plack;

use Settings;
use SandboxCommon;

use Yandex::SOAP::UTF8Serializer;

use utf8;

my $server_YaBSSOAPExport = SOAP::Transport::HTTP::Plack
        -> serializer( new Yandex::SOAP::UTF8Serializer('utf8'))
        -> deserializer( new Yandex::SOAP::UTF8Deserializer('utf8') )
        -> dispatch_to("$Settings::ROOT/protected/Sandbox", 'YaBSSOAPExport'); 

sub handler {
    my ($r, $multiform) = @_;

    $r->headers->header('SOAPAction') =~ /(\w+)#(\w+)/;
    my $soapmodule = $1 || '';
    my $soapaction = $2 || 'null';

    if ($_[0]->path_info =~ /master-report\.cgi/) {
        my $request = from_json( $r->content );
        # для потоковой обработки ответа обязательно чтоб поле data шло после всего остального (БК это гарантирует)
        my $stat = get_fake_master_report_stat($request);
        my $data_obj_json = to_json({data => delete $stat->{data}});
        $data_obj_json =~ s/^{//;
        my $headers_obj_json = to_json($stat);
        $headers_obj_json =~ s/}$//;

        my $stat_json = $headers_obj_json . ',' . $data_obj_json;
        return {text => $stat_json};
    } elsif ($_[0]->path_info =~ m!export/update-prices\.cgi!) {
        return {text => 1};

    } elsif ($_[0]->path_info =~ m!export/import-application-store-data\.cgi!) {
        my $request = eval { from_json($r->content) };

        my %response_data;
        if (!$request || $@ || ref $request ne 'ARRAY') {
            $response_data{Error} = 1;
            $response_data{ErrorMessage} = 'Invalid request format';
        } else {
            my @result;
            for my $content (@$request) {
                my %content_answer;
                if ($content && ref $content eq 'HASH' && defined $content->{mobile_app_id}) {
                    $content_answer{mobile_app_id} = $content->{mobile_app_id};
                } else {
                    $content_answer{Error} = 1;
                    $content_answer{ErrorMessage} = 'Invalid entry';
                }
                push @result, \%content_answer;
            }
            $response_data{Result} = \@result;
        }

        return {json => \%response_data};

    } else {
        if ($soapmodule eq 'YaBSSOAPExport'){
            $server_YaBSSOAPExport->handler(@_);
        } else {
            die "unknown module $soapmodule";
        }
    }
}

1;
