package Sandbox::FakeBlackbox;

# $Id$

=head1 NAME

    Sandbox::FakeBlackbox

=head1 DESCRIPTION

    Эмуляция блэкбокса для песочницы

=cut

use strict;
use warnings;

use Intapi;
use Yandex::HTTP qw/http_fetch/;
use Yandex::HashUtils;

use Settings;
use Yandex::DBTools;
use HttpTools;
use TextTools qw/string2xml/;
use TvmChecker;
use LogTools qw/log_messages/;

use utf8;

sub handler {
    my ($r, $multiform) = @_;

    my $form = multiform2directform($multiform);
    # Для неизвестных юзеров фейковый BB ходит в настоящий BB за авторизацией.
    # Для получения TVM User Ticket нужно отправлять сервисный тикет, чего фейковый BB пока не умеет.
    # Пока он это делать не научится - удаляем часть про юзер-тикет из общего запроса к реальному BB
    delete $form->{get_user_ticket};

    my $result = '';

    if ($form->{method} eq 'userinfo') {

        my @req_uids = split(',', $form->{uid});

        if (scalar(@req_uids) lt 2) {
            $result = single_bb_request($form);
        } else {
            $result = bulk_bb_request(\@req_uids);
        }

        if (!$result) {
            # ни один uid не нашёлся в базе, на всякий случай идём в Blackbox
            $result = base_blackbox_request($form);
        }

    } elsif ($form->{method} eq 'sessionid' || $form->{method} eq 'oauth') {

        $result = base_blackbox_request($form);

    } else {
        die 'unknown method';
    }

    return { text => $result, content_type => 'text/xml'};
}

=head2 single_bb_request

    Если в фейковой базе есть запрошенные uid, сформировать ответ по нему.
    Если из базы ничего не приходит, возвращается undef.

=cut
sub single_bb_request {
    my $where = hash_cut($_[0], 'uid', 'login');
    my $res = get_one_line_sql(FAKEBLACKBOX, ["select * from users", where => $where]);
    if (!$res) {
        return undef;
    }
    return join("\n",
        '<?xml version="1.0" encoding="UTF-8"?>',
        '<doc>',
        '<status id="0">VALID</status>',
        '<error>OK</error>',
        '<uid hosted="0" domid="" domain="" mx="">'.$res->{uid}.'</uid>',
        '<login>'.$res->{login}.'</login>',
        '<regname>'.$res->{login}.'</regname>',
        '<display_name>',
        '<name>'.$res->{login}.'</name>',
        '</display_name>',
        join("\n", map {sprintf('<dbfield id="%s">%s</dbfield>', $_, string2xml($res->{$_}))}
                        grep {$res->{$_}} grep {$_ !~ m/^(login|uid)$/} keys %$res),
        '</doc>'
    );
}

=head2 bulk_bb_request

    Если в фейковой базе есть запрошенные uid-ы, сформировать bulk-response.
    Если из базы ничего не приходит, возвращается undef.

=cut
sub bulk_bb_request {
    my @uids = @{$_[0]};
    my @sql_resp = @{get_all_sql(FAKEBLACKBOX, ["select uid, login from users",
                                               where => {uid__int => \@uids}])};
    if (@sql_resp) {
        my @res_arr = map {join("\n",
            '<user id="'.$_->{uid}.'">',
            '<uid hosted="0"></uid>',
            '<karma confirmed="0">0</karma>',
            '<karma_status>0</karma_status>',
            '</user>'
        )} @sql_resp;
        return '<?xml version="1.0" encoding="UTF-8"?>'."\n<doc>\n"
               .join("\n", @res_arr)."\n</doc>";
    } else {
        return undef;
    }
}

=head2 base_blackbox_request
    
    Кажется, функция должна либо сама переехать в Yandex::Blackbox, 
    либо вместо нее должен быть вызов готового кода из Yandex::Blackbox

=cut

sub base_blackbox_request {
    my $form = shift;

    my $headers = {
        'User-Agent' => "Yandex::Blackbox/perl/1.00",
    };

    my $use_tvm = TvmChecker::use_tvm();
    if ($use_tvm) {
        my $tvm_ticket = eval{Yandex::TVM2::get_ticket($Yandex::Blackbox::BLACKBOX_TVM2_ID)} 
            or die("Cannot get ticket for $$Yandex::Blackbox::BLACKBOX_TVM2_ID: $@");
        $headers->{'X-Ya-Service-Ticket'} = $tvm_ticket;
    } else {
        log_messages("base_blackbox_request", "tvm disabled");
    }

    my $content = http_fetch(GET => $Yandex::Blackbox::BLACKBOX_URL_BASE, $form,
        headers => $headers,
        timeout => 5,
        ipv6_prefer => 1,
    );

    if ( !$@ ) {
        return $content;
    }
    return undef;
}

1;
