package Sandbox::FakePassport;

# $Id$

=head1 NAME

    Sandbox::FakePassport

=head1 DESCRIPTION

    Эмуляция паспорта для песочницы

=cut

use strict;
use warnings;
use utf8;

use Yandex::DBTools;

use Settings;
use Direct::ResponseHelper;

sub handler {
    my ($r, $multiform) = @_;

    my $method = $r->path_info();

    # заведение нового логина в "паспорте"
    if ($method eq '/1/bundle/account/register/by_middleman/') {

        my $res = get_one_field_sql(FAKEBLACKBOX, ["select 1 from users", where => {login => $multiform->{login}}, 'LIMIT 1']);

        if ($res) {
            return respond_json($r, {status => 'error', errors => ['login.notavailable']});
        } else {
            my $result = do_sql(FAKEBLACKBOX, "INSERT INTO users
                            (`login`, `accounts.login.uid`, `account_info.email.uid`, `account_info.fio.uid`) 
                            VALUES (?, ?, ?, ?)",
                            $multiform->{login}, $multiform->{login}, $multiform->{login}.'@yandex.ru',
                            "$multiform->{lastname} $multiform->{firstname}" );
            my $uid;
            if ($result) {
                $uid = get_one_field_sql(FAKEBLACKBOX, ["select uid from users", where => {login => $multiform->{login}}, 'LIMIT 1']);
            }
            
            if ($uid) {
                return respond_json($r, {status => 'ok', uid => $uid});
            } else {
                return respond_json($r, {status => 'error', errors => ['backend.database_failed']});
            }
        }
    } else {
        return respond_http_error($r, 404);
    }
}

1;
