package Sandbox::FakeYaMoney;

# $Id$

=head1 NAME

    Sandbox::FakeYaMoney

=head1 DESCRIPTION

    Эмуляция Я.Денег для песочницы

=cut

use strict;
use warnings;

use JSON;

use Settings;

use utf8;

my $FAKE_TOKEN = '12345678901234.1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF1234567890ABCDEF';

sub handler {
    my ($r, $multiform) = @_;

    my $token = $r->{env}{HTTP_AUTHORIZATION};
    my $method = $r->{env}{PATH_INFO};
    $method =~ s/^\///;

    my $result = {};

    if ($method eq 'token-validate') {
        my ($bearer, $tok) = split ' ', $token;
        if ($bearer eq 'Bearer' && $tok eq $FAKE_TOKEN) {
            $result->{uid} = 1;
            $result->{scope} = 'payment.to-pattern(3081).limit(1,10000.00) money-source(\"wallet\",\"card\") yandex-direct(\"permission1\")';
        } else {
            return {text => "invalid_token", code => 401};
        }
    } else {
        die 'unknown method';
    }

    return { text => JSON::to_json($result), content_type => 'application/json;charset=UTF-8'};
}

1;
