package YaBSSOAPExport;

# $Id$

=pod

=encoding utf-8

=head1 NAME

YaBSSOAPExport - БК в песочнице

=head1 DESCRIPTION

    Эмуляция баннерной крутилки для песочницы

    XMLRPC::Transport::HTTP::Apache хочет, чтобы модуль и пакет назывались именно YaBSSOAPExport

=cut

use Direct::Modern;

use POSIX qw/strftime/;
use SandboxCommon;
use BS::Export;
use Yandex::Hostname;

use Settings;
use HashingTools qw/bs_md5int_utf8/;


# ВНИМАНИЕ! Если меняете этот метод, то нужно также поменять аналогичный в джаве - FakeBsExportLogsUtils::fillResponse
sub UpdateData2
{
    my ($self, $data) = @_;

    my $response = {};

    for my $o (values %{$data->{ORDER}}) {

        my $order = BS::Export::get_query_data($response, 'ORDER', [$o->{ID}, $o->{EID}], [qw/ID EID/]);
        $order->{ID} ||= $order->{EID};
        $order->{Archive} = $o->{Archive};
        $order->{Archived} = $order->{Archive} ? 1 : 0;
        $order->{UpdateTime} = strftime("%Y%m%d%H%M%S", localtime);
        $order->{Stop} = $o->{Stop};

        for my $c (values %{$o->{CONTEXT}}) {

            my $context = BS::Export::get_query_data($order, 'CONTEXT', [$c->{ID}, $c->{EID}], [qw/ID EID/]);
            $context->{ID} ||= $context->{EID};

            ## no critic (Freenode::DollarAB)
            for my $b (values %{$c->{BANNER}}) {
                my $banner = BS::Export::get_query_data($context, 'BANNER', [$b->{ID}, $b->{EID}], [qw/ID EID/]);
                $banner->{ID} ||= $banner->{EID};
                $banner->{Stop} = $b->{Stop};
            }

            for my $p (values %{$c->{PHRASE}}) {
                my $phrase = BS::Export::get_query_data($context, 'PHRASE', [$p->{ID}, $p->{EID}], [qw/ID EID/]);
                if ($p->{Text}) {
                    $phrase->{ID} = _get_phrase_id($phrase, $p->{Text});
                } else {
                    $phrase->{ID} = _get_phrase_id($phrase);
                }
            }

            for my $r (values %{$c->{GOAL_CONTEXT}}) {
                my $retargeting = BS::Export::get_query_data($context, 'GOAL_CONTEXT', [$r->{ID}, $r->{EID}], [qw/ID EID/]);
                $retargeting->{ID} = _get_phrase_id($retargeting);
            }

            for my $r (values %{$c->{DYNAMIC}}) {
                my $dynamic = BS::Export::get_query_data($context, 'DYNAMIC', [$r->{ID}, $r->{EID}], [qw/ID EID/]);
                $dynamic->{ID} = _get_phrase_id($dynamic);
            }

            for my $r (values %{$c->{FILTER}}) {
                my $filter = BS::Export::get_query_data($context, 'FILTER', [$r->{ID}, $r->{EID}], [qw/ID EID/]);
                $filter->{ID} = _get_phrase_id($filter);
            }

            for my $r (values %{$c->{RELEVANCE_MATCH}}) {
                $context->{'RELEVANCE_MATCH'}->{$r->{EID}} ||= {
                    'EID' => $r->{EID}
                };
            }
        }
    }

    state $hostname;
    $hostname //= Yandex::Hostname::hostfqdn();
    $response->{BACKEND_HOST} = $hostname;

    return $response;
}

sub _get_phrase_id {
    my ($object, $text) = @_;
    my ($eid, $id) = @{$object}{qw/EID ID/};
    if ($id) {
        # если есть существующий БК-шный идентификатор - возвращаем его
        return $id;
    } elsif ($text) {
        # вычисляем по тексту фразу как в БК
        return bs_md5int_utf8($text);
    } else {
        $eid += $SandboxCommon::PHRASE_ID_FACTOR;
        # Для использования фейковой БК в тестах транспорта
        while ($eid > 2 ** 31 - 1) {
            $eid -= 2 ** 31 - 1;
            # дополнительно вычитаем 1, чтобы не получить нулевое значение, оно не подходит по смыслу
        }
        return $eid;
    }
}

1;
