package SandboxCommon;

#  $Id$

=head1 NAME

    SandboxCommon

=head1 DESCRIPTION

    фукнции для песочницы

=cut

use warnings;
use strict;
use POSIX qw/strftime/;

use List::MoreUtils qw/any uniq/;
use List::Util qw/max min sum0/;
use Digest::MD5 qw/md5_hex/;

use Yandex::Balance;
use Yandex::DBShards qw/delete_shard/;
use Yandex::DBTools;
use Yandex::HashUtils;
use Yandex::ListUtils qw/xflatten/;
use Yandex::MyGoodWords;
use Yandex::Retry;
use Yandex::TimeCommon;
use Yandex::DateTime;
use Yandex::Overshard;

use Campaign qw/can_create_camp create_empty_camp del_camp_data save_camp/;
use Client::CurrencyTeaserData;
use Client;
use Currencies;
use Currency::Rate;
use CommonMaps qw/check_address_map/;
use Direct::AdGroups2::Text;
use Direct::Banners::Text;
use Direct::Keywords;
use Direct::Model::AdGroupText;
use Direct::Model::BannerText;
use Direct::Model::Keyword;
use EnvTools;
use HashingTools;
use Notification;
use Primitives;
use PrimitivesIds;
use RBACDirect;
use RBACElementary;
use Settings;
use Tag;
use TextTools;
use User;
use VCards qw//;
use geo_regions;
use Stat::Const qw/:enums/;
use Stat::Tools;

use APICommon qw/api_initialize get_max_available_api_version get_new_master_token/;
use APIMethods;
use API::Validate;
use API::Methods::Finance;
use API::Methods::Clients;

use BS::Export::Queues;

use Models::CampaignOperations qw/db_update_campaign_statusModerate/;

use base qw/Exporter/;
our @EXPORT = qw/
    set_fake_status_moderate
    validate_create_sandbox_user
    create_sandbox_user
    create_test_data
    get_current_sandbox_user_state
    drop_sandbox_user
    get_fake_master_report_stat
    get_pages_for_fake_stat
/;

use utf8;

our $SANDBOX_MANAGER_UID = 129480072;
our $PHRASE_ID_FACTOR = 15;
our $TEST_AGENCY_NAME = 'Sandbox agency';
our $TEST_MANAGER_NAME = 'Sandbox Manager';
our $DEFAULT_OVERDRAFT = 300; #уе

our $OPERATOR_UID = 1;

# объект Plack::Request
our $plack_request;

=head2 set_fake_status_moderate

    Выставляет статус модерации для кампании и баннеров.
        status => [Yes, Sent]
    Если передан массив bids или cids, обновляет только их

=cut

sub set_fake_status_moderate($$;$$)
{
    my ($rbac, $status, $bids, $cids) = @_;


    my %add_where_bids_sql = ();
    my %add_where_pids_sql = ();
    my %add_where_cids_sql = ();

    $add_where_bids_sql{'b.bid'} = [@$bids] if $bids && scalar @$bids;
    $add_where_pids_sql{'pid'} = get_pids(bid => $bids) if $bids && scalar @$bids;
    $add_where_cids_sql{'c.cid'} = [@$cids] if $cids && scalar @$cids;

    if ($status eq 'Sent') {
        do_update_table(PPC, 'campaigns c', { statusModerate => $status }, where => { %add_where_cids_sql, statusModerate => 'Ready' });
        do_update_table(PPC, 'banners b', { statusModerate => $status }, where => { %add_where_bids_sql, statusModerate => 'Ready' });
        do_update_table(PPC, 'banners b', { statusSitelinksModerate => $status }, where => { %add_where_bids_sql, statusSitelinksModerate => 'Ready' });
        do_update_table(PPC, 'banners b', { phoneflag => $status }, where => { %add_where_bids_sql, phoneflag => 'Ready' });
        do_update_table(PPC, 'phrases', { statusModerate => $status }, where => { %add_where_pids_sql, statusModerate => 'Ready' });
    } elsif ($status eq 'Yes') {
        do_update_table(PPC, 'banners b', { statusModerate => $status, statusPostModerate => $status }, where => { %add_where_bids_sql, statusModerate => 'Sent' });
        do_update_table(PPC, 'phrases', { statusModerate => $status, statusPostModerate => $status }, where => { %add_where_pids_sql, statusModerate => 'Sent' });
        do_update_table(PPC, 'bids', { statusModerate => $status }, where => { %add_where_pids_sql });

        do_update_table(PPC, 'banners b', { statusSitelinksModerate => $status }, where => { %add_where_bids_sql, statusSitelinksModerate => 'Sent' });
        do_update_table(PPC, 'banners b', { phoneflag => $status }, where => { %add_where_bids_sql, phoneflag => 'Sent' });

        foreach my $cid (@$cids) {

            db_update_campaign_statusModerate($cid);
        }

        my $banners_info = get_all_sql(PPC, ["select b.bid, c.uid, b.vcard_id, b.sitelinks_set_id, b.statusModerate, c.cid, u.ClientID, b.pid
                                            from banners b
                                       left join phrases p using (pid)
                                       left join campaigns c ON p.cid = c.cid
                                       left join users u ON u.uid = c.uid ", where => \%add_where_bids_sql]);
        my %mailvars;
        ## no critic (Freenode::DollarAB)
        foreach my $b (@$banners_info) {
            $mailvars{$b->{cid}}{cid} = $b->{cid};
            $mailvars{$b->{cid}}{ClientID} = $b->{ClientID};
            $mailvars{$b->{cid}}{uid} = $b->{uid};
            $mailvars{$b->{cid}}{pid} = $b->{pid};
            $mailvars{$b->{cid}}{type} = 'text';
            $mailvars{$b->{cid}}{stat} = {accepted => 1};
            $mailvars{$b->{cid}}{banners_count}++;

            my $banner = {  bid => $b->{bid},
                            statusModerate => $b->{statusModerate},
                            cid => $b->{cid},
                            phrases => {statusModerate => 'Yes'},
                            is_accepted => 1
                         };
            if ($b->{vcard_id}) {
                $banner->{contactinfo} = {statusModerate => 'Yes'};
            }
            if ($b->{sitelinks_set_id}) {
                $banner->{sitelinks_set} = {statusModerate => 'Yes'};
            }

            push @{$mailvars{$b->{cid}}{banners}}, $banner;
        }

        foreach my $cid (keys %mailvars) {
            add_notification($rbac, 'moderate_result', $mailvars{$cid});
        }
    }
}

=head2 validate_create_sandbox_user

    Валидация входных данных для запроса на создание пользователя в песочнице

=cut

sub validate_create_sandbox_user {
    my $params = shift;

    if ($params->{uid} !~ /^\d+$/) {
        return "uid $params->{uid} is incorrect";
    }

    my $available_type = { client => 1, agency => 1 };
    $available_type->{manager} = 1 if !is_production();
    return "type filled incorrectly" unless $available_type->{ $params->{type} };

    if ( any { ! defined $params->{$_} || length($params->{$_}) == 0 } qw/login email/  ) {
        return 'Not all fields specified';
    }

    if ( !defined $params->{currency} || !Currencies::is_valid_currency($params->{currency}) ) {
        return 'Invalid currency';
    }

    return undef;
}

=head2 create_sandbox_user

    Добавляет пользователя в фэйковый блэкбокс, баланс, RBAC и базу Директа

=cut

sub create_sandbox_user {
    my ( $rbac, $params ) = @_;

    return undef if rbac_who_is($rbac, $params->{uid}) ne 'empty';

    if (!get_login(uid => $params->{uid})) {

        my $res = do_sql(FAKEBLACKBOX, "INSERT INTO users
                            (`uid`, `login`, `accounts.login.uid`, `account_info.email.uid`, `account_info.fio.uid`)
                            VALUES (?, ?, ?, ?, ?)",
                            $params->{uid}, $params->{login}, $params->{login}, $params->{email}, $params->{fio} );

        my $vars = { UID => $SANDBOX_MANAGER_UID,
                     name => $params->{fio},
                     email => $params->{email},
                     initial_country => $geo_regions::RUS,
                     login => $params->{login},
                   };

        my $currency = $params->{currency} || 'YND_FIXED';
        $vars->{initial_currency} = $currency if ($currency ne 'YND_FIXED');

        if ($params->{type} eq 'client') {

            create_update_user( $params->{uid}, $vars );

            my $client_id = _client_id_by_uid($params->{uid});

            if (rbac_create_client($rbac, $params->{uid}, 'commit_after_create')) {
                return 'Error creating client in rbac';
            }

            create_update_user( $params->{uid}, { ClientID => $client_id, allow_create_subclients => 'Yes', api_allow_finance_operations => 'Yes', role => 'client'} );


            # добавляем пользователю овердрафта, DEFAULT_OVERDRAFT но в валюте клиента
            my $overdraft_amount = convert_currency($DEFAULT_OVERDRAFT, 'YND_FIXED', $currency, with_nds => 1);
            do_insert_into_table(PPC(ClientID => $client_id), 'clients_options', {ClientID => $client_id, overdraft_lim => $overdraft_amount}, on_duplicate_key_update => 1, key => 'ClientID');

        } elsif ($params->{type} eq 'agency') {

            $vars->{name} = $TEST_AGENCY_NAME unless $vars->{name};

            create_update_user( $params->{uid}, $vars );
            my $client_id = _client_id_by_uid($params->{uid});

            if (rbac_create_agency($rbac, $SANDBOX_MANAGER_UID, $params->{uid}, $client_id) ) {
                return 'Error creating client in rbac';
            }

            my $user_params = { ClientID => $client_id, allow_create_subclients => 'Yes', api_allow_finance_operations => 'Yes', UID => $SANDBOX_MANAGER_UID, };
            $user_params->{initial_currency} = $params->{currency} if ($params->{currency} ne 'YND_FIXED');
            create_update_user( $params->{uid}, $user_params );
            create_update_client({
                    client_data => {
                            ClientID => $client_id,
                            role => 'agency',
                            name => $params->{fio} || $TEST_AGENCY_NAME,
                            agency_status => 'SA',
                            primary_manager_uid => $SANDBOX_MANAGER_UID,
                    }
            });
            my $agency_options = {
                ClientID => $client_id,
                allow_clients_without_wallet => 1,
                default_clients_with_wallet => 1,
            };
            do_insert_into_table(PPC(ClientID => $client_id), 'agency_options', $agency_options, ignore => 1);
            if ($params->{currency} eq "YND_FIXED") {
                Client::CurrencyTeaserData::fetch_client_multicurrency_teaser_data($client_id);
            }
        } elsif ($params->{type} eq 'manager' && !is_production()) {
            $vars->{name} = $TEST_MANAGER_NAME unless $vars->{name};

            create_update_user( $params->{uid}, $vars );

            if (rbac_create_manager($rbac, $params->{uid}) ) {
                return 'Error creating client in rbac';
            }

            $vars->{role} = 'manager';
            create_update_user( $params->{uid}, $vars);
        }
        get_new_master_token($params->{uid});

    } else {
        return 'LOGIN_EXISTS';
    }

    return undef;
}

{

# параметры для создания тестового окружения
my $SANDBOX_CAMPS_COUNT = 3; # количество кампаний на клиента
my $SANDBOX_BANNERS_IN_CAMP = 5; # количество баннеров в каждой кампании
my $SANDBOX_TEST_SUBCLIENTS_COUNT = 3; # количество субклиентов
my $TEST_MONEY_ON_CAMP = 10_000; # количество денег, которые кладутся на кампанию в валюте кампании; поднято на порядок из-за тенге
my $PAY_CONTRACT_ID = '11111/00'; # тестовый договор, по которому кладутся деньги

my @first_names = qw/Batman Spiderman Superman Halk Ironman Aquaman Catwoman Blade Elektra Hellboy Robin Megamind/;
my @second_names = qw/Johnes Smith Charles Brown Black White Payne Franks Rambo Michaels Stone Williams/;

=head2 create_test_data

    Инициализация тестовых данных для агентства или клиента

=cut

sub create_test_data {
    my ($rbac, $params) = @_;

    my $self = {'operator_login' => $params->{login}, 'uid' => $params->{uid}};
    $self->{locale} = 'en';
    $self->{plack_request} = $plack_request;
    $self = api_initialize($self);
    $self->{api_version} = 4;
    $self->{api_version_full} = '4.5';

    my $currency = $params->{currency};

    if ($params->{type} eq 'client') {
        my $campaign_client_id = _client_id_by_uid($params->{uid}); # ClientID на котором будет хранится кампания
        _create_test_data_for_user($rbac, $self, $campaign_client_id, $params);
        if ($params->{enable_shared_account}) {
            # -- включаем ОС
            my $enable_res = API::Methods::Finance::EnableSharedAccount(
                # -- self
                $self,
                # -- params
                hash_merge($params, {Login => $params->{login}}),
            );

            return $enable_res->{Errors} if exists $enable_res->{Errors} && scalar @{$enable_res->{Errors}};
        }

    } elsif ($params->{type} eq 'agency') {
        foreach my $num (1..$SANDBOX_TEST_SUBCLIENTS_COUNT) {
            my $new_subclient = API::Methods::Clients::CreateNewSubclient($self, _get_test_subclient_request($params->{login}, $params->{currency}));
            my $new_subclient_uid = get_uid(login => $new_subclient->{Login});
            my $subclient_params = {
                uid => $new_subclient_uid,
                agency_uid => $params->{uid},
                login => $new_subclient->{Login},
                fio => $new_subclient->{FIO},
                email => $new_subclient->{Email},
                currency => $currency,
            };

            _create_test_data_for_user($rbac, $self, $new_subclient->{ClientID}, $subclient_params);
        }
    }
}

sub _client_id_by_uid {
    return get_clientid(uid => $_[0]);
}

sub _create_test_data_for_user {
    my ($rbac, $self, $campaign_client_id, $params) = @_;

    my $currency = $params->{currency};

    my $uid = $params->{uid};
    foreach my $num (1..$SANDBOX_CAMPS_COUNT) {
        my $cid = _create_campaign($rbac, $num, $campaign_client_id, $params);
        if ($cid && $cid =~/\d+/) {
            my $vcard_id = _create_vcard_in_user_campaign($campaign_client_id, $uid, $cid, $params->{email});
            my $adgroups = _create_adgroups_in_campaign($uid, $cid);
            _create_keywords_in_campaign_adgroups($uid, $currency, $cid, $adgroups);
            my $bids = _create_ads_in_campaign($uid, $cid, $adgroups, $vcard_id);

            # модерируем и кладем деньги только на первую кампанию
            if ($num == 1) {
                if ($bids and (ref $bids eq 'ARRAY')) {
                    APIMethods::ModerateBanners($self, {CampaignID => $cid, BannerIDS => $bids});
                    set_fake_status_moderate($rbac, 'Sent', $bids, [$cid]);
                    set_fake_status_moderate($rbac, 'Yes', $bids, [$cid]);

                    my $pay_campaigns_params = {
                        ContractID  => $PAY_CONTRACT_ID,
                        PayMethod   => 'Bank',
                        Payments    => [ {CampaignID => $cid, Sum => $TEST_MONEY_ON_CAMP} ],
                    };
                    if ($currency ne 'YND_FIXED') {
                        $pay_campaigns_params->{Payments}->[0]->{Currency} = $currency;
                    }

                    API::Validate::validate_params($self, 'PayCampaigns', $pay_campaigns_params, not_die_on_no_validate => 1);
                    my $pay_camps_result = API::Methods::Finance::PayCampaigns($self, $pay_campaigns_params);
                }
            }
        }
    }

    return 1;
}

sub _get_test_subclient_request {
    my ($login, $cur) = @_;
    my $new_user_login = get_random_string(length => 16, prefix => "sbx-$login", alphabets => 'wWd');
    my $currency = $cur // 'YND_FIXED';
    return {Login => $new_user_login, Name => _get_rnd_name('name'), Surname => _get_rnd_name('surname'), Currency => $currency};
}

sub _get_rnd_name {

    my $type = shift;

    return $first_names[int(rand(scalar @first_names))] if $type eq 'name';
    return $second_names[int(rand(scalar @second_names))] if $type eq 'surname';
    return '';

}

sub _create_campaign {
    my ($rbac, $num, $campaign_client_id, $params) = @_;
    my $cid = _create_empty_camp($rbac, $campaign_client_id, $params);
    _update_campaign_params($num, $cid, $params);
    return $cid;
}

sub _create_empty_camp {
    my ($rbac, $campaign_client_id, $params) = @_;

    my %camp_options = (
        ClientID => $campaign_client_id,
        client_chief_uid => $params->{uid},

        product_type => 'text',
        type => 'text',

        currency => $params->{currency},
        client_fio => $params->{fio},
        client_email => $params->{email},

        ( exists $params->{agency_uid} ? (agency_uid => $params->{agency_uid}) : () )
    );

    my $error = can_create_camp( %camp_options );
    die "Can\t create empty camp: $error" if $error;

    return create_empty_camp( %camp_options );
}

sub _update_campaign_params {
    my ($num, $cid, $params) = @_;
    my $uid = $params->{uid};
    my $operator_uid = $params->{agency_uid} ? $params->{agency_uid} : $uid;
    my $campaign_model = _get_test_campaign_request($num, $cid, $params);

    my $c = DirectContext->new({
        is_direct    => 1,
        UID          => $operator_uid,
        uid          => $uid,
        login_rights => { is_any_client => 1 },
    });

    save_camp($c, $campaign_model, $uid, is_new_camp => 1, remove_statusEmpty => 1);

    return;
}

sub _get_test_campaign_request {
    my ($num, $cid, $params) = @_;

    my $today = strftime('%Y%m%d', localtime());

    return {
        cid => $cid,
        name => "Test API Sandbox campaign $num",
        start_time => $today . "000000",
        fio => $params->{fio},
        email => $params->{email},
        currency => $params->{currency},
        ( exists $params->{agency_uid} ? ( AgencyUID => $params->{agency_uid}) : () ),
        campaign_minus_words => [
            'keyword1',
            'keyword2',
            'keyword3'
        ],
        ContextLimit => 0,
        ContextPriceCoef => 100,
        autoOptimization => 'No',
        autobudget => 'No',
        broad_match_flag => 1,
        broad_match_limit => 50,
        dontShowYacontext => 'No',
        i_know_strategy_min_price => 1,
        is_search_stop => 0,
        money_warning_value => 20,
        opts => {
            enable_cpc_hold => 1,
            no_extended_geotargeting => 0,
            no_title_substitute => 0
        },
        sendAccNews => 'Yes',
        sendWarn => 'Yes',
        timeTarget => '1IJKLMNPQRSTU2IJKLMNPQRSTU3IJKLMNPQRSTU4IJKLMNPQRSTU5IJKLMNPQRSTU',
        time_target_working_holiday => 1,
        warnPlaceInterval => 15,
    };
}

sub _create_vcard_in_user_campaign {
    my ($client_id, $uid, $campaign_id, $email) = @_;

    my $vcard_data = {
        country => "Russia",
        city => "Moscow",
        contact_email => $email,
        worktime => "0;6;09;00;18;00",
        name => "Sandbox company",
        cid => $campaign_id,
        house => "16",
        street => "1st street",
        phone => "+7#812#123-45-67",
        map_location => {
                x => 1,
                y => 1,
                x1 => 1,
                y1 => 1,
                x2 => 1,
                y2 => 1,
        }
    };
    my $map = check_address_map($vcard_data, {no_metro_kludge => 1, ClientID => $client_id});
    $vcard_data->{address_id} = $map->{aid};
    VCards::create_vcards($uid, [ $vcard_data ]);

    return $vcard_data->{vcard_id};
}

sub _create_adgroups_in_campaign {
    my ($uid, $campaign_id) = @_;

    my $adgroups = [];
    foreach my $num (1..5) {
        push @$adgroups, Direct::Model::AdGroupText->new(
            campaign_id => $campaign_id,
            adgroup_name => "Sandbox adgroup #$num",
            geo => "1",
            minus_words => [qw/minusword1 minusword2 minusword3/],
        );
    }
    my $direct_adgroups = Direct::AdGroups2::Text->new(items => $adgroups);
    $direct_adgroups->create($uid);

    foreach my $adg (@$adgroups) {
        my $update_name = Direct::Model::AdGroupText->new(
            adgroup_name => "Группа №" . $adg->id,
        );
        $adg->merge_with($update_name);
    }
    $direct_adgroups->update;

    return $adgroups;
}

sub _create_keywords_in_campaign_adgroups {
    my ($uid, $currency, $campaign_id, $adgroups) = @_;

    my $keywords = [];
    my $adgroup_num = 1;

    my $min_currency_constant = get_currency_constant($currency, 'MIN_PRICE');

    foreach my $adgroup (@$adgroups) {
        my $adgroup_id = $adgroup->id;
        for my $keyword_num (1..2) {
            my $keyword_ind = "$adgroup_num\.$keyword_num";
            push @$keywords, Direct::Model::Keyword->new(
                adgroup => $adgroup,
                campaign_id => $campaign_id,
                adgroup_id => $adgroup_id,
                text => "test keyword $keyword_ind",
                autobudget_priority => 3, # NORMAL
                price => $min_currency_constant,
                price_context => 0,
            );
        }
        $adgroup_num++;
    }

    local $LogTools::context{uid} = $uid;
    Direct::Keywords->new(items => $keywords)->create();
    return;
}

sub _create_ads_in_campaign {
    my ($uid, $campaign_id, $adgroups, $vcard_id) = @_;

    my $ads = [];
    my $num = 0;
    foreach my $adgroup (@$adgroups) {
        $num++;
        $adgroup->has_show_conditions(1);
        push @$ads, Direct::Model::BannerText->new(
            adgroup => $adgroup,
            adgroup_id => $adgroup->id,
            campaign_id => $campaign_id,
            title => "Test sandbox banner $num",
            body => "Test sandbox banner $num text",
            href => "http://www.yandex.ru",
            domain => "www.yandex.ru",
            is_mobile => 0,
            vcard_id => $vcard_id,
        );
    }

    Direct::Banners::Text->new(items => $ads)->create($uid);
    return [map {$_->id} @$ads];
}

}

=head2 get_current_sandbox_user_state

    Возвращает данные по пользователю песочницы:
        role - роль
        master_token - мастер токен для фин. операций
        api_operation_num - текущее значение счетчика финансовых операций

=cut

sub get_current_sandbox_user_state {
    my ($rbac, $uid) = @_;

    my $result = {};
    $result->{role} = rbac_who_is($rbac, $uid);

    my $client_id = _client_id_by_uid($uid);
    $result->{role} = 'empty' unless $client_id;

    if ($result->{role} =~ /client|agency/) {
        $result = hash_merge $result, get_one_line_sql(PPCDICT, [ 'select master_token from api_finance_tokens', where => {uid => $uid} ]);
        $result->{currency} = get_client_currencies($client_id)->{work_currency};

        if ($result->{role} =~ /client/) {
            my $wallets = get_all_wallet_camps(client_client_id => $client_id);
            my @record = grep {!$_->{'agency_client_id'}} @$wallets;
            $result->{shared_account_enabled} = (scalar @record && $record[0]->{is_enabled})? 1 : 0;
        }
    }

    return $result;
}

=head2 drop_sandbox_user

    Удаляет информацию о пользователе из фэйковых блэкбокса, баланса, RBAC и базы Директа

=cut

sub drop_sandbox_user {
    my ($rbac, $uid, %O) = @_;

    my $role = rbac_who_is($rbac, $uid);

    if ($role =~ /client|empty/) {

        _drop_sandbox_client($rbac, $uid, $uid);

    } elsif ($role eq 'agency') {

        my $subclients_uids = rbac_get_subclients_uids($rbac, $uid);
        foreach my $subclient_uid (@$subclients_uids) {
            _drop_sandbox_client($rbac, $uid, $subclient_uid);
            _drop_sandbox_user_in_bases($rbac, $subclient_uid, 'client');
        }
    } else {
        return 0;
    }

    if (!$O{only_data}) {
        _drop_sandbox_user_in_bases($rbac, $uid, $role);
    }

    return 1;
}

# удаляет клиента
sub _drop_sandbox_client {
    my ($rbac, $UID, $uid) = @_;

    my $rbac_cids = rbac_get_campaigns_for_edit($rbac, $UID, $uid);
    my $camp = get_hash_sql(PPC, ["SELECT cid, type FROM campaigns", where => {uid => $uid}]);

    # вместо того, чтобы лочить потоки - лочим сами кампании, в несколько попыток.
    my %cids_to_lock = map { ($_ => undef) } keys(%$camp);
    my $nosend_par_id = $BS::Export::Queues::SPECIAL_PAR_TYPES{nosend_for_drop_sandbox_client};
    eval {
        retry tries => 6, pauses => [1], sub {
            # пробуем залочить "своим" par-id
            do_mass_insert_sql(PPC, "INSERT INTO bs_export_queue (cid, par_id, camps_num, banners_num, contexts_num, bids_num, prices_num)
                                     VALUES %s ON DUPLICATE KEY UPDATE par_id = IF(par_id IS NULL, $nosend_par_id, par_id)",
                               [ map { [ $_, $nosend_par_id, 0, 0, 0, 0, 0 ]  } keys(%cids_to_lock) ],
                               );

            # проверяем, что смогли залочить
            my $locked_cids = get_one_column_sql(PPC, ['SELECT cid FROM bs_export_queue',
                                                 WHERE => {
                                                    cid => [keys(%cids_to_lock)],
                                                    par_id => $nosend_par_id,
                                                 }]);
            delete @cids_to_lock{ @$locked_cids };
            if (%cids_to_lock) {
                die "can't lock cids: " . join (',', keys %cids_to_lock);
            }
        };
    };
    my $err = $@;

    if (%cids_to_lock) {
        # не смогли все залочить - разлочим и умрем
        do_update_table(PPC, 'bs_export_queue', {par_id => undef}, where => {cid => [keys(%$camp)], par_id => $nosend_par_id});
        die "can't lock all campaigns in bs_export_queue: " . ($err // '');
    }

    foreach my $cid (@$rbac_cids) {
        my $error = rbac_delete_campaign($rbac, $cid, $uid);
        if ($error) {
            warn "rbac error on delete campaign (cid: $cid, code: $error)";
        }
    }

    my @cids;
    foreach my $cid (keys %$camp) {
        if (($camp->{$cid} || 'not text') eq 'text') {
            push @cids, $cid;
        }
    }

    # Удаляем кампании:
    # 1. Делаем кампании максимально пригодными к удалению
    do_update_table(PPC, 'campaigns', {sum => 0, sum_to_pay => 0, sum_last => 0, OrderID => 0, statusBsSynced => 'No'}, where => {cid => [keys %$camp]});

    foreach my $cid (@cids) {
        # 2. Пробуем удалить кампанию по-хорошему
        del_camp_data($cid, $uid);
    }

    my @delete_by_cid = qw/
        camp_payments_info
        campaigns_mobile_content
        campaigns_performance
        campaigns camp_options
        user_campaigns_favorite
        camp_metrika_counters metrika_counters
        camp_promocodes
        bs_export_queue
        bs_export_candidates
        bs_export_specials
        campaigns_deals
        campaigns_internal
        campaign_promoactions
        campaign_permalinks
        campaign_phones
        camp_calltracking_settings
        camp_additional_data
        camp_secondary_options
        subcampaigns
        campaigns_promotions
        camp_order_types
    /;
    # 3. На случай, если кампания не удалилась по-хорошему -- удаляем по-плохому, непосредственно из БД по cid-у
    # скопировано из del_camp_data и дополнено таблицами с очередями
    # NB: могут остаться недоудаленные группы, фразы и т.п., но этим пренебрегаем
    # можно было бы регулярно удалять осиротевшие объекты из всей БД
    # 4. Здесь же удаляем общие счета
    for my $table (@delete_by_cid) {
        do_delete_from_table(PPC, $table, where => { cid => [keys %$camp] });
    }

    Tag::delete_campaign_tags([keys %$camp]);

    # если удаляем агентских субклиентов, отвязываем сначала агентство
    if ($UID != $uid) {
        if (rbac_unbind_agency($rbac, $UID, $uid)) {
            warn "rbac error on unbind client from agency in rbac (uid: $uid)";
        }
    }

    return 1;
}

#удаляет данные о пользователе из rbac, fakebalance, fakeblackbox и базы Директа, сбрасывает мастер-токен
sub _drop_sandbox_user_in_bases {
    my ($rbac, $uid, $role) = @_;

    return unless $uid;

    if ($role eq 'client') {
        my $error_code = eval { rbac_drop_client($rbac, $uid) };
        if ($@ || $error_code) {
            warn "rbac error on delete client from rbac (uid: $uid)";
        }
    } elsif ($role eq 'agency') {
        my $error_code = eval { rbac_drop_user($rbac, $uid, $role) };
        if ($@ || $error_code) {
            warn "rbac error on delete agency from rbac (uid: $uid, error: $error_code)";
        }
    }
    

    my $clid = _client_id_by_uid($uid);
    if ($clid) {
        remove_client_id_association(1, $clid, $uid);
        Client::update_role($clid, 'empty', undef);
    }
    do_delete_from_table(FAKEBALANCE, 'reps', where => {uid => $uid}); # если мы не знаем ClientID, а запись осталась

    my $login = get_login(uid => $uid);

    do_delete_from_table(PPC, 'api_users_units_consumption', where => {uid => $uid});

    do_delete_from_table(PPC, 'users', where => {uid => $uid});
    do_delete_from_table(PPC, 'users_options', where => {uid => $uid});
    do_delete_from_table(PPC, 'users_api_options', where => {uid => $uid});
    do_delete_from_table(PPC, 'internal_users', where => {uid => $uid});

    do_delete_from_table(FAKEBLACKBOX, 'users', where => {uid => $uid});

    if ($clid) {
        do_delete_from_table(FAKEBALANCE, 'clients', where => {ClientID => $clid});
        do_delete_from_table(PPC, 'clients', where => {ClientID => $clid});
        do_delete_from_table(PPC, 'client_firm_country_currency', where => {ClientID => $clid});
        do_delete_from_table(PPC, 'agency_options', where => {ClientID => $clid});
    }

    do_delete_from_table(PPCDICT, 'api_finance_tokens', where => {uid => $uid});

    if ($login) {
        delete_shard(login => $login);
    }
    delete_shard(uid => $uid);

    if ($clid) {
        delete_shard(ClientID => $clid);
    }

    return 1;
}

=head2 _get_fake_raw_stat

    Получить фэйковую статистику для кампании. 
    Возвращает сырую статистику, вычисленную по спец. правилам, в виде массива хешей, с максимальной детализацией,
    а также словарь фраз {PhraseID => "phrase_text"}

=cut

sub _get_fake_raw_stat {
    my ($order_id, $start, $stop, %O) = @_;

    # дата в формате unix_timestamp
    my ($start_date, $end_date)  = map {mysql2unix($_)} ($start, $stop);
    my @dates = ts_get_distinct_dates($start_date, $end_date);
    my $pages = [sort {$a <=> $b} keys %{get_pages_for_fake_stat()}];

    my ($cid, $camp_currency) = get_one_line_array_sql(PPC, 'select cid, IFNULL(currency, "YND_FIXED") from campaigns where OrderID = ?', $order_id);
    my $currency = $O{currency} || $camp_currency;
    my $data = get_all_sql(PPC,  [ 'select b.BannerID, b.bid, p.pid, p.geo, bi.PhraseID, bi.phrase
                                    from banners b join phrases p ON b.pid = p.pid join bids bi ON bi.pid = p.pid',
                                    where => {'p.cid' => $cid, 'bi.statusModerate' => 'Yes'} ]);
    my $cdata = {};
    foreach my $phrase_obj (@$data) {
        $phrase_obj->{phrase} = Yandex::MyGoodWords::process_quoted_phrases($phrase_obj->{phrase});
        $cdata->{$phrase_obj->{BannerID}}{phrases}{$phrase_obj->{PhraseID}} = $phrase_obj;
        $cdata->{$phrase_obj->{BannerID}}{$_} = $phrase_obj->{$_} for qw/geo pid bid/;
    }
    my $have_goals = get_one_field_sql(PPC, 'select 1 from camp_metrika_goals where cid = ?', $cid) || 0;

    my (@result, %phrases_dict);

    # "перечислимые" (enum) ключи статистики, и их возможные значения
    my %simple_dicts = (DEVICE_TYPES => Stat::Tools::simple_dict(\%DEVICE_TYPES),
                        CONNECTION_TYPES => Stat::Tools::simple_dict(\%CONNECTION_TYPES),
                        DETAILED_DEVICE_TYPES => Stat::Tools::simple_dict(\%DETAILED_DEVICE_TYPES),
                        AGES => Stat::Tools::simple_dict(\%AGES),
                        GENDERS => Stat::Tools::simple_dict(\%GENDERS),
                        );

    my %enum_keys = ( TypeID         => [1,2],
                      DeviceType     => [uniq(map { xflatten $_ } values %{$simple_dicts{DEVICE_TYPES}})],
                      ConnectionType => [map { xflatten $simple_dicts{CONNECTION_TYPES}->{$_} } grep {$_ ne 'undefined'} keys %{$simple_dicts{CONNECTION_TYPES}}],
                      DetailedDeviceType => [map { xflatten $simple_dicts{DETAILED_DEVICE_TYPES}->{$_} } grep {$_ ne 'undefined'} keys %{$simple_dicts{DETAILED_DEVICE_TYPES}}],
                      Age            => [xflatten values %{$simple_dicts{AGES}}],
                      Gender         => [xflatten values %{$simple_dicts{GENDERS}}], );
    # во сколько строк (максимум) должна разворачиваться статистика в разрезе по всем перечислимым ключам
    # ограничение нужно для того чтоб уменьшить количество отдаваемой статистики, иначе можем получить миллионы строк
    my $num_of_enum_stat_rows = 10;

    my $num_of_combinations = 1;
    for my $vals (values %enum_keys) {
        my $vals_qty = scalar(xflatten $vals);
        next unless $vals_qty;

        $num_of_combinations *= $vals_qty;
    }
    my $pct_of_enum_stat_rows = min(( $num_of_enum_stat_rows / $num_of_combinations )*100, 100);

    my $enums_iterator = new SandboxCommon::StatKeysIterator(dict => \%enum_keys, key_sets_pct => $pct_of_enum_stat_rows);
    my $MaxHostTime = now()->strftime('%Y%m%d%H%M%S');

    foreach my $BannerID (keys %$cdata) {
        my $geo = [];
        push @$geo, abs($_) foreach ( grep {/\S/} split( /,/, $cdata->{$BannerID}->{geo} ) );

        $cdata->{$BannerID}->{1} = {phrase => $Stat::Const::BROADMATCH_PHRASE};
        foreach my $phrase_obj(values %{$cdata->{$BannerID}{phrases}}) {
            $phrases_dict{$phrase_obj->{PhraseID}} = $phrase_obj->{phrase};

            foreach my $date (@dates) {
                my $pages = _get_pages_list($pages, $phrase_obj->{PhraseID}, $date);
                foreach my $page (@$pages) {
                    foreach my $geo_id (@$geo) {

                        $enums_iterator->reset(key_sets_randomizer => [$date, $page, $geo_id]);
                        while (my $enum_key_set = $enums_iterator->next) {
                            my $d = {};
                            # используем md5 хэш, как устойчивый генератор "случайных" данных
                            my $md5_hash = half_md5hex_hash(md5_hex($date, $page, $geo_id, $enum_key_set->{TypeID}, $enum_key_set->{DeviceType}));
                            $d->{Shows} = int(substr($md5_hash, 0, 3) / 4);
                            $d->{Clicks} = int(substr($md5_hash, 3, 2) / 6);
                            $d->{eShows} = int(substr($md5_hash, 9, 3) / 4);
                            # multicurrency: хорошо бы ограничить минимальную/максимальную ставку в соответствии с валютой
                            my $cpc = max(1, substr($md5_hash, 5, 1) / 2) * 0.01;
                            $cpc *= 1_000_000 if $O{mul_by_10x6};

                            $d->{SessionNum} = int($d->{Clicks} * 0.9 ) || ($d->{Clicks} ? 1 : 0);
                            $d->{SessionDepth} = $d->{SessionNum} * (substr($md5_hash, 6, 1) % 5 + 1);

                            my $session_clicks = $d->{Clicks} - (substr($md5_hash, 7, 1) % 5 == 0 ? 1 : 0);
                            $d->{SessionCost} = round2s($session_clicks * $cpc);

                            my $conversion = $have_goals ? substr($md5_hash, 8, 1) / 10 * 0.2 + 0.4 : 0;
                            $d->{GoalsNum} = int($session_clicks * $conversion);
                            
                            # пишем нули там, где мы пока ничего другого не можем записать
                            $d->{OfferShows} = 0;
                            $d->{Bounces} = 0;
                            $d->{BounceRatio} = 0;
                            $d->{BonusNoVAT} = 0;

                            # Не делаем разбиение по самим целями и стоимость их достижения
                            # возвращаем нули, чтобы стримовая статистика не ломалась
                            $d->{GoalNumsByGoalIDs} = 0;
                            $d->{GoalsPriceByGoalIDs} = 0;
                            
                            # первые позиции, здесь желательно ещё накидать устойчивых случайных значений
                            $d->{FirstPageShows} = min(int(2 / 3 * $d->{Shows} + 1), $d->{Shows});
                            $d->{FirstPageClicks} = min(int(2 / 3 * $d->{Clicks} + 1), $d->{Clicks});
                            $d->{FirstPageSumPosShows} = int($d->{FirstPageShows} * 1.75);
                            $d->{FirstPageSumPosClicks} = int($d->{FirstPageClicks} * 1.25);

                            $d->{Cost} = round2s($d->{Clicks} * $cpc);
                            $d->{CostCur} = round2s(convert_currency($d->{Cost}, 'YND_FIXED', (($currency eq 'YND_FIXED') ? 'RUB' : $currency), with_nds => $O{with_nds} // 1));

                            $d->{TargetType} = ($enum_key_set->{TypeID} > 1) ? $Stat::Const::CONTEXT_TARGET_TYPE : 0;

                            push @result, {BannerID    => $BannerID,
                                           # для мастера отчетов
                                           bid         => $cdata->{$BannerID}->{bid},
                                           GroupExportID => $cdata->{$BannerID}->{pid},
                                           OrderID     => $order_id,
                                           IsImage     => 0,
                                           StatisticRegionID => $geo_id,
                                           SessionNumLimited => $d->{SessionNum},
                                           ##
                                           PhraseID    => $phrase_obj->{PhraseID},
                                           ContextType => ($phrase_obj->{PhraseID} == 1)? $Stat::Const::CONTEXT_TYPE_BROADMATCH : 1,
                                           PageID      => $page,
                                           TargetType  => ($enum_key_set->{TypeID} > 1) ? $Stat::Const::CONTEXT_TARGET_TYPE : 0,
                                           UpdateTime  => $date,
                                           RegionID    => $geo_id,
                                           %$enum_key_set,
                                           MaxHostTime => $MaxHostTime,
                                           %$d, };
                        }
                    }
                }
            }
        }
    }

    return \@result, \%phrases_dict;
}

=head2 get_fake_master_report_stat

    Получить фэйковую статистику для кампании, в формате мастера отчетов (хеш, не сериализованный в json).
    Входные параметры:
        $params - хеш с параметрами, которые понимает ручка БК-шного мастера отчетов

=cut

sub get_fake_master_report_stat {
    my $params = shift;

    die "Fake stats available only for single OrderID by one request" if @{$params->{order_ids}} > 1;
    
    my ($stat_raw_data, $phrases_dict) = _get_fake_raw_stat($params->{order_ids}->[0], $params->{date_from}, $params->{date_to}, 
                                                            mul_by_10x6 => 1,
                                                            with_nds => $params->{with_vat},
                                                            currency => $params->{currency},);

    # применяем к данным маппинги
    for my $field (keys %{$params->{mapping} // {}}) {
        my $m = $params->{mapping}->{$field};
        for my $row (@$stat_raw_data) {
            $row->{$field} = $m->{map}->{$row->{$m->{by}} // ''} // $m->{default} // $row->{$m->{by}};
        }
    }

    # если группировка не по дням - заменяем UpdateTime не дату, соответствующую периоду группировки
    if (($params->{group_by_date} // 'none') ne 'day') {
        my %date_period_cache = ();
        for my $row (@$stat_raw_data) {
            $row->{UpdateTime} = $params->{date_from};
            if (($params->{group_by_date} // 'none') ne 'none') {
                unless ($date_period_cache{$row->{UpdateTime}}) {
                    ($date_period_cache{$row->{UpdateTime}}, undef) = Stat::Tools::get_date_subperiod($row->{UpdateTime}, $params->{group_by_date}, $params->{date_from}, $params->{date_to});
                    $date_period_cache{$row->{UpdateTime}} =~ s/\-//g;
                }
                $row->{UpdateTime} =~ $date_period_cache{$row->{UpdateTime}};
            }
        }
    }
    if ($params->{group_by_date} && $params->{group_by_date} ne 'none') {
        @{$params->{group_by}} = uniq @{$params->{group_by}}, 'UpdateTime';
    }

    # NB: фильтры не применяем (можно реализовать если будет в этом необходимость)

    # добавляем доп. колонки, в зависимости от запрошенного группировки
    my $pages_dict;
    my %fields_to_add = ();
    if (any { $_ eq 'PhraseID'} @{$params->{group_by} // []}) {
        $fields_to_add{$_} = 1 for qw/Phrase PhraseType/;
    }
    if (any { $_->{field} eq 'RegionName'} @{$params->{order_by} // []}) {
        $fields_to_add{RegionName} = 1;
    }
    if (any { $_->{field} eq 'PageSortName'} @{$params->{order_by} // []}) {
        $fields_to_add{PageSortName} = 1;
        $pages_dict = get_pages_for_fake_stat();
    }

    if (keys %fields_to_add) {
        my $regions_cache = {};
        for my $row (@$stat_raw_data) {
            if ($fields_to_add{Phrase}) {
                $row->{Phrase} = $phrases_dict->{$row->{PhraseID}} // '';
            }
            if ($fields_to_add{PhraseType}) {
                $row->{PhraseType} = 0;
            }
            if ($fields_to_add{RegionName}) {
                $row->{RegionName} = $regions_cache->{$row->{RegionID}} //= Stat::Tools::get_region_info($row->{RegionID}, 'region')->{region_name};
            }
            if ($fields_to_add{PageSortName}) {
                my $p = $pages_dict->{$row->{PageID}} // {};
                $row->{PageSortName} = join('', map { $p->{$_} // '' } qw/sorting name PageID/);
            }
        }
    }

    # группируем и сортируем
    my @countable_fields = qw/
        Shows Clicks eShows CostCur BonusNoVAT
        FirstPageShows FirstPageSumPosShows FirstPageClicks FirstPageSumPosClicks 
        SessionNum SessionNumLimited SessionDepth GoalsNum GoalsIncome Bounces BounceRatio
        PrGoodMultiGoal PrGoodMultiGoalCPA PrGoodMultiGoalConversionRate AvgTimeToConversion GoalsProfit
    /;

    my @targettype_suffixes = qw/_search _context/;
    my %rename_report_master2raw_fields = (PageGroupID => 'PageID',
                                           ( map { ("Cost$_" => "CostCur$_") } ('', @targettype_suffixes) ),);
    my %rename_raw2report_master_fields = reverse %rename_report_master2raw_fields;


    if (ref($params->{countable_fields_by_targettype}) && @{$params->{countable_fields_by_targettype}}) {
        for my $row (@$stat_raw_data) {
            my $main_suf = $row->{TargetType} == $Stat::Const::CONTEXT_TARGET_TYPE ? '_context' : '_search';
            for my $field (map { $rename_report_master2raw_fields{$_} // $_ } @{$params->{countable_fields_by_targettype}}) {
                for my $suf (qw/_context _search/) {
                    $row->{$field.$suf} = $suf eq $main_suf ? $row->{$field} : 0;
                }
            }
        }
        for my $field (map { $rename_report_master2raw_fields{$_} // $_ } @{$params->{countable_fields_by_targettype}}) {
            for my $suf (qw/_context _search/) {
                push @countable_fields, $field.$suf;
            }
        }
    }
    
    my $ready_stat = overshard group => [map { $rename_report_master2raw_fields{$_} // $_ } @{$params->{group_by} // []}],
                               sum => \@countable_fields,
                               order => [map { (($_->{dir} // 'asc') eq 'desc' ? '-' : '') . $_->{field} } @{$params->{order_by} // []}],
                               $stat_raw_data;

    $stat_raw_data = undef;

    my $total_stat = { map { $_ => 0 } @countable_fields };
    if (!$params->{without_totals} && @$ready_stat) {
        $total_stat = overshard(group => 1,
                                sum => \@countable_fields,
                                $ready_stat)->[0];
    }

    my @header = @{$params->{group_by} // []};
    push @header, grep { $fields_to_add{$_} } qw/Phrase PhraseType/;
    push @header, @countable_fields;

    my @result_stat = ();
    my @header_raw_fields = map { $rename_report_master2raw_fields{$_} // $_} @header;
    for my $row (@$ready_stat) {
        push @result_stat, [ @{$row}{@header_raw_fields} ];
    }

    my $result_total_stat = hash_kmap { return $rename_raw2report_master_fields{$_} // $_ } hash_cut($total_stat, @countable_fields);
    @header = map { $rename_raw2report_master_fields{$_} // $_ } @header;

    return {
                status => 0,
                stat_time => now()->strftime('%Y%m%d%H%M%S'),
                header => \@header,
                data => \@result_stat,
                totals => $result_total_stat,
                total_rows => scalar(@result_stat),
            };
}


=head2 get_pages_for_fake_stat

    Возвращает первые 255 площадок из таблицы pages

=cut

sub get_pages_for_fake_stat {
    return get_hashes_hash_sql(PPCDICT, 'select PageID, TargetType, name, sorting from pages limit 255');
}

sub _get_pages_list {

    my ($pages, @in) = @_;

    # используем md5 хэш, как устойчивый генератор "случайных" данных
    my $str = md5_hex(@in);
    my $pages_num = int(oct("0x".substr($str, 0, 2))/16);

    # всегда добавляем площадку поиск Яндекса
    my @result = (1);

    my $offset = 0;

    while ($offset < length($str)) {
        my $num = substr($str, $offset, 2);
        my $id = min (scalar @$pages - 1, oct("0x".$num));
        push @result, $pages->[$id];
        $offset += 2;
    }

    return [uniq @result];
}

package SandboxCommon::StatKeysIterator;

=head1 NAME

    SandboxCommon::StatKeysIterator

=head1 DESCRIPTION

    итератор по словарю ключей статистики вида:
        {key1 => [value1, value2],
         key2 => [value3, value4],}
    позволяет итерироваться по комбинациям значений ключей вида:
        {key1 => value1, key2 => value3},
        {key1 => value1, key2 => value4},
        ...
    позволяет псевдослучайно (значения-рандомизаторы для инициализации можно задать) отбирать только заданную часть комбинаций ключей (задается в процентах)

=cut

use warnings;
use strict;

use List::Util qw/min max/;
use Digest::MD5 qw/md5_hex/;

use Yandex::HashUtils qw/hash_copy/;
use Yandex::ListUtils qw/xflatten/;

use HashingTools;

=head2 new(dict => {}, key_sets_pct => 30, key_sets_filter_randomizer => [12,333,44443])

    Конструктор класса SandboxCommon::StatKeysIterator
    Возможные параметры:
        dict => {k1 => [v1,v2], ...} - перечень ключей и их возможных значений, по которому нужно итерироваться (по всем вариантам комбинаций значений)
        key_sets_pct => 20 - доля комбинаций ключей по которым нужно проитерироваться, в процентах (по-умолчанию 100%)
        key_sets_randomizer => [12,333] - константы для инициализации псевдорандомизатора выбора доли комбинаци участвующих в итерировании

=cut

sub new {
    my ($class, %params) = @_;

    my $self = {dict => $params{dict} // {}};

    bless $self, $class;
    $self->_init();
    $self->reset( key_sets_pct => $params{key_sets_pct},
                  key_sets_randomizer => $params{key_sets_randomizer}, );
    return $self;
}

=head2 _init

    инициализируем внутренние списки/переменные для дальнейшего использования при итерировании

=cut

sub _init {
    my $self = shift;

    my @combs = ();
    my @keys = sort keys %{$self->{dict}};
    for my $key_idx (0 .. $#keys) {
        my $key = $keys[$key_idx];
        my @vals = xflatten $self->{dict}->{$key};
        if (@combs) {
            for my $i (0 .. $#combs) {
                for my $val_idx (0 .. $#vals) {
                    if ($val_idx == 0) {
                        $combs[$i]->{$key} = $vals[$val_idx];
                    } else {
                        my $new_comb = hash_copy {}, $combs[$i], @keys[0 .. $key_idx-1];
                        $new_comb->{$key} = $vals[$val_idx];
                        push @combs, $new_comb;
                    }
                }
            }
        } else {
            for my $val (@vals) {
                push @combs, {$key => $val};
            }
        }
    }

    $self->{_all_combinations} = \@combs;
}

=head2 reset

    сбрасываем состояние итератора в начальное (с тем же словарем)

    взможные входные параметры:
        key_sets_pct => 20 - доля комбинаций ключей по которым нужно проитерироваться, в процентах (по-умолчанию 100%)
        key_sets_randomizer => [12,333] - константы для инициализации псевдорандомизатора выбора доли комбинаци участвующих в итерировании
    если какой-то из параметров не задан - используется значение которое было задано при создании итератора

=cut

sub reset {
    my ($self, %params) = @_;
    if (exists $params{key_sets_pct}) {
        $self->{key_sets_pct} = min(max(0, $params{key_sets_pct} // 100), 100);
        $self->{_key_sets_qty} = $self->{key_sets_pct} == 100 
                                        ? scalar(@{$self->{_all_combinations}})
                                        : int(scalar(@{$self->{_all_combinations}}) * $self->{key_sets_pct} / 100);
        $self->{_key_sets_randomizer_digits} = int(log(scalar @{$self->{_all_combinations}}) / log(10)) || 1;
    }

    if (exists $params{key_sets_randomizer}) {
        $self->{key_sets_randomizer} = $params{key_sets_randomizer};
    }
    $self->{_key_sets_randomizer_str} = half_md5hex_hash(md5_hex( grep {defined $_ } xflatten($self->{key_sets_randomizer})));

    $self->{_free_combinations} = [ @{$self->{_all_combinations}} ];
    $self->{_taken_combinations_qty} = 0;
    $self->{_current_combination_idx} = 0;
}

=head2 next

    возвращает следующий (в соответствии с правилами псевдорандомизации) набор ключей

=cut

sub next {
    my $self = shift;

    if ($self->{_taken_combinations_qty} >= $self->{_key_sets_qty} || !@{$self->{_free_combinations}} ) {
        return undef;
    }

    # максимальное число "промахов" (попаданий в уже занятые комбинации)
    # при превышении чистим массив с доступными комбинациями
    # нужно для уменьшения количества копирований больших частей массива доступных комбинаций, при удалении использованной комбинации
    my $max_missed_tries = 2;
    while (1) {
        my $shift_size = substr($self->{_key_sets_randomizer_str}, 0, $self->{_key_sets_randomizer_digits}) || 10;
        my $first_digit = substr($self->{_key_sets_randomizer_str}, 0, 1, '');
        $self->{_key_sets_randomizer_str} .= $first_digit;
        $self->{_current_combination_idx} = ($self->{_current_combination_idx} + $shift_size) % scalar(@{$self->{_free_combinations}});

        if (my $next_key_set = $self->{_free_combinations}->[$self->{_current_combination_idx}]) {
            $self->{_free_combinations}->[$self->{_current_combination_idx}] = undef;
            $self->{_taken_combinations_qty} ++;
            return $next_key_set;
        } else {
            $max_missed_tries--;
            unless ($max_missed_tries) {
                @{$self->{_free_combinations}} = grep { $_ } @{$self->{_free_combinations}};
            }
            return undef unless @{$self->{_free_combinations}};
        }
    }
}

1;
