package SearchObjects;

# $Id$

=head1 NAME
    
    Search

=head1 DESCRIPTION

    Поиск всякого, код перемещен из DoCmd

=cut

use strict;
use warnings;

use List::MoreUtils qw/uniq/;
use Yandex::Clone qw/yclone/;

use Yandex::HashUtils;
use Yandex::ListUtils;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Overshard;
use Yandex::I18n;

use Settings;
use TextTools;
use RBACElementary;
use Rbac ':const';
use RBACDirect;
use User;
use Client;
use ServicedClient ();
use Campaign::Types qw/get_camp_kind_types get_camp_kind_types_and/;

our @ISA = qw(Exporter);
our @EXPORT = qw(
    search_clients
);

use utf8;

=head2

options:
          is_direct
          uids_only

=cut

sub search_clients {
    my ($rbac, $options, $query) = @_;

    my $result = {};
    $result->{listbylogin} = defined $query->{listbylogin} ? normalize_login($query->{listbylogin}) : '';

    my $camp_type = $options->{is_direct} ? get_camp_kind_types_and('web_edit_base', 'with_currency') : get_camp_kind_types('media');
    my $media_type_sql = 'c.type in (' . join(",", map {sql_quote($_)} @$camp_type) . ')';

    my ($sql_where, $sql_where_ag) = ({}, {});

    if (defined $query->{listbyclientid}) {
        $sql_where->{'u.ClientID'} = $query->{listbyclientid};
    }

    if (defined $query->{listbylogin}) {
        if ($query->{login_match} && $query->{login_match} eq 'exact') {
            $sql_where->{'login'} = $result->{listbylogin};
        } elsif ($query->{login_match} && $query->{login_match} eq 'contains') {
            $sql_where->{'login__like'} = '%'.$result->{listbylogin}.'%';
        } else {
            # starts_with
            $sql_where->{'login__like'} = $result->{listbylogin} . '%';
        }
    }

    if (defined $query->{listbyuid}) {
        $sql_where->{'u.uid'} = $query->{listbyuid};
    }

    $sql_where_ag = yclone($sql_where);
    if (defined $query->{listbyname}) {
        if ( $query->{name_match} && $query->{name_match} eq 'exact' ) {
            $sql_where->{'FIO'} = $query->{listbyname};
            $sql_where_ag->{_OR} = {'FIO' => $query->{listbyname}, 'cl.name' => $query->{listbyname}};
        } else {
            $sql_where->{'FIO__like'} = "\%$query->{listbyname}\%";
            $sql_where_ag->{_OR} = {'FIO__like' => "\%$query->{listbyname}\%", 'cl.name__like' =>"\%$query->{listbyname}\%"};
        }
    }

    if (defined $query->{manageruidforclient}) {

        # on one manager
        if (ref($query->{manageruidforclient}) eq 'ARRAY') {
            my $managers = get_one_column_sql(PPC(shard => 'all'), ["select distinct uid from campaigns",
                                                    where => {
                                                        statusEmpty => 'No',
                                                        ManagerUID => $query->{manageruidforclient}
                                                    }]) || [];

            if (@$managers) {
                $sql_where->{'uid'} = $managers;
            } else {
                $sql_where->{_TEXT} = 0;
            }
        # on all managers            
        } elsif ($query->{manageruidforclient} eq 'all') {
            my $managers = get_one_column_sql(PPC(shard => 'all'), "select distinct uid
                                                     from campaigns
                                                     where statusEmpty = 'No' and
                                                           ManagerUID is not null and
                                                           ManagerUID > 0")||[];
            if (scalar @$managers >= 0) {
                $sql_where->{'uid'} = $managers;
            }
        }
    }

    if (defined $query->{listbycid} && $options->{uids_only}) {
        $sql_where->{'c.cid'} = $query->{listbycid};
    }

    if (!%$sql_where) {
        $result->{error} = iget("ошибка: не введено данных для поиска");
    } else {
        $sql_where->{login__is_not_null} = 1;
        # Если нас интересуют только uids (для API) - возвращаем только их
        if ($options->{uids_only}) {
            my @shard_info = exists $sql_where->{'c.cid'} ? (cid => $sql_where->{'c.cid'}) : (shard => 'all');
            my $uids = get_one_column_sql(PPC(@shard_info),
                                     ["select uid from users u", (exists $sql_where->{'c.cid'} ? 'join campaigns c using (uid)' : ()), where=> $sql_where]) || [];
            return [nsort @$uids];
        }
        # dclients ...........................
        my $shard = exists($sql_where->{'u.ClientID'}) ? {ClientID => $sql_where->{'u.ClientID'}} : {shard => 'all'};

        # вряд ли реально используются все поля из таблицы users, зафиксирован текущий список
        my $users = get_all_sql(PPC(%$shard),
                                ["SELECT u.uid, u.email, u.valid, u.LastChange, u.fio, u.phone, u.sendNews
                                       , u.sendWarn, u.createtime, u.ClientID, u.login, u.hidden, u.sendAccNews
                                       , u.not_resident, u.statusArch, u.statusBlocked, u.description
                                       , u.lang, u.captcha_freq, u.allowed_ips, u.statusYandexAdv, u.showOnYandexOnly
                                       , c.primary_manager_uid, c.primary_manager_set_by_idm
                                    FROM users u
                                        JOIN clients c ON (u.ClientID = c.ClientID)",
                                   WHERE => $sql_where]);
        my @uids = map {$_->{uid}} @$users;
        my $chief_reps = rbac_get_chief_reps_of_client_reps(\@uids);
        my $who_iss = rbac_multi_who_is($rbac, \@uids);
        my @all_chief_reps = values %$chief_reps;

        my $manager_agency_data = get_all_sql(PPC(uid => \@all_chief_reps), [q/
            SELECT DISTINCT c.uid, c.AgencyUID, c.AgencyID, c.ManagerUID
            FROM campaigns c
         /, WHERE => {
                'c.uid' => SHARD_IDS,
                'c.statusEmpty' => 'No',
                'c.type' => $camp_type,
        }]) || [];
        my (%chief_rep2managers, @manager_uids, %chief_rep2agencies, @agency_clientids, %known_manager_uids_by_chief_rep);
        for my $row (@$manager_agency_data) {
            if ($row->{ManagerUID} && $row->{ManagerUID} > 0) {
                $chief_rep2managers{$row->{uid}} ||= [];
                push @{$chief_rep2managers{$row->{uid}}}, $row->{ManagerUID};
                push @manager_uids, $row->{ManagerUID};
                $known_manager_uids_by_chief_rep{$row->{uid}}->{$row->{ManagerUID}} = 1;
            }
            if ($row->{AgencyUID} && $row->{AgencyUID} > 0) {
                $chief_rep2agencies{$row->{uid}} ||= [];
                push @{$chief_rep2agencies{$row->{uid}}}, $row->{AgencyUID};
                push @agency_clientids, $row->{AgencyID};
            }
        }
        # Если у клиента есть установленный через IDM primary manager и мы еще не нашли его через кампании - 
        # добавим менеджера в chief_rep2managers и manager_uids здесь
        for my $row (@$users) {
            next unless $row->{primary_manager_set_by_idm};
            next if !$row->{primary_manager_uid};

            my $uid = $row->{uid};
            my $manager_uid = $row->{primary_manager_uid};
            next if $known_manager_uids_by_chief_rep{$uid}->{$manager_uid};

            $chief_rep2managers{$uid} //= [];
            push @{$chief_rep2managers{$uid}}, $manager_uid;
            push @manager_uids, $manager_uid;
        }
        undef %known_manager_uids_by_chief_rep;

        my ($chief_reps_of_agencies, @agency_uids);
        if (@agency_clientids) {
            @agency_clientids = uniq @agency_clientids;
            $chief_reps_of_agencies = rbac_get_chief_reps_of_agencies(\@agency_clientids);
            my $agency_ids = Rbac::get_reps_multi(ClientID => \@agency_clientids, role => $ROLE_AGENCY);
            @agency_uids = uniq((map { @$_ } values %$agency_ids), values %$chief_reps_of_agencies);
        }

        # TODO: performance: сделать и вызывать массовую версию rbac_get_manager_of_agency (rbac_get_manager_of_agency_clientid)
        # уже сделана - только заменить и потестировать
        my $agencyuid2manageruid = { map { $_ => rbac_get_manager_of_agency($rbac, $_, $camp_type->[0]) } @agency_uids };
        my @agency_manager_uids = values %$agencyuid2manageruid;
        push @manager_uids, @agency_manager_uids;
        @manager_uids = uniq @manager_uids;

        # TODO: performance: сделать и вызывать массовую версию get_user_data (mass_get_user_data)
        my $managers_data = get_hashes_hash_sql(PPC(uid => \@manager_uids), [q/
            SELECT u.uid
                 , u.fio
                 , u.email
            FROM users u
         /, WHERE => {
                'u.uid' => SHARD_IDS,
        }]);
        my $agencies_data = get_hashes_hash_sql(PPC(uid => \@agency_uids), [q/
            SELECT u.uid
                 , IFNULL(cl.name, u.fio) AS fio
                 , u.email
                 , u.ClientID
            FROM users u
            LEFT JOIN clients cl ON u.ClientID = cl.ClientID
         /, WHERE => {
                'u.uid' => SHARD_IDS,
        }]);

        my $uid2camp_counts = get_hashes_hash_sql(PPC(uid => \@all_chief_reps), [qq/
            SELECT c.uid
                 , COUNT(IF($media_type_sql, 1, NULL)) AS campcount
                 , COUNT(IF(c.type = 'geo',  1, NULL)) AS geo_campcount
                 , COUNT(IF(c.type != 'geo', 1, NULL)) AS all_campcount
            FROM campaigns c
         /, WHERE => {
                'c.uid' => SHARD_IDS,
                'c.statusEmpty' => 'No',
        }, q/
            GROUP BY c.uid
        /]) || {};

        my $fl_uid_by_uid = RBACDirect::mass_get_uid_of_related_freelancer(\@uids);
        my $freelancers = get_hash_sql(PPC(uid => \@uids), [
            q/SELECT u.uid, f.ClientID FROM users u 
                JOIN freelancers f ON (u.ClientID = f.ClientID)
            /,
            WHERE => {'u.uid' => SHARD_IDS}
        ]);
        my $fl_user_info;
        if (keys %$freelancers || keys %$fl_uid_by_uid) {
            $fl_user_info = Primitives::get_users_list_info([uniq @$chief_reps{keys %$freelancers}, values %$fl_uid_by_uid]);
        }

        my $internal_ad_products = get_hashes_hash_sql(PPC(uid => \@uids), [
            q/SELECT u.uid, iap.ClientID, iap.product_name
                FROM users u
                JOIN internal_ad_products iap ON (u.ClientID = iap.ClientID)
            /,
            WHERE => {'u.uid' => SHARD_IDS},
        ]);

        $result->{users_list} = [];
        $result->{freelancers_list} = [];
        $result->{internal_ad_products_list} = [];
        for my $row (@$users) {
            $result->{found_exact} ||= $row->{login} eq ($result->{listbylogin} || '');

            $row->{rbac_role} = $who_iss->{$row->{uid}};
            next if ! $options->{get_all_logins} && $row->{rbac_role} =~ /^(?:super|placer|media|support)$/;

            my $client_chief_uid = $chief_reps->{$row->{uid}} || $row->{uid};
            $row->{is_main_rep} = $client_chief_uid == $row->{uid};

            my $target_list = $freelancers->{$row->{uid}} ? 'freelancers_list' : 'users_list';
            if ($freelancers->{$row->{uid}}){
                # Если user - представитель фрилансера, добавим его не в список "Пользователи", а в список "Фрилансеры"
                # и добавим в main_rep_info данные главного представителя
                $target_list = 'freelancers_list';
                $row->{main_rep_info} = $fl_user_info->{$client_chief_uid};
            }
            elsif($fl_uid_by_uid->{$row->{uid}}) {
                # Если user - представитель сопровождаемого фрилансером клиента - добавим freelancer_info
                $row->{freelancer_info} =  $fl_user_info->{$fl_uid_by_uid->{$row->{uid}}};
            }

            if (my $internal_ad_product_info = $internal_ad_products->{$row->{uid}}) {
                $target_list = 'internal_ad_products_list';
                $row->{product_name} = $internal_ad_product_info->{product_name};
            }

            my $manager_uids = $chief_rep2managers{$client_chief_uid} || [];
            my $managers = [xsort {$_->{fio}} map { $managers_data->{$_} ? $managers_data->{$_} : () } @$manager_uids];

            # Для каждого агентства выводим название, e-mail главного представителя, и менеджера
            my @row_agency_uids = uniq map {
                $agencies_data->{$_} ? $chief_reps_of_agencies->{$agencies_data->{$_}->{ClientID}} : ()
            } @{$chief_rep2agencies{$client_chief_uid} || []};
            $row->{agencies} = [xsort {$_->{fio}} map { $agencies_data->{$_} ? $agencies_data->{$_} : () } @row_agency_uids];

            for my $agency (@{ $row->{agencies} }) {
                my $manager_of_agency_uid = $agencyuid2manageruid->{$agency->{uid}};
                if ($manager_of_agency_uid) {
                    my $manager_info = $managers_data->{$manager_of_agency_uid};
                    $agency->{agency_manager_fio} = $manager_info->{fio};
                    $agency->{agency_manager_email} = $manager_info->{email};
                }
            }

            if ($row->{rbac_role} eq 'agency') {
                # TODO: performance: сделать и вызывать массовую версию rbac_get_manager_of_agency (rbac_get_manager_of_agency_clientid)
                my $manager_of_agency = rbac_get_manager_of_agency($rbac, $row->{uid}, $camp_type->[0]);
                if (defined $manager_of_agency) {
                    # TODO: performance: выбирать данные по менеджерам массово
                    $managers = get_all_sql(PPC(uid =>  $manager_of_agency), ["select fio, email from users", where => {uid => SHARD_IDS}]);
                    $managers = overshard("order" => "fio", $managers);
                }
            }
            if (defined $managers) {
                if( $query->{reverse} and ($query->{sort}||'') eq 'managers_FIO') {
                    $row->{managers} = [reverse @$managers];
                }else {
                    $row->{managers} = $managers;
                }
                my $manager = $row->{managers}[0];
                $row->{managers_FIO} = $manager->{fio};
                $row->{managers_email} = $manager->{email};
            }

            # TODO: performance: сделать массовую версию is_client_serviced (mass_is_client_serviced)
            $row->{is_serviced} = ServicedClient::is_client_serviced($row->{ClientID});

            hash_copy $row, $uid2camp_counts->{$client_chief_uid}, qw/campcount geo_campcount all_campcount/;
            $row->{$_} ||= 0 for qw/campcount geo_campcount all_campcount/;

            # если у клиента только гео-кампании, то не хотим его показывать
            unless (!$row->{all_campcount} && $row->{geo_campcount}) {
                push @{$result->{$target_list}}, $row;
            }

            $result->{( $options->{is_direct} ? "text" : "media")."_client_cnt"}++ if $row->{campcount};
            $result->{(!$options->{is_direct} ? "text" : "media")."_client_cnt"}++ if $row->{all_campcount} - $row->{campcount};
        }

        # agencies ...........................
        my $manager_uid = $options->{UID};
        if ($query->{manageruidforclient} =~ m/^\d+$/ && $query->{manageruidforclient} > 0) {
            $manager_uid = $query->{manageruidforclient};
        } else {
            $manager_uid = undef;
        }

        my $ag_uids = $manager_uid ? rbac_get_all_reps_agencies_of_manager($rbac, $manager_uid) : rbac_get_all_agencies($rbac);
        my %ag_uids_hash = map {$_ => 1} @$ag_uids;
        if (@$ag_uids && $ag_uids->[0] =~ /^\d+$/) {

            my $agencies_data = get_all_sql(PPC(uid => $ag_uids),
                                            ["select u.uid, u.email, u.valid, u.LastChange, u.FIO, u.phone, u.sendNews
                                                   , u.sendWarn, u.createtime, u.ClientID, u.login, u.hidden, u.sendAccNews
                                                   , u.not_resident, u.statusArch, u.statusBlocked, u.description
                                                   , u.lang, u.captcha_freq, u.allowed_ips, u.statusYandexAdv, u.showOnYandexOnly
                                                   , cl.name as agency_name
                                                FROM users u
                                                     LEFT JOIN clients cl ON u.ClientID = cl.ClientID",
                                               WHERE => {uid => SHARD_IDS, %$sql_where_ag}
                                        ]);

            my $agencies_client_ids = [uniq map {$_->{ClientID}} @$agencies_data];
            my @agency_uids = uniq map {$_->{uid}} @$agencies_data;
            my %is_agency_chief = @$agencies_client_ids ? reverse(%{rbac_get_chief_reps_of_agencies($agencies_client_ids)}) : ();
            my $agency_managers = rbac_get_all_managers_of_agencies_clientids($rbac, $agencies_client_ids) || {};
            my $agency_data = mass_get_clients_data($agencies_client_ids, [qw/primary_manager_uid primary_bayan_manager_uid/]);
            my $agency_geo_manager_uids = get_hash_sql(PPC(ClientID => $agencies_client_ids), [q/
                SELECT cl.ClientID
                     , cl.primary_geo_manager_uid
                FROM clients cl
             /, WHERE => {
                    'cl.ClientID' => SHARD_IDS,
            }]);
            my $camp_count_data = overshard group => 'AgencyUID', sum => [qw/campcount geo_campcount all_campcount/], get_all_sql(PPC(shard => 'all'), [qq/
                SELECT AgencyUID,
                COUNT(IF($media_type_sql, 1, NULL)) AS campcount,
                COUNT(IF(c.type = 'geo',  1, NULL)) AS geo_campcount,
                COUNT(IF(c.type != 'geo', 1, NULL)) AS all_campcount
                FROM (
                SELECT AgencyUID, c.type
                FROM campaigns c
             /, WHERE => {
                    'c.AgencyUID' => \@agency_uids,
                    'c.statusEmpty' => 'No',
            }, q/
                UNION ALL
                SELECT agency_uid as AgencyUID, c.type
                FROM campaigns c
                JOIN agency_lim_rep_clients alrc USING(ClientID)
             /, WHERE => {
                    'agency_uid' => \@agency_uids,
                    'c.AgencyUID__ne__dont_quote' =>  'agency_uid',
                    'c.statusEmpty' => 'No',
            }, q/
            ) as c
                GROUP BY AgencyUID
            /]);
            my $agencyuid2camp_counts = {map { $_->{AgencyUID} => $_ } @{$camp_count_data || []}};

            $result->{ag_list} = [];
            my $managers_or_agencies_data = get_users_data([uniq map {@$_} values %$agency_managers ], [qw/login fio email/]);
            for my $row (@$agencies_data) {
                $result->{found_exact} ||= $row->{login} eq ($result->{listbylogin}||'');

                my @all_managers_of_agency_clientid = @{ $agency_managers->{ $row->{ClientID} } || [] };
                for my $manager_of_agency (@all_managers_of_agency_clientid) {
                    next if scalar(@all_managers_of_agency_clientid) > 1 && 
                            $manager_of_agency == ($agency_geo_manager_uids->{ $row->{ClientID} } || 0); # без гео-менеджеров
                    # TODO: performance: сделать и вызывать массовую версию get_user_data (mass_get_user_data)
                    my $manager_info =  $managers_or_agencies_data->{$manager_of_agency};

                    my $manager_type_key = $options->{is_direct} ? 'primary_manager_uid' : 'primary_bayan_manager_uid';
                    my $is_main_manager =
                        $agency_data->{$row->{ClientID}}->{$manager_type_key}
                        && $agency_data->{$row->{ClientID}}->{$manager_type_key} == $manager_of_agency
                        ? 1
                        : 0;

                    push @{ $row->{managers_of_agency} }, {
                        managers_login => $manager_info->{login}
                        , managers_FIO => $manager_info->{fio}
                        , managers_email => $manager_info->{email}
                        , is_main_manager => $is_main_manager
                    };
                }

                $row->{agency_name} = $row->{agency_name} || $row->{FIO} || '';
                $row->{is_agency_chief} = $is_agency_chief{ $row->{uid} } ? 1 : 0;

                hash_copy $row, $agencyuid2camp_counts->{$row->{uid}}, qw/campcount geo_campcount all_campcount/;

                # если у агентства только гео-кампании, то покажем его везде
                if (!$row->{all_campcount} || $row->{campcount}) {
                    push @{$result->{ag_list}}, $row;
                }
                $result->{( $options->{is_direct} ? "text" : "media")."_client_cnt"}++ if $row->{campcount};
                $result->{(!$options->{is_direct} ? "text" : "media")."_client_cnt"}++ if defined $row->{all_campcount} && ($row->{all_campcount} - $row->{campcount});
            }

        }

        # delete dublicate users
        @{$result->{users_list}} = grep {! exists $ag_uids_hash{ $_->{uid} }} @{$result->{users_list}};
    }

    return $result;

}

1;
