package ServiceSOAP;

# $Id$

use strict;
use warnings;

use Settings;
use PrimitivesIds;
use Yandex::DBTools;
use Yandex::DBShards;
use Direct::Validation::Keywords qw/base_validate_keywords/;

use Yandex::Log;
use Yandex::HashUtils;
use Yandex::TimeCommon;
use Yandex::Trace;
use Yandex::Validate;
use Property;

use SOAP::Lite;
use Time::Local;
use List::MoreUtils qw(uniq any);

use utf8;


=head2 setAutobudgetShowStatus

    Включение/выключение групп баннеров автобюджетом

    perl -MSOAP::Lite -MDDP -e 'my $x = SOAP::Lite->proxy("http://9144.beta2.direct.yandex.ru/soap")->uri("ServiceSOAP")->setAutobudgetShowStatus({284531093 => 0})->result; p $x'

=cut
sub setAutobudgetShowStatus {
    shift;

    my $log_input = new Yandex::Log(
        log_file_name => "ServiceSOAP_setAutobudgetShowStatus.log",
        date_suf => "%Y%m%d",
        msg_prefix => "[$$]"
    );
    $log_input->out(\@_);

    my $data = shift;
    my $log = new Yandex::Log(
        log_file_name => "ServiceSOAP.log",
        date_suf => "%Y%m%d",
    );
    $log->out({ setAutobudgetShowStatus => $data });
    if ( !keys %$data ) {
        return 1;
    } elsif ( any { !is_valid_id($_) } keys %$data ) {
        $log->die("Incorrect GroupExportID");
    }

    my @all_pids = sort {$a <=> $b} keys %$data;
    foreach_shard pid => \@all_pids, chunk_size => 1_000, sub {
        my ($shard, $pids) = @_;
        my %status_values = map {$_ => $data->{$_} ? 'Yes' : 'No'} @$pids;
        my $case = sql_case('pid', \%status_values, default__dont_quote => 'p.statusAutobudgetShow');

        #записи обновляются только для кампаний на автобюджете или с дневным бюджетом в режиме распределения
        #или если кампания находится под кошельком с дневным бюджетом в режиме распределения
        do_sql(PPC(shard => $shard), [
                   "UPDATE phrases p
                    INNER JOIN campaigns c ON p.cid=c.cid
                     LEFT JOIN campaigns wc ON wc.cid = c.wallet_cid
                    SET p.LastChange=p.LastChange
                         , p.statusAutobudgetShow=$case
                    ", WHERE => {pid => $pids}," 
                    AND (c.autobudget = 'Yes' 
                    OR (c.day_budget > 0 AND c.day_budget_show_mode = 'stretched')
                    OR (wc.cid IS NOT NULL AND wc.day_budget > 0 AND wc.day_budget_show_mode = 'stretched'))"
               ]
            );
    };

    return 1;
}

=head2 setCampDayBudgetLimitStopTime

    SOAP-метод для приёма от БК информации о времени остановки заказов (кампаний) по дневному ограничению бюджета
    На вход получает ссылку на хеш, ключами которого являются идентификаторы заказов (OrderID), 
    а значениями — время остановки кампании в виде 14-значного числа в UTC+4 без пробелов (пример: 20110810192104) 
    в случае остановки показов, либо 0 в случае возобновления показов.

    Протестировать на бете можно как-то так:
    perl -MSOAP::Lite -MDDP -e 'my $x = SOAP::Lite->proxy("https://8706.beta1.direct.yandex.ru/soap")->uri("ServiceSOAP")->setCampDayBudgetLimitStopTime({21082 => 20110826173912, 12345 => 20110101010101})->result; p $x'

=cut

sub setCampDayBudgetLimitStopTime {
    shift;

    my $prop = Property->new('campdaybudgetlimitstoptime_java_writing_enabled');
    return 1 if $prop->get();

    my $profile = Yandex::Trace::new_profile('soap:setCampDayBudgetLimitStopTime');
    my $log = new Yandex::Log(log_file_name => 'setCampDayBudgetLimitStopTime.log', date_suf => "%Y%m%d");

    $log->out(@_);

    my ($data) = @_;

    if ($data && %$data) {
        while (my ($OrderID, $date) = each %$data) {
            $log->die("Bad OrderID '$OrderID'") unless is_valid_id($OrderID);
            # проверяем время остановки. должен быть или 0 (возобновили) или валидная MySQL-дата
            $log->die("Bad stop time '$date' for OrderID = $OrderID") unless defined $date && ($date == 0 || check_mysql_date($date));
        }

        foreach_shard OrderID => [keys %$data], sub {
            my ($shard, $OrderIDs) = @_;
            my $non_default_data = hash_grep { $_ != 0 } hash_copy {}, $data, $OrderIDs;
            my $stop_time_case = sql_case('c.OrderID', $non_default_data, default => 0);
            do_update_table(PPC(shard => $shard), 'camp_options co, campaigns c', 
                {'day_budget_stop_time__dont_quote' => $stop_time_case, 'day_budget_notification_status' => 'Ready'},
                where => {'c.cid__dont_quote' => 'co.cid', 'c.OrderID' => $OrderIDs}
            );

            my $oid2cid = get_orderid2cid(OrderID => $OrderIDs);
            my @data_to_insert;
            while (my ($OrderID, $date) = each %$non_default_data) {
                my $cid = $oid2cid->{$OrderID};
                next unless $cid;
                push @data_to_insert, [$cid, $date];
            }
            do_mass_insert_sql(PPC(shard => $shard), 'insert ignore into camp_day_budget_stop_history (cid, stop_time) values %s'
                        , \@data_to_insert );
        };
    }

    $log->out('DONE');
    return 1;
}

=head2 soapEcho

стандартное echo для тестирования

=cut

sub soapEcho {
    shift;
    return @_;
}

1;

