package ServicedClient;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod
    $Id$
    Модуль для работы с историей сервисируемых клиентов
=cut

use strict;
use base qw/Exporter/;

use Yandex::ScalarUtils;

use DateTime::Format::MySQL;

use Settings;
use Yandex::DBTools;

use utf8;

# проверить, сервисируется ли клиент
sub is_client_serviced {
    my $ClientID = shift;
    return $ClientID && get_one_field_sql(PPC(ClientID => $ClientID), "
                SELECT 1
                  FROM users u
                       JOIN campaigns c ON c.uid = u.uid
                 WHERE u.ClientID = ?
                   AND c.statusEmpty = 'No'
                   AND ifnull(c.ManagerUID, 0) > 0
                 LIMIT 1
                      ", $ClientID);
}

# проверить, сервисируется ли пользователь
# получает uid главного представителя 
sub is_user_serviced($) {
    my $uid = shift;
    return $uid && get_one_field_sql(PPC(uid => $uid), "
                SELECT 1
                  FROM users u
                       JOIN campaigns c ON c.uid = u.uid
                 WHERE u.uid = ?
                   AND c.statusEmpty = 'No'
                   AND ifnull(c.ManagerUID, 0) > 0
                 LIMIT 1
                      ", $uid);
}

=head2 users_has_agency_manager_camps(uids)

    Проверяет у пользователей, наличие агентстких, либо менеджерских кампании

=cut

sub users_has_agency_manager_camps 
{
    my $uids = shift;

    my $res = get_one_column_sql(PPC(uid => $uids), ["
                SELECT distinct uid
                  FROM campaigns
                 ", WHERE => { 
                        "uid" => $uids
                        , "statusEmpty" => 'No'
                 }, " AND ( ifnull(AgencyUID, 0) > 0 or ifnull(ManagerUID, 0) > 0 )"]) || [];

    my %RESULT;
    my $uids_hash = { map { $_ => 1 } @$res };

    map { 
        $RESULT{$_} = defined $uids_hash ? 1 : 0 
    } @$uids;

    return \%RESULT;
}

1;

