package SolomonTools;

=head1 SolomonTools

    Сахар для отправки данных в Solomon

=cut

use Direct::Modern;

use Yandex::HashUtils;

use JavaIntapi::SendMetricsToSolomon;


=head2 send_requests_stat

    Отправить статистику выполнения запроса
    $labels - hashref с метками
    $stat - hashref (interpreted_status => число запросов)

=cut

sub send_requests_stat {
    my ($labels, $stat) = @_;

    my @items;
    for my $status (keys %$stat) {
        push @items, {
            labels => hash_merge({ interpreted_status => $status }, $labels),
            name => "reqs.count",
            type => "RATE",
            long_value => $stat->{$status},
        };
    }

    JavaIntapi::SendMetricsToSolomon->new(items => \@items)->call();
}

=head2 send_advq_semaphores_stat
    
    Отправить отправить статистику использования семафоров advq.
    $host - имя хоста, использующего семафор
    $state - состояние семафора
        acquired - установлен
        failed   - не удалось установить, т.к. все семафоры заняты
        unknown  - установка семафора вернула неопределенный статус (недоступен memcache или иные внешние проблемы) 

=cut

sub send_advq_semaphores_stat {
    my ($host, $state) = @_;

    JavaIntapi::SendMetricsToSolomon->new(items => [{
        name => 'semaphores.count',
        long_value => 1,
        labels => {
            external_system => 'advq',
            host => $host,
            state => $state,
        },
    }])->call();
}


=head2 guess_status_by_code

    Определить успешность ответа по коду HTTP-статуса

=cut

sub guess_status_by_code {
    my ($code) = @_;
    if ($code =~ /^5/) {
        return 'server_error';
    } elsif ($code =~ /^4/) {
        return 'client_error';
    } else {
        return 'unknown';
    }
}

1;
