package Stat::Const;

=head1 NAME

    Stat::Const

=head1 DESCRIPTION

    "магические" константы в статистике (в основном из БК)

=cut

use warnings;
use strict;

use utf8;

use Yandex::I18n;
use Yandex::ListUtils qw/xminus/;
use Yandex::DateTime;

use API::Campaign::Const qw/ %CAMPAIGN_TYPE_MAP /;

use base qw/Exporter/;
our @EXPORT = qw/
    $BEGIN_OF_TIME_FOR_STAT
    BS_STAT_START_DATE/;
my @_EXPORT_BASE = (@EXPORT,
    qw/
    $CONTEXT_TYPE_PHRASE
    $CONTEXT_TYPE_RET
    $CONTEXT_TYPE_DYNAMIC
    $CONTEXT_TYPE_PERFORMANCE
    $CONTEXT_TYPE_BROADMATCH
    $CONTEXT_TYPE_BM_SYNONYM
    $CONTEXT_TYPE_RELEVANCE_MATCH
    @ANY_BROADMATCH_CONTEXT_TYPE
    @ANY_CONTEXT_TYPE
    @ANY_TEXT_CONTEXT_TYPE
    @NOT_TEXT_CONTEXT_TYPE
    $CONTEXT_TARGET_TYPE
    $BROADMATCH_PHRASE_ID
    $BROADMATCH_PHRASE
    %SPECIAL_PHRASES
    $BEGIN_OF_TIME_FOR_STAT
    $BS_METRICA_BORDER_DATE
    $BS_STREAM_AVG_POS_BORDER_DATE
    $BS_DEVICE_TYPE_BORDER_DATE
    $BS_CONNECTION_TYPE_BORDER_DATE
    $BS_DETAILED_DEVICE_TYPE_BORDER_DATE
    $BS_AGE_GENDER_BORDER_DATE
    $BS_BOUNCES_BORDER_DATE
    $BS_EXT_PHRASE_BORDER_DATE
    $BS_SEARCH_QUERIES_BORDER_DATE
    $BS_SEARCH_QUERIES_LAST_DAYS
    $BS_BROADMATCH_TYPE_BORDER_DATE
    $BS_RETARGETING_COEF_BORDER_DATE
    $BS_PRGOODMULTIGOAL_BORDER_DATE
    $BS_AVG_BID_BORDER_DATE
    $BS_TURBO_PAGE_TYPE_BORDER_DATE
    $BS_TARGETING_CATEGORY_BORDER_DATE
    $BS_CORRUPTED_SEARCH_QUERIES_ON_PAGES_DATE
    $BS_AGE_45_54_AND_AGE_55_DATE
    $BROADMATCH_EXT_PHRASE_ID
    $RELEVANCE_MATCH_PHRASE_ID
    $RELEVANCE_MATCH_PHRASE_PLACEHOLDER
    $GOALS_MAX_NUM
    $MULTI_CLIENTS_FILTER_IDS_MAX_NUM
    $MULTI_CLIENTS_CAMPAIGNS_MAX_NUM
    $MCC_MULTI_CLIENTS_FILTER_IDS_MAX_NUM
    $MCC_MULTI_CLIENTS_CAMPAIGNS_MAX_NUM
    $DEFAULT_MOBILE_GOAL_ID
    $DEFAULT_MOBILE_GOAL_ID_WITH_SKAD
    $BS_PROFIT_BORDER_DATE
    $BS_PRISMA_INCOME_GRADE_BORDER_DATE
    APP_INSTALL
/);
my @_EXPORT_ENUMS = qw/
    %DEVICE_TYPES
    %CLICK_PLACES
    %GENDERS
    %AGES
    %DETAILED_DEVICE_TYPES
    %CONNECTION_TYPES
    %CONTEXT_TYPES
    %CRITERION_TYPES
    %CONTEXT_COND_TYPES
    %BROADMATCH_TYPES
    %CAMP_TYPES
    %BANNER_TYPES
    %POSITION_TYPES
    %TARGET_TYPES
    %BS_PHRASE_STATUSES
    %BANNER_IMAGE_TYPES
    %ATTRIBUTION_MODEL_TYPES
    %MOBILE_APP_SPECIAL_GOALS
    %MATCH_TYPES
    %INVENTORY_TYPES
    %BS_TURBO_PAGE_TYPES
    %TARGETING_CATEGORIES
    %PRISMA_INCOME_GRADES
    %REGION_SOURCES
/;
our @EXPORT_OK = ( @_EXPORT_BASE, @_EXPORT_ENUMS);
our %EXPORT_TAGS = (
    'base' => \@_EXPORT_BASE,
    'enums' => \@_EXPORT_ENUMS );

=head2 BS_STAT_START_DATE
    дата, с которой (включительно) клиенту отдаем подробную статистику
=cut

sub BS_STAT_START_DATE {
    return now()->truncate(to => 'month')->subtract(years => 3)->ymd('');
}

# "начало всех времен" для статистики
our $BEGIN_OF_TIME_FOR_STAT = '20000101';
# дата, до которой включительно аналитику нужно забирать из метрики, а не из БК
our $BS_METRICA_BORDER_DATE = '20130331';
# дата, до которой (включительно) в стримовой статистике БК нет данных по средней позиции
our $BS_STREAM_AVG_POS_BORDER_DATE='20141031';
# дата, до которой (включительно) в БК нет разбивки по типам устройств
our $BS_DEVICE_TYPE_BORDER_DATE='20141031';
# дата, до которой (включительно) в статистике БК нет данных по типу связи
our $BS_CONNECTION_TYPE_BORDER_DATE = '20151015';
# дата, до которой (включительно) в статистике БК нет данных по типу ОС
our $BS_DETAILED_DEVICE_TYPE_BORDER_DATE = '20150914';
# дата, до которой (включительно) в статистике БК нет данных по полу и возрасту
our $BS_AGE_GENDER_BORDER_DATE = '20150721';
# дата, до которой (включительно) в статистике БК нет данных по отказам
our $BS_BOUNCES_BORDER_DATE = '20151109';
# дата, до которой (включительно) в статистике БК для мастер отчетов нет полных данных (текстовых расшифровок) по ДРФ
our $BS_EXT_PHRASE_BORDER_DATE = '20160514';
# дата, до которой (включительно) в статистике БК для мастер отчетов нет полных данных (текстовых расшифровок) по поисковым запросам
our $BS_SEARCH_QUERIES_BORDER_DATE = '20160722';
# за сколько последних дней БК отдаст статистику по поисковым запросам
our $BS_SEARCH_QUERIES_LAST_DAYS = 180;
# дата, до которой (включительно) в статистике БК нет данных по типам добавенных фраз
our $BS_BROADMATCH_TYPE_BORDER_DATE = '20160831';
# дата, до которой (включительно) в статистике БК нет данных по сработавшим корректировкам ретаргетинга
our $BS_RETARGETING_COEF_BORDER_DATE = '20150721';
# дата, до которой (включительно) в статистике БК нет данных по умным целям
our $BS_PRGOODMULTIGOAL_BORDER_DATE = '20170713';
# дата, до которой (включительно) в статистике БК нет данных по средней ставке
our $BS_AVG_BID_BORDER_DATE = '20180524';
# дата, до которой (включительно) в статистике БК повреждены данные о поисковых запросах на внешних площадках
our $BS_CORRUPTED_SEARCH_QUERIES_ON_PAGES_DATE = '20170612';
# дата, до которой (включительно) в статистике БК нет данных по срезу турбо-площадке
our $BS_TURBO_PAGE_TYPE_BORDER_DATE = '20200229';

# дата, до которой (включительно) в статистике БК нет данных по срезу категория таргетирования
our $BS_TARGETING_CATEGORY_BORDER_DATE = '20210902';

# дата, до которой (включительно) в статистике БК нет данных по срезу доходов из призмы
our $BS_PRISMA_INCOME_GRADE_BORDER_DATE = '20211018';

# дата начиная с которой в статистике перестает приходить AGE_45 и начинают приходить AGE_45_54 и AGE_55
our $BS_AGE_45_54_AND_AGE_55_DATE = "20180822";
# дата, до которой (включительно) в статистике БК нет данных по прибыли
our $BS_PROFIT_BORDER_DATE = '20160525';
# дата, до которой (включительно) в статистике БК нет данных по видимости показов
our $BS_MRC_VISIBILITY_BORDER_DATE = '20200202';

# стандартное ограничение на количество целей, которое допускается запрашивать
our $GOALS_MAX_NUM = 10;
# внутреннее ограничение на количество целей, которое допускается запрашивать
# используется например в ручке Intapi::CampaignStatistics, где нужно получать статистику по всем целям на кампании
our $GOALS_MAX_NUM_INTERNAL = 50;
our $DEFAULT_MOBILE_GOAL_ID = 4;
our $DEFAULT_MOBILE_GOAL_ID_WITH_SKAD = 10;

# сколько id допускается запрашивать в режиме Мультиклиентности
our $MULTI_CLIENTS_FILTER_IDS_MAX_NUM = 20;
# сколько кампаний допускается запрашивать в режиме Мультиклиентности
our $MULTI_CLIENTS_CAMPAIGNS_MAX_NUM = 2000;

our $MCC_MULTI_CLIENTS_FILTER_IDS_MAX_NUM = 200;
our $MCC_MULTI_CLIENTS_CAMPAIGNS_MAX_NUM = 50000;

# типы фраз в статистике из БК
our $CONTEXT_TYPE_PHRASE = 1;     # фразы
our $CONTEXT_TYPE_RET = 2;        # условие ретаргетинга
our $CONTEXT_TYPE_BROADMATCH = 3; # броадматч
our $CONTEXT_TYPE_AD_SHARD = 4;   # рекламный шард поиска
our $CONTEXT_TYPE_SYNONYM = 5;    # расширенный синонимами поисковый запрос
our $CONTEXT_TYPE_INTENTS = 6;    # интенты
our $CONTEXT_TYPE_DYNAMIC = 7;    # условия нацеливания
our $CONTEXT_TYPE_PERFORMANCE = 8;# фильтры перформанса
our $CONTEXT_TYPE_BM_SYNONYM = 10; # автоматически добавленные фразы-синонимы ("виртуальный" тип, для использования в МОЛ)
our $CONTEXT_TYPE_RELEVANCE_MATCH = 11; # беcфразноый таргетинг

our $CRITERION_TYPE_PHRASE = 100;
our $CRITERION_TYPE_RETARGETING = 200;
our $CRITERION_TYPE_INTEREST = 220;
our $CRITERION_TYPE_REACH_AUDIENCE = 240;
our $CRITERION_TYPE_BROADMATCH = 300;
our $CRITERION_TYPE_WEBPAGE_FILTER = 700;
our $CRITERION_TYPE_FEED_FILTER = 800;
our $CRITERION_TYPE_AUTOTARGETING = 1100;
our @TEXT_CRITERION_TYPES = ($CRITERION_TYPE_PHRASE, $CRITERION_TYPE_BROADMATCH);

# Перечисление значений ContextType, которые мы "маскируем" и представляем как $BROADMATCH_CONTEXT_TYPE
our @ANY_BROADMATCH_CONTEXT_TYPE = ($CONTEXT_TYPE_BROADMATCH, $CONTEXT_TYPE_AD_SHARD, $CONTEXT_TYPE_SYNONYM, $CONTEXT_TYPE_INTENTS);
our @ANY_CONTEXT_TYPE = ($CONTEXT_TYPE_PHRASE, $CONTEXT_TYPE_RET, $CONTEXT_TYPE_DYNAMIC, $CONTEXT_TYPE_PERFORMANCE, $CONTEXT_TYPE_RELEVANCE_MATCH, @ANY_BROADMATCH_CONTEXT_TYPE);
our @ANY_TEXT_CONTEXT_TYPE = ($CONTEXT_TYPE_PHRASE, @ANY_BROADMATCH_CONTEXT_TYPE);
our @ANY_PHRASES_GROUP_BY = ('phrase', 'retargeting', 'dynamic', 'performance_filter');
our @NOT_TEXT_CONTEXT_TYPE = @{ xminus(\@ANY_CONTEXT_TYPE, \@ANY_TEXT_CONTEXT_TYPE) };

# типы фраз во "внутреннем" представлении (мастер отчетов)
our %CONTEXT_TYPES = (phrases => {bs => $CONTEXT_TYPE_PHRASE, api => 'KEYWORD', default => {ord => $CONTEXT_TYPE_PHRASE} },
                      retargeting => {bs => $CONTEXT_TYPE_RET, api => 'AUDIENCE_TARGET', default => {ord => $CONTEXT_TYPE_RET} },
                      dynamic => {bs => $CONTEXT_TYPE_DYNAMIC, api => 'DYNAMIC_TEXT_AD_TARGET', default => {ord => $CONTEXT_TYPE_DYNAMIC} },
                      performance => {bs => $CONTEXT_TYPE_PERFORMANCE, api => 'SMART_BANNER_FILTER', default => {ord => $CONTEXT_TYPE_PERFORMANCE} },
                      synonym => {bs => $CONTEXT_TYPE_BM_SYNONYM, api => 'KEYWORD', default => {ord => $CONTEXT_TYPE_BM_SYNONYM}},
                      'relevance-match' => {bs => $CONTEXT_TYPE_RELEVANCE_MATCH, api => 'AUTOTARGETING', default => {ord => $CONTEXT_TYPE_RELEVANCE_MATCH}},
                      'auto-added-phrases' => {bs => \@ANY_BROADMATCH_CONTEXT_TYPE, api => 'KEYWORD', default => {ord => $CONTEXT_TYPE_BROADMATCH}},
                       );

# типы условий показа
our %CRITERION_TYPES = (
    phrases => {bs => \@TEXT_CRITERION_TYPES, api => 'KEYWORD', default => {ord => $CRITERION_TYPE_PHRASE} },
    retargeting => {bs => $CRITERION_TYPE_RETARGETING, api => 'RETARGETING', default => {ord => $CRITERION_TYPE_RETARGETING} },
    'mobile-content-interest' => {bs => $CRITERION_TYPE_INTEREST, api => 'MOBILE_APP_CATEGORY', default => {ord => $CRITERION_TYPE_INTEREST} },
    'webpage-filter' => {bs => $CRITERION_TYPE_WEBPAGE_FILTER, api => 'WEBPAGE_FILTER', default => {ord => $CRITERION_TYPE_WEBPAGE_FILTER} },
    'feed-filter' => {bs => $CRITERION_TYPE_FEED_FILTER, api => 'FEED_FILTER', default => {ord => $CRITERION_TYPE_FEED_FILTER} },
    'relevance-match' => {bs => $CRITERION_TYPE_AUTOTARGETING, api => 'AUTOTARGETING', default => {ord => $CRITERION_TYPE_AUTOTARGETING}},
    'reach-audience' => {bs => $CRITERION_TYPE_REACH_AUDIENCE, api => 'INTERESTS_AND_DEMOGRAPHICS', default => {ord => $CRITERION_TYPE_REACH_AUDIENCE}},
);

# типы фраз во "внутреннем" представлении, различаются только типы условий показа которые может добавить клиент (мастер отчетов)
our %CONTEXT_COND_TYPES = (
                      phrases => {bs => [$CONTEXT_TYPE_PHRASE, @ANY_BROADMATCH_CONTEXT_TYPE] , api => 'KEYWORD', default => {ord => $CONTEXT_TYPE_PHRASE} },
                      retargeting => {bs => $CONTEXT_TYPE_RET, api => 'AUDIENCE_TARGET', default => {ord => $CONTEXT_TYPE_RET} },
                      dynamic => {bs => $CONTEXT_TYPE_DYNAMIC, api => 'DYNAMIC_TEXT_AD_TARGET', default => {ord => $CONTEXT_TYPE_DYNAMIC} },
                      performance => {bs => $CONTEXT_TYPE_PERFORMANCE, api => 'SMART_BANNER_FILTER', default => {ord => $CONTEXT_TYPE_PERFORMANCE} },
                      'relevance-match' => {bs => $CONTEXT_TYPE_RELEVANCE_MATCH, api => 'AUTOTARGETING', default => {ord => $CONTEXT_TYPE_RELEVANCE_MATCH}},
                       );

# типы устройств по группам
our %DEVICE_TYPES = (desktop => { bs => [1], api => 'DESKTOP' }, # к десктопам причисляем все устройства, которые не входят в другие группы
                     mobile  => { bs => [2], api => 'MOBILE' },
                     tablet  => { bs => [3], api => 'TABLET' }, );

# операционные системы
our %DETAILED_DEVICE_TYPES = (
                     undefined => {bs => -1, api => 'UNKNOWN', default => {ord => 1}}, # тип ОС не определен до даты BS_DETAILED_DEVICE_TYPE_BORDER_DATE
                     other     => {bs => 0, api => 'OTHER', default => {ord => 2}}, # к "другое" относим все ОС, которые не входят в другие группы
                     android   => {bs => 2, api => 'ANDROID', default => {ord => 3}},
                     ios       => {bs => 3, api => 'IOS', default => {ord => 4}} );

# типы связи
our %CONNECTION_TYPES = (
                     undefined  => {bs => -1, api => 'UNKNOWN', default => {ord => 1}}, # тип связи не определен до даты BS_CONNECTION_TYPE_BORDER_DATE
                     stationary => {bs => 0, api => 'STATIONARY', default => {ord => 2}},
                     mobile     => {bs => 1, api => 'CELLULAR', default => {ord => 3}} );

# места клика (ресурсы) по группам
our %CLICK_PLACES = (undefined => { bs => 0, api => 'UNKNOWN', default => {ord => 1} },
                     title     => { bs => 1, api => 'TITLE', default => {ord => 2} },
                     sitelink1 => { bs => 2, api => 'SITELINK1', default => {ord => 3} },
                     sitelink2 => { bs => 3, api => 'SITELINK2', default => {ord => 4} },
                     sitelink3 => { bs => 4, api => 'SITELINK3', default => {ord => 5} },
                     sitelink4 => { bs => 5, api => 'SITELINK4', default => {ord => 6} },
                     vcard     => { bs => 6, api => 'VCARD', default => {ord => 7} },
                     display_href => { bs => 7, api => 'DISPLAY_URL_PATH', default => {ord => 8} },
                     button => { bs => 8, api => 'BUTTON', default => {ord => 9} },
                     mobile_content_icon => { bs => 9, api => 'MOBILE_APP_ICON', default => {ord => 10} },
                     dialog => { bs => 10, api => 'CHAT', default => {ord => 11} },
                     sitelink5 => { bs => 11, api => 'SITELINK5', default => {ord => 12} },
                     sitelink6 => { bs => 12, api => 'SITELINK6', default => {ord => 13} },
                     sitelink7 => { bs => 13, api => 'SITELINK7', default => {ord => 14} },
                     sitelink8 => { bs => 14, api => 'SITELINK8', default => {ord => 15} },
                     turbo_gallery => {bs => 15, api => 'TURBO_GALLERY', default => {ord => 16}},
                     phone => {bs => 16, api => 'PHONE', default => {ord => 17}},
                     adv_gallery => {bs => 17, api => 'PRODUCT_EXTENSIONS', default => {ord => 18}},
                     market => {bs => 18, api => 'MARKET', default => {ord => 19}},
                     promo_extension => {bs => 19, api => 'PROMO_EXTENSION', default => {ord => 20}},
);

# возрастные группы
our %AGES = ('undefined' => {bs => -1, api => 'UNKNOWN', default => {ord => 1}},
             '0-17'  => {bs => 0, api => 'AGE_0_17', default => {ord => 2}},
             '18-24' => {bs => 1, api => 'AGE_18_24', default => {ord => 3}},
             '25-34' => {bs => 2, api => 'AGE_25_34', default => {ord => 4}},
             '35-44' => {bs => 3, api => 'AGE_35_44', default => {ord => 5}},
             '45-'   => {bs => 4, api => 'AGE_45', default => {ord => 6}},
             '45-54' => {bs => 5, api => 'AGE_45_54', default => {ord => 7}},
             '55-'   => {bs => 6, api => 'AGE_55', default => {ord => 8}}, );

# метки по полу
our %GENDERS = (undefined => {bs => -1, api => 'UNKNOWN', default => {ord => 1}},
                male      => {bs => 0, api => 'GENDER_MALE', default => {ord => 2}},
                female    => {bs => 1, api => 'GENDER_FEMALE', default => {ord => 3}} );

# типы добавленных фраз
our %BROADMATCH_TYPES = (
                         none => {bs => 'none', api => 'NONE', default => 'undefined'},
                         synonym => {bs => 'synonym', api => 'SYNONYM', default => 'undefined'},
                         adf => {bs => 'adf', api => 'RELATED_KEYWORD', default => 'adf'},
                         drf => {bs => 'drf', api => 'RELATED_KEYWORD', default => 'drf'}, );

# типы кампаний (для кастомизации под потребителя)
our %CAMP_TYPES = (text           => {api => $CAMPAIGN_TYPE_MAP{text}},
                   mobile_content => {api => $CAMPAIGN_TYPE_MAP{mobile_content}},
                   dynamic        => {api => $CAMPAIGN_TYPE_MAP{dynamic}},
                   performance    => {api => $CAMPAIGN_TYPE_MAP{performance}},
		           mcbanner	      => {api => $CAMPAIGN_TYPE_MAP{mcbanner}},
		           cpm_banner	  => {api => $CAMPAIGN_TYPE_MAP{cpm_banner}},
                   cpm_deals	  => {api => $CAMPAIGN_TYPE_MAP{cpm_deals}},
                   cpm_yndx_frontpage => {api => $CAMPAIGN_TYPE_MAP{cpm_yndx_frontpage}},
                   content_promotion => {api => $CAMPAIGN_TYPE_MAP{content_promotion}},
                   cpm_price => {api => $CAMPAIGN_TYPE_MAP{cpm_price}},
               );

# типы баннеров
our %BANNER_TYPES = (text       => {bs => 'text'},
                     image_ad   => {bs => 'image_ad'},
                     cpc_video  => {bs => 'cpc_video'},
                     cpm_video  => {bs => 'cpm_video'},
                     other      => {bs => 'other'}, );

our %BS_PHRASE_STATUSES = (added    => {bs => '2',},
                           excluded => {bs => '1',},
                           none     => {bs => '0',} );

our %BS_TURBO_PAGE_TYPES = (turbo    => {bs => [1,2], api => 'TURBO'},
                       none    => {bs => 0, api => 'NONE'} );

# типы медиа-дополнений к баннерам (без изображения/с изображением/с видео)
our %BANNER_IMAGE_TYPES = (text_only  => {bs => 'text_only', api => 'TEXT'},
                           text_image => {bs => [qw/text_image image_only/], api => 'IMAGE'},
                           text_video => {bs => 'text_video', api => 'VIDEO'},
                           smart_creative => {bs => 'smart_creative', api => 'SMART_MULTIPLE'},
                           smart_tgo => {bs => 'smart_tgo', api => 'SMART_SINGLE'},
                           smart_video => {bs => 'smart_video', api => 'SMART_VIDEO'},
                           adaptive_image => {bs => 'adaptive_image', api => 'ADAPTIVE_IMAGE'},
                           smart_tile => {bs => 'smart_tile', api => 'SMART_TILE'},
                           multicard => {bs => 'multicard'},  # TODO api
);

# типы атрибуционной модели
our %ATTRIBUTION_MODEL_TYPES = (last_click => { bs => '1', api => 'LC' },
                                last_significant_click => { bs => '2', api => 'LSC' },
                                first_click => { bs => '3', api => 'FC' },
                                last_yandex_direct_click => { bs => '4', api => 'LYDC' },
                                last_significant_click_cross_device => { bs => '5', api => 'LSCCD' },
                                first_click_cross_device => { bs => '6', api => 'FCCD' },
                                last_yandex_direct_click_cross_device => { bs => '7', api => 'LYDCCD' },
                                last_yandex_direct_view_cross_device => { bs => '8', api => 'LYDVCD' }, # только в статистике
                                );
#  категории таргетинга
our %TARGETING_CATEGORIES = (undefined     => {bs => [0, 1],   default => {ord => 1},  api => 'UNKNOWN'},
                                      exact         => {bs => 2,        default => {ord => 2},  api => 'EXACT'},
                                      alternative   => {bs => 3,        default => {ord => 3},  api => 'ALTERNATIVE'},
                                      competitor    => {bs => 4,        default => {ord => 4},  api => 'COMPETITOR'},
                                      accessory     => {bs => 5,        default => {ord => 5},  api => 'ACCESSORY'},
                                      broader       => {bs => 6,        default => {ord => 6},  api => 'BROADER'});

our %PRISMA_INCOME_GRADES = (others              => {bs => [0 .. 90],    default => {ord => 1},  api => 'OTHER'},
                             above_average      => {bs => [91 .. 95],    default => {ord => 2},  api => 'ABOVE_AVERAGE'},
                             high               => {bs => [96 .. 99],    default => {ord => 3},  api => 'HIGH'},
                             very_high          => {bs => 100,           default => {ord => 4},  api => 'VERY_HIGH'});

our %REGION_SOURCES = (
    current_region => {bs => 'current_region'},
    regular_region => {bs => 'regular_region'},
    search_region  => {bs => 'search_region'},
    unknown        => {bs => 'unknown'},
);

# выражение для проверки переданного параметра группировки по региону
our $REGION_LEVEL_RE = qr/^(continent|country|district|area|city|original)$/;

# блок показа, соответствующий спецразмещению
our $PRIME_TYPE_ID = 1;
our $NON_PRIME_TYPE_ID = 2;
our $ALONE_TYPE_ID = 102;
our $SUGGEST_TYPE_ID = 104;
our $ADV_GALLERY_TYPE_ID = 200;

# блоки показа
# дабы не править фронтенд, на выходе МОЛ по-дефолту отдаются bs-значения, а не ключи данного хеша
our %POSITION_TYPES = ('prime' => {bs => $PRIME_TYPE_ID, api => 'PREMIUMBLOCK', api4 => 'premium', default => {ord => 1}},
                       'non-prime' => {bs => $NON_PRIME_TYPE_ID, api => 'OTHER', api4 => 'other', default => {ord => 2}},
                       'alone' => {bs => $ALONE_TYPE_ID, api => 'ALONE', api4 => 'other', default => {ord => 3}},
                       'suggest' => {bs => $SUGGEST_TYPE_ID, api => 'SUGGEST', api4 => 'other', default => {ord => 4}},
                       'adv-gallery' => {bs => $ADV_GALLERY_TYPE_ID, api => 'PRODUCT_GALLERY', api4 => 'other', default => {ord => 5}});

# тип рекламных площадок "контекст"
our $CONTEXT_TARGET_TYPE = 3;

# типы площадок
our %TARGET_TYPES = (search => {bs => [0..2], api => 'SEARCH', default => {ord => 1} },
                     context => {bs => $CONTEXT_TARGET_TYPE, api => 'AD_NETWORK', default => {ord => 2}});

# тип матчинга (соответствия)
our %MATCH_TYPES = (none => {bs => '', api => 'NONE', default => {ord => 1} },
                    rkw => {bs => 'rkw', api => 'RELATED_KEYWORD', default => {ord => 2} },
                    syn => {bs => 'syn', api => 'SYNONYM', default => {ord => 3} },
                    kwd => {bs => 'kwd', api => 'KEYWORD', default => {ord => 4} },
                );

# типы инвентаря
our %INVENTORY_TYPES = (
    instream_web => {bs => 1, default => {ord => 1}},
    inpage => {bs => 2, default => {ord => 2}},
    interstitial => {bs => 3, default => {ord => 3}},
    inbanner => {bs => 4, default => {ord => 4}},
    rewarded => {bs => 5, default => {ord => 5}},
);

# PhraseID, проставляемый всем расшифрованным ДРФ фразам (т.е. конкретным фразам)
our $BROADMATCH_EXT_PHRASE_ID = 0;
# PhraseID, текст проставляемые всем ДРФ фразам
our $BROADMATCH_PHRASE_ID = 1;
our $BROADMATCH_PHRASE = iget_noop('Автоматически добавленные фразы');

# PhraseID проставляемый для всех relevance match строк при запросе фразы
our $RELEVANCE_MATCH_PHRASE_ID = 11;
# Фраза проставляемая для всех relevance match строк
our $RELEVANCE_MATCH_PHRASE_PLACEHOLDER = "---autotargeting";

# NB! привязывать специальные фразы только к PhraseID - некорректно,
# т.к. с тем же PhraseID может быть ретаргетинг или условие нацеливания
# правильно - по связке ContextType + PhraseID
our %SPECIAL_PHRASES = (
    $BROADMATCH_PHRASE_ID => $BROADMATCH_PHRASE,
    $RELEVANCE_MATCH_PHRASE_ID => $RELEVANCE_MATCH_PHRASE_PLACEHOLDER,
);

# константа обозначающая "значимую" пустую строку
# применяется например в мастере отчетов, для того чтоб отличить не заданный пользователем фильтр, от такого что нужно применить (для поисковых запросов)
our $SIGNIFICANT_EMPTY_STRING = '__SIGNIFICANT_EMPTY_STRING__';

# константа, соответствующая тексту ошибки при превышении лимита строк на выгрузку в xls (применяется в мастере отчетов)
our $XLS_ROWS_LIMIT_EXCEEDED_ERROR = 'XLS_ROWS_LIMIT_EXCEEDED_ERROR';

# константа, соответствующая тексту ошибки при превышении лимита прогнозного времени, необходимого на выгрузку в xls (применяется в мастере отчетов)
our $XLS_PROCESS_TIME_LIMIT_EXCEEDED_ERROR = 'XLS_PROCESS_TIME_LIMIT_EXCEEDED_ERROR';

# выражение для проверки переданного параметра группировки по дате
our $GROUP_BY_DATE_RE = qr/^(none|year|quarter|month|week|day)$/;

use constant APP_INSTALL_ANTIFRAUD => 3;
use constant APP_INSTALL => 4;
use constant APP_INSTALL_TRACKER => 5;
use constant ASSISTED_APP_INSTALL => 6;
use constant ASSISTED_APP_INSTALL_WITHOUT_REINSTALLATION => 7;
use constant ASSOCIATED_APP_INSTALL => 8;
use constant SKAD_NETWORK_APP_INSTALL => 10;

use constant ACHIEVED => 38402972;
use constant APP_LAUNCHED => 38403008;
use constant ADDED_PAYMENT_INFO => 38403053;
use constant ADDED_TO_CART => 38403071;
use constant ADDED_TO_WISHLIST => 38403080;
use constant COMPLETED_REGISTRATION => 38403095;
use constant COMPLETED_TUTORIAL => 38403104;
use constant INITIATED_CHECKOUT => 38403131;
use constant PURCHASED => 38403173;
use constant RATED => 38403191;
use constant SEARCHED => 38403197;
use constant SPENT_CREDITS => 38403206;

use constant UNLOCKED_ACHIEVEMENT => 38403215;
use constant VIEWED_CONTENT => 38403230;
use constant SPENT_TIME_IN_APP => 38403338;
use constant SHARED => 38403494;
use constant EVENT_1 => 38403530;
use constant EVENT_2 => 38403545;
use constant EVENT_3 => 38403581;


our %MOBILE_APP_SPECIAL_GOALS = (
    APP_INSTALL_ANTIFRAUD() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            # роли внутренней рекламы aka Банана
            internal_ad_roles => 1,
        },
        only_for_manager => 1,
        name => iget_noop("Установки приложения (3)"),
    },
    APP_INSTALL() => {
        permissions => { everybody => 1 },
        name => iget_noop("Установки приложения"),
    },
    APP_INSTALL_TRACKER() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_tracker_install_enabled'],
        },
        name => iget_noop('Установки приложения (трекер)'),
    },
    ASSISTED_APP_INSTALL() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_associated_install_enabled'],
        },
        name => iget_noop("Ассоциированные установки приложения"),
    },
    ASSISTED_APP_INSTALL_WITHOUT_REINSTALLATION() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_associated_install_enabled'],
        },
        name => iget_noop("Ассоциированные установки приложения (без переустановок)"),
    },
    ASSOCIATED_APP_INSTALL() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_impression_install_enabled'],
        },
        name => iget_noop("Установки приложения (по показам)"),
    },
    SKAD_NETWORK_APP_INSTALL() => {
        permissions => { everybody => 1 },
        name => iget_noop("Установки приложения (SkAdNetwork)"),
    },
    ACHIEVED() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Achieved"),
    },
    APP_LAUNCHED() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("App launched"),
    },
    ADDED_PAYMENT_INFO() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Added payment info"),
    },
    ADDED_TO_CART() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Added to cart"),
    },
    ADDED_TO_WISHLIST() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Added to wishlist"),
    },
    COMPLETED_REGISTRATION() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Completed registration"),
    },
    COMPLETED_TUTORIAL() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Completed tutorial"),
    },
    INITIATED_CHECKOUT() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Initiated checkout"),
    },
    PURCHASED() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Purchased"),
    },
    RATED() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Rated"),
    },
    SEARCHED() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Searched"),
    },
    SPENT_CREDITS() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Spent credits"),
    },
    UNLOCKED_ACHIEVEMENT() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Unlocked achievement"),
    },
    VIEWED_CONTENT() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Viewed content"),
    },
    SPENT_TIME_IN_APP() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Spent Time In App"),
    },
    SHARED() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Shared"),
    },
    EVENT_1() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Event 1"),
    },
    EVENT_2() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Event 2"),
    },
    EVENT_3() => {
        permissions => {
            managers => 1,
            internal_roles => 1,
            features => ['rmp_stat_cpa_enabled', 'in_app_events_in_rmp_enabled'],
        },
        name => iget_noop("Event 3"),
    },
);


1;
