package Stat::CustomizedArray::DBStat;

=pod

    $Id$

=head1 NAME

    Stat::CustomizedArray::DBStat

=head1 DESCRIPTION

    Метод get_stat_customized_array вынесен из DBStat в отдельный модуль, со
    всеми сабметодами для упрощения зависимостей и дальнейшего рефакторинга.
    Возвращает отчеты только из БД, для автоматического переключения на быстрые
    отчеты следует использовать Stat::CustomizedArray

=head2 Интферфейс
    new - конструктор
    set_report_parameters - параметры отчета для генерации
    generate_dbstat - генерирует и возвращает отчет, аналогично старому DBStat::get_stat_customized_array

    все остальные методы внутренние, либо для классов наследников

    также см. Stat::CustomizedArray::Base, Stat::CustomizedArray
=cut

use strict;
use warnings;

use utf8;

use LogTools qw/log_stacktrace/;

use base qw/Stat::CustomizedArray::Base DBStat/;

sub new {
    return Stat::CustomizedArray::Base::new(@_);
}

=head2 generate_dbstat_iterator
    
=cut

sub generate_dbstat_iterator {
    log_stacktrace("dbstat", 'Stat::CustomizedArray::DBStat->generate_dbstat_iterator');
    die "unsupported";
}

=head2 generate

    Методы для доступа к параметром отчета, в основном для удобства внутреннго
    пользования

    Скаляры: oid, start_date, end_date, date_aggregation_by
    Массивы: group_by
    Хэши: filters, limits, options

    Описание см. в set_report_parameters
=cut

sub generate { shift->generate_dbstat }

=head2 generate_dbstat {
    Получить статистику с самыми обобщёнными группировками, фильтрами и
    лимитом. Фильтр работает только на уровне SQL-запроса

    В отличии от похожего DBStat::get_stat_customized, не умеет переключаться
    на быстрые отчеты, фильтровать на лету, но формирует общую статистику по
    всему запросу и поддерживает лимиты.

=cut

sub generate_dbstat {
    log_stacktrace("dbstat", 'Stat::CustomizedArray::DBStat->generate_dbstat');
    # еще один кейс, при котором сюда проваливаемся: у кампании не определяется или определяется неверно тип.
    # это может быть "пустой" тип из-за проблем с метабазой
    die "unsupported, DIRECT-56151, DIRECT-98169";
}

1;
