#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

# отключили из-за DIRECT-54229
# <crontab>
#     time: 10 5 * * *
#     <switchman>
#         group:  scripts-other
#     </switchman>
#     package: scripts-switchman
# </crontab>
# <juggler>
#     host: checks_auto.direct.yandex.ru
#     ttl: 2d2h
# </juggler>

=cut

# $Id$

=head1 DESCRIPTION

    Подписывает на рассылку директа разработчиков приложений использующих API.

=cut

use strict;
use warnings;
use utf8;

use JSON;

use ScriptHelper;
use Yandex::Subscriptions;

use API::DevelopersSubscription qw/get_emails/;

$log->out("start");
my $log = Yandex::Log->new( log_file_name => $Yandex::Subscriptions::SUBSCRIPTIONS_LOG, date_suf => '%Y%m' );

my $maillist_id = 'novosti-api-direkta-auto';

my $del_res = maillist_clear_subscribers($maillist_id);

$log->out("Clear subscribers error") if $del_res->{result} ne 'success';

my $emails = get_emails();

if ( scalar @$emails ) {
    while (my @chunk = splice @$emails, 0, 500) {
        my $result = maillist_add_subscribers( $maillist_id, @chunk )
        or $log->die("Unable to subscribe");
        $log->out(to_json($result)) if $result;
    }
}

juggler_ok();

$log->out("end.");



