package Suggestions;

# $Id$

=head1 NAME
    
    Suggestions

=head1 DESCRIPTION

    функции, относящиеся к подсказкам: по фразам и по сайту

=cut

use strict;
use warnings;

use List::Util qw/max min sum/;
use List::MoreUtils qw/uniq/;
use Yandex::HashUtils;
use Settings;
use Yandex::DBTools;
use PhraseText;
use ADVQ6;
use LogTools qw/log_messages/;
use TextTools qw/space_cleaner/;

use Yandex::BMWordstat;
use ReqWizard;


use base qw/Exporter/;
our @EXPORT = qw/
    get_url_suggestion

    get_phrases_info_from_suggest
/;

use utf8;

my $is_new_reqwizard_enabled = Property->new('IS_NEW_REQWIZARD_ENABLED');

=head2 get_phrases_info_from_suggest

    Получить информацию о фразах из подсказочной таблицы (suggest_phrases)

    На входе -- ссылка на массив описаний фраз [ {phrase => 'слон', phrase_hash=> 9088118357466876082}, {phrase => 'слоно -ужам'}, {phrase_hash => 513592808282260562}, ... ]
    Входной массив изменяется: к каждой фразе добавляются недостающие поля:
        phrase_orig -- текст фразы, как он записан в подсказочной таблице
        phrase_hash -- хеш фразы (минус-слова, кавычки и воскл. знаки при вычислении хеша НЕ учитываются)
        banners_cnt 
        orders_cnt 
        users_cnt 
        shows -- примерное количество показов по фразе в месяц (из таблицы suggest_phrases)
        notintable -- добавляется (со значением 1) для фраз, которых нет в таблице фраз
    В результате массив @$phrases приобретает вид: 
    [ 
        {
            phrase      => 'слон', 
            phrase_orig => 'слон',
            phrase_hash => 9088118357466876082, 
            price
            banners_cnt 
            orders_cnt 
            users_cnt 
            shows       => 4500,
            ctr         => 8.3
        }, 
        {
            phrase      => 'слоно -ужам',
            phrase_hash => ..., 
            ...
            shows       => 0,
            notintable  => 1
        }, 
        ...
    ]

    $options = {
        shows_only => 1, # добавлять инфрмацию только о показах
    }

=cut

sub get_phrases_info_from_suggest
{
    my ($phrases, $options) = @_;
    for (@{$phrases}){
        $_->{phrase_hash} = get_phrase_hash($_->{phrase}) if !exists $_->{phrase_hash} && exists $_->{phrase};
    }
    my $hashes = join ',', map {$_->{phrase_hash}} @{$phrases};

    return if $hashes eq '';

    log_messages("suggest_phrases", "get_phrases_info_from_suggest");
    my $suggest_phrases;
    my $sth = exec_sql(PPCDICT, "SELECT phrase as phrase_orig, phrase_hash, hits as shows, banners_cnt, orders_cnt, users_cnt, price, ctr*100 as ctr
                                 FROM suggest_phrases WHERE phrase_hash in ($hashes)");
    while(my $p = $sth->fetchrow_hashref) {
        $p->{price} /= 1e6;
        $suggest_phrases->{$p->{phrase_hash}} = $p;
    }

    for my $p (@$phrases){
        if ($options->{shows_only} || 0){
            hash_merge($p, hash_cut($suggest_phrases->{$p->{phrase_hash}}, qw/shows/) );
        } else {
            hash_merge($p, $suggest_phrases->{$p->{phrase_hash}});
        }
        $p->{shows} ||= 0;
        $p->{notintable} = 1 if !exists $suggest_phrases->{$p->{phrase_hash}}->{phrase_hash} || $suggest_phrases->{$p->{phrase_hash}}->{banners_cnt} == 0;
    }
    return;
}


=head2 get_bm_suggestion

Получаем подсказки из bmwordstat.
Формат частично совместим с get_suggestion (без постраничного вывода):
на входе массив фраз, на выходе хеш вида

    { phrases => [ "...", ... ] }

Опции:

    count
    iteration

=cut

sub get_bm_suggestion
{
    my ($phrases, $options) = @_;
    my @prepared_phrases = grep { $_ } map { space_cleaner($_) } map { s/\x{00}//gr } @$phrases;

    return {phrases => []}  if !@prepared_phrases || (defined $options->{count} && !$options->{count});

    my $page_num = $options->{iteration} || 0;
    my $page_size = $options->{count} || 10;

    # пытаемся не запрашивать лишнего:
    # минимум 20 подсказок всего, и минимум 10 на каждую фразу
    my $phr_count = max($page_size, 20 + 1 - @prepared_phrases);

    my @requests = map {[$_, $phr_count, 0]} @prepared_phrases;

    my $response;
    if ($is_new_reqwizard_enabled->get(60)) {
        $response = ReqWizard::reqwizard_call(\@prepared_phrases);
    } else {
        $response = Yandex::BMWordstat::bm_wordstat_call(\@requests);
    }
    my %in_request = map {($_ => 1)} @prepared_phrases;

    # перемешиваем все подсказки, выкидываем совпадающие с запросом
    my @bm_suggestions =
        uniq
        grep {!$in_request{$_}}
        map {$_->[0]}
#        sort {$b->[1] <=> $a->[1]}
        map {@$_}
        @$response;

    # пересортировываем по прогнозу advq
    my $advq_response = eval {
        my $advq_response = { map {$_->{phrase} => $_->{count}} @{ADVQ6::advq_request(\@bm_suggestions)} };

    };

    if (!$advq_response) {
        log_messages('suggestions', "Call to Advq failed: $@");
        $advq_response = {};
    }
    my @suggestions =
        sort {($advq_response->{$b} // 0) <=> ($advq_response->{$a} // 0)}
        keys %$advq_response;

    my @suggestions_page = map {$suggestions[$_] || ()} ($page_num*$page_size .. ($page_num+1)*$page_size-1);

    return {
        phrases => \@suggestions_page,
        is_something_before => !!$page_num,
        is_something_after => (@suggestions > ($page_num+1)*$page_size),
    };
}



=head2 get_url_suggestion($url, $options)
    Deprecated.
    Нужно удалить после реализации DIRECT-110328

=cut

sub get_url_suggestion {
    my ($url, $options) = @_;
    # DIRECT-96507 - никуда не ходим и считаем, что нам вернули пустой результат.

    return [], 1, "";
}

1;
