package Survey::Surveymonkey;

use 5.010;
use strict;
use warnings;
use utf8;

use Carp;
use Mouse;

use Exception::Class ( 'Survey::Surveymonkey::Error' );

use Yandex::I18n qw/iget/;
use List::Util qw/first/;
use Digest::MD5 qw/md5_hex/;


our $USER_SALT //= 'some weird message';


has ext_survey_id => ( is => 'ro', isa => 'Int', required => 1 );
has ext_collector_id => ( is => 'ro', isa => 'Int', required => 1 );
has tracking_var => ( is => 'ro', isa => 'Str', required => 1 );
has base_url => ( is => 'ro', isa => 'Str', required => 1, lazy_build => 1 );


sub _build_base_url {
    my ($self) = @_;

    require Net::Surveymonkey;
    my $sm = Net::Surveymonkey->new();
    my $sm_response = eval { $sm->get_survey_details({
            survey_id => q{} . $self->ext_survey_id,
        }) }
    or Survey::Surveymonkey::Error->throw(iget("Не удалось запросить данные опроса из Surveymonkey"));

    Survey::Surveymonkey::Error->throw(iget("В опросе не определена трекинговая переменная"))  if !$sm_response->{custom_variable_count};

    $sm_response = eval { $sm->get_collector_list({
            survey_id => q{} . $self->ext_survey_id,
            fields => [ "url" ],
        }) }
    or Survey::Surveymonkey::Error->throw(iget("Не удалось запросить данные коллектора из Surveymonkey"));

    my $collector = first {$_->{collector_id} == $self->ext_collector_id} @{$sm_response->{collectors}}
    or Survey::Surveymonkey::Error->throw(iget("Не найден коллектор %s для опроса %s", $self->ext_collector_id, $self->ext_survey_id));

    my $url = $collector->{url};
    Survey::Surveymonkey::Error->throw(iget("В коллекторе не описана базовая ссылка"))  if !$url;
    return $url;
}


=head2 export

=cut

sub export {
    my ($self) = @_;

    my %export = map {($_ => $self->$_())} qw/ ext_survey_id ext_collector_id tracking_var base_url /;
    return \%export;
}



=head2 get_user_id

=cut

sub get_user_id
{
    my ($self, $uid) = @_;
    croak "No uid"  if !$uid;

    my $base_url = $self->base_url;
    my $user_id = md5_hex("$uid$base_url$USER_SALT");
    return $user_id;
}


=head2 get_user_url

=cut

sub get_user_url
{
    my ($self, %opt) = @_;

    my $user_id = $opt{ext_user_id} || $self->get_user_id($opt{uid});

    return $self->base_url . q{?} . $self->tracking_var . q{=} . $user_id;
}



__PACKAGE__->meta->make_immutable();
1;

