package Survey::TNS;

use 5.010;
use strict;
use warnings;
use utf8;

use Carp;
use Mouse;

use Yandex::HTTP;
use List::Util qw/sum/;
use Digest::MD5 qw/md5_hex/;



our $TNS_BASE_URL //= 'http://ts-preview.ktrmr.com/surveyv.aspx';
our $USER_SALT = 'salt tail message';

has ext_survey_id => ( is => 'ro', isa => 'Str', required => 1 );
has ext_contractor_id => ( is => 'ro', isa => 'Str', required => 1 );



=head2 export

=cut

sub export {
    my ($self) = @_;

    my %export = map {($_ => $self->$_())} qw/ ext_survey_id ext_contractor_id /;
    return \%export;
}


=head2 get_user_id

=cut

sub get_user_id
{
    my ($self, $uid) = @_;
    croak "No uid"  if !$uid;

    my $user_id = md5_hex($uid . $USER_SALT);
    return $user_id;
}


=head2 get_user_url

=cut

sub get_user_url
{
    my ($self, %opt) = @_;

    my $user_id = $opt{ext_user_id} || $self->get_user_id($opt{uid});

    my $url = Yandex::HTTP::make_url($TNS_BASE_URL, {
            'i.project' => $self->ext_survey_id,
            s => $self->ext_contractor_id,
            pid => $user_id,
            chk => $self->get_user_checksum($user_id),
            id => 1,
            rs => 1,
            'i.timeout' => 60,
        });

    return $url;
}


=head2 get_user_checksum

Подсчёт контрольной суммы:
сумма кодов символов, в кубе, берём три последних цифры.

=cut

sub get_user_checksum
{
    my ($self, $user_id) = @_;

    my $chk = (sum map {ord} split m//, $user_id) ** 3 % 1000;
    return sprintf '%03d', $chk;
}


__PACKAGE__->meta->make_immutable();
1;
