##########################################################
#
# $Id$
#       Escape special characters in TeX notation
#
##########################################################
package TeXEscape;

use strict;
use warnings;

use utf8;

require Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw(tex_escape);

my %chars = (
    0xA0 => q|~|,
    0xA1 => q|\textexclamdown{}|,
    0xA2 => q|\textcent{}|,
    0xA3 => q|\textsterling{}|,
    0xA4 => q|\textcurrency{}|,
    0xA5 => q|\textyen{}|,
    0xA6 => q|\textbrokenbar{}|,
    0xA7 => q|\textsection{}|,
    0xA8 => q|\textasciidieresis{}|,
    0xA9 => q|\textcopyright{}|,
    0xAA => q|\textordfeminine{}|,
    0xAB => q|\guillemotleft{}|,
    0xAC => q|\textlnot{}|,
    0xAD => q|\-|,
    0xAE => q|\textregistered{}|,
    0xAF => q|\textasciimacron{}|,
    0xB0 => q|\textdegree{}|,
    0xB1 => q|\textpm{}|,
    0xB2 => q|\texttwosuperior{}|,
    0xB3 => q|\textthreesuperior{}|,
    0xB4 => q|\textasciiacute{}|,
    0xB5 => q|\textmu{}|,
    0xB6 => q|\textparagraph{}|,
    0xB7 => q|\textperiodcentered{}|,
    0xB8 => q|\c{}|,
    0xB9 => q|\textonesuperior{}|,
    0xBA => q|\textordmasculine{}|,
    0xBB => q|\guillemotright{}|,
    0xBC => q|\textonequarter{}|,
    0xBD => q|\textonehalf{}|,
    0xBE => q|\textthreequarters{}|,
    0xBF => q|\textquestiondown{}|,
    0xC0 => q|\`A|,
    0xC1 => q|\'A|,
    0xC2 => q|\^A|,
    0xC3 => q|\~A|,
    0xC4 => q|\"A|,
    0xC5 => q|\AA{}|,
    0xC6 => q|\AE{}|,
    0xC7 => q|\c{C}|,
    0xC8 => q|\`E|,
    0xC9 => q|\'E|,
    0xCA => q|\^E|,
    0xCB => q|\"E|,
    0xCC => q|\`I|,
    0xCD => q|\'I|,
    0xCE => q|\^I|,
    0xCF => q|\"I|,
    0xD0 => q|\DH{}|,
    0xD1 => q|\~N|,
    0xD2 => q|\`O|,
    0xD3 => q|\'O|,
    0xD4 => q|\^O|,
    0xD5 => q|\~O|,
    0xD6 => q|\"O|,
    0xD7 => q|x|,
    0xD8 => q|\O{}|,
    0xD9 => q|\`U|,
    0xDA => q|\'U|,
    0xDB => q|\^U|,
    0xDC => q|\"U|,
    0xDD => q|\'Y|,
    0xDE => q|\TH{}|,
    0xDF => q|\ss{}|,
    0xE0 => q|\`a|,
    0xE1 => q|\'a|,
    0xE2 => q|\^a|,
    0xE3 => q|\~a|,
    0xE4 => q|\"a|,
    0xE5 => q|\aa{}|,
    0xE6 => q|\ae{}|,
    0xE7 => q|\c{c}|,
    0xE8 => q|\`e|,
    0xE9 => q|\'e|,
    0xEA => q|\^e|,
    0xEB => q|\"e|,
    0xEC => q|\`i|,
    0xED => q|\'i|,
    0xEE => q|\^i|,
    0xEF => q|\"i|,
    0xF0 => q|\dh{}|,
    0xF1 => q|\~n|,
    0xF2 => q|\`o|,
    0xF3 => q|\'o|,
    0xF4 => q|\^o|,
    0xF5 => q|\~o|,
    0xF6 => q|\"o|,
    0xF7 => q|\textdiv{}|,
    0xF8 => q|\o{}|,
    0xF9 => q|\`u|,
    0xFA => q|\'u|,
    0xFB => q|\^u|,
    0xFC => q|\"u|,
    0xFD => q|\'y|,
    0xFE => q|\th{}|,
    0xFF => q|\"y|,
);

sub tex_escape {
    my $str = shift;
    # Сначала эскейпим фигурные скобки, чтобы не сделать это для уже экранированного результата (например \)
    $str =~ s/([{}])/\\$1/g;
    # \ ^ ~ недостаточно просто экранировать обратным слешем
    $str =~ s/\\(?!\{|\})/\\textbackslash{}/g;
    $str =~ s/\^/\\textasciicircum{}/g;
    $str =~ s/\~/\\textasciitilde{}/g;
    # экранируем остальные спец. символы
    $str =~ s/([\$\%_\&\#])/\\$1/g;
    $str =~ s/"/``/g;
    $str =~ s/([\xA0-\xFF])/$chars{ord($1)}/g;
    return $str;
}

1;
