package Teaser;

use Direct::Modern;

use Settings;
use Yandex::DBTools;
use Yandex::HashUtils;
use Client;

use List::MoreUtils qw(none);

use base qw/Exporter/;
our @EXPORT = qw/
    get_teasers
/;

=head2 get_teasers($user, $login_rights, $domain, $campaigns, $client_currencies, $c)

    Какие тизеры можно показать пользователю?

    $user = {
        ClientID => $ClientID,
        NDS => get_client_NDS($ClientID),
        client_have_agency => rbac_has_agency($rbac, $uid),
    };
    $teaser_result = get_teasers($user, $login_rights, $domain, $campaign, $client_currencies);
    $teaser_result => {
        cpa_optimization => # оптимизация по конверсии
        personal_manager => # персональный менеджер
        working_holiday => # рабочие выходные
        multicurrency => 1/0 # переход в реальную валюту
        country_currencies => [{region_id => 225, currency => 'RUB}, ...], # доступные для перехода с точки зрения Баланса страны/валюты
    }
    $c => DirectContext->new(...)

=cut

sub get_teasers {

    my ($user, $login_rights, $domain, $campaigns, $client_currencies, $c) = @_;

    my @teasers;
    my $teasers_data = {};
    if ($login_rights->{is_any_client} && $domain ne 'tr') {

        my @cids = map {$_->{cid}}
                    grep {$_->{OrderID}
                          && $_->{archived} eq 'No'
                          && $_->{mediaType} eq 'text'
                         }
                    @$campaigns;

        # тизер мобильного приложения
        my $uid = $user->{uid};

        # Когда появляется новый мобильный тизер, то его показы должны считаться с нуля
        # для этого вводим версию тизера, который нужно показывать
        my $mobile_teaser_current_version = 2;
        my $mobile_teaser_rf = 5; # показываем не более 5 раз одному пользователю
        my $mobile_teaser_shows = get_one_field_sql(PPC(uid => $uid), ["select rf from mobile_teaser", where => { 
            uid => $uid, 
            teaser_version => $mobile_teaser_current_version,
        }]) || 0;
        if ($mobile_teaser_shows < $mobile_teaser_rf) {
            do_sql(PPC(uid => $uid), "insert into mobile_teaser (uid,teaser_version,rf) values (?,?,1) on duplicate key update rf=rf+1", $uid, $mobile_teaser_current_version);
            push @teasers, 'android';
        }
    }

    # тизер про переход в реальную валюту
    if ($c->is_direct && $user->{ClientID} && !Property->new($Client::CURRENCY_CONVERT_TEASER_DISABLED_PROPERTY_NAME)->get()) {
        my @country_currency;
        my $can_convert_error = Client::can_convert_to_real_money(
            ClientID => $user->{ClientID},
            NDS => $user->{NDS},
            client_currencies => $client_currencies,
            client_chief_uid => $login_rights->{client_chief_uid},
            country_currency_ref => \@country_currency,
            ignore_nds_absence => 1,
        );

        if (!defined $can_convert_error && @country_currency) {
            if ($user->{client_have_agency} && none { $login_rights->{"${_}_control"} } qw(agency manager support super)) {
                # заказать конвертацию агентского субклиента может только представитель агентства/менеджер/саппорт/супер
                # тизер при этом показываем всем, но не у всех в нём есть кнопка конвертации
                $teasers_data->{cannot_request_currency_convert} = 1;
            }

            push @teasers, 'multicurrency';
            $teasers_data->{country_currencies} = \@country_currency;
        }

    }

    push @teasers, 'recommendations_email' if $login_rights->{role} eq 'client' && $c->is_direct && $user->{ClientID} && !( $user->{client_have_agency} || $user->{client_have_manager})&& $user->{is_russian_client};

    return hash_merge {map {("${_}" => 1)} @teasers}, $teasers_data;
}

1;
