package Template::Plugin::DocsL10n;
use base qw(Template::Plugin::Procedural);

=head1 DESCRIPTION

    $Id$
    TT-плагин для получения пути к локализованному документу

=cut

use strict;
use warnings;

use List::Util qw/first/;


=head2 $DEFAULT_LANG

    Если перевода нет, используем язык оригинала

=cut

our $DEFAULT_LANG = 'ru';


=head2 $DOC_ROOT

    Директория для документов, внутри поддиректории по языкам
    определяется в Settings

=cut

our $DOC_ROOT ||= './data/docs';
our $DOC_URL  ||= '/docs';


=head2 get_doc_path

    Возвращаем путь к переводу документа 
    или к оригиналу, если перевода нет (ищем оригинал в директории для языка по умолчанию и на верхнем уровне)

=cut

sub get_doc_path
{
    my $doc  = shift;
    my $lang = shift;
    
    $lang = 'en' if $lang eq 'tr' && $doc =~ /api_offer/;
    my @possible_paths = (
        $lang.'/'.$doc, 
        $DEFAULT_LANG.'/'.$doc, 
        $doc,
    );
    return first { -f "$DOC_ROOT/$_" } @possible_paths;
}


=head2 get_doc_url

    Возвращаем url, по которому загрузится то, что было найдено get_doc_path

=cut

sub get_doc_url
{
    my $doc  = shift;
    my $lang = shift;

    my $url = "$DOC_URL/".get_doc_path($doc, $lang);
    return $url;
}

1;
