package Translit;

=pod

=encoding utf8

    $Id:$

=head1 NAME

    Translit

=head1 SYNOPSIS

    use Translit;
    my $str_lat = translit($str_ru);

=head1 DESCRIPTION

    Транслитерация, не по госту. Не в TextTools, потому что есть зависимость от Settings;
    Работает в два этапа, сначала заменяет символы русского алфавита на их транслитерации по таблице,
    потом удаляет допустимые в директе символы других алфавитов (недопустимых уже быть не должно)

=head1 METHODS

=cut

use Direct::Modern;

use base qw/Exporter/;

our @EXPORT = qw/translit/;

use Settings;

=head2 translit($str)

    Возвращает транслитерацию строки

=cut

sub translit {
    my $str = shift;
    my %tr = (
        'А'  =>  'A',   'Б'  =>  'B',   'В'  =>  'V',     'Г'  =>  'G',    'Д'  =>  'D',     'Е'  =>  'E',   'Ж'  =>  'Zh',
        'З'  =>  'Z',   'И'  =>  'I',   'Й'  =>  'Y',     'К'  =>  'K',    'Л'  =>  'L',     'М'  =>  'M',   'Н'  =>  'N',
        'О'  =>  'O',   'П'  =>  'P',   'Р'  =>  'R',     'С'  =>  'S',    'Т'  =>  'T',     'У'  =>  'U',   'Ф'  =>  'F',
        'Х'  =>  'Kh',  'Ц'  =>  'Ts',  'Ч'  =>  'Ch',    'Ш'  =>  'Sh',   'Щ'  =>  'Shch',  'ъ'  =>  '',    'Ё'  =>  'Yo',
        'ы'  =>  'y',   'ь'  =>  '',    'Э'  =>  'E',     'Ю'  =>  'Yu',   'Я'  =>  'Ya',    'а'  =>  'a',   'б'  =>  'b',
        'в'  =>  'v',   'г'  =>  'g',   'д'  =>  'd',     'е'  =>  'e',    'ж'  =>  'zh',    'з'  =>  'z',   'и'  =>  'i',
        'й'  =>  'y',   'к'  =>  'k',   'л'  =>  'l',     'м'  =>  'm',    'н'  =>  'n',     'о'  =>  'o',   'п'  =>  'p',
        'р'  =>  'r',   'с'  =>  's',   'т'  =>  't',     'у'  =>  'u',    'ф'  =>  'f',     'х'  =>  'kh',  'ц'  =>  'ts',
        'ч'  =>  'ch',  'ш'  =>  'sh',  'щ'  =>  'shch',  'э'  =>  'e',    'ю'  =>  'yu',    'я'  =>  'ya',  'ё'  =>  'yo',
        'Ы'  =>  'Y',   'Ъ'  =>  '',    'Ь'  =>  ''
    );

    my $transliterate_re = join "|", map {quotemeta} keys %tr;
    my $non_latin_alphabet_letters_re = qr/[\Q$Settings::NON_LAT_ALPHABET_LETTERS\E]/iaa;

    $str =~ s/($transliterate_re)/$tr{$1}/ig;
    $str =~ s/$non_latin_alphabet_letters_re//ig;
    $str =~ s/\s+/ /g; # на случай если предыдущая строчка что-то удалила, чтобы не было двойных пробелов

    return $str;
}

1;

__END__
