package Units::Adjusted;

=pod

=head1 NAME

    Units::Adjusted - субкласс Units, позволяющий применять множитель ко всем списываемым баллам

=head1 SYNOPSIS

    см. Units.pm

=head1 DESCRIPTION

    см. Units.pm

=cut

use Direct::Modern;

use Mouse;
use POSIX qw/ceil/;

extends 'Units';

=head1 METHOD

=head2 new

    Конструктор

    Параметры:
        теже, что и для Units, плюс
        multiplier    - множитель, который применяется ко всем списываемым баллам

    Результат:
        Ссылка на объект класса Units

=head2 multiplier

    Множитель, который применяется ко всем списываемым баллам, по умолчанию 1

    Параметры:
        Число с плавающей точкой

    Результат:
        Число с плавающей точкой

=cut

has multiplier => ( is => 'rw', isa => 'Num', default => 1 );

=head2 withdraw

    Увеличивает счетчик потраченных в текущем интервале баллов на указанную величину

    Параметры:
        количество баллов

    Результат:
        кол-во списанных баллов, либо undef
        1 | 0

=cut

sub withdraw {
    my ( $self, $amount ) = @_;

    $amount = ceil( ($amount // 0) * $self->multiplier );
    $self->SUPER::withdraw($amount);

    return $amount;
}

__PACKAGE__->meta->make_immutable();

1;
