package Units::Storage;

use strict;
use warnings;
use utf8;

=pod

=head1 NAME

    Units::Storage - определяет интерфейс, который backend хранилища баллов должен реализовывать

=head1 METHODS

=cut

use Carp qw/ croak /;

=head2 get

    Получает из хранилища значение по ключу

    Параметры:
        ключ - строка

    Результат:
        значение или undef

=cut

sub get { croak 'Must be implemented in descendants' }

=head2 get_multi

    Получает из хранилища несколько значений по указанным ключам

    Параметры:
        массив ключей - массив строк

    Результат:
        ссылка на хэш вида ключ => значение

=cut

sub get_multi { croak 'Must be implemented in descendants' }

=head2 set

    Устанавливает в хранилище указанное значение по указанному ключу с указанным временем time-to-live

    Параметры:
        ключ     - строка
        значение - число
        ttl      - число

    Результат:
        true | false

=cut

sub set { croak 'Must be implemented in descendants' }

=head2 incr

    Увеличивает в хранилище значение по указанному ключу на указанную величину

    Параметры:
        ключ     - строка
        значение - число

    Результат:
        true | false

=cut

sub incr { croak 'Must be implemented in descendants' }

=head2 incr_expire

    Увеличивает в хранилище значение по указанному ключу на указанную величину,
    и если значения не было - устанавливает expire

    Параметры:
        ключ     - строка
        значение - число
        expire   - число

    Результат:
        true | false

=cut

sub incr_expire { croak 'Must be implemented in descendants' }

=head2 delete_multi

    Удаляет из хранилища значения по указанным ключам

    Параметры:
        массив ключей - массив строк

    Результат:
        ссылка на хэш вида ключ => результат

=cut

sub delete_multi { croak 'Must be implemented in descendants' }

1;
