package Units::Storage::Memcached;

use strict;
use warnings;
use utf8;

use Yandex::Memcached;

use base qw/Units::Storage/;

use Mouse;

has memcached => ( is => 'ro', isa => 'Yandex::Memcached', required => 1 );

sub get {
    my ( $self, $key ) = @_;

    return $self->memcached->get( $key );
}

sub get_multi {
    my ( $self, $keys ) = @_;

    return $self->memcached->get_multi( @$keys );
}

sub set {
    my ( $self, $key, $val, $expiration ) = @_;

    return $self->memcached->set( $key, $val, $expiration );
}

sub incr {
    my ( $self, $key, $val ) = @_;

    return $self->memcached->incr( $key, $val );
}

sub incr_expire {
    my ( $self, $key, $val, $expire ) = @_;

    my $ret = $self->memcached->incr($key, $val);
    if (defined $ret && !$ret) {
        $self->memcached->add($key, 0, $expire);
        $ret = $self->memcached->incr($key, $val);
    }
    return $ret;
}

sub delete_multi {
    my ( $self, $keys ) = @_;
    my $results = $self->memcached->delete_multi( @$keys );
    return ( grep { not defined $_ } values %$results ) ? 0 : 1
}

__PACKAGE__->meta->make_immutable();

1;
