package Units::Storage::RedisCluster;

=head1 NAME

    Units::Storage::RedisCluster

=head1 DESCRIPTION

    Хранение юнитов api5 в RedisCluster

    В случае недоступности редиса все операции возвращают undef

=cut

use Direct::Modern;

use List::MoreUtils qw/zip/;
use Try::Tiny;

use DirectRedis;

use parent qw/Units::Storage/;

use Mouse;

has redis => ( is => 'ro', isa => 'DirectRedis', required => 1 );

sub get {
    my ( $self, $key ) = @_;

    return try { $self->redis->get( $key ) };
}

sub get_multi {
    my ( $self, $keys ) = @_;

    return try {
        my $vals = $self->redis->mget( @$keys );
        my $ret = {zip @$keys, @$vals};
        $ret;
    };
}

sub set {
    my ( $self, $key, $val, $expiration ) = @_;

    return try { $self->redis->setex( $key, $expiration, $val ) };
}

sub incr {
    my ( $self, $key, $val ) = @_;

    return try { $self->redis->incrby( $key, $val ) };
}

sub incr_expire {
    my ( $self, $key, $val, $expire ) = @_;

    return try {
        my $ret = $self->redis->incrby($key, $val);
        if (defined $ret && $ret == $val) {
            # мы создали ключ
            $self->redis->expire($key, $expire);
        }

        $ret;
    };
}

sub delete_multi {
    my ( $self, $keys ) = @_;

    return scalar try { $self->redis->del( @$keys ) };
}

__PACKAGE__->meta->make_immutable();

1;
