package UnitsFactory;

=pod

    $Id$

=head1 NAME

    UnitsFactory

=head1 SYNOPSIS

    my $units = UnitsFactory::create($client_id);

    $units->withdraw(10);

=head1 DESCRIPTION

    Пакет для инициализации системы баллов на пользователя с хранением в redis или где-нибудь еще (раньше была возможность хранить в memcache)

=head1 METHODS

=cut

use Direct::Modern;

use Settings;
use DirectRedis;

use Units;
use Units::Adjusted;
use Units::Storage::RedisCluster;

=head2 create($client_id, $daily_units_limit, $basket_name)

    Возвращает объект Units настроенный на клиента

    Параметры:
        $client_id         - число, обязательный
        $daily_units_limit - число, необязательный
        $basket_name       - число, тип корзины (API/XLS)

=cut

sub create {
    my ( $client_id, $daily_units_limit, $basket_name ) = @_;

    my $params = _units_params($client_id, $daily_units_limit, $basket_name);

    return Units->new($params);
}

=head2 create_adjusted($client_id, $coef, $daily_units_limit, $basket_name)

    Возвращает объект Units настроенный на клиента с коэффициентом на списываемые баллы

    Параметры:
        $client_id         - число, обязательный
        $coef              - дробное число, коэффициента на который умножаются все списываемые баллы, по умолчанию 1
        $daily_units_limit - число, необязательный
        $basket_name       - число, тип корзины (API/XLS)

=cut

sub create_adjusted {
    my ( $client_id, $coef, $daily_units_limit, $basket_name ) = @_;

    my $params = _units_params($client_id, $daily_units_limit, $basket_name);
    $params->{multiplier} = $coef if defined $coef;

    return Units::Adjusted->new($params);
}

sub _units_params {
    my ($client_id, $daily_units_limit, $basket_name) = @_;

    croak "no client_id" unless $client_id;

    my %params = (
        client_id => $client_id,
        ( $daily_units_limit ? ( limit => $daily_units_limit ) : () ),
        ( $basket_name ? (basket_name => $basket_name) : () ),
        );

    return {
        %params,
        key_format => $Settings::REDIS_KEY_PREFIX."units-{%d}-%s-%d-spent",
        storage => Units::Storage::RedisCluster->new(
            redis => DirectRedis::get_redis(),
        ),
    };
        # пример хранения в memcached
        # return {
        #    %params,
        #    key_format => "%d-%s-%d-spent",
        #    storage => Units::Storage::Memcached->new(
        #        memcached => Yandex::Memcached->new(
        #            servers => $Settings::MEMCACHED_SERVERS
        #        )),
        #};
}

1;

__END__
