package WalletLock;

=head1 NAME

WalletLock - блокировка/разблокировка "единого счета" (DIRECT-47185)

=cut

use Direct::Modern;

use Settings;

use Yandex::DBTools;
use Yandex::I18n;


=head2 has_any_common_wallet($uid)

    Узнать, подключен ли у клиента хоть один общий кошелек

 - $uid - uid главного представителя клиента с $client_id

=cut

sub has_any_common_wallet {
    my $uid = shift;

    my $wallet_id =  get_one_field_sql(PPC(uid => $uid),
        "SELECT c.wallet_cid
           FROM users u
             JOIN campaigns c USING(uid)
             LEFT JOIN clients cl ON cl.ClientID = u.ClientID
         WHERE u.uid=? AND c.wallet_cid!=0
           AND IFNULL(cl.work_currency, 'YND_FIXED') = IFNULL(c.currency, 'YND_FIXED')
         LIMIT 1", $uid);

    return (defined $wallet_id ? 1 : 0);
}


# --------------------------------------------------------------------

=head2 lock_wallet($uid, $client_id)

    Заблокировать возможность отключения общего счета для клиента.

Блокировку можно снять до того, как информация о ней будет отправлена в Баланс,
то есть в течении 7 дней. После этого клиент никогда не сможет отключить общий
счет

 - $uid - uid главного представителя клиента с $client_id

=cut

sub lock_wallet {
    my ($uid, $client_id) = @_;

    # Не даем установить лок, если общий счет не подключен
    my $has_wallet = has_any_common_wallet($uid);
    return iget("Общий счет не подключен") if !$has_wallet;

    do_insert_into_table(PPC(ClientID => $client_id), 'wallet_campaigns_lock', {ClientID => $client_id, state => 'created'});

    return 0;
}

# --------------------------------------------------------------------

=head2 unlock_wallet($client_id)

    Разблокировать возможность отключения общего счета для клиента.

Работает только до отправки информации о блокировке в Баланс. Если кошелек уже нельзя разлочить
или кошелек не заблокирован, возвращает ошибку.

=cut

sub unlock_wallet {
    my $client_id = shift;

    my $nrows = do_delete_from_table(PPC(ClientID => $client_id), 'wallet_campaigns_lock', where => {ClientID => $client_id, state => 'created'});

    return iget("Блокировка отсутствует или уже не может быть снята") if $nrows == 0;
}

# --------------------------------------------------------------------

=head2 is_wallet_locked($client_id)

    Заблокирована ли возможность отключить общий счет для клиента

=cut

sub is_wallet_locked {
    my $client_id = shift;

    my $lock_state = get_one_field_sql(PPC(ClientID => $client_id),
        "SELECT 1 FROM wallet_campaigns_lock WHERE ClientID=?", $client_id);

    return defined $lock_state ? 1 : 0;
}

1;
