use strict;
use warnings;
use utf8;

package XLSMediaplan;

use Yandex::HashUtils;
use Yandex::URL qw/get_host/;
use Yandex::MyGoodWords;

use VCards;
use Mediaplan;
use Sitelinks;
use Settings;
use XLSCampImport;
use TextTools;
use OrgDetails;
use BS::History;
use PrimitivesIds;
use MinusWords;
use Retargeting;

sub convert_to_mediaplan {
    
    my ($xls_camp, $to_cid, %options) = @_;
    my ($uid, $client_chief_uid) = @options{qw/uid client_chief_uid/};  

    my $curr_camp = get_camp_snapshot($client_chief_uid, $to_cid);
    my %groups = map {
        my $g = $_;
        ($g->{pid} => {map {$_->{bid} . '_' . $_->{banner_type} => 1} @{$g->{banners}}})
    } @{$curr_camp->{groups}};
    
    # Сразу достаем все phraseIdHistory для фраз, которые присутствуют в кампании.
    my $bs_phraseid_histories = {};
    if ($xls_camp->{cid}) {
        for my $ph (@{BS::History::get_keywords_with_history({cid => $xls_camp->{cid}})}) {
            $bs_phraseid_histories->{$ph->{id}} = $ph;
        }
    }

    # Если в xls файле указаны контакты, то скомпилировать номер телефона в один номер по нашему формату.
    $xls_camp->{contact_info}->{phone} = compile_phone($xls_camp->{contact_info}) if $xls_camp->{contact_info};

    my @banners;  
    foreach my $xls_group (@{$xls_camp->{groups}}) {
        
        my @phrases;
        for my $phrase (@{$xls_group->{phrases}}) {
            my @norm_words = ();
            unless($phrase->{phr} =~ m/^($Retargeting::CONDITION_XLS_PREFIX|$Retargeting::CONDITION_XLS_PREFIX_OLD)\s*/){
                @norm_words = split /\s/, Yandex::MyGoodWords::norm_words($phrase->{phr});
            }
            my $new_ph = {
                phrase  => $phrase->{phr},
                cid     => $to_cid,
                numword => scalar(@norm_words),
            };
            # copy ctr
            if ($phrase->{id}) {
                $new_ph->{phraseIdHistory} = $bs_phraseid_histories->{$phrase->{id}}->{phraseIdHistory} if $bs_phraseid_histories->{$phrase->{id}};
            }
            
            push @phrases, $new_ph;
        }
        
        for my $xls_banner (@{$xls_group->{banners}}) {
            
            # copy phrases
            my %banner = (
                retargetings => $xls_group->{retargetings},
                phrases => [@phrases],
                geo => $xls_group->{geo}
            );
            hash_copy \%banner, $xls_banner, qw/title title_extension body href sitelinks banner_type/;
            $banner{$_}         = html2string($banner{$_}) foreach qw/title title_extension body/;
            $banner{domain}     = get_host($banner{href});
            $banner{cid}        = $to_cid;
            if ($xls_group->{pid} && $xls_banner->{bid}
                && $groups{$xls_group->{pid}} && $groups{$xls_group->{pid}}->{ $xls_banner->{bid} . '_' .  $xls_banner->{banner_type} }) {
                    
                $banner{source_bid} = $xls_banner->{bid};                    
                $banner{source_pid} = $xls_group->{pid};
            }

            # Собираем данные контактной информации
            if ($xls_banner->{contact_info} && $xls_banner->{contact_info} eq '+') {
                my $vcard_values = hash_cut($xls_camp->{contact_info}, @$VCARD_FIELDS);
                # XXX Добавляем недостающие до $VCARD_FIELDS_DB 4 поля.
                $vcard_values->{uid} = $uid;
                $vcard_values->{cid} = $to_cid;
                $vcard_values->{geo_id} = $banner{geo_id} || 0;
                $vcard_values->{address_id} = $banner{map}{aid};
                $banner{vcard_values} = $vcard_values;
            }

            # Единые минус-слов
            $banner{minus_words} = $xls_group->{minus_words} if $xls_group->{minus_words};

            push @banners, \%banner;
        }
    }
    
    return {
        banners => \@banners,
        contact_info => $xls_camp->{contact_info},
        cid => $to_cid
    }, $curr_camp;
}

sub validate_xls_mediaplan {
    
    my ($mediaplan, $curr_camp, %options) = @_;
    
    my @errors;
    foreach (@{$mediaplan->{banners}}) {
        if (my @err = Mediaplan::validate_mediabanner($_, ClientID => $options{ClientID})) {
            push @errors, @err;   
            last;
        }
    }
    
    my $error = XLSCampImport::validate_xls_geo(%options);
    push @errors, $error if $error;
    push @errors, @{check_domain_availability($mediaplan->{banners}, $curr_camp->{groups})};
    
    return @errors;
}

sub save {
    my ($mediaplan, %options) = @_;

    my ($UID, $client_chief_uid) = @options{qw/UID client_chief_uid/};
    XLSCampImport::set_geo_to_groups({groups => $mediaplan->{banners}}, $options{geo}, $options{form_geo}) if defined $options{form_geo};
    my $client_id = get_clientid(uid => $client_chief_uid);
    my $org_details_id;
    foreach my $banner (@{$mediaplan->{banners}}) {
        
        # Сохраняем контактные данные
        if ($banner->{vcard_values}) {
            
            if (!$org_details_id && $mediaplan->{contact_info}->{ogrn}) {
                $org_details_id = add_org_details({ogrn => $mediaplan->{contact_info}->{ogrn}, uid => $client_chief_uid})
            }             
            $banner->{vcard_values}->{org_details_id} = $org_details_id if $org_details_id;
            
            $banner->{vcard_values}->{cid} = $banner->{cid};
            $banner->{vcard_id} = create_vcards($client_chief_uid, [$banner->{vcard_values}])->[0]{vcard_id};
        }

        # Сохраняем сайтлинки
        if ($banner->{sitelinks}
                && Sitelinks::need_save_sitelinks_set($banner->{sitelinks})) {
        
            my $sitelinks_set_id = Sitelinks::save_sitelinks_set($banner->{sitelinks}, $client_id);
            $banner->{sitelinks_set_id} = $sitelinks_set_id if $sitelinks_set_id;
        }

        # Сохраняем минус-слова
        $banner->{mw_id} = MinusWords::save_minus_words($banner->{minus_words}, $client_id) if $banner->{minus_words};

        # Сохраняем баннер медиаплана
        add_mediaplan_banner($banner, ClientID => $client_id);
    }

    # Создаем заявку на медиаплан
    update_mediaplan_stats($options{rbac}, $mediaplan->{cid}, $UID, $options{login_rights}, 1);
}


1;
