use strict;
use warnings;
use utf8;

package XLSVocabulary;

use Yandex::HashUtils;
use Yandex::I18n;

use base qw/Exporter/;
our @EXPORT = qw/
    get_field_names
    get_field_name
    get_campaign_type_by_parse_string
/;

{
    my $camp_field_names = {
        cid                  => iget_noop('№ заказа:'),
        currency             => iget_noop('Валюта:'),
        campaign_minus_words => [iget_noop('Минус-фразы на кампанию:'), iget_noop('Минус-слова на кампанию:')],
        campaign_type        => iget_noop('Тип кампании:'),
        mobile_columns_adgroup_header=> iget_noop('Реклама мобильных приложений: настройки на группу'),
        mobile_columns_banner_header=> iget_noop('Реклама мобильных приложений: настройки на объявление'),
    };

    my $group_field_names = {
        pid => iget_noop("ID группы"),
        number  => iget_noop("Номер группы"),
        serving_status  => iget_noop('Статус "Мало показов"'),
        region  => iget_noop("Регион"),
        mobile_store_content_href => iget_noop('Ссылка на приложение в магазине'),
        mobile_device_type_targeting => iget_noop('Тип устройства'),
        mobile_network_targeting => iget_noop('Тип связи'),
        mobile_os => iget_noop('Версия ОС'),
    };

    my $banner_field_names = {
        is_banner => iget_noop("Доп. объявление группы"),
        ad_type => iget_noop('Тип объявления'),
        banner_type => iget_noop("Мобильное объявление"),
        group_name => iget_noop("Название группы"),
        
        id      => iget_noop("ID фразы"),
        phr     => iget_noop("Фраза (с минус-словами)"),
        bid     => iget_noop("ID объявления"),
        title_mobile_content    => iget_noop("Заголовок"),
        title                   => iget_noop("Заголовок 1"),
        title_extension         => iget_noop("Заголовок 2"),
        body                    => iget_noop("Текст"),

        l1      => iget_noop("Длина"),
        l2      => undef,
        l_title_mobile_content  => iget_noop("заголовок"),
        l_title                 => iget_noop("заголовок 1"),
        l_title_extension       => iget_noop("заголовок 2"),
        l_body                  => iget_noop("текст"),

        href    => iget_noop("Ссылка"),
        display_href => iget_noop("Отображаемая ссылка"),
        permalink => iget_noop("Организация Яндекс.Справочника"),
        price   => iget_noop("Ставка"),
        price_context => [iget_noop('Ставка в сетях'), iget_noop('Ставка на тематич. пл.')],
        contact_info    => iget_noop("Контакты"),
        banner_status   => iget_noop("Статус объявления "), # Пробел в конце фразы добавлен специально, см. DIRECT-86954
        phrase_status   => iget_noop("Статус фразы"),

        sitelink_titles => [iget_noop("Заголовки быстрых ссылок"), iget_noop("Заголовки дополнительных ссылок")],
        sitelink_descriptions => [iget_noop("Описания быстрых ссылок"), iget_noop("Описания дополнительных ссылок")],
        sitelink_hrefs  => [iget_noop("Адреса быстрых ссылок"), iget_noop("Адреса дополнительных ссылок")],
        sitelink_turbolanding_ids => iget_noop("Турбо-страницы быстрых ссылок"),

        param1 => iget_noop('Параметр 1'),
        param2 => iget_noop('Параметр 2'),

        tags => iget_noop('Метки'),
        image_url => iget_noop('Изображение'),

        creative_id => iget_noop('Креатив'),
        creative_status_moderate => iget_noop('Статус модерации креатива'),
        
        turbolanding_id => iget_noop('Турбо-страница'),

        minus_words => [iget_noop("Минус-фразы на группу"), iget_noop("Минус-слова на группу")],
        age => iget_noop('Возрастные ограничения'),

        mobile_href => iget_noop('Трекинговая ссылка'),
        mobile_icon => iget_noop('Иконка'),
        mobile_rating => iget_noop('Рейтинг'),
        mobile_rating_votes => iget_noop('Количество оценок'),
        mobile_price => iget_noop('Цена'),

        callouts => iget_noop('Уточнения'),
    };

    my $vocabulary_field_names = {
        voc_header => iget_noop('Словарь значений полей'),
        campaign_type_header => iget_noop('Тип кампании'),
        ad_type_text => iget_noop('Текстово-графическое'),
        ad_type_image_ad => iget_noop('Графическое'),
        camp_type_text   => iget_noop('Текстово-графическая кампания'),
        camp_type_mobile_content => iget_noop('Реклама мобильных приложений'),
        mobile_device_type_targeting_all => iget_noop('Все'),
        mobile_device_type_targeting_tablet => iget_noop('Планшеты'),
        mobile_device_type_targeting_phone => iget_noop('Смартфоны'),
        mobile_network_targeting_all => iget_noop('Мобильная связь и Wi-Fi'),
        mobile_network_targeting_wifi => iget_noop('Только Wi-Fi'),
        mobile_os_android => iget_noop('Android'),
        mobile_os_ios => iget_noop('iOS'),

    };

    my $field_names = hash_merge $camp_field_names, $group_field_names, $banner_field_names, $vocabulary_field_names;

    my $valid_campaign_type_names = {camp_type_text=> 'text',
                                     camp_type_mobile_content => 'mobile_content'};


    sub get_field_names($) {
        my $field = shift;
        if (defined $field && defined $field_names->{$field}) {
            if (ref $field_names->{$field}) {
                return [map { iget($_) } @{$field_names->{$field}}] if @{$field_names->{$field}};
            } else {
                return [iget($field_names->{$field})];
            }
        }
        return [];
    }

=head2 get_field_name

   По ключу возвращает текстовое название поля или строки, которая используется в XLS.
   Внимание, если в $field_names у ключа несколько вариантов строк - берется первая.
   Таким образом, переименовывая какое-либо поле, требуется в качестве первого варианта указывать
   новое название и только далее - старый вариант.

=cut

    sub get_field_name($) {
        my $field = shift;
        return unless defined $field;
        return get_field_names($field)->[0] || '';
    }
    
    sub get_all_fields {
        return keys %$field_names;
    }

    sub get_campaign_type_by_parse_string {
        my $parse_string = shift;
        return unless defined $parse_string;
        return $valid_campaign_type_names->{$parse_string};
    }
}
1;
