package Yandex::Clone;
## no critic (Modules::ProhibitEvilModules)

=head1 NAME

Yandex::Clone

=head1 DESCRIPTION

Реализует единственную функцию yclone, являющуюся оберткой над Storable::dclone + Clone::clone

=cut

use Direct::Modern;

use base qw/Exporter/;

use Yandex::Log::Messages;

use Carp;
use Storable qw//;
use Clone qw//;

our @EXPORT = qw/yclone/;

=head2 yclone($sref)

Пытается скопировать структуру по ссылке $ref используя Storable::dclone, а при невозможности, через Clone::clone

=cut

sub yclone {
    my ($sref) = @_;
    return $sref if !defined $sref || !ref($sref);
    my $dref;
    eval {
        $dref = Storable::dclone($sref); 1;
    } or do {
        my $log = Yandex::Log::Messages->new();
        $log->msg_prefix("clone_fallback");
        $log->out(Carp::shortmess('Falling back to `Clone::clone`'));
        $dref = Clone::clone($sref);
    };
    return $dref;
}

1;
