package Yandex::ORM::Types;
## no critic (TestingAndDebugging::RequireUseStrict, TestingAndDebugging::RequireUseWarnings)

use Mouse::Util::TypeConstraints;
use Mouse::Exporter;

Mouse::Exporter->setup_import_methods(
    as_is => [qw/set/],
);

use List::MoreUtils qw/all/;

my $TIMESTAMP_RE = qr/^(((\d{4})(-)(0[13578]|10|12)(-)(0[1-9]|[12][0-9]|3[01]))|((\d{4})(-)(0[469]|11)(-)([0][1-9]|[12][0-9]|30))|((\d{4})(-)(02)(-)(0[1-9]|1[0-9]|2[0-8]))|(([02468][048]00)(-)(02)(-)(29))|(([13579][26]00)(-)(02)(-)(29))|(([0-9][0-9][0][48])(-)(02)(-)(29))|(([0-9][0-9][2468][048])(-)(02)(-)(29))|(([0-9][0-9][13579][26])(-)(02)(-)(29)))(\s([0-1][0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9]))$/;

subtype 'Id' => as 'Int' => where { $_ >= 0 }; # 2^31 Java Integer.MAX_VALUE
subtype 'Id32' => as 'Int' => where { $_ >= 0 && $_ <= 2_147_483_647 }; # 2^31 Java Integer.MAX_VALUE
subtype 'Id64' => as 'Int' => where { $_ >= 0 && $_ <= 9_223_372_036_854_775_807 }; # 2^63 Java Long.MAX_VALUE

subtype 'Timestamp' => as 'Str' => where { $_ eq '0000-00-00 00:00:00' or $_ =~ $TIMESTAMP_RE };

subtype 'EmptyStr'
    => as 'Str'
    => where { length($_) == 0 };

subtype 'NonEmptyStr'
    => as 'Str'
    => where { length($_) > 0 };

subtype 'OnlyFalse'
    => as 'Bool'
    => where { !$_ };

subtype 'OnlyTrue'
    => as 'Bool'
    => where { !!$_ };

subtype 'NonEmptyArrayRef'
    => as 'ArrayRef'
    => where { scalar(@$_) > 0 };

subtype 'EmptyArrayRef'
    => as 'ArrayRef'
    => where { scalar(@$_) == 0 };

subtype 'EmptyHashRef'
    => as 'HashRef'
    => where { !scalar(keys %$_) };

subtype 'Zero'
    => as 'Int'
    => where { $_ == 0 };

=head2 set($name, [@values])

    set 'MySet' => [qw/one two three/];

Создает новый тип Set с именем $name и допустимыми значениями @values.
Если в начале имени поставить `+`, это будет означать, что Set не может быть пустым.

=cut

sub set {
    my ($name, $nonempty, %valid);

    $name = shift unless @_ == 1 && ref($_[0]) eq 'ARRAY';
    if (defined $name) {
        $nonempty = 1 if $name =~ s/^\+//;
        $name = undef if !length $name;
    }
    %valid = map { $_ => undef } (@_ == 1 && ref($_[0]) eq 'ARRAY' ? @{$_[0]} : @_);

    # SetType
    return subtype $name => (
        as           => 'ArrayRef[Str]',
        optimized_as => sub {
            defined($_[0]) && ref($_[0]) eq 'ARRAY' && (!$nonempty || @{$_[0]}) && all { exists $valid{$_} } @{$_[0]}
        }
    );
}

no Mouse::Util::TypeConstraints;

1;
