#!/usr/bin/env perl

use my_inc "..";

=head1 METADATA

# TODO: здесь пятнадцать раз одно и то же, с разницей в --uniq N;
# стоит поменять на один блок с instances: 15 (pod2crontab сейчас так не умеет, сначала надо научить)
# NB! при изменении числа инстансов - не забыть поменять juggler-проверку ниже
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 2
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 3
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 4
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 5
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 6
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 7
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 8
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 9
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 10
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 11
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 12
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 13
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 14
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    time: */5 * * * *
    ulimit: -v 10000000
    package: scripts-switchman
    sharded: 1
    params: --uniq 15
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    raw_events:     scripts.apiReportsBuilder.working.uniq_$uniq.shard_$shard
    sharded:        1
    vars:           uniq=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
    ttl:            20m
    tag: direct_group_internal_systems
</juggler>

<crontab>
    time: */5 * * * *
    params: --uniq 1
    sharded: 1
    only_shards: 1
    package: scripts-sandbox
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:           scripts.apiReportsBuilder.working.sandbox
    raw_host:       CGROUP%direct_sandbox
    raw_events:     scripts.apiReportsBuilder.working.sandbox.uniq_$uniq.shard_$shard
    vars:           shard=1
    vars:           uniq=1
    ttl:            20m
    tag: direct_group_internal_systems
</juggler>

<crontab>
    time: */3 * * * *
    params: --uniq 1
    sharded: 1
    flock: 1
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

=cut

#    $Id: apiReportsBuilder.pl 129047 2016-10-27 13:13:25Z pavryabov $

=head1 NAME

apiReportsBuilder.pl - демон генерации отчетов для api клиентов

=head1 DESCRIPTION

    Параметры запуска:
    --uniq - обязательный параметр, число, позволяющее развести несколько
             скриптов на кластере ppcscripts (обрабатывается switchman)

    На машинах под switchman запускается несколько процессов для каждого шарда.

    Если отчетов для обработки нет, процесс ждет $IDLE_SLEEP_TIME секунд и снова опрашивает базу.

    Если скрипт стал занимать слишком много памяти ($MAX_PROC_SIZE) или слишком долго
    работает ($PROCESS_LIFETIME), он умирает.

=head1 RUNNING

    Перезапускается при каждом обновлении Директ-пакетов независимо от того,
    были ли изменения в самом скрипте apiReportsBuilder.pl

=cut

use Direct::Modern;

use Encode;
use File::Temp;
use List::Util qw/any/;
use Sys::Hostname;
use Time::HiRes ();

use Yandex::DBQueue;
use Yandex::ProcInfo;
use Yandex::Trace;

use Settings;
use ScriptHelper sharded => 1, get_file_lock => undef, 'Yandex::Log' => 'messages';

use API::Reports::Builder;
use API::Reports::FormatTsv 'tsv_line';
use API::Reports::InternalRequestRepresentation;
use API::Reports::OfflineReportTask;
use API::Settings;

use Direct::Storage;
use EnvTools;
use LockTools;
use PrimitivesIds;

use open ':std' => ':utf8';

=head1 SUBROUTINES/METHODS/VARIABLES

=cut

# используем ip адрес сервера в качестве идентификатора папы
my $PROC_FATHER_ID = hostname() or die("Can't get hostname");

# максимальное количество попыток сгенерировать отчет
my $MAX_PROCESSING_TIMES = $API::Settings::MAX_PROCESSING_TIMES_STAT_REPORTS || 5;

# максимальный размер памяти, отведенный под процесс
my $MAX_PROC_SIZE = 1.5 * 1024 * 1024 * 1024; # 1.5 ГБ

# максимальный объём отчёта, который буферизуем в памяти, а не сбрасываем во временный файл
my $MAX_REPORT_SIZE_IN_MEMORY = 50 * 1024 * 1024;

# максимальное количество итераций цикла "выбрать задачу - сделать задачу";
# итерации, в которых задачи не нашлось, считаются
my $MAX_ITERATIONS = 10000;

# счётчик итераций; когда дойдёт до $MAX_ITERATIONS, скрипт завершается
my $ITERATIONS_ALMOST_DONE = 0;

# Максимальное время жизни процесса (сек)
my $PROCESS_LIFETIME = 60*60;

# сколько спать при отсутствии отчёта (сек)
my $IDLE_SLEEP_TIME = 5;

# идентификация процесса в логах: "$hostname/$uniq/$$"
my $FULL_PROC_ID;

my $PROCESS_START_TIME = time();

my $STORAGE = Direct::Storage->new;

my $JUGGLER_SERVICE_SUFFIX = '';

my $JOB_QUEUE;

# на сколько секунд процесс может захватить задание в очереди
my $GRAB_DURATION = 60 * 60 * 1.5;

my ($UNIQ, $ONCE, $LOGIN, $REPORT_NAME);
extract_script_params(
    'uniq=s' => \$UNIQ,
    'once' => \$ONCE,
    'login=s' => \$LOGIN,
    'report-name=s' => \$REPORT_NAME,
);

die '--uniq param is mandatory!' unless defined $UNIQ;

if ( ! defined $LOGIN && !get_file_lock( 'dont die', get_script_name() . ".$UNIQ" ) ) {
    exit 0;
}

$log->msg_prefix("[shard_$SHARD,uniq_$UNIQ]");
$Yandex::DBQueue::LOG = $log;

$JUGGLER_SERVICE_SUFFIX .= 'sandbox.' if is_sandbox();
$JUGGLER_SERVICE_SUFFIX .= "uniq_$UNIQ";

$FULL_PROC_ID = "$PROC_FATHER_ID/$UNIQ/$$";

$log->out("start daemon $FULL_PROC_ID");

$JOB_QUEUE = Yandex::DBQueue->new( PPC( shard => $SHARD ), API::Reports::OfflineReportTask::DBQUEUE_JOB_TYPE );

if ( defined $LOGIN ) {
    if ( $LOGIN eq '' ) {
        $log->die('--login, if present, must not be empty');
    }

    if ( ! defined $REPORT_NAME || $REPORT_NAME eq '' ) {
        $log->die('--login requires --report-name');
    }

    my $ClientID = get_clientid( login => $LOGIN );
    unless ($ClientID) {
        $log->die("Invalid login: $LOGIN");
    }

    my $task = API::Reports::OfflineReportTask->find_task( $ClientID, $REPORT_NAME );

    my $job = $task->dbqueue_job;

    $log->out( "found job, job_id = " . $job->job_id );

    if ( $job->is_finished || $job->is_failed || $job->is_revoked ) {
        $log->out('job already done, quitting');
        exit;
    }

    if ( $job->is_grabbed ) {
        $log->out('some other process is working on it, waiting for it to finish...');

        my $time_started_waiting = time;

        while ( time - $time_started_waiting < 120 ) {
            sleep 1;

            $job = $JOB_QUEUE->find_job_by_id( $job->job_id );

            if ( $job->is_failed ) {
                $log->die('job failed');
            }

            if ( $job->is_finished ) {
                $log->out('finished now');
                last;
            }

            $log->out('not finished yet');
        }

        unless ( $job->is_finished ) {
            $log->die('the other process failed to finish the job');
        }

        $log->out('the other process finished the job, quitting');
        exit;
    }

    work_on_job($job);

    $log->out('done with the job, quitting');
    exit;
}

while (1) {
    last if ($ITERATIONS_ALMOST_DONE++ > $MAX_ITERATIONS);
    my $idle = 0;

    if ( my $job = $JOB_QUEUE->grab_job(grab_for => $GRAB_DURATION) ) {
        work_on_job($job);
    } else {
        $idle = 1;
    }

    juggler_ok( service_suffix => $JUGGLER_SERVICE_SUFFIX );

    last if should_quit();
    idle() if $idle;

    restart_tracing('worker');
}

$log->out("end daemon $FULL_PROC_ID");

exit;

sub work_on_job {
    my ($job) = @_;

    my $job_id = $job->job_id;
    my $ClientID = $job->ClientID;

    if ( $job->trycount > $MAX_PROCESSING_TIMES ) {
        $log->out({ error => "rank_exceed_limit", job_id => $job_id, trycount => $job->trycount });

        my $marked_ok = $job->mark_failed_permanently( { error => 'Unknown error' } );
        $log->out( "failed to mark $job_id failed (permanently) - another process handled it?") unless $marked_ok;
        return;
    }

    $log->out("$FULL_PROC_ID process start for job $job_id");

    my $report_extra_log_data = {};

    my $starttime = Time::HiRes::time();
    my $result = eval { build_report( $ClientID, $job_id, $job->args ) } || {};

    if ($@) {
        my $error = $@;
        $result = { error => $error };
        $log->out( { 'report_error' => $error, job_id => $job_id || 0, args => $job->args } );
    }

    my $report_generation_time = Time::HiRes::time() - $starttime;

    if ( $result->{ok} ) {
        $log->out( 'Create report - '.$job_id );
        my $marked_ok = $job->mark_finished( {
            filename => $result->{filename},
            generation_time => $report_generation_time,
            stat_source => $result->{stat_source},
            is_empty_report => $result->{is_empty_report},
        } );

        $log->out("failed to mark $job_id finished") unless $marked_ok;
    } else {
        my $error = $result->{error} || 'Unknown error';

        if ( $job->trycount >= $MAX_PROCESSING_TIMES ) {
            $log->out({ error => "rank_exceed_limit", job_id => $job_id, trycount => $job->trycount });

            my $marked_ok = $job->mark_failed_permanently( { error => $error } );
            $log->out( "failed to mark $job_id failed (permanently) - another process handled it?") unless $marked_ok;
        } else {
            my $marked_ok = $job->mark_failed_once;
            $log->out( "failed to mark $job_id failed once - another process handled it?") unless $marked_ok;
        }
    }

    $log->out( sprintf( 'process time for job %s: %.3f sec, trycount = %s', $job_id, $report_generation_time, $job->trycount ) );
}

=head2 should_quit()

Проверки, что процесс должен завершиться, потому что:
    а) слишком много памяти ест
    б) слишком долго работает
    в) получил SIGTERM или версия Директа поменялась (использует стандартный smart_check_stop_file)
    г) сделали слишко много итераций
    д) нас просили сделать только одну итерацию

Возвращает 0 (надо работать дальше) или 1 (надо завершиться).

=cut

sub should_quit {
    return 1 if $ONCE;
    # перезапускаем процесс, если он начал занимать слишком много памяти
    if ( proc_memory() > $MAX_PROC_SIZE ) {
        $log->out("$FULL_PROC_ID uses too much memory, quitting: " . proc_status_str());
        return 1;
    # или процесс работает уже слишком долго (смерть от старости)
    } elsif ( Time::HiRes::time() - $PROCESS_START_TIME > $PROCESS_LIFETIME) {
        $log->out("$FULL_PROC_ID is too old, quitting");
        return 1;
    # или уже сделали достаточно итераций
    } elsif ( $ITERATIONS_ALMOST_DONE >= $MAX_ITERATIONS ) {
        $log->out("$FULL_PROC_ID: done $MAX_ITERATIONS iterations, quitting");
        return 1;
    # или получен SIGTERM/изменилась версия Директа
    } elsif ( my $reason = smart_check_stop_file() ) {
        $log->out("$FULL_PROC_ID: $reason, quitting");
        return 1;
    }

    return 0;
}

=head2 build_report( ClientID, job_id, job_args )

    Создает файл отчета

=cut

sub build_report {
    my ( $ClientID, $job_id, $job_args ) = @_;

    die "Missing required argument: ClientID" unless $ClientID;
    die "Missing required argument: job_id" unless $job_id;
    die "Missing or invalid argument: job_args" unless $job_args && ref $job_args eq 'HASH';

    my $profile = Yandex::Trace::new_profile('apiReportsBuilder:build_report');

    my $request = API::Reports::InternalRequestRepresentation->from_plain_struct($job_args);
    my $result = API::Reports::Builder->build_report($request);

    # инвариант: в каждый момент определён (defined) либо $buffer (буферизуем в памяти),
    # либо все три $tmp_file, $tmp_filename, $tmp_fh (буферизуем в файле),
    # но не и то, и другое
    my $buffer = '';
    my ( $tmp_file, $tmp_filename, $tmp_fh ) = ( undef, undef, undef );

    my $size = 0;

    my $write_line = sub {
        my ($data) = @_;

        # делаем encode_utf8 здесь, потому что пусть это будет единственное место,
        # где делается это преобразование; символы всё равно дальше не нужны
        $data = Encode::encode_utf8($data);

        $size += length($data);

        if ( defined $buffer ) {
            $buffer .= $data;

            if ( length $buffer > $MAX_REPORT_SIZE_IN_MEMORY ) {
                $tmp_file = File::Temp->new( DIR => $API::Settings::API_REPORTS_TMPDIR );
                $tmp_filename = $tmp_file->filename;

                $log->out("saving the report to a temporary file: $tmp_filename");

                open $tmp_fh, '>:raw', $tmp_filename
                    or die "cannot open temporary file to store the report: $!";

                print $tmp_fh $buffer
                    or die "cannot write to temporary file: $!";
                undef $buffer;
            }

            return;
        }

        print $tmp_fh $data
            or die "cannot write to temporary file: $!";
    };

    $write_line->( tsv_line( [ $result->title ] ) ) if !$request->skip_report_header;
    $write_line->( tsv_line( $result->header ) ) if !$request->skip_column_header;

    my $iterator = $result->data_iterator;
    my $row_count = 0;
    while ( $iterator->has_next_row ) {
        $write_line->( tsv_line( $iterator->next_row ) );
        $row_count++;
    }

    # добавляем последнюю стоку с количеством строк отчета
    $write_line->( tsv_line( ["Total rows: $row_count"] ) ) if !$request->skip_report_summary;

    my $is_empty_report = 0;
    my $storage_filename = '';

    if ( defined $buffer ) {
        if (length $buffer) {
            my $stored_file = $STORAGE->save( API::Reports::OfflineReportTask::STORAGE_FILE_TYPE, $buffer,
                ClientID => $ClientID,
                filename => $job_id,
                size => $size,
            );

            $storage_filename = $stored_file->filename;
        } else {
            $is_empty_report = 1;
        }
    } else {
        close $tmp_fh
            or die "cannot flush/close temporary file: $!";

        my $stored_file = $STORAGE->save( API::Reports::OfflineReportTask::STORAGE_FILE_TYPE, undef,
            ClientID => $ClientID,
            content_filename => $tmp_filename,
            filename => $job_id,
            size => $size,
        );

        $storage_filename = $stored_file->filename;
    }

    return { ok => 1, is_empty_report => $is_empty_report, filename => $storage_filename, stat_source => $result->stat_source };
}

sub idle {
    # спим, чтобы не пожрать все ресурсы, если отчетов для обработки нет
    $log->out("No report selected, sleeping for $IDLE_SLEEP_TIME seconds");
    my $profile = Yandex::Trace::new_profile("apiReportsBuilder:sleep");
    sleep $IDLE_SLEEP_TIME;
}
