#!/usr/bin/perl
use Direct::Modern;

=head1 METADATA

# здесь, может быть, странное, но так предполагается:
# скрипт в пакете scripts-switchman, чтобы быть рядом с apiReportsBuilder,
# но запускается не под switchman, потому что чистить временные файлы надо
# на всех серверах
<crontab>
    time: 20 3 * * *
    package: scripts-switchman
</crontab>
<crontab>
    time: 20 3 * * *
    package: scripts-sandbox
</crontab>
<crontab>
    time: 20 3 * * *
    package: conf-test-scripts
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 2d
    tag: direct_group_internal_systems
</juggler>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:       scripts.apiReportsBuilderCleanTempFiles.working.sandbox
    raw_host:   CGROUP%direct_sandbox
    raw_events: scripts.apiReportsBuilderCleanTempFiles.working.sandbox
    ttl:        2d
    tag: direct_group_internal_systems
</juggler>

=head1 NAME

apiReportsBuilderCleanTempFiles.pl

=head1 DESCRIPTION

Удаляет временные файлы отчётов, которые сохраняет apiReportsBuilder.pl
Удаляются только старые файлы, чтобы не затронуть отчёты, которые Builder
строит в момент запуска BuilderCleanTempFiles.

=cut

use Path::Tiny;

use my_inc '..';
use API::Settings;
use EnvTools;
use ScriptHelper 'Yandex::Log' => 'messages';

# файлы, у которых время последнего изменения меньше этого unix timestamp,
# считаются старыми и удаляются
my $DELETE_FILES_WITH_MTIME_BEFORE = time - 24 * 60 * 60; # сутки назад

$log->out('start');

for my $tempfile ( path($API::Settings::API_REPORTS_TMPDIR)->children ) {
    if ( $tempfile->stat->mtime >= $DELETE_FILES_WITH_MTIME_BEFORE ) {
        $log->out("skipping $tempfile: recently modified");
        next;
    }

    $log->out("deleting $tempfile");
    $tempfile->remove;
}

$log->out('sending juggler notification');
juggler_ok(service_suffix => (EnvTools::is_sandbox() ? 'sandbox' : undef));

$log->out('finish');
