#!/usr/bin/perl


=head1 METADATA

<crontab>
    env: YT_DIRECT_CLUSTER=hahn
    time: */59 * * * *
    <switchman>
        group: scripts-other
        lockname: bmAllBanners.pl.hahn
        <leases>
            mem: 150
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    env: YT_DIRECT_CLUSTER=arnold
    time: */59 * * * *
    <switchman>
        group: scripts-other
        lockname: bmAllBanners.pl.arnold
        <leases>
            mem: 150
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    raw_events:     scripts.bmAllBanners.working.$yt_cluster.banners
    vars:           yt_cluster=hahn,arnold
    ttl:            4h
    tag:            direct_yt
    tag:            direct_group_internal_systems
</juggler>
=cut

=head1 DESCRIPTION

    Создание в YT таблички со всеми баннерами Директа (Бродматч будет забирать их прямо оттуда)
    Табличку с кампаниями создаем с помощью YQL-запроса https://a.yandex-team.ru/arc/trunk/arcadia/direct/jobs/src/main/java/ru/yandex/direct/jobs/export/CampaignsForBroadmatchExporter.java
    bmAllBanners.pl --generate banners --force

=cut

use strict;
use warnings;
use utf8;
use my_inc '..';

use Yandex::DateTime;
use Yandex::Shell;
use Yandex::YT::Table;

my $YT_CLUSTER;
BEGIN {
    $YT_CLUSTER = $ENV{YT_DIRECT_CLUSTER} // 'prod';
}

use Settings;
use ScriptHelper get_file_lock => ['dont_die', "bmAllBanners.$YT_CLUSTER"], 'Yandex::Log' => 'messages';
use Tools;
use EnvTools qw/is_beta/;

$log->msg_prefix("[$YT_CLUSTER]");

$log->out("start");

my @GENERATE;
my $FORCE;
my $MAX_CID;
extract_script_params(
    "force" => \$FORCE,
    "generate=s" => \@GENERATE,
    "max-cid=i" => \$MAX_CID,
);
@GENERATE = qw/banners/ if !@GENERATE;

my $export_path = 'export/bm';
my $tmp_path = 'tmp/bm';
if (is_beta()) {
    $export_path = "tmp/$ENV{USER}";
    $tmp_path = "tmp/$ENV{USER}";
}

Tools::force_set_yt_environment();
Yandex::YT::Table->new($_)->create("map_node") for $export_path, $tmp_path;


my $db_upload_time = Yandex::YT::Table->new('//home/direct/db/banners')->get_attribute('upload_time');
$log->out("db_upload_time=$db_upload_time");

my $stat_from_date = Yandex::DateTime->now()->subtract(days => 30)->strftime("%Y-%m-%d");

for my $gen (@GENERATE) {
    my $gen_tbl = Yandex::YT::Table->new("$export_path/bm_$gen/");
    if ($gen_tbl->exists() && ($gen_tbl->get_attribute('upload_time')//'') eq $db_upload_time && !$FORCE) {
        $log->out("table $gen already exists and up-to-date");
        juggler_ok(service_suffix => "$YT_CLUSTER.$gen", description => "table $gen already exists and up-to-date: $db_upload_time");
        next;
    }

    $log->out("start generate $gen");
    my $profile = Yandex::Trace::new_profile('yt:BmAllBanners');
    yash_system('pyt', '--path' => my_inc::path('.'),
                'Direct::YT::Export::BmAllBanners', $gen, 
                '-v', "export_path=$export_path",
                '-v', "tmp_path=$tmp_path",
                '-v', "stat_from_date=$stat_from_date",
                '-v', "db_upload_time=$db_upload_time",
                (defined $MAX_CID ? ('-v', "cids_range=[:$MAX_CID]") : ()),
    );
    $log->out("generate finished");

    juggler_ok(service_suffix => "$YT_CLUSTER.$gen");
}

$log->out("finish");
