#!/usr/bin/perl

use my_inc "..";


=head1 DESCRIPTION

Транспорт с БК

Документация: https://docs.yandex-team.ru/direct-dev/reference/bs-export-diag

=cut

# $Id$


=head1 METADATA

<crontab>
    ulimit: -v 20000000
    params: --par-id=std:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:2
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:3
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:4
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:5
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:6
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:7
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:8
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:9
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:10
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:11
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:12
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:13
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:14
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:15
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:16
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:17
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:18
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:19
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:20
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:21
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:22
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:23
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:24
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 20000000
    params: --par-id=std:25
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2400
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    params: --par-id=camp:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    params: --par-id=fast:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:2
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:3
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:4
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:5
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:6
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:7
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:8
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:9
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:10
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:11
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:12
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:13
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:14
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:15
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:16
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:17
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -v 21000000
    params: --par-id=heavy:18
    params_postfix: 2>&1 | tail -1000
    time: */7 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2800
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    params: --par-id=internal_ads:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
######################################## BUGGY
<crontab>
    params: --par-id=buggy:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    ulimit: -v 27000000
    <switchman>
        group: scripts-bs
        <leases>
            mem: 1600
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    params: --par-id=buggy:2
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    ulimit: -v 27000000
    <switchman>
        group: scripts-bs
        <leases>
            mem: 1600
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
######################################## SANDBOX
# Песочница пока cron only (БЕЗ switchman)
<crontab>
    params: --par-id=std:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    only_shards: 1
    package: scripts-sandbox
</crontab>
######################################## LIMTEST
# limtest'ы под switchman, но без групп, т.к. запуск разделен пакетами с кронтабами.
<crontab>
    params: --par-id=dev1:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
    </switchman>
    package: scripts-limtest1
</crontab>
<crontab>
    params: --par-id=dev2:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
    </switchman>
    package: scripts-limtest2
</crontab>
<crontab>
    params: --par-id=internal_ads_dev1:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
    </switchman>
    package: scripts-limtest1
</crontab>
<crontab>
    params: --par-id=internal_ads_dev2:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
    </switchman>
    package: scripts-limtest2
</crontab>
######################################## FULL LB EXPORT
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:1
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:2
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:3
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:4
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:5
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:6
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:7
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:8
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:9
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
<crontab>
    time: */4 * * * *
    params: --par-id=full_lb_export:10
    params_postfix: 2>&1 | tail -1000
    sharded: 1
    ulimit: -v 36000000
    <switchman>
        group: scripts-export
        <leases>
            FQDN_reexport.workers: 1:10
        </leases>
    </switchman>
    package: scripts-export
</crontab>
######################################## PREPROD
<crontab>
    params: --par-id=preprod:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
######################################## CAMPS_ONLY
<crontab>
    params: --par-id=camps_only:1
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    ulimit: -v 24000000
    <switchman>
        group: scripts-bs
        <leases>
            mem: 2200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>


=cut

=head1 NAME

    bsClientData.pl - экспорт данных в БК

=head1 DESCRIPTION

    Параметры запуска:
    --help - вывести справку
    --par-id=(NNN|NICK) - обрабатывать указанный поток
    --once - отработать одну итерацию и выйти
    --no-auto-buggy - отключить автоматическое перемещение кампаний в buggy-очередь
    Только для непродакшена:
    --no-send - не делать soap и logbroker запросы, писать реквесты в лог и прерывать выполнение
                (выводит на STDOUT в json-формате массив структур, содержащий uuid пригодный для запроса в java-ручку /bsexport/legacyLogs)
    --cid YYY - отправлять только указанную кампанию (можно указывать несколько раз)
                оптимизация для бет: если использовать только с одной кампанией, будет брать лок только по этой кампании
                в продакшене и для нескольких кампаний будет брать общий лок
    --no-logbroker - не отправлять данные в БК через logbroker
    --debug-mode - режим отладки чтения из базы и формирования запроса по продакшн-данным, подробнее ниже

=head2 DEBUG_MODE

    Специальный режим для случаев, когда нужно отладить падение экспорта
    при формировании запроса (например из-за битых данных в базе),
    или замерить потребление скриптом памяти. Реализован как ре-экспорт,
    т.е. берет кампанию целиком и без учета statusBsSynced.

    Также этот режим используется в B2B-тестах транспорта в регрессии.

    Пользуйтесь этим режимом только при крайней необходимости и с особой осторожностью (при конфигурации ro-prod).
    Работает только на бетах и только при указании --cid (кампании при этом могут отсутствовать в очереди).

    Пишет данные в тестовый логброкер, в остальном режим исключает пишущие операции (но это неточно!):
        - отправку метрик в ppclog.monitor_values
        - взятие sql-локов в базе
        - обновление записей в bs_export_queue
        - обновление statusBsSynced и прочих полей
    Также в нескольких местах исключается из join'а таблица bs_export_queue,
        вместо значений из нее подставляются разные заглушки.
    Как мера дополнительной предосторожности - подменяются адреса логброкера на тестовый логброкер и БК на некорректный адрес локалхоста.

    Перекрывает собой и включает следующие параметры:
        --par-id=full_lb_export:1
        --fake-bs
        --once

=head1 RUNNING

    Перезапускается при каждом обновлении Директ-пакетов, независимо от того, были ли изменения в самом скрипте bsClientData.pl

=cut

use Direct::Modern;

use JSON;
use List::Util qw/min max/;
# TODO: отпилить вместе с SOAP при переходе на http_parallel_request / http_fetch
use Net::INET6Glue::INET_is_INET6;

use Yandex::DBTools;
use Yandex::HashUtils;
use Yandex::Log;
use Yandex::Log::Messages;
use Yandex::ProcInfo;
use Yandex::TimeCommon;
use Yandex::Trace;
use Yandex::Validate qw/is_valid_id/;

use BalanceQueue;
use BS::Export ();
use BS::Export::Queues;
use BS::ExportQuery;
use BS::ExportWorker;
use EnvTools;
use JavaIntapi::SendMetricsToSolomon;
use LockTools;
use ScriptHelper 'Yandex::Log' => 'messages',
            get_file_lock => undef,
            script_timer => undef,
            sharded => 1;
use Settings;

=head1 SUBROUTINES/METHODS/VARIABLES

=cut

# граница, при достижении которой процессы будут перезапускаться по окончании итерации
my $PROC_MEMORY_LIMIT = 3500*1024*1024;
# для препрода (и buggy) - больше, чтобы не перезапускаться (потоков мало, теряем время)
my $PREPROD_PROC_MEMORY_LIMIT = 2 * $PROC_MEMORY_LIMIT;
my $LB_FULL_EXPORT_MEMORY_LIMIT = 12 * 1024 * 1024 * 1024;
# если отсутствует проперти задающее кол-во воркеров данного типа, запустить хотя бы один воркер
my $WORKERS_MIN_NUM_IF_PROP_IS_EMPTY = 1;
# процесс будет перезапущен, если указанное число итераций подряд - ничего не отправлял
use constant SKIPPED_ITERATIONS_LIMIT => 4;

# объекты, по которым считается суммарная статистика
my @ITERATION_OBJECT_STAT_FIELDS = (
    'camps',
    'contexts',
    'banners',
    'bids',
);

my $OPERATOR_UID = 1;
my $ExportQueues = \%BS::Export::Queues::QUEUES;

my $IGNORE;
my ($PAR_ID, $ONCE, $NO_SEND, $PAR_CID, @ONLY_CIDS, $NO_LOGBROKER, $DEBUG_MODE);
extract_script_params(
    'par-id=s' => \$PAR_ID,
    'once' => \$ONCE,
    'no-send' => \$NO_SEND,
    'no-auto-buggy' => \$BS::ExportWorker::DONT_MOVE_CAMPS_TO_BUGGY,
    'cid=i@' => \@ONLY_CIDS,
    'fake-bs' => \$IGNORE,
    'fake-bs-url-data=s' => \$IGNORE,
    'no-logbroker' => \$NO_LOGBROKER,
    'debug-mode' => \$DEBUG_MODE,
);

if (is_production() && (defined $NO_SEND || defined $NO_LOGBROKER)) {
    die "Options --no-send, --fake-bs, --fake-bs-url-data, --no-logbroker prohibited for production";
}

if (@ONLY_CIDS) {
    for my $cid (@ONLY_CIDS) {
        die "--cid $cid is invalid - value must be positive integer" unless is_valid_id($cid);
    }
}

if ($DEBUG_MODE) {
    die "--debug-mode available only with specified cids" unless @ONLY_CIDS;
    die "--debug-mode available only on betas" unless $ScriptHelper::is_beta;
    $PAR_ID = "full_lb_export:1";
    $ONCE = 1;
    $Settings::BS_HOST_FAKE = '127.0.0.300';
    # в debug режиме всегда используется тестовый логброкер
    $BS::Export::LOGBROKER_HOST = 'lbkxt.logbroker.yandex.net';
}

# переводим nick в id
my $PAR_ID_BY_NICK = BS::Export::Queues::get_par_id_by_nick();
if (defined $PAR_ID && $PAR_ID !~ /^\d+$/) {
    die "Incorrect par-id: $PAR_ID" if !exists $PAR_ID_BY_NICK->{$PAR_ID};
    $PAR_ID = $PAR_ID_BY_NICK->{$PAR_ID};
}
if (defined $PAR_ID && !exists $ExportQueues->{$PAR_ID}) {
    die "incorrect par-id: $PAR_ID";
}
unless (defined $PAR_ID) {
    die "Usage: $0 [--par-id=NNN] [--once] --shard-id=YYY";
}
my $PAR_TYPE = $ExportQueues->{$PAR_ID}{type};
my $IS_PREPROD = $ExportQueues->{$PAR_ID}->{preprod};
my $FORCED_USE_PREPROD = 0;

if ($ExportQueues->{$PAR_ID}->{logbroker_only}) {
    if (!is_beta() && $NO_LOGBROKER) {
        die "Can't work as logbroker_only with disabled log-broker sending";
    }
}

my $script_name = get_script_name();

# лочим файлик
if (!@ONLY_CIDS) {
    get_file_lock('dont_die', $script_name . ".$PAR_ID.lock");
}

$BS::ExportWorker::LOG_FILE_PREFIX = "bsexport.shard_$SHARD";

my $DB2 = $ExportQueues->{$PAR_ID}->{db_ref}->(shard => $SHARD);

my $skip_locked_wallets_prop = Property->new(BS::Export::SKIP_LOCKED_WALLETS_PROP_NAME);

# свойство, в котором находится ограничение количества воркеров нашего типа
# для препрод-потоков ограничения нет.
my $workers_num_prop = !$IS_PREPROD && BS::Export::has_par_type_workers_num_prop($PAR_TYPE)
    ? Property->new(BS::Export::get_workers_num_prop_name($PAR_TYPE, $SHARD))
    : undef;
# счетчик пропущенных итераций
my $skipped_iterations = 0;

my $PREPROD_TRACE_TAG = $IS_PREPROD ? 'preprod' : 'prod';
my $PAR_NORM_NICK = "$ExportQueues->{$PAR_ID}{type}_$ExportQueues->{$PAR_ID}{order}";
my $juggler_service_suffix = is_sandbox() ? 'sandbox.' : '';

$log->msg_prefix("[shard_$SHARD,par_$PAR_NORM_NICK]");
$log->out({START => \@ScriptHelper::ORIGINAL_ARGV});
my $log_error = Yandex::Log::Messages->new();

my $error_logger = sub {
    my $data = shift;
    my %predefined_data = (
        shard => $SHARD,
        par_type => $PAR_TYPE,
        par_norm_nick => $PAR_NORM_NICK,
    );
    if (ref $data ne 'ARRAY'){
        $data = [$data];
    }
    $log_error->bulk_out('errors' => [map {hash_merge({}, $_, \%predefined_data)} @$data]);
};

if (is_sandbox()) {
    $log->out("Don't use logbroker in sandbox");
    $NO_LOGBROKER = 1;
}

while (1) {
    my $trace = Yandex::Trace->new(service => 'direct.script', method => 'bsClientData', tags => "shard_$SHARD,par-id_$PAR_ID");

    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason! Exiting.");
        exit 0;
    }

    my $dbh2 = connect_db($DB2);
    my $dbh = connect_db(PPC(shard => $SHARD));
    # TODO: хорошо бы делать это внутри one_bs_iteration "чтобы наверняка", так как в init'ах чистятся кеши.
    BS::ExportWorker::init(
        dbh => $dbh,
        dbh2 => $dbh2,
        parid => $PAR_ID,
        partype => $PAR_TYPE,
        par_norm_nick => $PAR_NORM_NICK,
        log => $log,
        error_logger => $error_logger,
        ignore_bs_synced => $ExportQueues->{$PAR_ID}->{ignore_bs_synced},
        debug_mode => $DEBUG_MODE,
        load_autobudget_restart => $ExportQueues->{$PAR_ID}->{dont_calculate_autobudget_restart},
        shard => $SHARD,
    );
    BS::ExportQuery::init(
        dbh2 => $dbh2,
        dbh => $dbh,
        parid => $PAR_ID,
        partype => $PAR_TYPE,
        log => $log,
        error_logger => $error_logger,
        ignore_bs_synced => $ExportQueues->{$PAR_ID}->{ignore_bs_synced},
        dont_calculate_autobudget_restart => $ExportQueues->{$PAR_ID}->{dont_calculate_autobudget_restart},
        shard => $SHARD,
    );
    $BS::ExportWorker::LogBrokerBuffer::LOG = $log;

    my $global_start = time();
    my %lock_options;

    if (BS::ExportWorker::is_par_type('buggy')) {
        # в buggy-очереди отправляем кампании по одной
        $lock_options{limit} = 1;
        # и уменьшаем минимальное время итерации (так как запросы будут маленькие)
        $BS::ExportWorker::MIN_ITERATION_DURATION = 5;

        # про запас еще поднимаем память
        $PROC_MEMORY_LIMIT = $PREPROD_PROC_MEMORY_LIMIT;

        # подниманием лимиты на пачку, чтобы повысить шанс отправить кампанию целиком
        $BS::Export::MAX_ROWS_FOR_SNAPSHOT = 75_000;
        $BS::Export::BANNERS_LIMIT = 20_000;
        $BS::Export::CONTEXTS_LIMIT = 1_001;
        $BS::Export::BIDS_LIMIT = 100_000;
    } elsif (BS::ExportWorker::is_par_type('full_lb_export')) {
        $BS::Export::CAMPS_LIMIT = 40;
        $PROC_MEMORY_LIMIT = $LB_FULL_EXPORT_MEMORY_LIMIT;

        $BS::ExportWorker::LOG_FILE_PREFIX = "bs_full_lb_export.shard_$SHARD";

        $BS::Export::MAX_ROWS_FOR_SNAPSHOT = 500_000; # если кампания максимальной "жирности" - влезет только 10
    } elsif (BS::ExportWorker::is_par_type(qw/dev devprice internal_ads_dev/)) {
        $FORCED_USE_PREPROD = Property->new(BS::Export::PREPROD_LIMTEST_PROP_PREFIX.(substr $PAR_TYPE, -1))->get() // 0;
    } elsif (BS::ExportWorker::is_par_type('camps_only')) {
        # CAMPS_LIMIT по умолчанию равен 15_000, но можно уменьшить через пропертю
        # Крутить этот параметр стоит только в крайнем случае.
        # Размер пачки специально выбран таким большим, чтобы кампании одного клиента не уезжали в разных
        # SOAP запросах, чтобы суммы на кампаниях одного клиента отправлялись максимально близко друг к другу по времени.
        my $camps_limit_prop = int(Property->new('BS_CAMPS_ONLY_CAMPS_LIMIT')->get() // 15_000);
        $BS::Export::CAMPS_LIMIT = min(max($camps_limit_prop, 1), 15_000);
        $lock_options{limit} = $BS::Export::CAMPS_LIMIT;
        $BS::Export::MAX_ROWS_FOR_SNAPSHOT = $BS::Export::CAMPS_LIMIT;
    }

    $log->out("Let's start iteration...");

    # Лочимся (против параллельного запуска еще где-то этого же потока)
    # TODO: в свете перехода на switchman возможно таймаут нужно уменьшить
    my $lock_timeout = $ScriptHelper::is_beta ? 1 : 3600;
    my (@sql_lock_guards, @lock_names);
    if (scalar(@ONLY_CIDS) == 1) {
        push @lock_names, map { "BS_CLIENTDATA_CID_$_" } @ONLY_CIDS;
    } else {
        push @lock_names, $BS::ExportWorker::LOCK_NAME."_$PAR_ID";
    }
    for my $lock_name (@lock_names) {
        if ($DEBUG_MODE) {
            $log->out("Skip sql-lock $lock_name");
            next;
        }
        my $sql_lock_guard = eval { sql_lock_guard(PPC(shard => $SHARD), $lock_name, $lock_timeout) };
        if ($sql_lock_guard) {
            $log->out("Mysql lock $lock_name getted...");
        } else {
            $log->die("Can't obtain mysql lock $lock_name with timeout $lock_timeout: $@");
        }
        push @sql_lock_guards, $sql_lock_guard;
    }

    my $workers_limit = $workers_num_prop ? ($workers_num_prop->get() // $WORKERS_MIN_NUM_IF_PROP_IS_EMPTY) : undef;
    my (@uuid_update_data, $uuid_update_prices, $uuid_logbroker_full_export);
    my $description_for_juggler = '';
    my $iteration_failed_flag;

    if (@ONLY_CIDS) {
        $lock_options{cids} = \@ONLY_CIDS;
    }
    if (defined $workers_limit && $ExportQueues->{$PAR_ID}->{order} > $workers_limit) {
        # наш порядковый номер больше лимита, поэтому новых объектов лочить не будем
        # отправим только уже залоченные этим потоком объекты (если они есть)
        $log->out("Only locked objects will be processed due to balancing limits: $ExportQueues->{$PAR_ID}->{order} > $workers_limit");
        $lock_options{already_locked_only} = 1;
    }
    $lock_options{skip_locked_wallets} = $skip_locked_wallets_prop->get();

    my $lock_sub = !$DEBUG_MODE ? \&lock_campaigns_in_queue : \&fake_lock_campaigns_in_queue;
    my $result = $lock_sub->(%lock_options);
    my $camps = $result->{camps};
    if (keys %$camps) {
        $log->out("Let's wait master...");
        unless (wait_synchronization()) {
            unlock_campaigns($camps, all => [keys %$camps]);
            $log->die("Can't wait_master");
        }

        # получаем данные
        my $snapshot = BS::ExportWorker::get_snapshot(camps => $camps, only_cids => \@ONLY_CIDS);
        # устанавливаем словари
        BS::ExportQuery::set_global_variables($snapshot);

        if (BS::ExportWorker::is_par_type('full_lb_export')) {
            $uuid_logbroker_full_export = eval {
                lb_full_export_iteration(camps => $camps,
                                         no_send => $NO_SEND,
                                         data_arrayref => $snapshot->{data},
                                         no_logbroker => ($NO_LOGBROKER ? 1 : 0),
                                         select_time => $snapshot->{select_time},
                                         );
            };
            if (!$uuid_logbroker_full_export) {
                $iteration_failed_flag ||= 1;
                my $msg = "Failed to send full data to logbroker: $@";
                $log->out($msg =~ s{[\r\n]+}{ |}gr);
            }
        } else {
            # отправляем данные
            if (@{ $snapshot->{data} }) {
                @uuid_update_data = eval {
                    one_bs_iteration(camps => $camps,
                                     no_send => $NO_SEND,
                                     data_arrayref => $snapshot->{data},
                                     minus_geo => $snapshot->{minus_geo},
                                     no_logbroker => ($NO_LOGBROKER ? 1 : 0),
                                     select_time => $snapshot->{select_time},
                                    );
                };
                if (!@uuid_update_data && $@) {
                    $iteration_failed_flag ||= 1;
                    my $msg = "Failed to send data: $@";
                    $log->out($msg =~ s{[\r\n]+}{ |}gr);
                }
            }
        }

        BS::ExportWorker::actions_on_iteration_end($camps);
        $description_for_juggler ||= "Working";
        $skipped_iterations = 0;
    } elsif (@{$result->{cids_removed_from_specials}}) {
        $description_for_juggler ||= "Nothing sent, but deleted from specials";
        $skipped_iterations = 0;
    } elsif ($lock_options{already_locked_only}) {
        $description_for_juggler = "Nothing sent, skip other iterations due to balancing limits";
        $skipped_iterations = SKIPPED_ITERATIONS_LIMIT;
    } else {
        $description_for_juggler = "Nothing to send";
        ++$skipped_iterations;
    }

    # Отпускаем лок (хотя здесь это уже не так актуально)
    undef @sql_lock_guards;

    my $ela = time() - $global_start;
    $log->out("all_iteration - elapsed $ela sec");
    if ($iteration_failed_flag) {
        if ($ONCE) {
            # выходим с ненулевым кодом.
            exit 70;
        }
        if (BS::ExportWorker::is_par_type('buggy')) {
            # we alive
            juggler_warn(description => $description_for_juggler, service_suffix => "$juggler_service_suffix$PAR_NORM_NICK");
        }
    } else {
        juggler_ok(description => $description_for_juggler, service_suffix => "$juggler_service_suffix$PAR_NORM_NICK");
    }

    if ($ONCE) {
        my @result;
        push @result, { method  => 'UpdatePrices', uuid => [$uuid_update_prices], date => today(), shard => $SHARD } if $uuid_update_prices;
        push @result, { method  => 'UpdateData2', uuid => \@uuid_update_data, date => today(), shard => $SHARD } if @uuid_update_data;
        push @result, { method  => 'full_lb_export', uuid => [$uuid_logbroker_full_export], date => today(), shard => $SHARD } if $uuid_logbroker_full_export;
        $log->out({result_once => \@result});
        print STDOUT to_json(\@result);
        exit;
    } elsif (proc_memory() > $PROC_MEMORY_LIMIT) {
        # проверяем, не нужно ли перезапуститься
        $log->out("Process too large, lets exit: ".proc_status_str());
        exit;
    } elsif ($skipped_iterations >= SKIPPED_ITERATIONS_LIMIT) {
        # процесс ничего полезного не делал, выходим.
        $log->out("Process didn't sent anything $skipped_iterations iterations in a row, exiting");
        exit;
    }

    disconnect_all();

    if ($ela < $BS::ExportWorker::MIN_ITERATION_DURATION) {
        my $profile = Yandex::Trace::new_profile('bsClientData:sleep');
        sleep($BS::ExportWorker::MIN_ITERATION_DURATION - $ela);
    }
}

=head2 lb_full_export_iteration(%params)

    Код немного копипастен с one_bs_iteration в частях инициализации и логирования*.

    my @uuid_update_data = lb_full_export_iteration(camps => $camps,
                                                    no_send => $NO_SEND,
                                                    data_arrayref => $snapshot->{data},
                                                    );

    собирает из снэпшота запрос без ограничений на число объектов и отправляет только в LB.
    второй запрос игнорируется.

    Параметры именованные:
        camps               - ссылка на хеш со статистикой по отправляемым кампаниям,
                              результат lock_campaigns_in_queue
        no_send             - флаг, что запросы выполнять не нужно, при этом будет сформирован
                              только первый запрос.
        data_arrayref       - массив хешей с данными по кампаниям/группам/баннерам
        no_logbroker        - не посылать данные в logbroker
    Результат:
        $uuid               - текстовыq идентификатор запроса к БК.

=cut

sub lb_full_export_iteration {
    my %options = @_;
    my $camps = $options{camps} || {};
    my %iteration_stats;

    $log->out("Start lb_full_export_iteration");

    ### построение запроса к БК
    my ($query, %additional) = BS::ExportQuery::get_query(data_arrayref => $options{data_arrayref},
                                                          no_limits => 1,
                                                          );
    my $request_uuid = BS::Export::get_request_uuid($query);;
    # статистика по числу объектов в запросе
    hash_merge(\%iteration_stats, hash_cut($additional{quantity}, @ITERATION_OBJECT_STAT_FIELDS));
    # освобождаем кампании, которые не попали в выборку
    unlock_campaigns($camps, all => [grep { !exists $additional{campaigns_to_sync}->{$_} } keys %$camps]);

    BS::ExportWorker::log_data("par_id=$PAR_ID,uuid=$request_uuid,data_type=request", $query) if !EnvTools::is_production_but_not_roprod();
    ### / построение запроса к БК


    if ($options{no_send}) {
        $log->out("Skip sending data from request (UUID: $request_uuid) to logbroker - --no-send param defined");
        return $request_uuid;
    }

    if ($options{no_logbroker}) {
        $log->out("WARN: logbroker will NOT be used");
    }
    $log->out("Sending data request (UUID: $request_uuid) to logbroker");
    my %logbroker_options = (
            no_logbroker => $options{no_logbroker},
            actual_in_direct_db_at => $options{select_time},
            full_export_flag => 'full_export_flag',
            cid_to_engine_id => $additional{cid_to_engine_id},
    );
    my $success = eval {
        BS::ExportWorker::send_to_logbroker($SHARD, $query, $request_uuid, %logbroker_options);
        return 1;
    };
    if (!$success) {
        my $err = $@;
        save_lb_req_stat($err);
        $log->die("ERROR sending data from request (UUID: $request_uuid) to logbroker: $err");
    } else {
        save_lb_req_stat(undef, \%iteration_stats);
    }
    $log->out("Done sending data from request (UUID: $request_uuid) to logbroker");

    # помечаем кампании, которые отправили целиком
    my @camps_to_set_synced = grep {
                                    exists $additional{campaigns_to_sync}->{$_}
                                    && !exists $additional{campaigns_in_rest}->{$_}
                              } keys %$camps;
    set_sync_campaigns($camps, full => \@camps_to_set_synced);
    undef @camps_to_set_synced;

    set_banner_permalinks_sent_to_bs($SHARD, $query->{ORDER});

    $log->out("End of lb_full_export_iteration");

    return $request_uuid;
}

=head2 one_bs_iteration(%options)

    my @uuid_update_data = one_bs_iteration(camps => $camps,
                                            no_send => $NO_SEND,
                                            data_arrayref => $snapshot->{data},
                                            );

    собирает из снэпшота запрос (возможно два) к UpdateData2, делает их, обрабатывает ответ,
    возвращает массив UUID'ов сделанных к БК запросов.

    TODO: хорошо бы вынести функцию из скрипта в отдельный модуль (например BS::UpdateData2)
          из нее вытащить код, отвечающий за запрос к БК и поместить в BS::Export
          добавить фейковые пустые ответы для no-send, чтобы пытаться сделать второй запрос.

    Параметры именованные:
        camps               - ссылка на хеш со статистикой по отправляемым кампаниям,
                              результат lock_campaigns_in_queue
        no_send             - флаг, что запросы выполнять не нужно, при этом будет сформирован
                              только первый запрос.
        data_arrayref       - массив хешей с данными по кампаниям/группам/баннерам
        minus_geo           - хеш с выбранными из БД дыннами по минус-регионам баннеров
                              (соответствует глобальной переменной $MINUS_GEO)
        no_logbroker        - не посылать данные в logbroker
    Результат:
        @UUIDs              - массив текстовых идентификаторов запросов к БК.

=cut
sub one_bs_iteration {
    my %options = @_;
    my $camps = $options{camps} || {};
    my @UUIDs;
    my %iteration_stats;

    # тип отправки, используется для того, чтобы правильно разблокировать и удалять
    # кампании из очереди
    # camps_only тут означает, что если помимо кампании хотим отправлять данные (судя по флагу $camps->{$_}->{send_*}),
    # ее нельзя разблокировать. А если нужно отправить что-то кроме кампании (судя по статистике в очереди), ее нельзя
    # удалять из очереди.
    my $SEND_DATA_KIND;
    if (BS::ExportWorker::is_par_type('camps_only')) {
        $SEND_DATA_KIND = 'camps_only';
    } else {
        $SEND_DATA_KIND = 'camps_and_data';
    }

    $log->out("Start one_bs_iteration");

    ### построение первого запроса к БК
    my ($query, %additional) = BS::ExportQuery::get_query(data_arrayref => $options{data_arrayref},
                                                          );
    # не будем складывать UUID в ответ, если отправлять было нечего
    my $is_nonempty_query = %{$query->{ORDER}} ? 1 : 0;
    my $request_uuid = BS::Export::get_request_uuid($query);
    # статистика по числу объектов в запросе
    hash_merge(\%iteration_stats, hash_cut($additional{quantity}, @ITERATION_OBJECT_STAT_FIELDS));
    # освобождаем кампании, которые не попали в выборку
    unlock_campaigns($camps, $SEND_DATA_KIND => [grep { !exists $additional{campaigns_to_sync}->{$_} } keys %$camps]);

    BS::ExportWorker::log_data("par_id=$PAR_ID,uuid=$request_uuid,data_type=request", $query);
    ### / построение первого запроса к БК


    # ставим в ленивую очередь создание в Балансе новых заказов, чтобы точно было куда приходить откруткам
    if ((my @new_cids = keys %{ $additional{new_campaigns} }) && !BS::ExportWorker::is_par_type('internal_ads')) {
        $log->out('Adding new campaigns to balance_info_queue to be created in Balance: (' . join(',', @new_cids) . ')');
        BalanceQueue::add_to_balance_info_queue($OPERATOR_UID, cid => \@new_cids, BalanceQueue::PRIORITY_BS_EXPORT_NEW_CAMPAIGN);
    }

    if (@{ $additional{resync_banners_with_phrases} }) {
        BS::ExportWorker::resync_at_end($additional{resync_banners_with_phrases});
    }

    if ($options{no_send}) {
        $log->out("skip soap and logbroker requests - --no-send param defined");
        return $request_uuid;
    }

    if ($options{no_logbroker}) {
        $log->out("WARN: logbroker will NOT be used");
    }
    $log->out("Sending data from first request (UUID: $request_uuid) to logbroker");

    my %logbroker_options = (
            no_logbroker => $options{no_logbroker},
            actual_in_direct_db_at => $options{select_time},
            cid_to_engine_id => $additional{cid_to_engine_id},
    );
    my $success = eval {
        BS::ExportWorker::send_to_logbroker($SHARD, $query, $request_uuid, %logbroker_options);
        return 1;
    };
    if (!$success) {
        my $err = $@;
        save_lb_req_stat($err);
        $log->die("ERROR sending data from first request (UUID: $request_uuid) to logbroker, die: $err");
    } else {
        save_lb_req_stat(undef, $additional{quantity});
        $log->out("Done sending data from first request (UUID: $request_uuid) to logbroker");
    }

    BS::ExportQuery::drop_logbroker_only_keys($query);

    # промежуточные данные, необходимые для второго запроса
    # маппинг pid => ContextID
    my %CONTEXTS_EID2ID;
    # хеш, ключами которого являются номера кампаний, попавших во второй запрос
    my $campaigns_in_second_query = {};

    # Собираем маппу bid->image_id, где image_id - id скрытых картиночных баннеров, которые переданны в родительском bid
    my $bid_to_hidden_image_id = {};
    for my $pid_bid_to_image_id_as_one ( values %{$additional{cid_pid_bid_to_image_id_as_one}} ) {
        for my $bid_to_image_id_as_one ( values %{$pid_bid_to_image_id_as_one} ) {
            hash_merge( $bid_to_hidden_image_id, $bid_to_image_id_as_one );
        }
    }

    $log->out("update data in db after first request");
    BS::ExportWorker::do_response_actions_without_bssoap_data($query, %additional,
        contexts_eid2id => \%CONTEXTS_EID2ID,
        minus_geo => $options{minus_geo},
        bid_to_hidden_image_id => $bid_to_hidden_image_id,
    );

    ### построение второго ("включающего") запроса к БК
    my ($second_query, %second_additional) = BS::ExportQuery::get_second_query(
                                                data_arrayref => $additional{second_query_data},
                                                new_campaigns => $additional{new_campaigns},
                                                new_banners => $additional{new_banners},
                                                campaigns_to_sync => $additional{campaigns_to_sync},
                                                autobudget_restart_data => $additional{autobudget_restart_data},
                                                campaigns_in_second_query => $campaigns_in_second_query,
                                                contexts_eid2id => \%CONTEXTS_EID2ID,
                                                cid_pid_bid_to_image_id_as_one => $additional{cid_pid_bid_to_image_id_as_one},
                                                );

    # Убираем с заявки копии картиночных версий баннера, переданных в cid_pid_bid_to_image_id_as_one
    my $deleted_image_ids = BS::ExportQuery::change_query_with_single_ad_image(
                                $second_query,
                                cid_pid_bid_to_image_id_as_one => $additional{cid_pid_bid_to_image_id_as_one},
                            );
    if($second_additional{quantity}->{banners}) {
        $second_additional{quantity}->{banners} -= scalar @$deleted_image_ids;
    }

    my $second_request_uuid = BS::Export::get_request_uuid($second_query);


    # Продолжаем обработку первого ответа...
    # помечаем кампании, которые отправили целиком
    my @camps_to_set_synced = grep {
                                    exists $additional{campaigns_to_sync}->{$_}
                                    && !exists $additional{campaigns_in_rest}->{$_}
                                    && !exists $campaigns_in_second_query->{$_}
                              } keys %$camps;
    set_sync_campaigns($camps, $SEND_DATA_KIND => \@camps_to_set_synced);
    undef @camps_to_set_synced;

    set_banner_permalinks_sent_to_bs($SHARD, $query->{ORDER});

    # разлочиваем кампании с которыми больше ничего делать не будем.
    # кампании с ошибками или UnDone (!exists $additional{campaigns_to_sync}->{$_})
    # оставляем (для buggy) они будут разлочены после итерации в основном цикле
    my @camps_to_unlock = grep {
                                # ошибок не было
                                exists $additional{campaigns_to_sync}->{$_}
                                # нужно отправить что-то еще, что не попало в первый запрос
                                && exists $additional{campaigns_in_rest}->{$_}
                                # и нет данных для второго запроса
                                && !exists $campaigns_in_second_query->{$_}
                          } keys %$camps;
    unlock_campaigns($camps, $SEND_DATA_KIND => \@camps_to_unlock);
    undef @camps_to_unlock;
    # На этом первый запрос к БК завершен
    if ($is_nonempty_query) {
        push @UUIDs, $request_uuid;
    }

    if (%$campaigns_in_second_query && %$camps) {
        # есть что отправить вторым запросом
        $log->out("Continue one_bs_iteration");

        # Добавляем статистику по числу объектов во втором запросе
        $iteration_stats{$_} += $second_additional{quantity}->{$_} for qw/camps banners/;

        # Логируем второй запрос
        BS::ExportWorker::log_data("par_id=$PAR_ID,uuid=$second_request_uuid,data_type=request", $second_query);

        if ($options{no_logbroker}) {
            $log->out("WARN: logbroker will NOT be used");
        }
        $log->out("Sending data from second request (UUID: $second_request_uuid) to logbroker");

        my $success = eval {
            BS::ExportWorker::send_to_logbroker($SHARD, $second_query, $second_request_uuid, %logbroker_options);
            return 1;
        };
        if (!$success) {
            my $err = $@;
            save_lb_req_stat($err);
            $log->die("ERROR sending data from second request (UUID: $second_request_uuid) to logbroker, die: $err");
        } else {
            save_lb_req_stat(undef, $second_additional{quantity});
            $log->out("Done sending data from second request (UUID: $second_request_uuid) to logbroker");
        }

        BS::ExportQuery::drop_logbroker_only_keys($second_query);

        # Выполняем второй запрос
        $log->out("update data in db after second request");
        BS::ExportWorker::do_response_actions_without_bssoap_data($second_query,
            campaigns_to_sync => $additional{campaigns_to_sync},
            images_sent => $additional{images_sent},
            forcedly_stopped_camps => $additional{forcedly_stopped_camps},
            forcedly_stopped_banners => $additional{forcedly_stopped_banners},
            is_second_query => 1,
            minus_geo => $options{minus_geo},
            bid_to_hidden_image_id => $bid_to_hidden_image_id,
        );

        # помечаем кампании, которые отправили целиком
        @camps_to_set_synced = grep {
                                        exists $additional{campaigns_to_sync}->{$_}
                                        && !exists $additional{campaigns_in_rest}->{$_}
                               } keys %$camps;
        set_sync_campaigns($camps, $SEND_DATA_KIND => \@camps_to_set_synced);
        undef @camps_to_set_synced;

        set_banner_permalinks_sent_to_bs($SHARD, $query->{ORDER});

        # разлочиваем кампании с которыми больше ничего делать не будем.
        # кампании с ошибками или UnDone (!exists $additional{campaigns_to_sync}->{$_})
        # оставляем (для buggy) они будут разлочены после итерации в основном цикле
        @camps_to_unlock = grep {
                                    # ошибок не было
                                    exists $additional{campaigns_to_sync}->{$_}
                                    # нужно отправить что-то еще, что не попало в первый запрос
                                    && exists $additional{campaigns_in_rest}->{$_}
                           } keys %$camps;
        unlock_campaigns($camps, $SEND_DATA_KIND => \@camps_to_unlock);
        undef @camps_to_unlock;

        push @UUIDs, $second_request_uuid;
    } else {
        if (@{ $additional{second_query_data} }) {
            $log->out('first query has new objects, but there is no available data - skip second request');
        } elsif (%$campaigns_in_second_query && ! %$camps) {
            $log->out('got data for second query, but there is no stats in $camp - skip second request');
        } else {
            $log->out('first query has no new objects, skip second request');
        }
    }

    $log->out("End of one_bs_iteration");

    return @UUIDs;
}

sub _object_metrics {
    my ($stat, $labels) = @_;
    my @metrics;
    if (!$stat || ref $stat ne 'HASH') {
        return @metrics;
    }
    push @metrics, { name => "objects.sent", long_value => $stat->{camps} // 0, labels => { %$labels, object_type => 'order'} };
    push @metrics, { name => "objects.sent", long_value => $stat->{contexts} // 0, labels => { %$labels, object_type => 'context' } };
    push @metrics, { name => "objects.sent", long_value => $stat->{banners} // 0, labels => { %$labels, object_type => 'banner' } };
    push @metrics, { name => "objects.sent", long_value => $stat->{prices} // 0, labels => { %$labels, object_type => 'price' } };
    push @metrics, { name => "objects.sent", long_value => $stat->{bids} // 0, labels => { %$labels, object_type => 'bid' } };

    return @metrics;
}

sub save_lb_req_stat {
    my ($err, $stat) = @_;
    return if $DEBUG_MODE;

    my $status;
    if (!$err) {
        $status = 'success';
    } elsif($err =~ "Too long data given to append") { # из LogBrokerBuffer.pm
        $status = 'client_error';
    } elsif ($err =~ /inc_bsexport_iter_id/) {
        # наша ошибка запроса в базу, до запроса в logbroker не дошли, поэтому не учитываем в статистике
        return;
    } else {
        $status = 'server_error';
    }
    my %labels = (external_system => "yabs", sub_system => "direct-banners-log");
    my @metrics = ({ name => "reqs.count", long_value => 1, labels => { %labels, interpreted_status => $status }});
    push @metrics, _object_metrics($stat, \%labels);

    JavaIntapi::SendMetricsToSolomon->new(items => \@metrics)->call();
}


# аналог BS::ExportWorker::lock_campaigns_in_queue, возвращает переданные cid'ы будто они и залочены для ре-экспорта
sub fake_lock_campaigns_in_queue {
    my (%options) = @_;

    my $locked = {};
    for my $cid (@{$options{cids}}) {
        $locked->{$cid} = { cid => $cid, sync_val => 999, is_full_export => 1, send_full => 1 };
        for my $f (qw/prices_num camps_num banners_num contexts_num bids_num/) {
            $locked->{$cid}->{$f} = 0;
        }
    }

    return {
        camps => $locked,
        cids_removed_from_specials => [],
    }
}
