#!/usr/bin/perl

=head1 METADATA

<crontab>
    params_postfix: 2>&1 | tail -1000
    time: */2 * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 100
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    tag: direct_group_internal_systems
    <notification>
        template: on_status_change
        status: CRIT
        status: OK
        method: telegram
        login: DISMonitoring
    </notification>
</juggler>

#TODO: когда-то экспорт в песочнице тоже мониторился. восстановить.
=cut

=head1 NAME

    bsExportMonitor.pl - отправка показателей экспорта в системы мониторинга

=head1 DESCRIPTION

    Опции:
    --shard-id  - номер шарда для обработки
    --once      - сделать одну итерацию и выйти
    --help      - справка

=cut

use Direct::Modern;

use Time::HiRes ();

use Yandex::Advmon;

use my_inc "..";

use BS::ExportMaster;
use BS::Export ();
use Property;
use ScriptHelper 'Yandex::Log' => 'messages', sharded => 1;

=head1 SUBROUTINES/METHODS/VARIABLES

=head2 $MIN_ITERATION_DURATION

    минимальное время итерации
    если итерация закончилась быстрее - делаем sleep
    кроме того используется для округления времени источника данных перед отправкой в графит

=cut

my $MIN_ITERATION_DURATION = 1 * 60;

=head2 $ITERATION_START_SECOND

    сдвиг относительно округленного до $MIN_ITERATION_DURATION времени, до которого будем спать,
    если отработали быстрее, чем $MIN_ITERATION_DURATION

=cut

my $ITERATION_START_SECOND = 21;

my $ONCE;
extract_script_params(
    'once' => \$ONCE,
);

$log->out("START");

while (1) {
    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason! Exiting.");
        exit 0;
    } else {
        restart_tracing();
    }

    $log->out('calc queue stats');
    my $queue_stats_time = time();
    my $queue_stats = BS::ExportMaster::calc_queue_stats(shard => $SHARD);

    # балансируем потоки std / heavy
    $log->out('calc workers count');

    my $is_workers_num_manual_control_enabled = BS::Export::get_bsexport_workers_num_controlled_manually;

    $log->out({'is workers num controlled manually' => $is_workers_num_manual_control_enabled});

    my $workers_num;
    if ($is_workers_num_manual_control_enabled) {
        $workers_num = {map {$_ => Property->new(BS::Export::get_workers_num_prop_name($_, $SHARD))->get()} qw/std heavy buggy/};
    } else {
        $workers_num = BS::ExportMaster::calc_suggested_workers_count(BS::ExportMaster::get_simple_stat($queue_stats, $SHARD));
    }
    $log->out({workers_num => $workers_num});
    my %workers_for_graphite;
    for my $type (keys %$workers_num) {
        if (BS::Export::has_par_type_workers_num_prop($type)) {
            $workers_for_graphite{$type}->{"shard_$SHARD"} = $workers_num->{$type};
            if (!$is_workers_num_manual_control_enabled) {
                Property->new(BS::Export::get_workers_num_prop_name($type, $SHARD))->set($workers_num->{$type});
            }
            
        }
    }

    # округляем вверх до $MIN_ITERATION_DURATION секунд
    my $time_for_graphite = int($queue_stats_time / $MIN_ITERATION_DURATION) * $MIN_ITERATION_DURATION;
    $time_for_graphite += $MIN_ITERATION_DURATION if $queue_stats_time % $MIN_ITERATION_DURATION;

    local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION, qw/flow bsexport/]};
    monitor_values({
        suggested_workers_count => \%workers_for_graphite,
    }, time => $time_for_graphite);

    last if $ONCE;
    juggler_ok();

    my $sleep_time = $time_for_graphite + $ITERATION_START_SECOND - Time::HiRes::time();
    if ($sleep_time > 0) {
        $log->out("sleep for $sleep_time seconds");
        Time::HiRes::sleep($sleep_time);
    }
}

$log->out("finish");
