#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    time: * * * * *
    sharded: 1
    <switchman>
        group: scripts-bs
        <leases>
            mem: 200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    time: * * * * *
    sharded: 1
    only_shards: 1
    package: scripts-sandbox
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl:     5m
    tag:    direct_group_internal_systems
    <notification>
        template: on_status_change
        status: OK
        status: CRIT
        method: telegram
        login: DISMonitoring
    </notification>
</juggler>

=cut

=head1 DESCRIPTION

    $Id$
    Опрос крутилки на предмет статуса активности заказов

=cut

use warnings;
use strict;

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

use Yandex::BSInfo;

use Settings;
use Yandex::DBTools;
use Common;
use Yandex::TimeCommon; 

use utf8;
use open ':std' => ':utf8';

my $STOP_TIMEOUT = 3 * 24 * 3600;

extract_script_params();

$log->out("start");

my $now = unix2mysql(time);
# получаем кампании для обстукивания
my %campaigns =
    map {$_->{cid} => $_}
    @{ get_all_sql(PPC(shard => $SHARD), "
            SELECT a.cid, a.send_time
                 , c.OrderID, c.archived
                 , c.statusActive
                 , c.statusShow
                 , co.stopTime
                 , $Common::CAMP_ACTIVE_SQL statusActive_new
              FROM camp_activization a
                   JOIN campaigns c on c.cid = a.cid
                   JOIN camp_options co on co.cid = c.cid
                   LEFT JOIN campaigns wc ON wc.cid = c.wallet_cid
             WHERE a.send_time > date_sub(now(), interval 7 day)
             ORDER BY send_time
        ") || []};
$log->out("todo ".scalar(keys %campaigns)." campaigns");

# получаем данные из БК
my $bs_status = bsinfo_orders_status_active([map {$_->{OrderID}} values %campaigns]);
$log->out("bs result for ".scalar(keys %$bs_status)." campaigns");

# смотрим, какие кампании можно апдейтить
my %act_del_cids;
my %update_cids;
for my $camp (values %campaigns) {
    if ($camp->{statusActive} eq $camp->{statusActive_new}) {
        # если менять статус не надо
        $act_del_cids{$camp->{cid}} = 1;
        next;
    }
    if (!exists $bs_status->{$camp->{OrderID}}
        && ($camp->{archived} eq 'Yes'
            || ($camp->{statusShow} eq 'No'
                && check_mysql_date($camp->{stopTime})
                && time - mysql2unix($camp->{stopTime}) > $STOP_TIMEOUT))
    ) {
        # если заказ заархивирован или остановлен больше трех дней назад - крутилка его не возвращает
        # https://st.yandex-team.ru/BSDEV-68765#1520343091000
        $camp->{statusActive_bs} = 'No';
        $update_cids{$camp->{cid}} = 1;
        $act_del_cids{$camp->{cid}} = 1;
        next;
    }
    next if !exists $bs_status->{$camp->{OrderID}};
    $camp->{statusActive_bs} = $bs_status->{$camp->{OrderID}} ? 'Yes' : 'No';
    if ($camp->{statusActive_bs} eq $camp->{statusActive_new}) {
        # если менять статус надо
        $update_cids{$camp->{cid}} = 1;
        $act_del_cids{$camp->{cid}} = 1;
    }
}

# обновляем campaigns.statusActive
$log->out("update campaigns: todo ".scalar(keys %update_cids));
my @ucids = sort {$a <=> $b} keys %update_cids;
$log->out(join ", ", @ucids);
while(my @chunk = splice @ucids, 0, 100) {
    do_sql(PPC(shard => $SHARD), "
        UPDATE campaigns c
     LEFT JOIN campaigns wc on wc.cid = c.wallet_cid
           SET c.statusActive = $Common::CAMP_ACTIVE_SQL,
               c.LastChange = NOW()
         WHERE c.cid in (".join(",", @chunk).")
           AND $Common::CAMP_ACTIVE_SQL = case c.cid "
                .join(" ", map {"when $_ then '$campaigns{$_}->{statusActive_bs}'"} @chunk)
                ." else null end
        " );
}

# чистим camp_activization
$log->out("clear camp_activization: todo ".scalar(keys %act_del_cids));
my @dcids = sort {$a <=> $b} keys %act_del_cids;
$log->out(join ", ", @dcids);
while(my @chunk = splice @dcids, 0, 100) {
    do_sql(PPC(shard => $SHARD), "
        DELETE FROM camp_activization
         WHERE cid in (".join(",", @chunk).")
           AND send_time < ?
        ", $now);
}

$log->out('Sending OK to juggler');
juggler_ok();

$log->out("finish");

