#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */5 * * * *
    <switchman>
        group: scripts-bs
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 20m
    tag: direct_group_internal_systems
</juggler>

<juggler_check>
    host:   checks_auto.direct.yandex.ru
    name:       direct.bsrank_stattime
    raw_events: direct.bsrank_stattime.production
    ttl:        4h
    tag: direct_group_internal_systems
</juggler_check>

=cut

# $Id$

=head1 NAME

    bsRankstatTime.pl
    получаем из БК время обновления 28-ми дневной статистики по торгам и записываем в БД

=cut

use Direct::Modern;

use Yandex::Advmon;
use Yandex::HTTP qw/http_fetch/;
use Yandex::TimeCommon;

use my_inc "..";

use Property;
use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;

$log->out('START');

my $update_time = http_fetch('GET' => $Settings::BS_EXPORT_PROXY_READONLY."export/bsrank_eventtime.cgi", undef, log => $log) || '';
$update_time =~ s/^\s+|\s+$//;

if (!defined $update_time || $update_time !~ /^\d{14}$/) {
    $log->die("Incorrect bs_rankstat_time: '$update_time'");
}

$log->out("Got: $update_time");

Property->new($Settings::BS_RANKSTAT_TIME_PROP)->set($update_time);
monitor_values({'bsrank.stattime' => mysql2unix($update_time)});

juggler_check(service => 'direct.bsrank_stattime',
              description => 'Отставание (в секундах) БК в обработке статистики',
              value => (time() - mysql2unix($update_time)),
              warn => 2*3600,
              crit => 4*3600,
);

juggler_ok();

$log->out('FINISH');
