#!/usr/bin/perl

use my_inc "..";


# $Id$

=head1 NAME

    checkModerate.pl

=head1 DESCRIPTION

    Скрипт для нахождения и исправления расхождений в ppc и модерации
    
    ./checkModerate.pl [--resend]
    
        "--resend" - если требуется исправить все ошибки, 
                        иначе просто покажет объявления.

=cut

use strict;
use warnings;

use ScriptHelper;

use Settings;
use Yandex::DBTools;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $resend = 0;

extract_script_params(
    'resend' => \$resend,
);

my $dbh_mod = connect_db('moddb');

# Получаем баннеры, которые ожидают модерации
my @bad_banners = @{ get_one_column_sql(PPC, "select bid 
                                                  from banners b 
                                                       inner join campaigns c on b.cid=c.cid 
                                                 where b.statusModerate='Sent' and c.statusEmpty='No' and b.statusArch = 'No' and c.archived = 'No'") || []
                                                };
if (@bad_banners) {
    my $ids = join(',', @bad_banners);
    my @bad_ids = get_bad_ids({type=>'banner'}, $ids);
    if (@bad_ids) {
        print STDERR "Bad banners bid in (".join (",", @bad_ids).")\n";
        _do_sql(PPC, "UPDATE banners set LastChange=LastChange, statusModerate='Ready', phoneflag=IF(vcard_id is not null, 'Ready', 'New') where bid in  (".join (",", @bad_ids).")");
    }
}

# Получаем контактную информацию, которая ожидает модерацию
my @bad_phones = @{ get_one_column_sql(PPC, "select bid 
                                                  from banners b 
                                                       left join vcards vc on vc.vcard_id = b.vcard_id
                                                       left join phrases p ON p.pid = b.pid
                                                       inner join campaigns c on p.cid=c.cid 
                                                 where b.phoneflag = 'Sent'
                                                       and vc.phone is not null
                                                       and b.statusModerate in ('Sent', 'Yes') 
                                                       and b.statusArch  = 'No'
                                                       and c.archived    = 'No'
                                                       and p.statusModerate in ('Sent', 'Yes')
                                                       and c.statusEmpty = 'No'") || []
                                                };
if (@bad_phones) {
    my $ids = join(',', @bad_phones);
    my @bad_ids = get_bad_ids({type=>'contactinfo'}, $ids);
    if (@bad_ids) {
        print STDERR "Bad contactinfo - bid in (".join (",", @bad_ids).")\n";
        _do_sql(PPC, "update banners set phoneflag=IF(vcard_id is not null, 'Ready', 'New'), LastChange=LastChange where bid in  (".join (",", @bad_ids).")");
    }
}

# Получаем условия, которые ожидают модерации
my @bad_phrases = @{ get_one_column_sql(PPC, "select pid 
                                                  from phrases p 
                                                       inner join banners b on b.bid=p.bid 
                                                       inner join campaigns c on b.cid=c.cid 
                                                 where p.statusModerate  = 'Sent' 
                                                       and b.statusArch  = 'No'
                                                       and c.archived    = 'No'
                                                       and c.statusEmpty = 'No'") || []
                                                };
if (@bad_phrases) {
    my $ids = join(',', @bad_phrases);
    my @bad_ids = get_bad_ids({type=>'phrases'}, $ids);
    if (@bad_ids) {
        print STDERR "Bad phrases pid in (".join (",", @bad_ids).")\n" ;
        _do_sql(PPC, "update phrases set statusModerate='Ready', LastChange=LastChange where pid in (".join (",", @bad_ids).")");
    }
}

#
### Медийка ###
#

# Получаем условия, которые ожидают модерации
my @bad_mbanners = @{ get_one_column_sql(PPC, "select mbid 
                                                  from media_banners mb 
                                                       inner join media_groups mg using(mgid)
                                                       inner join campaigns c using(cid)
                                                 where mb.statusModerate  = 'Sent' 
                                                       and mb.statusArch  = 'No'
                                                       and c.archived    = 'No'
                                                       and c.statusEmpty = 'No'") || []
                                                };
if (@bad_mbanners) {
    my $ids = join(',', @bad_mbanners);
    my @bad_ids = get_bad_ids({type=>'media_banner'}, $ids);
    if (@bad_ids) {
        print STDERR "Bad media banner mbid in (".join (",", @bad_ids).")\n" ;
        _do_sql(PPC, "update media_banners set statusModerate='Ready', LastChange=LastChange where mbid in (".join (",", @bad_ids).")");
    }
}

# Получаем условия, которые ожидают модерации
my @bad_mgroups = @{ get_one_column_sql(PPC, "select mgid 
                                                  from media_groups mg
                                                       inner join campaigns c using(cid)
                                                 where mg.statusModerate = 'Sent' 
                                                       and c.archived    = 'No'
                                                       and c.statusEmpty = 'No'") || []
                                                };
if (@bad_mgroups) {
    my $ids = join(',', @bad_mgroups);
    my @bad_ids = get_bad_ids({type=>'media_group'}, $ids);
    if (@bad_ids) {
        print STDERR "Bad media group mgid in (".join (",", @bad_ids).")\n" ;
        _do_sql(PPC, "update media_groups set statusModerate='Ready', LastChange=LastChange where mgid in (".join (",", @bad_ids).")");
    }
}

sub get_bad_ids 
{    
    my $options = shift;
    my $ids = shift;
    
    my ($idname, $tablename);
    
    if ($options->{type} eq 'banner') {
        ($idname, $tablename) = ('bid', 'mod_banners');
    } elsif ($options->{type} eq 'phrases') {
        ($idname, $tablename) = ('pid', 'mod_phrases');
    } elsif ($options->{type} eq 'contactinfo') {
        ($idname, $tablename) = ('kid', 'mod_contactinfo');
    } elsif ($options->{type} eq 'media_banner') {
        ($idname, $tablename) = ('mbid', 'mod_media_banners');
    } elsif ($options->{type} eq 'media_group') {
        ($idname, $tablename) = ('mgid', 'mod_media_groups');
    } else {
        warn "Error: Unknown object type - '$options->{type}'";
    }
    
    # получаем баннеры, которые были отправлены из модерации, но не пришли в Директ
    # т.е. statusModerate для последней записи = Sent
    my @bad_ids = @{ get_one_column_sql($dbh_mod, " SELECT r.$idname
                                                      FROM (
                                                           select max(id) as id
                                                             from $tablename
                                                            where $idname in ($ids) 
                                                            group by $idname
                                                           ) mr
                                                           join $tablename r on r.id = mr.id 
                                                     WHERE r.statusSync='Sent'
                                                           and r.statusModerate not in ('None')
                                                    ") || []
                                    };
    
    # Получаем баннеры, которые существуют в модерации
    my @exist_ids = @{ get_one_column_sql($dbh_mod, "select $idname
                                                       from $tablename
                                                      where $idname in ($ids)
                                                            and statusModerate not in ('Old')
                                                       ") || []
                                    };
    my %exist_ids = map {$_ => 1} @exist_ids;
    
    # Получаем баннеры, которые отосланы из Директа, но не пришли в модерацию
    push @bad_ids, grep {!$exist_ids{$_}} split /,/, $ids;
    
    return @bad_ids;
}

sub _do_sql
{
    if ($resend) {
        warn $_[1];
        do_sql(@_);
    }
}
