#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */10 * * * *
    <switchman>
        group: scripts-other
        <leases>
            mem: 80
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 1h
    tag: direct_group_internal_systems
    <notification>
        template: on_status_change
        status: OK
        status: WARN
        method: telegram
        login: DISMonitoring
    </notification>
</juggler>

=cut

=head1 NAME

# $Id$

=head1 DESCRIPTION

запускается по крону, получает из conv-db название целей(Используется для показа в статистике).

=cut

use Direct::Modern;

use JSON;

use Yandex::DateTime;
use Yandex::DBTools;
use Yandex::HTTP;
use Yandex::ListUtils;
use Yandex::ScalarUtils;
use Yandex::TVM2;

use my_inc "../..";

use Property;
use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;


use constant FETCH_TIMEOUT => 60;
my @METRICA_CHANGED_GOALS_NAMES_FIELDS = qw/goal_id name counter_status status goal_type parent_goal_id subgoal_index/;
my $chunk_size = 200_000;
my $max_offset_multiplier = int(1_000_000 / $chunk_size); # максимальный offset равен 1_000_000

$log->out('START');

# получить время последнего запуска
my $last_start_time_prop = new Property('update_orders_goal_name');
my $last_start_time = datetime($last_start_time_prop->get())->strftime("%Y-%m-%d") || 0;
$log->out("last_start_time: $last_start_time");
my $now = DateTime->today()->strftime("%Y-%m-%d %H:%M:%S");

$log->out('get tvm2 ticket');
my $ticket = eval{Yandex::TVM2::get_ticket($Settings::METRIKA_TVM2_ID)} or $log->die("Cannot get ticket for $Settings::METRIKA_TVM2_ID: $@");

my $maxed_out_chunks = undef;
for my $offset_multiplier (0 .. $max_offset_multiplier) {
    my $offset = $chunk_size * $offset_multiplier;
    #получить имена целей которые изменились со времени последнего запуска
    my $form_param = [
        last_time => $last_start_time,
        limit     => $chunk_size,
        offset    => $offset,
    ];
    my $goals = make_json_call($Settings::METRIKA_CHANGED_GOALS_NAMES_URL, $form_param, \@METRICA_CHANGED_GOALS_NAMES_FIELDS, $ticket);
    last unless @$goals;

    my @metrika_goals;
    foreach my $g (@{$goals}) {
        push @metrika_goals, [$g->{goal_id}
                        , $g->{name}
                        , $g->{counter_status}
                        , $g->{status}
                        , $g->{goal_type}
                        , $g->{parent_goal_id}
                        , $g->{subgoal_index}
                         ];
    }

    do_mass_insert_sql(PPCDICT, 'INSERT INTO metrika_goals (goal_id, name, counter_status, goal_status, goal_type, parent_goal_id, subgoal_index)
                             VALUES %s
                             ON DUPLICATE KEY UPDATE
                                name = values(name)
                                , counter_status = values(counter_status)
                                , goal_status = values(goal_status)
                                , goal_type = values(goal_type)
                                , parent_goal_id = values(parent_goal_id)
                                , subgoal_index = values(subgoal_index)
                            ',
                             \@metrika_goals);

    # обновить LAL-сегменты по статусам родителей
    foreach my $row (@{$goals}) {
        my $parent_id = $row ->{goal_id};
        my $status = $row->{status} eq 'Active' ? 1 : 0;


        do_update_table(PPCDICT, "lal_segments", {is_active => $status, sync_time__dont_quote => 'NOW()'}, where => {parent_goal_id => $parent_id});
    }

    for my $row (@metrika_goals) {
        $log->out($row);
    }
    $log->out("Processed offset $offset");
    $maxed_out_chunks = 1 if ($offset_multiplier == $max_offset_multiplier); # нам обещали, что всё влезет в первый чанк.
}

# обновить время
$last_start_time_prop->set($now);

if ($maxed_out_chunks) {
    my $warn_line = 'received maximum number of chunks, possible extra data was not queried';
    $log->warn($warn_line);
    juggler_warn(description => $warn_line);
} else {
    juggler_ok();
}
$log->out('FINISH');


sub make_json_call {
    my ($api_url, $form_param, $metrica_response_fields, $ticket) = @_;
 
    $log->out("Fetching new notify data from $api_url");
    my $resp = Yandex::HTTP::submit_form('POST', $api_url, $form_param, timeout => FETCH_TIMEOUT, headers => {'X-Ya-Service-Ticket' => $ticket});
    if ($resp->is_error) {
        my $response_code = $resp->code();
        my $response_status_line = $resp->status_line();
        my $url = Yandex::HTTP::make_url($api_url, $form_param);
        my $error = "Can't fetch statistic from $url. Got $response_code: $response_status_line";
        $log->die($error);
    }
    my $content = $resp->decoded_content;
    $log->out('Got ' . length($content) . ' characters from metrica');

    return unless $content;
    
    # разобрать ответ Метрики
    my $lines = decode_json($content);
    $log->out('Got ' . scalar @$lines . ' lines');
    #$log->out('Got data from metrica:');

    foreach my $line (@{$lines}) {
        my @fields = keys %{$line};
        # если не получили всех нужных полей
        my $delta_fields = xminus($metrica_response_fields, \@fields);
        if (@$delta_fields > 0) {
            $log->die({line => $line, delta_fields => $delta_fields, error => 'bad row from metrica: differences in fields'})
        }
        #$log->out($line);
    }

    return $lines;
}
