#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */20 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 60
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 1h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

$Id$
Скрипт для проверки счётчиков ДМО-кампаний

=cut

use Direct::Modern; 
use my_inc "../..";

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

use List::MoreUtils qw/uniq any none/;

use MetrikaIntapi;
use MetrikaCounters;
use Yandex::DBTools;
use RBAC2::Extended;

use Direct::Model::MetrikaCounter;
use Direct::Model::MetrikaCounter::Manager;

use Settings;

# workaround for: Can't call method "_put_session" on an undefined value at /usr/lib/perl5/AnyEvent/Handle.pm
# it's a race condition in the object destroying order
use Carp::Always;

my $ITERATION_SIZE = 200;


$log->out("START");

extract_script_params(
    'cid=s@' => \my @cids,
    'metrika-url=s' => \$MetrikaIntapi::METRIKA_INTAPI_URL,
);

my $rbac = RBAC2::Extended->get_singleton(1);
my %uid_counters;

iterate run_interval => { hours => 24, minutes => -20 }, sub {
    my $start_cid = shift || 0;
    my $counters = get_all_sql(PPC(shard => $SHARD), [
            'SELECT cid, uid, metrika_counter, is_deleted, has_ecommerce
            FROM campaigns_performance cp
            JOIN campaigns c USING(cid)
            JOIN metrika_counters mc USING(cid)',
            WHERE => {
                cid__ge => $start_cid,
                (@cids ? (cid => \@cids) : ()),
            },
            'ORDER BY cid',
            LIMIT => $ITERATION_SIZE,
        ]);
    $log->out(sprintf "got %d campaigns starting from $start_cid", scalar @$counters);
    return if !@$counters;

    $start_cid = $counters->[-1]->{cid} + 1;

    for my $counter (@$counters) {
        my $uid = $counter->{uid};
        $uid_counters{$uid} //= MetrikaCounters::get_all_uid_reps_counters($uid);
        $counter->{is_deleted_now} = 0 + none { $_ == $counter->{metrika_counter} } @{$uid_counters{$uid}};
    }

    my $counters_ecommerce = MetrikaCounters::check_counters_ecommerce([map { $_->{metrika_counter} } grep { !$_->{is_deleted_now} } @$counters]);

    my ($cache, @models);
    for my $counter (@$counters) {
        my $mc = Direct::Model::MetrikaCounter->from_db_hash($counter, \$cache);

        $mc->is_deleted($counter->{is_deleted_now});
        $mc->has_ecommerce($counters_ecommerce->{$mc->id});
        $mc->do_bs_sync_campaign(1) if $mc->is_is_deleted_changed;

        next if !$mc->is_changed;

        $log->out("updating cid=@{[$mc->campaign_id]}, counter=@{[$mc->id]}: is_deleted => @{[$mc->is_deleted]}, has_ecommerce => @{[$mc->has_ecommerce // '-']}");

        push @models, $mc;
    }

    Direct::Model::MetrikaCounter::Manager->new(items => \@models)->update();

    return $start_cid;
};

juggler_ok();

$log->out("FINISH");
