package geo_regions;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod

    

    geo_regions.pm

    Модуль geo_regions.pm -- генерируемый, вручную исправлять его не надо, надо исправлять шаблон data/t/regions/all_regions.tmpl.pm
    и запускать скрипт protected/mk_regions.pl для перегенерации pm-файла

=cut

use strict;
use utf8;

use Hash::Util;

# символьные обозначения некоторых важных регионов
our $RUS = 225;
our $UKR = 187;
our $KAZ = 159;
our $BY  = 149;
our $MSK_REGION = 1; # Московская область ( включая Москву ;) )
our $TR = 983; # Turkey
our $MOSCOW = 213;
our $KRIM = 977;
our $SNG = 166;
our $UZB = 171;
our $ASIA = 183;

# типы регионов
our $COUNTRY = 3;
our $CITY = 6;
our $OVERSEAS_TERRITORY = 12;

our @REGIONS_FOR_GEO_SUGGEST = (
    84, 93, 94, 95, 96, 102, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 134, 135, 137, 139, 149, 159, 167, 168, 169, 170, 171, 179, 180, 181, 203, 204, 205, 206, 207, 208, 209, 210, 211, 246, 977, 983, 994, 995, 1056, 10074, 10077, 10083, 10095, 10176, 10231, 10233, 10243, 10251, 10540, 10645, 10650, 10658, 10672, 10687, 10693, 10699, 10705, 10712, 10772, 10776, 10795, 10802, 10819, 10832, 10841, 10842, 10853, 10857, 10897, 10904, 10926, 10933, 10939, 10946, 10950, 10995, 11004, 11010, 11012, 11013, 11015, 11020, 11021, 11024, 11029, 11069, 11070, 11077, 11079, 11084, 11095, 11108, 11111, 11117, 11119, 11131, 11146, 11148, 11153, 11156, 11158, 11162, 11176, 11193, 11225, 11232, 11235, 11266, 11282, 11309, 11316, 11318, 11330, 11340, 11353, 11375, 11398, 11403, 11409, 11443, 11450, 11457, 20529, 20530, 20531, 20532, 20533, 20534, 20535, 20536, 20537, 20538, 20539, 20540, 20541, 20542, 20543, 20544, 20545, 20546, 20547, 20548, 20549, 20550, 20551, 20552, 20574, 20733, 20917, 20968, 20975, 21610, 21949, 29386, 29387, 29403, 29404, 29406, 29407, 29408, 29409, 29410, 29411, 29412, 29413, 29414, 29415, 29416, 29417, 29629, 29630, 29631, 29632, 29633, 29634
);


# список стран
our @COUNTRY_REGIONS = (
    
    
    { region_id => '84',  name_ru => 'США',  name_ua => 'США',  name_tr => 'ABD',  name_en => 'United States',     },
    { region_id => '93',  name_ru => 'Аргентина',  name_ua => 'Аргентина',  name_tr => 'Arjantin',  name_en => 'Argentina',     },
    { region_id => '94',  name_ru => 'Бразилия',  name_ua => 'Бразилія',  name_tr => 'Brezilya',  name_en => 'Brazil',     },
    { region_id => '95',  name_ru => 'Канада',  name_ua => 'Канада',  name_tr => 'Kanada',  name_en => 'Canada',     },
    { region_id => '96',  name_ru => 'Германия',  name_ua => 'Німеччина',  name_tr => 'Almanya',  name_en => 'Germany',     },
    { region_id => '102',  name_ru => 'Великобритания',  name_ua => 'Великобританія',  name_tr => 'Birleşik Krallık',  name_en => 'United Kingdom',     },
    { region_id => '113',  name_ru => 'Австрия',  name_ua => 'Австрія',  name_tr => 'Avusturya',  name_en => 'Austria',     },
    { region_id => '114',  name_ru => 'Бельгия',  name_ua => 'Бельгія',  name_tr => 'Belçika',  name_en => 'Belgium',     },
    { region_id => '115',  name_ru => 'Болгария',  name_ua => 'Болгарія',  name_tr => 'Bulgaristan',  name_en => 'Bulgaria',     },
    { region_id => '116',  name_ru => 'Венгрия',  name_ua => 'Угорщина',  name_tr => 'Macaristan',  name_en => 'Hungary',     },
    { region_id => '117',  name_ru => 'Литва',  name_ua => 'Литва',  name_tr => 'Litvanya',  name_en => 'Lithuania',     },
    { region_id => '118',  name_ru => 'Нидерланды',  name_ua => 'Нідерланди',  name_tr => 'Hollanda',  name_en => 'Netherlands',     },
    { region_id => '119',  name_ru => 'Норвегия',  name_ua => 'Норвегія',  name_tr => 'Norveç',  name_en => 'Norway',     },
    { region_id => '120',  name_ru => 'Польша',  name_ua => 'Польща',  name_tr => 'Polonya',  name_en => 'Poland',     },
    { region_id => '121',  name_ru => 'Словакия',  name_ua => 'Словаччина',  name_tr => 'Slovakya',  name_en => 'Slovakia',     },
    { region_id => '122',  name_ru => 'Словения',  name_ua => 'Словенія',  name_tr => 'Slovenya',  name_en => 'Slovenia',     },
    { region_id => '123',  name_ru => 'Финляндия',  name_ua => 'Фінляндія',  name_tr => 'Finlandiya',  name_en => 'Finland',     },
    { region_id => '124',  name_ru => 'Франция',  name_ua => 'Франція',  name_tr => 'Fransa',  name_en => 'France',     },
    { region_id => '125',  name_ru => 'Чехия',  name_ua => 'Чехія',  name_tr => 'Çek Cumhuriyeti',  name_en => 'Czech Republic',     },
    { region_id => '126',  name_ru => 'Швейцария',  name_ua => 'Швейцарія',  name_tr => 'İsviçre',  name_en => 'Switzerland',     },
    { region_id => '127',  name_ru => 'Швеция',  name_ua => 'Швеція',  name_tr => 'İsveç',  name_en => 'Sweden',     },
    { region_id => '134',  name_ru => 'Китай',  name_ua => 'Китай',  name_tr => 'Çin',  name_en => 'China',     },
    { region_id => '135',  name_ru => 'Южная Корея',  name_ua => 'Південна Корея',  name_tr => 'Güney Kore',  name_en => 'South Korea',     },
    { region_id => '137',  name_ru => 'Япония',  name_ua => 'Японія',  name_tr => 'Japonya',  name_en => 'Japan',     },
    { region_id => '139',  name_ru => 'Новая Зеландия',  name_ua => 'Нова Зеландія',  name_tr => 'Yeni Zelanda',  name_en => 'New Zealand',     },
    { region_id => '149',  name_ru => 'Беларусь',  name_ua => 'Білорусь',  name_tr => 'Beyaz Rusya',  name_en => 'Belarus',     },
    { region_id => '159',  name_ru => 'Казахстан',  name_ua => 'Казахстан',  name_tr => 'Kazakistan',  name_en => 'Kazakhstan',     },
    { region_id => '167',  name_ru => 'Азербайджан',  name_ua => 'Азербайджан',  name_tr => 'Azerbaycan',  name_en => 'Azerbaijan',     },
    { region_id => '168',  name_ru => 'Армения',  name_ua => 'Вірменія',  name_tr => 'Ermenistan',  name_en => 'Armenia',     },
    { region_id => '169',  name_ru => 'Грузия',  name_ua => 'Грузія',  name_tr => 'Gürcistan',  name_en => 'Georgia',     },
    { region_id => '170',  name_ru => 'Туркменистан',  name_ua => 'Туркменія',  name_tr => 'Türkmenistan',  name_en => 'Turkmenistan',     },
    { region_id => '171',  name_ru => 'Узбекистан',  name_ua => 'Узбекистан',  name_tr => 'Özbekistan',  name_en => 'Uzbekistan',     },
    { region_id => '179',  name_ru => 'Эстония',  name_ua => 'Естонія',  name_tr => 'Estonya',  name_en => 'Estonia',     },
    { region_id => '180',  name_ru => 'Сербия',  name_ua => 'Сербія',  name_tr => 'Sırbistan',  name_en => 'Serbia',     },
    { region_id => '181',  name_ru => 'Израиль',  name_ua => 'Ізраїль',  name_tr => 'İsrail',  name_en => 'Israel',     },
    { region_id => '187',  name_ru => 'Украина',  name_ua => 'Україна',  name_tr => 'Ukrayna',  name_en => 'Ukraine',     },
    { region_id => '203',  name_ru => 'Дания',  name_ua => 'Данія',  name_tr => 'Danimarka',  name_en => 'Denmark',     },
    { region_id => '204',  name_ru => 'Испания',  name_ua => 'Іспанія',  name_tr => 'İspanya',  name_en => 'Spain',     },
    { region_id => '205',  name_ru => 'Италия',  name_ua => 'Італія',  name_tr => 'İtalya',  name_en => 'Italy',     },
    { region_id => '206',  name_ru => 'Латвия',  name_ua => 'Латвія',  name_tr => 'Letonya',  name_en => 'Latvia',     },
    { region_id => '207',  name_ru => 'Киргизия',  name_ua => 'Киргизія',  name_tr => 'Kırgizistan',  name_en => 'Kyrgyzstan',     },
    { region_id => '208',  name_ru => 'Молдова',  name_ua => 'Молдова',  name_tr => 'Moldova',  name_en => 'Moldova',     },
    { region_id => '209',  name_ru => 'Таджикистан',  name_ua => 'Таджикистан',  name_tr => 'Tacikistan',  name_en => 'Tajikistan',     },
    { region_id => '210',  name_ru => 'Объединённые Арабские Эмираты',  name_ua => 'Об\'єднані Арабські Емірати',  name_tr => 'Birleşik Arap Emirlikleri',  name_en => 'United Arab Emirates',     },
    { region_id => '211',  name_ru => 'Австралия',  name_ua => 'Австралія',  name_tr => 'Avustralya',  name_en => 'Australia',     },
    { region_id => '225',  name_ru => 'Россия',  name_ua => 'Росія',  name_tr => 'Rusya',  name_en => 'Russia',     },
    { region_id => '246',  name_ru => 'Греция',  name_ua => 'Греція',  name_tr => 'Yunanistan',  name_en => 'Greece',     },
    { region_id => '983',  name_ru => 'Турция',  name_ua => 'Туреччина',  name_tr => 'Türkiye',  name_en => 'Turkey',     },
    { region_id => '994',  name_ru => 'Индия',  name_ua => 'Індія',  name_tr => 'Hindistan',  name_en => 'India',     },
    { region_id => '995',  name_ru => 'Таиланд',  name_ua => 'Таїланд',  name_tr => 'Tayland',  name_en => 'Thailand',     },
    { region_id => '1056',  name_ru => 'Египет',  name_ua => 'Єгипет',  name_tr => 'Mısır',  name_en => 'Egypt',     },
    { region_id => '10013',  name_ru => 'Ямайка',  name_ua => 'Ямайка',  name_tr => 'Jamaika',  name_en => 'Jamaica',     },
    { region_id => '10015',  name_ru => 'Боливия',  name_ua => 'Болівія',  name_tr => 'Bolivya',  name_en => 'Bolivia',     },
    { region_id => '10017',  name_ru => 'Куба',  name_ua => 'Куба',  name_tr => 'Küba',  name_en => 'Cuba',     },
    { region_id => '10020',  name_ru => 'Марокко',  name_ua => 'Марокко',  name_tr => 'Fas',  name_en => 'Morocco',     },
    { region_id => '10021',  name_ru => 'ЮАР',  name_ua => 'ПАР',  name_tr => 'Güney Afrika',  name_en => 'South Africa',     },
    { region_id => '10022',  name_ru => 'Сейшельские острова',  name_ua => 'Сейшельські острови',  name_tr => 'Seyşeller',  name_en => 'Seychelles',     },
    { region_id => '10023',  name_ru => 'Ливия',  name_ua => 'Лівія',  name_tr => 'Libya',  name_en => 'Libya',     },
    { region_id => '10024',  name_ru => 'Тунис',  name_ua => 'Туніс',  name_tr => 'Tunus',  name_en => 'Tunisia',     },
    { region_id => '10030',  name_ru => 'Фиджи',  name_ua => 'Фіджі',  name_tr => 'Fiji',  name_en => 'Fiji',     },
    { region_id => '10054',  name_ru => 'Албания',  name_ua => 'Албанія',  name_tr => 'Arnavutluk',  name_en => 'Albania',     },
    { region_id => '10057',  name_ru => 'Босния и Герцеговина',  name_ua => 'Боснія і Герцеговина',  name_tr => 'Bosna Hersek',  name_en => 'Bosnia and Herzegovina',     },
    { region_id => '10063',  name_ru => 'Ирландия',  name_ua => 'Ірландія',  name_tr => 'İrlanda',  name_en => 'Ireland',     },
    { region_id => '10064',  name_ru => 'Исландия',  name_ua => 'Ісландія',  name_tr => 'İzlanda',  name_en => 'Iceland',     },
    { region_id => '10067',  name_ru => 'Лихтенштейн',  name_ua => 'Ліхтенштейн',  name_tr => 'Liechtenstein',  name_en => 'Liechtenstein',     },
    { region_id => '10068',  name_ru => 'Северная Македония',  name_ua => 'Северна Македонія',  name_tr => 'Kuzey Makedonya',  name_en => 'North Macedonia',     },
    { region_id => '10069',  name_ru => 'Мальта',  name_ua => 'Мальта',  name_tr => 'Malta',  name_en => 'Malta',     },
    { region_id => '10070',  name_ru => 'Монако',  name_ua => 'Монако',  name_tr => 'Monako',  name_en => 'Monaco',     },
    { region_id => '10074',  name_ru => 'Португалия',  name_ua => 'Португалія',  name_tr => 'Portekiz',  name_en => 'Portugal',     },
    { region_id => '10077',  name_ru => 'Румыния',  name_ua => 'Румунія',  name_tr => 'Romanya',  name_en => 'Romania',     },
    { region_id => '10083',  name_ru => 'Хорватия',  name_ua => 'Хорватія',  name_tr => 'Hırvatistan',  name_en => 'Croatia',     },
    { region_id => '10088',  name_ru => 'Андорра',  name_ua => 'Андорра',  name_tr => 'Andorra',  name_en => 'Andorra',     },
    { region_id => '10089',  name_ru => 'Гибралтар',  name_ua => 'Гібралтар',  name_tr => 'Cebelitarık',  name_en => 'Gibraltar',     },
    { region_id => '10090',  name_ru => 'Афганистан',  name_ua => 'Афганістан',  name_tr => 'Afganistan',  name_en => 'Afghanistan',     },
    { region_id => '10091',  name_ru => 'Бангладеш',  name_ua => 'Бангладеш',  name_tr => 'Bengladei',  name_en => 'Bangladesh',     },
    { region_id => '10093',  name_ru => 'Вьетнам',  name_ua => 'В\'єтнам',  name_tr => 'Vietnam',  name_en => 'Vietnam',     },
    { region_id => '10095',  name_ru => 'Индонезия',  name_ua => 'Індонезія',  name_tr => 'Endonezya',  name_en => 'Indonesia',     },
    { region_id => '10097',  name_ru => 'Малайзия',  name_ua => 'Малайзія',  name_tr => 'Malezya',  name_en => 'Malaysia',     },
    { region_id => '10098',  name_ru => 'Мальдивы',  name_ua => 'Мальдіви',  name_tr => 'Maldivler',  name_en => 'Maldives',     },
    { region_id => '10099',  name_ru => 'Монголия',  name_ua => 'Монголія',  name_tr => 'Moğolistan',  name_en => 'Mongolia',     },
    { region_id => '10100',  name_ru => 'Мьянма',  name_ua => 'М\'янма',  name_tr => 'Myanmar',  name_en => 'Myanmar',     },
    { region_id => '10101',  name_ru => 'Непал',  name_ua => 'Непал',  name_tr => 'Nepal',  name_en => 'Nepal',     },
    { region_id => '10102',  name_ru => 'Пакистан',  name_ua => 'Пакистан',  name_tr => 'Pakistan',  name_en => 'Pakistan',     },
    { region_id => '10104',  name_ru => 'Северная Корея',  name_ua => 'Північна Корея',  name_tr => 'Kuzey Kore',  name_en => 'North Korea',     },
    { region_id => '10105',  name_ru => 'Сингапур',  name_ua => 'Сінгапур',  name_tr => 'Singapur',  name_en => 'Singapore',     },
    { region_id => '10108',  name_ru => 'Филиппины',  name_ua => 'Філіппіни',  name_tr => 'Filipinler',  name_en => 'Philippines',     },
    { region_id => '10109',  name_ru => 'Шри-Ланка',  name_ua => 'Шрі-Ланка',  name_tr => 'Sri Lanka',  name_en => 'Sri Lanka',     },
    { region_id => '10532',  name_ru => 'Бахрейн',  name_ua => 'Бахрейн',  name_tr => 'Bahreyn',  name_en => 'Bahrain',     },
    { region_id => '10535',  name_ru => 'Иордания',  name_ua => 'Йорданія',  name_tr => 'Ürdün',  name_en => 'Jordan',     },
    { region_id => '10536',  name_ru => 'Иран',  name_ua => 'Іран',  name_tr => 'İran',  name_en => 'Iran',     },
    { region_id => '10537',  name_ru => 'Кувейт',  name_ua => 'Кувейт',  name_tr => 'Kuveyt',  name_en => 'Kuwait',     },
    { region_id => '10538',  name_ru => 'Ливан',  name_ua => 'Ліван',  name_tr => 'Lübnan',  name_en => 'Lebanon',     },
    { region_id => '10540',  name_ru => 'Саудовская Аравия',  name_ua => 'Саудівська Аравія',  name_tr => 'Suudi Arabistan',  name_en => 'Saudi Arabia',     },
    { region_id => '10542',  name_ru => 'Сирия',  name_ua => 'Сирія',  name_tr => 'Suriye',  name_en => 'Syria',     },
    { region_id => '20271',  name_ru => 'Мексика',  name_ua => 'Мексика',  name_tr => 'Meksika',  name_en => 'Mexico',     },
    { region_id => '20274',  name_ru => 'Бруней',  name_ua => 'Бруней',  name_tr => 'Brunei',  name_en => 'Brunei',     },
    { region_id => '20572',  name_ru => 'Ирак',  name_ua => 'Ірак',  name_tr => 'Irak',  name_en => 'Iraq',     },
    { region_id => '20574',  name_ru => 'Кипр',  name_ua => 'Кіпр',  name_tr => 'Kıbrıs',  name_en => 'Cyprus',     },
    { region_id => '20733',  name_ru => 'Кот-д’Ивуар',  name_ua => 'Кот-д\'Івуар',  name_tr => 'Fildişi Sahilleri',  name_en => 'Côte d\'Ivoire',     },
    { region_id => '20736',  name_ru => 'Камерун',  name_ua => 'Камерун',  name_tr => 'Kamerun',  name_en => 'Cameroon',     },
    { region_id => '20739',  name_ru => 'Папуа-Новая Гвинея',  name_ua => 'Папуа – Нова Гвінея',  name_tr => 'Papua Yeni Gine',  name_en => 'Papua New Guinea',     },
    { region_id => '20741',  name_ru => 'Нигерия',  name_ua => 'Нігерія',  name_tr => 'Nijerya',  name_en => 'Nigeria',     },
    { region_id => '20746',  name_ru => 'Доминика',  name_ua => 'Домініка',  name_tr => 'Dominik',  name_en => 'Dominica',     },
    { region_id => '20747',  name_ru => 'Гуам',  name_ua => 'Гуам',  name_tr => 'Guam',  name_en => 'Guam',     },
    { region_id => '20754',  name_ru => 'Сент-Винсент и Гренадины',  name_ua => 'Сент-Вінсент і Гренадіни',  name_tr => 'Saint Vincent ve Grenadines',  name_en => 'Saint Vincent and the Grenadines',     },
    { region_id => '20762',  name_ru => 'Демократическая Республика Конго',  name_ua => 'Демократична Республіка Конго',  name_tr => 'Demokratik Kongo Cumhuriyeti',  name_en => 'Democratic Republic of the Congo',     },
    { region_id => '20764',  name_ru => 'Пуэрто-Рико',  name_ua => 'Пуерто-Ріко',  name_tr => 'Porto Riko',  name_en => 'Puerto Rico',     },
    { region_id => '20768',  name_ru => 'Эфиопия',  name_ua => 'Ефіопія',  name_tr => 'Etiyopya',  name_en => 'Ethiopia',     },
    { region_id => '20769',  name_ru => 'Сальвадор',  name_ua => 'Сальвадор',  name_tr => 'El Salvador',  name_en => 'El Salvador',     },
    { region_id => '20785',  name_ru => 'Эквадор',  name_ua => 'Еквадор',  name_tr => 'Ekvador',  name_en => 'Ecuador',     },
    { region_id => '20789',  name_ru => 'Сахарская Арабская Демократическая Республика',  name_ua => 'Сахарська Арабська Демократична Республіка',  name_tr => 'Batı Sahra',  name_en => 'Sahrawi Arab Democratic Republic',     },
    { region_id => '20790',  name_ru => 'Сан-Марино',  name_ua => 'Сан-Марино',  name_tr => 'San Marino',  name_en => 'San Marino',     },
    { region_id => '20802',  name_ru => 'Гана',  name_ua => 'Гана',  name_tr => 'Gana',  name_en => 'Ghana',     },
    { region_id => '20818',  name_ru => 'Гвинея',  name_ua => 'Гвінея',  name_tr => 'Gine',  name_en => 'Guinea',     },
    { region_id => '20826',  name_ru => 'Алжир',  name_ua => 'Алжир',  name_tr => 'Cezayir',  name_en => 'Algeria',     },
    { region_id => '20854',  name_ru => 'Мадагаскар',  name_ua => 'Мадагаскар',  name_tr => 'Madagaskar',  name_en => 'Madagascar',     },
    { region_id => '20856',  name_ru => 'Антигуа и Барбуда',  name_ua => 'Антигуа і Барбуда',  name_tr => 'Antik ve Barbuda',  name_en => 'Antigua and Barbuda',     },
    { region_id => '20860',  name_ru => 'Самоа',  name_ua => 'Самоа',  name_tr => 'Samua',  name_en => 'Samoa',     },
    { region_id => '20862',  name_ru => 'Чили',  name_ua => 'Чилі',  name_tr => 'Şili',  name_en => 'Chile',     },
    { region_id => '20869',  name_ru => 'Бенин',  name_ua => 'Бенін',  name_tr => 'Benin',  name_en => 'Benin',     },
    { region_id => '20915',  name_ru => 'Соломоновы острова',  name_ua => 'Соломонові острови',  name_tr => 'Solomon Adaları',  name_en => 'Solomon Islands',     },
    { region_id => '20917',  name_ru => 'Доминиканская Республика',  name_ua => 'Домініканська Республіка',  name_tr => 'Dominik Cumhuriyeti',  name_en => 'Dominican Republic',     },
    { region_id => '20954',  name_ru => 'Зимбабве',  name_ua => 'Зімбабве',  name_tr => 'Zimbabve',  name_en => 'Zimbabwe',     },
    { region_id => '20957',  name_ru => 'Судан',  name_ua => 'Судан',  name_tr => 'Sudan',  name_en => 'Sudan',     },
    { region_id => '20968',  name_ru => 'Гватемала',  name_ua => 'Гватемала',  name_tr => 'Guatemala',  name_en => 'Guatemala',     },
    { region_id => '20972',  name_ru => 'Лаос',  name_ua => 'Лаос',  name_tr => 'Laos',  name_en => 'Laos',     },
    { region_id => '20975',  name_ru => 'Камбоджа',  name_ua => 'Камбоджа',  name_tr => 'Kamboçya',  name_en => 'Cambodia',     },
    { region_id => '20989',  name_ru => 'Эритрея',  name_ua => 'Еритрея',  name_tr => 'Eritre',  name_en => 'Eritrea',     },
    { region_id => '20992',  name_ru => 'Парагвай',  name_ua => 'Парагвай',  name_tr => 'Paraguay',  name_en => 'Paraguay',     },
    { region_id => '21004',  name_ru => 'Мали',  name_ua => 'Малі',  name_tr => 'Mali',  name_en => 'Mali',     },
    { region_id => '21007',  name_ru => 'Центральноафриканская республика',  name_ua => 'Центральноафриканська Республіка',  name_tr => 'Orta Afrika Cumhuriyeti',  name_en => 'Central African Republic',     },
    { region_id => '21010',  name_ru => 'Гамбия',  name_ua => 'Гамбія',  name_tr => 'Gambiya',  name_en => 'Gambia',     },
    { region_id => '21019',  name_ru => 'Барбадос',  name_ua => 'Барбадос',  name_tr => 'Barbados',  name_en => 'Barbados',     },
    { region_id => '21042',  name_ru => 'Сент-Китс и Невис',  name_ua => 'Сент-Кітс і Невіс',  name_tr => 'Saint Kitts ve Nevis',  name_en => 'Saint Kitts and Nevis',     },
    { region_id => '21045',  name_ru => 'Экваториальная Гвинея',  name_ua => 'Екваторіальна Гвінея',  name_tr => 'Ekvator Ginesi',  name_en => 'Equatorial Guinea',     },
    { region_id => '21131',  name_ru => 'Коста-Рика',  name_ua => 'Коста-Рика',  name_tr => 'Kosta Rika',  name_en => 'Costa Rica',     },
    { region_id => '21137',  name_ru => 'Габон',  name_ua => 'Габон',  name_tr => 'Gabon',  name_en => 'Gabon',     },
    { region_id => '21143',  name_ru => 'Гвинея-Бисау',  name_ua => 'Гвінея-Бісау',  name_tr => 'Gine-Bissau',  name_en => 'Guinea-Bissau',     },
    { region_id => '21151',  name_ru => 'Малави',  name_ua => 'Малаві',  name_tr => 'Malavi',  name_en => 'Malawi',     },
    { region_id => '21156',  name_ru => 'Перу',  name_ua => 'Перу',  name_tr => 'Peru',  name_en => 'Peru',     },
    { region_id => '21165',  name_ru => 'Буркина-Фасо',  name_ua => 'Буркіна Фасо',  name_tr => 'Burkina Faso',  name_en => 'Burkina Faso',     },
    { region_id => '21171',  name_ru => 'Того',  name_ua => 'Того',  name_tr => 'Togo',  name_en => 'Togo',     },
    { region_id => '21175',  name_ru => 'Гондурас',  name_ua => 'Гондурас',  name_tr => 'Honduras',  name_en => 'Honduras',     },
    { region_id => '21182',  name_ru => 'Ангола',  name_ua => 'Ангола',  name_tr => 'Angola',  name_en => 'Angola',     },
    { region_id => '21184',  name_ru => 'Венесуэла',  name_ua => 'Венесуела',  name_tr => 'Venezuela',  name_en => 'Venezuela',     },
    { region_id => '21187',  name_ru => 'Тринидад и Тобаго',  name_ua => 'Тринідад і Тобаго',  name_tr => 'Trinidad ve Tobago',  name_en => 'Trinidad and Tobago',     },
    { region_id => '21191',  name_ru => 'Колумбия',  name_ua => 'Колумбія',  name_tr => 'Kolombiya',  name_en => 'Colombia',     },
    { region_id => '21196',  name_ru => 'Замбия',  name_ua => 'Замбія',  name_tr => 'Zambiya',  name_en => 'Zambia',     },
    { region_id => '21198',  name_ru => 'Республика Конго',  name_ua => 'Республіка Конго',  name_tr => 'Kongo',  name_en => 'Congo',     },
    { region_id => '21199',  name_ru => 'Сан-Томе и Принсипи',  name_ua => 'Сан-Томе і Принсіпі',  name_tr => 'Sao Tome ve Principe',  name_en => 'São Tomé and Príncipe',     },
    { region_id => '21203',  name_ru => 'Люксембург',  name_ua => 'Люксембург',  name_tr => 'Lüksemburg',  name_en => 'Luxembourg',     },
    { region_id => '21208',  name_ru => 'Танзания',  name_ua => 'Танзанія',  name_tr => 'Tanzanya',  name_en => 'Tanzania',     },
    { region_id => '21214',  name_ru => 'Бурунди',  name_ua => 'Бурунді',  name_tr => 'Burundi',  name_en => 'Burundi',     },
    { region_id => '21217',  name_ru => 'Намибия',  name_ua => 'Намібія',  name_tr => 'Namibya',  name_en => 'Namibia',     },
    { region_id => '21219',  name_ru => 'Сьерра-Леоне',  name_ua => 'Сьєрра-Леоне',  name_tr => 'Sierra Leone',  name_en => 'Sierra Leone',     },
    { region_id => '21223',  name_ru => 'Кения',  name_ua => 'Кенія',  name_tr => 'Kenya',  name_en => 'Kenya',     },
    { region_id => '21227',  name_ru => 'Сомали',  name_ua => 'Сомалі',  name_tr => 'Somali',  name_en => 'Somalia',     },
    { region_id => '21230',  name_ru => 'Уганда',  name_ua => 'Уганда',  name_tr => 'Uganda',  name_en => 'Uganda',     },
    { region_id => '21231',  name_ru => 'Никарагуа',  name_ua => 'Нікарагуа',  name_tr => 'Nikaragua',  name_en => 'Nicaragua',     },
    { region_id => '21235',  name_ru => 'Мозамбик',  name_ua => 'Мозамбік',  name_tr => 'Mozambik',  name_en => 'Mozambique',     },
    { region_id => '21239',  name_ru => 'Ботсвана',  name_ua => 'Ботсвана',  name_tr => 'Botsvana',  name_en => 'Botswana',     },
    { region_id => '21241',  name_ru => 'Маврикий',  name_ua => 'Маврикій',  name_tr => 'Mauritius',  name_en => 'Mauritius',     },
    { region_id => '21251',  name_ru => 'Эсватини',  name_ua => 'Свазіленд',  name_tr => 'Svaziland',  name_en => 'Swaziland',     },
    { region_id => '21261',  name_ru => 'Лесото',  name_ua => 'Лесото',  name_tr => 'Lesotho',  name_en => 'Lesotho',     },
    { region_id => '21278',  name_ru => 'Либерия',  name_ua => 'Ліберія',  name_tr => 'Liberya',  name_en => 'Liberia',     },
    { region_id => '21289',  name_ru => 'Уругвай',  name_ua => 'Уругвай',  name_tr => 'Uruguay',  name_en => 'Uruguay',     },
    { region_id => '21297',  name_ru => 'Коморские острова',  name_ua => 'Коморські острови',  name_tr => 'Komorlar',  name_en => 'Comoros',     },
    { region_id => '21299',  name_ru => 'Панама',  name_ua => 'Панама',  name_tr => 'Panama',  name_en => 'Panama',     },
    { region_id => '21321',  name_ru => 'Гаити',  name_ua => 'Гаїті',  name_tr => 'Haiti',  name_en => 'Haiti',     },
    { region_id => '21325',  name_ru => 'Багамские острова',  name_ua => 'Багамські острови',  name_tr => 'Bahamalar',  name_en => 'Bahamas',     },
    { region_id => '21326',  name_ru => 'Кабо-Верде',  name_ua => 'Кабо-Верде',  name_tr => 'Cape Verde',  name_en => 'Cape Verde',     },
    { region_id => '21330',  name_ru => 'Французская Полинезия',  name_ua => 'Французька Полінезія',  name_tr => 'Fransız Polinezyası',  name_en => 'French Polynesia',     },
    { region_id => '21331',  name_ru => 'Чад',  name_ua => 'Чад',  name_tr => 'Çad',  name_en => 'Chad',     },
    { region_id => '21339',  name_ru => 'Нигер',  name_ua => 'Нігер',  name_tr => 'Nijer',  name_en => 'Niger',     },
    { region_id => '21344',  name_ru => 'Суринам',  name_ua => 'Суринам',  name_tr => 'Surinam',  name_en => 'Suriname',     },
    { region_id => '21349',  name_ru => 'Мавритания',  name_ua => 'Мавританія',  name_tr => 'Moritanya',  name_en => 'Mauritania',     },
    { region_id => '21359',  name_ru => 'Ватикан',  name_ua => 'Ватикан',  name_tr => 'Vatikan Şehri',  name_en => 'Vatican City',     },
    { region_id => '21371',  name_ru => 'Руанда',  name_ua => 'Руанда',  name_tr => 'Ruanda',  name_en => 'Rwanda',     },
    { region_id => '21395',  name_ru => 'Сент-Люсия',  name_ua => 'Сент-Люсія',  name_tr => 'Saint Lucia',  name_en => 'Saint Lucia',     },
    { region_id => '21426',  name_ru => 'Гренада',  name_ua => 'Гренада',  name_tr => 'Grenada',  name_en => 'Grenada',     },
    { region_id => '21441',  name_ru => 'Сенегал',  name_ua => 'Сенегал',  name_tr => 'Senegal',  name_en => 'Senegal',     },
    { region_id => '21451',  name_ru => 'Французская Гвиана',  name_ua => 'Французька Гвіана',  name_tr => 'Fransız Guyanası',  name_en => 'French Guiana',     },
    { region_id => '21475',  name_ru => 'Джибути',  name_ua => 'Джибуті',  name_tr => 'Cibuti',  name_en => 'Djibouti',     },
    { region_id => '21477',  name_ru => 'Гайана',  name_ua => 'Гаяна',  name_tr => 'Guyana',  name_en => 'Guyana',     },
    { region_id => '21486',  name_ru => 'Катар',  name_ua => 'Катар',  name_tr => 'Katar',  name_en => 'Qatar',     },
    { region_id => '21534',  name_ru => 'Ангилья',  name_ua => 'Ангілья',  name_tr => 'Anguilla',  name_en => 'Anguilla',     },
    { region_id => '21536',  name_ru => 'Аруба',  name_ua => 'Аруба',  name_tr => 'Aruba',  name_en => 'Aruba',     },
    { region_id => '21538',  name_ru => 'Кюрасао',  name_ua => 'Кюрасао',  name_tr => 'Curaçao',  name_en => 'Curacao',     },
    { region_id => '21544',  name_ru => 'Белиз',  name_ua => 'Беліз',  name_tr => 'Belize',  name_en => 'Belize',     },
    { region_id => '21546',  name_ru => 'Бермудские Острова',  name_ua => 'Бермудські острови',  name_tr => 'Bermuda',  name_en => 'Bermuda',     },
    { region_id => '21550',  name_ru => 'Бутан',  name_ua => 'Бутан',  name_tr => 'Bhutan',  name_en => 'Bhutan',     },
    { region_id => '21551',  name_ru => 'Йемен',  name_ua => 'Ємен',  name_tr => 'Yemen',  name_en => 'Yemen',     },
    { region_id => '21553',  name_ru => 'Американские Виргинские острова',  name_ua => 'Американські Віргінські острови',  name_tr => 'ABD Virgin Adaları',  name_en => 'The United States Virgin Islands',     },
    { region_id => '21556',  name_ru => 'Вануату',  name_ua => 'Вануату',  name_tr => 'Vanatu',  name_en => 'Vanuatu',     },
    { region_id => '21559',  name_ru => 'Британские Виргинские острова',  name_ua => 'Британські Віргінські острови',  name_tr => 'İngiliz Virgin Adaları',  name_en => 'British Virgin Islands',     },
    { region_id => '21562',  name_ru => 'Восточный Тимор',  name_ua => 'Східний Тимор',  name_tr => 'Doğu Timor',  name_en => 'East Timor',     },
    { region_id => '21567',  name_ru => 'Гренландия',  name_ua => 'Гренландія',  name_tr => 'Grönland',  name_en => 'Greenland',     },
    { region_id => '21570',  name_ru => 'Каймановы острова',  name_ua => 'Кайманові острови',  name_tr => 'Cayman Adaları',  name_en => 'The Cayman Islands',     },
    { region_id => '21572',  name_ru => 'Кирибати',  name_ua => 'Кірибаті',  name_tr => 'Kiribati',  name_en => 'Kiribati',     },
    { region_id => '21574',  name_ru => 'Острова Кука',  name_ua => 'Острови Кука',  name_tr => 'Cook Adaları',  name_en => 'Cook Islands',     },
    { region_id => '21578',  name_ru => 'Маршалловы острова',  name_ua => 'Маршаллові острови',  name_tr => 'Marşal Adaları',  name_en => 'The Marshall Islands',     },
    { region_id => '21580',  name_ru => 'Федеративные Штаты Микронезии',  name_ua => 'Федеративні Штати Мікронезії',  name_tr => 'Mikronezya Federe Devletleri',  name_en => 'The Federated States of Micronesia',     },
    { region_id => '21582',  name_ru => 'Науру',  name_ua => 'Науру',  name_tr => 'Nauru',  name_en => 'Nauru',     },
    { region_id => '21584',  name_ru => 'Новая Каледония',  name_ua => 'Нова Каледонія',  name_tr => 'Yeni Kaledonya',  name_en => 'New Caledonia',     },
    { region_id => '21586',  name_ru => 'Оман',  name_ua => 'Оман',  name_tr => 'Umman',  name_en => 'Oman',     },
    { region_id => '21589',  name_ru => 'Палау',  name_ua => 'Палау',  name_tr => 'Palau',  name_en => 'Palau',     },
    { region_id => '21595',  name_ru => 'Тёркс и Кайкос',  name_ua => 'Тьоркс і Кайкос',  name_tr => 'Turks ve Caicos Adaları',  name_en => 'Turks and Caicos Islands',     },
    { region_id => '21599',  name_ru => 'Тонга',  name_ua => 'Тонга',  name_tr => 'Tonga',  name_en => 'Tonga',     },
    { region_id => '21601',  name_ru => 'Тувалу',  name_ua => 'Тувалу',  name_tr => 'Tuvalu',  name_en => 'Tuvalu',     },
    { region_id => '21610',  name_ru => 'Черногория',  name_ua => 'Чорногорія',  name_tr => 'Karadağ',  name_en => 'Montenegro',     },
    { region_id => '29385',  name_ru => 'Тайвань',  name_ua => 'Тайвань',  name_tr => 'Tayvan',  name_en => 'Taiwan',     },
    { region_id => '29386',  name_ru => 'Абхазия',  name_ua => 'Абхазія',  name_tr => 'Abhazya',  name_en => 'Abkhazia',     },
    { region_id => '29387',  name_ru => 'Южная Осетия',  name_ua => 'Південна Осетія',  name_tr => 'Güney Osetya',  name_en => 'South Ossetia',     },
    { region_id => '37176',  name_ru => 'Монтсеррат',  name_ua => 'Монтсеррат',  name_tr => 'Montserrat',  name_en => 'Montserrat',     },
    { region_id => '98539',  name_ru => 'Норфолк',  name_ua => 'Норфолк',  name_tr => 'Norfolk Adası',  name_en => 'Norfolk Island',     },
    { region_id => '98542',  name_ru => 'Ниуэ',  name_ua => 'Ніуе',  name_tr => 'Niue',  name_en => 'Niue',     },
    { region_id => '98552',  name_ru => 'Палестина',  name_ua => 'Палестина',  name_tr => 'Filistin Toprakları',  name_en => 'Palestinian Territory',     },
    { region_id => '101519',  name_ru => 'Фолклендские острова',  name_ua => 'Фолклендські острови',  name_tr => 'Falkland Adaları',  name_en => 'Falkland Islands',     },
    { region_id => '101521',  name_ru => 'Мартиника',  name_ua => 'Мартініка',  name_tr => 'Martinik',  name_en => 'Martinique',     },
    { region_id => '108137',  name_ru => 'Южный Судан',  name_ua => 'Південний Судан',  name_tr => 'Güney Sudan',  name_en => 'South Sudan',     },
    { region_id => '109724',  name_ru => 'Синт-Мартен',  name_ua => 'Сінт-Мартен',  name_tr => 'Sint Maarten',  name_en => 'Sint Maarten',     },
);




# хэш всех известных регионов
our %GEOREG = (
    
        
        0 => {
             name => 'Все', 
             ua_name => 'Всі', 
             tr_name => 'Tümü', 
             ename => 'All',             
             media => 1, 
             geo_flag => 0, 
             level => 0, 
                        
             parents => [  ], 
             childs => [ 225, 166, 111, 183, 241, 10002, 10003, 138 ], 
        },
        
        1 => {
             name => 'Москва и область', 
             ua_name => 'Москва та Московська область', 
             tr_name => 'Moskova ve Moskovskaya oblastı', 
             ename => 'Moscow and Moscow Oblast',             
             media => 1, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 213, 214, 215, 217, 219, 10716, 10717, 10725, 10729, 10734, 10745, 10747, 10754, 10758, 20523, 20571, 20576, 20728, 21619, 21621, 21630, 21635, 21641, 21647, 21735, 98580, 98581, 98582, 98584, 98585, 98586, 98587, 98588, 98590, 98591, 98593, 98594, 98595, 98596, 98597, 98598, 98599, 98602, 98604, 98605, 98606, 98607, 98608, 98611, 98614, 98615, 98617 ], 
        },
        
        10 => {
             name => 'Орёл', 
             ua_name => 'Орел', 
             tr_name => 'Orel', 
             ename => 'Orel',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10772 ], 
             childs => [  ], 
        },
        
        100005 => {
             name => 'Ашинский район', 
             ua_name => 'Ашинський район', 
             tr_name => 'Aşinski ilçesi', 
             ename => 'Ashinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [ 11196 ], 
        },
        
        10002 => {
             name => 'Северная Америка', 
             ua_name => 'Північна Америка', 
             tr_name => 'Kuzey Amerika', 
             ename => 'North America',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 84, 95, 20917, 20968 ], 
        },
        
        100020 => {
             name => 'Саткинский район', 
             ua_name => 'Саткінський район', 
             tr_name => 'Satkinski ilçesi', 
             ename => 'Satkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [ 11217 ], 
        },
        
        100028 => {
             name => 'Надымский район', 
             ua_name => 'Надимський район', 
             tr_name => 'Nadymski ilçesi', 
             ename => 'Nadymsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [ 11229 ], 
        },
        
        10003 => {
             name => 'Южная Америка', 
             ua_name => 'Південна Америка', 
             tr_name => 'Güney Amerika', 
             ename => 'South America',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 93, 94 ], 
        },
        
        100109 => {
             name => 'Нижнеудинский район', 
             ua_name => 'Нижньоудинський район', 
             tr_name => 'Nijneudinski ilçesi', 
             ename => 'Nizhneudinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 11268 ], 
        },
        
        100112 => {
             name => 'Тайшетский район', 
             ua_name => 'Тайшетський район', 
             tr_name => 'Tayşetski ilçesi', 
             ename => 'Tayshetsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 11270 ], 
        },
        
        100116 => {
             name => 'Усть-Кутский район', 
             ua_name => 'Усть-Кутський район', 
             tr_name => 'Ust-Kutski ilçesi', 
             ename => 'Ust-Kutsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 20097 ], 
        },
        
        100183 => {
             name => 'Барабинский район', 
             ua_name => 'Барабінський район', 
             tr_name => 'Barabinski İlçesi', 
             ename => 'Barabinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [ 20098 ], 
        },
        
        100189 => {
             name => 'Карасукский район', 
             ua_name => 'Карасуцький район', 
             tr_name => 'Karasukski İlçesi', 
             ename => 'Karasuksky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [ 20101 ], 
        },
        
        100244 => {
             name => 'Баргузинский район', 
             ua_name => 'Баргузинський район', 
             tr_name => 'Barguzinski ilçesi', 
             ename => 'Barguzin District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [ 21161 ], 
        },
        
        100278 => {
             name => 'Каргасокский район', 
             ua_name => 'Каргасоцький район', 
             tr_name => 'Kargasokski ilçesi', 
             ename => 'Kargasoksky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [ 21675 ], 
        },
        
        100280 => {
             name => 'Колпашевский район', 
             ua_name => 'Колпашевський район', 
             tr_name => 'Kolpaşevski ilçesi', 
             ename => 'Kolpashevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [ 11349 ], 
        },
        
        100398 => {
             name => 'Амурский район', 
             ua_name => 'Амурський район', 
             tr_name => 'Amur bölgesi', 
             ename => 'Amursky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [ 11451 ], 
        },
        
        100471 => {
             name => 'Красноармейск', 
             ua_name => 'Красноармійськ', 
             tr_name => 'Krasnoarmeysk', 
             ename => 'Krasnoarmeysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        10074 => {
             name => 'Португалия', 
             ua_name => 'Португалія', 
             tr_name => 'Portekiz', 
             ename => 'Portugal',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        10077 => {
             name => 'Румыния', 
             ua_name => 'Румунія', 
             tr_name => 'Romanya', 
             ename => 'Romania',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        10083 => {
             name => 'Хорватия', 
             ua_name => 'Хорватія', 
             tr_name => 'Hırvatistan', 
             ename => 'Croatia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        100944 => {
             name => 'Ашкелон', 
             ua_name => 'Ашкелон', 
             tr_name => 'Aşkelon', 
             ename => 'Ashkelon',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103904 ], 
             childs => [  ], 
        },
        
        10095 => {
             name => 'Индонезия', 
             ua_name => 'Індонезія', 
             tr_name => 'Endonezya', 
             ename => 'Indonesia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        101425 => {
             name => 'Маргилан', 
             ua_name => 'Маргілан', 
             tr_name => 'Mergilân', 
             ename => 'Margilan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        101524 => {
             name => 'Бекабад', 
             ua_name => 'Бекабад', 
             tr_name => 'Bekabat', 
             ename => 'Bekabad',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        101550 => {
             name => 'Ангрен', 
             ua_name => 'Ангрен', 
             tr_name => 'Angren', 
             ename => 'Angren',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105813, 189657 ], 
             childs => [  ], 
        },
        
        101738 => {
             name => 'Ингольштадт', 
             ua_name => 'Інгольштадт', 
             tr_name => 'Ingolstadt', 
             ename => 'Ingolstadt',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 96, 103750 ], 
             childs => [  ], 
        },
        
        10174 => {
             name => 'Санкт-Петербург и Ленинградская область', 
             ua_name => 'Санкт-Петербург і Ленінградська область', 
             tr_name => 'Saint-Petersburg ve Leningradskaya oblastı', 
             ename => 'Saint-Petersburg and Leningrad Oblast',             
             media => 1, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 2, 10891, 98620, 98621, 98622, 98623, 98624, 98625, 98626, 98629, 98630, 98631, 98632, 98633, 98634 ], 
        },
        
        101749 => {
             name => 'Кандалакшский район', 
             ua_name => 'Кандалакський район', 
             tr_name => 'Kandalakshski İlçesi', 
             ename => 'Kandalakshsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [ 10895 ], 
        },
        
        10176 => {
             name => 'Ненецкий автономный округ', 
             ua_name => 'Ненецький автономний округ', 
             tr_name => 'Nenets özerk okrugu', 
             ename => 'Nenets Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 10902 ], 
        },
        
        101761 => {
             name => 'Шахрисабз', 
             ua_name => 'Шахрисабз', 
             tr_name => 'Şehrisebz', 
             ename => 'Shahrisabz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105807 ], 
             childs => [  ], 
        },
        
        101987 => {
             name => 'Нерюнгринский район', 
             ua_name => 'Нерюнгрінський район', 
             tr_name => 'Neryungrinski İlçesi', 
             ename => 'Neryungrinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11443 ], 
             childs => [ 11437 ], 
        },
        
        102 => {
             name => 'Великобритания', 
             ua_name => 'Великобританія', 
             tr_name => 'Birleşik Krallık', 
             ename => 'United Kingdom',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104520 ], 
        },
        
        102089 => {
             name => 'Кобринский район', 
             ua_name => 'Кобринський район', 
             tr_name => 'Kobrinsky İlçesi', 
             ename => 'Kobrinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [ 26010 ], 
        },
        
        102103 => {
             name => 'Жлобинский район', 
             ua_name => 'Жлобінський район', 
             tr_name => 'Zhlobinsky İlçesi', 
             ename => 'Zhlobinsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26966 ], 
        },
        
        102104 => {
             name => 'Калинковичский район', 
             ua_name => 'Калинковицький район', 
             tr_name => 'Kalinovichsky İlçesi', 
             ename => 'Kalinovichsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 102235 ], 
        },
        
        102108 => {
             name => 'Мозырский район', 
             ua_name => 'Мозирський район', 
             tr_name => 'Mozirsky İlçesi', 
             ename => 'Mozirsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 21274 ], 
        },
        
        102112 => {
             name => 'Речицкий район', 
             ua_name => 'Речицький район', 
             tr_name => 'Rechitsky İlçesi', 
             ename => 'Rechitsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26008 ], 
        },
        
        102113 => {
             name => 'Рогачёвский район', 
             ua_name => 'Рогачовський район', 
             tr_name => 'Rogachevsky İlçesi', 
             ename => 'Rogachevsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26027 ], 
        },
        
        102114 => {
             name => 'Светлогорский район', 
             ua_name => 'Свєтлогорський район', 
             tr_name => 'Svetlogorsky İlçesi', 
             ename => 'Svetlogorsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26004 ], 
        },
        
        102118 => {
             name => 'Волковысский район', 
             ua_name => 'Волковиський район', 
             tr_name => 'Volkovisski İlçesi', 
             ename => 'Volkovisski District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26923 ], 
        },
        
        102125 => {
             name => 'Лидский район', 
             ua_name => 'Лідський район', 
             tr_name => 'Lidsky İlçesi', 
             ename => 'Lidsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 21144 ], 
        },
        
        102126 => {
             name => 'Мостовский район', 
             ua_name => 'Мостовський район', 
             tr_name => 'Mostovsky İlçesi', 
             ename => 'Mostovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26007 ], 
        },
        
        102127 => {
             name => 'Новогрудский район', 
             ua_name => 'Новогрудський район', 
             tr_name => 'Novogrudsky İlçesi', 
             ename => 'Novogrudsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26836 ], 
        },
        
        102131 => {
             name => 'Слонимский район', 
             ua_name => 'Слонімський район', 
             tr_name => 'Slonimsky İlçesi', 
             ename => 'Slonimsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26005 ], 
        },
        
        102132 => {
             name => 'Сморгонский район', 
             ua_name => 'Сморгонський район', 
             tr_name => 'Smorgonsky İlçesi', 
             ename => 'Smorgonsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26017 ], 
        },
        
        102136 => {
             name => 'Быховский район', 
             ua_name => 'Биховський район', 
             tr_name => 'Bykhovsky İlçesi', 
             ename => 'Bikhovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26021 ], 
        },
        
        102138 => {
             name => 'Горецкий район', 
             ua_name => 'Горецький район', 
             tr_name => 'Goretsky İlçesi', 
             ename => 'Goretsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26774 ], 
        },
        
        102141 => {
             name => 'Климовичский район', 
             ua_name => 'Климовицький район', 
             tr_name => 'Klimovichsky İlçesi', 
             ename => 'Klimovichsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26006 ], 
        },
        
        102144 => {
             name => 'Кричевский район', 
             ua_name => 'Кричевський район', 
             tr_name => 'Krichevsky İlçesi', 
             ename => 'Krichevsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26015 ], 
        },
        
        102149 => {
             name => 'Осиповичский район', 
             ua_name => 'Осиповицький район', 
             tr_name => 'Osipovichsky İlçesi', 
             ename => 'Osipovichsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26012 ], 
        },
        
        102154 => {
             name => 'Шкловский район', 
             ua_name => 'Шкловський район', 
             tr_name => 'Shklovsky İlçesi', 
             ename => 'Shklovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26016 ], 
        },
        
        102156 => {
             name => 'Борисовский район', 
             ua_name => 'Борисовський район', 
             tr_name => 'Borisovsky İlçesi', 
             ename => 'Borisovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 21193 ], 
        },
        
        102157 => {
             name => 'Вилейский район', 
             ua_name => 'Вілейський район', 
             tr_name => 'Vileysky İlçesi', 
             ename => 'Vileysky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26745 ], 
        },
        
        102159 => {
             name => 'Дзержинский район', 
             ua_name => 'Дзержинський район', 
             tr_name => 'Dzerzhinsky İlçesi', 
             ename => 'Dzerzhinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26018 ], 
        },
        
        102162 => {
             name => 'Крупский район', 
             ua_name => 'Крупський район', 
             tr_name => 'Krupsky İlçesi', 
             ename => 'Krupsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26022 ], 
        },
        
        102165 => {
             name => 'Молодечненский район', 
             ua_name => 'Молодечненський район', 
             tr_name => 'Molodechnensky İlçesi', 
             ename => 'Molodechnensky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26001 ], 
        },
        
        102169 => {
             name => 'Слуцкий район', 
             ua_name => 'Слуцький район', 
             tr_name => 'Slutsky İlçesi', 
             ename => 'Slutsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26951 ], 
        },
        
        102170 => {
             name => 'Солигорский район', 
             ua_name => 'Солігорський район', 
             tr_name => 'Salihorsky İlçesi', 
             ename => 'Salihorsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26003 ], 
        },
        
        102178 => {
             name => 'Верхнедвинский район', 
             ua_name => 'Верхньодвінський район', 
             tr_name => 'Verkhnedvinsky İlçesi', 
             ename => 'Verkhnedvinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26554 ], 
        },
        
        102180 => {
             name => 'Глубокский район', 
             ua_name => 'Глибоцький район', 
             tr_name => 'Gluboksky İlçesi', 
             ename => 'Gluboksky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26025 ], 
        },
        
        102186 => {
             name => 'Миорский район', 
             ua_name => 'Міорський район', 
             tr_name => 'Miorsky İlçesi', 
             ename => 'Myory District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 21271 ], 
        },
        
        102187 => {
             name => 'Оршанский район', 
             ua_name => 'Оршанський район', 
             tr_name => 'Orshansky İlçesi', 
             ename => 'Orshansky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 10276 ], 
        },
        
        102188 => {
             name => 'Полоцкий район', 
             ua_name => 'Полоцький район', 
             tr_name => 'Polotsky İlçesi', 
             ename => 'Polotsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 10275 ], 
        },
        
        102189 => {
             name => 'Поставский район', 
             ua_name => 'Поставський район', 
             tr_name => 'Pastavsky İlçesi', 
             ename => 'Pastavsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26026 ], 
        },
        
        102235 => {
             name => 'Калинковичи', 
             ua_name => 'Калинковичі', 
             tr_name => 'Kalinoviçi', 
             ename => 'Kalinovichi',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102104 ], 
             childs => [  ], 
        },
        
        10231 => {
             name => 'Республика Алтай', 
             ua_name => 'Республіка Алтай', 
             tr_name => 'Altay Cumhuriyeti', 
             ename => 'Altai Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 11319 ], 
        },
        
        10233 => {
             name => 'Республика Тыва', 
             ua_name => 'Республіка Тива', 
             tr_name => 'Tuva', 
             ename => 'Tyva Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 11333 ], 
        },
        
        10243 => {
             name => 'Еврейская автономная область', 
             ua_name => 'Єврейська автономна область', 
             tr_name => 'Yahudi Özerk Bölgesi', 
             ename => 'Jewish Autonomous Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 11393 ], 
        },
        
        102444 => {
             name => 'Северный Кавказ', 
             ua_name => 'Північний Кавказ', 
             tr_name => 'Kuzey Kafkasya Federal Bölgesi', 
             ename => 'North Caucasian Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11010, 11012, 11013, 11020, 11021, 11024, 11069 ], 
        },
        
        10251 => {
             name => 'Чукотский автономный округ', 
             ua_name => 'Чукотський автономний округ', 
             tr_name => 'Chukotka Özerk Bölgesi', 
             ename => 'Chukotka Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [  ], 
        },
        
        10253 => {
             name => 'Баку', 
             ua_name => 'Баку', 
             tr_name => 'Bakü', 
             ename => 'Baku',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 167 ], 
             childs => [  ], 
        },
        
        10258 => {
             name => 'Ванадзор', 
             ua_name => 'Ванадзор', 
             tr_name => 'Vanadzor', 
             ename => 'Vanadzor',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 168, 105794 ], 
             childs => [  ], 
        },
        
        10259 => {
             name => 'Гюмри', 
             ua_name => 'Гюмрі', 
             tr_name => 'Gümrü', 
             ename => 'Gyumri',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 168, 105795 ], 
             childs => [  ], 
        },
        
        10262 => {
             name => 'Ереван', 
             ua_name => 'Єреван', 
             tr_name => 'Erivan', 
             ename => 'Yerevan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        10274 => {
             name => 'Гродно', 
             ua_name => 'Гродно', 
             tr_name => 'Grodno', 
             ename => 'Grodno',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [  ], 
        },
        
        10275 => {
             name => 'Полоцк', 
             ua_name => 'Полоцьк', 
             tr_name => 'Polotsk', 
             ename => 'Polotsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102188 ], 
             childs => [  ], 
        },
        
        10276 => {
             name => 'Орша', 
             ua_name => 'Орша', 
             tr_name => 'Orsha', 
             ename => 'Orsha',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102187 ], 
             childs => [  ], 
        },
        
        10277 => {
             name => 'Тбилиси', 
             ua_name => 'Тбілісі', 
             tr_name => 'Tiflis', 
             ename => 'Tbilisi',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        10278 => {
             name => 'Батуми', 
             ua_name => 'Батумі', 
             tr_name => 'Batum', 
             ename => 'Batumi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 169, 122054 ], 
             childs => [  ], 
        },
        
        10285 => {
             name => 'Рустави', 
             ua_name => 'Руставі', 
             tr_name => 'Rustavi (Bostandere)', 
             ename => 'Rustavi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 169, 122062 ], 
             childs => [  ], 
        },
        
        10291 => {
             name => 'Атырау', 
             ua_name => 'Атирау', 
             tr_name => 'Atırav', 
             ename => 'Atyrau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29407 ], 
             childs => [  ], 
        },
        
        10295 => {
             name => 'Костанай', 
             ua_name => 'Костанай', 
             tr_name => 'Kostanay', 
             ename => 'Kostanai',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29412 ], 
             childs => [  ], 
        },
        
        10298 => {
             name => 'Петропавловск', 
             ua_name => 'Петропавловськ', 
             tr_name => 'Petropavl (Petropavlovsk)', 
             ename => 'Petropavlovsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29416 ], 
             childs => [  ], 
        },
        
        10300 => {
             name => 'Рудный', 
             ua_name => 'Рудний', 
             tr_name => 'Rudny', 
             ename => 'Rudny',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29412 ], 
             childs => [  ], 
        },
        
        10303 => {
             name => 'Талдыкорган', 
             ua_name => 'Талдикорган', 
             tr_name => 'Taldıkorgan', 
             ename => 'Taldikorgan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        10305 => {
             name => 'Уральск', 
             ua_name => 'Уральськ', 
             tr_name => 'Oral (Uralsk)', 
             ename => 'Uralsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29410 ], 
             childs => [  ], 
        },
        
        10306 => {
             name => 'Усть-Каменогорск', 
             ua_name => 'Усть-Каменогорськ', 
             tr_name => 'Öskemen (Ust-Kamenogorsk)', 
             ename => 'Ust-Kamenogorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29408 ], 
             childs => [  ], 
        },
        
        10308 => {
             name => 'Жезказган', 
             ua_name => 'Жезказган', 
             tr_name => 'Jezkazgan', 
             ename => 'Zhezkazgan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        10309 => {
             name => 'Бишкек', 
             ua_name => 'Бішкек', 
             tr_name => 'Bişkek', 
             ename => 'Bishkek',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 207 ], 
             childs => [  ], 
        },
        
        10310 => {
             name => 'Ош', 
             ua_name => 'Ош', 
             tr_name => 'Osh', 
             ename => 'Osh',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 207 ], 
             childs => [  ], 
        },
        
        10313 => {
             name => 'Кишинев', 
             ua_name => 'Кишинів', 
             tr_name => 'Kişinev', 
             ename => 'Kishinev',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 208 ], 
             childs => [  ], 
        },
        
        10328 => {
             name => 'Алмалык', 
             ua_name => 'Алмалик', 
             tr_name => 'Elmalık', 
             ename => 'Almalik',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        10329 => {
             name => 'Андижан', 
             ua_name => 'Андіжан', 
             tr_name => 'Andican', 
             ename => 'Andijan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105804 ], 
             childs => [  ], 
        },
        
        10330 => {
             name => 'Бухара', 
             ua_name => 'Бухара', 
             tr_name => 'Buhara', 
             ename => 'Bukhara',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105805 ], 
             childs => [  ], 
        },
        
        10331 => {
             name => 'Карши', 
             ua_name => 'Карші', 
             tr_name => 'Karşı', 
             ename => 'Karshi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105807 ], 
             childs => [  ], 
        },
        
        10332 => {
             name => 'Коканд', 
             ua_name => 'Коканд', 
             tr_name => 'Kokand', 
             ename => 'Kokand',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        10334 => {
             name => 'Самарканд', 
             ua_name => 'Самарканд', 
             tr_name => 'Semerkant', 
             ename => 'Samarkand',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105810 ], 
             childs => [  ], 
        },
        
        10335 => {
             name => 'Ташкент', 
             ua_name => 'Ташкент', 
             tr_name => 'Taşkent', 
             ename => 'Tashkent',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 171 ], 
             childs => [  ], 
        },
        
        10336 => {
             name => 'Фергана', 
             ua_name => 'Фергана', 
             tr_name => 'Fergana', 
             ename => 'Phergana',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        10337 => {
             name => 'Нукус', 
             ua_name => 'Нукус', 
             tr_name => 'Nukus', 
             ename => 'Nukus',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105816 ], 
             childs => [  ], 
        },
        
        10338 => {
             name => 'Термез', 
             ua_name => 'Термез', 
             tr_name => 'Termez', 
             ename => 'Termez',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105811 ], 
             childs => [  ], 
        },
        
        10347 => {
             name => 'Кривой Рог', 
             ua_name => 'Кривий Ріг', 
             tr_name => 'Krivoi Rog', 
             ename => 'Kryvyi Rih',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        10366 => {
             name => 'Мариуполь', 
             ua_name => 'Маріуполь', 
             tr_name => 'Mariupol', 
             ename => 'Mariupol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        103668 => {
             name => 'Провинция Агры', 
             ua_name => 'Агри', 
             tr_name => 'Ağrı', 
             ename => 'Agri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103669 => {
             name => 'Провинция Адана', 
             ua_name => 'Адана', 
             tr_name => 'Adana', 
             ename => 'Adana',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103670 => {
             name => 'Провинция Адыяман', 
             ua_name => 'Адияман', 
             tr_name => 'Adıyaman', 
             ename => 'Adiyaman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103671 => {
             name => 'Провинция Айдын', 
             ua_name => 'Айдин', 
             tr_name => 'Aydın', 
             ename => 'Aydin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103672 => {
             name => 'Провинция Аксарай', 
             ua_name => 'Аксарай', 
             tr_name => 'Aksaray', 
             ename => 'Aksaray',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103673 => {
             name => 'Провинция Амасья', 
             ua_name => 'Амасья', 
             tr_name => 'Amasya', 
             ename => 'Amasya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103674 => {
             name => 'Провинция Анкара', 
             ua_name => 'Анкара', 
             tr_name => 'Ankara', 
             ename => 'Ankara',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103675 => {
             name => 'Провинция Анталья', 
             ua_name => 'Анталья', 
             tr_name => 'Antalya', 
             ename => 'Antalya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103676 => {
             name => 'Провинция Ардахан', 
             ua_name => 'Ардахан', 
             tr_name => 'Ardahan', 
             ename => 'Ardahan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103677 => {
             name => 'Провинция Артвин', 
             ua_name => 'Артвін', 
             tr_name => 'Artvin', 
             ename => 'Artvin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103678 => {
             name => 'Провинция Афьонкарахисар', 
             ua_name => 'Афьонкарахісар', 
             tr_name => 'Afyonkarahisar', 
             ename => 'Afyonkarahisar',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103679 => {
             name => 'Провинция Байбурт', 
             ua_name => 'Байбурт', 
             tr_name => 'Bayburt', 
             ename => 'Bayburt',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103680 => {
             name => 'Провинция Балыкесир', 
             ua_name => 'Баликесір', 
             tr_name => 'Balıkesir', 
             ename => 'Balikesir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103681 => {
             name => 'Провинция Бартын', 
             ua_name => 'Бартин', 
             tr_name => 'Bartın', 
             ename => 'Bartin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103682 => {
             name => 'Провинция Батман', 
             ua_name => 'Батман', 
             tr_name => 'Batman', 
             ename => 'Batman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103683 => {
             name => 'Провинция Биледжик', 
             ua_name => 'Біледжик', 
             tr_name => 'Bilecik', 
             ename => 'Bilecik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103684 => {
             name => 'Провинция Бингёль', 
             ua_name => 'Бінґель', 
             tr_name => 'Bingöl', 
             ename => 'Bingol',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103685 => {
             name => 'Провинция Битлис', 
             ua_name => 'Бітліс', 
             tr_name => 'Bitlis', 
             ename => 'Bitlis',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103686 => {
             name => 'Провинция Болу', 
             ua_name => 'Болу', 
             tr_name => 'Bolu', 
             ename => 'Bolu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103687 => {
             name => 'Провинция Бурдур', 
             ua_name => 'Бурдур', 
             tr_name => 'Burdur', 
             ename => 'Burdur',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103688 => {
             name => 'Провинция Бурса', 
             ua_name => 'Бурса', 
             tr_name => 'Bursa', 
             ename => 'Bursa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103689 => {
             name => 'Провинция Ван', 
             ua_name => 'Ван', 
             tr_name => 'Van', 
             ename => 'Van',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        10369 => {
             name => 'Белая Церковь', 
             ua_name => 'Біла Церква', 
             tr_name => 'Belaya Tserkov', 
             ename => 'Bila Tserkva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20544 ], 
             childs => [  ], 
        },
        
        103690 => {
             name => 'Провинция Газиантеп', 
             ua_name => 'Газіантеп', 
             tr_name => 'Gaziantep', 
             ename => 'Gaziantep',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103691 => {
             name => 'Провинция Гиресун', 
             ua_name => 'Гіресун', 
             tr_name => 'Giresun', 
             ename => 'Giresun',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103692 => {
             name => 'Провинция Гюмюшхане', 
             ua_name => 'Ґюмюшхане', 
             tr_name => 'Gümüşhane', 
             ename => 'Gumushane',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103693 => {
             name => 'Провинция Денизли', 
             ua_name => 'Денізлі', 
             tr_name => 'Denizli', 
             ename => 'Denizli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103694 => {
             name => 'Провинция Диярбакыр', 
             ua_name => 'Діярбакир', 
             tr_name => 'Diyarbakır', 
             ename => 'Diyarbakir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103695 => {
             name => 'Провинция Дюздже', 
             ua_name => 'Дюздже', 
             tr_name => 'Düzce', 
             ename => 'Duzce',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103696 => {
             name => 'Провинция Зонгулдак', 
             ua_name => 'Зонгулдак', 
             tr_name => 'Zonguldak', 
             ename => 'Zonguldak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103697 => {
             name => 'Провинция Измир', 
             ua_name => 'Ізмір', 
             tr_name => 'İzmir', 
             ename => 'Izmir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103698 => {
             name => 'Провинция Йозгат', 
             ua_name => 'Йозгат', 
             tr_name => 'Yozgat', 
             ename => 'Yozgat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103699 => {
             name => 'Провинция Кайсери', 
             ua_name => 'Кайсері', 
             tr_name => 'Kayseri', 
             ename => 'Kayseri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103700 => {
             name => 'Провинция Карабюк', 
             ua_name => 'Карабюк', 
             tr_name => 'Karabük', 
             ename => 'Karabuk',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103701 => {
             name => 'Провинция Караман', 
             ua_name => 'Караман', 
             tr_name => 'Karaman', 
             ename => 'Karaman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103702 => {
             name => 'Провинция Карс', 
             ua_name => 'Карс', 
             tr_name => 'Kars', 
             ename => 'Kars',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103703 => {
             name => 'Провинция Кастамону', 
             ua_name => 'Кастамону', 
             tr_name => 'Kastamonu', 
             ename => 'Kastamonu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103704 => {
             name => 'Провинция Кахраманмараш', 
             ua_name => 'Кахраманмараш', 
             tr_name => 'Kahramanmaraş', 
             ename => 'Kahramanmaras',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103705 => {
             name => 'Провинция Килис', 
             ua_name => 'Кіліс', 
             tr_name => 'Kilis', 
             ename => 'Kilis',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103706 => {
             name => 'Провинция Коджаэли', 
             ua_name => 'Коджаелі', 
             tr_name => 'Kocaeli', 
             ename => 'Kocaeli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103707 => {
             name => 'Провинция Конья', 
             ua_name => 'Конья', 
             tr_name => 'Konya', 
             ename => 'Konya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103708 => {
             name => 'Провинция Кыркларели', 
             ua_name => 'Киркларелі', 
             tr_name => 'Kırklareli', 
             ename => 'Kirklareli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103709 => {
             name => 'Провинция Кыршехир', 
             ua_name => 'Киршехір', 
             tr_name => 'Kırşehir', 
             ename => 'Kirsehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103710 => {
             name => 'Провинция Кырыккале', 
             ua_name => 'Кириккале', 
             tr_name => 'Kırıkkale', 
             ename => 'Kirikkale',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103711 => {
             name => 'Провинция Кютахья', 
             ua_name => 'Кютах\'я', 
             tr_name => 'Kütahya', 
             ename => 'Kutahya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103712 => {
             name => 'Провинция Малатья', 
             ua_name => 'Малатья', 
             tr_name => 'Malatya', 
             ename => 'Malatya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103713 => {
             name => 'Провинция Маниса', 
             ua_name => 'Маніса', 
             tr_name => 'Manisa', 
             ename => 'Manisa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103714 => {
             name => 'Провинция Мардин', 
             ua_name => 'Мардін', 
             tr_name => 'Mardin', 
             ename => 'Mardin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103715 => {
             name => 'Провинция Мерсин', 
             ua_name => 'Мерсін', 
             tr_name => 'Mersin', 
             ename => 'Mersin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103716 => {
             name => 'Провинция Мугла', 
             ua_name => 'Муґла', 
             tr_name => 'Muğla', 
             ename => 'Mugla',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103717 => {
             name => 'Провинция Муш', 
             ua_name => 'Муш', 
             tr_name => 'Muş', 
             ename => 'Mus',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103718 => {
             name => 'Провинция Невшехир', 
             ua_name => 'Невшехір', 
             tr_name => 'Nevşehir', 
             ename => 'Nevsehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103719 => {
             name => 'Провинция Нигде', 
             ua_name => 'Ніґде', 
             tr_name => 'Niğde', 
             ename => 'Nigde',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103720 => {
             name => 'Провинция Орду', 
             ua_name => 'Орду', 
             tr_name => 'Ordu', 
             ename => 'Ordu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103721 => {
             name => 'Провинция Османие', 
             ua_name => 'Османіє', 
             tr_name => 'Osmaniye', 
             ename => 'Osmaniye',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103722 => {
             name => 'Провинция Ризе', 
             ua_name => 'Різе', 
             tr_name => 'Rize', 
             ename => 'Rize',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103723 => {
             name => 'Провинция Сакарья', 
             ua_name => 'Сакар\'я', 
             tr_name => 'Sakarya', 
             ename => 'Sakarya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103724 => {
             name => 'Провинция Самсун', 
             ua_name => 'Самсун', 
             tr_name => 'Samsun', 
             ename => 'Samsun',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103725 => {
             name => 'Провинция Сивас', 
             ua_name => 'Сівас', 
             tr_name => 'Sivas', 
             ename => 'Sivas',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103726 => {
             name => 'Провинция Сиирт', 
             ua_name => 'Сіїрт', 
             tr_name => 'Siirt', 
             ename => 'Siirt',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103727 => {
             name => 'Провинция Синоп', 
             ua_name => 'Сіноп', 
             tr_name => 'Sinop', 
             ename => 'Sinop',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103728 => {
             name => 'Провинция Стамбул', 
             ua_name => 'Стамбул', 
             tr_name => 'İstanbul', 
             ename => 'Istanbul',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103729 => {
             name => 'Провинция Текирдаг', 
             ua_name => 'Текірдаг', 
             tr_name => 'Tekirdağ', 
             ename => 'Tekirdag',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103730 => {
             name => 'Провинция Токат', 
             ua_name => 'Токат', 
             tr_name => 'Tokat', 
             ename => 'Tokat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103731 => {
             name => 'Провинция Трабзон', 
             ua_name => 'Трабзон', 
             tr_name => 'Trabzon', 
             ename => 'Trabzon',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103732 => {
             name => 'Провинция Тунджели', 
             ua_name => 'Тунджелі', 
             tr_name => 'Tunceli', 
             ename => 'Tunceli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103733 => {
             name => 'Провинция Ушак', 
             ua_name => 'Ушак', 
             tr_name => 'Uşak', 
             ename => 'Usak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103734 => {
             name => 'Провинция Хаккяри', 
             ua_name => 'Хаккярі', 
             tr_name => 'Hakkari', 
             ename => 'Hakkari',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103735 => {
             name => 'Провинция Хатай', 
             ua_name => 'Хатай', 
             tr_name => 'Hatay', 
             ename => 'Hatay',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103736 => {
             name => 'Провинция Чанаккале', 
             ua_name => 'Чанаккале', 
             tr_name => 'Çanakkale', 
             ename => 'Canakkale',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103737 => {
             name => 'Провинция Чанкыры', 
             ua_name => 'Чанкири', 
             tr_name => 'Çankırı', 
             ename => 'Cankiri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103738 => {
             name => 'Провинция Чорум', 
             ua_name => 'Чорум', 
             tr_name => 'Çorum', 
             ename => 'Corum',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103739 => {
             name => 'Провинция Шанлыурфа', 
             ua_name => 'Шанлиурфа', 
             tr_name => 'Şanlıurfa', 
             ename => 'Sanliurfa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103740 => {
             name => 'Провинция Ширнак', 
             ua_name => 'Ширнак', 
             tr_name => 'Şırnak', 
             ename => 'Sirnak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103741 => {
             name => 'Провинция Ыгдыр', 
             ua_name => 'Игдир', 
             tr_name => 'Iğdır', 
             ename => 'Igdir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103742 => {
             name => 'Провинция Ыспарта', 
             ua_name => 'Испарта', 
             tr_name => 'Isparta', 
             ename => 'Isparta',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103743 => {
             name => 'Провинция Эдирне', 
             ua_name => 'Едірне', 
             tr_name => 'Edirne', 
             ename => 'Edirne',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103744 => {
             name => 'Провинция Элязыг', 
             ua_name => 'Елязиг', 
             tr_name => 'Elazığ', 
             ename => 'Elazig',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103745 => {
             name => 'Провинция Эрзинджан', 
             ua_name => 'Ерзінджан', 
             tr_name => 'Erzincan', 
             ename => 'Erzincan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103746 => {
             name => 'Провинция Эрзурум', 
             ua_name => 'Ерзурум', 
             tr_name => 'Erzurum', 
             ename => 'Erzurum',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103747 => {
             name => 'Провинция Эскишехир', 
             ua_name => 'Ескішехір', 
             tr_name => 'Eskişehir', 
             ename => 'Eskisehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103748 => {
             name => 'Провинция Ялова', 
             ua_name => 'Ялова', 
             tr_name => 'Yalova', 
             ename => 'Yalova',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103750 => {
             name => 'Свободное государство Бавария', 
             ua_name => 'Вільна держава Баварія', 
             tr_name => 'Bavyera', 
             ename => 'Free State of Bavaria',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 96 ], 
             childs => [ 101738 ], 
        },
        
        103900 => {
             name => 'Центральный АО', 
             ua_name => 'Центральний АО', 
             tr_name => 'Merkez', 
             ename => 'Central District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 116114 ], 
        },
        
        103901 => {
             name => 'Хайфский АО', 
             ua_name => 'Хайфський АО', 
             tr_name => 'Hayfa Bölgesi', 
             ename => 'Haifa District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 132 ], 
        },
        
        103904 => {
             name => 'Южный АО', 
             ua_name => 'Південний АО', 
             tr_name => 'Güney\'de', 
             ename => 'Southern District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 100944 ], 
        },
        
        103905 => {
             name => 'Тель-Авивский АО', 
             ua_name => 'Тель-Авівський АО', 
             tr_name => 'Tel Aviv Bölgesi', 
             ename => 'Tel Aviv District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 131 ], 
        },
        
        10391 => {
             name => 'Кембридж', 
             ua_name => 'Кембридж', 
             tr_name => 'Cambridge', 
             ename => 'Cambridge',             
             media => 0, 
             geo_flag => 0, 
             level => 6, 
             type => 6,             
             parents => [ 0, 111, 102, 104520, 104584, 104612 ], 
             childs => [  ], 
        },
        
        104260 => {
             name => 'Вильнюсский уезд', 
             ua_name => 'Вільнюський повіт', 
             tr_name => 'Vilnius Vilayeti', 
             ename => 'Vilnius County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 117 ], 
             childs => [ 11475 ], 
        },
        
        104357 => {
             name => 'Уусимаа', 
             ua_name => 'Уусімаа', 
             tr_name => 'Uusimaa', 
             ename => 'Uusimaa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 123 ], 
             childs => [ 10493 ], 
        },
        
        104430 => {
             name => 'Тартумаа', 
             ua_name => 'Тартумаа', 
             tr_name => 'Tartu Vilayeti', 
             ename => 'Tartu County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 179 ], 
             childs => [ 11482 ], 
        },
        
        104431 => {
             name => 'Харьюмаа', 
             ua_name => 'Гар\'юмаа', 
             tr_name => 'Harju Vilayeti', 
             ename => 'Harju County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 179 ], 
             childs => [ 11481 ], 
        },
        
        104492 => {
             name => 'Округ Белград', 
             ua_name => 'Округ Белград', 
             tr_name => 'Belgrad Bölgesi', 
             ename => 'Belgrade District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 180 ], 
             childs => [ 10522 ], 
        },
        
        104520 => {
             name => 'Англия', 
             ua_name => 'Англія', 
             tr_name => 'İngiltere', 
             ename => 'England',             
             media => 1, 
             geo_flag => 0, 
             level => 3, 
             type => 4,             
             parents => [ 0, 111, 102 ], 
             childs => [ 104584 ], 
        },
        
        104584 => {
             name => 'Восточная Англия', 
             ua_name => 'Східна Англія', 
             tr_name => 'Doğu İngiltere', 
             ename => 'East of England',             
             media => 1, 
             geo_flag => 0, 
             level => 4, 
             type => 2,             
             parents => [ 0, 111, 102, 104520 ], 
             childs => [ 104612 ], 
        },
        
        104612 => {
             name => 'Графство Кембриджшир', 
             ua_name => 'Графство Кембриджшир', 
             tr_name => 'Cambridgeshire County', 
             ename => 'Cambridgeshire County',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 5,             
             parents => [ 0, 111, 102, 104520, 104584 ], 
             childs => [ 10391 ], 
        },
        
        10493 => {
             name => 'Хельсинки', 
             ua_name => 'Хельсінкі', 
             tr_name => 'Helsinki', 
             ename => 'Helsinki',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 123, 104357 ], 
             childs => [  ], 
        },
        
        10522 => {
             name => 'Белград', 
             ua_name => 'Белград', 
             tr_name => 'Belgrad', 
             ename => 'Belgrade',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 180, 104492 ], 
             childs => [  ], 
        },
        
        10540 => {
             name => 'Саудовская Аравия', 
             ua_name => 'Саудівська Аравія', 
             tr_name => 'Suudi Arabistan', 
             ename => 'Saudi Arabia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        1056 => {
             name => 'Египет', 
             ua_name => 'Єгипет', 
             tr_name => 'Mısır', 
             ename => 'Egypt',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 241 ], 
             childs => [  ], 
        },
        
        105789 => {
             name => 'Область Арагацотн', 
             ua_name => 'Область Арагацотн', 
             tr_name => 'Aragatsotn', 
             ename => 'Aragatsotn',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105790 => {
             name => 'Область Арарат', 
             ua_name => 'Область Арарат', 
             tr_name => 'Ararat', 
             ename => 'Ararat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105791 => {
             name => 'Область Армавир', 
             ua_name => 'Область Армавір', 
             tr_name => 'Armavir Bölgesi (Armenia)', 
             ename => 'Armavir (Armenia)',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105792 => {
             name => 'Область Гехаркуник', 
             ua_name => 'Область Гехаркунік', 
             tr_name => 'Geğarkunik', 
             ename => 'Gegharkunik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105793 => {
             name => 'Область Котайк', 
             ua_name => 'Область Котайк', 
             tr_name => 'Kotayk', 
             ename => 'Kotayk',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105794 => {
             name => 'Область Лори', 
             ua_name => 'Область Лорі', 
             tr_name => 'Lori', 
             ename => 'Lori',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [ 10258 ], 
        },
        
        105795 => {
             name => 'Область Ширак', 
             ua_name => 'Область Ширак', 
             tr_name => 'Şirak', 
             ename => 'Shirak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [ 10259 ], 
        },
        
        105796 => {
             name => 'Область Сюник', 
             ua_name => 'Область Сюнік', 
             tr_name => 'Sünik', 
             ename => 'Syunik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105797 => {
             name => 'Область Тавуш', 
             ua_name => 'Область Тавуш', 
             tr_name => 'Tavuş', 
             ename => 'Tavush',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105798 => {
             name => 'Область Вайоц-Дзор', 
             ua_name => 'Область Вайоц-Дзор', 
             tr_name => 'Vayots Dzor', 
             ename => 'Vayots Dzor',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        1058 => {
             name => 'Туапсе', 
             ua_name => 'Туапсе', 
             tr_name => 'Tuapse', 
             ename => 'Tuapse',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99299 ], 
             childs => [  ], 
        },
        
        105804 => {
             name => 'Андижанская область', 
             ua_name => 'Андижанська область', 
             tr_name => 'Andican eyaleti', 
             ename => 'Andijan Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10329 ], 
        },
        
        105805 => {
             name => 'Бухарская область', 
             ua_name => 'Бухарська область', 
             tr_name => 'Buhara eyaleti', 
             ename => 'Bukhara Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10330 ], 
        },
        
        105806 => {
             name => 'Джизакская область', 
             ua_name => 'Джиззацька область', 
             tr_name => 'Cizzak eyaleti', 
             ename => 'Jizzakh Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21606 ], 
        },
        
        105807 => {
             name => 'Кашкадарьинская область', 
             ua_name => 'Кашкадар\'їнська область', 
             tr_name => 'Kaşkaderya eyaleti', 
             ename => 'Qashqadaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10331, 101761 ], 
        },
        
        105808 => {
             name => 'Навоийская область', 
             ua_name => 'Навоїйська область', 
             tr_name => 'Nevai eyaleti', 
             ename => 'Navoiy Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21947 ], 
        },
        
        105809 => {
             name => 'Наманганская область', 
             ua_name => 'Наманганська область', 
             tr_name => 'Nemengan eyaleti', 
             ename => 'Namangan Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21314 ], 
        },
        
        105810 => {
             name => 'Самаркандская область', 
             ua_name => 'Самаркандська область', 
             tr_name => 'Semerkant eyaleti', 
             ename => 'Samarqand Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10334 ], 
        },
        
        105811 => {
             name => 'Сурхандарьинская область', 
             ua_name => 'Сурхандар\'їнська область', 
             tr_name => 'Surhanderya eyaleti', 
             ename => 'Surxondaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10338, 196979 ], 
        },
        
        105812 => {
             name => 'Сырдарьинская область', 
             ua_name => 'Сирдар\'їнська область', 
             tr_name => 'Siriderya eyaleti', 
             ename => 'Sirdaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [  ], 
        },
        
        105813 => {
             name => 'Ташкентская область', 
             ua_name => 'Ташкентська область', 
             tr_name => 'Taşkent eyaleti', 
             ename => 'Tashkent Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10328, 101524, 114900, 189657 ], 
        },
        
        105814 => {
             name => 'Ферганская область', 
             ua_name => 'Ферганська область', 
             tr_name => 'Fergana eyaleti', 
             ename => 'Fergana Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10332, 10336, 101425 ], 
        },
        
        105815 => {
             name => 'Хорезмская область', 
             ua_name => 'Хорезмська область', 
             tr_name => 'Harezm eyaleti', 
             ename => 'Xorazm Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21105 ], 
        },
        
        105816 => {
             name => 'Республика Каракалпакстан', 
             ua_name => 'Республіка Каракалпакстан', 
             tr_name => 'Karakalpakistan', 
             ename => 'Republic of Karakalpakstan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10337, 193330 ], 
        },
        
        10645 => {
             name => 'Белгородская область', 
             ua_name => 'Бєлгородська область', 
             tr_name => 'Belgorodskaya oblastı', 
             ename => 'Belgorod Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 4, 10646, 10649, 98697, 98716, 98717 ], 
        },
        
        10646 => {
             name => 'Губкин', 
             ua_name => 'Губкин', 
             tr_name => 'Gubkin', 
             ename => 'Gubkin',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [  ], 
        },
        
        10649 => {
             name => 'Старый Оскол', 
             ua_name => 'Старий Оскол', 
             tr_name => 'Stariy Oskol', 
             ename => 'Stariy Oskol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [  ], 
        },
        
        10650 => {
             name => 'Брянская область', 
             ua_name => 'Брянська область', 
             tr_name => 'Brianskaya oblastı', 
             ename => 'Bryansk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 191, 10653 ], 
        },
        
        10653 => {
             name => 'Клинцы', 
             ua_name => 'Клинці', 
             tr_name => 'Klintsy', 
             ename => 'Klintsy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10650 ], 
             childs => [  ], 
        },
        
        10656 => {
             name => 'Александров', 
             ua_name => 'Александров', 
             tr_name => 'Aleksandrov', 
             ename => 'Aleksandrov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10658, 98745 ], 
             childs => [  ], 
        },
        
        10658 => {
             name => 'Владимирская область', 
             ua_name => 'Владимирська область', 
             tr_name => 'Vladimirskaya oblastı', 
             ename => 'Vladimir Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 192, 10661, 10664, 10668, 98745, 98750, 98755 ], 
        },
        
        10661 => {
             name => 'Гусь-Хрустальный', 
             ua_name => 'Гусь-Хрустальний', 
             tr_name => 'Gus-Hrustalny', 
             ename => 'Gus-Chrustalniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        10663 => {
             name => 'Киржач', 
             ua_name => 'Кіржач', 
             tr_name => 'Kirjaç', 
             ename => 'Kirzach',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10658, 98750 ], 
             childs => [  ], 
        },
        
        10664 => {
             name => 'Ковров', 
             ua_name => 'Ковров', 
             tr_name => 'Kovrov', 
             ename => 'Kovrov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        10668 => {
             name => 'Муром', 
             ua_name => 'Муром', 
             tr_name => 'Murom', 
             ename => 'Murom',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        10672 => {
             name => 'Воронежская область', 
             ua_name => 'Воронезька область', 
             tr_name => 'Voronejskaya oblastı', 
             ename => 'Voronezh Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 193, 98787 ], 
        },
        
        10681 => {
             name => 'Россошь', 
             ua_name => 'Россош', 
             tr_name => 'Rossoş', 
             ename => 'Rossosh',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10672, 98787 ], 
             childs => [  ], 
        },
        
        10687 => {
             name => 'Ивановская область', 
             ua_name => 'Івановська область', 
             tr_name => 'İvanovskaya oblastı', 
             ename => 'Ivanovo Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 5, 10689, 10691 ], 
        },
        
        10689 => {
             name => 'Кинешма', 
             ua_name => 'Кінешма', 
             tr_name => 'Kineşma', 
             ename => 'Kineshma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10687 ], 
             childs => [  ], 
        },
        
        10691 => {
             name => 'Шуя', 
             ua_name => 'Шуя', 
             tr_name => 'Şuya', 
             ename => 'Shuya',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10687 ], 
             childs => [  ], 
        },
        
        10693 => {
             name => 'Калужская область', 
             ua_name => 'Калузька область', 
             tr_name => 'Kalujskaya oblastı', 
             ename => 'Kaluga Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 6, 967, 98826 ], 
        },
        
        10697 => {
             name => 'Малоярославец', 
             ua_name => 'Малоярославець', 
             tr_name => 'Maloyaroslavets', 
             ename => 'Maloyaroslavets',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10693, 98826 ], 
             childs => [  ], 
        },
        
        10699 => {
             name => 'Костромская область', 
             ua_name => 'Костромська область', 
             tr_name => 'Kostromskaya oblastı', 
             ename => 'Kostroma Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 7 ], 
        },
        
        10705 => {
             name => 'Курская область', 
             ua_name => 'Курська область', 
             tr_name => 'Kurskaya oblastı', 
             ename => 'Kursk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 8, 10710, 20707 ], 
        },
        
        10710 => {
             name => 'Железногорск', 
             ua_name => 'Желєзногорськ', 
             tr_name => 'Jeleznogorsk', 
             ename => 'Zheleznogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10705 ], 
             childs => [  ], 
        },
        
        10712 => {
             name => 'Липецкая область', 
             ua_name => 'Липецька область', 
             tr_name => 'Lipetskaya oblastı', 
             ename => 'Lipetsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 9, 10713 ], 
        },
        
        10713 => {
             name => 'Елец', 
             ua_name => 'Єлець', 
             tr_name => 'Yelets', 
             ename => 'Yelets',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10712 ], 
             childs => [  ], 
        },
        
        10715 => {
             name => 'Апрелевка', 
             ua_name => 'Апрелєвка', 
             tr_name => 'Aprelevka', 
             ename => 'Aprelevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98597 ], 
             childs => [  ], 
        },
        
        10716 => {
             name => 'Балашиха', 
             ua_name => 'Балашиха', 
             tr_name => 'Balaşiha', 
             ename => 'Balashiha',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10717 => {
             name => 'Бронницы', 
             ua_name => 'Бронниці', 
             tr_name => 'Bronnitsy', 
             ename => 'Bronnizi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10719 => {
             name => 'Видное', 
             ua_name => 'Видне', 
             tr_name => 'Vidnoye', 
             ename => 'Vidnoe',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98591 ], 
             childs => [  ], 
        },
        
        10721 => {
             name => 'Волоколамск', 
             ua_name => 'Волоколамськ', 
             tr_name => 'Volokolamsk', 
             ename => 'Volokolamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98580 ], 
             childs => [  ], 
        },
        
        10722 => {
             name => 'Воскресенск', 
             ua_name => 'Воскресенськ', 
             tr_name => 'Voskresensk', 
             ename => 'Voskresensk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98581 ], 
             childs => [  ], 
        },
        
        10723 => {
             name => 'Дмитров', 
             ua_name => 'Дмитров', 
             tr_name => 'Dmitrov', 
             ename => 'Dmitrov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98582 ], 
             childs => [  ], 
        },
        
        10725 => {
             name => 'Домодедово', 
             ua_name => 'Домодєдово', 
             tr_name => 'Domodedovo', 
             ename => 'Domodedovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10727 => {
             name => 'Егорьевск', 
             ua_name => 'Єгор\'євськ', 
             tr_name => 'Yegoryevsk', 
             ename => 'Egorievsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98584 ], 
             childs => [  ], 
        },
        
        10728 => {
             name => 'Зарайск', 
             ua_name => 'Зарайськ', 
             tr_name => 'Zaraysk', 
             ename => 'Zaraysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98585 ], 
             childs => [  ], 
        },
        
        10729 => {
             name => 'Звенигород', 
             ua_name => 'Звенигород', 
             tr_name => 'Zvenigorod', 
             ename => 'Zvenigorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10731 => {
             name => 'Истра', 
             ua_name => 'Істра', 
             tr_name => 'İstra', 
             ename => 'Istra',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98586 ], 
             childs => [  ], 
        },
        
        10732 => {
             name => 'Кашира', 
             ua_name => 'Кашира', 
             tr_name => 'Kaşira', 
             ename => 'Kashira',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98587 ], 
             childs => [  ], 
        },
        
        10733 => {
             name => 'Клин', 
             ua_name => 'Клин', 
             tr_name => 'Klin', 
             ename => 'Klin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98588 ], 
             childs => [  ], 
        },
        
        10734 => {
             name => 'Коломна', 
             ua_name => 'Коломна', 
             tr_name => 'Kolomna', 
             ename => 'Kolomna',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10735 => {
             name => 'Красногорск', 
             ua_name => 'Красногорськ', 
             tr_name => 'Krasnogorsk', 
             ename => 'Krasnogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98590 ], 
             childs => [  ], 
        },
        
        10737 => {
             name => 'Луховицы', 
             ua_name => 'Луховиці', 
             tr_name => 'Luhovitsy', 
             ename => 'Luhovicy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98593 ], 
             childs => [  ], 
        },
        
        10738 => {
             name => 'Люберцы', 
             ua_name => 'Люберці', 
             tr_name => 'Liubertsy', 
             ename => 'Lubercy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98594 ], 
             childs => [  ], 
        },
        
        10739 => {
             name => 'Можайск', 
             ua_name => 'Можайськ', 
             tr_name => 'Mojaysk', 
             ename => 'Mozhaysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98595 ], 
             childs => [  ], 
        },
        
        10740 => {
             name => 'Мытищи', 
             ua_name => 'Митищі', 
             tr_name => 'Mytişçi', 
             ename => 'Mytischi',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98596 ], 
             childs => [  ], 
        },
        
        10741 => {
             name => 'Наро-Фоминск', 
             ua_name => 'Наро-Фомінськ', 
             tr_name => 'Naro-Fominsk', 
             ename => 'Naro-Fominsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98597 ], 
             childs => [  ], 
        },
        
        10742 => {
             name => 'Ногинск', 
             ua_name => 'Ногинськ', 
             tr_name => 'Noginsk', 
             ename => 'Noginsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98598 ], 
             childs => [  ], 
        },
        
        10743 => {
             name => 'Одинцово', 
             ua_name => 'Одинцово', 
             tr_name => 'Odintsovo', 
             ename => 'Odincovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98599 ], 
             childs => [  ], 
        },
        
        10745 => {
             name => 'Орехово-Зуево', 
             ua_name => 'Орєхово-Зуєво', 
             tr_name => 'Orehovo-Zuyevo', 
             ename => 'Orehovo-Zuevo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10746 => {
             name => 'Павловский Посад', 
             ua_name => 'Павловський Посад', 
             tr_name => 'Pavlovski Posad', 
             ename => 'Pavlovskiy Posad',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98602 ], 
             childs => [  ], 
        },
        
        10747 => {
             name => 'Подольск', 
             ua_name => 'Подольськ', 
             tr_name => 'Podolsk', 
             ename => 'Podolsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10748 => {
             name => 'Пушкино', 
             ua_name => 'Пушкіно', 
             tr_name => 'Puşkino', 
             ename => 'Pushkino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        10750 => {
             name => 'Раменское', 
             ua_name => 'Раменське', 
             tr_name => 'Ramenskoye', 
             ename => 'Ramenskoe',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98605 ], 
             childs => [  ], 
        },
        
        10751 => {
             name => 'Руза', 
             ua_name => 'Руза', 
             tr_name => 'Ruza', 
             ename => 'Ruza',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98606 ], 
             childs => [  ], 
        },
        
        10752 => {
             name => 'Сергиев Посад', 
             ua_name => 'Сергієв Посад', 
             tr_name => 'Sergiyev Posad', 
             ename => 'Sergiev Posad',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98608 ], 
             childs => [  ], 
        },
        
        10754 => {
             name => 'Серпухов', 
             ua_name => 'Серпухов', 
             tr_name => 'Serpuhov', 
             ename => 'Serpuhov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10755 => {
             name => 'Солнечногорск', 
             ua_name => 'Солнєчногорськ', 
             tr_name => 'Solneçnogorsk', 
             ename => 'Solnechnogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98611 ], 
             childs => [  ], 
        },
        
        10756 => {
             name => 'Ступино', 
             ua_name => 'Ступіно', 
             tr_name => 'Stupino', 
             ename => 'Stupino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98607 ], 
             childs => [  ], 
        },
        
        10758 => {
             name => 'Химки', 
             ua_name => 'Хімки', 
             tr_name => 'Himki', 
             ename => 'Himki',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10761 => {
             name => 'Чехов', 
             ua_name => 'Чехов', 
             tr_name => 'Çehov', 
             ename => 'Chehov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98614 ], 
             childs => [  ], 
        },
        
        10762 => {
             name => 'Шатура', 
             ua_name => 'Шатура', 
             tr_name => 'Şatura', 
             ename => 'Shatura',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98615 ], 
             childs => [  ], 
        },
        
        10765 => {
             name => 'Щелково', 
             ua_name => 'Щолково', 
             tr_name => 'Şçolkovo', 
             ename => 'Shelkovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98617 ], 
             childs => [  ], 
        },
        
        10772 => {
             name => 'Орловская область', 
             ua_name => 'Орловська область', 
             tr_name => 'Orlovskaya oblastı', 
             ename => 'Oryol Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 10 ], 
        },
        
        10773 => {
             name => 'Касимов', 
             ua_name => 'Касімов', 
             tr_name => 'Kasimov', 
             ename => 'Kasimov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10776 ], 
             childs => [  ], 
        },
        
        10776 => {
             name => 'Рязанская область', 
             ua_name => 'Рязанська область', 
             tr_name => 'Riazanskaya oblastı', 
             ename => 'Ryazan Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 11, 10773 ], 
        },
        
        10782 => {
             name => 'Вязьма', 
             ua_name => 'Вязьма', 
             tr_name => 'Viazma', 
             ename => 'Vyazma',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10795, 98958 ], 
             childs => [  ], 
        },
        
        10783 => {
             name => 'Гагарин', 
             ua_name => 'Гагарін', 
             tr_name => 'Gagarin', 
             ename => 'Gagarin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10795, 98959 ], 
             childs => [  ], 
        },
        
        10795 => {
             name => 'Смоленская область', 
             ua_name => 'Смоленська область', 
             tr_name => 'Smolenskaya oblastı', 
             ename => 'Smolensk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 12, 98958, 98959, 98981 ], 
        },
        
        10801 => {
             name => 'Ярцево', 
             ua_name => 'Ярцево', 
             tr_name => 'Yartsevo', 
             ename => 'Yartsevo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10795, 98981 ], 
             childs => [  ], 
        },
        
        10802 => {
             name => 'Тамбовская область', 
             ua_name => 'Тамбовська область', 
             tr_name => 'Tambovskaya oblastı', 
             ename => 'Tambov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 13, 10803 ], 
        },
        
        10803 => {
             name => 'Мичуринск', 
             ua_name => 'Мічурінськ', 
             tr_name => 'Miçurinsk', 
             ename => 'Michurinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10802 ], 
             childs => [  ], 
        },
        
        10805 => {
             name => 'Бологое', 
             ua_name => 'Бологе', 
             tr_name => 'Bologoe', 
             ename => 'Bologoe',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99008 ], 
             childs => [  ], 
        },
        
        10807 => {
             name => 'Вышний Волочёк', 
             ua_name => 'Вишній Волочeк', 
             tr_name => 'Vishniy Volochek', 
             ename => 'Vishniy Volochek',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        10811 => {
             name => 'Кимры', 
             ua_name => 'Кімри', 
             tr_name => 'Kimry', 
             ename => 'Kimry',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        10812 => {
             name => 'Конаково', 
             ua_name => 'Конаково', 
             tr_name => 'Konakovo', 
             ename => 'Konakovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99019 ], 
             childs => [  ], 
        },
        
        10818 => {
             name => 'Осташков', 
             ua_name => 'Осташков', 
             tr_name => 'Ostashkov', 
             ename => 'Ostashkov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99028 ], 
             childs => [  ], 
        },
        
        10819 => {
             name => 'Тверская область', 
             ua_name => 'Тверська область', 
             tr_name => 'Tverskaya oblastı', 
             ename => 'Tver Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 14, 10807, 10811, 10820, 99008, 99019, 99028, 99039 ], 
        },
        
        10820 => {
             name => 'Ржев', 
             ua_name => 'Ржев', 
             tr_name => 'Rzhev', 
             ename => 'Rzhev',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        10824 => {
             name => 'Удомля', 
             ua_name => 'Удомля', 
             tr_name => 'Udomlya', 
             ename => 'Udomlya',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99039 ], 
             childs => [  ], 
        },
        
        10828 => {
             name => 'Ефремов', 
             ua_name => 'Єфремов', 
             tr_name => 'Yefremov', 
             ename => 'Efremov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [  ], 
        },
        
        10830 => {
             name => 'Новомосковск', 
             ua_name => 'Новомосковськ', 
             tr_name => 'Novomoskovsk', 
             ename => 'Novomoskovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [  ], 
        },
        
        10832 => {
             name => 'Тульская область', 
             ua_name => 'Тульська область', 
             tr_name => 'Tulskaya oblastı', 
             ename => 'Tula Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 15, 10828, 10830, 99044 ], 
        },
        
        10836 => {
             name => 'Мышкин', 
             ua_name => 'Мишкин', 
             tr_name => 'Myşkin', 
             ename => 'Myshkin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10841, 99070 ], 
             childs => [  ], 
        },
        
        10837 => {
             name => 'Переславль-Залесский', 
             ua_name => 'Переславль-Залєський', 
             tr_name => 'Pereslavl-Zalesski', 
             ename => 'Pereslavl-Zalesskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [  ], 
        },
        
        10839 => {
             name => 'Рыбинск', 
             ua_name => 'Рибинськ', 
             tr_name => 'Rybinsk', 
             ename => 'Rybinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [  ], 
        },
        
        10840 => {
             name => 'Углич', 
             ua_name => 'Углич', 
             tr_name => 'Ugliç', 
             ename => 'Uglich',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10841, 99079 ], 
             childs => [  ], 
        },
        
        10841 => {
             name => 'Ярославская область', 
             ua_name => 'Ярославська область', 
             tr_name => 'Yaroslavskaya oblastı', 
             ename => 'Yaroslavl Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 16, 10837, 10839, 99070, 99078, 99079 ], 
        },
        
        10842 => {
             name => 'Архангельская область', 
             ua_name => 'Архангельська область', 
             tr_name => 'Arhangelskaya oblastı', 
             ename => 'Arkhange\'lskaya Oblast\'',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 20, 10846, 10849, 20117 ], 
        },
        
        10846 => {
             name => 'Котлас', 
             ua_name => 'Котлас', 
             tr_name => 'Kotlas', 
             ename => 'Kotlas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        10849 => {
             name => 'Северодвинск', 
             ua_name => 'Сєвєродвінськ', 
             tr_name => 'Severodvinsk', 
             ename => 'Severodvinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        10853 => {
             name => 'Вологодская область', 
             ua_name => 'Вологодська область', 
             tr_name => 'Vologodskaya oblastı', 
             ename => 'Vologda Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 21, 968, 99105 ], 
        },
        
        10854 => {
             name => 'Великий Устюг', 
             ua_name => 'Великий Устюг', 
             tr_name => 'Velikiy Ustug', 
             ename => 'Velikiy Ustug',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10853, 99105 ], 
             childs => [  ], 
        },
        
        10857 => {
             name => 'Калининградская область', 
             ua_name => 'Калінінградська область', 
             tr_name => 'Kaliningradskaya oblastı', 
             ename => 'Kaliningrad Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 22, 10860, 20139, 20144 ], 
        },
        
        10860 => {
             name => 'Советск', 
             ua_name => 'Совєтськ', 
             tr_name => 'Sovetsk', 
             ename => 'Sovetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        10864 => {
             name => 'Волхов', 
             ua_name => 'Волхов', 
             tr_name => 'Volhov', 
             ename => 'Volhov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98620 ], 
             childs => [  ], 
        },
        
        10865 => {
             name => 'Всеволожск', 
             ua_name => 'Всеволожськ', 
             tr_name => 'Vsevolgsk', 
             ename => 'Vsevolgsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98621 ], 
             childs => [  ], 
        },
        
        10867 => {
             name => 'Гатчина', 
             ua_name => 'Гатчина', 
             tr_name => 'Gatchina', 
             ename => 'Gatchina',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98623 ], 
             childs => [  ], 
        },
        
        10870 => {
             name => 'Кингисепп', 
             ua_name => 'Кінгісепп', 
             tr_name => 'Kingisepp', 
             ename => 'Kingisepp',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98624 ], 
             childs => [  ], 
        },
        
        10871 => {
             name => 'Кириши', 
             ua_name => 'Кириші', 
             tr_name => 'Kirishi', 
             ename => 'Kirishi',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98625 ], 
             childs => [  ], 
        },
        
        10872 => {
             name => 'Кировск', 
             ua_name => 'Кіровськ', 
             tr_name => 'Kirovsk', 
             ename => 'Kirovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98626 ], 
             childs => [  ], 
        },
        
        10876 => {
             name => 'Луга', 
             ua_name => 'Луга', 
             tr_name => 'Luga', 
             ename => 'Luga',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98629 ], 
             childs => [  ], 
        },
        
        10881 => {
             name => 'Подпорожье', 
             ua_name => 'Підпоріжжя', 
             tr_name => 'Podorogie', 
             ename => 'Podporogie',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98630 ], 
             childs => [  ], 
        },
        
        10883 => {
             name => 'Приозерск', 
             ua_name => 'Приозерськ', 
             tr_name => 'Priozersk', 
             ename => 'Priozersk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98631 ], 
             childs => [  ], 
        },
        
        10884 => {
             name => 'Пушкин', 
             ua_name => 'Пушкін', 
             tr_name => 'Puşkin', 
             ename => 'Pushkin',             
             media => 0, 
             geo_flag => 1, 
             level => 6, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 2, 20297 ], 
             childs => [  ], 
        },
        
        10888 => {
             name => 'Сланцы', 
             ua_name => 'Сланці', 
             tr_name => 'Slantsy', 
             ename => 'Slantsy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98632 ], 
             childs => [  ], 
        },
        
        10891 => {
             name => 'Сосновый Бор', 
             ua_name => 'Сосновий Бір', 
             tr_name => 'Sosnoviy Bor', 
             ename => 'Sosnoviy Bor',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [  ], 
        },
        
        10892 => {
             name => 'Тихвин', 
             ua_name => 'Тихвін', 
             tr_name => 'Tixvin', 
             ename => 'Tikhvin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98633 ], 
             childs => [  ], 
        },
        
        10893 => {
             name => 'Тосно', 
             ua_name => 'Тосно', 
             tr_name => 'Tosno', 
             ename => 'Tosno',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98634 ], 
             childs => [  ], 
        },
        
        10894 => {
             name => 'Апатиты', 
             ua_name => 'Апатіти', 
             tr_name => 'Apatity', 
             ename => 'Apatity',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        10895 => {
             name => 'Кандалакша', 
             ua_name => 'Кандалакша', 
             tr_name => 'Kandalaksha', 
             ename => 'Kandalaksha',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10897, 101749 ], 
             childs => [  ], 
        },
        
        10896 => {
             name => 'Мончегорск', 
             ua_name => 'Мончегорськ', 
             tr_name => 'Monchegorsk', 
             ename => 'Monchegorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        10897 => {
             name => 'Мурманская область', 
             ua_name => 'Мурманська область', 
             tr_name => 'Murmanskaya oblastı', 
             ename => 'Murmansk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 23, 10894, 10896, 20155, 101749 ], 
        },
        
        10902 => {
             name => 'Нарьян-Мар', 
             ua_name => 'Нар\'ян-Мар', 
             tr_name => 'Naryan-Mar', 
             ename => 'Naryan-Mar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10176 ], 
             childs => [  ], 
        },
        
        10904 => {
             name => 'Новгородская область', 
             ua_name => 'Новгородська область', 
             tr_name => 'Novgorodskaya oblastı', 
             ename => 'Novgorod Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 24, 99146, 99147, 99161 ], 
        },
        
        10906 => {
             name => 'Боровичи', 
             ua_name => 'Боровичі', 
             tr_name => 'Borovichy', 
             ename => 'Borovichy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10904, 99146 ], 
             childs => [  ], 
        },
        
        10907 => {
             name => 'Валдай', 
             ua_name => 'Валдай', 
             tr_name => 'Valday', 
             ename => 'Valday',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10904, 99147 ], 
             childs => [  ], 
        },
        
        1091 => {
             name => 'Нижневартовск', 
             ua_name => 'Нижньовартовськ', 
             tr_name => 'Nijnevartovsk', 
             ename => 'Nizhnevartovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        1092 => {
             name => 'Назрань', 
             ua_name => 'Назрань', 
             tr_name => 'Nazran', 
             ename => 'Nazran',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11012 ], 
             childs => [  ], 
        },
        
        10923 => {
             name => 'Старая Русса', 
             ua_name => 'Стара Русса', 
             tr_name => 'Staraya Russa', 
             ename => 'Staraya Russa',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10904, 99161 ], 
             childs => [  ], 
        },
        
        10926 => {
             name => 'Псковская область', 
             ua_name => 'Псковська область', 
             tr_name => 'Pskovskaya oblastı', 
             ename => 'Pskov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 25, 10928 ], 
        },
        
        10928 => {
             name => 'Великие Луки', 
             ua_name => 'Великі Луки', 
             tr_name => 'Velikie Luky', 
             ename => 'Velikie Luky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10926 ], 
             childs => [  ], 
        },
        
        1093 => {
             name => 'Майкоп', 
             ua_name => 'Майкоп', 
             tr_name => 'Maykop', 
             ename => 'Maykop',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11004 ], 
             childs => [  ], 
        },
        
        10933 => {
             name => 'Республика Карелия', 
             ua_name => 'Республіка Карелія', 
             tr_name => 'Karelya', 
             ename => 'Republic of Karelia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 18, 10935, 99193, 99203, 110934 ], 
        },
        
        10934 => {
             name => 'Кондопога', 
             ua_name => 'Кондопога', 
             tr_name => 'Kondopoga', 
             ename => 'Kondopoga',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10933, 99193 ], 
             childs => [  ], 
        },
        
        10935 => {
             name => 'Костомукша', 
             ua_name => 'Костомукша', 
             tr_name => 'Kostomucsha', 
             ename => 'Kostomucsha',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [  ], 
        },
        
        10936 => {
             name => 'Сегежа', 
             ua_name => 'Сегежа', 
             tr_name => 'Segezha', 
             ename => 'Segezha',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10933, 99203 ], 
             childs => [  ], 
        },
        
        10937 => {
             name => 'Сортавала', 
             ua_name => 'Сортавала', 
             tr_name => 'Sortavala', 
             ename => 'Sortavala',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10933, 110934 ], 
             childs => [  ], 
        },
        
        10939 => {
             name => 'Республика Коми', 
             ua_name => 'Республіка Комі', 
             tr_name => 'Komi', 
             ename => 'Komi Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 19, 10940, 10941, 10944, 10945, 99210 ], 
        },
        
        1094 => {
             name => 'Элиста', 
             ua_name => 'Еліста', 
             tr_name => 'Elista', 
             ename => 'Elista',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11015 ], 
             childs => [  ], 
        },
        
        10940 => {
             name => 'Воркута', 
             ua_name => 'Воркута', 
             tr_name => 'Vorkuta', 
             ename => 'Vorkuta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10941 => {
             name => 'Инта', 
             ua_name => 'Інта', 
             tr_name => 'Inta', 
             ename => 'Inta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10942 => {
             name => 'Печора', 
             ua_name => 'Печора', 
             tr_name => 'Pechora', 
             ename => 'Pechora',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10939, 99210 ], 
             childs => [  ], 
        },
        
        10944 => {
             name => 'Усинск', 
             ua_name => 'Усинськ', 
             tr_name => 'Usinsk', 
             ename => 'Usinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10945 => {
             name => 'Ухта', 
             ua_name => 'Ухта', 
             tr_name => 'Uhta', 
             ename => 'Uhta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10946 => {
             name => 'Астраханская область', 
             ua_name => 'Астраханська область', 
             tr_name => 'Astrahanskaya oblastı', 
             ename => 'Astrakhan Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 37, 99221 ], 
        },
        
        1095 => {
             name => 'Абакан', 
             ua_name => 'Абакан', 
             tr_name => 'Abakan', 
             ename => 'Abakan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11340 ], 
             childs => [  ], 
        },
        
        10950 => {
             name => 'Волгоградская область', 
             ua_name => 'Волгоградська область', 
             tr_name => 'Volgogradskaya oblastı', 
             ename => 'Volgograd Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 38, 10951, 10959, 10965, 10981 ], 
        },
        
        10951 => {
             name => 'Волжский', 
             ua_name => 'Волзький', 
             tr_name => 'Voljski', 
             ename => 'Volzhskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10959 => {
             name => 'Камышин', 
             ua_name => 'Камишин', 
             tr_name => 'Kamyşin', 
             ename => 'Kamishin',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10965 => {
             name => 'Михайловка', 
             ua_name => 'Михайлівка', 
             tr_name => 'Mihaylovka', 
             ename => 'Mihaylovka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10981 => {
             name => 'Урюпинск', 
             ua_name => 'Урюпінськ', 
             tr_name => 'Uriupinsk', 
             ename => 'Uryupinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10987 => {
             name => 'Армавир', 
             ua_name => 'Армавір', 
             tr_name => 'Armavir (Krasnodarski krayı)', 
             ename => 'Armavir (Krasnodar Krai)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        10988 => {
             name => 'Белореченск', 
             ua_name => 'Бєлореченськ', 
             tr_name => 'Beloreçensk', 
             ename => 'Belorechensk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99269 ], 
             childs => [  ], 
        },
        
        10990 => {
             name => 'Геленджик', 
             ua_name => 'Геленджик', 
             tr_name => 'Gelencik', 
             ename => 'Gelendgik',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        10993 => {
             name => 'Ейск', 
             ua_name => 'Єйськ', 
             tr_name => 'Yeysk', 
             ename => 'Yesk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99274 ], 
             childs => [  ], 
        },
        
        10995 => {
             name => 'Краснодарский край', 
             ua_name => 'Краснодарський край', 
             tr_name => 'Krasnodarski krayı', 
             ename => 'Krasnodar Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 35, 239, 970, 1107, 10987, 10990, 99269, 99274, 99275, 99281, 99293, 99297, 99298, 99299 ], 
        },
        
        10996 => {
             name => 'Кропоткин', 
             ua_name => 'Кропоткін', 
             tr_name => 'Kropotkin', 
             ename => 'Kropotkin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99275 ], 
             childs => [  ], 
        },
        
        10997 => {
             name => 'Крымск', 
             ua_name => 'Кримськ', 
             tr_name => 'Krymsk', 
             ename => 'Krymsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99281 ], 
             childs => [  ], 
        },
        
        11 => {
             name => 'Рязань', 
             ua_name => 'Рязань', 
             tr_name => 'Riazan', 
             ename => 'Ryazan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10776 ], 
             childs => [  ], 
        },
        
        11002 => {
             name => 'Тихорецк', 
             ua_name => 'Тихорєцьк', 
             tr_name => 'Tihoretsk', 
             ename => 'Tikhoretsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99298 ], 
             childs => [  ], 
        },
        
        11004 => {
             name => 'Республика Адыгея', 
             ua_name => 'Республіка Адигея', 
             tr_name => 'Adıge Cumhuriyeti', 
             ename => 'Republic of Adygea',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 1093 ], 
        },
        
        11006 => {
             name => 'Буйнакск', 
             ua_name => 'Буйнакськ', 
             tr_name => 'Buynaksk', 
             ename => 'Buynaksk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11007 => {
             name => 'Дербент', 
             ua_name => 'Дербент', 
             tr_name => 'Derbent', 
             ename => 'Derbent',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11008 => {
             name => 'Каспийск', 
             ua_name => 'Каспійськ', 
             tr_name => 'Kaspiysk', 
             ename => 'Kaspiysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11009 => {
             name => 'Кизляр', 
             ua_name => 'Кизляр', 
             tr_name => 'Kizlyar', 
             ename => 'Kizlyar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11010 => {
             name => 'Республика Дагестан', 
             ua_name => 'Республіка Дагестан', 
             tr_name => 'Dağıstan', 
             ename => 'Republic of Dagestan',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 28, 11006, 11007, 11008, 11009, 11011, 21521 ], 
        },
        
        11011 => {
             name => 'Хасавюрт', 
             ua_name => 'Хасавюрт', 
             tr_name => 'Khasavyurt', 
             ename => 'Khasavurt',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11012 => {
             name => 'Республика Ингушетия', 
             ua_name => 'Республіка Інгушетія', 
             tr_name => 'İnguşetya', 
             ename => 'Republic of Ingushetia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 1092, 20181 ], 
        },
        
        11013 => {
             name => 'Кабардино-Балкарская Республика', 
             ua_name => 'Республіка Кабардино-Балкарія', 
             tr_name => 'Kabardino-Balkarya', 
             ename => 'The Kabardino-Balkar Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 30 ], 
        },
        
        11015 => {
             name => 'Республика Калмыкия', 
             ua_name => 'Республіка Калмикія', 
             tr_name => 'Kalmukya', 
             ename => 'Republic of Kalmykia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 1094 ], 
        },
        
        11020 => {
             name => 'Карачаево-Черкесская Республика', 
             ua_name => 'Карачаєво-Черкеська Республіка', 
             tr_name => 'Karaçay-Çerkez Cumhuriyeti', 
             ename => 'Karachay-Cherkess Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 1104 ], 
        },
        
        11021 => {
             name => 'Республика Северная Осетия — Алания', 
             ua_name => 'Республіка Північна Осетія — Аланія', 
             tr_name => 'Kuzey Osetya-Alanya', 
             ename => 'Republic of North Ossetia — Alania',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 33 ], 
        },
        
        11024 => {
             name => 'Чеченская Республика', 
             ua_name => 'Чеченська Республіка', 
             tr_name => 'Çeçen Cumhuriyeti', 
             ename => 'Chechen Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 1106 ], 
        },
        
        11029 => {
             name => 'Ростовская область', 
             ua_name => 'Ростовська область', 
             tr_name => 'Rostovskaya oblastı', 
             ename => 'Rostov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 39, 238, 971, 11030, 11033, 11036, 11037, 11043, 11049, 11053, 99411 ], 
        },
        
        11030 => {
             name => 'Азов', 
             ua_name => 'Азов', 
             tr_name => 'Azov', 
             ename => 'Azov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11033 => {
             name => 'Батайск', 
             ua_name => 'Батайськ', 
             tr_name => 'Bataysk', 
             ename => 'Bataysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11034 => {
             name => 'Белая Калитва', 
             ua_name => 'Біла Калитва', 
             tr_name => 'Belaya Kalitva', 
             ename => 'Belaya Kalitva',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 11029, 99411 ], 
             childs => [  ], 
        },
        
        11036 => {
             name => 'Волгодонск', 
             ua_name => 'Волгодонськ', 
             tr_name => 'Volgodonsk', 
             ename => 'Volgodonsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11037 => {
             name => 'Гуково', 
             ua_name => 'Гуково', 
             tr_name => 'Gukovo', 
             ename => 'Gukovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        1104 => {
             name => 'Черкесск', 
             ua_name => 'Черкеськ', 
             tr_name => 'Cherkessk', 
             ename => 'Cherkessk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11020 ], 
             childs => [  ], 
        },
        
        11043 => {
             name => 'Каменск-Шахтинский', 
             ua_name => 'Каменськ-Шахтинський', 
             tr_name => 'Kamensk-Şahtinski', 
             ename => 'Kamensk-Shakhtinsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11049 => {
             name => 'Новошахтинск', 
             ua_name => 'Новошахтинськ', 
             tr_name => 'Novoşahtinsk', 
             ename => 'Novoshahtinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11053 => {
             name => 'Шахты', 
             ua_name => 'Шахти', 
             tr_name => 'Şahty', 
             ename => 'Shakhty',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11055 => {
             name => 'Будённовск', 
             ua_name => 'Будьоновськ', 
             tr_name => 'Budennovsk', 
             ename => 'Budennovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069, 99456 ], 
             childs => [  ], 
        },
        
        11056 => {
             name => 'Георгиевск', 
             ua_name => 'Георгієвськ', 
             tr_name => 'Georgievsk', 
             ename => 'Georgievsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11057 => {
             name => 'Ессентуки', 
             ua_name => 'Єсентуки', 
             tr_name => 'Essentuky', 
             ename => 'Essentuky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        1106 => {
             name => 'Грозный', 
             ua_name => 'Грозний', 
             tr_name => 'Grozni', 
             ename => 'Grozniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11024 ], 
             childs => [  ], 
        },
        
        11062 => {
             name => 'Кисловодск', 
             ua_name => 'Кисловодськ', 
             tr_name => 'Kislovodsk', 
             ename => 'Kislovodsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11063 => {
             name => 'Минеральные Воды', 
             ua_name => 'Мінеральні Води', 
             tr_name => 'Mineralniye Vodi', 
             ename => 'Mineralniye Vodi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11064 => {
             name => 'Невинномысск', 
             ua_name => 'Невинномиськ', 
             tr_name => 'Nevinnomissk', 
             ename => 'Nevinnomissk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11067 => {
             name => 'Пятигорск', 
             ua_name => 'П\'ятигорськ', 
             tr_name => 'Pyatigorsk', 
             ename => 'Pyatigorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11069 => {
             name => 'Ставропольский край', 
             ua_name => 'Ставропольський край', 
             tr_name => 'Stavropolski krayı', 
             ename => 'Stavropol Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 36, 11056, 11057, 11062, 11063, 11064, 11067, 99456 ], 
        },
        
        1107 => {
             name => 'Анапа', 
             ua_name => 'Анапа', 
             tr_name => 'Anapa', 
             ename => 'Anapa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        11070 => {
             name => 'Кировская область', 
             ua_name => 'Кіровська область', 
             tr_name => 'Kirovskaya oblastı', 
             ename => 'Kirov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 46, 11071, 20020 ], 
        },
        
        11071 => {
             name => 'Кирово-Чепецк', 
             ua_name => 'Кірово-Чепецьк', 
             tr_name => 'Kirovo-Chepetsk', 
             ename => 'Kirovo-Chepetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11070 ], 
             childs => [  ], 
        },
        
        11077 => {
             name => 'Республика Марий Эл', 
             ua_name => 'Республіка Марій Ел', 
             tr_name => 'Mariy El Cumhuriyeti', 
             ename => 'Mari El Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 41, 20721 ], 
        },
        
        11079 => {
             name => 'Нижегородская область', 
             ua_name => 'Нижегородська область', 
             tr_name => 'Nijegorodskaya oblastı', 
             ename => 'Nizhny Novgorod Oblast\'',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 47, 972, 11080, 11083, 20040, 99555, 99560 ], 
        },
        
        11080 => {
             name => 'Арзамас', 
             ua_name => 'Арзамас', 
             tr_name => 'Arzamas', 
             ename => 'Arzamas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        11082 => {
             name => 'Павлово', 
             ua_name => 'Павлово', 
             tr_name => 'Pavlovo', 
             ename => 'Pavlovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11079, 99560 ], 
             childs => [  ], 
        },
        
        11083 => {
             name => 'Саров', 
             ua_name => 'Саров', 
             tr_name => 'Sarov', 
             ename => 'Sarov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        11084 => {
             name => 'Оренбургская область', 
             ua_name => 'Оренбурзька область', 
             tr_name => 'Orenburgskaya oblastı', 
             ename => 'Orenburg Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 48, 11086, 11087, 11090, 11091 ], 
        },
        
        11086 => {
             name => 'Бузулук', 
             ua_name => 'Бузулук', 
             tr_name => 'Buzuluk', 
             ename => 'Buzuluk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        11087 => {
             name => 'Гай', 
             ua_name => 'Гай', 
             tr_name => 'Gay', 
             ename => 'Gay',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        11090 => {
             name => 'Новотроицк', 
             ua_name => 'Новотроїцьк', 
             tr_name => 'Novotroitsk', 
             ename => 'Novotroitsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        11091 => {
             name => 'Орск', 
             ua_name => 'Орськ', 
             tr_name => 'Orsk', 
             ename => 'Orsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        110916 => {
             name => 'Чайковский район', 
             ua_name => 'Чайковський район', 
             tr_name => 'Chaykovski İlçesi', 
             ename => 'Chaykovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [ 20243 ], 
        },
        
        110934 => {
             name => 'Сортавальский район', 
             ua_name => 'Сортавальський район', 
             tr_name => 'Sortavalski İlçesi', 
             ename => 'Sortavalsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [ 10937 ], 
        },
        
        11095 => {
             name => 'Пензенская область', 
             ua_name => 'Пензенська область', 
             tr_name => 'Penzenskaya oblastı', 
             ename => 'Penza Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 49, 11101 ], 
        },
        
        111 => {
             name => 'Европа', 
             ua_name => 'Європа', 
             tr_name => 'Avrupa', 
             ename => 'Europe',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 96, 102, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 179, 180, 203, 204, 205, 206, 246, 983, 10074, 10077, 10083, 20574, 21610 ], 
        },
        
        11101 => {
             name => 'Кузнецк', 
             ua_name => 'Кузнецьк', 
             tr_name => 'Kuznetsk', 
             ename => 'Kuznetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11095 ], 
             childs => [  ], 
        },
        
        11108 => {
             name => 'Пермский край', 
             ua_name => 'Пермський край', 
             tr_name => 'Permski krayı', 
             ename => 'Perm Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 50, 11110, 20237, 20244, 110916 ], 
        },
        
        11110 => {
             name => 'Соликамск', 
             ua_name => 'Солікамськ', 
             tr_name => 'Solikamsk', 
             ename => 'Solikamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        11111 => {
             name => 'Республика Башкортостан', 
             ua_name => 'Республіка Башкортостан', 
             tr_name => 'Başkurdistan', 
             ename => 'Republic of Bashkortostan',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 172, 11113, 11114, 11115, 11116, 20235, 20716, 99675, 99677, 99694, 99703, 99712, 99714 ], 
        },
        
        11113 => {
             name => 'Кумертау', 
             ua_name => 'Кумертау', 
             tr_name => 'Kumertau', 
             ename => 'Kumertau',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11114 => {
             name => 'Нефтекамск', 
             ua_name => 'Нефтекамськ', 
             tr_name => 'Neftekamsk', 
             ename => 'Nephtekamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11115 => {
             name => 'Салават', 
             ua_name => 'Салават', 
             tr_name => 'Salavat', 
             ename => 'Salavat',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11116 => {
             name => 'Стерлитамак', 
             ua_name => 'Стерлітамак', 
             tr_name => 'Sterlitamak', 
             ename => 'Sterlitamak',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11117 => {
             name => 'Республика Мордовия', 
             ua_name => 'Республіка Мордовія', 
             tr_name => 'Mordovya', 
             ename => 'Republic of Mordovia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 42, 99737 ], 
        },
        
        11119 => {
             name => 'Республика Татарстан', 
             ua_name => 'Республіка Татарстан', 
             tr_name => 'Tataristan', 
             ename => 'Republic of Tatarstan',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 43, 236, 11121, 11122, 11127, 11129 ], 
        },
        
        11121 => {
             name => 'Альметьевск', 
             ua_name => 'Альметьєвськ', 
             tr_name => 'Almetyevsk (Elmet)', 
             ename => 'Almetyevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11122 => {
             name => 'Бугульма', 
             ua_name => 'Бугульма', 
             tr_name => 'Bügülme', 
             ename => 'Bugulma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11127 => {
             name => 'Нижнекамск', 
             ua_name => 'Нижньокамськ', 
             tr_name => 'Nijnekamsk (Tüben Kama)', 
             ename => 'Nizhnekamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11129 => {
             name => 'Чистополь', 
             ua_name => 'Чистополь', 
             tr_name => 'Çistopol (Çistey)', 
             ename => 'Chistopol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11131 => {
             name => 'Самарская область', 
             ua_name => 'Самарська область', 
             tr_name => 'Samarskaya oblastı', 
             ename => 'Samara Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 51, 240, 11132, 11135, 11139 ], 
        },
        
        11132 => {
             name => 'Жигулёвск', 
             ua_name => 'Жигульовськ', 
             tr_name => 'Jiguliovsk', 
             ename => 'Zhiguliovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        11135 => {
             name => 'Новокуйбышевск', 
             ua_name => 'Новокуйбишевськ', 
             tr_name => 'Novokuybyşevsk', 
             ename => 'Novokuibishevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        11139 => {
             name => 'Сызрань', 
             ua_name => 'Сизрань', 
             tr_name => 'Syzran', 
             ename => 'Syzran',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        11143 => {
             name => 'Балаково', 
             ua_name => 'Балаково', 
             tr_name => 'Balakovo', 
             ename => 'Balakovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99817 ], 
             childs => [  ], 
        },
        
        11144 => {
             name => 'Балашов', 
             ua_name => 'Балашов', 
             tr_name => 'Balaşov', 
             ename => 'Balashev',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99818 ], 
             childs => [  ], 
        },
        
        11146 => {
             name => 'Саратовская область', 
             ua_name => 'Саратовська область', 
             tr_name => 'Saratovskaya oblastı', 
             ename => 'Saratov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 194, 99817, 99818, 99832, 99850 ], 
        },
        
        11147 => {
             name => 'Энгельс', 
             ua_name => 'Енгельс', 
             tr_name => 'Engels', 
             ename => 'Engels',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99850 ], 
             childs => [  ], 
        },
        
        11148 => {
             name => 'Удмуртская Республика', 
             ua_name => 'Удмуртська Республіка', 
             tr_name => 'Udmurtiya', 
             ename => 'Udmurt Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 44, 11149, 11150, 11152 ], 
        },
        
        11149 => {
             name => 'Воткинск', 
             ua_name => 'Воткінськ', 
             tr_name => 'Votkinsk', 
             ename => 'Votkinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        11150 => {
             name => 'Глазов', 
             ua_name => 'Глазов', 
             tr_name => 'Glazov', 
             ename => 'Glazov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        11152 => {
             name => 'Сарапул', 
             ua_name => 'Сарапул', 
             tr_name => 'Sarapul', 
             ename => 'Sarapul',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        11153 => {
             name => 'Ульяновская область', 
             ua_name => 'Ульяновська область', 
             tr_name => 'Ulyanovskaya oblastı', 
             ename => 'Ulyanovsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 195, 11155, 20070 ], 
        },
        
        11155 => {
             name => 'Димитровград', 
             ua_name => 'Дімітровград', 
             tr_name => 'Dmitrovgrad', 
             ename => 'Dimitrovgrad',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11153 ], 
             childs => [  ], 
        },
        
        11156 => {
             name => 'Чувашская Республика', 
             ua_name => 'Чуваська Республіка', 
             tr_name => 'Çuvaşya', 
             ename => 'Chuvash Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 45, 20078, 37133 ], 
        },
        
        11158 => {
             name => 'Курганская область', 
             ua_name => 'Курганська область', 
             tr_name => 'Kurganskaya oblastı', 
             ename => 'Kurgan Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 53, 11159 ], 
        },
        
        11159 => {
             name => 'Шадринск', 
             ua_name => 'Шадрінськ', 
             tr_name => 'Şadrinsk', 
             ename => 'Shadrinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11158 ], 
             childs => [  ], 
        },
        
        11160 => {
             name => 'Асбест', 
             ua_name => 'Асбест', 
             tr_name => 'Asbest', 
             ename => 'Asbest',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11161 => {
             name => 'Верхняя Салда', 
             ua_name => 'Верхня Салда', 
             tr_name => 'Verhniaya Salda', 
             ename => 'Verhnya Salda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11162 => {
             name => 'Свердловская область', 
             ua_name => 'Свердловська область', 
             tr_name => 'Sverdlovskaya oblastı', 
             ename => 'Sverdlovsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 54, 11160, 11161, 11164, 11165, 11166, 11167, 11168, 11169, 11170, 11171, 11172, 20224, 20234, 20579, 20654, 20672, 20684, 20691, 20720, 21726, 29397 ], 
        },
        
        11164 => {
             name => 'Каменск-Уральский', 
             ua_name => 'Каменськ-Уральський', 
             tr_name => 'Kamensk-Uralski', 
             ename => 'Kamensk-Uralskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11165 => {
             name => 'Краснотурьинск', 
             ua_name => 'Краснотур\'їнськ', 
             tr_name => 'Krasnoturyinsk', 
             ename => 'Krasnoturinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11166 => {
             name => 'Кушва', 
             ua_name => 'Кушва', 
             tr_name => 'Kuşva', 
             ename => 'Kushva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11167 => {
             name => 'Лесной', 
             ua_name => 'Лєсний', 
             tr_name => 'Lesnoy', 
             ename => 'Lesnoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11168 => {
             name => 'Нижний Тагил', 
             ua_name => 'Нижній Тагіл', 
             tr_name => 'Nijni Tagil', 
             ename => 'Nizhniy Tagil',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11169 => {
             name => 'Нижняя Тура', 
             ua_name => 'Нижня Тура', 
             tr_name => 'Nijniaya Tura', 
             ename => 'Nignaya Tura',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11170 => {
             name => 'Новоуральск', 
             ua_name => 'Новоуральськ', 
             tr_name => 'Novouralsk', 
             ename => 'Novouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11171 => {
             name => 'Первоуральск', 
             ua_name => 'Первоуральськ', 
             tr_name => 'Pervouralsk', 
             ename => 'Pervouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11172 => {
             name => 'Серов', 
             ua_name => 'Сєров', 
             tr_name => 'Serov', 
             ename => 'Serov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11173 => {
             name => 'Ишим', 
             ua_name => 'Ішим', 
             tr_name => 'İşim', 
             ename => 'Ishim',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        11175 => {
             name => 'Тобольск', 
             ua_name => 'Тобольськ', 
             tr_name => 'Tobolsk', 
             ename => 'Tobolsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        11176 => {
             name => 'Тюменская область', 
             ua_name => 'Тюменська область', 
             tr_name => 'Tümen (Tiumenskaya) oblastı', 
             ename => 'Tyumen Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 55, 11173, 11175, 11178 ], 
        },
        
        11177 => {
             name => 'Югорск', 
             ua_name => 'Югорськ', 
             tr_name => 'Ugorsk', 
             ename => 'Ugorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11178 => {
             name => 'Ялуторовск', 
             ua_name => 'Ялуторовськ', 
             tr_name => 'Yalutorovsk', 
             ename => 'Yalutorovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        11180 => {
             name => 'Когалым', 
             ua_name => 'Когалим', 
             tr_name => 'Kogalym', 
             ename => 'Kogalym',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11181 => {
             name => 'Лангепас', 
             ua_name => 'Лангепас', 
             tr_name => 'Langepas', 
             ename => 'Langepas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11182 => {
             name => 'Мегион', 
             ua_name => 'Мегіон', 
             tr_name => 'Megion', 
             ename => 'Megion',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11184 => {
             name => 'Нефтеюганск', 
             ua_name => 'Нефтеюганськ', 
             tr_name => 'Nefteyugansk', 
             ename => 'Nefteugansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11186 => {
             name => 'Нягань', 
             ua_name => 'Нягань', 
             tr_name => 'Niagan', 
             ename => 'Nyagan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11188 => {
             name => 'Пыть-Ях', 
             ua_name => 'Пить-Ях', 
             tr_name => 'Pyt-Yah', 
             ename => 'Pyt-Yah',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11189 => {
             name => 'Радужный', 
             ua_name => 'Радужний', 
             tr_name => 'Radujny', 
             ename => 'Radugniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11192 => {
             name => 'Урай', 
             ua_name => 'Урай', 
             tr_name => 'Uray', 
             ename => 'Uray',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11193 => {
             name => 'Ханты-Мансийский автономный округ - Югра', 
             ua_name => 'Ханти-Мансійський автономний округ', 
             tr_name => 'Hantı-Mansi Özerk Okrugu', 
             ename => 'Khanty-Mansi Autonomous Okrug — Yugra',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 57, 973, 1091, 11177, 11180, 11181, 11182, 11184, 11186, 11188, 11189, 11192 ], 
        },
        
        11196 => {
             name => 'Аша', 
             ua_name => 'Аша', 
             tr_name => 'Aşa', 
             ename => 'Asha',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 52, 11225, 100005 ], 
             childs => [  ], 
        },
        
        11200 => {
             name => 'Верхний Уфалей', 
             ua_name => 'Верхній Уфалей', 
             tr_name => 'Verhni Ufaley', 
             ename => 'Verhniy Ufaley',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11202 => {
             name => 'Златоуст', 
             ua_name => 'Златоуст', 
             tr_name => 'Zlatoust', 
             ename => 'Zlatoust',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11207 => {
             name => 'Копейск', 
             ua_name => 'Копейськ', 
             tr_name => 'Kopeysk', 
             ename => 'Kopeysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11212 => {
             name => 'Миасс', 
             ua_name => 'Міас', 
             tr_name => 'Miass', 
             ename => 'Miass',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11214 => {
             name => 'Озёрск', 
             ua_name => 'Озерськ', 
             tr_name => 'Ozersk', 
             ename => 'Ozersk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11217 => {
             name => 'Сатка', 
             ua_name => 'Сатка', 
             tr_name => 'Satka', 
             ename => 'Satka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 52, 11225, 100020 ], 
             childs => [  ], 
        },
        
        11218 => {
             name => 'Снежинск', 
             ua_name => 'Снєжинськ', 
             tr_name => 'Snejinsk', 
             ename => 'Sneginsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11220 => {
             name => 'Троицк', 
             ua_name => 'Троїцьк', 
             tr_name => 'Troitsk', 
             ename => 'Troitsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11223 => {
             name => 'Усть-Катав', 
             ua_name => 'Усть-Катав', 
             tr_name => 'Ust-Katav', 
             ename => 'Ust-Katav',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11224 => {
             name => 'Чебаркуль', 
             ua_name => 'Чебаркуль', 
             tr_name => 'Çebarkul', 
             ename => 'Chebarkul',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11225 => {
             name => 'Челябинская область', 
             ua_name => 'Челябінська область', 
             tr_name => 'Çeliabinskaya oblastı', 
             ename => 'Chelyabinsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 56, 235, 11200, 11202, 11207, 11212, 11214, 11218, 11220, 11223, 11224, 11227, 100005, 100020 ], 
        },
        
        11227 => {
             name => 'Южноуральск', 
             ua_name => 'Южноуральськ', 
             tr_name => 'Yujnouralsk', 
             ename => 'Ugnouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11228 => {
             name => 'Губкинский', 
             ua_name => 'Губкинський', 
             tr_name => 'Gubkinski', 
             ename => 'Gubkinskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        11229 => {
             name => 'Надым', 
             ua_name => 'Надим', 
             tr_name => 'Nadym', 
             ename => 'Nadym',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 52, 11232, 100028 ], 
             childs => [  ], 
        },
        
        11230 => {
             name => 'Новый Уренгой', 
             ua_name => 'Новий Уренгой', 
             tr_name => 'Novy Urengoy', 
             ename => 'Noviy Urengoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        11231 => {
             name => 'Ноябрьск', 
             ua_name => 'Ноябрьськ', 
             tr_name => 'Noyabrsk', 
             ename => 'Noyabrsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        11232 => {
             name => 'Ямало-Ненецкий автономный округ', 
             ua_name => 'Ямало-Ненецький автономний округ', 
             tr_name => 'Yamal-Nenets Özerk Bölgesi', 
             ename => 'Yamalo-Nenets Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 58, 11228, 11230, 11231, 100028 ], 
        },
        
        11235 => {
             name => 'Алтайский край', 
             ua_name => 'Алтайський край', 
             tr_name => 'Altayski krayı', 
             ename => 'Altai Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 197, 975, 11240, 11246, 11251 ], 
        },
        
        11240 => {
             name => 'Заринск', 
             ua_name => 'Заринськ', 
             tr_name => 'Zarinsk', 
             ename => 'Zarinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        11246 => {
             name => 'Новоалтайск', 
             ua_name => 'Новоалтайськ', 
             tr_name => 'Novoaltaysk', 
             ename => 'Novoaltaysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        11251 => {
             name => 'Рубцовск', 
             ua_name => 'Рубцовськ', 
             tr_name => 'Rubtsovsk', 
             ename => 'Rubtsovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        11256 => {
             name => 'Ангарск', 
             ua_name => 'Ангара', 
             tr_name => 'Angarsk', 
             ename => 'Angarsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11266 => {
             name => 'Иркутская область', 
             ua_name => 'Іркутська область', 
             tr_name => 'İrkutskaya oblastı', 
             ename => 'Irkutsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 63, 976, 11256, 11271, 11272, 11273, 11274, 100109, 100112, 100116 ], 
        },
        
        11268 => {
             name => 'Нижнеудинск', 
             ua_name => 'Нижньоудинськ', 
             tr_name => 'Nizgneudinsk', 
             ename => 'Nizhneudinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11266, 100109 ], 
             childs => [  ], 
        },
        
        11270 => {
             name => 'Тайшет', 
             ua_name => 'Тайшет', 
             tr_name => 'Tayshet', 
             ename => 'Tayshet',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11266, 100112 ], 
             childs => [  ], 
        },
        
        11271 => {
             name => 'Тулун', 
             ua_name => 'Тулун', 
             tr_name => 'Tulun', 
             ename => 'Tulun',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11272 => {
             name => 'Усолье-Сибирское', 
             ua_name => 'Усольє-Сибірське', 
             tr_name => 'Usolye-Sibirskoye', 
             ename => 'Usole-Sibirskoe',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11273 => {
             name => 'Усть-Илимск', 
             ua_name => 'Усть-Ілімськ', 
             tr_name => 'Ust-Ilimsk', 
             ename => 'Ust-Ilimsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11274 => {
             name => 'Черемхово', 
             ua_name => 'Черемхово', 
             tr_name => 'Cheremkhovo', 
             ename => 'Cheremkhovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11276 => {
             name => 'Анжеро-Судженск', 
             ua_name => 'Анжеро-Судженськ', 
             tr_name => 'Anjero-Sudjensk', 
             ename => 'Angero-Sudgensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11277 => {
             name => 'Белово', 
             ua_name => 'Бєлово', 
             tr_name => 'Belovo', 
             ename => 'Belovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11278 => {
             name => 'Берёзовский (Кемеровская область)', 
             ua_name => 'Берёзовский (Кемеровская область)', 
             tr_name => 'Beriozovski (Kemerovskaya oblastı)', 
             ename => 'Berezovskiy (Kemerovo District)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11282 => {
             name => 'Кемеровская область (Кузбасс)', 
             ua_name => 'Кемеровская область (Кузбасс)', 
             tr_name => 'Kemerovskaya oblastı', 
             ename => 'Kemerovo Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 64, 237, 11276, 11277, 11278, 11283, 11285, 11287, 11288, 11291, 11292, 11299 ], 
        },
        
        11283 => {
             name => 'Киселёвск', 
             ua_name => 'Кисельовськ', 
             tr_name => 'Kiseliovsk', 
             ename => 'Kiselevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11285 => {
             name => 'Ленинск-Кузнецкий', 
             ua_name => 'Ленінськ-Кузнецький', 
             tr_name => 'Leninsk-Kuznetski', 
             ename => 'Leninsk-Kuznetskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11287 => {
             name => 'Междуреченск', 
             ua_name => 'Мєждуреченськ', 
             tr_name => 'Mejdureçensk', 
             ename => 'Mezgdurechensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11288 => {
             name => 'Мыски', 
             ua_name => 'Миски', 
             tr_name => 'Myski', 
             ename => 'Myski',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11291 => {
             name => 'Прокопьевск', 
             ua_name => 'Прокоп\'євськ', 
             tr_name => 'Prokopyevsk', 
             ename => 'Prokopevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11292 => {
             name => 'Полысаево', 
             ua_name => 'Полисаєво', 
             tr_name => 'Polysayevo', 
             ename => 'Polysaevo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11299 => {
             name => 'Юрга', 
             ua_name => 'Юрга', 
             tr_name => 'Yurga', 
             ename => 'Urga',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        113 => {
             name => 'Австрия', 
             ua_name => 'Австрія', 
             tr_name => 'Avusturya', 
             ename => 'Austria',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        11302 => {
             name => 'Ачинск', 
             ua_name => 'Ачинськ', 
             tr_name => 'Achinsk', 
             ename => 'Achinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11304 => {
             name => 'Енисейск', 
             ua_name => 'Єнісейськ', 
             tr_name => 'Eniseysk', 
             ename => 'Eniseysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11309 => {
             name => 'Красноярский край', 
             ua_name => 'Красноярський край', 
             tr_name => 'Krasnoyarski krayı', 
             ename => 'Krasnoyarsk Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 62, 11302, 11304, 11310, 11311, 20086, 20088 ], 
        },
        
        11310 => {
             name => 'Минусинск', 
             ua_name => 'Мінусинськ', 
             tr_name => 'Minusinsk', 
             ename => 'Minusinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11311 => {
             name => 'Норильск', 
             ua_name => 'Норильськ', 
             tr_name => 'Norilsk', 
             ename => 'Norilsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11314 => {
             name => 'Бердск', 
             ua_name => 'Бердськ', 
             tr_name => 'Berdsk', 
             ename => 'Berdsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [  ], 
        },
        
        11316 => {
             name => 'Новосибирская область', 
             ua_name => 'Новосибірська область', 
             tr_name => 'Novosibirskaya oblastı', 
             ename => 'Novosibirsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 65, 11314, 20100, 100183, 100189 ], 
        },
        
        11318 => {
             name => 'Омская область', 
             ua_name => 'Омська область', 
             tr_name => 'Omskaya oblastı', 
             ename => 'Omsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 66 ], 
        },
        
        11319 => {
             name => 'Горно-Алтайск', 
             ua_name => 'Горно-Алтайськ', 
             tr_name => 'Gorno-Altaysk', 
             ename => 'Gorno-Altaysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 10231 ], 
             childs => [  ], 
        },
        
        11327 => {
             name => 'Северобайкальск', 
             ua_name => 'Сєвєробайкальськ', 
             tr_name => 'Severobaykalsk', 
             ename => 'Severobaykalsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [  ], 
        },
        
        11330 => {
             name => 'Республика Бурятия', 
             ua_name => 'Республіка Бурятія', 
             tr_name => 'Buriatya', 
             ename => 'Republic of Buryatia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 198, 11327, 100244 ], 
        },
        
        11333 => {
             name => 'Кызыл', 
             ua_name => 'Кизил', 
             tr_name => 'Kızıl', 
             ename => 'Kyzyl',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 10233 ], 
             childs => [  ], 
        },
        
        11340 => {
             name => 'Республика Хакасия', 
             ua_name => 'Республіка Хакасія', 
             tr_name => 'Hakasya', 
             ename => 'Republic of Khakassia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 1095 ], 
        },
        
        11349 => {
             name => 'Колпашево', 
             ua_name => 'Колпашево', 
             tr_name => 'Kolpaşevo', 
             ename => 'Kolpashevo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11353, 100280 ], 
             childs => [  ], 
        },
        
        11351 => {
             name => 'Северск', 
             ua_name => 'Сєвєрськ', 
             tr_name => 'Seversk', 
             ename => 'Seversk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [  ], 
        },
        
        11352 => {
             name => 'Стрежевой', 
             ua_name => 'Стрежевий', 
             tr_name => 'Strejevoy', 
             ename => 'Strezgevoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [  ], 
        },
        
        11353 => {
             name => 'Томская область', 
             ua_name => 'Томська область', 
             tr_name => 'Tomskaya oblastı', 
             ename => 'Tomsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 67, 11351, 11352, 100278, 100280 ], 
        },
        
        11374 => {
             name => 'Белогорск', 
             ua_name => 'Бєлогорськ', 
             tr_name => 'Belogorsk', 
             ename => 'Belogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        11375 => {
             name => 'Амурская область', 
             ua_name => 'Амурська область', 
             tr_name => 'Amursk Bölgesi', 
             ename => 'Amur Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 77, 11374, 11387, 11391 ], 
        },
        
        11387 => {
             name => 'Свободный', 
             ua_name => 'Свободний', 
             tr_name => 'Svobodniy', 
             ename => 'Svobodniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        11391 => {
             name => 'Тында', 
             ua_name => 'Тинда', 
             tr_name => 'Tynda', 
             ename => 'Tynda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        11393 => {
             name => 'Биробиджан', 
             ua_name => 'Біробіджан', 
             tr_name => 'Birobidgan', 
             ename => 'Birobidgan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 10243 ], 
             childs => [  ], 
        },
        
        11398 => {
             name => 'Камчатский край', 
             ua_name => 'Камчатський край', 
             tr_name => 'Kamçatski krayı', 
             ename => 'Kamchatka Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 78 ], 
        },
        
        114 => {
             name => 'Бельгия', 
             ua_name => 'Бельгія', 
             tr_name => 'Belçika', 
             ename => 'Belgium',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        11403 => {
             name => 'Магаданская область', 
             ua_name => 'Магаданська область', 
             tr_name => 'Magadan Bölgesi', 
             ename => 'Magadan District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 79 ], 
        },
        
        11405 => {
             name => 'Арсеньев', 
             ua_name => 'Арсеньєв', 
             tr_name => 'Arsenev', 
             ename => 'Arsenev',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11406 => {
             name => 'Артём', 
             ua_name => 'Артем', 
             tr_name => 'Artem', 
             ename => 'Artem',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11409 => {
             name => 'Приморский край', 
             ua_name => 'Приморський край', 
             tr_name => 'Primoriye', 
             ename => 'Primorsky Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 75, 974, 11405, 11406, 11411, 11425, 11426 ], 
        },
        
        11411 => {
             name => 'Дальнегорск', 
             ua_name => 'Дальнєгорськ', 
             tr_name => 'Dalnegorsk', 
             ename => 'Dalnegorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11425 => {
             name => 'Спасск-Дальний', 
             ua_name => 'Спаськ-Дальній', 
             tr_name => 'Spassk-Dalniy', 
             ename => 'Spassk-Dalniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11426 => {
             name => 'Уссурийск', 
             ua_name => 'Уссурійськ', 
             tr_name => 'Ussuriysk', 
             ename => 'Ussuriysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11437 => {
             name => 'Нерюнгри', 
             ua_name => 'Нерюнгрі', 
             tr_name => 'Nerungri', 
             ename => 'Nerungri',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 73, 11443, 101987 ], 
             childs => [  ], 
        },
        
        11443 => {
             name => 'Республика Саха (Якутия)', 
             ua_name => 'Республіка Саха (Якутія)', 
             tr_name => 'Saha Cumhuriyeti (Yakutistan)', 
             ename => 'Sakha (Yakutia) Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 74, 101987 ], 
        },
        
        11450 => {
             name => 'Сахалинская область', 
             ua_name => 'Сахалінська область', 
             tr_name => 'Sahalin Bölgesi', 
             ename => 'Sakhalin District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 80, 20160 ], 
        },
        
        11451 => {
             name => 'Амурск', 
             ua_name => 'Амурськ', 
             tr_name => 'Amursk', 
             ename => 'Amursk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 73, 11457, 100398 ], 
             childs => [  ], 
        },
        
        11453 => {
             name => 'Комсомольск-на-Амуре', 
             ua_name => 'Комсомольськ-на-Амурі', 
             tr_name => 'Komsomolsk-at-Amur', 
             ename => 'Komsomolsk-at-Amur',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [  ], 
        },
        
        11457 => {
             name => 'Хабаровский край', 
             ua_name => 'Хабаровський край', 
             tr_name => 'Habarovski krayı', 
             ename => 'Khabarovsk Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 76, 11453, 100398 ], 
        },
        
        11463 => {
             name => 'Евпатория', 
             ua_name => 'Євпаторія', 
             tr_name => 'Yevpatorya', 
             ename => 'Evpatoria',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        11464 => {
             name => 'Керчь', 
             ua_name => 'Керч', 
             tr_name => 'Kerç', 
             ename => 'Kerch',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        11469 => {
             name => 'Феодосия', 
             ua_name => 'Феодосія', 
             tr_name => 'Feodosya (Kefe)', 
             ename => 'Feodosia',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        11470 => {
             name => 'Ялта', 
             ua_name => 'Ялта', 
             tr_name => 'Yalta', 
             ename => 'Yalta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        11471 => {
             name => 'Алушта', 
             ua_name => 'Алушта', 
             tr_name => 'Aluşta', 
             ename => 'Alushta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        11472 => {
             name => 'Судак', 
             ua_name => 'Судак', 
             tr_name => 'Sudak', 
             ename => 'Sudak',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        11474 => {
             name => 'Рига', 
             ua_name => 'Рига', 
             tr_name => 'Riga', 
             ename => 'Riga',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 111, 206 ], 
             childs => [  ], 
        },
        
        11475 => {
             name => 'Вильнюс', 
             ua_name => 'Вільнюс', 
             tr_name => 'Vilnus', 
             ename => 'Vilnius',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 117, 104260 ], 
             childs => [  ], 
        },
        
        11481 => {
             name => 'Таллин', 
             ua_name => 'Таллінн', 
             tr_name => 'Tallin', 
             ename => 'Tallinn',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 179, 104431 ], 
             childs => [  ], 
        },
        
        11482 => {
             name => 'Тарту', 
             ua_name => 'Тарту', 
             tr_name => 'Tartu', 
             ename => 'Tartu',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 179, 104430 ], 
             childs => [  ], 
        },
        
        114900 => {
             name => 'Чирчик', 
             ua_name => 'Чирчик', 
             tr_name => 'Çırçık', 
             ename => 'Chirchiq',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        115 => {
             name => 'Болгария', 
             ua_name => 'Болгарія', 
             tr_name => 'Bulgaristan', 
             ename => 'Bulgaria',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        116 => {
             name => 'Венгрия', 
             ua_name => 'Угорщина', 
             tr_name => 'Macaristan', 
             ename => 'Hungary',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        116114 => {
             name => 'Ришон-ле-Цион', 
             ua_name => 'Рішон-ле-Ціон', 
             tr_name => 'Rişon LeTsiyon', 
             ename => 'Rishon LeZion',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103900 ], 
             childs => [  ], 
        },
        
        116777 => {
             name => 'Панфиловский район', 
             ua_name => 'Панфіловський район', 
             tr_name => 'Panfilov ilçesi', 
             ename => 'Panfilov District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116778 => {
             name => 'Жамбылский район', 
             ua_name => 'Жамбилський район', 
             tr_name => 'Jambıl ilçesi', 
             ename => 'Zhambyl District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116779 => {
             name => 'Илийский район', 
             ua_name => 'Ілійський район', 
             tr_name => 'İle ilçesi', 
             ename => 'Ile District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116780 => {
             name => 'Карасайский район', 
             ua_name => 'Карасайський район', 
             tr_name => 'Karasay ilçesi', 
             ename => 'Karasay District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116781 => {
             name => 'Талгарский район', 
             ua_name => 'Талгарський район', 
             tr_name => 'Talgar ilçesi', 
             ename => 'Talgar District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116782 => {
             name => 'Енбекшиказахский район', 
             ua_name => 'Єнбекшиказахський район', 
             tr_name => 'Yenbekşikazak ilçesi', 
             ename => 'Enbekshikazakh District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116939 => {
             name => 'Казыгуртский район', 
             ua_name => 'Казигуртський район', 
             tr_name => 'Kazığurt ilçesi', 
             ename => 'Kazygurt District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116940 => {
             name => 'Мактааральский район', 
             ua_name => 'Мактааральський район', 
             tr_name => 'Maktaaral ilçesi', 
             ename => 'Maktaaral District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116941 => {
             name => 'Ордабасинский район', 
             ua_name => 'Ордабасинський район', 
             tr_name => 'Ordabası ilçesi', 
             ename => 'Ordabasy District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116943 => {
             name => 'Сайрамский район', 
             ua_name => 'Сайрамський район', 
             tr_name => 'Sayram ilçesi', 
             ename => 'Sayram District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116944 => {
             name => 'Сарыагашский район', 
             ua_name => 'Сариагашський район', 
             tr_name => 'Sarıağaş ilçesi', 
             ename => 'Saryagash District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116946 => {
             name => 'Толебийский район', 
             ua_name => 'Толебійський район', 
             tr_name => 'Töle Biy ilçesi', 
             ename => 'Tole Bi District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116947 => {
             name => 'Тюлькубасский район', 
             ua_name => 'Тюлькубаський район', 
             tr_name => 'Tülkibas ilçesi', 
             ename => 'Tulkibas District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116948 => {
             name => 'Шардаринский район', 
             ua_name => 'Шардаринський район', 
             tr_name => 'Şardara ilçesi', 
             ename => 'Shardara District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116954 => {
             name => 'Мунайлинский район', 
             ua_name => 'Мунайлінський район', 
             tr_name => 'Munaylı ilçesi', 
             ename => 'Munaily District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29414 ], 
             childs => [  ], 
        },
        
        116960 => {
             name => 'Кордайский район', 
             ua_name => 'Кордайський район', 
             tr_name => 'Korday ilçesi', 
             ename => 'Korday District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29409 ], 
             childs => [  ], 
        },
        
        117 => {
             name => 'Литва', 
             ua_name => 'Литва', 
             tr_name => 'Litvanya', 
             ename => 'Lithuania',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104260 ], 
        },
        
        118 => {
             name => 'Нидерланды', 
             ua_name => 'Нідерланди', 
             tr_name => 'Hollanda', 
             ename => 'Netherlands',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        119 => {
             name => 'Норвегия', 
             ua_name => 'Норвегія', 
             tr_name => 'Norveç', 
             ename => 'Norway',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        12 => {
             name => 'Смоленск', 
             ua_name => 'Смоленськ', 
             tr_name => 'Smolensk', 
             ename => 'Smolensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [  ], 
        },
        
        120 => {
             name => 'Польша', 
             ua_name => 'Польща', 
             tr_name => 'Polonya', 
             ename => 'Poland',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        121 => {
             name => 'Словакия', 
             ua_name => 'Словаччина', 
             tr_name => 'Slovakya', 
             ename => 'Slovakia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        122 => {
             name => 'Словения', 
             ua_name => 'Словенія', 
             tr_name => 'Slovenya', 
             ename => 'Slovenia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        122054 => {
             name => 'Автономная Республика Аджария', 
             ua_name => 'Автономна Республіка Аджарія', 
             tr_name => 'Acara Özerk Cumhuriyeti', 
             ename => 'Autonomous Republic of Adjara',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [ 10278 ], 
        },
        
        122055 => {
             name => 'Гурия', 
             ua_name => 'Гурія', 
             tr_name => 'Guria', 
             ename => 'Guria',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122056 => {
             name => 'Имеретия', 
             ua_name => 'Імеретія', 
             tr_name => 'İmereti', 
             ename => 'Imereti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122057 => {
             name => 'Кахетия', 
             ua_name => 'Кахетія', 
             tr_name => 'Kaheti', 
             ename => 'Kakheti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122058 => {
             name => 'Мцхета-Мтианети', 
             ua_name => 'Мцхета-Мтіанетія', 
             tr_name => 'Mtsheta-Mtianeti', 
             ename => 'Mtskheta-Mtianeti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122059 => {
             name => 'Рача-Лечхуми и Квемо-Сванети', 
             ua_name => 'Рача-Лечхумі і Квемо-Сванетія', 
             tr_name => 'Raca-Leçhumi ve Kvemo Svaneti', 
             ename => 'Racha-Lechkhumi and Kvemo Svaneti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122060 => {
             name => 'Самегрело и Земо-Сванети', 
             ua_name => 'Самегрело і Земо-Сванетія', 
             tr_name => 'Samegrelo-Zemo Svaneti', 
             ename => 'Samegrelo-Zemo Svaneti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122061 => {
             name => 'Самцхе-Джавахети', 
             ua_name => 'Самцхе-Джавахетія', 
             tr_name => 'Samtshe-Cavaheti', 
             ename => 'Samtskhe-Javakheti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122062 => {
             name => 'Квемо-Картли', 
             ua_name => 'Квемо-Картлі', 
             tr_name => 'Kvemo Kartli', 
             ename => 'Kvemo Kartli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [ 10285 ], 
        },
        
        122063 => {
             name => 'Шида-Картли', 
             ua_name => 'Шида-Картлі', 
             tr_name => 'Şida Kartli', 
             ename => 'Shida Kartli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        123 => {
             name => 'Финляндия', 
             ua_name => 'Фінляндія', 
             tr_name => 'Finlandiya', 
             ename => 'Finland',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104357 ], 
        },
        
        124 => {
             name => 'Франция', 
             ua_name => 'Франція', 
             tr_name => 'Fransa', 
             ename => 'France',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        125 => {
             name => 'Чехия', 
             ua_name => 'Чехія', 
             tr_name => 'Çek Cumhuriyeti', 
             ename => 'Czech Republic',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        126 => {
             name => 'Швейцария', 
             ua_name => 'Швейцарія', 
             tr_name => 'İsviçre', 
             ename => 'Switzerland',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        127 => {
             name => 'Швеция', 
             ua_name => 'Швеція', 
             tr_name => 'İsveç', 
             ename => 'Sweden',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        13 => {
             name => 'Тамбов', 
             ua_name => 'Тамбов', 
             tr_name => 'Tambov', 
             ename => 'Tambov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10802 ], 
             childs => [  ], 
        },
        
        131 => {
             name => 'Тель-Авив', 
             ua_name => 'Тель-Авів', 
             tr_name => 'Tel Aviv', 
             ename => 'Tel Aviv',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103905 ], 
             childs => [  ], 
        },
        
        132 => {
             name => 'Хайфа', 
             ua_name => 'Хайфа', 
             tr_name => 'Hayfa', 
             ename => 'Haifa',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103901 ], 
             childs => [  ], 
        },
        
        134 => {
             name => 'Китай', 
             ua_name => 'Китай', 
             tr_name => 'Çin', 
             ename => 'China',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        135 => {
             name => 'Южная Корея', 
             ua_name => 'Південна Корея', 
             tr_name => 'Güney Kore', 
             ename => 'South Korea',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        137 => {
             name => 'Япония', 
             ua_name => 'Японія', 
             tr_name => 'Japonya', 
             ename => 'Japan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        138 => {
             name => 'Австралия и Океания', 
             ua_name => 'Австралія та Океанія', 
             tr_name => 'Avustralya ve Okyanusya', 
             ename => 'Australia and Oceania',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 139, 211 ], 
        },
        
        139 => {
             name => 'Новая Зеландия', 
             ua_name => 'Нова Зеландія', 
             tr_name => 'Yeni Zelanda', 
             ename => 'New Zealand',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 138 ], 
             childs => [  ], 
        },
        
        14 => {
             name => 'Тверь', 
             ua_name => 'Твер', 
             tr_name => 'Tver', 
             ename => 'Tver',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        141 => {
             name => 'Днепр', 
             ua_name => 'Дніпро', 
             tr_name => 'Dnepropetrovsk', 
             ename => 'Dnipro',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        142 => {
             name => 'Донецк', 
             ua_name => 'Донецьк', 
             tr_name => 'Donetsk', 
             ename => 'Donetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        143 => {
             name => 'Киев', 
             ua_name => 'Київ', 
             tr_name => 'Kiev', 
             ename => 'Kyiv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20544 ], 
             childs => [  ], 
        },
        
        144 => {
             name => 'Львов', 
             ua_name => 'Львів', 
             tr_name => 'Lviv', 
             ename => 'Lviv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20529 ], 
             childs => [  ], 
        },
        
        145 => {
             name => 'Одесса', 
             ua_name => 'Одеса', 
             tr_name => 'Odesa', 
             ename => 'Odesa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20541 ], 
             childs => [  ], 
        },
        
        146 => {
             name => 'Симферополь', 
             ua_name => 'Сімферополь', 
             tr_name => 'Simferopol (Akmescit)', 
             ename => 'Simferopol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        147 => {
             name => 'Харьков', 
             ua_name => 'Харків', 
             tr_name => 'Harkiv', 
             ename => 'Kharkiv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20538 ], 
             childs => [  ], 
        },
        
        148 => {
             name => 'Николаев', 
             ua_name => 'Миколаїв', 
             tr_name => 'Nikolaev', 
             ename => 'Mykolaiv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20543 ], 
             childs => [  ], 
        },
        
        149 => {
             name => 'Беларусь', 
             ua_name => 'Білорусь', 
             tr_name => 'Beyaz Rusya', 
             ename => 'Belarus',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 29629, 29630, 29631, 29632, 29633, 29634 ], 
        },
        
        15 => {
             name => 'Тула', 
             ua_name => 'Тула', 
             tr_name => 'Tula', 
             ename => 'Tula',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [  ], 
        },
        
        153 => {
             name => 'Брест', 
             ua_name => 'Брест', 
             tr_name => 'Brest', 
             ename => 'Brest',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [  ], 
        },
        
        154 => {
             name => 'Витебск', 
             ua_name => 'Вітебськ', 
             tr_name => 'Vitebsk', 
             ename => 'Vitebsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [  ], 
        },
        
        155 => {
             name => 'Гомель', 
             ua_name => 'Гомель', 
             tr_name => 'Gomel', 
             ename => 'Gomel',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [  ], 
        },
        
        157 => {
             name => 'Минск', 
             ua_name => 'Мінськ', 
             tr_name => 'Minsk', 
             ename => 'Minsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [  ], 
        },
        
        158 => {
             name => 'Могилёв', 
             ua_name => 'Могильов', 
             tr_name => 'Moguilev', 
             ename => 'Mogilev',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [  ], 
        },
        
        159 => {
             name => 'Казахстан', 
             ua_name => 'Казахстан', 
             tr_name => 'Kazakistan', 
             ename => 'Kazakhstan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 29403, 29404, 29406, 29407, 29408, 29409, 29410, 29411, 29412, 29413, 29414, 29415, 29416, 29417 ], 
        },
        
        16 => {
             name => 'Ярославль', 
             ua_name => 'Ярославль', 
             tr_name => 'Yaroslavl', 
             ename => 'Yaroslavl',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [  ], 
        },
        
        162 => {
             name => 'Алматы', 
             ua_name => 'Алмати', 
             tr_name => 'Almatı', 
             ename => 'Almaty',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        163 => {
             name => 'Нур-Султан', 
             ua_name => 'Нур-Султан', 
             tr_name => 'Nursultan', 
             ename => 'Nur-Sultan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29403 ], 
             childs => [  ], 
        },
        
        164 => {
             name => 'Караганда', 
             ua_name => 'Караганда', 
             tr_name => 'Karağandı', 
             ename => 'Karaganda',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        165 => {
             name => 'Семей', 
             ua_name => 'Семей', 
             tr_name => 'Semey', 
             ename => 'Semey',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29408 ], 
             childs => [  ], 
        },
        
        166 => {
             name => 'СНГ (исключая Россию)', 
             ua_name => 'СНД (за винятком Росії)', 
             tr_name => 'CIS (Rusya dahil değil)', 
             ename => 'CIS (except Russia)',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 2,             
             parents => [ 0 ], 
             childs => [ 149, 159, 167, 168, 170, 171, 187, 207, 208, 209, 29386, 29387 ], 
        },
        
        167 => {
             name => 'Азербайджан', 
             ua_name => 'Азербайджан', 
             tr_name => 'Azerbaycan', 
             ename => 'Azerbaijan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10253 ], 
        },
        
        168 => {
             name => 'Армения', 
             ua_name => 'Вірменія', 
             tr_name => 'Ermenistan', 
             ename => 'Armenia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10262, 105789, 105790, 105791, 105792, 105793, 105794, 105795, 105796, 105797, 105798 ], 
        },
        
        169 => {
             name => 'Грузия', 
             ua_name => 'Грузія', 
             tr_name => 'Gürcistan', 
             ename => 'Georgia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [ 10277, 122054, 122055, 122056, 122057, 122058, 122059, 122060, 122061, 122062, 122063 ], 
        },
        
        17 => {
             name => 'Северо-Запад', 
             ua_name => 'Північний Захід', 
             tr_name => 'Kuzeybatı Federal Bölgesi', 
             ename => 'Northwestern Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10174, 10176, 10842, 10853, 10857, 10897, 10904, 10926, 10933, 10939 ], 
        },
        
        170 => {
             name => 'Туркменистан', 
             ua_name => 'Туркменія', 
             tr_name => 'Türkmenistan', 
             ename => 'Turkmenistan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        171 => {
             name => 'Узбекистан', 
             ua_name => 'Узбекистан', 
             tr_name => 'Özbekistan', 
             ename => 'Uzbekistan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10335, 105804, 105805, 105806, 105807, 105808, 105809, 105810, 105811, 105812, 105813, 105814, 105815, 105816 ], 
        },
        
        172 => {
             name => 'Уфа', 
             ua_name => 'Уфа', 
             tr_name => 'Ufa', 
             ename => 'Ufa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        179 => {
             name => 'Эстония', 
             ua_name => 'Естонія', 
             tr_name => 'Estonya', 
             ename => 'Estonia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104430, 104431 ], 
        },
        
        18 => {
             name => 'Петрозаводск', 
             ua_name => 'Петрозаводськ', 
             tr_name => 'Petrozavodsk', 
             ename => 'Petrozavodsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [  ], 
        },
        
        180 => {
             name => 'Сербия', 
             ua_name => 'Сербія', 
             tr_name => 'Sırbistan', 
             ename => 'Serbia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104492 ], 
        },
        
        181 => {
             name => 'Израиль', 
             ua_name => 'Ізраїль', 
             tr_name => 'İsrail', 
             ename => 'Israel',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [ 103900, 103901, 103904, 103905 ], 
        },
        
        183 => {
             name => 'Азия', 
             ua_name => 'Азія', 
             tr_name => 'Asya', 
             ename => 'Asia',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 134, 135, 137, 169, 181, 210, 994, 995, 10095, 10540, 20975 ], 
        },
        
        187 => {
             name => 'Украина', 
             ua_name => 'Україна', 
             tr_name => 'Ukrayna', 
             ename => 'Ukraine',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 20529, 20530, 20531, 20532, 20533, 20534, 20535, 20536, 20537, 20538, 20539, 20540, 20541, 20542, 20543, 20544, 20545, 20546, 20547, 20548, 20549, 20550, 20551, 20552, 977 ], 
        },
        
        189657 => {
             name => 'Ахангаранский район', 
             ua_name => 'Ахангаранский район', 
             tr_name => 'Okhangaron District', 
             ename => 'Okhangaron District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [ 101550 ], 
        },
        
        19 => {
             name => 'Сыктывкар', 
             ua_name => 'Сиктивкар', 
             tr_name => 'Syktivkar', 
             ename => 'Syktyvkar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        190 => {
             name => 'Павлодар', 
             ua_name => 'Павлодар', 
             tr_name => 'Pavlodar', 
             ename => 'Pavlodar',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29415 ], 
             childs => [  ], 
        },
        
        191 => {
             name => 'Брянск', 
             ua_name => 'Брянськ', 
             tr_name => 'Briansk', 
             ename => 'Bryansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10650 ], 
             childs => [  ], 
        },
        
        192 => {
             name => 'Владимир', 
             ua_name => 'Владимир', 
             tr_name => 'Vladimir', 
             ename => 'Vladimir',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        193 => {
             name => 'Воронеж', 
             ua_name => 'Воронеж', 
             tr_name => 'Voronej', 
             ename => 'Voronezh',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10672 ], 
             childs => [  ], 
        },
        
        193330 => {
             name => 'Ходжейлийский район', 
             ua_name => 'Ходжейлийский район', 
             tr_name => 'Xo‘jayli District', 
             ename => 'Xojayli District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 171, 105816 ], 
             childs => [ 193331 ], 
        },
        
        193331 => {
             name => 'Ходжейли', 
             ua_name => 'Ходжейли', 
             tr_name => 'Xojayli', 
             ename => 'Xojayli',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105816, 193330 ], 
             childs => [  ], 
        },
        
        194 => {
             name => 'Саратов', 
             ua_name => 'Саратов', 
             tr_name => 'Saratov', 
             ename => 'Saratov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [  ], 
        },
        
        195 => {
             name => 'Ульяновск', 
             ua_name => 'Ульяновськ', 
             tr_name => 'Ulyanovsk', 
             ename => 'Ulyanovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11153 ], 
             childs => [  ], 
        },
        
        196979 => {
             name => 'Денауский район', 
             ua_name => 'Денауский район', 
             tr_name => 'Denau district', 
             ename => 'Denau district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 171, 105811 ], 
             childs => [ 196980 ], 
        },
        
        196980 => {
             name => 'Денау', 
             ua_name => 'Денау', 
             tr_name => 'Danau', 
             ename => 'Denau',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105811, 196979 ], 
             childs => [  ], 
        },
        
        197 => {
             name => 'Барнаул', 
             ua_name => 'Барнаул', 
             tr_name => 'Barnaul', 
             ename => 'Barnaul',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        198 => {
             name => 'Улан-Удэ', 
             ua_name => 'Улан-Уде', 
             tr_name => 'Ulan-Ude', 
             ename => 'Ulan-Ude',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [  ], 
        },
        
        2 => {
             name => 'Санкт-Петербург', 
             ua_name => 'Санкт-Петербург', 
             tr_name => 'Saint-Petersburg', 
             ename => 'Saint Petersburg',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 20293, 20297 ], 
        },
        
        20 => {
             name => 'Архангельск', 
             ua_name => 'Архангельськ', 
             tr_name => 'Arhangelsk', 
             ename => 'Arhangelsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        20010 => {
             name => 'Рузаевка', 
             ua_name => 'Рузаєвка', 
             tr_name => 'Ruzaevka', 
             ename => 'Ruzaevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11117, 99737 ], 
             childs => [  ], 
        },
        
        20020 => {
             name => 'Вятские Поляны', 
             ua_name => 'Вятські Поляни', 
             tr_name => 'Vyatskie Polyani', 
             ename => 'Vyatskie Polyani',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11070 ], 
             childs => [  ], 
        },
        
        20040 => {
             name => 'Выкса', 
             ua_name => 'Викса', 
             tr_name => 'Vyksa', 
             ename => 'Vyksa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        20044 => {
             name => 'Кстово', 
             ua_name => 'Кстово', 
             tr_name => 'Kstovo', 
             ename => 'Kstovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11079, 99555 ], 
             childs => [  ], 
        },
        
        20063 => {
             name => 'Маркс', 
             ua_name => 'Маркс', 
             tr_name => 'Marx', 
             ename => 'Marks',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99832 ], 
             childs => [  ], 
        },
        
        20070 => {
             name => 'Новоульяновск', 
             ua_name => 'Новоульяновськ', 
             tr_name => 'Novoulyanovsk', 
             ename => 'Novoulyanovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11153 ], 
             childs => [  ], 
        },
        
        20078 => {
             name => 'Шумерля', 
             ua_name => 'Шумерля', 
             tr_name => 'Shumerlya', 
             ename => 'Shumerlya',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11156 ], 
             childs => [  ], 
        },
        
        20086 => {
             name => 'Железногорск', 
             ua_name => 'Желєзногорськ', 
             tr_name => 'Zheleznogorsk', 
             ename => 'Zheleznogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        20088 => {
             name => 'Зеленогорск', 
             ua_name => 'Зеленогорськ', 
             tr_name => 'Zelenogorsk', 
             ename => 'Zelenogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        20097 => {
             name => 'Усть-Кут', 
             ua_name => 'Усть-Кут', 
             tr_name => 'Ust-Kut', 
             ename => 'Ust-Kut',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11266, 100116 ], 
             childs => [  ], 
        },
        
        20098 => {
             name => 'Барабинск', 
             ua_name => 'Барабінськ', 
             tr_name => 'Barabinsk', 
             ename => 'Barabinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11316, 100183 ], 
             childs => [  ], 
        },
        
        20100 => {
             name => 'Искитим', 
             ua_name => 'Іскітім', 
             tr_name => 'Iskitim', 
             ename => 'Iskitim',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [  ], 
        },
        
        20101 => {
             name => 'Карасук', 
             ua_name => 'Карасук', 
             tr_name => 'Karasuk', 
             ename => 'Karasuk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11316, 100189 ], 
             childs => [  ], 
        },
        
        20117 => {
             name => 'Новодвинск', 
             ua_name => 'Новодвінськ', 
             tr_name => 'Novodvinsk', 
             ename => 'Novodvinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        20139 => {
             name => 'Зеленоградск', 
             ua_name => 'Зеленоградськ', 
             tr_name => 'Zelenogradsk', 
             ename => 'Zelenogradsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        20144 => {
             name => 'Пионерский', 
             ua_name => 'Піонерський', 
             tr_name => 'Pionersky', 
             ename => 'Pionersky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        20155 => {
             name => 'Оленегорск', 
             ua_name => 'Оленьогорськ', 
             tr_name => 'Olenegorsk', 
             ename => 'Olenegorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        20160 => {
             name => 'Невельск', 
             ua_name => 'Невельськ', 
             tr_name => 'Nevelsk', 
             ename => 'Nevelsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11450 ], 
             childs => [  ], 
        },
        
        20167 => {
             name => 'Ахтубинск', 
             ua_name => 'Ахтубінськ', 
             tr_name => 'Ahtubinsk', 
             ename => 'Ahtubinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10946, 99221 ], 
             childs => [  ], 
        },
        
        20181 => {
             name => 'Магас', 
             ua_name => 'Магас', 
             tr_name => 'Magas', 
             ename => 'Magas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11012 ], 
             childs => [  ], 
        },
        
        20192 => {
             name => 'Алексеевка', 
             ua_name => 'Алексєєвка', 
             tr_name => 'Alekseyevka', 
             ename => 'Alekseevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10645, 98697 ], 
             childs => [  ], 
        },
        
        20196 => {
             name => 'Шебекино', 
             ua_name => 'Шебекіно', 
             tr_name => 'Shebekino', 
             ename => 'Shebekino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10645, 98716 ], 
             childs => [  ], 
        },
        
        20224 => {
             name => 'Ревда', 
             ua_name => 'Ревда', 
             tr_name => 'Revda', 
             ename => 'Revda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20234 => {
             name => 'Качканар', 
             ua_name => 'Качканар', 
             tr_name => 'Kaçkanar', 
             ename => 'Kachkanar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20235 => {
             name => 'Октябрьский', 
             ua_name => 'Октябрський', 
             tr_name => 'Oktiabrski', 
             ename => 'Oktyabrsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        20237 => {
             name => 'Березники', 
             ua_name => 'Березники', 
             tr_name => 'Berezniki', 
             ename => 'Berezniki',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        20243 => {
             name => 'Чайковский', 
             ua_name => 'Чайковський', 
             tr_name => 'Çaykovski', 
             ename => 'Chaikovsky',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11108, 110916 ], 
             childs => [  ], 
        },
        
        20244 => {
             name => 'Лысьва', 
             ua_name => 'Лисьва', 
             tr_name => 'Lysva', 
             ename => 'Lysva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        20259 => {
             name => 'Белорецк', 
             ua_name => 'Бєлорєцьк', 
             tr_name => 'Beloretsk', 
             ename => 'Beloretsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99677 ], 
             childs => [  ], 
        },
        
        20273 => {
             name => 'Актобе', 
             ua_name => 'Актобе', 
             tr_name => 'Aktöbe', 
             ename => 'Aktobe',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29404 ], 
             childs => [  ], 
        },
        
        20293 => {
             name => 'Колпинский район', 
             ua_name => 'Колпінський район', 
             tr_name => 'Kolpinski', 
             ename => 'Kolpinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 8,             
             parents => [ 0, 225, 17, 10174, 2 ], 
             childs => [ 26081 ], 
        },
        
        20297 => {
             name => 'Пушкинский район', 
             ua_name => 'Пушкінський район', 
             tr_name => 'Pushkinski', 
             ename => 'Pushkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 8,             
             parents => [ 0, 225, 17, 10174, 2 ], 
             childs => [ 10884 ], 
        },
        
        203 => {
             name => 'Дания', 
             ua_name => 'Данія', 
             tr_name => 'Danimarka', 
             ename => 'Denmark',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        204 => {
             name => 'Испания', 
             ua_name => 'Іспанія', 
             tr_name => 'İspanya', 
             ename => 'Spain',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        205 => {
             name => 'Италия', 
             ua_name => 'Італія', 
             tr_name => 'İtalya', 
             ename => 'Italy',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        20523 => {
             name => 'Электросталь', 
             ua_name => 'Електросталь', 
             tr_name => 'Elektrostal', 
             ename => 'Elektrostal',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20529 => {
             name => 'Львов и область', 
             ua_name => 'Львів і область', 
             tr_name => 'Lvivska oblastı', 
             ename => 'Lviv District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 144 ], 
        },
        
        20530 => {
             name => 'Ужгород и Закарпатская область', 
             ua_name => 'Ужгород і Закарпатська область', 
             tr_name => 'Zakarpatska oblastı', 
             ename => 'Zakarpattia District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20531 => {
             name => 'Тернополь и область', 
             ua_name => 'Тернопіль і область', 
             tr_name => 'Ternopol Bölgesi', 
             ename => 'Ternopil District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20532 => {
             name => 'Ивано-Франковск и область', 
             ua_name => 'Івано-Франківськ і область', 
             tr_name => 'Ivano-Frankovsk Bölgesi', 
             ename => 'Ivano-Frankovsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20533 => {
             name => 'Черновцы и область', 
             ua_name => 'Чернівці і область', 
             tr_name => 'Çernivtsi', 
             ename => 'Chernovtci District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20534 => {
             name => 'Ровно и область', 
             ua_name => 'Рівне і область', 
             tr_name => 'Rovno Bölgesi', 
             ename => 'Rovno District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20535 => {
             name => 'Хмельницкий и область', 
             ua_name => 'Хмельницький і область', 
             tr_name => 'Kimelnitsky Bölgesi', 
             ename => 'Khmelnitsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 961 ], 
        },
        
        20536 => {
             name => 'Донецк и область', 
             ua_name => 'Донецьк і область', 
             tr_name => 'Donetsk Bölgesi', 
             ename => 'Donetsk Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 142, 10366, 20554, 21774, 24876 ], 
        },
        
        20537 => {
             name => 'Днепр и область', 
             ua_name => 'Дніпро і область', 
             tr_name => 'Dnepropetrovsk Bölgesi', 
             ename => 'Dnipropetrovsk Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 141, 10347, 21773, 21775, 28401 ], 
        },
        
        20538 => {
             name => 'Харьков и область', 
             ua_name => 'Харків і область', 
             tr_name => 'Harkivska oblastı', 
             ename => 'Kharkiv Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 147 ], 
        },
        
        20539 => {
             name => 'Запорожье и область', 
             ua_name => 'Запоріжжя і область', 
             tr_name => 'Zaporoje Bölgesi', 
             ename => 'Zaporizhia Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 960 ], 
        },
        
        20540 => {
             name => 'Луганск и область', 
             ua_name => 'Луганськ і область', 
             tr_name => 'Lugansk Bölgesi', 
             ename => 'Luhansk Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 222, 24885, 24893 ], 
        },
        
        20541 => {
             name => 'Одесса и область', 
             ua_name => 'Одеса і область', 
             tr_name => 'Odessa Bölgesi', 
             ename => 'Odesa District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 145 ], 
        },
        
        20542 => {
             name => 'Херсон и область', 
             ua_name => 'Херсон і область', 
             tr_name => 'Kerson Bölgesi', 
             ename => 'Kherson District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 962 ], 
        },
        
        20543 => {
             name => 'Николаев и область', 
             ua_name => 'Миколаїв і область', 
             tr_name => 'Nikolayev Bölgesi', 
             ename => 'Mykolaiv District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 148 ], 
        },
        
        20544 => {
             name => 'Киев и область', 
             ua_name => 'Київ і область', 
             tr_name => 'Kiev Bölgesi', 
             ename => 'Kyiv Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 143, 10369 ], 
        },
        
        20545 => {
             name => 'Винница и область', 
             ua_name => 'Вінниця і область', 
             tr_name => 'Vinica Bölgesi', 
             ename => 'Vinnytsia Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 963 ], 
        },
        
        20546 => {
             name => 'Черкассы и область', 
             ua_name => 'Черкаси і область', 
             tr_name => 'Çerkassi Bölgesi', 
             ename => 'Cherkassi District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20547 => {
             name => 'Житомир и область', 
             ua_name => 'Житомир і область', 
             tr_name => 'Jytomyr', 
             ename => 'Zhytomyr Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20548 => {
             name => 'Кропивницкий и Кировоградская область', 
             ua_name => 'Кропивницький і Кіровоградська область', 
             tr_name => 'Kirovograd Bölgesi', 
             ename => 'Kirovohrad Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20549 => {
             name => 'Полтава и область', 
             ua_name => 'Полтава і область', 
             tr_name => 'Poltava Bölgesi', 
             ename => 'Poltava Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 964, 21609 ], 
        },
        
        20550 => {
             name => 'Луцк и Волынская область', 
             ua_name => 'Луцьк і Волинська область', 
             tr_name => 'Volyn oblastı', 
             ename => 'Volyn Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20551 => {
             name => 'Чернигов и область', 
             ua_name => 'Чернігів і область', 
             tr_name => 'Çernigov Bölgesi', 
             ename => 'Chernihiv Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 29053 ], 
        },
        
        20552 => {
             name => 'Сумы и область', 
             ua_name => 'Суми і область', 
             tr_name => 'Sumi Bölgesi', 
             ename => 'Sumi District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 965 ], 
        },
        
        20554 => {
             name => 'Краматорск', 
             ua_name => 'Краматорськ', 
             tr_name => 'Kramatorsk', 
             ename => 'Kramatorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        20556 => {
             name => 'Саки', 
             ua_name => 'Саки', 
             tr_name => 'Saki (Sak)', 
             ename => 'Saky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        20571 => {
             name => 'Жуковский', 
             ua_name => 'Жуковський', 
             tr_name => 'Jukovski', 
             ename => 'Zhukovskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20574 => {
             name => 'Кипр', 
             ua_name => 'Кіпр', 
             tr_name => 'Kıbrıs', 
             ename => 'Cyprus',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        20576 => {
             name => 'Протвино', 
             ua_name => 'Протвіно', 
             tr_name => 'Protvino', 
             ename => 'Protvino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20579 => {
             name => 'Белоярский', 
             ua_name => 'Білоярський', 
             tr_name => 'Beloyarski', 
             ename => 'Beloyarskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 7,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20587 => {
             name => 'Строитель', 
             ua_name => 'Будівельник', 
             tr_name => 'Stroitel', 
             ename => 'Stroitel',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10645, 98717 ], 
             childs => [  ], 
        },
        
        206 => {
             name => 'Латвия', 
             ua_name => 'Латвія', 
             tr_name => 'Letonya', 
             ename => 'Latvia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 11474 ], 
        },
        
        20654 => {
             name => 'Невьянск', 
             ua_name => 'Нев\'янськ', 
             tr_name => 'Nevyansk', 
             ename => 'Nevyansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20667 => {
             name => 'Богородицк', 
             ua_name => 'Богородицьк', 
             tr_name => 'Bogoroditsk', 
             ename => 'Bogoroditsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10832, 99044 ], 
             childs => [  ], 
        },
        
        20672 => {
             name => 'Североуральск', 
             ua_name => 'Сєвєроуральськ', 
             tr_name => 'Severouralsk', 
             ename => 'Severouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20674 => {
             name => 'Троицк', 
             ua_name => 'Троїцьк', 
             tr_name => 'Troitsk', 
             ename => 'Troitsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 213 ], 
             childs => [  ], 
        },
        
        20680 => {
             name => 'Учалы', 
             ua_name => 'Учали', 
             tr_name => 'Uçaly', 
             ename => 'Uchaly',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99714 ], 
             childs => [  ], 
        },
        
        20684 => {
             name => 'Реж', 
             ua_name => 'Реж', 
             tr_name => 'Rej', 
             ename => 'Rezh',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20691 => {
             name => 'Красноуфимск', 
             ua_name => 'Красноуфімськ', 
             tr_name => 'Krasnoufimsk', 
             ename => 'Krasnoufimsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        207 => {
             name => 'Киргизия', 
             ua_name => 'Киргизія', 
             tr_name => 'Kırgizistan', 
             ename => 'Kyrgyzstan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10309, 10310 ], 
        },
        
        20704 => {
             name => 'Славянск-на-Кубани', 
             ua_name => 'Славянськ-на-Кубані', 
             tr_name => 'Slaviansk-na-Kubani', 
             ename => 'Slavyansk-na-Kubani',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99293 ], 
             childs => [  ], 
        },
        
        20707 => {
             name => 'Курчатов', 
             ua_name => 'Курчатов', 
             tr_name => 'Kurçatov', 
             ename => 'Kurchatov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10705 ], 
             childs => [  ], 
        },
        
        20714 => {
             name => 'Белебей', 
             ua_name => 'Белебей', 
             tr_name => 'Belebey', 
             ename => 'Belebey',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99675 ], 
             childs => [  ], 
        },
        
        20715 => {
             name => 'Мелеуз', 
             ua_name => 'Мелеуз', 
             tr_name => 'Meleuz', 
             ename => 'Meleuz',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99703 ], 
             childs => [  ], 
        },
        
        20716 => {
             name => 'Сибай', 
             ua_name => 'Сібай', 
             tr_name => 'Sibay', 
             ename => 'Sibay',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        20717 => {
             name => 'Туймазы', 
             ua_name => 'Туймази', 
             tr_name => 'Tuymazy', 
             ename => 'Tuymazy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99712 ], 
             childs => [  ], 
        },
        
        20718 => {
             name => 'Ишимбай', 
             ua_name => 'Ішимбай', 
             tr_name => 'İşimbay', 
             ename => 'Ishimbay',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99694 ], 
             childs => [  ], 
        },
        
        20720 => {
             name => 'Верхняя Пышма', 
             ua_name => 'Верхня Пишма', 
             tr_name => 'Verhniaya Pyşma', 
             ename => 'Verhnyaya Pyshma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20721 => {
             name => 'Волжск', 
             ua_name => 'Волзьк', 
             tr_name => 'Volzhsk', 
             ename => 'Volzhsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11077 ], 
             childs => [  ], 
        },
        
        20728 => {
             name => 'Королёв', 
             ua_name => 'Корольов', 
             tr_name => 'Koroliov', 
             ename => 'Korolev',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20729 => {
             name => 'Бобруйск', 
             ua_name => 'Бобруйськ', 
             tr_name => 'Bobruisk', 
             ename => 'Bobruisk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [  ], 
        },
        
        20733 => {
             name => 'Кот-д’Ивуар', 
             ua_name => 'Кот-д\'Івуар', 
             tr_name => 'Fildişi Sahilleri', 
             ename => 'Côte d\'Ivoire',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 241 ], 
             childs => [ 20734 ], 
        },
        
        20734 => {
             name => 'Абиджан', 
             ua_name => 'Абіджан', 
             tr_name => 'Abican', 
             ename => 'Abidjan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 241, 20733 ], 
             childs => [  ], 
        },
        
        208 => {
             name => 'Молдова', 
             ua_name => 'Молдова', 
             tr_name => 'Moldova', 
             ename => 'Moldova',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10313 ], 
        },
        
        20809 => {
             name => 'Кокшетау', 
             ua_name => 'Кокшетау', 
             tr_name => 'Kökşetav', 
             ename => 'Kokshetau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29403 ], 
             childs => [  ], 
        },
        
        209 => {
             name => 'Таджикистан', 
             ua_name => 'Таджикистан', 
             tr_name => 'Tacikistan', 
             ename => 'Tajikistan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        20917 => {
             name => 'Доминиканская Республика', 
             ua_name => 'Домініканська Республіка', 
             tr_name => 'Dominik Cumhuriyeti', 
             ename => 'Dominican Republic',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        20968 => {
             name => 'Гватемала', 
             ua_name => 'Гватемала', 
             tr_name => 'Guatemala', 
             ename => 'Guatemala',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        20975 => {
             name => 'Камбоджа', 
             ua_name => 'Камбоджа', 
             tr_name => 'Kamboçya', 
             ename => 'Cambodia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        21 => {
             name => 'Вологда', 
             ua_name => 'Вологда', 
             tr_name => 'Vologda', 
             ename => 'Vologda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10853 ], 
             childs => [  ], 
        },
        
        210 => {
             name => 'Объединённые Арабские Эмираты', 
             ua_name => 'Об\'єднані Арабські Емірати', 
             tr_name => 'Birleşik Arap Emirlikleri', 
             ename => 'United Arab Emirates',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        21015 => {
             name => 'Барановичи', 
             ua_name => 'Барановичі', 
             tr_name => 'Baranavichy', 
             ename => 'Baranavichy',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [  ], 
        },
        
        21050 => {
             name => 'Кызылорда', 
             ua_name => 'Кизилорда', 
             tr_name => 'Kızılorda', 
             ename => 'Kyzylorda',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29413 ], 
             childs => [  ], 
        },
        
        21094 => {
             name => 'Тараз', 
             ua_name => 'Тараз', 
             tr_name => 'Taraz', 
             ename => 'Taraz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29409 ], 
             childs => [  ], 
        },
        
        211 => {
             name => 'Австралия', 
             ua_name => 'Австралія', 
             tr_name => 'Avustralya', 
             ename => 'Australia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 138 ], 
             childs => [  ], 
        },
        
        21105 => {
             name => 'Ургенч', 
             ua_name => 'Ургенч', 
             tr_name => 'Ürgenç', 
             ename => 'Urgench',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105815 ], 
             childs => [  ], 
        },
        
        21106 => {
             name => 'Туркестан', 
             ua_name => 'Туркестан', 
             tr_name => 'Türkistan', 
             ename => 'Turkestan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        21141 => {
             name => 'Тимашевск', 
             ua_name => 'Тимашевськ', 
             tr_name => 'Timaşovsk', 
             ename => 'Timashovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99297 ], 
             childs => [  ], 
        },
        
        21144 => {
             name => 'Лида', 
             ua_name => 'Ліда', 
             tr_name => 'Lida', 
             ename => 'Lida',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102125 ], 
             childs => [  ], 
        },
        
        21154 => {
             name => 'Тутаев', 
             ua_name => 'Тутаєв', 
             tr_name => 'Tutayev', 
             ename => 'Tutaev',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10841, 99078 ], 
             childs => [  ], 
        },
        
        21161 => {
             name => 'Усть-Баргузин', 
             ua_name => 'Усть-Баргузін', 
             tr_name => 'Ust-Barguzin', 
             ename => 'Ust\'-Barguzin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 73, 11330, 100244 ], 
             childs => [  ], 
        },
        
        21193 => {
             name => 'Борисов', 
             ua_name => 'Борисов', 
             tr_name => 'Borisov', 
             ename => 'Borisov',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102156 ], 
             childs => [  ], 
        },
        
        21271 => {
             name => 'Миоры', 
             ua_name => 'Міори', 
             tr_name => 'Miory', 
             ename => 'Miory',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102186 ], 
             childs => [  ], 
        },
        
        21274 => {
             name => 'Мозырь', 
             ua_name => 'Мозир', 
             tr_name => 'Mozyr', 
             ename => 'Mozyr',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102108 ], 
             childs => [  ], 
        },
        
        213 => {
             name => 'Москва', 
             ua_name => 'Москва', 
             tr_name => 'Moskova', 
             ename => 'Moscow',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 216, 20674, 21624 ], 
        },
        
        21314 => {
             name => 'Наманган', 
             ua_name => 'Наманган', 
             tr_name => 'Nemengan', 
             ename => 'Namangan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105809 ], 
             childs => [  ], 
        },
        
        214 => {
             name => 'Долгопрудный', 
             ua_name => 'Долгопрудний', 
             tr_name => 'Dolgoprudny', 
             ename => 'Dolgoprudniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        215 => {
             name => 'Дубна', 
             ua_name => 'Дубна', 
             tr_name => 'Dubna', 
             ename => 'Dubna',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21510 => {
             name => 'Пинск', 
             ua_name => 'Пінськ', 
             tr_name => 'Pinsk', 
             ename => 'Pinsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [  ], 
        },
        
        21521 => {
             name => 'Избербаш', 
             ua_name => 'Ізбербаш', 
             tr_name => 'Izberbash', 
             ename => 'Izberbash',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        216 => {
             name => 'Зеленоград', 
             ua_name => 'Зеленоград', 
             tr_name => 'Zelenograd', 
             ename => 'Zelenograd',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 213 ], 
             childs => [  ], 
        },
        
        21606 => {
             name => 'Джизак', 
             ua_name => 'Джизак', 
             tr_name => 'Cizzak', 
             ename => 'Dzhizak',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105806 ], 
             childs => [  ], 
        },
        
        21609 => {
             name => 'Кременчуг', 
             ua_name => 'Кременчук', 
             tr_name => 'Kremenchuk', 
             ename => 'Kremenchuk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20549 ], 
             childs => [  ], 
        },
        
        21610 => {
             name => 'Черногория', 
             ua_name => 'Чорногорія', 
             tr_name => 'Karadağ', 
             ename => 'Montenegro',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        21619 => {
             name => 'Фрязино', 
             ua_name => 'Фрязіно', 
             tr_name => 'Friazino', 
             ename => 'Fryazino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21621 => {
             name => 'Реутов', 
             ua_name => 'Реутов', 
             tr_name => 'Reutov', 
             ename => 'Reutov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21623 => {
             name => 'Ивантеевка', 
             ua_name => 'Івантєєвка', 
             tr_name => 'İvanteyevka', 
             ename => 'Ivanteevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        21624 => {
             name => 'Щербинка', 
             ua_name => 'Щербинка', 
             tr_name => 'Şçerbinka', 
             ename => 'Zcherbinka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 213 ], 
             childs => [  ], 
        },
        
        21625 => {
             name => 'Кубинка', 
             ua_name => 'Кубінка', 
             tr_name => 'Kubinka', 
             ename => 'Kubinka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98599 ], 
             childs => [  ], 
        },
        
        21627 => {
             name => 'Дедовск', 
             ua_name => 'Дєдовськ', 
             tr_name => 'Dedovsk', 
             ename => 'Dedovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98586 ], 
             childs => [  ], 
        },
        
        21630 => {
             name => 'Лыткарино', 
             ua_name => 'Литкаріно', 
             tr_name => 'Lytkarino', 
             ename => 'Lytkarino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21632 => {
             name => 'Белоозерский', 
             ua_name => 'Білоозерський', 
             tr_name => 'Belooziorski', 
             ename => 'Beloozerskij',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 3, 1, 98581 ], 
             childs => [  ], 
        },
        
        21635 => {
             name => 'Лосино-Петровский', 
             ua_name => 'Лосіно-Петровський', 
             tr_name => 'Losino-Petrovski', 
             ename => 'Losino-Petrovsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21641 => {
             name => 'Лобня', 
             ua_name => 'Лобня', 
             tr_name => 'Lobnia', 
             ename => 'Lobnja',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21642 => {
             name => 'Электроугли', 
             ua_name => 'Електроуглі', 
             tr_name => 'Elektrougli', 
             ename => 'Elektrougli',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98598 ], 
             childs => [  ], 
        },
        
        21645 => {
             name => 'Хотьково', 
             ua_name => 'Хотьково', 
             tr_name => 'Hotkovo', 
             ename => 'Hot\'kovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98608 ], 
             childs => [  ], 
        },
        
        21646 => {
             name => 'Голицыно', 
             ua_name => 'Голіцино', 
             tr_name => 'Golitsino', 
             ename => 'Golicyno',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98599 ], 
             childs => [  ], 
        },
        
        21647 => {
             name => 'Краснознаменск', 
             ua_name => 'Краснознаменськ', 
             tr_name => 'Krasnoznamensk', 
             ename => 'Krasnoznamensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21656 => {
             name => 'Старая Купавна', 
             ua_name => 'Стара Купавна', 
             tr_name => 'Staraya Kupavna', 
             ename => 'Staraja Kupavna',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98598 ], 
             childs => [  ], 
        },
        
        21675 => {
             name => 'Каргасок', 
             ua_name => 'Каргасок', 
             tr_name => 'Kargasok', 
             ename => 'Kargasok',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 59, 11353, 100278 ], 
             childs => [  ], 
        },
        
        217 => {
             name => 'Пущино', 
             ua_name => 'Пущино', 
             tr_name => 'Puşçino', 
             ename => 'Pushino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21726 => {
             name => 'Полевской', 
             ua_name => 'Полевський', 
             tr_name => 'Polevskoy', 
             ename => 'Polevskoj',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        21735 => {
             name => 'Дзержинский', 
             ua_name => 'Дзержинський', 
             tr_name => 'Dzerjinski', 
             ename => 'Dzerzhinsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21745 => {
             name => 'Нахабино', 
             ua_name => 'Нахабіно', 
             tr_name => 'Nahabino', 
             ename => 'Nakhabino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 3, 1, 98590 ], 
             childs => [  ], 
        },
        
        21773 => {
             name => 'Никополь', 
             ua_name => 'Нікополь', 
             tr_name => 'Nikopol', 
             ename => 'Nikopol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        21774 => {
             name => 'Горловка', 
             ua_name => 'Горлівка', 
             tr_name => 'Horlovka', 
             ename => 'Horlivka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        21775 => {
             name => 'Каменское', 
             ua_name => 'Кам\'янське', 
             tr_name => 'Dniprodzerzhynsk', 
             ename => 'Kamianske',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        219 => {
             name => 'Черноголовка', 
             ua_name => 'Черноголовка', 
             tr_name => 'Çernogolovka', 
             ename => 'Chernogolovka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21947 => {
             name => 'Навои', 
             ua_name => 'Навої', 
             tr_name => 'Nevai', 
             ename => 'Navoi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105808 ], 
             childs => [  ], 
        },
        
        21949 => {
             name => 'Забайкальский край', 
             ua_name => 'Забайкальський край', 
             tr_name => 'Zabaykalski krayı', 
             ename => 'Zabaykalsky Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 68 ], 
        },
        
        22 => {
             name => 'Калининград', 
             ua_name => 'Калінінград', 
             tr_name => 'Kaliningrad', 
             ename => 'Kaliningrad',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        221 => {
             name => 'Шымкент', 
             ua_name => 'Шимкент', 
             tr_name => 'Çimkent (Şımkent)', 
             ename => 'Chimkent',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        222 => {
             name => 'Луганск', 
             ua_name => 'Луганськ', 
             tr_name => 'Lugansk', 
             ename => 'Luhansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20540 ], 
             childs => [  ], 
        },
        
        225 => {
             name => 'Россия', 
             ua_name => 'Росія', 
             tr_name => 'Rusya', 
             ename => 'Russia',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 3,             
             parents => [ 0 ], 
             childs => [ 3, 17, 26, 40, 52, 59, 73, 102444 ], 
        },
        
        22829 => {
             name => 'Вознесенье', 
             ua_name => 'Вознесіння', 
             tr_name => 'Voznyesyenje', 
             ename => 'Voznyesyenje',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 17, 10174, 98630 ], 
             childs => [  ], 
        },
        
        23 => {
             name => 'Мурманск', 
             ua_name => 'Мурманськ', 
             tr_name => 'Murmansk', 
             ename => 'Murmansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        235 => {
             name => 'Магнитогорск', 
             ua_name => 'Магнітогорськ', 
             tr_name => 'Magnitogorsk', 
             ename => 'Magnitogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        236 => {
             name => 'Набережные Челны', 
             ua_name => 'Набережні Челни', 
             tr_name => 'Naberejniye Çelny (Yar Çallı)', 
             ename => 'Naberezhnie Chelny',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        237 => {
             name => 'Новокузнецк', 
             ua_name => 'Новокузнецьк', 
             tr_name => 'Novokuznetsk', 
             ename => 'Novokuznetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        238 => {
             name => 'Новочеркасск', 
             ua_name => 'Новочеркаськ', 
             tr_name => 'Novoçerkassk', 
             ename => 'Novocherkassk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        239 => {
             name => 'Сочи', 
             ua_name => 'Сочі', 
             tr_name => 'Soçi', 
             ename => 'Sochi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        24 => {
             name => 'Великий Новгород', 
             ua_name => 'Великий Новгород', 
             tr_name => 'Velikiy Novgorod', 
             ename => 'Veliky Novgorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [  ], 
        },
        
        240 => {
             name => 'Тольятти', 
             ua_name => 'Тольятті', 
             tr_name => 'Tolyatti (Togliatti)', 
             ename => 'Togliatti',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        241 => {
             name => 'Африка', 
             ua_name => 'Африка', 
             tr_name => 'Afrika', 
             ename => 'Africa',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 1056, 20733 ], 
        },
        
        246 => {
             name => 'Греция', 
             ua_name => 'Греція', 
             tr_name => 'Yunanistan', 
             ename => 'Greece',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        24696 => {
             name => 'Бахчисарайский район', 
             ua_name => 'Бахчисарайський район', 
             tr_name => 'Bahçisarayski ilçesi', 
             ename => 'Bakhchisaray District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [ 27217 ], 
        },
        
        24702 => {
             name => 'Ленинский район', 
             ua_name => 'Ленінський район', 
             tr_name => 'Leninski ilçesi', 
             ename => 'Leninsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [ 28786 ], 
        },
        
        24876 => {
             name => 'Макеевка', 
             ua_name => 'Макіївка', 
             tr_name => 'Makeevka', 
             ename => 'Makiivka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        24885 => {
             name => 'Алчевск', 
             ua_name => 'Алчевськ', 
             tr_name => 'Alchevsk', 
             ename => 'Alchevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20540 ], 
             childs => [  ], 
        },
        
        24893 => {
             name => 'Северодонецк', 
             ua_name => 'Сєверодонецьк', 
             tr_name => 'Severodonetsk', 
             ename => 'Sievierodonetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20540 ], 
             childs => [  ], 
        },
        
        25 => {
             name => 'Псков', 
             ua_name => 'Псков', 
             tr_name => 'Pskov', 
             ename => 'Pskov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10926 ], 
             childs => [  ], 
        },
        
        26 => {
             name => 'Юг', 
             ua_name => 'Південь', 
             tr_name => 'Güney Federal Bölgesi', 
             ename => 'Southern Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10946, 10950, 10995, 11004, 11015, 11029 ], 
        },
        
        26001 => {
             name => 'Молодечно', 
             ua_name => 'Молодечно', 
             tr_name => 'Molodchenko', 
             ename => 'Molodcheno',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102165 ], 
             childs => [  ], 
        },
        
        26003 => {
             name => 'Солигорск', 
             ua_name => 'Солігорськ', 
             tr_name => 'Salihorsk', 
             ename => 'Salihorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102170 ], 
             childs => [  ], 
        },
        
        26004 => {
             name => 'Светлогорск', 
             ua_name => 'Свєтлогорськ', 
             tr_name => 'Svetlahorsk', 
             ename => 'Svetlogorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102114 ], 
             childs => [  ], 
        },
        
        26005 => {
             name => 'Слоним', 
             ua_name => 'Слонім', 
             tr_name => 'Slonim', 
             ename => 'Slonim',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102131 ], 
             childs => [  ], 
        },
        
        26006 => {
             name => 'Климовичи', 
             ua_name => 'Климовичі', 
             tr_name => 'Klimavichy', 
             ename => 'Klimavichy',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102141 ], 
             childs => [  ], 
        },
        
        26007 => {
             name => 'Мосты', 
             ua_name => 'Мости', 
             tr_name => 'Mosti', 
             ename => 'Mosti',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102126 ], 
             childs => [  ], 
        },
        
        26008 => {
             name => 'Речица', 
             ua_name => 'Речиця', 
             tr_name => 'Rechitsa', 
             ename => 'Rechitsa',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102112 ], 
             childs => [  ], 
        },
        
        26010 => {
             name => 'Кобрин', 
             ua_name => 'Кобрин', 
             tr_name => 'Kobrin', 
             ename => 'Kobrin',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29632, 102089 ], 
             childs => [  ], 
        },
        
        26012 => {
             name => 'Осиповичи', 
             ua_name => 'Осиповичі', 
             tr_name => 'Asipovichy', 
             ename => 'Asipovichy',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102149 ], 
             childs => [  ], 
        },
        
        26015 => {
             name => 'Кричев', 
             ua_name => 'Кричев', 
             tr_name => 'Krichev', 
             ename => 'Krichev',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102144 ], 
             childs => [  ], 
        },
        
        26016 => {
             name => 'Шклов', 
             ua_name => 'Шклов', 
             tr_name => 'Shklov', 
             ename => 'Shklov',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102154 ], 
             childs => [  ], 
        },
        
        26017 => {
             name => 'Сморгонь', 
             ua_name => 'Сморгонь', 
             tr_name => 'Smarhon', 
             ename => 'Smarhon',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102132 ], 
             childs => [  ], 
        },
        
        26018 => {
             name => 'Дзержинск (Минская область)', 
             ua_name => 'Дзержинск (Минская область)', 
             tr_name => 'Dzerzhinsk', 
             ename => 'Dzerzhinsk (Minsk District)',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102159 ], 
             childs => [  ], 
        },
        
        26021 => {
             name => 'Быхов', 
             ua_name => 'Бихов', 
             tr_name => 'Bikhov', 
             ename => 'Bikhov',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102136 ], 
             childs => [  ], 
        },
        
        26022 => {
             name => 'Крупки', 
             ua_name => 'Крупки', 
             tr_name => 'Krupki', 
             ename => 'Krupki',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102162 ], 
             childs => [  ], 
        },
        
        26025 => {
             name => 'Глубокое', 
             ua_name => 'Глибоке', 
             tr_name => 'Glubokoye', 
             ename => 'Glubokoye',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102180 ], 
             childs => [  ], 
        },
        
        26026 => {
             name => 'Поставы', 
             ua_name => 'Постави', 
             tr_name => 'Pastavy', 
             ename => 'Pastavy',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102189 ], 
             childs => [  ], 
        },
        
        26027 => {
             name => 'Рогачёв', 
             ua_name => 'Рогачов', 
             tr_name => 'Rogachev', 
             ename => 'Rogachev',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102113 ], 
             childs => [  ], 
        },
        
        26030 => {
             name => 'Новополоцк', 
             ua_name => 'Новополоцьк', 
             tr_name => 'Navapolatsk', 
             ename => 'Navapolatsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [  ], 
        },
        
        26034 => {
             name => 'Жодино', 
             ua_name => 'Жодино', 
             tr_name => 'Zhodzina', 
             ename => 'Zhodzina',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [  ], 
        },
        
        26081 => {
             name => 'Колпино', 
             ua_name => 'Колпіно', 
             tr_name => 'Kolpino', 
             ename => 'Kolpino',             
             media => 0, 
             geo_flag => 1, 
             level => 6, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 2, 20293 ], 
             childs => [  ], 
        },
        
        26554 => {
             name => 'Верхнедвинск', 
             ua_name => 'Верхньодвінськ', 
             tr_name => 'Verkhnedvinsk', 
             ename => 'Verkhnedvinsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102178 ], 
             childs => [  ], 
        },
        
        26745 => {
             name => 'Вилейка', 
             ua_name => 'Вілейка', 
             tr_name => 'Vileyka', 
             ename => 'Vileyka',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102157 ], 
             childs => [  ], 
        },
        
        26774 => {
             name => 'Горки', 
             ua_name => 'Горки', 
             tr_name => 'Gorki', 
             ename => 'Gorki',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102138 ], 
             childs => [  ], 
        },
        
        26836 => {
             name => 'Новогрудок', 
             ua_name => 'Новогрудок', 
             tr_name => 'Novogrudok', 
             ename => 'Novogrudok',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102127 ], 
             childs => [  ], 
        },
        
        26923 => {
             name => 'Волковыск', 
             ua_name => 'Волковиськ', 
             tr_name => 'Vawkavysk', 
             ename => 'Vawkavysk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102118 ], 
             childs => [  ], 
        },
        
        26951 => {
             name => 'Слуцк', 
             ua_name => 'Слуцьк', 
             tr_name => 'Slutsk', 
             ename => 'Slutsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102169 ], 
             childs => [  ], 
        },
        
        26966 => {
             name => 'Жлобин', 
             ua_name => 'Жлобін', 
             tr_name => 'Zhlobin', 
             ename => 'Zhlobin',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102103 ], 
             childs => [  ], 
        },
        
        27217 => {
             name => 'Бахчисарай', 
             ua_name => 'Бахчисарай', 
             tr_name => 'Bahçesaray', 
             ename => 'Bahchisaraj',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 187, 977, 24696 ], 
             childs => [  ], 
        },
        
        27555 => {
             name => 'Джанкой', 
             ua_name => 'Джанкой', 
             tr_name => 'Canköy', 
             ename => 'Jankoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        27693 => {
             name => 'Красноперекопск', 
             ua_name => 'Красноперекопськ', 
             tr_name => 'Krasnoperekopsk', 
             ename => 'Krasnoperekopsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        28 => {
             name => 'Махачкала', 
             ua_name => 'Махачкала', 
             tr_name => 'Makhachkala', 
             ename => 'Makhachkala',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        28401 => {
             name => 'Павлоград', 
             ua_name => 'Павлоград', 
             tr_name => 'Pavlograd', 
             ename => 'Pavlohrad',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        28786 => {
             name => 'Щёлкино', 
             ua_name => 'Щолкіне', 
             tr_name => 'Şçolkino', 
             ename => 'Shchelkino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 187, 977, 24702 ], 
             childs => [  ], 
        },
        
        28892 => {
             name => 'Армянск', 
             ua_name => 'Армянськ', 
             tr_name => 'Armiansk (Ermenibazar)', 
             ename => 'Armyansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        29053 => {
             name => 'Нежин', 
             ua_name => 'Ніжин', 
             tr_name => 'Nezhin', 
             ename => 'Nizhyn',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20551 ], 
             childs => [  ], 
        },
        
        29386 => {
             name => 'Абхазия', 
             ua_name => 'Абхазія', 
             tr_name => 'Abhazya', 
             ename => 'Abkhazia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        29387 => {
             name => 'Южная Осетия', 
             ua_name => 'Південна Осетія', 
             tr_name => 'Güney Osetya', 
             ename => 'South Ossetia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        29397 => {
             name => 'Берёзовский (Свердловская область)', 
             ua_name => 'Берёзовский (Свердловская область)', 
             tr_name => 'Beriozovski (Sverdlovskaya oblastı)', 
             ename => 'Berezovskiy (Sverdlovsk District)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        29403 => {
             name => 'Нур-Султан и Акмолинская область', 
             ua_name => 'Нур-Султан і Акмолінська область', 
             tr_name => 'Akmola eyaleti', 
             ename => 'Akmolinsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 163, 20809 ], 
        },
        
        29404 => {
             name => 'Актобе и область', 
             ua_name => 'Актобе і область', 
             tr_name => 'Aktöbe eyaleti', 
             ename => 'Aktubinsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 20273 ], 
        },
        
        29406 => {
             name => 'Алматы и область', 
             ua_name => 'Алмати і область', 
             tr_name => 'Almatı eyaleti', 
             ename => 'Alma-Ata District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 162, 10303, 116777, 116778, 116779, 116780, 116781, 116782 ], 
        },
        
        29407 => {
             name => 'Атырау и область', 
             ua_name => 'Атирау і область', 
             tr_name => 'Atırav eyaleti', 
             ename => 'Atyrau District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10291 ], 
        },
        
        29408 => {
             name => 'Восточно-Казахстанская область', 
             ua_name => 'Східно-Казахстанська область', 
             tr_name => 'Doğu Kazakistan eyaleti', 
             ename => 'East-Kazakhstan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 165, 10306 ], 
        },
        
        29409 => {
             name => 'Тараз и Жамбылская область', 
             ua_name => 'Тараз і Жамбилська область', 
             tr_name => 'Jambıl eyaleti', 
             ename => 'Zhambylsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 21094, 116960 ], 
        },
        
        29410 => {
             name => 'Западно-Казахстанская область', 
             ua_name => 'Західно-Казахстанська область', 
             tr_name => 'Batı Kazakistan eyaleti', 
             ename => 'West-Kazakhstan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10305 ], 
        },
        
        29411 => {
             name => 'Караганда и область', 
             ua_name => 'Караганда і область', 
             tr_name => 'Karağandı eyaleti', 
             ename => 'Karaganda District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 164, 10308, 35393 ], 
        },
        
        29412 => {
             name => 'Костанай и область', 
             ua_name => 'Костанай і область', 
             tr_name => 'Kostanay eyaleti', 
             ename => 'Kostanai District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10295, 10300 ], 
        },
        
        29413 => {
             name => 'Кызылорда и область', 
             ua_name => 'Кизилорда і область', 
             tr_name => 'Kızılorda eyaleti', 
             ename => 'Kyzylorda District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 21050 ], 
        },
        
        29414 => {
             name => 'Актау и Мангистауская область', 
             ua_name => 'Актау і Мангістауська область', 
             tr_name => 'Mangıstav eyaleti', 
             ename => 'Mangystau District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 29575, 29577, 116954 ], 
        },
        
        29415 => {
             name => 'Павлодар и область', 
             ua_name => 'Павлодар і область', 
             tr_name => 'Pavlodar eyaleti', 
             ename => 'Pavlodar District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 190, 29590 ], 
        },
        
        29416 => {
             name => 'Северо-Казахстанская область', 
             ua_name => 'Північно-Казахстанська область', 
             tr_name => 'Kuzey Kazakistan eyaleti', 
             ename => 'North-Kazakhstan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10298 ], 
        },
        
        29417 => {
             name => 'Туркестан и область', 
             ua_name => 'Туркестан і область', 
             tr_name => 'Türkistan eyaleti', 
             ename => 'Turkestan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 221, 21106, 116939, 116940, 116941, 116943, 116944, 116946, 116947, 116948 ], 
        },
        
        29575 => {
             name => 'Актау', 
             ua_name => 'Актау', 
             tr_name => 'Aktav', 
             ename => 'Aktau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29414 ], 
             childs => [  ], 
        },
        
        29577 => {
             name => 'Жанаозен', 
             ua_name => 'Жанаозен', 
             tr_name => 'Janaözen', 
             ename => 'Zhanaozen',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29414 ], 
             childs => [  ], 
        },
        
        29590 => {
             name => 'Экибастуз', 
             ua_name => 'Екибастуз', 
             tr_name => 'Yekibastuz (Ekibastuz)', 
             ename => 'Ekibastuz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29415 ], 
             childs => [  ], 
        },
        
        29629 => {
             name => 'Могилёв и область', 
             ua_name => 'Могильов і область', 
             tr_name => 'Mogiliovskaya oblastı', 
             ename => 'Mogilev District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 158, 20729, 102136, 102138, 102141, 102144, 102149, 102154 ], 
        },
        
        29630 => {
             name => 'Минск и область', 
             ua_name => 'Мінськ і область', 
             tr_name => 'Minskaya oblastı', 
             ename => 'Minsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 157, 26034, 102156, 102157, 102159, 102162, 102165, 102169, 102170 ], 
        },
        
        29631 => {
             name => 'Гомель и область', 
             ua_name => 'Гомель і область', 
             tr_name => 'Gomelskaya oblastı', 
             ename => 'Gomel District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 155, 102103, 102104, 102108, 102112, 102113, 102114 ], 
        },
        
        29632 => {
             name => 'Брест и область', 
             ua_name => 'Брест і область', 
             tr_name => 'Brestskaya oblastı', 
             ename => 'Brest District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 153, 21015, 21510, 102089 ], 
        },
        
        29633 => {
             name => 'Витебск и область', 
             ua_name => 'Вітебськ і область', 
             tr_name => 'Vitebskaya oblastı', 
             ename => 'Vitebsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 154, 26030, 102178, 102180, 102186, 102187, 102188, 102189 ], 
        },
        
        29634 => {
             name => 'Гродно и область', 
             ua_name => 'Гродно і область', 
             tr_name => 'Grodnenskaya oblastı', 
             ename => 'Grodno District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 10274, 102118, 102125, 102126, 102127, 102131, 102132 ], 
        },
        
        3 => {
             name => 'Центр', 
             ua_name => 'Центр', 
             tr_name => 'Merkezi Federal Bölge', 
             ename => 'Central Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 1, 10645, 10650, 10658, 10672, 10687, 10693, 10699, 10705, 10712, 10772, 10776, 10795, 10802, 10819, 10832, 10841 ], 
        },
        
        30 => {
             name => 'Нальчик', 
             ua_name => 'Нальчик', 
             tr_name => 'Nalchik', 
             ename => 'Nalchik',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11013 ], 
             childs => [  ], 
        },
        
        33 => {
             name => 'Владикавказ', 
             ua_name => 'Владикавказ', 
             tr_name => 'Vladikavkaz', 
             ename => 'Vladikavkaz',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11021 ], 
             childs => [  ], 
        },
        
        35 => {
             name => 'Краснодар', 
             ua_name => 'Краснодар', 
             tr_name => 'Krasnodar', 
             ename => 'Krasnodar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        35393 => {
             name => 'Темиртау', 
             ua_name => 'Теміртау', 
             tr_name => 'Temirtav', 
             ename => 'Temirtau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        36 => {
             name => 'Ставрополь', 
             ua_name => 'Ставрополь', 
             tr_name => 'Stavropol', 
             ename => 'Stavropol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        37 => {
             name => 'Астрахань', 
             ua_name => 'Астрахань', 
             tr_name => 'Astrahan', 
             ename => 'Astrahan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10946 ], 
             childs => [  ], 
        },
        
        37129 => {
             name => 'Покров', 
             ua_name => 'Покров', 
             tr_name => 'Pokrov', 
             ename => 'Pokrov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10658, 98755 ], 
             childs => [  ], 
        },
        
        37133 => {
             name => 'Новочебоксарск', 
             ua_name => 'Новочебоксарськ', 
             tr_name => 'Novocheboksarsk', 
             ename => 'Novocheboksarsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11156 ], 
             childs => [  ], 
        },
        
        38 => {
             name => 'Волгоград', 
             ua_name => 'Волгоград', 
             tr_name => 'Volgograd', 
             ename => 'Volgograd',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        39 => {
             name => 'Ростов-на-Дону', 
             ua_name => 'Ростов-на-Дону', 
             tr_name => 'Rostov-na-Donu', 
             ename => 'Rostov-na-Donu',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        4 => {
             name => 'Белгород', 
             ua_name => 'Бєлгород', 
             tr_name => 'Belgorod', 
             ename => 'Belgorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [  ], 
        },
        
        40 => {
             name => 'Поволжье', 
             ua_name => 'Поволжя', 
             tr_name => 'Volga Federal Bölgesi', 
             ename => 'Volga Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11070, 11077, 11079, 11084, 11095, 11108, 11111, 11117, 11119, 11131, 11146, 11148, 11153, 11156 ], 
        },
        
        41 => {
             name => 'Йошкар-Ола', 
             ua_name => 'Йошкар-Ола', 
             tr_name => 'Yoshkar-Ola', 
             ename => 'Yoshkar-Ola',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11077 ], 
             childs => [  ], 
        },
        
        42 => {
             name => 'Саранск', 
             ua_name => 'Саранськ', 
             tr_name => 'Saransk', 
             ename => 'Saransk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11117 ], 
             childs => [  ], 
        },
        
        43 => {
             name => 'Казань', 
             ua_name => 'Казань', 
             tr_name => 'Kazan', 
             ename => 'Kazan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        44 => {
             name => 'Ижевск', 
             ua_name => 'Іжевськ', 
             tr_name => 'Izhevsk', 
             ename => 'Izhevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        45 => {
             name => 'Чебоксары', 
             ua_name => 'Чебоксари', 
             tr_name => 'Cheboksary', 
             ename => 'Cheboksary',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11156 ], 
             childs => [  ], 
        },
        
        46 => {
             name => 'Киров', 
             ua_name => 'Кіров', 
             tr_name => 'Kirov', 
             ename => 'Kirov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11070 ], 
             childs => [  ], 
        },
        
        47 => {
             name => 'Нижний Новгород', 
             ua_name => 'Нижній Новгород', 
             tr_name => 'Nijni Novgorod', 
             ename => 'Nizhny Novgorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        48 => {
             name => 'Оренбург', 
             ua_name => 'Оренбург', 
             tr_name => 'Orenburg', 
             ename => 'Orenburg',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        49 => {
             name => 'Пенза', 
             ua_name => 'Пенза', 
             tr_name => 'Penza', 
             ename => 'Penza',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11095 ], 
             childs => [  ], 
        },
        
        5 => {
             name => 'Иваново', 
             ua_name => 'Іваново', 
             tr_name => 'İvanovo', 
             ename => 'Ivanovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10687 ], 
             childs => [  ], 
        },
        
        50 => {
             name => 'Пермь', 
             ua_name => 'Перм', 
             tr_name => 'Perm', 
             ename => 'Perm',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        51 => {
             name => 'Самара', 
             ua_name => 'Самара', 
             tr_name => 'Samara', 
             ename => 'Samara',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        52 => {
             name => 'Урал', 
             ua_name => 'Урал', 
             tr_name => 'Ural Federal Bölgesi', 
             ename => 'Ural Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11158, 11162, 11176, 11193, 11225, 11232 ], 
        },
        
        53 => {
             name => 'Курган', 
             ua_name => 'Курган', 
             tr_name => 'Kurgan', 
             ename => 'Kurgan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11158 ], 
             childs => [  ], 
        },
        
        54 => {
             name => 'Екатеринбург', 
             ua_name => 'Єкатеринбург', 
             tr_name => 'Yekaterinburg', 
             ename => 'Yekaterinburg',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        55 => {
             name => 'Тюмень', 
             ua_name => 'Тюмень', 
             tr_name => 'Tiumen', 
             ename => 'Tyumen',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        56 => {
             name => 'Челябинск', 
             ua_name => 'Челябінськ', 
             tr_name => 'Çeliabinsk', 
             ename => 'Chelyabinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        57 => {
             name => 'Ханты-Мансийск', 
             ua_name => 'Ханти-Мансійськ', 
             tr_name => 'Hantı-Mansi', 
             ename => 'Khanty-Mansiysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        58 => {
             name => 'Салехард', 
             ua_name => 'Салехард', 
             tr_name => 'Salehard', 
             ename => 'Salekhard',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        59 => {
             name => 'Сибирь', 
             ua_name => 'Сибір', 
             tr_name => 'Sibirya Federal Bölgesi', 
             ename => 'Siberian Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10231, 10233, 11235, 11266, 11282, 11309, 11316, 11318, 11340, 11353 ], 
        },
        
        6 => {
             name => 'Калуга', 
             ua_name => 'Калуга', 
             tr_name => 'Kaluga', 
             ename => 'Kaluga',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10693 ], 
             childs => [  ], 
        },
        
        62 => {
             name => 'Красноярск', 
             ua_name => 'Красноярськ', 
             tr_name => 'Krasnoyarsk', 
             ename => 'Krasnoyarsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        63 => {
             name => 'Иркутск', 
             ua_name => 'Іркутськ', 
             tr_name => 'Irkutsk', 
             ename => 'Irkutsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        64 => {
             name => 'Кемерово', 
             ua_name => 'Кемерово', 
             tr_name => 'Kemerovo', 
             ename => 'Kemerovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        65 => {
             name => 'Новосибирск', 
             ua_name => 'Новосибірськ', 
             tr_name => 'Novosibirsk', 
             ename => 'Novosibirsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [  ], 
        },
        
        66 => {
             name => 'Омск', 
             ua_name => 'Омськ', 
             tr_name => 'Omsk', 
             ename => 'Omsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11318 ], 
             childs => [  ], 
        },
        
        67 => {
             name => 'Томск', 
             ua_name => 'Томськ', 
             tr_name => 'Tomsk', 
             ename => 'Tomsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [  ], 
        },
        
        68 => {
             name => 'Чита', 
             ua_name => 'Чита', 
             tr_name => 'Çita', 
             ename => 'Chita',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 21949 ], 
             childs => [  ], 
        },
        
        7 => {
             name => 'Кострома', 
             ua_name => 'Кострома', 
             tr_name => 'Kostroma', 
             ename => 'Kostroma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10699 ], 
             childs => [  ], 
        },
        
        73 => {
             name => 'Дальний Восток', 
             ua_name => 'Далекий Схід', 
             tr_name => 'Uzak Doğu Federal Bölgesi', 
             ename => 'Far Eastern Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10243, 10251, 11330, 11375, 11398, 11403, 11409, 11443, 11450, 11457, 21949 ], 
        },
        
        74 => {
             name => 'Якутск', 
             ua_name => 'Якутськ', 
             tr_name => 'Yakutsk', 
             ename => 'Yakutsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11443 ], 
             childs => [  ], 
        },
        
        75 => {
             name => 'Владивосток', 
             ua_name => 'Владивосток', 
             tr_name => 'Vladivostok', 
             ename => 'Vladivostok',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        76 => {
             name => 'Хабаровск', 
             ua_name => 'Хабаровськ', 
             tr_name => 'Habarovsk', 
             ename => 'Khabarovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [  ], 
        },
        
        77 => {
             name => 'Благовещенск', 
             ua_name => 'Благовєщенськ', 
             tr_name => 'Blagoveshchensk', 
             ename => 'Blagoveshchensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        78 => {
             name => 'Петропавловск-Камчатский', 
             ua_name => 'Петропавловськ-Камчатський', 
             tr_name => 'Petropavlovsk', 
             ename => 'Petropavlovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11398 ], 
             childs => [  ], 
        },
        
        79 => {
             name => 'Магадан', 
             ua_name => 'Магадан', 
             tr_name => 'Magadan', 
             ename => 'Magadan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11403 ], 
             childs => [  ], 
        },
        
        8 => {
             name => 'Курск', 
             ua_name => 'Курськ', 
             tr_name => 'Kursk', 
             ename => 'Kursk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10705 ], 
             childs => [  ], 
        },
        
        80 => {
             name => 'Южно-Сахалинск', 
             ua_name => 'Южно-Сахалінськ', 
             tr_name => 'Sakhalinsk', 
             ename => 'Yuzhno-Sakhalinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11450 ], 
             childs => [  ], 
        },
        
        84 => {
             name => 'США', 
             ua_name => 'США', 
             tr_name => 'ABD', 
             ename => 'United States',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        9 => {
             name => 'Липецк', 
             ua_name => 'Липецьк', 
             tr_name => 'Lipetsk', 
             ename => 'Lipetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10712 ], 
             childs => [  ], 
        },
        
        93 => {
             name => 'Аргентина', 
             ua_name => 'Аргентина', 
             tr_name => 'Arjantin', 
             ename => 'Argentina',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10003 ], 
             childs => [  ], 
        },
        
        94 => {
             name => 'Бразилия', 
             ua_name => 'Бразилія', 
             tr_name => 'Brezilya', 
             ename => 'Brazil',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10003 ], 
             childs => [  ], 
        },
        
        95 => {
             name => 'Канада', 
             ua_name => 'Канада', 
             tr_name => 'Kanada', 
             ename => 'Canada',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        959 => {
             name => 'Севастополь', 
             ua_name => 'Севастополь', 
             tr_name => 'Sevastopol', 
             ename => 'Sevastopol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 977 ], 
             childs => [  ], 
        },
        
        96 => {
             name => 'Германия', 
             ua_name => 'Німеччина', 
             tr_name => 'Almanya', 
             ename => 'Germany',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 103750 ], 
        },
        
        960 => {
             name => 'Запорожье', 
             ua_name => 'Запоріжжя', 
             tr_name => 'Zaporoje', 
             ename => 'Zaporizhia',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20539 ], 
             childs => [  ], 
        },
        
        961 => {
             name => 'Хмельницкий', 
             ua_name => 'Хмельницький', 
             tr_name => 'Khmelnitski', 
             ename => 'Khmelnytskyi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20535 ], 
             childs => [  ], 
        },
        
        962 => {
             name => 'Херсон', 
             ua_name => 'Херсон', 
             tr_name => 'Herson', 
             ename => 'Kherson',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20542 ], 
             childs => [  ], 
        },
        
        963 => {
             name => 'Винница', 
             ua_name => 'Вінниця', 
             tr_name => 'Vinica', 
             ename => 'Vinnytsia',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20545 ], 
             childs => [  ], 
        },
        
        964 => {
             name => 'Полтава', 
             ua_name => 'Полтава', 
             tr_name => 'Poltava', 
             ename => 'Poltava',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20549 ], 
             childs => [  ], 
        },
        
        965 => {
             name => 'Сумы', 
             ua_name => 'Суми', 
             tr_name => 'Sumi', 
             ename => 'Sumy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20552 ], 
             childs => [  ], 
        },
        
        967 => {
             name => 'Обнинск', 
             ua_name => 'Обнінськ', 
             tr_name => 'Obninsk', 
             ename => 'Obninsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10693 ], 
             childs => [  ], 
        },
        
        968 => {
             name => 'Череповец', 
             ua_name => 'Череповець', 
             tr_name => 'Cherepovets', 
             ename => 'Cherepovets',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10853 ], 
             childs => [  ], 
        },
        
        969 => {
             name => 'Выборг', 
             ua_name => 'Виборг', 
             tr_name => 'Vyborg', 
             ename => 'Vyborg',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98622 ], 
             childs => [  ], 
        },
        
        970 => {
             name => 'Новороссийск', 
             ua_name => 'Новоросійськ', 
             tr_name => 'Novorossiysk', 
             ename => 'Novorossiysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        971 => {
             name => 'Таганрог', 
             ua_name => 'Таганрог', 
             tr_name => 'Taganrog', 
             ename => 'Taganrog',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        972 => {
             name => 'Дзержинск (Нижегородская область)', 
             ua_name => 'Дзержинск (Нижегородская область)', 
             tr_name => 'Dzerjinsk', 
             ename => 'Dzerzhinsk (Nizhny Novgorod District)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        973 => {
             name => 'Сургут', 
             ua_name => 'Сургут', 
             tr_name => 'Surgut', 
             ename => 'Surgut',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        974 => {
             name => 'Находка', 
             ua_name => 'Находка', 
             tr_name => 'Nahodka', 
             ename => 'Nahodka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        975 => {
             name => 'Бийск', 
             ua_name => 'Бійськ', 
             tr_name => 'Biysk', 
             ename => 'Biysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        976 => {
             name => 'Братск', 
             ua_name => 'Братськ', 
             tr_name => 'Bratsk', 
             ename => 'Bratsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        977 => {
             name => 'Республика Крым', 
             ua_name => 'Республіка Крим', 
             tr_name => 'Kırım Cumhuriyeti', 
             ename => 'Republic of Crimea',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 146, 959, 11463, 11464, 11469, 11470, 11471, 11472, 20556, 24696, 24702, 27555, 27693, 28892 ], 
        },
        
        983 => {
             name => 'Турция', 
             ua_name => 'Туреччина', 
             tr_name => 'Türkiye', 
             ename => 'Turkey',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 103668, 103669, 103670, 103671, 103672, 103673, 103674, 103675, 103676, 103677, 103678, 103679, 103680, 103681, 103682, 103683, 103684, 103685, 103686, 103687, 103688, 103689, 103690, 103691, 103692, 103693, 103694, 103695, 103696, 103697, 103698, 103699, 103700, 103701, 103702, 103703, 103704, 103705, 103706, 103707, 103708, 103709, 103710, 103711, 103712, 103713, 103714, 103715, 103716, 103717, 103718, 103719, 103720, 103721, 103722, 103723, 103724, 103725, 103726, 103727, 103728, 103729, 103730, 103731, 103732, 103733, 103734, 103735, 103736, 103737, 103738, 103739, 103740, 103741, 103742, 103743, 103744, 103745, 103746, 103747, 103748 ], 
        },
        
        98580 => {
             name => 'Волоколамский район', 
             ua_name => 'Волоколамський район', 
             tr_name => 'Volokolamski ilçesi', 
             ename => 'Volokolamsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10721 ], 
        },
        
        98581 => {
             name => 'Воскресенский район', 
             ua_name => 'Воскресенський район', 
             tr_name => 'Voskresenski ilçesi', 
             ename => 'Voskresensky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10722, 21632 ], 
        },
        
        98582 => {
             name => 'Дмитровский городской округ', 
             ua_name => 'Дмитровський район', 
             tr_name => 'Dmitrovski ilçesi', 
             ename => 'Dmitrovsky Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10723 ], 
        },
        
        98584 => {
             name => 'Егорьевск (городской округ)', 
             ua_name => 'Єгор\'євський район', 
             tr_name => 'Yegoryevski ilçesi', 
             ename => 'Yegoryevsk Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10727 ], 
        },
        
        98585 => {
             name => 'Зарайск (городской округ)', 
             ua_name => 'Зарайський район', 
             tr_name => 'Zarayski ilçesi', 
             ename => 'Zaraysk Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10728 ], 
        },
        
        98586 => {
             name => 'Истра (городской округ)', 
             ua_name => 'Істринський район', 
             tr_name => 'İstrinski ilçesi', 
             ename => 'Istra Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10731, 21627 ], 
        },
        
        98587 => {
             name => 'Кашира (городской округ)', 
             ua_name => 'Кашира (міський округ)', 
             tr_name => 'Kaşirski ilçesi', 
             ename => 'Kashira Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10732 ], 
        },
        
        98588 => {
             name => 'Клин (городской округ)', 
             ua_name => 'Клинський район', 
             tr_name => 'Klinski ilçesi', 
             ename => 'Klin Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10733 ], 
        },
        
        98590 => {
             name => 'Красногорск (городской округ)', 
             ua_name => 'Красногорський район', 
             tr_name => 'Krasnogorski ilçesi', 
             ename => 'Krasnogorsk Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10735, 21745 ], 
        },
        
        98591 => {
             name => 'Ленинский район', 
             ua_name => 'Ленінський район', 
             tr_name => 'Leninski ilçesi', 
             ename => 'Leninsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10719 ], 
        },
        
        98593 => {
             name => 'Луховицы (городской округ)', 
             ua_name => 'Луховицький район', 
             tr_name => 'Luhovitski ilçesi', 
             ename => 'Lukhovitsy Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10737 ], 
        },
        
        98594 => {
             name => 'Люберцы (городской округ)', 
             ua_name => 'Люберецький район', 
             tr_name => 'Liuberetski ilçesi', 
             ename => 'Lyubertsy Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10738 ], 
        },
        
        98595 => {
             name => 'Можайский (городской округ)', 
             ua_name => 'Можайський район', 
             tr_name => 'Mojayski ilçesi', 
             ename => 'Mozhajskij Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10739 ], 
        },
        
        98596 => {
             name => 'Мытищи (городской округ)', 
             ua_name => 'Митищинський район', 
             tr_name => 'Mytişçinski ilçesi', 
             ename => 'Mytishchi Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10740 ], 
        },
        
        98597 => {
             name => 'Наро-Фоминский городской округ', 
             ua_name => 'Наро-Фомінський район', 
             tr_name => 'Naro-Fominski ilçesi', 
             ename => 'Naro-Fominsky Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10715, 10741 ], 
        },
        
        98598 => {
             name => 'Богородский (городской округ)', 
             ua_name => 'Ногінський район', 
             tr_name => 'Noginski ilçesi', 
             ename => 'Bogorodskij Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10742, 21642, 21656 ], 
        },
        
        98599 => {
             name => 'Одинцовский район', 
             ua_name => 'Одинцовський район', 
             tr_name => 'Odintsovski ilçesi', 
             ename => 'Odintsovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10743, 21625, 21646 ], 
        },
        
        98602 => {
             name => 'Павловский Посад (городской округ)', 
             ua_name => 'Павлово-Посадський район', 
             tr_name => 'Pavlovo-Posadski ilçesi', 
             ename => 'Pavlovsky Posad Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10746 ], 
        },
        
        98604 => {
             name => 'Пушкинский район', 
             ua_name => 'Пушкінський район', 
             tr_name => 'Puşkinski ilçesi', 
             ename => 'Pushkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10748, 21623, 100471 ], 
        },
        
        98605 => {
             name => 'Раменский район', 
             ua_name => 'Раменський район', 
             tr_name => 'Ramenski ilçesi', 
             ename => 'Ramensky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10750 ], 
        },
        
        98606 => {
             name => 'Рузский городской округ', 
             ua_name => 'Рузький район', 
             tr_name => 'Ruzski ilçesi', 
             ename => 'Ruzsky Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10751 ], 
        },
        
        98607 => {
             name => 'Ступино (городской округ)', 
             ua_name => 'Ступинський район', 
             tr_name => 'Stupinski ilçesi', 
             ename => 'Stupino Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10756 ], 
        },
        
        98608 => {
             name => 'Сергиево-Посадский район', 
             ua_name => 'Сергієво-Посадський район', 
             tr_name => 'Sergiyevo-Posadski ilçesi', 
             ename => 'Sergiyevo-Posadsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10752, 21645 ], 
        },
        
        98611 => {
             name => 'Солнечногорский район', 
             ua_name => 'Солнєчногорський район', 
             tr_name => 'Solneçnogorski ilçesi', 
             ename => 'Solnechnogorsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10755 ], 
        },
        
        98614 => {
             name => 'Чехов (городской округ)', 
             ua_name => 'Чеховський район', 
             tr_name => 'Çehovski ilçesi', 
             ename => 'Chekhov Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10761 ], 
        },
        
        98615 => {
             name => 'Шатура (городской округ)', 
             ua_name => 'Шатурський район', 
             tr_name => 'Şaturski ilçesi', 
             ename => 'Shatura Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10762 ], 
        },
        
        98617 => {
             name => 'Щёлковский район', 
             ua_name => 'Щолковський район', 
             tr_name => 'Şçolkovski ilçesi', 
             ename => 'Shchelkovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10765 ], 
        },
        
        98620 => {
             name => 'Волховский район', 
             ua_name => 'Волховський район', 
             tr_name => 'Volkhov ilçesi', 
             ename => 'Volkhov district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10864 ], 
        },
        
        98621 => {
             name => 'Всеволожский район', 
             ua_name => 'Всеволожський район', 
             tr_name => 'Vsevolozhsk İlçesi', 
             ename => 'Vsevolozhsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10865 ], 
        },
        
        98622 => {
             name => 'Выборгский район', 
             ua_name => 'Виборзький район', 
             tr_name => 'Vyborg ilçesi', 
             ename => 'Vyborg district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 969 ], 
        },
        
        98623 => {
             name => 'Гатчинский район', 
             ua_name => 'Гатчинський район', 
             tr_name => 'Gatchina ilçesi', 
             ename => 'Gatchina district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10867 ], 
        },
        
        98624 => {
             name => 'Кингисеппский район', 
             ua_name => 'Кінгісеппський район', 
             tr_name => 'Kingisepp İlçesi', 
             ename => 'Kingisepp District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10870 ], 
        },
        
        98625 => {
             name => 'Киришский район', 
             ua_name => 'Кириський район', 
             tr_name => 'Kirishski İlçesi', 
             ename => 'Kirishsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10871 ], 
        },
        
        98626 => {
             name => 'Кировский район', 
             ua_name => 'Кіровський район', 
             tr_name => 'Kirov İlçesi', 
             ename => 'Kirov District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10872 ], 
        },
        
        98629 => {
             name => 'Лужский район', 
             ua_name => 'Лузький район', 
             tr_name => 'Luzhski İlçesi', 
             ename => 'Luzhsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10876 ], 
        },
        
        98630 => {
             name => 'Подпорожский район', 
             ua_name => 'Підпорізький район', 
             tr_name => 'Podporozhski İlçesi', 
             ename => 'Podporozhsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10881, 22829 ], 
        },
        
        98631 => {
             name => 'Приозерский район', 
             ua_name => 'Приозерський район', 
             tr_name => 'Priozersk İlçesi', 
             ename => 'Priozersk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10883 ], 
        },
        
        98632 => {
             name => 'Сланцевский район', 
             ua_name => 'Сланцевський район', 
             tr_name => 'Slantski İlçesi', 
             ename => 'Slantsy District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10888 ], 
        },
        
        98633 => {
             name => 'Тихвинский район', 
             ua_name => 'Тихвінський район', 
             tr_name => 'Tikhvinski İlçesi', 
             ename => 'Tikhvin District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10892 ], 
        },
        
        98634 => {
             name => 'Тосненский район', 
             ua_name => 'Тосненський район', 
             tr_name => 'Tosnenski İlçesi', 
             ename => 'Tosnensky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10893 ], 
        },
        
        98697 => {
             name => 'Алексеевский район', 
             ua_name => 'Алексєєвський район', 
             tr_name => 'Alekseevskii İlçesi', 
             ename => 'Alekseevskii District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [ 20192 ], 
        },
        
        98716 => {
             name => 'Шебекинский район', 
             ua_name => 'Шебекінський район', 
             tr_name => 'Shebekinski İlçesi', 
             ename => 'Shebekinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [ 20196 ], 
        },
        
        98717 => {
             name => 'Яковлевский район', 
             ua_name => 'Яковлєвський район', 
             tr_name => 'Yakovlevski İlçesi', 
             ename => 'Yakovlevskij District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [ 20587 ], 
        },
        
        98745 => {
             name => 'Александровский район', 
             ua_name => 'Олександрівський район', 
             tr_name => 'Aleksandrovski ilçesi', 
             ename => 'Alexandrovsky district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [ 10656 ], 
        },
        
        98750 => {
             name => 'Киржачский район', 
             ua_name => 'Киржацький район', 
             tr_name => 'Kirjaçski ilçesi', 
             ename => 'Kirzhachsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [ 10663 ], 
        },
        
        98755 => {
             name => 'Петушинский район', 
             ua_name => 'Петушинський район', 
             tr_name => 'Petuşinski ilçesi', 
             ename => 'Petushinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [ 37129 ], 
        },
        
        98787 => {
             name => 'Россошанский район', 
             ua_name => 'Россошанський район', 
             tr_name => 'Rossoşanski ilçesi', 
             ename => 'Rossoshansky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10672 ], 
             childs => [ 10681 ], 
        },
        
        98826 => {
             name => 'Малоярославецкий район', 
             ua_name => 'Малоярославецький район', 
             tr_name => 'Maloyaroslavetski İlçesi', 
             ename => 'Maloyaroslavetsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10693 ], 
             childs => [ 10697 ], 
        },
        
        98958 => {
             name => 'Вяземский район', 
             ua_name => 'Вяземський район', 
             tr_name => 'Viazemski ilçesi', 
             ename => 'Vyazemsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [ 10782 ], 
        },
        
        98959 => {
             name => 'Гагаринский район', 
             ua_name => 'Гагарінський район', 
             tr_name => 'Gagarinski ilçesi', 
             ename => 'Gagarinsky district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [ 10783 ], 
        },
        
        98981 => {
             name => 'Ярцевский район', 
             ua_name => 'Ярцевський район', 
             tr_name => 'Yartsevski İlçesi', 
             ename => 'Yartsevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [ 10801 ], 
        },
        
        99008 => {
             name => 'Бологовский район', 
             ua_name => 'Бологовський район', 
             tr_name => 'Bologovski İlçesi', 
             ename => 'Bologovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10805 ], 
        },
        
        99019 => {
             name => 'Конаковский район', 
             ua_name => 'Конаковський район', 
             tr_name => 'Konakovski İlçesi', 
             ename => 'Konakovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10812 ], 
        },
        
        99028 => {
             name => 'Осташковский район', 
             ua_name => 'Осташковський район', 
             tr_name => 'Ostashkovski İlçesi', 
             ename => 'Ostashkovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10818 ], 
        },
        
        99039 => {
             name => 'Удомельский район', 
             ua_name => 'Удомельський район', 
             tr_name => 'Udomelski İlçesi', 
             ename => 'Udomelsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10824 ], 
        },
        
        99044 => {
             name => 'Богородицкий район', 
             ua_name => 'Богородицький район', 
             tr_name => 'Bogoroditski ilçesi', 
             ename => 'Bogoroditsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [ 20667 ], 
        },
        
        99070 => {
             name => 'Мышкинский район', 
             ua_name => 'Мишкінський район', 
             tr_name => 'Myşkinski ilçesi', 
             ename => 'Myshkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [ 10836 ], 
        },
        
        99078 => {
             name => 'Тутаевский район', 
             ua_name => 'Тутаєвський район', 
             tr_name => 'Tutayevski ilçesi', 
             ename => 'Tutaevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [ 21154 ], 
        },
        
        99079 => {
             name => 'Угличский район', 
             ua_name => 'Углицький район', 
             tr_name => 'Ugliçski ilçesi', 
             ename => 'Uglichesky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [ 10840 ], 
        },
        
        99105 => {
             name => 'Великоустюгский район', 
             ua_name => 'Великоустюзький район', 
             tr_name => 'Velikoustyugski İlçesi', 
             ename => 'Velikoustyugsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10853 ], 
             childs => [ 10854 ], 
        },
        
        99146 => {
             name => 'Боровичский район', 
             ua_name => 'Боровицький район', 
             tr_name => 'Borovichski İlçesi', 
             ename => 'Borovichsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [ 10906 ], 
        },
        
        99147 => {
             name => 'Валдайский район', 
             ua_name => 'Валдайський район', 
             tr_name => 'Valdai İlçesi', 
             ename => 'Valdai District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [ 10907 ], 
        },
        
        99161 => {
             name => 'Старорусский район', 
             ua_name => 'Староруський район', 
             tr_name => 'Old İlçesi', 
             ename => 'Old District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [ 10923 ], 
        },
        
        99193 => {
             name => 'Кондопожский район', 
             ua_name => 'Кондопозький район', 
             tr_name => 'Kondopoga İlçesi', 
             ename => 'Kondopoga District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [ 10934 ], 
        },
        
        99203 => {
             name => 'Сегежский район', 
             ua_name => 'Сегезький район', 
             tr_name => 'Segezha İlçesi', 
             ename => 'Segezha District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [ 10936 ], 
        },
        
        99210 => {
             name => 'Район Печора', 
             ua_name => 'Печора', 
             tr_name => 'Pechora İlçesi', 
             ename => 'Pechora District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [ 10942 ], 
        },
        
        99221 => {
             name => 'Ахтубинский район', 
             ua_name => 'Ахтубінський район', 
             tr_name => 'Ahtubinski ilçesi', 
             ename => 'Akhtubinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10946 ], 
             childs => [ 20167 ], 
        },
        
        99269 => {
             name => 'Белореченский район', 
             ua_name => 'Бєлорєченський район', 
             tr_name => 'Beloreçenski ilçesi', 
             ename => 'Belorechensk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10988 ], 
        },
        
        99274 => {
             name => 'Ейский район', 
             ua_name => 'Єйський район', 
             tr_name => 'Yeyski ilçesi', 
             ename => 'Eisk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10993 ], 
        },
        
        99275 => {
             name => 'Кавказский район', 
             ua_name => 'Кавказький район', 
             tr_name => 'Kavkazski ilçesi', 
             ename => 'Kavkazsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10996 ], 
        },
        
        99281 => {
             name => 'Крымский район', 
             ua_name => 'Кримський район', 
             tr_name => 'Krymski ilçesi', 
             ename => 'Krimsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10997 ], 
        },
        
        99293 => {
             name => 'Славянский район', 
             ua_name => 'Слов\'янський район', 
             tr_name => 'Slavianski ilçesi', 
             ename => 'Slavyansky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 20704 ], 
        },
        
        99297 => {
             name => 'Тимашевский район', 
             ua_name => 'Тимашевський район', 
             tr_name => 'Timaşovski ilçesi', 
             ename => 'Timashyovsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 21141 ], 
        },
        
        99298 => {
             name => 'Тихорецкий район', 
             ua_name => 'Тихорєцький район', 
             tr_name => 'Tihoretski ilçesi', 
             ename => 'Tikhoretsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 11002 ], 
        },
        
        99299 => {
             name => 'Туапсинский район', 
             ua_name => 'Туапсінський район', 
             tr_name => 'Tuapsinski ilçesi', 
             ename => 'Tuapse District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 1058 ], 
        },
        
        994 => {
             name => 'Индия', 
             ua_name => 'Індія', 
             tr_name => 'Hindistan', 
             ename => 'India',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        99411 => {
             name => 'Белокалитвинский район', 
             ua_name => 'Білокалитвінський район', 
             tr_name => 'Belokalitvinski ilçesi', 
             ename => 'Belaya Kalitva District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [ 11034 ], 
        },
        
        99456 => {
             name => 'Будённовский район', 
             ua_name => 'Будьоновський район', 
             tr_name => 'Budyonnovski İlçesi', 
             ename => 'Budyonnovsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [ 11055 ], 
        },
        
        995 => {
             name => 'Таиланд', 
             ua_name => 'Таїланд', 
             tr_name => 'Tayland', 
             ename => 'Thailand',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        99555 => {
             name => 'Кстовский район', 
             ua_name => 'Кстовський район', 
             tr_name => 'Kstovski İlçesi', 
             ename => 'Kstovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [ 20044 ], 
        },
        
        99560 => {
             name => 'Павловский район', 
             ua_name => 'Павловський район', 
             tr_name => 'Pavlovski İlçesi', 
             ename => 'Pavlovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [ 11082 ], 
        },
        
        99675 => {
             name => 'Белебеевский район', 
             ua_name => 'Белебеєвський район', 
             tr_name => 'Belebeyevski ilçesi', 
             ename => 'Belebeevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20714 ], 
        },
        
        99677 => {
             name => 'Белорецкий район', 
             ua_name => 'Бєлорєцький район', 
             tr_name => 'Beloretski ilçesi', 
             ename => 'Beloretsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20259 ], 
        },
        
        99694 => {
             name => 'Ишимбайский район', 
             ua_name => 'Ішимбайський район', 
             tr_name => 'Ishimbayski İlçesi', 
             ename => 'Ishimbaysky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20718 ], 
        },
        
        99703 => {
             name => 'Мелеузовский район', 
             ua_name => 'Мелеузовський район', 
             tr_name => 'Meleuzovski ilçesi', 
             ename => 'Meleuzovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20715 ], 
        },
        
        99712 => {
             name => 'Туймазинский район', 
             ua_name => 'Туймазинський район', 
             tr_name => 'Tuymazinski ilçesi', 
             ename => 'Tuymazinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20717 ], 
        },
        
        99714 => {
             name => 'Учалинский район', 
             ua_name => 'Учалинський район', 
             tr_name => 'Uçalinski ilçesi', 
             ename => 'Uchalinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20680 ], 
        },
        
        99737 => {
             name => 'Рузаевский район', 
             ua_name => 'Рузаєвський район', 
             tr_name => 'Ruzaevski İlçesi', 
             ename => 'Ruzaevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11117 ], 
             childs => [ 20010 ], 
        },
        
        99817 => {
             name => 'Балаковский район', 
             ua_name => 'Балаковський район', 
             tr_name => 'Balakovski ilçesi', 
             ename => 'Balakovo District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 11143 ], 
        },
        
        99818 => {
             name => 'Балашовский район', 
             ua_name => 'Балашовський район', 
             tr_name => 'Balaşovski ilçesi', 
             ename => 'Balashov District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 11144 ], 
        },
        
        99832 => {
             name => 'Марксовский район', 
             ua_name => 'Марксовський район', 
             tr_name => 'Marksovski İlçesi', 
             ename => 'Marksovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 20063 ], 
        },
        
        99850 => {
             name => 'Энгельсский район', 
             ua_name => 'Енгельський район', 
             tr_name => 'Engelsski İlçesi', 
             ename => 'Engelssky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 11147 ], 
        },
);


# хэш всех известных регионов (транслокальный для Росиии)
our %GEOREG_FOR_RU = (
    
        
        0 => {
             name => 'Все', 
             ua_name => 'Всі', 
             tr_name => 'Tümü', 
             ename => 'All',             
             media => 1, 
             geo_flag => 0, 
             level => 0, 
                        
             parents => [  ], 
             childs => [ 225, 166, 111, 183, 241, 10002, 10003, 138 ], 
        },
        
        1 => {
             name => 'Москва и область', 
             ua_name => 'Москва та Московська область', 
             tr_name => 'Moskova ve Moskovskaya oblastı', 
             ename => 'Moscow and Moscow Oblast',             
             media => 1, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 213, 214, 215, 217, 219, 10716, 10717, 10725, 10729, 10734, 10745, 10747, 10754, 10758, 20523, 20571, 20576, 20728, 21619, 21621, 21630, 21635, 21641, 21647, 21735, 98580, 98581, 98582, 98584, 98585, 98586, 98587, 98588, 98590, 98591, 98593, 98594, 98595, 98596, 98597, 98598, 98599, 98602, 98604, 98605, 98606, 98607, 98608, 98611, 98614, 98615, 98617 ], 
        },
        
        10 => {
             name => 'Орёл', 
             ua_name => 'Орел', 
             tr_name => 'Orel', 
             ename => 'Orel',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10772 ], 
             childs => [  ], 
        },
        
        100005 => {
             name => 'Ашинский район', 
             ua_name => 'Ашинський район', 
             tr_name => 'Aşinski ilçesi', 
             ename => 'Ashinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [ 11196 ], 
        },
        
        10002 => {
             name => 'Северная Америка', 
             ua_name => 'Північна Америка', 
             tr_name => 'Kuzey Amerika', 
             ename => 'North America',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 84, 95, 20917, 20968 ], 
        },
        
        100020 => {
             name => 'Саткинский район', 
             ua_name => 'Саткінський район', 
             tr_name => 'Satkinski ilçesi', 
             ename => 'Satkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [ 11217 ], 
        },
        
        100028 => {
             name => 'Надымский район', 
             ua_name => 'Надимський район', 
             tr_name => 'Nadymski ilçesi', 
             ename => 'Nadymsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [ 11229 ], 
        },
        
        10003 => {
             name => 'Южная Америка', 
             ua_name => 'Південна Америка', 
             tr_name => 'Güney Amerika', 
             ename => 'South America',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 93, 94 ], 
        },
        
        100109 => {
             name => 'Нижнеудинский район', 
             ua_name => 'Нижньоудинський район', 
             tr_name => 'Nijneudinski ilçesi', 
             ename => 'Nizhneudinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 11268 ], 
        },
        
        100112 => {
             name => 'Тайшетский район', 
             ua_name => 'Тайшетський район', 
             tr_name => 'Tayşetski ilçesi', 
             ename => 'Tayshetsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 11270 ], 
        },
        
        100116 => {
             name => 'Усть-Кутский район', 
             ua_name => 'Усть-Кутський район', 
             tr_name => 'Ust-Kutski ilçesi', 
             ename => 'Ust-Kutsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 20097 ], 
        },
        
        100183 => {
             name => 'Барабинский район', 
             ua_name => 'Барабінський район', 
             tr_name => 'Barabinski İlçesi', 
             ename => 'Barabinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [ 20098 ], 
        },
        
        100189 => {
             name => 'Карасукский район', 
             ua_name => 'Карасуцький район', 
             tr_name => 'Karasukski İlçesi', 
             ename => 'Karasuksky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [ 20101 ], 
        },
        
        100244 => {
             name => 'Баргузинский район', 
             ua_name => 'Баргузинський район', 
             tr_name => 'Barguzinski ilçesi', 
             ename => 'Barguzin District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [ 21161 ], 
        },
        
        100278 => {
             name => 'Каргасокский район', 
             ua_name => 'Каргасоцький район', 
             tr_name => 'Kargasokski ilçesi', 
             ename => 'Kargasoksky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [ 21675 ], 
        },
        
        100280 => {
             name => 'Колпашевский район', 
             ua_name => 'Колпашевський район', 
             tr_name => 'Kolpaşevski ilçesi', 
             ename => 'Kolpashevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [ 11349 ], 
        },
        
        100398 => {
             name => 'Амурский район', 
             ua_name => 'Амурський район', 
             tr_name => 'Amur bölgesi', 
             ename => 'Amursky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [ 11451 ], 
        },
        
        100471 => {
             name => 'Красноармейск', 
             ua_name => 'Красноармійськ', 
             tr_name => 'Krasnoarmeysk', 
             ename => 'Krasnoarmeysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        10074 => {
             name => 'Португалия', 
             ua_name => 'Португалія', 
             tr_name => 'Portekiz', 
             ename => 'Portugal',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        10077 => {
             name => 'Румыния', 
             ua_name => 'Румунія', 
             tr_name => 'Romanya', 
             ename => 'Romania',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        10083 => {
             name => 'Хорватия', 
             ua_name => 'Хорватія', 
             tr_name => 'Hırvatistan', 
             ename => 'Croatia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        100944 => {
             name => 'Ашкелон', 
             ua_name => 'Ашкелон', 
             tr_name => 'Aşkelon', 
             ename => 'Ashkelon',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103904 ], 
             childs => [  ], 
        },
        
        10095 => {
             name => 'Индонезия', 
             ua_name => 'Індонезія', 
             tr_name => 'Endonezya', 
             ename => 'Indonesia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        101425 => {
             name => 'Маргилан', 
             ua_name => 'Маргілан', 
             tr_name => 'Mergilân', 
             ename => 'Margilan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        101524 => {
             name => 'Бекабад', 
             ua_name => 'Бекабад', 
             tr_name => 'Bekabat', 
             ename => 'Bekabad',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        101550 => {
             name => 'Ангрен', 
             ua_name => 'Ангрен', 
             tr_name => 'Angren', 
             ename => 'Angren',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105813, 189657 ], 
             childs => [  ], 
        },
        
        101738 => {
             name => 'Ингольштадт', 
             ua_name => 'Інгольштадт', 
             tr_name => 'Ingolstadt', 
             ename => 'Ingolstadt',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 96, 103750 ], 
             childs => [  ], 
        },
        
        10174 => {
             name => 'Санкт-Петербург и Ленинградская область', 
             ua_name => 'Санкт-Петербург і Ленінградська область', 
             tr_name => 'Saint-Petersburg ve Leningradskaya oblastı', 
             ename => 'Saint-Petersburg and Leningrad Oblast',             
             media => 1, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 2, 10891, 98620, 98621, 98622, 98623, 98624, 98625, 98626, 98629, 98630, 98631, 98632, 98633, 98634 ], 
        },
        
        101749 => {
             name => 'Кандалакшский район', 
             ua_name => 'Кандалакський район', 
             tr_name => 'Kandalakshski İlçesi', 
             ename => 'Kandalakshsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [ 10895 ], 
        },
        
        10176 => {
             name => 'Ненецкий автономный округ', 
             ua_name => 'Ненецький автономний округ', 
             tr_name => 'Nenets özerk okrugu', 
             ename => 'Nenets Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 10902 ], 
        },
        
        101761 => {
             name => 'Шахрисабз', 
             ua_name => 'Шахрисабз', 
             tr_name => 'Şehrisebz', 
             ename => 'Shahrisabz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105807 ], 
             childs => [  ], 
        },
        
        101987 => {
             name => 'Нерюнгринский район', 
             ua_name => 'Нерюнгрінський район', 
             tr_name => 'Neryungrinski İlçesi', 
             ename => 'Neryungrinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11443 ], 
             childs => [ 11437 ], 
        },
        
        102 => {
             name => 'Великобритания', 
             ua_name => 'Великобританія', 
             tr_name => 'Birleşik Krallık', 
             ename => 'United Kingdom',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104520 ], 
        },
        
        102089 => {
             name => 'Кобринский район', 
             ua_name => 'Кобринський район', 
             tr_name => 'Kobrinsky İlçesi', 
             ename => 'Kobrinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [ 26010 ], 
        },
        
        102103 => {
             name => 'Жлобинский район', 
             ua_name => 'Жлобінський район', 
             tr_name => 'Zhlobinsky İlçesi', 
             ename => 'Zhlobinsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26966 ], 
        },
        
        102104 => {
             name => 'Калинковичский район', 
             ua_name => 'Калинковицький район', 
             tr_name => 'Kalinovichsky İlçesi', 
             ename => 'Kalinovichsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 102235 ], 
        },
        
        102108 => {
             name => 'Мозырский район', 
             ua_name => 'Мозирський район', 
             tr_name => 'Mozirsky İlçesi', 
             ename => 'Mozirsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 21274 ], 
        },
        
        102112 => {
             name => 'Речицкий район', 
             ua_name => 'Речицький район', 
             tr_name => 'Rechitsky İlçesi', 
             ename => 'Rechitsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26008 ], 
        },
        
        102113 => {
             name => 'Рогачёвский район', 
             ua_name => 'Рогачовський район', 
             tr_name => 'Rogachevsky İlçesi', 
             ename => 'Rogachevsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26027 ], 
        },
        
        102114 => {
             name => 'Светлогорский район', 
             ua_name => 'Свєтлогорський район', 
             tr_name => 'Svetlogorsky İlçesi', 
             ename => 'Svetlogorsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26004 ], 
        },
        
        102118 => {
             name => 'Волковысский район', 
             ua_name => 'Волковиський район', 
             tr_name => 'Volkovisski İlçesi', 
             ename => 'Volkovisski District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26923 ], 
        },
        
        102125 => {
             name => 'Лидский район', 
             ua_name => 'Лідський район', 
             tr_name => 'Lidsky İlçesi', 
             ename => 'Lidsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 21144 ], 
        },
        
        102126 => {
             name => 'Мостовский район', 
             ua_name => 'Мостовський район', 
             tr_name => 'Mostovsky İlçesi', 
             ename => 'Mostovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26007 ], 
        },
        
        102127 => {
             name => 'Новогрудский район', 
             ua_name => 'Новогрудський район', 
             tr_name => 'Novogrudsky İlçesi', 
             ename => 'Novogrudsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26836 ], 
        },
        
        102131 => {
             name => 'Слонимский район', 
             ua_name => 'Слонімський район', 
             tr_name => 'Slonimsky İlçesi', 
             ename => 'Slonimsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26005 ], 
        },
        
        102132 => {
             name => 'Сморгонский район', 
             ua_name => 'Сморгонський район', 
             tr_name => 'Smorgonsky İlçesi', 
             ename => 'Smorgonsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26017 ], 
        },
        
        102136 => {
             name => 'Быховский район', 
             ua_name => 'Биховський район', 
             tr_name => 'Bykhovsky İlçesi', 
             ename => 'Bikhovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26021 ], 
        },
        
        102138 => {
             name => 'Горецкий район', 
             ua_name => 'Горецький район', 
             tr_name => 'Goretsky İlçesi', 
             ename => 'Goretsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26774 ], 
        },
        
        102141 => {
             name => 'Климовичский район', 
             ua_name => 'Климовицький район', 
             tr_name => 'Klimovichsky İlçesi', 
             ename => 'Klimovichsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26006 ], 
        },
        
        102144 => {
             name => 'Кричевский район', 
             ua_name => 'Кричевський район', 
             tr_name => 'Krichevsky İlçesi', 
             ename => 'Krichevsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26015 ], 
        },
        
        102149 => {
             name => 'Осиповичский район', 
             ua_name => 'Осиповицький район', 
             tr_name => 'Osipovichsky İlçesi', 
             ename => 'Osipovichsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26012 ], 
        },
        
        102154 => {
             name => 'Шкловский район', 
             ua_name => 'Шкловський район', 
             tr_name => 'Shklovsky İlçesi', 
             ename => 'Shklovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26016 ], 
        },
        
        102156 => {
             name => 'Борисовский район', 
             ua_name => 'Борисовський район', 
             tr_name => 'Borisovsky İlçesi', 
             ename => 'Borisovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 21193 ], 
        },
        
        102157 => {
             name => 'Вилейский район', 
             ua_name => 'Вілейський район', 
             tr_name => 'Vileysky İlçesi', 
             ename => 'Vileysky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26745 ], 
        },
        
        102159 => {
             name => 'Дзержинский район', 
             ua_name => 'Дзержинський район', 
             tr_name => 'Dzerzhinsky İlçesi', 
             ename => 'Dzerzhinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26018 ], 
        },
        
        102162 => {
             name => 'Крупский район', 
             ua_name => 'Крупський район', 
             tr_name => 'Krupsky İlçesi', 
             ename => 'Krupsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26022 ], 
        },
        
        102165 => {
             name => 'Молодечненский район', 
             ua_name => 'Молодечненський район', 
             tr_name => 'Molodechnensky İlçesi', 
             ename => 'Molodechnensky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26001 ], 
        },
        
        102169 => {
             name => 'Слуцкий район', 
             ua_name => 'Слуцький район', 
             tr_name => 'Slutsky İlçesi', 
             ename => 'Slutsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26951 ], 
        },
        
        102170 => {
             name => 'Солигорский район', 
             ua_name => 'Солігорський район', 
             tr_name => 'Salihorsky İlçesi', 
             ename => 'Salihorsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26003 ], 
        },
        
        102178 => {
             name => 'Верхнедвинский район', 
             ua_name => 'Верхньодвінський район', 
             tr_name => 'Verkhnedvinsky İlçesi', 
             ename => 'Verkhnedvinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26554 ], 
        },
        
        102180 => {
             name => 'Глубокский район', 
             ua_name => 'Глибоцький район', 
             tr_name => 'Gluboksky İlçesi', 
             ename => 'Gluboksky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26025 ], 
        },
        
        102186 => {
             name => 'Миорский район', 
             ua_name => 'Міорський район', 
             tr_name => 'Miorsky İlçesi', 
             ename => 'Myory District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 21271 ], 
        },
        
        102187 => {
             name => 'Оршанский район', 
             ua_name => 'Оршанський район', 
             tr_name => 'Orshansky İlçesi', 
             ename => 'Orshansky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 10276 ], 
        },
        
        102188 => {
             name => 'Полоцкий район', 
             ua_name => 'Полоцький район', 
             tr_name => 'Polotsky İlçesi', 
             ename => 'Polotsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 10275 ], 
        },
        
        102189 => {
             name => 'Поставский район', 
             ua_name => 'Поставський район', 
             tr_name => 'Pastavsky İlçesi', 
             ename => 'Pastavsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26026 ], 
        },
        
        102235 => {
             name => 'Калинковичи', 
             ua_name => 'Калинковичі', 
             tr_name => 'Kalinoviçi', 
             ename => 'Kalinovichi',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102104 ], 
             childs => [  ], 
        },
        
        10231 => {
             name => 'Республика Алтай', 
             ua_name => 'Республіка Алтай', 
             tr_name => 'Altay Cumhuriyeti', 
             ename => 'Altai Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 11319 ], 
        },
        
        10233 => {
             name => 'Республика Тыва', 
             ua_name => 'Республіка Тива', 
             tr_name => 'Tuva', 
             ename => 'Tyva Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 11333 ], 
        },
        
        10243 => {
             name => 'Еврейская автономная область', 
             ua_name => 'Єврейська автономна область', 
             tr_name => 'Yahudi Özerk Bölgesi', 
             ename => 'Jewish Autonomous Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 11393 ], 
        },
        
        102444 => {
             name => 'Северный Кавказ', 
             ua_name => 'Північний Кавказ', 
             tr_name => 'Kuzey Kafkasya Federal Bölgesi', 
             ename => 'North Caucasian Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11010, 11012, 11013, 11020, 11021, 11024, 11069 ], 
        },
        
        10251 => {
             name => 'Чукотский автономный округ', 
             ua_name => 'Чукотський автономний округ', 
             tr_name => 'Chukotka Özerk Bölgesi', 
             ename => 'Chukotka Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [  ], 
        },
        
        10253 => {
             name => 'Баку', 
             ua_name => 'Баку', 
             tr_name => 'Bakü', 
             ename => 'Baku',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 167 ], 
             childs => [  ], 
        },
        
        10258 => {
             name => 'Ванадзор', 
             ua_name => 'Ванадзор', 
             tr_name => 'Vanadzor', 
             ename => 'Vanadzor',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 168, 105794 ], 
             childs => [  ], 
        },
        
        10259 => {
             name => 'Гюмри', 
             ua_name => 'Гюмрі', 
             tr_name => 'Gümrü', 
             ename => 'Gyumri',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 168, 105795 ], 
             childs => [  ], 
        },
        
        10262 => {
             name => 'Ереван', 
             ua_name => 'Єреван', 
             tr_name => 'Erivan', 
             ename => 'Yerevan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        10274 => {
             name => 'Гродно', 
             ua_name => 'Гродно', 
             tr_name => 'Grodno', 
             ename => 'Grodno',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [  ], 
        },
        
        10275 => {
             name => 'Полоцк', 
             ua_name => 'Полоцьк', 
             tr_name => 'Polotsk', 
             ename => 'Polotsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102188 ], 
             childs => [  ], 
        },
        
        10276 => {
             name => 'Орша', 
             ua_name => 'Орша', 
             tr_name => 'Orsha', 
             ename => 'Orsha',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102187 ], 
             childs => [  ], 
        },
        
        10277 => {
             name => 'Тбилиси', 
             ua_name => 'Тбілісі', 
             tr_name => 'Tiflis', 
             ename => 'Tbilisi',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        10278 => {
             name => 'Батуми', 
             ua_name => 'Батумі', 
             tr_name => 'Batum', 
             ename => 'Batumi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 169, 122054 ], 
             childs => [  ], 
        },
        
        10285 => {
             name => 'Рустави', 
             ua_name => 'Руставі', 
             tr_name => 'Rustavi (Bostandere)', 
             ename => 'Rustavi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 169, 122062 ], 
             childs => [  ], 
        },
        
        10291 => {
             name => 'Атырау', 
             ua_name => 'Атирау', 
             tr_name => 'Atırav', 
             ename => 'Atyrau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29407 ], 
             childs => [  ], 
        },
        
        10295 => {
             name => 'Костанай', 
             ua_name => 'Костанай', 
             tr_name => 'Kostanay', 
             ename => 'Kostanai',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29412 ], 
             childs => [  ], 
        },
        
        10298 => {
             name => 'Петропавловск', 
             ua_name => 'Петропавловськ', 
             tr_name => 'Petropavl (Petropavlovsk)', 
             ename => 'Petropavlovsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29416 ], 
             childs => [  ], 
        },
        
        10300 => {
             name => 'Рудный', 
             ua_name => 'Рудний', 
             tr_name => 'Rudny', 
             ename => 'Rudny',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29412 ], 
             childs => [  ], 
        },
        
        10303 => {
             name => 'Талдыкорган', 
             ua_name => 'Талдикорган', 
             tr_name => 'Taldıkorgan', 
             ename => 'Taldikorgan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        10305 => {
             name => 'Уральск', 
             ua_name => 'Уральськ', 
             tr_name => 'Oral (Uralsk)', 
             ename => 'Uralsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29410 ], 
             childs => [  ], 
        },
        
        10306 => {
             name => 'Усть-Каменогорск', 
             ua_name => 'Усть-Каменогорськ', 
             tr_name => 'Öskemen (Ust-Kamenogorsk)', 
             ename => 'Ust-Kamenogorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29408 ], 
             childs => [  ], 
        },
        
        10308 => {
             name => 'Жезказган', 
             ua_name => 'Жезказган', 
             tr_name => 'Jezkazgan', 
             ename => 'Zhezkazgan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        10309 => {
             name => 'Бишкек', 
             ua_name => 'Бішкек', 
             tr_name => 'Bişkek', 
             ename => 'Bishkek',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 207 ], 
             childs => [  ], 
        },
        
        10310 => {
             name => 'Ош', 
             ua_name => 'Ош', 
             tr_name => 'Osh', 
             ename => 'Osh',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 207 ], 
             childs => [  ], 
        },
        
        10313 => {
             name => 'Кишинев', 
             ua_name => 'Кишинів', 
             tr_name => 'Kişinev', 
             ename => 'Kishinev',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 208 ], 
             childs => [  ], 
        },
        
        10328 => {
             name => 'Алмалык', 
             ua_name => 'Алмалик', 
             tr_name => 'Elmalık', 
             ename => 'Almalik',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        10329 => {
             name => 'Андижан', 
             ua_name => 'Андіжан', 
             tr_name => 'Andican', 
             ename => 'Andijan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105804 ], 
             childs => [  ], 
        },
        
        10330 => {
             name => 'Бухара', 
             ua_name => 'Бухара', 
             tr_name => 'Buhara', 
             ename => 'Bukhara',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105805 ], 
             childs => [  ], 
        },
        
        10331 => {
             name => 'Карши', 
             ua_name => 'Карші', 
             tr_name => 'Karşı', 
             ename => 'Karshi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105807 ], 
             childs => [  ], 
        },
        
        10332 => {
             name => 'Коканд', 
             ua_name => 'Коканд', 
             tr_name => 'Kokand', 
             ename => 'Kokand',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        10334 => {
             name => 'Самарканд', 
             ua_name => 'Самарканд', 
             tr_name => 'Semerkant', 
             ename => 'Samarkand',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105810 ], 
             childs => [  ], 
        },
        
        10335 => {
             name => 'Ташкент', 
             ua_name => 'Ташкент', 
             tr_name => 'Taşkent', 
             ename => 'Tashkent',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 171 ], 
             childs => [  ], 
        },
        
        10336 => {
             name => 'Фергана', 
             ua_name => 'Фергана', 
             tr_name => 'Fergana', 
             ename => 'Phergana',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        10337 => {
             name => 'Нукус', 
             ua_name => 'Нукус', 
             tr_name => 'Nukus', 
             ename => 'Nukus',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105816 ], 
             childs => [  ], 
        },
        
        10338 => {
             name => 'Термез', 
             ua_name => 'Термез', 
             tr_name => 'Termez', 
             ename => 'Termez',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105811 ], 
             childs => [  ], 
        },
        
        10347 => {
             name => 'Кривой Рог', 
             ua_name => 'Кривий Ріг', 
             tr_name => 'Krivoi Rog', 
             ename => 'Kryvyi Rih',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        10366 => {
             name => 'Мариуполь', 
             ua_name => 'Маріуполь', 
             tr_name => 'Mariupol', 
             ename => 'Mariupol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        103668 => {
             name => 'Провинция Агры', 
             ua_name => 'Агри', 
             tr_name => 'Ağrı', 
             ename => 'Agri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103669 => {
             name => 'Провинция Адана', 
             ua_name => 'Адана', 
             tr_name => 'Adana', 
             ename => 'Adana',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103670 => {
             name => 'Провинция Адыяман', 
             ua_name => 'Адияман', 
             tr_name => 'Adıyaman', 
             ename => 'Adiyaman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103671 => {
             name => 'Провинция Айдын', 
             ua_name => 'Айдин', 
             tr_name => 'Aydın', 
             ename => 'Aydin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103672 => {
             name => 'Провинция Аксарай', 
             ua_name => 'Аксарай', 
             tr_name => 'Aksaray', 
             ename => 'Aksaray',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103673 => {
             name => 'Провинция Амасья', 
             ua_name => 'Амасья', 
             tr_name => 'Amasya', 
             ename => 'Amasya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103674 => {
             name => 'Провинция Анкара', 
             ua_name => 'Анкара', 
             tr_name => 'Ankara', 
             ename => 'Ankara',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103675 => {
             name => 'Провинция Анталья', 
             ua_name => 'Анталья', 
             tr_name => 'Antalya', 
             ename => 'Antalya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103676 => {
             name => 'Провинция Ардахан', 
             ua_name => 'Ардахан', 
             tr_name => 'Ardahan', 
             ename => 'Ardahan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103677 => {
             name => 'Провинция Артвин', 
             ua_name => 'Артвін', 
             tr_name => 'Artvin', 
             ename => 'Artvin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103678 => {
             name => 'Провинция Афьонкарахисар', 
             ua_name => 'Афьонкарахісар', 
             tr_name => 'Afyonkarahisar', 
             ename => 'Afyonkarahisar',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103679 => {
             name => 'Провинция Байбурт', 
             ua_name => 'Байбурт', 
             tr_name => 'Bayburt', 
             ename => 'Bayburt',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103680 => {
             name => 'Провинция Балыкесир', 
             ua_name => 'Баликесір', 
             tr_name => 'Balıkesir', 
             ename => 'Balikesir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103681 => {
             name => 'Провинция Бартын', 
             ua_name => 'Бартин', 
             tr_name => 'Bartın', 
             ename => 'Bartin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103682 => {
             name => 'Провинция Батман', 
             ua_name => 'Батман', 
             tr_name => 'Batman', 
             ename => 'Batman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103683 => {
             name => 'Провинция Биледжик', 
             ua_name => 'Біледжик', 
             tr_name => 'Bilecik', 
             ename => 'Bilecik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103684 => {
             name => 'Провинция Бингёль', 
             ua_name => 'Бінґель', 
             tr_name => 'Bingöl', 
             ename => 'Bingol',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103685 => {
             name => 'Провинция Битлис', 
             ua_name => 'Бітліс', 
             tr_name => 'Bitlis', 
             ename => 'Bitlis',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103686 => {
             name => 'Провинция Болу', 
             ua_name => 'Болу', 
             tr_name => 'Bolu', 
             ename => 'Bolu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103687 => {
             name => 'Провинция Бурдур', 
             ua_name => 'Бурдур', 
             tr_name => 'Burdur', 
             ename => 'Burdur',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103688 => {
             name => 'Провинция Бурса', 
             ua_name => 'Бурса', 
             tr_name => 'Bursa', 
             ename => 'Bursa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103689 => {
             name => 'Провинция Ван', 
             ua_name => 'Ван', 
             tr_name => 'Van', 
             ename => 'Van',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        10369 => {
             name => 'Белая Церковь', 
             ua_name => 'Біла Церква', 
             tr_name => 'Belaya Tserkov', 
             ename => 'Bila Tserkva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20544 ], 
             childs => [  ], 
        },
        
        103690 => {
             name => 'Провинция Газиантеп', 
             ua_name => 'Газіантеп', 
             tr_name => 'Gaziantep', 
             ename => 'Gaziantep',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103691 => {
             name => 'Провинция Гиресун', 
             ua_name => 'Гіресун', 
             tr_name => 'Giresun', 
             ename => 'Giresun',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103692 => {
             name => 'Провинция Гюмюшхане', 
             ua_name => 'Ґюмюшхане', 
             tr_name => 'Gümüşhane', 
             ename => 'Gumushane',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103693 => {
             name => 'Провинция Денизли', 
             ua_name => 'Денізлі', 
             tr_name => 'Denizli', 
             ename => 'Denizli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103694 => {
             name => 'Провинция Диярбакыр', 
             ua_name => 'Діярбакир', 
             tr_name => 'Diyarbakır', 
             ename => 'Diyarbakir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103695 => {
             name => 'Провинция Дюздже', 
             ua_name => 'Дюздже', 
             tr_name => 'Düzce', 
             ename => 'Duzce',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103696 => {
             name => 'Провинция Зонгулдак', 
             ua_name => 'Зонгулдак', 
             tr_name => 'Zonguldak', 
             ename => 'Zonguldak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103697 => {
             name => 'Провинция Измир', 
             ua_name => 'Ізмір', 
             tr_name => 'İzmir', 
             ename => 'Izmir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103698 => {
             name => 'Провинция Йозгат', 
             ua_name => 'Йозгат', 
             tr_name => 'Yozgat', 
             ename => 'Yozgat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103699 => {
             name => 'Провинция Кайсери', 
             ua_name => 'Кайсері', 
             tr_name => 'Kayseri', 
             ename => 'Kayseri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103700 => {
             name => 'Провинция Карабюк', 
             ua_name => 'Карабюк', 
             tr_name => 'Karabük', 
             ename => 'Karabuk',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103701 => {
             name => 'Провинция Караман', 
             ua_name => 'Караман', 
             tr_name => 'Karaman', 
             ename => 'Karaman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103702 => {
             name => 'Провинция Карс', 
             ua_name => 'Карс', 
             tr_name => 'Kars', 
             ename => 'Kars',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103703 => {
             name => 'Провинция Кастамону', 
             ua_name => 'Кастамону', 
             tr_name => 'Kastamonu', 
             ename => 'Kastamonu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103704 => {
             name => 'Провинция Кахраманмараш', 
             ua_name => 'Кахраманмараш', 
             tr_name => 'Kahramanmaraş', 
             ename => 'Kahramanmaras',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103705 => {
             name => 'Провинция Килис', 
             ua_name => 'Кіліс', 
             tr_name => 'Kilis', 
             ename => 'Kilis',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103706 => {
             name => 'Провинция Коджаэли', 
             ua_name => 'Коджаелі', 
             tr_name => 'Kocaeli', 
             ename => 'Kocaeli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103707 => {
             name => 'Провинция Конья', 
             ua_name => 'Конья', 
             tr_name => 'Konya', 
             ename => 'Konya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103708 => {
             name => 'Провинция Кыркларели', 
             ua_name => 'Киркларелі', 
             tr_name => 'Kırklareli', 
             ename => 'Kirklareli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103709 => {
             name => 'Провинция Кыршехир', 
             ua_name => 'Киршехір', 
             tr_name => 'Kırşehir', 
             ename => 'Kirsehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103710 => {
             name => 'Провинция Кырыккале', 
             ua_name => 'Кириккале', 
             tr_name => 'Kırıkkale', 
             ename => 'Kirikkale',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103711 => {
             name => 'Провинция Кютахья', 
             ua_name => 'Кютах\'я', 
             tr_name => 'Kütahya', 
             ename => 'Kutahya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103712 => {
             name => 'Провинция Малатья', 
             ua_name => 'Малатья', 
             tr_name => 'Malatya', 
             ename => 'Malatya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103713 => {
             name => 'Провинция Маниса', 
             ua_name => 'Маніса', 
             tr_name => 'Manisa', 
             ename => 'Manisa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103714 => {
             name => 'Провинция Мардин', 
             ua_name => 'Мардін', 
             tr_name => 'Mardin', 
             ename => 'Mardin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103715 => {
             name => 'Провинция Мерсин', 
             ua_name => 'Мерсін', 
             tr_name => 'Mersin', 
             ename => 'Mersin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103716 => {
             name => 'Провинция Мугла', 
             ua_name => 'Муґла', 
             tr_name => 'Muğla', 
             ename => 'Mugla',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103717 => {
             name => 'Провинция Муш', 
             ua_name => 'Муш', 
             tr_name => 'Muş', 
             ename => 'Mus',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103718 => {
             name => 'Провинция Невшехир', 
             ua_name => 'Невшехір', 
             tr_name => 'Nevşehir', 
             ename => 'Nevsehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103719 => {
             name => 'Провинция Нигде', 
             ua_name => 'Ніґде', 
             tr_name => 'Niğde', 
             ename => 'Nigde',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103720 => {
             name => 'Провинция Орду', 
             ua_name => 'Орду', 
             tr_name => 'Ordu', 
             ename => 'Ordu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103721 => {
             name => 'Провинция Османие', 
             ua_name => 'Османіє', 
             tr_name => 'Osmaniye', 
             ename => 'Osmaniye',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103722 => {
             name => 'Провинция Ризе', 
             ua_name => 'Різе', 
             tr_name => 'Rize', 
             ename => 'Rize',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103723 => {
             name => 'Провинция Сакарья', 
             ua_name => 'Сакар\'я', 
             tr_name => 'Sakarya', 
             ename => 'Sakarya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103724 => {
             name => 'Провинция Самсун', 
             ua_name => 'Самсун', 
             tr_name => 'Samsun', 
             ename => 'Samsun',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103725 => {
             name => 'Провинция Сивас', 
             ua_name => 'Сівас', 
             tr_name => 'Sivas', 
             ename => 'Sivas',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103726 => {
             name => 'Провинция Сиирт', 
             ua_name => 'Сіїрт', 
             tr_name => 'Siirt', 
             ename => 'Siirt',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103727 => {
             name => 'Провинция Синоп', 
             ua_name => 'Сіноп', 
             tr_name => 'Sinop', 
             ename => 'Sinop',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103728 => {
             name => 'Провинция Стамбул', 
             ua_name => 'Стамбул', 
             tr_name => 'İstanbul', 
             ename => 'Istanbul',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103729 => {
             name => 'Провинция Текирдаг', 
             ua_name => 'Текірдаг', 
             tr_name => 'Tekirdağ', 
             ename => 'Tekirdag',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103730 => {
             name => 'Провинция Токат', 
             ua_name => 'Токат', 
             tr_name => 'Tokat', 
             ename => 'Tokat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103731 => {
             name => 'Провинция Трабзон', 
             ua_name => 'Трабзон', 
             tr_name => 'Trabzon', 
             ename => 'Trabzon',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103732 => {
             name => 'Провинция Тунджели', 
             ua_name => 'Тунджелі', 
             tr_name => 'Tunceli', 
             ename => 'Tunceli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103733 => {
             name => 'Провинция Ушак', 
             ua_name => 'Ушак', 
             tr_name => 'Uşak', 
             ename => 'Usak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103734 => {
             name => 'Провинция Хаккяри', 
             ua_name => 'Хаккярі', 
             tr_name => 'Hakkari', 
             ename => 'Hakkari',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103735 => {
             name => 'Провинция Хатай', 
             ua_name => 'Хатай', 
             tr_name => 'Hatay', 
             ename => 'Hatay',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103736 => {
             name => 'Провинция Чанаккале', 
             ua_name => 'Чанаккале', 
             tr_name => 'Çanakkale', 
             ename => 'Canakkale',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103737 => {
             name => 'Провинция Чанкыры', 
             ua_name => 'Чанкири', 
             tr_name => 'Çankırı', 
             ename => 'Cankiri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103738 => {
             name => 'Провинция Чорум', 
             ua_name => 'Чорум', 
             tr_name => 'Çorum', 
             ename => 'Corum',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103739 => {
             name => 'Провинция Шанлыурфа', 
             ua_name => 'Шанлиурфа', 
             tr_name => 'Şanlıurfa', 
             ename => 'Sanliurfa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103740 => {
             name => 'Провинция Ширнак', 
             ua_name => 'Ширнак', 
             tr_name => 'Şırnak', 
             ename => 'Sirnak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103741 => {
             name => 'Провинция Ыгдыр', 
             ua_name => 'Игдир', 
             tr_name => 'Iğdır', 
             ename => 'Igdir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103742 => {
             name => 'Провинция Ыспарта', 
             ua_name => 'Испарта', 
             tr_name => 'Isparta', 
             ename => 'Isparta',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103743 => {
             name => 'Провинция Эдирне', 
             ua_name => 'Едірне', 
             tr_name => 'Edirne', 
             ename => 'Edirne',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103744 => {
             name => 'Провинция Элязыг', 
             ua_name => 'Елязиг', 
             tr_name => 'Elazığ', 
             ename => 'Elazig',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103745 => {
             name => 'Провинция Эрзинджан', 
             ua_name => 'Ерзінджан', 
             tr_name => 'Erzincan', 
             ename => 'Erzincan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103746 => {
             name => 'Провинция Эрзурум', 
             ua_name => 'Ерзурум', 
             tr_name => 'Erzurum', 
             ename => 'Erzurum',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103747 => {
             name => 'Провинция Эскишехир', 
             ua_name => 'Ескішехір', 
             tr_name => 'Eskişehir', 
             ename => 'Eskisehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103748 => {
             name => 'Провинция Ялова', 
             ua_name => 'Ялова', 
             tr_name => 'Yalova', 
             ename => 'Yalova',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103750 => {
             name => 'Свободное государство Бавария', 
             ua_name => 'Вільна держава Баварія', 
             tr_name => 'Bavyera', 
             ename => 'Free State of Bavaria',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 96 ], 
             childs => [ 101738 ], 
        },
        
        103900 => {
             name => 'Центральный АО', 
             ua_name => 'Центральний АО', 
             tr_name => 'Merkez', 
             ename => 'Central District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 116114 ], 
        },
        
        103901 => {
             name => 'Хайфский АО', 
             ua_name => 'Хайфський АО', 
             tr_name => 'Hayfa Bölgesi', 
             ename => 'Haifa District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 132 ], 
        },
        
        103904 => {
             name => 'Южный АО', 
             ua_name => 'Південний АО', 
             tr_name => 'Güney\'de', 
             ename => 'Southern District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 100944 ], 
        },
        
        103905 => {
             name => 'Тель-Авивский АО', 
             ua_name => 'Тель-Авівський АО', 
             tr_name => 'Tel Aviv Bölgesi', 
             ename => 'Tel Aviv District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 131 ], 
        },
        
        10391 => {
             name => 'Кембридж', 
             ua_name => 'Кембридж', 
             tr_name => 'Cambridge', 
             ename => 'Cambridge',             
             media => 0, 
             geo_flag => 0, 
             level => 6, 
             type => 6,             
             parents => [ 0, 111, 102, 104520, 104584, 104612 ], 
             childs => [  ], 
        },
        
        104260 => {
             name => 'Вильнюсский уезд', 
             ua_name => 'Вільнюський повіт', 
             tr_name => 'Vilnius Vilayeti', 
             ename => 'Vilnius County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 117 ], 
             childs => [ 11475 ], 
        },
        
        104357 => {
             name => 'Уусимаа', 
             ua_name => 'Уусімаа', 
             tr_name => 'Uusimaa', 
             ename => 'Uusimaa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 123 ], 
             childs => [ 10493 ], 
        },
        
        104430 => {
             name => 'Тартумаа', 
             ua_name => 'Тартумаа', 
             tr_name => 'Tartu Vilayeti', 
             ename => 'Tartu County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 179 ], 
             childs => [ 11482 ], 
        },
        
        104431 => {
             name => 'Харьюмаа', 
             ua_name => 'Гар\'юмаа', 
             tr_name => 'Harju Vilayeti', 
             ename => 'Harju County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 179 ], 
             childs => [ 11481 ], 
        },
        
        104492 => {
             name => 'Округ Белград', 
             ua_name => 'Округ Белград', 
             tr_name => 'Belgrad Bölgesi', 
             ename => 'Belgrade District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 180 ], 
             childs => [ 10522 ], 
        },
        
        104520 => {
             name => 'Англия', 
             ua_name => 'Англія', 
             tr_name => 'İngiltere', 
             ename => 'England',             
             media => 1, 
             geo_flag => 0, 
             level => 3, 
             type => 4,             
             parents => [ 0, 111, 102 ], 
             childs => [ 104584 ], 
        },
        
        104584 => {
             name => 'Восточная Англия', 
             ua_name => 'Східна Англія', 
             tr_name => 'Doğu İngiltere', 
             ename => 'East of England',             
             media => 1, 
             geo_flag => 0, 
             level => 4, 
             type => 2,             
             parents => [ 0, 111, 102, 104520 ], 
             childs => [ 104612 ], 
        },
        
        104612 => {
             name => 'Графство Кембриджшир', 
             ua_name => 'Графство Кембриджшир', 
             tr_name => 'Cambridgeshire County', 
             ename => 'Cambridgeshire County',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 5,             
             parents => [ 0, 111, 102, 104520, 104584 ], 
             childs => [ 10391 ], 
        },
        
        10493 => {
             name => 'Хельсинки', 
             ua_name => 'Хельсінкі', 
             tr_name => 'Helsinki', 
             ename => 'Helsinki',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 123, 104357 ], 
             childs => [  ], 
        },
        
        10522 => {
             name => 'Белград', 
             ua_name => 'Белград', 
             tr_name => 'Belgrad', 
             ename => 'Belgrade',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 180, 104492 ], 
             childs => [  ], 
        },
        
        10540 => {
             name => 'Саудовская Аравия', 
             ua_name => 'Саудівська Аравія', 
             tr_name => 'Suudi Arabistan', 
             ename => 'Saudi Arabia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        1056 => {
             name => 'Египет', 
             ua_name => 'Єгипет', 
             tr_name => 'Mısır', 
             ename => 'Egypt',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 241 ], 
             childs => [  ], 
        },
        
        105789 => {
             name => 'Область Арагацотн', 
             ua_name => 'Область Арагацотн', 
             tr_name => 'Aragatsotn', 
             ename => 'Aragatsotn',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105790 => {
             name => 'Область Арарат', 
             ua_name => 'Область Арарат', 
             tr_name => 'Ararat', 
             ename => 'Ararat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105791 => {
             name => 'Область Армавир', 
             ua_name => 'Область Армавір', 
             tr_name => 'Armavir Bölgesi (Armenia)', 
             ename => 'Armavir (Armenia)',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105792 => {
             name => 'Область Гехаркуник', 
             ua_name => 'Область Гехаркунік', 
             tr_name => 'Geğarkunik', 
             ename => 'Gegharkunik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105793 => {
             name => 'Область Котайк', 
             ua_name => 'Область Котайк', 
             tr_name => 'Kotayk', 
             ename => 'Kotayk',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105794 => {
             name => 'Область Лори', 
             ua_name => 'Область Лорі', 
             tr_name => 'Lori', 
             ename => 'Lori',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [ 10258 ], 
        },
        
        105795 => {
             name => 'Область Ширак', 
             ua_name => 'Область Ширак', 
             tr_name => 'Şirak', 
             ename => 'Shirak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [ 10259 ], 
        },
        
        105796 => {
             name => 'Область Сюник', 
             ua_name => 'Область Сюнік', 
             tr_name => 'Sünik', 
             ename => 'Syunik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105797 => {
             name => 'Область Тавуш', 
             ua_name => 'Область Тавуш', 
             tr_name => 'Tavuş', 
             ename => 'Tavush',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105798 => {
             name => 'Область Вайоц-Дзор', 
             ua_name => 'Область Вайоц-Дзор', 
             tr_name => 'Vayots Dzor', 
             ename => 'Vayots Dzor',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        1058 => {
             name => 'Туапсе', 
             ua_name => 'Туапсе', 
             tr_name => 'Tuapse', 
             ename => 'Tuapse',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99299 ], 
             childs => [  ], 
        },
        
        105804 => {
             name => 'Андижанская область', 
             ua_name => 'Андижанська область', 
             tr_name => 'Andican eyaleti', 
             ename => 'Andijan Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10329 ], 
        },
        
        105805 => {
             name => 'Бухарская область', 
             ua_name => 'Бухарська область', 
             tr_name => 'Buhara eyaleti', 
             ename => 'Bukhara Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10330 ], 
        },
        
        105806 => {
             name => 'Джизакская область', 
             ua_name => 'Джиззацька область', 
             tr_name => 'Cizzak eyaleti', 
             ename => 'Jizzakh Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21606 ], 
        },
        
        105807 => {
             name => 'Кашкадарьинская область', 
             ua_name => 'Кашкадар\'їнська область', 
             tr_name => 'Kaşkaderya eyaleti', 
             ename => 'Qashqadaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10331, 101761 ], 
        },
        
        105808 => {
             name => 'Навоийская область', 
             ua_name => 'Навоїйська область', 
             tr_name => 'Nevai eyaleti', 
             ename => 'Navoiy Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21947 ], 
        },
        
        105809 => {
             name => 'Наманганская область', 
             ua_name => 'Наманганська область', 
             tr_name => 'Nemengan eyaleti', 
             ename => 'Namangan Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21314 ], 
        },
        
        105810 => {
             name => 'Самаркандская область', 
             ua_name => 'Самаркандська область', 
             tr_name => 'Semerkant eyaleti', 
             ename => 'Samarqand Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10334 ], 
        },
        
        105811 => {
             name => 'Сурхандарьинская область', 
             ua_name => 'Сурхандар\'їнська область', 
             tr_name => 'Surhanderya eyaleti', 
             ename => 'Surxondaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10338, 196979 ], 
        },
        
        105812 => {
             name => 'Сырдарьинская область', 
             ua_name => 'Сирдар\'їнська область', 
             tr_name => 'Siriderya eyaleti', 
             ename => 'Sirdaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [  ], 
        },
        
        105813 => {
             name => 'Ташкентская область', 
             ua_name => 'Ташкентська область', 
             tr_name => 'Taşkent eyaleti', 
             ename => 'Tashkent Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10328, 101524, 114900, 189657 ], 
        },
        
        105814 => {
             name => 'Ферганская область', 
             ua_name => 'Ферганська область', 
             tr_name => 'Fergana eyaleti', 
             ename => 'Fergana Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10332, 10336, 101425 ], 
        },
        
        105815 => {
             name => 'Хорезмская область', 
             ua_name => 'Хорезмська область', 
             tr_name => 'Harezm eyaleti', 
             ename => 'Xorazm Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21105 ], 
        },
        
        105816 => {
             name => 'Республика Каракалпакстан', 
             ua_name => 'Республіка Каракалпакстан', 
             tr_name => 'Karakalpakistan', 
             ename => 'Republic of Karakalpakstan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10337, 193330 ], 
        },
        
        10645 => {
             name => 'Белгородская область', 
             ua_name => 'Бєлгородська область', 
             tr_name => 'Belgorodskaya oblastı', 
             ename => 'Belgorod Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 4, 10646, 10649, 98697, 98716, 98717 ], 
        },
        
        10646 => {
             name => 'Губкин', 
             ua_name => 'Губкин', 
             tr_name => 'Gubkin', 
             ename => 'Gubkin',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [  ], 
        },
        
        10649 => {
             name => 'Старый Оскол', 
             ua_name => 'Старий Оскол', 
             tr_name => 'Stariy Oskol', 
             ename => 'Stariy Oskol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [  ], 
        },
        
        10650 => {
             name => 'Брянская область', 
             ua_name => 'Брянська область', 
             tr_name => 'Brianskaya oblastı', 
             ename => 'Bryansk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 191, 10653 ], 
        },
        
        10653 => {
             name => 'Клинцы', 
             ua_name => 'Клинці', 
             tr_name => 'Klintsy', 
             ename => 'Klintsy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10650 ], 
             childs => [  ], 
        },
        
        10656 => {
             name => 'Александров', 
             ua_name => 'Александров', 
             tr_name => 'Aleksandrov', 
             ename => 'Aleksandrov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10658, 98745 ], 
             childs => [  ], 
        },
        
        10658 => {
             name => 'Владимирская область', 
             ua_name => 'Владимирська область', 
             tr_name => 'Vladimirskaya oblastı', 
             ename => 'Vladimir Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 192, 10661, 10664, 10668, 98745, 98750, 98755 ], 
        },
        
        10661 => {
             name => 'Гусь-Хрустальный', 
             ua_name => 'Гусь-Хрустальний', 
             tr_name => 'Gus-Hrustalny', 
             ename => 'Gus-Chrustalniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        10663 => {
             name => 'Киржач', 
             ua_name => 'Кіржач', 
             tr_name => 'Kirjaç', 
             ename => 'Kirzach',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10658, 98750 ], 
             childs => [  ], 
        },
        
        10664 => {
             name => 'Ковров', 
             ua_name => 'Ковров', 
             tr_name => 'Kovrov', 
             ename => 'Kovrov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        10668 => {
             name => 'Муром', 
             ua_name => 'Муром', 
             tr_name => 'Murom', 
             ename => 'Murom',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        10672 => {
             name => 'Воронежская область', 
             ua_name => 'Воронезька область', 
             tr_name => 'Voronejskaya oblastı', 
             ename => 'Voronezh Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 193, 98787 ], 
        },
        
        10681 => {
             name => 'Россошь', 
             ua_name => 'Россош', 
             tr_name => 'Rossoş', 
             ename => 'Rossosh',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10672, 98787 ], 
             childs => [  ], 
        },
        
        10687 => {
             name => 'Ивановская область', 
             ua_name => 'Івановська область', 
             tr_name => 'İvanovskaya oblastı', 
             ename => 'Ivanovo Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 5, 10689, 10691 ], 
        },
        
        10689 => {
             name => 'Кинешма', 
             ua_name => 'Кінешма', 
             tr_name => 'Kineşma', 
             ename => 'Kineshma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10687 ], 
             childs => [  ], 
        },
        
        10691 => {
             name => 'Шуя', 
             ua_name => 'Шуя', 
             tr_name => 'Şuya', 
             ename => 'Shuya',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10687 ], 
             childs => [  ], 
        },
        
        10693 => {
             name => 'Калужская область', 
             ua_name => 'Калузька область', 
             tr_name => 'Kalujskaya oblastı', 
             ename => 'Kaluga Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 6, 967, 98826 ], 
        },
        
        10697 => {
             name => 'Малоярославец', 
             ua_name => 'Малоярославець', 
             tr_name => 'Maloyaroslavets', 
             ename => 'Maloyaroslavets',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10693, 98826 ], 
             childs => [  ], 
        },
        
        10699 => {
             name => 'Костромская область', 
             ua_name => 'Костромська область', 
             tr_name => 'Kostromskaya oblastı', 
             ename => 'Kostroma Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 7 ], 
        },
        
        10705 => {
             name => 'Курская область', 
             ua_name => 'Курська область', 
             tr_name => 'Kurskaya oblastı', 
             ename => 'Kursk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 8, 10710, 20707 ], 
        },
        
        10710 => {
             name => 'Железногорск', 
             ua_name => 'Желєзногорськ', 
             tr_name => 'Jeleznogorsk', 
             ename => 'Zheleznogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10705 ], 
             childs => [  ], 
        },
        
        10712 => {
             name => 'Липецкая область', 
             ua_name => 'Липецька область', 
             tr_name => 'Lipetskaya oblastı', 
             ename => 'Lipetsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 9, 10713 ], 
        },
        
        10713 => {
             name => 'Елец', 
             ua_name => 'Єлець', 
             tr_name => 'Yelets', 
             ename => 'Yelets',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10712 ], 
             childs => [  ], 
        },
        
        10715 => {
             name => 'Апрелевка', 
             ua_name => 'Апрелєвка', 
             tr_name => 'Aprelevka', 
             ename => 'Aprelevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98597 ], 
             childs => [  ], 
        },
        
        10716 => {
             name => 'Балашиха', 
             ua_name => 'Балашиха', 
             tr_name => 'Balaşiha', 
             ename => 'Balashiha',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10717 => {
             name => 'Бронницы', 
             ua_name => 'Бронниці', 
             tr_name => 'Bronnitsy', 
             ename => 'Bronnizi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10719 => {
             name => 'Видное', 
             ua_name => 'Видне', 
             tr_name => 'Vidnoye', 
             ename => 'Vidnoe',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98591 ], 
             childs => [  ], 
        },
        
        10721 => {
             name => 'Волоколамск', 
             ua_name => 'Волоколамськ', 
             tr_name => 'Volokolamsk', 
             ename => 'Volokolamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98580 ], 
             childs => [  ], 
        },
        
        10722 => {
             name => 'Воскресенск', 
             ua_name => 'Воскресенськ', 
             tr_name => 'Voskresensk', 
             ename => 'Voskresensk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98581 ], 
             childs => [  ], 
        },
        
        10723 => {
             name => 'Дмитров', 
             ua_name => 'Дмитров', 
             tr_name => 'Dmitrov', 
             ename => 'Dmitrov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98582 ], 
             childs => [  ], 
        },
        
        10725 => {
             name => 'Домодедово', 
             ua_name => 'Домодєдово', 
             tr_name => 'Domodedovo', 
             ename => 'Domodedovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10727 => {
             name => 'Егорьевск', 
             ua_name => 'Єгор\'євськ', 
             tr_name => 'Yegoryevsk', 
             ename => 'Egorievsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98584 ], 
             childs => [  ], 
        },
        
        10728 => {
             name => 'Зарайск', 
             ua_name => 'Зарайськ', 
             tr_name => 'Zaraysk', 
             ename => 'Zaraysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98585 ], 
             childs => [  ], 
        },
        
        10729 => {
             name => 'Звенигород', 
             ua_name => 'Звенигород', 
             tr_name => 'Zvenigorod', 
             ename => 'Zvenigorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10731 => {
             name => 'Истра', 
             ua_name => 'Істра', 
             tr_name => 'İstra', 
             ename => 'Istra',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98586 ], 
             childs => [  ], 
        },
        
        10732 => {
             name => 'Кашира', 
             ua_name => 'Кашира', 
             tr_name => 'Kaşira', 
             ename => 'Kashira',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98587 ], 
             childs => [  ], 
        },
        
        10733 => {
             name => 'Клин', 
             ua_name => 'Клин', 
             tr_name => 'Klin', 
             ename => 'Klin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98588 ], 
             childs => [  ], 
        },
        
        10734 => {
             name => 'Коломна', 
             ua_name => 'Коломна', 
             tr_name => 'Kolomna', 
             ename => 'Kolomna',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10735 => {
             name => 'Красногорск', 
             ua_name => 'Красногорськ', 
             tr_name => 'Krasnogorsk', 
             ename => 'Krasnogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98590 ], 
             childs => [  ], 
        },
        
        10737 => {
             name => 'Луховицы', 
             ua_name => 'Луховиці', 
             tr_name => 'Luhovitsy', 
             ename => 'Luhovicy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98593 ], 
             childs => [  ], 
        },
        
        10738 => {
             name => 'Люберцы', 
             ua_name => 'Люберці', 
             tr_name => 'Liubertsy', 
             ename => 'Lubercy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98594 ], 
             childs => [  ], 
        },
        
        10739 => {
             name => 'Можайск', 
             ua_name => 'Можайськ', 
             tr_name => 'Mojaysk', 
             ename => 'Mozhaysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98595 ], 
             childs => [  ], 
        },
        
        10740 => {
             name => 'Мытищи', 
             ua_name => 'Митищі', 
             tr_name => 'Mytişçi', 
             ename => 'Mytischi',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98596 ], 
             childs => [  ], 
        },
        
        10741 => {
             name => 'Наро-Фоминск', 
             ua_name => 'Наро-Фомінськ', 
             tr_name => 'Naro-Fominsk', 
             ename => 'Naro-Fominsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98597 ], 
             childs => [  ], 
        },
        
        10742 => {
             name => 'Ногинск', 
             ua_name => 'Ногинськ', 
             tr_name => 'Noginsk', 
             ename => 'Noginsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98598 ], 
             childs => [  ], 
        },
        
        10743 => {
             name => 'Одинцово', 
             ua_name => 'Одинцово', 
             tr_name => 'Odintsovo', 
             ename => 'Odincovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98599 ], 
             childs => [  ], 
        },
        
        10745 => {
             name => 'Орехово-Зуево', 
             ua_name => 'Орєхово-Зуєво', 
             tr_name => 'Orehovo-Zuyevo', 
             ename => 'Orehovo-Zuevo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10746 => {
             name => 'Павловский Посад', 
             ua_name => 'Павловський Посад', 
             tr_name => 'Pavlovski Posad', 
             ename => 'Pavlovskiy Posad',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98602 ], 
             childs => [  ], 
        },
        
        10747 => {
             name => 'Подольск', 
             ua_name => 'Подольськ', 
             tr_name => 'Podolsk', 
             ename => 'Podolsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10748 => {
             name => 'Пушкино', 
             ua_name => 'Пушкіно', 
             tr_name => 'Puşkino', 
             ename => 'Pushkino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        10750 => {
             name => 'Раменское', 
             ua_name => 'Раменське', 
             tr_name => 'Ramenskoye', 
             ename => 'Ramenskoe',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98605 ], 
             childs => [  ], 
        },
        
        10751 => {
             name => 'Руза', 
             ua_name => 'Руза', 
             tr_name => 'Ruza', 
             ename => 'Ruza',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98606 ], 
             childs => [  ], 
        },
        
        10752 => {
             name => 'Сергиев Посад', 
             ua_name => 'Сергієв Посад', 
             tr_name => 'Sergiyev Posad', 
             ename => 'Sergiev Posad',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98608 ], 
             childs => [  ], 
        },
        
        10754 => {
             name => 'Серпухов', 
             ua_name => 'Серпухов', 
             tr_name => 'Serpuhov', 
             ename => 'Serpuhov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10755 => {
             name => 'Солнечногорск', 
             ua_name => 'Солнєчногорськ', 
             tr_name => 'Solneçnogorsk', 
             ename => 'Solnechnogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98611 ], 
             childs => [  ], 
        },
        
        10756 => {
             name => 'Ступино', 
             ua_name => 'Ступіно', 
             tr_name => 'Stupino', 
             ename => 'Stupino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98607 ], 
             childs => [  ], 
        },
        
        10758 => {
             name => 'Химки', 
             ua_name => 'Хімки', 
             tr_name => 'Himki', 
             ename => 'Himki',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        10761 => {
             name => 'Чехов', 
             ua_name => 'Чехов', 
             tr_name => 'Çehov', 
             ename => 'Chehov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98614 ], 
             childs => [  ], 
        },
        
        10762 => {
             name => 'Шатура', 
             ua_name => 'Шатура', 
             tr_name => 'Şatura', 
             ename => 'Shatura',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98615 ], 
             childs => [  ], 
        },
        
        10765 => {
             name => 'Щелково', 
             ua_name => 'Щолково', 
             tr_name => 'Şçolkovo', 
             ename => 'Shelkovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98617 ], 
             childs => [  ], 
        },
        
        10772 => {
             name => 'Орловская область', 
             ua_name => 'Орловська область', 
             tr_name => 'Orlovskaya oblastı', 
             ename => 'Oryol Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 10 ], 
        },
        
        10773 => {
             name => 'Касимов', 
             ua_name => 'Касімов', 
             tr_name => 'Kasimov', 
             ename => 'Kasimov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10776 ], 
             childs => [  ], 
        },
        
        10776 => {
             name => 'Рязанская область', 
             ua_name => 'Рязанська область', 
             tr_name => 'Riazanskaya oblastı', 
             ename => 'Ryazan Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 11, 10773 ], 
        },
        
        10782 => {
             name => 'Вязьма', 
             ua_name => 'Вязьма', 
             tr_name => 'Viazma', 
             ename => 'Vyazma',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10795, 98958 ], 
             childs => [  ], 
        },
        
        10783 => {
             name => 'Гагарин', 
             ua_name => 'Гагарін', 
             tr_name => 'Gagarin', 
             ename => 'Gagarin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10795, 98959 ], 
             childs => [  ], 
        },
        
        10795 => {
             name => 'Смоленская область', 
             ua_name => 'Смоленська область', 
             tr_name => 'Smolenskaya oblastı', 
             ename => 'Smolensk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 12, 98958, 98959, 98981 ], 
        },
        
        10801 => {
             name => 'Ярцево', 
             ua_name => 'Ярцево', 
             tr_name => 'Yartsevo', 
             ename => 'Yartsevo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10795, 98981 ], 
             childs => [  ], 
        },
        
        10802 => {
             name => 'Тамбовская область', 
             ua_name => 'Тамбовська область', 
             tr_name => 'Tambovskaya oblastı', 
             ename => 'Tambov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 13, 10803 ], 
        },
        
        10803 => {
             name => 'Мичуринск', 
             ua_name => 'Мічурінськ', 
             tr_name => 'Miçurinsk', 
             ename => 'Michurinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10802 ], 
             childs => [  ], 
        },
        
        10805 => {
             name => 'Бологое', 
             ua_name => 'Бологе', 
             tr_name => 'Bologoe', 
             ename => 'Bologoe',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99008 ], 
             childs => [  ], 
        },
        
        10807 => {
             name => 'Вышний Волочёк', 
             ua_name => 'Вишній Волочeк', 
             tr_name => 'Vishniy Volochek', 
             ename => 'Vishniy Volochek',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        10811 => {
             name => 'Кимры', 
             ua_name => 'Кімри', 
             tr_name => 'Kimry', 
             ename => 'Kimry',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        10812 => {
             name => 'Конаково', 
             ua_name => 'Конаково', 
             tr_name => 'Konakovo', 
             ename => 'Konakovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99019 ], 
             childs => [  ], 
        },
        
        10818 => {
             name => 'Осташков', 
             ua_name => 'Осташков', 
             tr_name => 'Ostashkov', 
             ename => 'Ostashkov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99028 ], 
             childs => [  ], 
        },
        
        10819 => {
             name => 'Тверская область', 
             ua_name => 'Тверська область', 
             tr_name => 'Tverskaya oblastı', 
             ename => 'Tver Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 14, 10807, 10811, 10820, 99008, 99019, 99028, 99039 ], 
        },
        
        10820 => {
             name => 'Ржев', 
             ua_name => 'Ржев', 
             tr_name => 'Rzhev', 
             ename => 'Rzhev',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        10824 => {
             name => 'Удомля', 
             ua_name => 'Удомля', 
             tr_name => 'Udomlya', 
             ename => 'Udomlya',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10819, 99039 ], 
             childs => [  ], 
        },
        
        10828 => {
             name => 'Ефремов', 
             ua_name => 'Єфремов', 
             tr_name => 'Yefremov', 
             ename => 'Efremov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [  ], 
        },
        
        10830 => {
             name => 'Новомосковск', 
             ua_name => 'Новомосковськ', 
             tr_name => 'Novomoskovsk', 
             ename => 'Novomoskovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [  ], 
        },
        
        10832 => {
             name => 'Тульская область', 
             ua_name => 'Тульська область', 
             tr_name => 'Tulskaya oblastı', 
             ename => 'Tula Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 15, 10828, 10830, 99044 ], 
        },
        
        10836 => {
             name => 'Мышкин', 
             ua_name => 'Мишкин', 
             tr_name => 'Myşkin', 
             ename => 'Myshkin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10841, 99070 ], 
             childs => [  ], 
        },
        
        10837 => {
             name => 'Переславль-Залесский', 
             ua_name => 'Переславль-Залєський', 
             tr_name => 'Pereslavl-Zalesski', 
             ename => 'Pereslavl-Zalesskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [  ], 
        },
        
        10839 => {
             name => 'Рыбинск', 
             ua_name => 'Рибинськ', 
             tr_name => 'Rybinsk', 
             ename => 'Rybinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [  ], 
        },
        
        10840 => {
             name => 'Углич', 
             ua_name => 'Углич', 
             tr_name => 'Ugliç', 
             ename => 'Uglich',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10841, 99079 ], 
             childs => [  ], 
        },
        
        10841 => {
             name => 'Ярославская область', 
             ua_name => 'Ярославська область', 
             tr_name => 'Yaroslavskaya oblastı', 
             ename => 'Yaroslavl Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 16, 10837, 10839, 99070, 99078, 99079 ], 
        },
        
        10842 => {
             name => 'Архангельская область', 
             ua_name => 'Архангельська область', 
             tr_name => 'Arhangelskaya oblastı', 
             ename => 'Arkhange\'lskaya Oblast\'',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 20, 10846, 10849, 20117 ], 
        },
        
        10846 => {
             name => 'Котлас', 
             ua_name => 'Котлас', 
             tr_name => 'Kotlas', 
             ename => 'Kotlas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        10849 => {
             name => 'Северодвинск', 
             ua_name => 'Сєвєродвінськ', 
             tr_name => 'Severodvinsk', 
             ename => 'Severodvinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        10853 => {
             name => 'Вологодская область', 
             ua_name => 'Вологодська область', 
             tr_name => 'Vologodskaya oblastı', 
             ename => 'Vologda Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 21, 968, 99105 ], 
        },
        
        10854 => {
             name => 'Великий Устюг', 
             ua_name => 'Великий Устюг', 
             tr_name => 'Velikiy Ustug', 
             ename => 'Velikiy Ustug',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10853, 99105 ], 
             childs => [  ], 
        },
        
        10857 => {
             name => 'Калининградская область', 
             ua_name => 'Калінінградська область', 
             tr_name => 'Kaliningradskaya oblastı', 
             ename => 'Kaliningrad Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 22, 10860, 20139, 20144 ], 
        },
        
        10860 => {
             name => 'Советск', 
             ua_name => 'Совєтськ', 
             tr_name => 'Sovetsk', 
             ename => 'Sovetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        10864 => {
             name => 'Волхов', 
             ua_name => 'Волхов', 
             tr_name => 'Volhov', 
             ename => 'Volhov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98620 ], 
             childs => [  ], 
        },
        
        10865 => {
             name => 'Всеволожск', 
             ua_name => 'Всеволожськ', 
             tr_name => 'Vsevolgsk', 
             ename => 'Vsevolgsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98621 ], 
             childs => [  ], 
        },
        
        10867 => {
             name => 'Гатчина', 
             ua_name => 'Гатчина', 
             tr_name => 'Gatchina', 
             ename => 'Gatchina',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98623 ], 
             childs => [  ], 
        },
        
        10870 => {
             name => 'Кингисепп', 
             ua_name => 'Кінгісепп', 
             tr_name => 'Kingisepp', 
             ename => 'Kingisepp',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98624 ], 
             childs => [  ], 
        },
        
        10871 => {
             name => 'Кириши', 
             ua_name => 'Кириші', 
             tr_name => 'Kirishi', 
             ename => 'Kirishi',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98625 ], 
             childs => [  ], 
        },
        
        10872 => {
             name => 'Кировск', 
             ua_name => 'Кіровськ', 
             tr_name => 'Kirovsk', 
             ename => 'Kirovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98626 ], 
             childs => [  ], 
        },
        
        10876 => {
             name => 'Луга', 
             ua_name => 'Луга', 
             tr_name => 'Luga', 
             ename => 'Luga',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98629 ], 
             childs => [  ], 
        },
        
        10881 => {
             name => 'Подпорожье', 
             ua_name => 'Підпоріжжя', 
             tr_name => 'Podorogie', 
             ename => 'Podporogie',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98630 ], 
             childs => [  ], 
        },
        
        10883 => {
             name => 'Приозерск', 
             ua_name => 'Приозерськ', 
             tr_name => 'Priozersk', 
             ename => 'Priozersk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98631 ], 
             childs => [  ], 
        },
        
        10884 => {
             name => 'Пушкин', 
             ua_name => 'Пушкін', 
             tr_name => 'Puşkin', 
             ename => 'Pushkin',             
             media => 0, 
             geo_flag => 1, 
             level => 6, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 2, 20297 ], 
             childs => [  ], 
        },
        
        10888 => {
             name => 'Сланцы', 
             ua_name => 'Сланці', 
             tr_name => 'Slantsy', 
             ename => 'Slantsy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98632 ], 
             childs => [  ], 
        },
        
        10891 => {
             name => 'Сосновый Бор', 
             ua_name => 'Сосновий Бір', 
             tr_name => 'Sosnoviy Bor', 
             ename => 'Sosnoviy Bor',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [  ], 
        },
        
        10892 => {
             name => 'Тихвин', 
             ua_name => 'Тихвін', 
             tr_name => 'Tixvin', 
             ename => 'Tikhvin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98633 ], 
             childs => [  ], 
        },
        
        10893 => {
             name => 'Тосно', 
             ua_name => 'Тосно', 
             tr_name => 'Tosno', 
             ename => 'Tosno',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98634 ], 
             childs => [  ], 
        },
        
        10894 => {
             name => 'Апатиты', 
             ua_name => 'Апатіти', 
             tr_name => 'Apatity', 
             ename => 'Apatity',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        10895 => {
             name => 'Кандалакша', 
             ua_name => 'Кандалакша', 
             tr_name => 'Kandalaksha', 
             ename => 'Kandalaksha',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10897, 101749 ], 
             childs => [  ], 
        },
        
        10896 => {
             name => 'Мончегорск', 
             ua_name => 'Мончегорськ', 
             tr_name => 'Monchegorsk', 
             ename => 'Monchegorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        10897 => {
             name => 'Мурманская область', 
             ua_name => 'Мурманська область', 
             tr_name => 'Murmanskaya oblastı', 
             ename => 'Murmansk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 23, 10894, 10896, 20155, 101749 ], 
        },
        
        10902 => {
             name => 'Нарьян-Мар', 
             ua_name => 'Нар\'ян-Мар', 
             tr_name => 'Naryan-Mar', 
             ename => 'Naryan-Mar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10176 ], 
             childs => [  ], 
        },
        
        10904 => {
             name => 'Новгородская область', 
             ua_name => 'Новгородська область', 
             tr_name => 'Novgorodskaya oblastı', 
             ename => 'Novgorod Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 24, 99146, 99147, 99161 ], 
        },
        
        10906 => {
             name => 'Боровичи', 
             ua_name => 'Боровичі', 
             tr_name => 'Borovichy', 
             ename => 'Borovichy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10904, 99146 ], 
             childs => [  ], 
        },
        
        10907 => {
             name => 'Валдай', 
             ua_name => 'Валдай', 
             tr_name => 'Valday', 
             ename => 'Valday',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10904, 99147 ], 
             childs => [  ], 
        },
        
        1091 => {
             name => 'Нижневартовск', 
             ua_name => 'Нижньовартовськ', 
             tr_name => 'Nijnevartovsk', 
             ename => 'Nizhnevartovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        1092 => {
             name => 'Назрань', 
             ua_name => 'Назрань', 
             tr_name => 'Nazran', 
             ename => 'Nazran',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11012 ], 
             childs => [  ], 
        },
        
        10923 => {
             name => 'Старая Русса', 
             ua_name => 'Стара Русса', 
             tr_name => 'Staraya Russa', 
             ename => 'Staraya Russa',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10904, 99161 ], 
             childs => [  ], 
        },
        
        10926 => {
             name => 'Псковская область', 
             ua_name => 'Псковська область', 
             tr_name => 'Pskovskaya oblastı', 
             ename => 'Pskov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 25, 10928 ], 
        },
        
        10928 => {
             name => 'Великие Луки', 
             ua_name => 'Великі Луки', 
             tr_name => 'Velikie Luky', 
             ename => 'Velikie Luky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10926 ], 
             childs => [  ], 
        },
        
        1093 => {
             name => 'Майкоп', 
             ua_name => 'Майкоп', 
             tr_name => 'Maykop', 
             ename => 'Maykop',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11004 ], 
             childs => [  ], 
        },
        
        10933 => {
             name => 'Республика Карелия', 
             ua_name => 'Республіка Карелія', 
             tr_name => 'Karelya', 
             ename => 'Republic of Karelia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 18, 10935, 99193, 99203, 110934 ], 
        },
        
        10934 => {
             name => 'Кондопога', 
             ua_name => 'Кондопога', 
             tr_name => 'Kondopoga', 
             ename => 'Kondopoga',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10933, 99193 ], 
             childs => [  ], 
        },
        
        10935 => {
             name => 'Костомукша', 
             ua_name => 'Костомукша', 
             tr_name => 'Kostomucsha', 
             ename => 'Kostomucsha',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [  ], 
        },
        
        10936 => {
             name => 'Сегежа', 
             ua_name => 'Сегежа', 
             tr_name => 'Segezha', 
             ename => 'Segezha',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10933, 99203 ], 
             childs => [  ], 
        },
        
        10937 => {
             name => 'Сортавала', 
             ua_name => 'Сортавала', 
             tr_name => 'Sortavala', 
             ename => 'Sortavala',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10933, 110934 ], 
             childs => [  ], 
        },
        
        10939 => {
             name => 'Республика Коми', 
             ua_name => 'Республіка Комі', 
             tr_name => 'Komi', 
             ename => 'Komi Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 19, 10940, 10941, 10944, 10945, 99210 ], 
        },
        
        1094 => {
             name => 'Элиста', 
             ua_name => 'Еліста', 
             tr_name => 'Elista', 
             ename => 'Elista',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11015 ], 
             childs => [  ], 
        },
        
        10940 => {
             name => 'Воркута', 
             ua_name => 'Воркута', 
             tr_name => 'Vorkuta', 
             ename => 'Vorkuta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10941 => {
             name => 'Инта', 
             ua_name => 'Інта', 
             tr_name => 'Inta', 
             ename => 'Inta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10942 => {
             name => 'Печора', 
             ua_name => 'Печора', 
             tr_name => 'Pechora', 
             ename => 'Pechora',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10939, 99210 ], 
             childs => [  ], 
        },
        
        10944 => {
             name => 'Усинск', 
             ua_name => 'Усинськ', 
             tr_name => 'Usinsk', 
             ename => 'Usinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10945 => {
             name => 'Ухта', 
             ua_name => 'Ухта', 
             tr_name => 'Uhta', 
             ename => 'Uhta',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        10946 => {
             name => 'Астраханская область', 
             ua_name => 'Астраханська область', 
             tr_name => 'Astrahanskaya oblastı', 
             ename => 'Astrakhan Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 37, 99221 ], 
        },
        
        1095 => {
             name => 'Абакан', 
             ua_name => 'Абакан', 
             tr_name => 'Abakan', 
             ename => 'Abakan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11340 ], 
             childs => [  ], 
        },
        
        10950 => {
             name => 'Волгоградская область', 
             ua_name => 'Волгоградська область', 
             tr_name => 'Volgogradskaya oblastı', 
             ename => 'Volgograd Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 38, 10951, 10959, 10965, 10981 ], 
        },
        
        10951 => {
             name => 'Волжский', 
             ua_name => 'Волзький', 
             tr_name => 'Voljski', 
             ename => 'Volzhskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10959 => {
             name => 'Камышин', 
             ua_name => 'Камишин', 
             tr_name => 'Kamyşin', 
             ename => 'Kamishin',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10965 => {
             name => 'Михайловка', 
             ua_name => 'Михайлівка', 
             tr_name => 'Mihaylovka', 
             ename => 'Mihaylovka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10981 => {
             name => 'Урюпинск', 
             ua_name => 'Урюпінськ', 
             tr_name => 'Uriupinsk', 
             ename => 'Uryupinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        10987 => {
             name => 'Армавир', 
             ua_name => 'Армавір', 
             tr_name => 'Armavir (Krasnodarski krayı)', 
             ename => 'Armavir (Krasnodar Krai)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        10988 => {
             name => 'Белореченск', 
             ua_name => 'Бєлореченськ', 
             tr_name => 'Beloreçensk', 
             ename => 'Belorechensk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99269 ], 
             childs => [  ], 
        },
        
        10990 => {
             name => 'Геленджик', 
             ua_name => 'Геленджик', 
             tr_name => 'Gelencik', 
             ename => 'Gelendgik',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        10993 => {
             name => 'Ейск', 
             ua_name => 'Єйськ', 
             tr_name => 'Yeysk', 
             ename => 'Yesk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99274 ], 
             childs => [  ], 
        },
        
        10995 => {
             name => 'Краснодарский край', 
             ua_name => 'Краснодарський край', 
             tr_name => 'Krasnodarski krayı', 
             ename => 'Krasnodar Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 35, 239, 970, 1107, 10987, 10990, 99269, 99274, 99275, 99281, 99293, 99297, 99298, 99299 ], 
        },
        
        10996 => {
             name => 'Кропоткин', 
             ua_name => 'Кропоткін', 
             tr_name => 'Kropotkin', 
             ename => 'Kropotkin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99275 ], 
             childs => [  ], 
        },
        
        10997 => {
             name => 'Крымск', 
             ua_name => 'Кримськ', 
             tr_name => 'Krymsk', 
             ename => 'Krymsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99281 ], 
             childs => [  ], 
        },
        
        11 => {
             name => 'Рязань', 
             ua_name => 'Рязань', 
             tr_name => 'Riazan', 
             ename => 'Ryazan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10776 ], 
             childs => [  ], 
        },
        
        11002 => {
             name => 'Тихорецк', 
             ua_name => 'Тихорєцьк', 
             tr_name => 'Tihoretsk', 
             ename => 'Tikhoretsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99298 ], 
             childs => [  ], 
        },
        
        11004 => {
             name => 'Республика Адыгея', 
             ua_name => 'Республіка Адигея', 
             tr_name => 'Adıge Cumhuriyeti', 
             ename => 'Republic of Adygea',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 1093 ], 
        },
        
        11006 => {
             name => 'Буйнакск', 
             ua_name => 'Буйнакськ', 
             tr_name => 'Buynaksk', 
             ename => 'Buynaksk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11007 => {
             name => 'Дербент', 
             ua_name => 'Дербент', 
             tr_name => 'Derbent', 
             ename => 'Derbent',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11008 => {
             name => 'Каспийск', 
             ua_name => 'Каспійськ', 
             tr_name => 'Kaspiysk', 
             ename => 'Kaspiysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11009 => {
             name => 'Кизляр', 
             ua_name => 'Кизляр', 
             tr_name => 'Kizlyar', 
             ename => 'Kizlyar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11010 => {
             name => 'Республика Дагестан', 
             ua_name => 'Республіка Дагестан', 
             tr_name => 'Dağıstan', 
             ename => 'Republic of Dagestan',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 28, 11006, 11007, 11008, 11009, 11011, 21521 ], 
        },
        
        11011 => {
             name => 'Хасавюрт', 
             ua_name => 'Хасавюрт', 
             tr_name => 'Khasavyurt', 
             ename => 'Khasavurt',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        11012 => {
             name => 'Республика Ингушетия', 
             ua_name => 'Республіка Інгушетія', 
             tr_name => 'İnguşetya', 
             ename => 'Republic of Ingushetia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 1092, 20181 ], 
        },
        
        11013 => {
             name => 'Кабардино-Балкарская Республика', 
             ua_name => 'Республіка Кабардино-Балкарія', 
             tr_name => 'Kabardino-Balkarya', 
             ename => 'The Kabardino-Balkar Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 30 ], 
        },
        
        11015 => {
             name => 'Республика Калмыкия', 
             ua_name => 'Республіка Калмикія', 
             tr_name => 'Kalmukya', 
             ename => 'Republic of Kalmykia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 1094 ], 
        },
        
        11020 => {
             name => 'Карачаево-Черкесская Республика', 
             ua_name => 'Карачаєво-Черкеська Республіка', 
             tr_name => 'Karaçay-Çerkez Cumhuriyeti', 
             ename => 'Karachay-Cherkess Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 1104 ], 
        },
        
        11021 => {
             name => 'Республика Северная Осетия — Алания', 
             ua_name => 'Республіка Північна Осетія — Аланія', 
             tr_name => 'Kuzey Osetya-Alanya', 
             ename => 'Republic of North Ossetia — Alania',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 33 ], 
        },
        
        11024 => {
             name => 'Чеченская Республика', 
             ua_name => 'Чеченська Республіка', 
             tr_name => 'Çeçen Cumhuriyeti', 
             ename => 'Chechen Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 1106 ], 
        },
        
        11029 => {
             name => 'Ростовская область', 
             ua_name => 'Ростовська область', 
             tr_name => 'Rostovskaya oblastı', 
             ename => 'Rostov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 26 ], 
             childs => [ 39, 238, 971, 11030, 11033, 11036, 11037, 11043, 11049, 11053, 99411 ], 
        },
        
        11030 => {
             name => 'Азов', 
             ua_name => 'Азов', 
             tr_name => 'Azov', 
             ename => 'Azov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11033 => {
             name => 'Батайск', 
             ua_name => 'Батайськ', 
             tr_name => 'Bataysk', 
             ename => 'Bataysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11034 => {
             name => 'Белая Калитва', 
             ua_name => 'Біла Калитва', 
             tr_name => 'Belaya Kalitva', 
             ename => 'Belaya Kalitva',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 11029, 99411 ], 
             childs => [  ], 
        },
        
        11036 => {
             name => 'Волгодонск', 
             ua_name => 'Волгодонськ', 
             tr_name => 'Volgodonsk', 
             ename => 'Volgodonsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11037 => {
             name => 'Гуково', 
             ua_name => 'Гуково', 
             tr_name => 'Gukovo', 
             ename => 'Gukovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        1104 => {
             name => 'Черкесск', 
             ua_name => 'Черкеськ', 
             tr_name => 'Cherkessk', 
             ename => 'Cherkessk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11020 ], 
             childs => [  ], 
        },
        
        11043 => {
             name => 'Каменск-Шахтинский', 
             ua_name => 'Каменськ-Шахтинський', 
             tr_name => 'Kamensk-Şahtinski', 
             ename => 'Kamensk-Shakhtinsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11049 => {
             name => 'Новошахтинск', 
             ua_name => 'Новошахтинськ', 
             tr_name => 'Novoşahtinsk', 
             ename => 'Novoshahtinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11053 => {
             name => 'Шахты', 
             ua_name => 'Шахти', 
             tr_name => 'Şahty', 
             ename => 'Shakhty',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        11055 => {
             name => 'Будённовск', 
             ua_name => 'Будьоновськ', 
             tr_name => 'Budennovsk', 
             ename => 'Budennovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069, 99456 ], 
             childs => [  ], 
        },
        
        11056 => {
             name => 'Георгиевск', 
             ua_name => 'Георгієвськ', 
             tr_name => 'Georgievsk', 
             ename => 'Georgievsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11057 => {
             name => 'Ессентуки', 
             ua_name => 'Єсентуки', 
             tr_name => 'Essentuky', 
             ename => 'Essentuky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        1106 => {
             name => 'Грозный', 
             ua_name => 'Грозний', 
             tr_name => 'Grozni', 
             ename => 'Grozniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11024 ], 
             childs => [  ], 
        },
        
        11062 => {
             name => 'Кисловодск', 
             ua_name => 'Кисловодськ', 
             tr_name => 'Kislovodsk', 
             ename => 'Kislovodsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11063 => {
             name => 'Минеральные Воды', 
             ua_name => 'Мінеральні Води', 
             tr_name => 'Mineralniye Vodi', 
             ename => 'Mineralniye Vodi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11064 => {
             name => 'Невинномысск', 
             ua_name => 'Невинномиськ', 
             tr_name => 'Nevinnomissk', 
             ename => 'Nevinnomissk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11067 => {
             name => 'Пятигорск', 
             ua_name => 'П\'ятигорськ', 
             tr_name => 'Pyatigorsk', 
             ename => 'Pyatigorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        11069 => {
             name => 'Ставропольский край', 
             ua_name => 'Ставропольський край', 
             tr_name => 'Stavropolski krayı', 
             ename => 'Stavropol Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 102444 ], 
             childs => [ 36, 11056, 11057, 11062, 11063, 11064, 11067, 99456 ], 
        },
        
        1107 => {
             name => 'Анапа', 
             ua_name => 'Анапа', 
             tr_name => 'Anapa', 
             ename => 'Anapa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        11070 => {
             name => 'Кировская область', 
             ua_name => 'Кіровська область', 
             tr_name => 'Kirovskaya oblastı', 
             ename => 'Kirov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 46, 11071, 20020 ], 
        },
        
        11071 => {
             name => 'Кирово-Чепецк', 
             ua_name => 'Кірово-Чепецьк', 
             tr_name => 'Kirovo-Chepetsk', 
             ename => 'Kirovo-Chepetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11070 ], 
             childs => [  ], 
        },
        
        11077 => {
             name => 'Республика Марий Эл', 
             ua_name => 'Республіка Марій Ел', 
             tr_name => 'Mariy El Cumhuriyeti', 
             ename => 'Mari El Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 41, 20721 ], 
        },
        
        11079 => {
             name => 'Нижегородская область', 
             ua_name => 'Нижегородська область', 
             tr_name => 'Nijegorodskaya oblastı', 
             ename => 'Nizhny Novgorod Oblast\'',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 47, 972, 11080, 11083, 20040, 99555, 99560 ], 
        },
        
        11080 => {
             name => 'Арзамас', 
             ua_name => 'Арзамас', 
             tr_name => 'Arzamas', 
             ename => 'Arzamas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        11082 => {
             name => 'Павлово', 
             ua_name => 'Павлово', 
             tr_name => 'Pavlovo', 
             ename => 'Pavlovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11079, 99560 ], 
             childs => [  ], 
        },
        
        11083 => {
             name => 'Саров', 
             ua_name => 'Саров', 
             tr_name => 'Sarov', 
             ename => 'Sarov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        11084 => {
             name => 'Оренбургская область', 
             ua_name => 'Оренбурзька область', 
             tr_name => 'Orenburgskaya oblastı', 
             ename => 'Orenburg Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 48, 11086, 11087, 11090, 11091 ], 
        },
        
        11086 => {
             name => 'Бузулук', 
             ua_name => 'Бузулук', 
             tr_name => 'Buzuluk', 
             ename => 'Buzuluk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        11087 => {
             name => 'Гай', 
             ua_name => 'Гай', 
             tr_name => 'Gay', 
             ename => 'Gay',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        11090 => {
             name => 'Новотроицк', 
             ua_name => 'Новотроїцьк', 
             tr_name => 'Novotroitsk', 
             ename => 'Novotroitsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        11091 => {
             name => 'Орск', 
             ua_name => 'Орськ', 
             tr_name => 'Orsk', 
             ename => 'Orsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        110916 => {
             name => 'Чайковский район', 
             ua_name => 'Чайковський район', 
             tr_name => 'Chaykovski İlçesi', 
             ename => 'Chaykovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [ 20243 ], 
        },
        
        110934 => {
             name => 'Сортавальский район', 
             ua_name => 'Сортавальський район', 
             tr_name => 'Sortavalski İlçesi', 
             ename => 'Sortavalsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [ 10937 ], 
        },
        
        11095 => {
             name => 'Пензенская область', 
             ua_name => 'Пензенська область', 
             tr_name => 'Penzenskaya oblastı', 
             ename => 'Penza Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 49, 11101 ], 
        },
        
        111 => {
             name => 'Европа', 
             ua_name => 'Європа', 
             tr_name => 'Avrupa', 
             ename => 'Europe',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 96, 102, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 179, 180, 203, 204, 205, 206, 246, 983, 10074, 10077, 10083, 20574, 21610 ], 
        },
        
        11101 => {
             name => 'Кузнецк', 
             ua_name => 'Кузнецьк', 
             tr_name => 'Kuznetsk', 
             ename => 'Kuznetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11095 ], 
             childs => [  ], 
        },
        
        11108 => {
             name => 'Пермский край', 
             ua_name => 'Пермський край', 
             tr_name => 'Permski krayı', 
             ename => 'Perm Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 50, 11110, 20237, 20244, 110916 ], 
        },
        
        11110 => {
             name => 'Соликамск', 
             ua_name => 'Солікамськ', 
             tr_name => 'Solikamsk', 
             ename => 'Solikamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        11111 => {
             name => 'Республика Башкортостан', 
             ua_name => 'Республіка Башкортостан', 
             tr_name => 'Başkurdistan', 
             ename => 'Republic of Bashkortostan',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 172, 11113, 11114, 11115, 11116, 20235, 20716, 99675, 99677, 99694, 99703, 99712, 99714 ], 
        },
        
        11113 => {
             name => 'Кумертау', 
             ua_name => 'Кумертау', 
             tr_name => 'Kumertau', 
             ename => 'Kumertau',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11114 => {
             name => 'Нефтекамск', 
             ua_name => 'Нефтекамськ', 
             tr_name => 'Neftekamsk', 
             ename => 'Nephtekamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11115 => {
             name => 'Салават', 
             ua_name => 'Салават', 
             tr_name => 'Salavat', 
             ename => 'Salavat',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11116 => {
             name => 'Стерлитамак', 
             ua_name => 'Стерлітамак', 
             tr_name => 'Sterlitamak', 
             ename => 'Sterlitamak',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        11117 => {
             name => 'Республика Мордовия', 
             ua_name => 'Республіка Мордовія', 
             tr_name => 'Mordovya', 
             ename => 'Republic of Mordovia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 42, 99737 ], 
        },
        
        11119 => {
             name => 'Республика Татарстан', 
             ua_name => 'Республіка Татарстан', 
             tr_name => 'Tataristan', 
             ename => 'Republic of Tatarstan',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 43, 236, 11121, 11122, 11127, 11129 ], 
        },
        
        11121 => {
             name => 'Альметьевск', 
             ua_name => 'Альметьєвськ', 
             tr_name => 'Almetyevsk (Elmet)', 
             ename => 'Almetyevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11122 => {
             name => 'Бугульма', 
             ua_name => 'Бугульма', 
             tr_name => 'Bügülme', 
             ename => 'Bugulma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11127 => {
             name => 'Нижнекамск', 
             ua_name => 'Нижньокамськ', 
             tr_name => 'Nijnekamsk (Tüben Kama)', 
             ename => 'Nizhnekamsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11129 => {
             name => 'Чистополь', 
             ua_name => 'Чистополь', 
             tr_name => 'Çistopol (Çistey)', 
             ename => 'Chistopol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        11131 => {
             name => 'Самарская область', 
             ua_name => 'Самарська область', 
             tr_name => 'Samarskaya oblastı', 
             ename => 'Samara Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 51, 240, 11132, 11135, 11139 ], 
        },
        
        11132 => {
             name => 'Жигулёвск', 
             ua_name => 'Жигульовськ', 
             tr_name => 'Jiguliovsk', 
             ename => 'Zhiguliovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        11135 => {
             name => 'Новокуйбышевск', 
             ua_name => 'Новокуйбишевськ', 
             tr_name => 'Novokuybyşevsk', 
             ename => 'Novokuibishevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        11139 => {
             name => 'Сызрань', 
             ua_name => 'Сизрань', 
             tr_name => 'Syzran', 
             ename => 'Syzran',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        11143 => {
             name => 'Балаково', 
             ua_name => 'Балаково', 
             tr_name => 'Balakovo', 
             ename => 'Balakovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99817 ], 
             childs => [  ], 
        },
        
        11144 => {
             name => 'Балашов', 
             ua_name => 'Балашов', 
             tr_name => 'Balaşov', 
             ename => 'Balashev',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99818 ], 
             childs => [  ], 
        },
        
        11146 => {
             name => 'Саратовская область', 
             ua_name => 'Саратовська область', 
             tr_name => 'Saratovskaya oblastı', 
             ename => 'Saratov Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 194, 99817, 99818, 99832, 99850 ], 
        },
        
        11147 => {
             name => 'Энгельс', 
             ua_name => 'Енгельс', 
             tr_name => 'Engels', 
             ename => 'Engels',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99850 ], 
             childs => [  ], 
        },
        
        11148 => {
             name => 'Удмуртская Республика', 
             ua_name => 'Удмуртська Республіка', 
             tr_name => 'Udmurtiya', 
             ename => 'Udmurt Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 44, 11149, 11150, 11152 ], 
        },
        
        11149 => {
             name => 'Воткинск', 
             ua_name => 'Воткінськ', 
             tr_name => 'Votkinsk', 
             ename => 'Votkinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        11150 => {
             name => 'Глазов', 
             ua_name => 'Глазов', 
             tr_name => 'Glazov', 
             ename => 'Glazov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        11152 => {
             name => 'Сарапул', 
             ua_name => 'Сарапул', 
             tr_name => 'Sarapul', 
             ename => 'Sarapul',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        11153 => {
             name => 'Ульяновская область', 
             ua_name => 'Ульяновська область', 
             tr_name => 'Ulyanovskaya oblastı', 
             ename => 'Ulyanovsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 195, 11155, 20070 ], 
        },
        
        11155 => {
             name => 'Димитровград', 
             ua_name => 'Дімітровград', 
             tr_name => 'Dmitrovgrad', 
             ename => 'Dimitrovgrad',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11153 ], 
             childs => [  ], 
        },
        
        11156 => {
             name => 'Чувашская Республика', 
             ua_name => 'Чуваська Республіка', 
             tr_name => 'Çuvaşya', 
             ename => 'Chuvash Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 40 ], 
             childs => [ 45, 20078, 37133 ], 
        },
        
        11158 => {
             name => 'Курганская область', 
             ua_name => 'Курганська область', 
             tr_name => 'Kurganskaya oblastı', 
             ename => 'Kurgan Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 53, 11159 ], 
        },
        
        11159 => {
             name => 'Шадринск', 
             ua_name => 'Шадрінськ', 
             tr_name => 'Şadrinsk', 
             ename => 'Shadrinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11158 ], 
             childs => [  ], 
        },
        
        11160 => {
             name => 'Асбест', 
             ua_name => 'Асбест', 
             tr_name => 'Asbest', 
             ename => 'Asbest',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11161 => {
             name => 'Верхняя Салда', 
             ua_name => 'Верхня Салда', 
             tr_name => 'Verhniaya Salda', 
             ename => 'Verhnya Salda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11162 => {
             name => 'Свердловская область', 
             ua_name => 'Свердловська область', 
             tr_name => 'Sverdlovskaya oblastı', 
             ename => 'Sverdlovsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 54, 11160, 11161, 11164, 11165, 11166, 11167, 11168, 11169, 11170, 11171, 11172, 20224, 20234, 20579, 20654, 20672, 20684, 20691, 20720, 21726, 29397 ], 
        },
        
        11164 => {
             name => 'Каменск-Уральский', 
             ua_name => 'Каменськ-Уральський', 
             tr_name => 'Kamensk-Uralski', 
             ename => 'Kamensk-Uralskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11165 => {
             name => 'Краснотурьинск', 
             ua_name => 'Краснотур\'їнськ', 
             tr_name => 'Krasnoturyinsk', 
             ename => 'Krasnoturinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11166 => {
             name => 'Кушва', 
             ua_name => 'Кушва', 
             tr_name => 'Kuşva', 
             ename => 'Kushva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11167 => {
             name => 'Лесной', 
             ua_name => 'Лєсний', 
             tr_name => 'Lesnoy', 
             ename => 'Lesnoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11168 => {
             name => 'Нижний Тагил', 
             ua_name => 'Нижній Тагіл', 
             tr_name => 'Nijni Tagil', 
             ename => 'Nizhniy Tagil',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11169 => {
             name => 'Нижняя Тура', 
             ua_name => 'Нижня Тура', 
             tr_name => 'Nijniaya Tura', 
             ename => 'Nignaya Tura',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11170 => {
             name => 'Новоуральск', 
             ua_name => 'Новоуральськ', 
             tr_name => 'Novouralsk', 
             ename => 'Novouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11171 => {
             name => 'Первоуральск', 
             ua_name => 'Первоуральськ', 
             tr_name => 'Pervouralsk', 
             ename => 'Pervouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11172 => {
             name => 'Серов', 
             ua_name => 'Сєров', 
             tr_name => 'Serov', 
             ename => 'Serov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        11173 => {
             name => 'Ишим', 
             ua_name => 'Ішим', 
             tr_name => 'İşim', 
             ename => 'Ishim',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        11175 => {
             name => 'Тобольск', 
             ua_name => 'Тобольськ', 
             tr_name => 'Tobolsk', 
             ename => 'Tobolsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        11176 => {
             name => 'Тюменская область', 
             ua_name => 'Тюменська область', 
             tr_name => 'Tümen (Tiumenskaya) oblastı', 
             ename => 'Tyumen Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 55, 11173, 11175, 11178 ], 
        },
        
        11177 => {
             name => 'Югорск', 
             ua_name => 'Югорськ', 
             tr_name => 'Ugorsk', 
             ename => 'Ugorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11178 => {
             name => 'Ялуторовск', 
             ua_name => 'Ялуторовськ', 
             tr_name => 'Yalutorovsk', 
             ename => 'Yalutorovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        11180 => {
             name => 'Когалым', 
             ua_name => 'Когалим', 
             tr_name => 'Kogalym', 
             ename => 'Kogalym',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11181 => {
             name => 'Лангепас', 
             ua_name => 'Лангепас', 
             tr_name => 'Langepas', 
             ename => 'Langepas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11182 => {
             name => 'Мегион', 
             ua_name => 'Мегіон', 
             tr_name => 'Megion', 
             ename => 'Megion',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11184 => {
             name => 'Нефтеюганск', 
             ua_name => 'Нефтеюганськ', 
             tr_name => 'Nefteyugansk', 
             ename => 'Nefteugansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11186 => {
             name => 'Нягань', 
             ua_name => 'Нягань', 
             tr_name => 'Niagan', 
             ename => 'Nyagan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11188 => {
             name => 'Пыть-Ях', 
             ua_name => 'Пить-Ях', 
             tr_name => 'Pyt-Yah', 
             ename => 'Pyt-Yah',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11189 => {
             name => 'Радужный', 
             ua_name => 'Радужний', 
             tr_name => 'Radujny', 
             ename => 'Radugniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11192 => {
             name => 'Урай', 
             ua_name => 'Урай', 
             tr_name => 'Uray', 
             ename => 'Uray',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        11193 => {
             name => 'Ханты-Мансийский автономный округ - Югра', 
             ua_name => 'Ханти-Мансійський автономний округ', 
             tr_name => 'Hantı-Mansi Özerk Okrugu', 
             ename => 'Khanty-Mansi Autonomous Okrug — Yugra',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 57, 973, 1091, 11177, 11180, 11181, 11182, 11184, 11186, 11188, 11189, 11192 ], 
        },
        
        11196 => {
             name => 'Аша', 
             ua_name => 'Аша', 
             tr_name => 'Aşa', 
             ename => 'Asha',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 52, 11225, 100005 ], 
             childs => [  ], 
        },
        
        11200 => {
             name => 'Верхний Уфалей', 
             ua_name => 'Верхній Уфалей', 
             tr_name => 'Verhni Ufaley', 
             ename => 'Verhniy Ufaley',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11202 => {
             name => 'Златоуст', 
             ua_name => 'Златоуст', 
             tr_name => 'Zlatoust', 
             ename => 'Zlatoust',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11207 => {
             name => 'Копейск', 
             ua_name => 'Копейськ', 
             tr_name => 'Kopeysk', 
             ename => 'Kopeysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11212 => {
             name => 'Миасс', 
             ua_name => 'Міас', 
             tr_name => 'Miass', 
             ename => 'Miass',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11214 => {
             name => 'Озёрск', 
             ua_name => 'Озерськ', 
             tr_name => 'Ozersk', 
             ename => 'Ozersk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11217 => {
             name => 'Сатка', 
             ua_name => 'Сатка', 
             tr_name => 'Satka', 
             ename => 'Satka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 52, 11225, 100020 ], 
             childs => [  ], 
        },
        
        11218 => {
             name => 'Снежинск', 
             ua_name => 'Снєжинськ', 
             tr_name => 'Snejinsk', 
             ename => 'Sneginsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11220 => {
             name => 'Троицк', 
             ua_name => 'Троїцьк', 
             tr_name => 'Troitsk', 
             ename => 'Troitsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11223 => {
             name => 'Усть-Катав', 
             ua_name => 'Усть-Катав', 
             tr_name => 'Ust-Katav', 
             ename => 'Ust-Katav',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11224 => {
             name => 'Чебаркуль', 
             ua_name => 'Чебаркуль', 
             tr_name => 'Çebarkul', 
             ename => 'Chebarkul',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11225 => {
             name => 'Челябинская область', 
             ua_name => 'Челябінська область', 
             tr_name => 'Çeliabinskaya oblastı', 
             ename => 'Chelyabinsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 56, 235, 11200, 11202, 11207, 11212, 11214, 11218, 11220, 11223, 11224, 11227, 100005, 100020 ], 
        },
        
        11227 => {
             name => 'Южноуральск', 
             ua_name => 'Южноуральськ', 
             tr_name => 'Yujnouralsk', 
             ename => 'Ugnouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        11228 => {
             name => 'Губкинский', 
             ua_name => 'Губкинський', 
             tr_name => 'Gubkinski', 
             ename => 'Gubkinskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        11229 => {
             name => 'Надым', 
             ua_name => 'Надим', 
             tr_name => 'Nadym', 
             ename => 'Nadym',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 52, 11232, 100028 ], 
             childs => [  ], 
        },
        
        11230 => {
             name => 'Новый Уренгой', 
             ua_name => 'Новий Уренгой', 
             tr_name => 'Novy Urengoy', 
             ename => 'Noviy Urengoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        11231 => {
             name => 'Ноябрьск', 
             ua_name => 'Ноябрьськ', 
             tr_name => 'Noyabrsk', 
             ename => 'Noyabrsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        11232 => {
             name => 'Ямало-Ненецкий автономный округ', 
             ua_name => 'Ямало-Ненецький автономний округ', 
             tr_name => 'Yamal-Nenets Özerk Bölgesi', 
             ename => 'Yamalo-Nenets Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 52 ], 
             childs => [ 58, 11228, 11230, 11231, 100028 ], 
        },
        
        11235 => {
             name => 'Алтайский край', 
             ua_name => 'Алтайський край', 
             tr_name => 'Altayski krayı', 
             ename => 'Altai Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 197, 975, 11240, 11246, 11251 ], 
        },
        
        11240 => {
             name => 'Заринск', 
             ua_name => 'Заринськ', 
             tr_name => 'Zarinsk', 
             ename => 'Zarinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        11246 => {
             name => 'Новоалтайск', 
             ua_name => 'Новоалтайськ', 
             tr_name => 'Novoaltaysk', 
             ename => 'Novoaltaysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        11251 => {
             name => 'Рубцовск', 
             ua_name => 'Рубцовськ', 
             tr_name => 'Rubtsovsk', 
             ename => 'Rubtsovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        11256 => {
             name => 'Ангарск', 
             ua_name => 'Ангара', 
             tr_name => 'Angarsk', 
             ename => 'Angarsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11266 => {
             name => 'Иркутская область', 
             ua_name => 'Іркутська область', 
             tr_name => 'İrkutskaya oblastı', 
             ename => 'Irkutsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 63, 976, 11256, 11271, 11272, 11273, 11274, 100109, 100112, 100116 ], 
        },
        
        11268 => {
             name => 'Нижнеудинск', 
             ua_name => 'Нижньоудинськ', 
             tr_name => 'Nizgneudinsk', 
             ename => 'Nizhneudinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11266, 100109 ], 
             childs => [  ], 
        },
        
        11270 => {
             name => 'Тайшет', 
             ua_name => 'Тайшет', 
             tr_name => 'Tayshet', 
             ename => 'Tayshet',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11266, 100112 ], 
             childs => [  ], 
        },
        
        11271 => {
             name => 'Тулун', 
             ua_name => 'Тулун', 
             tr_name => 'Tulun', 
             ename => 'Tulun',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11272 => {
             name => 'Усолье-Сибирское', 
             ua_name => 'Усольє-Сибірське', 
             tr_name => 'Usolye-Sibirskoye', 
             ename => 'Usole-Sibirskoe',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11273 => {
             name => 'Усть-Илимск', 
             ua_name => 'Усть-Ілімськ', 
             tr_name => 'Ust-Ilimsk', 
             ename => 'Ust-Ilimsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11274 => {
             name => 'Черемхово', 
             ua_name => 'Черемхово', 
             tr_name => 'Cheremkhovo', 
             ename => 'Cheremkhovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        11276 => {
             name => 'Анжеро-Судженск', 
             ua_name => 'Анжеро-Судженськ', 
             tr_name => 'Anjero-Sudjensk', 
             ename => 'Angero-Sudgensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11277 => {
             name => 'Белово', 
             ua_name => 'Бєлово', 
             tr_name => 'Belovo', 
             ename => 'Belovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11278 => {
             name => 'Берёзовский (Кемеровская область)', 
             ua_name => 'Берёзовский (Кемеровская область)', 
             tr_name => 'Beriozovski (Kemerovskaya oblastı)', 
             ename => 'Berezovskiy (Kemerovo District)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11282 => {
             name => 'Кемеровская область (Кузбасс)', 
             ua_name => 'Кемеровская область (Кузбасс)', 
             tr_name => 'Kemerovskaya oblastı', 
             ename => 'Kemerovo Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 64, 237, 11276, 11277, 11278, 11283, 11285, 11287, 11288, 11291, 11292, 11299 ], 
        },
        
        11283 => {
             name => 'Киселёвск', 
             ua_name => 'Кисельовськ', 
             tr_name => 'Kiseliovsk', 
             ename => 'Kiselevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11285 => {
             name => 'Ленинск-Кузнецкий', 
             ua_name => 'Ленінськ-Кузнецький', 
             tr_name => 'Leninsk-Kuznetski', 
             ename => 'Leninsk-Kuznetskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11287 => {
             name => 'Междуреченск', 
             ua_name => 'Мєждуреченськ', 
             tr_name => 'Mejdureçensk', 
             ename => 'Mezgdurechensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11288 => {
             name => 'Мыски', 
             ua_name => 'Миски', 
             tr_name => 'Myski', 
             ename => 'Myski',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11291 => {
             name => 'Прокопьевск', 
             ua_name => 'Прокоп\'євськ', 
             tr_name => 'Prokopyevsk', 
             ename => 'Prokopevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11292 => {
             name => 'Полысаево', 
             ua_name => 'Полисаєво', 
             tr_name => 'Polysayevo', 
             ename => 'Polysaevo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        11299 => {
             name => 'Юрга', 
             ua_name => 'Юрга', 
             tr_name => 'Yurga', 
             ename => 'Urga',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        113 => {
             name => 'Австрия', 
             ua_name => 'Австрія', 
             tr_name => 'Avusturya', 
             ename => 'Austria',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        11302 => {
             name => 'Ачинск', 
             ua_name => 'Ачинськ', 
             tr_name => 'Achinsk', 
             ename => 'Achinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11304 => {
             name => 'Енисейск', 
             ua_name => 'Єнісейськ', 
             tr_name => 'Eniseysk', 
             ename => 'Eniseysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11309 => {
             name => 'Красноярский край', 
             ua_name => 'Красноярський край', 
             tr_name => 'Krasnoyarski krayı', 
             ename => 'Krasnoyarsk Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 62, 11302, 11304, 11310, 11311, 20086, 20088 ], 
        },
        
        11310 => {
             name => 'Минусинск', 
             ua_name => 'Мінусинськ', 
             tr_name => 'Minusinsk', 
             ename => 'Minusinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11311 => {
             name => 'Норильск', 
             ua_name => 'Норильськ', 
             tr_name => 'Norilsk', 
             ename => 'Norilsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        11314 => {
             name => 'Бердск', 
             ua_name => 'Бердськ', 
             tr_name => 'Berdsk', 
             ename => 'Berdsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [  ], 
        },
        
        11316 => {
             name => 'Новосибирская область', 
             ua_name => 'Новосибірська область', 
             tr_name => 'Novosibirskaya oblastı', 
             ename => 'Novosibirsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 65, 11314, 20100, 100183, 100189 ], 
        },
        
        11318 => {
             name => 'Омская область', 
             ua_name => 'Омська область', 
             tr_name => 'Omskaya oblastı', 
             ename => 'Omsk Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 66 ], 
        },
        
        11319 => {
             name => 'Горно-Алтайск', 
             ua_name => 'Горно-Алтайськ', 
             tr_name => 'Gorno-Altaysk', 
             ename => 'Gorno-Altaysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 10231 ], 
             childs => [  ], 
        },
        
        11327 => {
             name => 'Северобайкальск', 
             ua_name => 'Сєвєробайкальськ', 
             tr_name => 'Severobaykalsk', 
             ename => 'Severobaykalsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [  ], 
        },
        
        11330 => {
             name => 'Республика Бурятия', 
             ua_name => 'Республіка Бурятія', 
             tr_name => 'Buriatya', 
             ename => 'Republic of Buryatia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 198, 11327, 100244 ], 
        },
        
        11333 => {
             name => 'Кызыл', 
             ua_name => 'Кизил', 
             tr_name => 'Kızıl', 
             ename => 'Kyzyl',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 10233 ], 
             childs => [  ], 
        },
        
        11340 => {
             name => 'Республика Хакасия', 
             ua_name => 'Республіка Хакасія', 
             tr_name => 'Hakasya', 
             ename => 'Republic of Khakassia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 1095 ], 
        },
        
        11349 => {
             name => 'Колпашево', 
             ua_name => 'Колпашево', 
             tr_name => 'Kolpaşevo', 
             ename => 'Kolpashevo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11353, 100280 ], 
             childs => [  ], 
        },
        
        11351 => {
             name => 'Северск', 
             ua_name => 'Сєвєрськ', 
             tr_name => 'Seversk', 
             ename => 'Seversk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [  ], 
        },
        
        11352 => {
             name => 'Стрежевой', 
             ua_name => 'Стрежевий', 
             tr_name => 'Strejevoy', 
             ename => 'Strezgevoy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [  ], 
        },
        
        11353 => {
             name => 'Томская область', 
             ua_name => 'Томська область', 
             tr_name => 'Tomskaya oblastı', 
             ename => 'Tomsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 67, 11351, 11352, 100278, 100280 ], 
        },
        
        11374 => {
             name => 'Белогорск', 
             ua_name => 'Бєлогорськ', 
             tr_name => 'Belogorsk', 
             ename => 'Belogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        11375 => {
             name => 'Амурская область', 
             ua_name => 'Амурська область', 
             tr_name => 'Amursk Bölgesi', 
             ename => 'Amur Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 77, 11374, 11387, 11391 ], 
        },
        
        11387 => {
             name => 'Свободный', 
             ua_name => 'Свободний', 
             tr_name => 'Svobodniy', 
             ename => 'Svobodniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        11391 => {
             name => 'Тында', 
             ua_name => 'Тинда', 
             tr_name => 'Tynda', 
             ename => 'Tynda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        11393 => {
             name => 'Биробиджан', 
             ua_name => 'Біробіджан', 
             tr_name => 'Birobidgan', 
             ename => 'Birobidgan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 10243 ], 
             childs => [  ], 
        },
        
        11398 => {
             name => 'Камчатский край', 
             ua_name => 'Камчатський край', 
             tr_name => 'Kamçatski krayı', 
             ename => 'Kamchatka Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 78 ], 
        },
        
        114 => {
             name => 'Бельгия', 
             ua_name => 'Бельгія', 
             tr_name => 'Belçika', 
             ename => 'Belgium',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        11403 => {
             name => 'Магаданская область', 
             ua_name => 'Магаданська область', 
             tr_name => 'Magadan Bölgesi', 
             ename => 'Magadan District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 79 ], 
        },
        
        11405 => {
             name => 'Арсеньев', 
             ua_name => 'Арсеньєв', 
             tr_name => 'Arsenev', 
             ename => 'Arsenev',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11406 => {
             name => 'Артём', 
             ua_name => 'Артем', 
             tr_name => 'Artem', 
             ename => 'Artem',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11409 => {
             name => 'Приморский край', 
             ua_name => 'Приморський край', 
             tr_name => 'Primoriye', 
             ename => 'Primorsky Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 75, 974, 11405, 11406, 11411, 11425, 11426 ], 
        },
        
        11411 => {
             name => 'Дальнегорск', 
             ua_name => 'Дальнєгорськ', 
             tr_name => 'Dalnegorsk', 
             ename => 'Dalnegorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11425 => {
             name => 'Спасск-Дальний', 
             ua_name => 'Спаськ-Дальній', 
             tr_name => 'Spassk-Dalniy', 
             ename => 'Spassk-Dalniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11426 => {
             name => 'Уссурийск', 
             ua_name => 'Уссурійськ', 
             tr_name => 'Ussuriysk', 
             ename => 'Ussuriysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        11437 => {
             name => 'Нерюнгри', 
             ua_name => 'Нерюнгрі', 
             tr_name => 'Nerungri', 
             ename => 'Nerungri',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 73, 11443, 101987 ], 
             childs => [  ], 
        },
        
        11443 => {
             name => 'Республика Саха (Якутия)', 
             ua_name => 'Республіка Саха (Якутія)', 
             tr_name => 'Saha Cumhuriyeti (Yakutistan)', 
             ename => 'Sakha (Yakutia) Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 74, 101987 ], 
        },
        
        11450 => {
             name => 'Сахалинская область', 
             ua_name => 'Сахалінська область', 
             tr_name => 'Sahalin Bölgesi', 
             ename => 'Sakhalin District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 80, 20160 ], 
        },
        
        11451 => {
             name => 'Амурск', 
             ua_name => 'Амурськ', 
             tr_name => 'Amursk', 
             ename => 'Amursk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 73, 11457, 100398 ], 
             childs => [  ], 
        },
        
        11453 => {
             name => 'Комсомольск-на-Амуре', 
             ua_name => 'Комсомольськ-на-Амурі', 
             tr_name => 'Komsomolsk-at-Amur', 
             ename => 'Komsomolsk-at-Amur',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [  ], 
        },
        
        11457 => {
             name => 'Хабаровский край', 
             ua_name => 'Хабаровський край', 
             tr_name => 'Habarovski krayı', 
             ename => 'Khabarovsk Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 76, 11453, 100398 ], 
        },
        
        11463 => {
             name => 'Евпатория', 
             ua_name => 'Євпаторія', 
             tr_name => 'Yevpatorya', 
             ename => 'Evpatoria',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        11464 => {
             name => 'Керчь', 
             ua_name => 'Керч', 
             tr_name => 'Kerç', 
             ename => 'Kerch',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        11469 => {
             name => 'Феодосия', 
             ua_name => 'Феодосія', 
             tr_name => 'Feodosya (Kefe)', 
             ename => 'Feodosia',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        11470 => {
             name => 'Ялта', 
             ua_name => 'Ялта', 
             tr_name => 'Yalta', 
             ename => 'Yalta',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        11471 => {
             name => 'Алушта', 
             ua_name => 'Алушта', 
             tr_name => 'Aluşta', 
             ename => 'Alushta',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        11472 => {
             name => 'Судак', 
             ua_name => 'Судак', 
             tr_name => 'Sudak', 
             ename => 'Sudak',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        11474 => {
             name => 'Рига', 
             ua_name => 'Рига', 
             tr_name => 'Riga', 
             ename => 'Riga',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 111, 206 ], 
             childs => [  ], 
        },
        
        11475 => {
             name => 'Вильнюс', 
             ua_name => 'Вільнюс', 
             tr_name => 'Vilnus', 
             ename => 'Vilnius',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 117, 104260 ], 
             childs => [  ], 
        },
        
        11481 => {
             name => 'Таллин', 
             ua_name => 'Таллінн', 
             tr_name => 'Tallin', 
             ename => 'Tallinn',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 179, 104431 ], 
             childs => [  ], 
        },
        
        11482 => {
             name => 'Тарту', 
             ua_name => 'Тарту', 
             tr_name => 'Tartu', 
             ename => 'Tartu',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 179, 104430 ], 
             childs => [  ], 
        },
        
        114900 => {
             name => 'Чирчик', 
             ua_name => 'Чирчик', 
             tr_name => 'Çırçık', 
             ename => 'Chirchiq',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        115 => {
             name => 'Болгария', 
             ua_name => 'Болгарія', 
             tr_name => 'Bulgaristan', 
             ename => 'Bulgaria',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        116 => {
             name => 'Венгрия', 
             ua_name => 'Угорщина', 
             tr_name => 'Macaristan', 
             ename => 'Hungary',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        116114 => {
             name => 'Ришон-ле-Цион', 
             ua_name => 'Рішон-ле-Ціон', 
             tr_name => 'Rişon LeTsiyon', 
             ename => 'Rishon LeZion',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103900 ], 
             childs => [  ], 
        },
        
        116777 => {
             name => 'Панфиловский район', 
             ua_name => 'Панфіловський район', 
             tr_name => 'Panfilov ilçesi', 
             ename => 'Panfilov District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116778 => {
             name => 'Жамбылский район', 
             ua_name => 'Жамбилський район', 
             tr_name => 'Jambıl ilçesi', 
             ename => 'Zhambyl District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116779 => {
             name => 'Илийский район', 
             ua_name => 'Ілійський район', 
             tr_name => 'İle ilçesi', 
             ename => 'Ile District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116780 => {
             name => 'Карасайский район', 
             ua_name => 'Карасайський район', 
             tr_name => 'Karasay ilçesi', 
             ename => 'Karasay District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116781 => {
             name => 'Талгарский район', 
             ua_name => 'Талгарський район', 
             tr_name => 'Talgar ilçesi', 
             ename => 'Talgar District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116782 => {
             name => 'Енбекшиказахский район', 
             ua_name => 'Єнбекшиказахський район', 
             tr_name => 'Yenbekşikazak ilçesi', 
             ename => 'Enbekshikazakh District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        116939 => {
             name => 'Казыгуртский район', 
             ua_name => 'Казигуртський район', 
             tr_name => 'Kazığurt ilçesi', 
             ename => 'Kazygurt District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116940 => {
             name => 'Мактааральский район', 
             ua_name => 'Мактааральський район', 
             tr_name => 'Maktaaral ilçesi', 
             ename => 'Maktaaral District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116941 => {
             name => 'Ордабасинский район', 
             ua_name => 'Ордабасинський район', 
             tr_name => 'Ordabası ilçesi', 
             ename => 'Ordabasy District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116943 => {
             name => 'Сайрамский район', 
             ua_name => 'Сайрамський район', 
             tr_name => 'Sayram ilçesi', 
             ename => 'Sayram District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116944 => {
             name => 'Сарыагашский район', 
             ua_name => 'Сариагашський район', 
             tr_name => 'Sarıağaş ilçesi', 
             ename => 'Saryagash District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116946 => {
             name => 'Толебийский район', 
             ua_name => 'Толебійський район', 
             tr_name => 'Töle Biy ilçesi', 
             ename => 'Tole Bi District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116947 => {
             name => 'Тюлькубасский район', 
             ua_name => 'Тюлькубаський район', 
             tr_name => 'Tülkibas ilçesi', 
             ename => 'Tulkibas District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116948 => {
             name => 'Шардаринский район', 
             ua_name => 'Шардаринський район', 
             tr_name => 'Şardara ilçesi', 
             ename => 'Shardara District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        116954 => {
             name => 'Мунайлинский район', 
             ua_name => 'Мунайлінський район', 
             tr_name => 'Munaylı ilçesi', 
             ename => 'Munaily District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29414 ], 
             childs => [  ], 
        },
        
        116960 => {
             name => 'Кордайский район', 
             ua_name => 'Кордайський район', 
             tr_name => 'Korday ilçesi', 
             ename => 'Korday District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 159, 29409 ], 
             childs => [  ], 
        },
        
        117 => {
             name => 'Литва', 
             ua_name => 'Литва', 
             tr_name => 'Litvanya', 
             ename => 'Lithuania',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104260 ], 
        },
        
        118 => {
             name => 'Нидерланды', 
             ua_name => 'Нідерланди', 
             tr_name => 'Hollanda', 
             ename => 'Netherlands',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        119 => {
             name => 'Норвегия', 
             ua_name => 'Норвегія', 
             tr_name => 'Norveç', 
             ename => 'Norway',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        12 => {
             name => 'Смоленск', 
             ua_name => 'Смоленськ', 
             tr_name => 'Smolensk', 
             ename => 'Smolensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [  ], 
        },
        
        120 => {
             name => 'Польша', 
             ua_name => 'Польща', 
             tr_name => 'Polonya', 
             ename => 'Poland',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        121 => {
             name => 'Словакия', 
             ua_name => 'Словаччина', 
             tr_name => 'Slovakya', 
             ename => 'Slovakia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        122 => {
             name => 'Словения', 
             ua_name => 'Словенія', 
             tr_name => 'Slovenya', 
             ename => 'Slovenia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        122054 => {
             name => 'Автономная Республика Аджария', 
             ua_name => 'Автономна Республіка Аджарія', 
             tr_name => 'Acara Özerk Cumhuriyeti', 
             ename => 'Autonomous Republic of Adjara',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [ 10278 ], 
        },
        
        122055 => {
             name => 'Гурия', 
             ua_name => 'Гурія', 
             tr_name => 'Guria', 
             ename => 'Guria',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122056 => {
             name => 'Имеретия', 
             ua_name => 'Імеретія', 
             tr_name => 'İmereti', 
             ename => 'Imereti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122057 => {
             name => 'Кахетия', 
             ua_name => 'Кахетія', 
             tr_name => 'Kaheti', 
             ename => 'Kakheti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122058 => {
             name => 'Мцхета-Мтианети', 
             ua_name => 'Мцхета-Мтіанетія', 
             tr_name => 'Mtsheta-Mtianeti', 
             ename => 'Mtskheta-Mtianeti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122059 => {
             name => 'Рача-Лечхуми и Квемо-Сванети', 
             ua_name => 'Рача-Лечхумі і Квемо-Сванетія', 
             tr_name => 'Raca-Leçhumi ve Kvemo Svaneti', 
             ename => 'Racha-Lechkhumi and Kvemo Svaneti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122060 => {
             name => 'Самегрело и Земо-Сванети', 
             ua_name => 'Самегрело і Земо-Сванетія', 
             tr_name => 'Samegrelo-Zemo Svaneti', 
             ename => 'Samegrelo-Zemo Svaneti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122061 => {
             name => 'Самцхе-Джавахети', 
             ua_name => 'Самцхе-Джавахетія', 
             tr_name => 'Samtshe-Cavaheti', 
             ename => 'Samtskhe-Javakheti',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        122062 => {
             name => 'Квемо-Картли', 
             ua_name => 'Квемо-Картлі', 
             tr_name => 'Kvemo Kartli', 
             ename => 'Kvemo Kartli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [ 10285 ], 
        },
        
        122063 => {
             name => 'Шида-Картли', 
             ua_name => 'Шида-Картлі', 
             tr_name => 'Şida Kartli', 
             ename => 'Shida Kartli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        123 => {
             name => 'Финляндия', 
             ua_name => 'Фінляндія', 
             tr_name => 'Finlandiya', 
             ename => 'Finland',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104357 ], 
        },
        
        124 => {
             name => 'Франция', 
             ua_name => 'Франція', 
             tr_name => 'Fransa', 
             ename => 'France',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        125 => {
             name => 'Чехия', 
             ua_name => 'Чехія', 
             tr_name => 'Çek Cumhuriyeti', 
             ename => 'Czech Republic',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        126 => {
             name => 'Швейцария', 
             ua_name => 'Швейцарія', 
             tr_name => 'İsviçre', 
             ename => 'Switzerland',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        127 => {
             name => 'Швеция', 
             ua_name => 'Швеція', 
             tr_name => 'İsveç', 
             ename => 'Sweden',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        13 => {
             name => 'Тамбов', 
             ua_name => 'Тамбов', 
             tr_name => 'Tambov', 
             ename => 'Tambov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10802 ], 
             childs => [  ], 
        },
        
        131 => {
             name => 'Тель-Авив', 
             ua_name => 'Тель-Авів', 
             tr_name => 'Tel Aviv', 
             ename => 'Tel Aviv',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103905 ], 
             childs => [  ], 
        },
        
        132 => {
             name => 'Хайфа', 
             ua_name => 'Хайфа', 
             tr_name => 'Hayfa', 
             ename => 'Haifa',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103901 ], 
             childs => [  ], 
        },
        
        134 => {
             name => 'Китай', 
             ua_name => 'Китай', 
             tr_name => 'Çin', 
             ename => 'China',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        135 => {
             name => 'Южная Корея', 
             ua_name => 'Південна Корея', 
             tr_name => 'Güney Kore', 
             ename => 'South Korea',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        137 => {
             name => 'Япония', 
             ua_name => 'Японія', 
             tr_name => 'Japonya', 
             ename => 'Japan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        138 => {
             name => 'Австралия и Океания', 
             ua_name => 'Австралія та Океанія', 
             tr_name => 'Avustralya ve Okyanusya', 
             ename => 'Australia and Oceania',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 139, 211 ], 
        },
        
        139 => {
             name => 'Новая Зеландия', 
             ua_name => 'Нова Зеландія', 
             tr_name => 'Yeni Zelanda', 
             ename => 'New Zealand',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 138 ], 
             childs => [  ], 
        },
        
        14 => {
             name => 'Тверь', 
             ua_name => 'Твер', 
             tr_name => 'Tver', 
             ename => 'Tver',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [  ], 
        },
        
        141 => {
             name => 'Днепр', 
             ua_name => 'Дніпро', 
             tr_name => 'Dnepropetrovsk', 
             ename => 'Dnipro',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        142 => {
             name => 'Донецк', 
             ua_name => 'Донецьк', 
             tr_name => 'Donetsk', 
             ename => 'Donetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        143 => {
             name => 'Киев', 
             ua_name => 'Київ', 
             tr_name => 'Kiev', 
             ename => 'Kyiv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20544 ], 
             childs => [  ], 
        },
        
        144 => {
             name => 'Львов', 
             ua_name => 'Львів', 
             tr_name => 'Lviv', 
             ename => 'Lviv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20529 ], 
             childs => [  ], 
        },
        
        145 => {
             name => 'Одесса', 
             ua_name => 'Одеса', 
             tr_name => 'Odesa', 
             ename => 'Odesa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20541 ], 
             childs => [  ], 
        },
        
        146 => {
             name => 'Симферополь', 
             ua_name => 'Сімферополь', 
             tr_name => 'Simferopol (Akmescit)', 
             ename => 'Simferopol',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        147 => {
             name => 'Харьков', 
             ua_name => 'Харків', 
             tr_name => 'Harkiv', 
             ename => 'Kharkiv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20538 ], 
             childs => [  ], 
        },
        
        148 => {
             name => 'Николаев', 
             ua_name => 'Миколаїв', 
             tr_name => 'Nikolaev', 
             ename => 'Mykolaiv',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20543 ], 
             childs => [  ], 
        },
        
        149 => {
             name => 'Беларусь', 
             ua_name => 'Білорусь', 
             tr_name => 'Beyaz Rusya', 
             ename => 'Belarus',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 29629, 29630, 29631, 29632, 29633, 29634 ], 
        },
        
        15 => {
             name => 'Тула', 
             ua_name => 'Тула', 
             tr_name => 'Tula', 
             ename => 'Tula',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [  ], 
        },
        
        153 => {
             name => 'Брест', 
             ua_name => 'Брест', 
             tr_name => 'Brest', 
             ename => 'Brest',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [  ], 
        },
        
        154 => {
             name => 'Витебск', 
             ua_name => 'Вітебськ', 
             tr_name => 'Vitebsk', 
             ename => 'Vitebsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [  ], 
        },
        
        155 => {
             name => 'Гомель', 
             ua_name => 'Гомель', 
             tr_name => 'Gomel', 
             ename => 'Gomel',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [  ], 
        },
        
        157 => {
             name => 'Минск', 
             ua_name => 'Мінськ', 
             tr_name => 'Minsk', 
             ename => 'Minsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [  ], 
        },
        
        158 => {
             name => 'Могилёв', 
             ua_name => 'Могильов', 
             tr_name => 'Moguilev', 
             ename => 'Mogilev',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [  ], 
        },
        
        159 => {
             name => 'Казахстан', 
             ua_name => 'Казахстан', 
             tr_name => 'Kazakistan', 
             ename => 'Kazakhstan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 29403, 29404, 29406, 29407, 29408, 29409, 29410, 29411, 29412, 29413, 29414, 29415, 29416, 29417 ], 
        },
        
        16 => {
             name => 'Ярославль', 
             ua_name => 'Ярославль', 
             tr_name => 'Yaroslavl', 
             ename => 'Yaroslavl',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [  ], 
        },
        
        162 => {
             name => 'Алматы', 
             ua_name => 'Алмати', 
             tr_name => 'Almatı', 
             ename => 'Almaty',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        163 => {
             name => 'Нур-Султан', 
             ua_name => 'Нур-Султан', 
             tr_name => 'Nursultan', 
             ename => 'Nur-Sultan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29403 ], 
             childs => [  ], 
        },
        
        164 => {
             name => 'Караганда', 
             ua_name => 'Караганда', 
             tr_name => 'Karağandı', 
             ename => 'Karaganda',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        165 => {
             name => 'Семей', 
             ua_name => 'Семей', 
             tr_name => 'Semey', 
             ename => 'Semey',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29408 ], 
             childs => [  ], 
        },
        
        166 => {
             name => 'СНГ (исключая Россию)', 
             ua_name => 'СНД (за винятком Росії)', 
             tr_name => 'CIS (Rusya dahil değil)', 
             ename => 'CIS (except Russia)',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 2,             
             parents => [ 0 ], 
             childs => [ 149, 159, 167, 168, 170, 171, 187, 207, 208, 209, 29386, 29387 ], 
        },
        
        167 => {
             name => 'Азербайджан', 
             ua_name => 'Азербайджан', 
             tr_name => 'Azerbaycan', 
             ename => 'Azerbaijan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10253 ], 
        },
        
        168 => {
             name => 'Армения', 
             ua_name => 'Вірменія', 
             tr_name => 'Ermenistan', 
             ename => 'Armenia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10262, 105789, 105790, 105791, 105792, 105793, 105794, 105795, 105796, 105797, 105798 ], 
        },
        
        169 => {
             name => 'Грузия', 
             ua_name => 'Грузія', 
             tr_name => 'Gürcistan', 
             ename => 'Georgia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [ 10277, 122054, 122055, 122056, 122057, 122058, 122059, 122060, 122061, 122062, 122063 ], 
        },
        
        17 => {
             name => 'Северо-Запад', 
             ua_name => 'Північний Захід', 
             tr_name => 'Kuzeybatı Federal Bölgesi', 
             ename => 'Northwestern Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10174, 10176, 10842, 10853, 10857, 10897, 10904, 10926, 10933, 10939 ], 
        },
        
        170 => {
             name => 'Туркменистан', 
             ua_name => 'Туркменія', 
             tr_name => 'Türkmenistan', 
             ename => 'Turkmenistan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        171 => {
             name => 'Узбекистан', 
             ua_name => 'Узбекистан', 
             tr_name => 'Özbekistan', 
             ename => 'Uzbekistan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10335, 105804, 105805, 105806, 105807, 105808, 105809, 105810, 105811, 105812, 105813, 105814, 105815, 105816 ], 
        },
        
        172 => {
             name => 'Уфа', 
             ua_name => 'Уфа', 
             tr_name => 'Ufa', 
             ename => 'Ufa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        179 => {
             name => 'Эстония', 
             ua_name => 'Естонія', 
             tr_name => 'Estonya', 
             ename => 'Estonia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104430, 104431 ], 
        },
        
        18 => {
             name => 'Петрозаводск', 
             ua_name => 'Петрозаводськ', 
             tr_name => 'Petrozavodsk', 
             ename => 'Petrozavodsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [  ], 
        },
        
        180 => {
             name => 'Сербия', 
             ua_name => 'Сербія', 
             tr_name => 'Sırbistan', 
             ename => 'Serbia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104492 ], 
        },
        
        181 => {
             name => 'Израиль', 
             ua_name => 'Ізраїль', 
             tr_name => 'İsrail', 
             ename => 'Israel',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [ 103900, 103901, 103904, 103905 ], 
        },
        
        183 => {
             name => 'Азия', 
             ua_name => 'Азія', 
             tr_name => 'Asya', 
             ename => 'Asia',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 134, 135, 137, 169, 181, 210, 994, 995, 10095, 10540, 20975 ], 
        },
        
        187 => {
             name => 'Украина', 
             ua_name => 'Україна', 
             tr_name => 'Ukrayna', 
             ename => 'Ukraine',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 20529, 20530, 20531, 20532, 20533, 20534, 20535, 20536, 20537, 20538, 20539, 20540, 20541, 20542, 20543, 20544, 20545, 20546, 20547, 20548, 20549, 20550, 20551, 20552 ], 
        },
        
        189657 => {
             name => 'Ахангаранский район', 
             ua_name => 'Ахангаранский район', 
             tr_name => 'Okhangaron District', 
             ename => 'Okhangaron District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [ 101550 ], 
        },
        
        19 => {
             name => 'Сыктывкар', 
             ua_name => 'Сиктивкар', 
             tr_name => 'Syktivkar', 
             ename => 'Syktyvkar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [  ], 
        },
        
        190 => {
             name => 'Павлодар', 
             ua_name => 'Павлодар', 
             tr_name => 'Pavlodar', 
             ename => 'Pavlodar',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29415 ], 
             childs => [  ], 
        },
        
        191 => {
             name => 'Брянск', 
             ua_name => 'Брянськ', 
             tr_name => 'Briansk', 
             ename => 'Bryansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10650 ], 
             childs => [  ], 
        },
        
        192 => {
             name => 'Владимир', 
             ua_name => 'Владимир', 
             tr_name => 'Vladimir', 
             ename => 'Vladimir',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [  ], 
        },
        
        193 => {
             name => 'Воронеж', 
             ua_name => 'Воронеж', 
             tr_name => 'Voronej', 
             ename => 'Voronezh',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10672 ], 
             childs => [  ], 
        },
        
        193330 => {
             name => 'Ходжейлийский район', 
             ua_name => 'Ходжейлийский район', 
             tr_name => 'Xo‘jayli District', 
             ename => 'Xojayli District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 171, 105816 ], 
             childs => [ 193331 ], 
        },
        
        193331 => {
             name => 'Ходжейли', 
             ua_name => 'Ходжейли', 
             tr_name => 'Xojayli', 
             ename => 'Xojayli',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105816, 193330 ], 
             childs => [  ], 
        },
        
        194 => {
             name => 'Саратов', 
             ua_name => 'Саратов', 
             tr_name => 'Saratov', 
             ename => 'Saratov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [  ], 
        },
        
        195 => {
             name => 'Ульяновск', 
             ua_name => 'Ульяновськ', 
             tr_name => 'Ulyanovsk', 
             ename => 'Ulyanovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11153 ], 
             childs => [  ], 
        },
        
        196979 => {
             name => 'Денауский район', 
             ua_name => 'Денауский район', 
             tr_name => 'Denau district', 
             ename => 'Denau district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 171, 105811 ], 
             childs => [ 196980 ], 
        },
        
        196980 => {
             name => 'Денау', 
             ua_name => 'Денау', 
             tr_name => 'Danau', 
             ename => 'Denau',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105811, 196979 ], 
             childs => [  ], 
        },
        
        197 => {
             name => 'Барнаул', 
             ua_name => 'Барнаул', 
             tr_name => 'Barnaul', 
             ename => 'Barnaul',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        198 => {
             name => 'Улан-Удэ', 
             ua_name => 'Улан-Уде', 
             tr_name => 'Ulan-Ude', 
             ename => 'Ulan-Ude',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [  ], 
        },
        
        2 => {
             name => 'Санкт-Петербург', 
             ua_name => 'Санкт-Петербург', 
             tr_name => 'Saint-Petersburg', 
             ename => 'Saint Petersburg',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 20293, 20297 ], 
        },
        
        20 => {
             name => 'Архангельск', 
             ua_name => 'Архангельськ', 
             tr_name => 'Arhangelsk', 
             ename => 'Arhangelsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        20010 => {
             name => 'Рузаевка', 
             ua_name => 'Рузаєвка', 
             tr_name => 'Ruzaevka', 
             ename => 'Ruzaevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11117, 99737 ], 
             childs => [  ], 
        },
        
        20020 => {
             name => 'Вятские Поляны', 
             ua_name => 'Вятські Поляни', 
             tr_name => 'Vyatskie Polyani', 
             ename => 'Vyatskie Polyani',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11070 ], 
             childs => [  ], 
        },
        
        20040 => {
             name => 'Выкса', 
             ua_name => 'Викса', 
             tr_name => 'Vyksa', 
             ename => 'Vyksa',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        20044 => {
             name => 'Кстово', 
             ua_name => 'Кстово', 
             tr_name => 'Kstovo', 
             ename => 'Kstovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11079, 99555 ], 
             childs => [  ], 
        },
        
        20063 => {
             name => 'Маркс', 
             ua_name => 'Маркс', 
             tr_name => 'Marx', 
             ename => 'Marks',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11146, 99832 ], 
             childs => [  ], 
        },
        
        20070 => {
             name => 'Новоульяновск', 
             ua_name => 'Новоульяновськ', 
             tr_name => 'Novoulyanovsk', 
             ename => 'Novoulyanovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11153 ], 
             childs => [  ], 
        },
        
        20078 => {
             name => 'Шумерля', 
             ua_name => 'Шумерля', 
             tr_name => 'Shumerlya', 
             ename => 'Shumerlya',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11156 ], 
             childs => [  ], 
        },
        
        20086 => {
             name => 'Железногорск', 
             ua_name => 'Желєзногорськ', 
             tr_name => 'Zheleznogorsk', 
             ename => 'Zheleznogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        20088 => {
             name => 'Зеленогорск', 
             ua_name => 'Зеленогорськ', 
             tr_name => 'Zelenogorsk', 
             ename => 'Zelenogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        20097 => {
             name => 'Усть-Кут', 
             ua_name => 'Усть-Кут', 
             tr_name => 'Ust-Kut', 
             ename => 'Ust-Kut',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11266, 100116 ], 
             childs => [  ], 
        },
        
        20098 => {
             name => 'Барабинск', 
             ua_name => 'Барабінськ', 
             tr_name => 'Barabinsk', 
             ename => 'Barabinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11316, 100183 ], 
             childs => [  ], 
        },
        
        20100 => {
             name => 'Искитим', 
             ua_name => 'Іскітім', 
             tr_name => 'Iskitim', 
             ename => 'Iskitim',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [  ], 
        },
        
        20101 => {
             name => 'Карасук', 
             ua_name => 'Карасук', 
             tr_name => 'Karasuk', 
             ename => 'Karasuk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 59, 11316, 100189 ], 
             childs => [  ], 
        },
        
        20117 => {
             name => 'Новодвинск', 
             ua_name => 'Новодвінськ', 
             tr_name => 'Novodvinsk', 
             ename => 'Novodvinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10842 ], 
             childs => [  ], 
        },
        
        20139 => {
             name => 'Зеленоградск', 
             ua_name => 'Зеленоградськ', 
             tr_name => 'Zelenogradsk', 
             ename => 'Zelenogradsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        20144 => {
             name => 'Пионерский', 
             ua_name => 'Піонерський', 
             tr_name => 'Pionersky', 
             ename => 'Pionersky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        20155 => {
             name => 'Оленегорск', 
             ua_name => 'Оленьогорськ', 
             tr_name => 'Olenegorsk', 
             ename => 'Olenegorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        20160 => {
             name => 'Невельск', 
             ua_name => 'Невельськ', 
             tr_name => 'Nevelsk', 
             ename => 'Nevelsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11450 ], 
             childs => [  ], 
        },
        
        20167 => {
             name => 'Ахтубинск', 
             ua_name => 'Ахтубінськ', 
             tr_name => 'Ahtubinsk', 
             ename => 'Ahtubinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10946, 99221 ], 
             childs => [  ], 
        },
        
        20181 => {
             name => 'Магас', 
             ua_name => 'Магас', 
             tr_name => 'Magas', 
             ename => 'Magas',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11012 ], 
             childs => [  ], 
        },
        
        20192 => {
             name => 'Алексеевка', 
             ua_name => 'Алексєєвка', 
             tr_name => 'Alekseyevka', 
             ename => 'Alekseevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10645, 98697 ], 
             childs => [  ], 
        },
        
        20196 => {
             name => 'Шебекино', 
             ua_name => 'Шебекіно', 
             tr_name => 'Shebekino', 
             ename => 'Shebekino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10645, 98716 ], 
             childs => [  ], 
        },
        
        20224 => {
             name => 'Ревда', 
             ua_name => 'Ревда', 
             tr_name => 'Revda', 
             ename => 'Revda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20234 => {
             name => 'Качканар', 
             ua_name => 'Качканар', 
             tr_name => 'Kaçkanar', 
             ename => 'Kachkanar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20235 => {
             name => 'Октябрьский', 
             ua_name => 'Октябрський', 
             tr_name => 'Oktiabrski', 
             ename => 'Oktyabrsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        20237 => {
             name => 'Березники', 
             ua_name => 'Березники', 
             tr_name => 'Berezniki', 
             ename => 'Berezniki',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        20243 => {
             name => 'Чайковский', 
             ua_name => 'Чайковський', 
             tr_name => 'Çaykovski', 
             ename => 'Chaikovsky',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11108, 110916 ], 
             childs => [  ], 
        },
        
        20244 => {
             name => 'Лысьва', 
             ua_name => 'Лисьва', 
             tr_name => 'Lysva', 
             ename => 'Lysva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        20259 => {
             name => 'Белорецк', 
             ua_name => 'Бєлорєцьк', 
             tr_name => 'Beloretsk', 
             ename => 'Beloretsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99677 ], 
             childs => [  ], 
        },
        
        20273 => {
             name => 'Актобе', 
             ua_name => 'Актобе', 
             tr_name => 'Aktöbe', 
             ename => 'Aktobe',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29404 ], 
             childs => [  ], 
        },
        
        20293 => {
             name => 'Колпинский район', 
             ua_name => 'Колпінський район', 
             tr_name => 'Kolpinski', 
             ename => 'Kolpinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 8,             
             parents => [ 0, 225, 17, 10174, 2 ], 
             childs => [ 26081 ], 
        },
        
        20297 => {
             name => 'Пушкинский район', 
             ua_name => 'Пушкінський район', 
             tr_name => 'Pushkinski', 
             ename => 'Pushkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 8,             
             parents => [ 0, 225, 17, 10174, 2 ], 
             childs => [ 10884 ], 
        },
        
        203 => {
             name => 'Дания', 
             ua_name => 'Данія', 
             tr_name => 'Danimarka', 
             ename => 'Denmark',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        204 => {
             name => 'Испания', 
             ua_name => 'Іспанія', 
             tr_name => 'İspanya', 
             ename => 'Spain',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        205 => {
             name => 'Италия', 
             ua_name => 'Італія', 
             tr_name => 'İtalya', 
             ename => 'Italy',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        20523 => {
             name => 'Электросталь', 
             ua_name => 'Електросталь', 
             tr_name => 'Elektrostal', 
             ename => 'Elektrostal',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20529 => {
             name => 'Львов и область', 
             ua_name => 'Львів і область', 
             tr_name => 'Lvivska oblastı', 
             ename => 'Lviv District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 144 ], 
        },
        
        20530 => {
             name => 'Ужгород и Закарпатская область', 
             ua_name => 'Ужгород і Закарпатська область', 
             tr_name => 'Zakarpatska oblastı', 
             ename => 'Zakarpattia District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20531 => {
             name => 'Тернополь и область', 
             ua_name => 'Тернопіль і область', 
             tr_name => 'Ternopol Bölgesi', 
             ename => 'Ternopil District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20532 => {
             name => 'Ивано-Франковск и область', 
             ua_name => 'Івано-Франківськ і область', 
             tr_name => 'Ivano-Frankovsk Bölgesi', 
             ename => 'Ivano-Frankovsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20533 => {
             name => 'Черновцы и область', 
             ua_name => 'Чернівці і область', 
             tr_name => 'Çernivtsi', 
             ename => 'Chernovtci District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20534 => {
             name => 'Ровно и область', 
             ua_name => 'Рівне і область', 
             tr_name => 'Rovno Bölgesi', 
             ename => 'Rovno District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20535 => {
             name => 'Хмельницкий и область', 
             ua_name => 'Хмельницький і область', 
             tr_name => 'Kimelnitsky Bölgesi', 
             ename => 'Khmelnitsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 961 ], 
        },
        
        20536 => {
             name => 'Донецк и область', 
             ua_name => 'Донецьк і область', 
             tr_name => 'Donetsk Bölgesi', 
             ename => 'Donetsk Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 142, 10366, 20554, 21774, 24876 ], 
        },
        
        20537 => {
             name => 'Днепр и область', 
             ua_name => 'Дніпро і область', 
             tr_name => 'Dnepropetrovsk Bölgesi', 
             ename => 'Dnipropetrovsk Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 141, 10347, 21773, 21775, 28401 ], 
        },
        
        20538 => {
             name => 'Харьков и область', 
             ua_name => 'Харків і область', 
             tr_name => 'Harkivska oblastı', 
             ename => 'Kharkiv Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 147 ], 
        },
        
        20539 => {
             name => 'Запорожье и область', 
             ua_name => 'Запоріжжя і область', 
             tr_name => 'Zaporoje Bölgesi', 
             ename => 'Zaporizhia Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 960 ], 
        },
        
        20540 => {
             name => 'Луганск и область', 
             ua_name => 'Луганськ і область', 
             tr_name => 'Lugansk Bölgesi', 
             ename => 'Luhansk Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 222, 24885, 24893 ], 
        },
        
        20541 => {
             name => 'Одесса и область', 
             ua_name => 'Одеса і область', 
             tr_name => 'Odessa Bölgesi', 
             ename => 'Odesa District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 145 ], 
        },
        
        20542 => {
             name => 'Херсон и область', 
             ua_name => 'Херсон і область', 
             tr_name => 'Kerson Bölgesi', 
             ename => 'Kherson District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 962 ], 
        },
        
        20543 => {
             name => 'Николаев и область', 
             ua_name => 'Миколаїв і область', 
             tr_name => 'Nikolayev Bölgesi', 
             ename => 'Mykolaiv District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 148 ], 
        },
        
        20544 => {
             name => 'Киев и область', 
             ua_name => 'Київ і область', 
             tr_name => 'Kiev Bölgesi', 
             ename => 'Kyiv Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 143, 10369 ], 
        },
        
        20545 => {
             name => 'Винница и область', 
             ua_name => 'Вінниця і область', 
             tr_name => 'Vinica Bölgesi', 
             ename => 'Vinnytsia Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 963 ], 
        },
        
        20546 => {
             name => 'Черкассы и область', 
             ua_name => 'Черкаси і область', 
             tr_name => 'Çerkassi Bölgesi', 
             ename => 'Cherkassi District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20547 => {
             name => 'Житомир и область', 
             ua_name => 'Житомир і область', 
             tr_name => 'Jytomyr', 
             ename => 'Zhytomyr Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20548 => {
             name => 'Кропивницкий и Кировоградская область', 
             ua_name => 'Кропивницький і Кіровоградська область', 
             tr_name => 'Kirovograd Bölgesi', 
             ename => 'Kirovohrad Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20549 => {
             name => 'Полтава и область', 
             ua_name => 'Полтава і область', 
             tr_name => 'Poltava Bölgesi', 
             ename => 'Poltava Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 964, 21609 ], 
        },
        
        20550 => {
             name => 'Луцк и Волынская область', 
             ua_name => 'Луцьк і Волинська область', 
             tr_name => 'Volyn oblastı', 
             ename => 'Volyn Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [  ], 
        },
        
        20551 => {
             name => 'Чернигов и область', 
             ua_name => 'Чернігів і область', 
             tr_name => 'Çernigov Bölgesi', 
             ename => 'Chernihiv Region',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 29053 ], 
        },
        
        20552 => {
             name => 'Сумы и область', 
             ua_name => 'Суми і область', 
             tr_name => 'Sumi Bölgesi', 
             ename => 'Sumi District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 187 ], 
             childs => [ 965 ], 
        },
        
        20554 => {
             name => 'Краматорск', 
             ua_name => 'Краматорськ', 
             tr_name => 'Kramatorsk', 
             ename => 'Kramatorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        20556 => {
             name => 'Саки', 
             ua_name => 'Саки', 
             tr_name => 'Saki (Sak)', 
             ename => 'Saky',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        20571 => {
             name => 'Жуковский', 
             ua_name => 'Жуковський', 
             tr_name => 'Jukovski', 
             ename => 'Zhukovskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20574 => {
             name => 'Кипр', 
             ua_name => 'Кіпр', 
             tr_name => 'Kıbrıs', 
             ename => 'Cyprus',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        20576 => {
             name => 'Протвино', 
             ua_name => 'Протвіно', 
             tr_name => 'Protvino', 
             ename => 'Protvino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20579 => {
             name => 'Белоярский', 
             ua_name => 'Білоярський', 
             tr_name => 'Beloyarski', 
             ename => 'Beloyarskiy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 7,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20587 => {
             name => 'Строитель', 
             ua_name => 'Будівельник', 
             tr_name => 'Stroitel', 
             ename => 'Stroitel',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10645, 98717 ], 
             childs => [  ], 
        },
        
        206 => {
             name => 'Латвия', 
             ua_name => 'Латвія', 
             tr_name => 'Letonya', 
             ename => 'Latvia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 11474 ], 
        },
        
        20654 => {
             name => 'Невьянск', 
             ua_name => 'Нев\'янськ', 
             tr_name => 'Nevyansk', 
             ename => 'Nevyansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20667 => {
             name => 'Богородицк', 
             ua_name => 'Богородицьк', 
             tr_name => 'Bogoroditsk', 
             ename => 'Bogoroditsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10832, 99044 ], 
             childs => [  ], 
        },
        
        20672 => {
             name => 'Североуральск', 
             ua_name => 'Сєвєроуральськ', 
             tr_name => 'Severouralsk', 
             ename => 'Severouralsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20674 => {
             name => 'Троицк', 
             ua_name => 'Троїцьк', 
             tr_name => 'Troitsk', 
             ename => 'Troitsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 213 ], 
             childs => [  ], 
        },
        
        20680 => {
             name => 'Учалы', 
             ua_name => 'Учали', 
             tr_name => 'Uçaly', 
             ename => 'Uchaly',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99714 ], 
             childs => [  ], 
        },
        
        20684 => {
             name => 'Реж', 
             ua_name => 'Реж', 
             tr_name => 'Rej', 
             ename => 'Rezh',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20691 => {
             name => 'Красноуфимск', 
             ua_name => 'Красноуфімськ', 
             tr_name => 'Krasnoufimsk', 
             ename => 'Krasnoufimsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        207 => {
             name => 'Киргизия', 
             ua_name => 'Киргизія', 
             tr_name => 'Kırgizistan', 
             ename => 'Kyrgyzstan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10309, 10310 ], 
        },
        
        20704 => {
             name => 'Славянск-на-Кубани', 
             ua_name => 'Славянськ-на-Кубані', 
             tr_name => 'Slaviansk-na-Kubani', 
             ename => 'Slavyansk-na-Kubani',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99293 ], 
             childs => [  ], 
        },
        
        20707 => {
             name => 'Курчатов', 
             ua_name => 'Курчатов', 
             tr_name => 'Kurçatov', 
             ename => 'Kurchatov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10705 ], 
             childs => [  ], 
        },
        
        20714 => {
             name => 'Белебей', 
             ua_name => 'Белебей', 
             tr_name => 'Belebey', 
             ename => 'Belebey',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99675 ], 
             childs => [  ], 
        },
        
        20715 => {
             name => 'Мелеуз', 
             ua_name => 'Мелеуз', 
             tr_name => 'Meleuz', 
             ename => 'Meleuz',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99703 ], 
             childs => [  ], 
        },
        
        20716 => {
             name => 'Сибай', 
             ua_name => 'Сібай', 
             tr_name => 'Sibay', 
             ename => 'Sibay',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [  ], 
        },
        
        20717 => {
             name => 'Туймазы', 
             ua_name => 'Туймази', 
             tr_name => 'Tuymazy', 
             ename => 'Tuymazy',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99712 ], 
             childs => [  ], 
        },
        
        20718 => {
             name => 'Ишимбай', 
             ua_name => 'Ішимбай', 
             tr_name => 'İşimbay', 
             ename => 'Ishimbay',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 40, 11111, 99694 ], 
             childs => [  ], 
        },
        
        20720 => {
             name => 'Верхняя Пышма', 
             ua_name => 'Верхня Пишма', 
             tr_name => 'Verhniaya Pyşma', 
             ename => 'Verhnyaya Pyshma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        20721 => {
             name => 'Волжск', 
             ua_name => 'Волзьк', 
             tr_name => 'Volzhsk', 
             ename => 'Volzhsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11077 ], 
             childs => [  ], 
        },
        
        20728 => {
             name => 'Королёв', 
             ua_name => 'Корольов', 
             tr_name => 'Koroliov', 
             ename => 'Korolev',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        20729 => {
             name => 'Бобруйск', 
             ua_name => 'Бобруйськ', 
             tr_name => 'Bobruisk', 
             ename => 'Bobruisk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [  ], 
        },
        
        20733 => {
             name => 'Кот-д’Ивуар', 
             ua_name => 'Кот-д\'Івуар', 
             tr_name => 'Fildişi Sahilleri', 
             ename => 'Côte d\'Ivoire',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 241 ], 
             childs => [ 20734 ], 
        },
        
        20734 => {
             name => 'Абиджан', 
             ua_name => 'Абіджан', 
             tr_name => 'Abican', 
             ename => 'Abidjan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 241, 20733 ], 
             childs => [  ], 
        },
        
        208 => {
             name => 'Молдова', 
             ua_name => 'Молдова', 
             tr_name => 'Moldova', 
             ename => 'Moldova',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [ 10313 ], 
        },
        
        20809 => {
             name => 'Кокшетау', 
             ua_name => 'Кокшетау', 
             tr_name => 'Kökşetav', 
             ename => 'Kokshetau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29403 ], 
             childs => [  ], 
        },
        
        209 => {
             name => 'Таджикистан', 
             ua_name => 'Таджикистан', 
             tr_name => 'Tacikistan', 
             ename => 'Tajikistan',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        20917 => {
             name => 'Доминиканская Республика', 
             ua_name => 'Домініканська Республіка', 
             tr_name => 'Dominik Cumhuriyeti', 
             ename => 'Dominican Republic',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        20968 => {
             name => 'Гватемала', 
             ua_name => 'Гватемала', 
             tr_name => 'Guatemala', 
             ename => 'Guatemala',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        20975 => {
             name => 'Камбоджа', 
             ua_name => 'Камбоджа', 
             tr_name => 'Kamboçya', 
             ename => 'Cambodia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        21 => {
             name => 'Вологда', 
             ua_name => 'Вологда', 
             tr_name => 'Vologda', 
             ename => 'Vologda',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10853 ], 
             childs => [  ], 
        },
        
        210 => {
             name => 'Объединённые Арабские Эмираты', 
             ua_name => 'Об\'єднані Арабські Емірати', 
             tr_name => 'Birleşik Arap Emirlikleri', 
             ename => 'United Arab Emirates',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        21015 => {
             name => 'Барановичи', 
             ua_name => 'Барановичі', 
             tr_name => 'Baranavichy', 
             ename => 'Baranavichy',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [  ], 
        },
        
        21050 => {
             name => 'Кызылорда', 
             ua_name => 'Кизилорда', 
             tr_name => 'Kızılorda', 
             ename => 'Kyzylorda',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29413 ], 
             childs => [  ], 
        },
        
        21094 => {
             name => 'Тараз', 
             ua_name => 'Тараз', 
             tr_name => 'Taraz', 
             ename => 'Taraz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29409 ], 
             childs => [  ], 
        },
        
        211 => {
             name => 'Австралия', 
             ua_name => 'Австралія', 
             tr_name => 'Avustralya', 
             ename => 'Australia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 138 ], 
             childs => [  ], 
        },
        
        21105 => {
             name => 'Ургенч', 
             ua_name => 'Ургенч', 
             tr_name => 'Ürgenç', 
             ename => 'Urgench',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105815 ], 
             childs => [  ], 
        },
        
        21106 => {
             name => 'Туркестан', 
             ua_name => 'Туркестан', 
             tr_name => 'Türkistan', 
             ename => 'Turkestan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        21141 => {
             name => 'Тимашевск', 
             ua_name => 'Тимашевськ', 
             tr_name => 'Timaşovsk', 
             ename => 'Timashovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99297 ], 
             childs => [  ], 
        },
        
        21144 => {
             name => 'Лида', 
             ua_name => 'Ліда', 
             tr_name => 'Lida', 
             ename => 'Lida',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102125 ], 
             childs => [  ], 
        },
        
        21154 => {
             name => 'Тутаев', 
             ua_name => 'Тутаєв', 
             tr_name => 'Tutayev', 
             ename => 'Tutaev',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10841, 99078 ], 
             childs => [  ], 
        },
        
        21161 => {
             name => 'Усть-Баргузин', 
             ua_name => 'Усть-Баргузін', 
             tr_name => 'Ust-Barguzin', 
             ename => 'Ust\'-Barguzin',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 73, 11330, 100244 ], 
             childs => [  ], 
        },
        
        21193 => {
             name => 'Борисов', 
             ua_name => 'Борисов', 
             tr_name => 'Borisov', 
             ename => 'Borisov',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102156 ], 
             childs => [  ], 
        },
        
        21271 => {
             name => 'Миоры', 
             ua_name => 'Міори', 
             tr_name => 'Miory', 
             ename => 'Miory',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102186 ], 
             childs => [  ], 
        },
        
        21274 => {
             name => 'Мозырь', 
             ua_name => 'Мозир', 
             tr_name => 'Mozyr', 
             ename => 'Mozyr',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102108 ], 
             childs => [  ], 
        },
        
        213 => {
             name => 'Москва', 
             ua_name => 'Москва', 
             tr_name => 'Moskova', 
             ename => 'Moscow',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 216, 20674, 21624 ], 
        },
        
        21314 => {
             name => 'Наманган', 
             ua_name => 'Наманган', 
             tr_name => 'Nemengan', 
             ename => 'Namangan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105809 ], 
             childs => [  ], 
        },
        
        214 => {
             name => 'Долгопрудный', 
             ua_name => 'Долгопрудний', 
             tr_name => 'Dolgoprudny', 
             ename => 'Dolgoprudniy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        215 => {
             name => 'Дубна', 
             ua_name => 'Дубна', 
             tr_name => 'Dubna', 
             ename => 'Dubna',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21510 => {
             name => 'Пинск', 
             ua_name => 'Пінськ', 
             tr_name => 'Pinsk', 
             ename => 'Pinsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [  ], 
        },
        
        21521 => {
             name => 'Избербаш', 
             ua_name => 'Ізбербаш', 
             tr_name => 'Izberbash', 
             ename => 'Izberbash',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        216 => {
             name => 'Зеленоград', 
             ua_name => 'Зеленоград', 
             tr_name => 'Zelenograd', 
             ename => 'Zelenograd',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 213 ], 
             childs => [  ], 
        },
        
        21606 => {
             name => 'Джизак', 
             ua_name => 'Джизак', 
             tr_name => 'Cizzak', 
             ename => 'Dzhizak',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105806 ], 
             childs => [  ], 
        },
        
        21609 => {
             name => 'Кременчуг', 
             ua_name => 'Кременчук', 
             tr_name => 'Kremenchuk', 
             ename => 'Kremenchuk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20549 ], 
             childs => [  ], 
        },
        
        21610 => {
             name => 'Черногория', 
             ua_name => 'Чорногорія', 
             tr_name => 'Karadağ', 
             ename => 'Montenegro',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        21619 => {
             name => 'Фрязино', 
             ua_name => 'Фрязіно', 
             tr_name => 'Friazino', 
             ename => 'Fryazino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21621 => {
             name => 'Реутов', 
             ua_name => 'Реутов', 
             tr_name => 'Reutov', 
             ename => 'Reutov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21623 => {
             name => 'Ивантеевка', 
             ua_name => 'Івантєєвка', 
             tr_name => 'İvanteyevka', 
             ename => 'Ivanteevka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        21624 => {
             name => 'Щербинка', 
             ua_name => 'Щербинка', 
             tr_name => 'Şçerbinka', 
             ename => 'Zcherbinka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 213 ], 
             childs => [  ], 
        },
        
        21625 => {
             name => 'Кубинка', 
             ua_name => 'Кубінка', 
             tr_name => 'Kubinka', 
             ename => 'Kubinka',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98599 ], 
             childs => [  ], 
        },
        
        21627 => {
             name => 'Дедовск', 
             ua_name => 'Дєдовськ', 
             tr_name => 'Dedovsk', 
             ename => 'Dedovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98586 ], 
             childs => [  ], 
        },
        
        21630 => {
             name => 'Лыткарино', 
             ua_name => 'Литкаріно', 
             tr_name => 'Lytkarino', 
             ename => 'Lytkarino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21632 => {
             name => 'Белоозерский', 
             ua_name => 'Білоозерський', 
             tr_name => 'Belooziorski', 
             ename => 'Beloozerskij',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 3, 1, 98581 ], 
             childs => [  ], 
        },
        
        21635 => {
             name => 'Лосино-Петровский', 
             ua_name => 'Лосіно-Петровський', 
             tr_name => 'Losino-Petrovski', 
             ename => 'Losino-Petrovsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21641 => {
             name => 'Лобня', 
             ua_name => 'Лобня', 
             tr_name => 'Lobnia', 
             ename => 'Lobnja',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21642 => {
             name => 'Электроугли', 
             ua_name => 'Електроуглі', 
             tr_name => 'Elektrougli', 
             ename => 'Elektrougli',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98598 ], 
             childs => [  ], 
        },
        
        21645 => {
             name => 'Хотьково', 
             ua_name => 'Хотьково', 
             tr_name => 'Hotkovo', 
             ename => 'Hot\'kovo',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98608 ], 
             childs => [  ], 
        },
        
        21646 => {
             name => 'Голицыно', 
             ua_name => 'Голіцино', 
             tr_name => 'Golitsino', 
             ename => 'Golicyno',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98599 ], 
             childs => [  ], 
        },
        
        21647 => {
             name => 'Краснознаменск', 
             ua_name => 'Краснознаменськ', 
             tr_name => 'Krasnoznamensk', 
             ename => 'Krasnoznamensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21656 => {
             name => 'Старая Купавна', 
             ua_name => 'Стара Купавна', 
             tr_name => 'Staraya Kupavna', 
             ename => 'Staraja Kupavna',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98598 ], 
             childs => [  ], 
        },
        
        21675 => {
             name => 'Каргасок', 
             ua_name => 'Каргасок', 
             tr_name => 'Kargasok', 
             ename => 'Kargasok',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 59, 11353, 100278 ], 
             childs => [  ], 
        },
        
        217 => {
             name => 'Пущино', 
             ua_name => 'Пущино', 
             tr_name => 'Puşçino', 
             ename => 'Pushino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21726 => {
             name => 'Полевской', 
             ua_name => 'Полевський', 
             tr_name => 'Polevskoy', 
             ename => 'Polevskoj',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        21735 => {
             name => 'Дзержинский', 
             ua_name => 'Дзержинський', 
             tr_name => 'Dzerjinski', 
             ename => 'Dzerzhinsky',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21745 => {
             name => 'Нахабино', 
             ua_name => 'Нахабіно', 
             tr_name => 'Nahabino', 
             ename => 'Nakhabino',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 3, 1, 98590 ], 
             childs => [  ], 
        },
        
        21773 => {
             name => 'Никополь', 
             ua_name => 'Нікополь', 
             tr_name => 'Nikopol', 
             ename => 'Nikopol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        21774 => {
             name => 'Горловка', 
             ua_name => 'Горлівка', 
             tr_name => 'Horlovka', 
             ename => 'Horlivka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        21775 => {
             name => 'Каменское', 
             ua_name => 'Кам\'янське', 
             tr_name => 'Dniprodzerzhynsk', 
             ename => 'Kamianske',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        219 => {
             name => 'Черноголовка', 
             ua_name => 'Черноголовка', 
             tr_name => 'Çernogolovka', 
             ename => 'Chernogolovka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [  ], 
        },
        
        21947 => {
             name => 'Навои', 
             ua_name => 'Навої', 
             tr_name => 'Nevai', 
             ename => 'Navoi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105808 ], 
             childs => [  ], 
        },
        
        21949 => {
             name => 'Забайкальский край', 
             ua_name => 'Забайкальський край', 
             tr_name => 'Zabaykalski krayı', 
             ename => 'Zabaykalsky Krai',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 68 ], 
        },
        
        22 => {
             name => 'Калининград', 
             ua_name => 'Калінінград', 
             tr_name => 'Kaliningrad', 
             ename => 'Kaliningrad',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10857 ], 
             childs => [  ], 
        },
        
        221 => {
             name => 'Шымкент', 
             ua_name => 'Шимкент', 
             tr_name => 'Çimkent (Şımkent)', 
             ename => 'Chimkent',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29417 ], 
             childs => [  ], 
        },
        
        222 => {
             name => 'Луганск', 
             ua_name => 'Луганськ', 
             tr_name => 'Lugansk', 
             ename => 'Luhansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20540 ], 
             childs => [  ], 
        },
        
        225 => {
             name => 'Россия', 
             ua_name => 'Росія', 
             tr_name => 'Rusya', 
             ename => 'Russia',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 3,             
             parents => [ 0 ], 
             childs => [ 3, 17, 26, 40, 52, 59, 73, 102444, 977 ], 
        },
        
        22829 => {
             name => 'Вознесенье', 
             ua_name => 'Вознесіння', 
             tr_name => 'Voznyesyenje', 
             ename => 'Voznyesyenje',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 7,             
             parents => [ 0, 225, 17, 10174, 98630 ], 
             childs => [  ], 
        },
        
        23 => {
             name => 'Мурманск', 
             ua_name => 'Мурманськ', 
             tr_name => 'Murmansk', 
             ename => 'Murmansk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [  ], 
        },
        
        235 => {
             name => 'Магнитогорск', 
             ua_name => 'Магнітогорськ', 
             tr_name => 'Magnitogorsk', 
             ename => 'Magnitogorsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        236 => {
             name => 'Набережные Челны', 
             ua_name => 'Набережні Челни', 
             tr_name => 'Naberejniye Çelny (Yar Çallı)', 
             ename => 'Naberezhnie Chelny',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        237 => {
             name => 'Новокузнецк', 
             ua_name => 'Новокузнецьк', 
             tr_name => 'Novokuznetsk', 
             ename => 'Novokuznetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        238 => {
             name => 'Новочеркасск', 
             ua_name => 'Новочеркаськ', 
             tr_name => 'Novoçerkassk', 
             ename => 'Novocherkassk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        239 => {
             name => 'Сочи', 
             ua_name => 'Сочі', 
             tr_name => 'Soçi', 
             ename => 'Sochi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        24 => {
             name => 'Великий Новгород', 
             ua_name => 'Великий Новгород', 
             tr_name => 'Velikiy Novgorod', 
             ename => 'Veliky Novgorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [  ], 
        },
        
        240 => {
             name => 'Тольятти', 
             ua_name => 'Тольятті', 
             tr_name => 'Tolyatti (Togliatti)', 
             ename => 'Togliatti',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        241 => {
             name => 'Африка', 
             ua_name => 'Африка', 
             tr_name => 'Afrika', 
             ename => 'Africa',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 1056, 20733 ], 
        },
        
        246 => {
             name => 'Греция', 
             ua_name => 'Греція', 
             tr_name => 'Yunanistan', 
             ename => 'Greece',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        24696 => {
             name => 'Бахчисарайский район', 
             ua_name => 'Бахчисарайський район', 
             tr_name => 'Bahçisarayski ilçesi', 
             ename => 'Bakhchisaray District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 10,             
             parents => [ 0, 225, 977 ], 
             childs => [ 27217 ], 
        },
        
        24702 => {
             name => 'Ленинский район', 
             ua_name => 'Ленінський район', 
             tr_name => 'Leninski ilçesi', 
             ename => 'Leninsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 10,             
             parents => [ 0, 225, 977 ], 
             childs => [ 28786 ], 
        },
        
        24876 => {
             name => 'Макеевка', 
             ua_name => 'Макіївка', 
             tr_name => 'Makeevka', 
             ename => 'Makiivka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        24885 => {
             name => 'Алчевск', 
             ua_name => 'Алчевськ', 
             tr_name => 'Alchevsk', 
             ename => 'Alchevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20540 ], 
             childs => [  ], 
        },
        
        24893 => {
             name => 'Северодонецк', 
             ua_name => 'Сєверодонецьк', 
             tr_name => 'Severodonetsk', 
             ename => 'Sievierodonetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20540 ], 
             childs => [  ], 
        },
        
        25 => {
             name => 'Псков', 
             ua_name => 'Псков', 
             tr_name => 'Pskov', 
             ename => 'Pskov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10926 ], 
             childs => [  ], 
        },
        
        26 => {
             name => 'Юг', 
             ua_name => 'Південь', 
             tr_name => 'Güney Federal Bölgesi', 
             ename => 'Southern Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10946, 10950, 10995, 11004, 11015, 11029 ], 
        },
        
        26001 => {
             name => 'Молодечно', 
             ua_name => 'Молодечно', 
             tr_name => 'Molodchenko', 
             ename => 'Molodcheno',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102165 ], 
             childs => [  ], 
        },
        
        26003 => {
             name => 'Солигорск', 
             ua_name => 'Солігорськ', 
             tr_name => 'Salihorsk', 
             ename => 'Salihorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102170 ], 
             childs => [  ], 
        },
        
        26004 => {
             name => 'Светлогорск', 
             ua_name => 'Свєтлогорськ', 
             tr_name => 'Svetlahorsk', 
             ename => 'Svetlogorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102114 ], 
             childs => [  ], 
        },
        
        26005 => {
             name => 'Слоним', 
             ua_name => 'Слонім', 
             tr_name => 'Slonim', 
             ename => 'Slonim',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102131 ], 
             childs => [  ], 
        },
        
        26006 => {
             name => 'Климовичи', 
             ua_name => 'Климовичі', 
             tr_name => 'Klimavichy', 
             ename => 'Klimavichy',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102141 ], 
             childs => [  ], 
        },
        
        26007 => {
             name => 'Мосты', 
             ua_name => 'Мости', 
             tr_name => 'Mosti', 
             ename => 'Mosti',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102126 ], 
             childs => [  ], 
        },
        
        26008 => {
             name => 'Речица', 
             ua_name => 'Речиця', 
             tr_name => 'Rechitsa', 
             ename => 'Rechitsa',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102112 ], 
             childs => [  ], 
        },
        
        26010 => {
             name => 'Кобрин', 
             ua_name => 'Кобрин', 
             tr_name => 'Kobrin', 
             ename => 'Kobrin',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29632, 102089 ], 
             childs => [  ], 
        },
        
        26012 => {
             name => 'Осиповичи', 
             ua_name => 'Осиповичі', 
             tr_name => 'Asipovichy', 
             ename => 'Asipovichy',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102149 ], 
             childs => [  ], 
        },
        
        26015 => {
             name => 'Кричев', 
             ua_name => 'Кричев', 
             tr_name => 'Krichev', 
             ename => 'Krichev',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102144 ], 
             childs => [  ], 
        },
        
        26016 => {
             name => 'Шклов', 
             ua_name => 'Шклов', 
             tr_name => 'Shklov', 
             ename => 'Shklov',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102154 ], 
             childs => [  ], 
        },
        
        26017 => {
             name => 'Сморгонь', 
             ua_name => 'Сморгонь', 
             tr_name => 'Smarhon', 
             ename => 'Smarhon',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102132 ], 
             childs => [  ], 
        },
        
        26018 => {
             name => 'Дзержинск (Минская область)', 
             ua_name => 'Дзержинск (Минская область)', 
             tr_name => 'Dzerzhinsk', 
             ename => 'Dzerzhinsk (Minsk District)',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102159 ], 
             childs => [  ], 
        },
        
        26021 => {
             name => 'Быхов', 
             ua_name => 'Бихов', 
             tr_name => 'Bikhov', 
             ename => 'Bikhov',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102136 ], 
             childs => [  ], 
        },
        
        26022 => {
             name => 'Крупки', 
             ua_name => 'Крупки', 
             tr_name => 'Krupki', 
             ename => 'Krupki',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102162 ], 
             childs => [  ], 
        },
        
        26025 => {
             name => 'Глубокое', 
             ua_name => 'Глибоке', 
             tr_name => 'Glubokoye', 
             ename => 'Glubokoye',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102180 ], 
             childs => [  ], 
        },
        
        26026 => {
             name => 'Поставы', 
             ua_name => 'Постави', 
             tr_name => 'Pastavy', 
             ename => 'Pastavy',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102189 ], 
             childs => [  ], 
        },
        
        26027 => {
             name => 'Рогачёв', 
             ua_name => 'Рогачов', 
             tr_name => 'Rogachev', 
             ename => 'Rogachev',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102113 ], 
             childs => [  ], 
        },
        
        26030 => {
             name => 'Новополоцк', 
             ua_name => 'Новополоцьк', 
             tr_name => 'Navapolatsk', 
             ename => 'Navapolatsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [  ], 
        },
        
        26034 => {
             name => 'Жодино', 
             ua_name => 'Жодино', 
             tr_name => 'Zhodzina', 
             ename => 'Zhodzina',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [  ], 
        },
        
        26081 => {
             name => 'Колпино', 
             ua_name => 'Колпіно', 
             tr_name => 'Kolpino', 
             ename => 'Kolpino',             
             media => 0, 
             geo_flag => 1, 
             level => 6, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 2, 20293 ], 
             childs => [  ], 
        },
        
        26554 => {
             name => 'Верхнедвинск', 
             ua_name => 'Верхньодвінськ', 
             tr_name => 'Verkhnedvinsk', 
             ename => 'Verkhnedvinsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102178 ], 
             childs => [  ], 
        },
        
        26745 => {
             name => 'Вилейка', 
             ua_name => 'Вілейка', 
             tr_name => 'Vileyka', 
             ename => 'Vileyka',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102157 ], 
             childs => [  ], 
        },
        
        26774 => {
             name => 'Горки', 
             ua_name => 'Горки', 
             tr_name => 'Gorki', 
             ename => 'Gorki',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29629, 102138 ], 
             childs => [  ], 
        },
        
        26836 => {
             name => 'Новогрудок', 
             ua_name => 'Новогрудок', 
             tr_name => 'Novogrudok', 
             ename => 'Novogrudok',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102127 ], 
             childs => [  ], 
        },
        
        26923 => {
             name => 'Волковыск', 
             ua_name => 'Волковиськ', 
             tr_name => 'Vawkavysk', 
             ename => 'Vawkavysk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29634, 102118 ], 
             childs => [  ], 
        },
        
        26951 => {
             name => 'Слуцк', 
             ua_name => 'Слуцьк', 
             tr_name => 'Slutsk', 
             ename => 'Slutsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29630, 102169 ], 
             childs => [  ], 
        },
        
        26966 => {
             name => 'Жлобин', 
             ua_name => 'Жлобін', 
             tr_name => 'Zhlobin', 
             ename => 'Zhlobin',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102103 ], 
             childs => [  ], 
        },
        
        27217 => {
             name => 'Бахчисарай', 
             ua_name => 'Бахчисарай', 
             tr_name => 'Bahçesaray', 
             ename => 'Bahchisaraj',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 977, 24696 ], 
             childs => [  ], 
        },
        
        27555 => {
             name => 'Джанкой', 
             ua_name => 'Джанкой', 
             tr_name => 'Canköy', 
             ename => 'Jankoy',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        27693 => {
             name => 'Красноперекопск', 
             ua_name => 'Красноперекопськ', 
             tr_name => 'Krasnoperekopsk', 
             ename => 'Krasnoperekopsk',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        28 => {
             name => 'Махачкала', 
             ua_name => 'Махачкала', 
             tr_name => 'Makhachkala', 
             ename => 'Makhachkala',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11010 ], 
             childs => [  ], 
        },
        
        28401 => {
             name => 'Павлоград', 
             ua_name => 'Павлоград', 
             tr_name => 'Pavlograd', 
             ename => 'Pavlohrad',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        28786 => {
             name => 'Щёлкино', 
             ua_name => 'Щолкіне', 
             tr_name => 'Şçolkino', 
             ename => 'Shchelkino',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 977, 24702 ], 
             childs => [  ], 
        },
        
        28892 => {
             name => 'Армянск', 
             ua_name => 'Армянськ', 
             tr_name => 'Armiansk (Ermenibazar)', 
             ename => 'Armyansk',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        29053 => {
             name => 'Нежин', 
             ua_name => 'Ніжин', 
             tr_name => 'Nezhin', 
             ename => 'Nizhyn',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20551 ], 
             childs => [  ], 
        },
        
        29386 => {
             name => 'Абхазия', 
             ua_name => 'Абхазія', 
             tr_name => 'Abhazya', 
             ename => 'Abkhazia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        29387 => {
             name => 'Южная Осетия', 
             ua_name => 'Південна Осетія', 
             tr_name => 'Güney Osetya', 
             ename => 'South Ossetia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 166 ], 
             childs => [  ], 
        },
        
        29397 => {
             name => 'Берёзовский (Свердловская область)', 
             ua_name => 'Берёзовский (Свердловская область)', 
             tr_name => 'Beriozovski (Sverdlovskaya oblastı)', 
             ename => 'Berezovskiy (Sverdlovsk District)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        29403 => {
             name => 'Нур-Султан и Акмолинская область', 
             ua_name => 'Нур-Султан і Акмолінська область', 
             tr_name => 'Akmola eyaleti', 
             ename => 'Akmolinsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 163, 20809 ], 
        },
        
        29404 => {
             name => 'Актобе и область', 
             ua_name => 'Актобе і область', 
             tr_name => 'Aktöbe eyaleti', 
             ename => 'Aktubinsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 20273 ], 
        },
        
        29406 => {
             name => 'Алматы и область', 
             ua_name => 'Алмати і область', 
             tr_name => 'Almatı eyaleti', 
             ename => 'Alma-Ata District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 162, 10303, 116777, 116778, 116779, 116780, 116781, 116782 ], 
        },
        
        29407 => {
             name => 'Атырау и область', 
             ua_name => 'Атирау і область', 
             tr_name => 'Atırav eyaleti', 
             ename => 'Atyrau District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10291 ], 
        },
        
        29408 => {
             name => 'Восточно-Казахстанская область', 
             ua_name => 'Східно-Казахстанська область', 
             tr_name => 'Doğu Kazakistan eyaleti', 
             ename => 'East-Kazakhstan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 165, 10306 ], 
        },
        
        29409 => {
             name => 'Тараз и Жамбылская область', 
             ua_name => 'Тараз і Жамбилська область', 
             tr_name => 'Jambıl eyaleti', 
             ename => 'Zhambylsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 21094, 116960 ], 
        },
        
        29410 => {
             name => 'Западно-Казахстанская область', 
             ua_name => 'Західно-Казахстанська область', 
             tr_name => 'Batı Kazakistan eyaleti', 
             ename => 'West-Kazakhstan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10305 ], 
        },
        
        29411 => {
             name => 'Караганда и область', 
             ua_name => 'Караганда і область', 
             tr_name => 'Karağandı eyaleti', 
             ename => 'Karaganda District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 164, 10308, 35393 ], 
        },
        
        29412 => {
             name => 'Костанай и область', 
             ua_name => 'Костанай і область', 
             tr_name => 'Kostanay eyaleti', 
             ename => 'Kostanai District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10295, 10300 ], 
        },
        
        29413 => {
             name => 'Кызылорда и область', 
             ua_name => 'Кизилорда і область', 
             tr_name => 'Kızılorda eyaleti', 
             ename => 'Kyzylorda District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 21050 ], 
        },
        
        29414 => {
             name => 'Актау и Мангистауская область', 
             ua_name => 'Актау і Мангістауська область', 
             tr_name => 'Mangıstav eyaleti', 
             ename => 'Mangystau District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 29575, 29577, 116954 ], 
        },
        
        29415 => {
             name => 'Павлодар и область', 
             ua_name => 'Павлодар і область', 
             tr_name => 'Pavlodar eyaleti', 
             ename => 'Pavlodar District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 190, 29590 ], 
        },
        
        29416 => {
             name => 'Северо-Казахстанская область', 
             ua_name => 'Північно-Казахстанська область', 
             tr_name => 'Kuzey Kazakistan eyaleti', 
             ename => 'North-Kazakhstan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 10298 ], 
        },
        
        29417 => {
             name => 'Туркестан и область', 
             ua_name => 'Туркестан і область', 
             tr_name => 'Türkistan eyaleti', 
             ename => 'Turkestan District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 159 ], 
             childs => [ 221, 21106, 116939, 116940, 116941, 116943, 116944, 116946, 116947, 116948 ], 
        },
        
        29575 => {
             name => 'Актау', 
             ua_name => 'Актау', 
             tr_name => 'Aktav', 
             ename => 'Aktau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29414 ], 
             childs => [  ], 
        },
        
        29577 => {
             name => 'Жанаозен', 
             ua_name => 'Жанаозен', 
             tr_name => 'Janaözen', 
             ename => 'Zhanaozen',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29414 ], 
             childs => [  ], 
        },
        
        29590 => {
             name => 'Экибастуз', 
             ua_name => 'Екибастуз', 
             tr_name => 'Yekibastuz (Ekibastuz)', 
             ename => 'Ekibastuz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29415 ], 
             childs => [  ], 
        },
        
        29629 => {
             name => 'Могилёв и область', 
             ua_name => 'Могильов і область', 
             tr_name => 'Mogiliovskaya oblastı', 
             ename => 'Mogilev District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 158, 20729, 102136, 102138, 102141, 102144, 102149, 102154 ], 
        },
        
        29630 => {
             name => 'Минск и область', 
             ua_name => 'Мінськ і область', 
             tr_name => 'Minskaya oblastı', 
             ename => 'Minsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 157, 26034, 102156, 102157, 102159, 102162, 102165, 102169, 102170 ], 
        },
        
        29631 => {
             name => 'Гомель и область', 
             ua_name => 'Гомель і область', 
             tr_name => 'Gomelskaya oblastı', 
             ename => 'Gomel District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 155, 102103, 102104, 102108, 102112, 102113, 102114 ], 
        },
        
        29632 => {
             name => 'Брест и область', 
             ua_name => 'Брест і область', 
             tr_name => 'Brestskaya oblastı', 
             ename => 'Brest District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 153, 21015, 21510, 102089 ], 
        },
        
        29633 => {
             name => 'Витебск и область', 
             ua_name => 'Вітебськ і область', 
             tr_name => 'Vitebskaya oblastı', 
             ename => 'Vitebsk District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 154, 26030, 102178, 102180, 102186, 102187, 102188, 102189 ], 
        },
        
        29634 => {
             name => 'Гродно и область', 
             ua_name => 'Гродно і область', 
             tr_name => 'Grodnenskaya oblastı', 
             ename => 'Grodno District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 149 ], 
             childs => [ 10274, 102118, 102125, 102126, 102127, 102131, 102132 ], 
        },
        
        3 => {
             name => 'Центр', 
             ua_name => 'Центр', 
             tr_name => 'Merkezi Federal Bölge', 
             ename => 'Central Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 1, 10645, 10650, 10658, 10672, 10687, 10693, 10699, 10705, 10712, 10772, 10776, 10795, 10802, 10819, 10832, 10841 ], 
        },
        
        30 => {
             name => 'Нальчик', 
             ua_name => 'Нальчик', 
             tr_name => 'Nalchik', 
             ename => 'Nalchik',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11013 ], 
             childs => [  ], 
        },
        
        33 => {
             name => 'Владикавказ', 
             ua_name => 'Владикавказ', 
             tr_name => 'Vladikavkaz', 
             ename => 'Vladikavkaz',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11021 ], 
             childs => [  ], 
        },
        
        35 => {
             name => 'Краснодар', 
             ua_name => 'Краснодар', 
             tr_name => 'Krasnodar', 
             ename => 'Krasnodar',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        35393 => {
             name => 'Темиртау', 
             ua_name => 'Теміртау', 
             tr_name => 'Temirtav', 
             ename => 'Temirtau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        36 => {
             name => 'Ставрополь', 
             ua_name => 'Ставрополь', 
             tr_name => 'Stavropol', 
             ename => 'Stavropol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [  ], 
        },
        
        37 => {
             name => 'Астрахань', 
             ua_name => 'Астрахань', 
             tr_name => 'Astrahan', 
             ename => 'Astrahan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10946 ], 
             childs => [  ], 
        },
        
        37129 => {
             name => 'Покров', 
             ua_name => 'Покров', 
             tr_name => 'Pokrov', 
             ename => 'Pokrov',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 10658, 98755 ], 
             childs => [  ], 
        },
        
        37133 => {
             name => 'Новочебоксарск', 
             ua_name => 'Новочебоксарськ', 
             tr_name => 'Novocheboksarsk', 
             ename => 'Novocheboksarsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11156 ], 
             childs => [  ], 
        },
        
        38 => {
             name => 'Волгоград', 
             ua_name => 'Волгоград', 
             tr_name => 'Volgograd', 
             ename => 'Volgograd',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10950 ], 
             childs => [  ], 
        },
        
        39 => {
             name => 'Ростов-на-Дону', 
             ua_name => 'Ростов-на-Дону', 
             tr_name => 'Rostov-na-Donu', 
             ename => 'Rostov-na-Donu',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        4 => {
             name => 'Белгород', 
             ua_name => 'Бєлгород', 
             tr_name => 'Belgorod', 
             ename => 'Belgorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [  ], 
        },
        
        40 => {
             name => 'Поволжье', 
             ua_name => 'Поволжя', 
             tr_name => 'Volga Federal Bölgesi', 
             ename => 'Volga Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11070, 11077, 11079, 11084, 11095, 11108, 11111, 11117, 11119, 11131, 11146, 11148, 11153, 11156 ], 
        },
        
        41 => {
             name => 'Йошкар-Ола', 
             ua_name => 'Йошкар-Ола', 
             tr_name => 'Yoshkar-Ola', 
             ename => 'Yoshkar-Ola',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11077 ], 
             childs => [  ], 
        },
        
        42 => {
             name => 'Саранск', 
             ua_name => 'Саранськ', 
             tr_name => 'Saransk', 
             ename => 'Saransk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11117 ], 
             childs => [  ], 
        },
        
        43 => {
             name => 'Казань', 
             ua_name => 'Казань', 
             tr_name => 'Kazan', 
             ename => 'Kazan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11119 ], 
             childs => [  ], 
        },
        
        44 => {
             name => 'Ижевск', 
             ua_name => 'Іжевськ', 
             tr_name => 'Izhevsk', 
             ename => 'Izhevsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11148 ], 
             childs => [  ], 
        },
        
        45 => {
             name => 'Чебоксары', 
             ua_name => 'Чебоксари', 
             tr_name => 'Cheboksary', 
             ename => 'Cheboksary',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11156 ], 
             childs => [  ], 
        },
        
        46 => {
             name => 'Киров', 
             ua_name => 'Кіров', 
             tr_name => 'Kirov', 
             ename => 'Kirov',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11070 ], 
             childs => [  ], 
        },
        
        47 => {
             name => 'Нижний Новгород', 
             ua_name => 'Нижній Новгород', 
             tr_name => 'Nijni Novgorod', 
             ename => 'Nizhny Novgorod',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        48 => {
             name => 'Оренбург', 
             ua_name => 'Оренбург', 
             tr_name => 'Orenburg', 
             ename => 'Orenburg',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11084 ], 
             childs => [  ], 
        },
        
        49 => {
             name => 'Пенза', 
             ua_name => 'Пенза', 
             tr_name => 'Penza', 
             ename => 'Penza',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11095 ], 
             childs => [  ], 
        },
        
        5 => {
             name => 'Иваново', 
             ua_name => 'Іваново', 
             tr_name => 'İvanovo', 
             ename => 'Ivanovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10687 ], 
             childs => [  ], 
        },
        
        50 => {
             name => 'Пермь', 
             ua_name => 'Перм', 
             tr_name => 'Perm', 
             ename => 'Perm',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11108 ], 
             childs => [  ], 
        },
        
        51 => {
             name => 'Самара', 
             ua_name => 'Самара', 
             tr_name => 'Samara', 
             ename => 'Samara',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11131 ], 
             childs => [  ], 
        },
        
        52 => {
             name => 'Урал', 
             ua_name => 'Урал', 
             tr_name => 'Ural Federal Bölgesi', 
             ename => 'Ural Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11158, 11162, 11176, 11193, 11225, 11232 ], 
        },
        
        53 => {
             name => 'Курган', 
             ua_name => 'Курган', 
             tr_name => 'Kurgan', 
             ename => 'Kurgan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11158 ], 
             childs => [  ], 
        },
        
        54 => {
             name => 'Екатеринбург', 
             ua_name => 'Єкатеринбург', 
             tr_name => 'Yekaterinburg', 
             ename => 'Yekaterinburg',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11162 ], 
             childs => [  ], 
        },
        
        55 => {
             name => 'Тюмень', 
             ua_name => 'Тюмень', 
             tr_name => 'Tiumen', 
             ename => 'Tyumen',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11176 ], 
             childs => [  ], 
        },
        
        56 => {
             name => 'Челябинск', 
             ua_name => 'Челябінськ', 
             tr_name => 'Çeliabinsk', 
             ename => 'Chelyabinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [  ], 
        },
        
        57 => {
             name => 'Ханты-Мансийск', 
             ua_name => 'Ханти-Мансійськ', 
             tr_name => 'Hantı-Mansi', 
             ename => 'Khanty-Mansiysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        58 => {
             name => 'Салехард', 
             ua_name => 'Салехард', 
             tr_name => 'Salehard', 
             ename => 'Salekhard',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [  ], 
        },
        
        59 => {
             name => 'Сибирь', 
             ua_name => 'Сибір', 
             tr_name => 'Sibirya Federal Bölgesi', 
             ename => 'Siberian Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10231, 10233, 11235, 11266, 11282, 11309, 11316, 11318, 11340, 11353 ], 
        },
        
        6 => {
             name => 'Калуга', 
             ua_name => 'Калуга', 
             tr_name => 'Kaluga', 
             ename => 'Kaluga',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10693 ], 
             childs => [  ], 
        },
        
        62 => {
             name => 'Красноярск', 
             ua_name => 'Красноярськ', 
             tr_name => 'Krasnoyarsk', 
             ename => 'Krasnoyarsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11309 ], 
             childs => [  ], 
        },
        
        63 => {
             name => 'Иркутск', 
             ua_name => 'Іркутськ', 
             tr_name => 'Irkutsk', 
             ename => 'Irkutsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        64 => {
             name => 'Кемерово', 
             ua_name => 'Кемерово', 
             tr_name => 'Kemerovo', 
             ename => 'Kemerovo',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11282 ], 
             childs => [  ], 
        },
        
        65 => {
             name => 'Новосибирск', 
             ua_name => 'Новосибірськ', 
             tr_name => 'Novosibirsk', 
             ename => 'Novosibirsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [  ], 
        },
        
        66 => {
             name => 'Омск', 
             ua_name => 'Омськ', 
             tr_name => 'Omsk', 
             ename => 'Omsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11318 ], 
             childs => [  ], 
        },
        
        67 => {
             name => 'Томск', 
             ua_name => 'Томськ', 
             tr_name => 'Tomsk', 
             ename => 'Tomsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [  ], 
        },
        
        68 => {
             name => 'Чита', 
             ua_name => 'Чита', 
             tr_name => 'Çita', 
             ename => 'Chita',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 21949 ], 
             childs => [  ], 
        },
        
        7 => {
             name => 'Кострома', 
             ua_name => 'Кострома', 
             tr_name => 'Kostroma', 
             ename => 'Kostroma',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10699 ], 
             childs => [  ], 
        },
        
        73 => {
             name => 'Дальний Восток', 
             ua_name => 'Далекий Схід', 
             tr_name => 'Uzak Doğu Federal Bölgesi', 
             ename => 'Far Eastern Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 10243, 10251, 11330, 11375, 11398, 11403, 11409, 11443, 11450, 11457, 21949 ], 
        },
        
        74 => {
             name => 'Якутск', 
             ua_name => 'Якутськ', 
             tr_name => 'Yakutsk', 
             ename => 'Yakutsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11443 ], 
             childs => [  ], 
        },
        
        75 => {
             name => 'Владивосток', 
             ua_name => 'Владивосток', 
             tr_name => 'Vladivostok', 
             ename => 'Vladivostok',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        76 => {
             name => 'Хабаровск', 
             ua_name => 'Хабаровськ', 
             tr_name => 'Habarovsk', 
             ename => 'Khabarovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [  ], 
        },
        
        77 => {
             name => 'Благовещенск', 
             ua_name => 'Благовєщенськ', 
             tr_name => 'Blagoveshchensk', 
             ename => 'Blagoveshchensk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11375 ], 
             childs => [  ], 
        },
        
        78 => {
             name => 'Петропавловск-Камчатский', 
             ua_name => 'Петропавловськ-Камчатський', 
             tr_name => 'Petropavlovsk', 
             ename => 'Petropavlovsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11398 ], 
             childs => [  ], 
        },
        
        79 => {
             name => 'Магадан', 
             ua_name => 'Магадан', 
             tr_name => 'Magadan', 
             ename => 'Magadan',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11403 ], 
             childs => [  ], 
        },
        
        8 => {
             name => 'Курск', 
             ua_name => 'Курськ', 
             tr_name => 'Kursk', 
             ename => 'Kursk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10705 ], 
             childs => [  ], 
        },
        
        80 => {
             name => 'Южно-Сахалинск', 
             ua_name => 'Южно-Сахалінськ', 
             tr_name => 'Sakhalinsk', 
             ename => 'Yuzhno-Sakhalinsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11450 ], 
             childs => [  ], 
        },
        
        84 => {
             name => 'США', 
             ua_name => 'США', 
             tr_name => 'ABD', 
             ename => 'United States',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        9 => {
             name => 'Липецк', 
             ua_name => 'Липецьк', 
             tr_name => 'Lipetsk', 
             ename => 'Lipetsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10712 ], 
             childs => [  ], 
        },
        
        93 => {
             name => 'Аргентина', 
             ua_name => 'Аргентина', 
             tr_name => 'Arjantin', 
             ename => 'Argentina',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10003 ], 
             childs => [  ], 
        },
        
        94 => {
             name => 'Бразилия', 
             ua_name => 'Бразилія', 
             tr_name => 'Brezilya', 
             ename => 'Brazil',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10003 ], 
             childs => [  ], 
        },
        
        95 => {
             name => 'Канада', 
             ua_name => 'Канада', 
             tr_name => 'Kanada', 
             ename => 'Canada',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 10002 ], 
             childs => [  ], 
        },
        
        959 => {
             name => 'Севастополь', 
             ua_name => 'Севастополь', 
             tr_name => 'Sevastopol', 
             ename => 'Sevastopol',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 6,             
             parents => [ 0, 225, 977 ], 
             childs => [  ], 
        },
        
        96 => {
             name => 'Германия', 
             ua_name => 'Німеччина', 
             tr_name => 'Almanya', 
             ename => 'Germany',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 103750 ], 
        },
        
        960 => {
             name => 'Запорожье', 
             ua_name => 'Запоріжжя', 
             tr_name => 'Zaporoje', 
             ename => 'Zaporizhia',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20539 ], 
             childs => [  ], 
        },
        
        961 => {
             name => 'Хмельницкий', 
             ua_name => 'Хмельницький', 
             tr_name => 'Khmelnitski', 
             ename => 'Khmelnytskyi',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20535 ], 
             childs => [  ], 
        },
        
        962 => {
             name => 'Херсон', 
             ua_name => 'Херсон', 
             tr_name => 'Herson', 
             ename => 'Kherson',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20542 ], 
             childs => [  ], 
        },
        
        963 => {
             name => 'Винница', 
             ua_name => 'Вінниця', 
             tr_name => 'Vinica', 
             ename => 'Vinnytsia',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20545 ], 
             childs => [  ], 
        },
        
        964 => {
             name => 'Полтава', 
             ua_name => 'Полтава', 
             tr_name => 'Poltava', 
             ename => 'Poltava',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20549 ], 
             childs => [  ], 
        },
        
        965 => {
             name => 'Сумы', 
             ua_name => 'Суми', 
             tr_name => 'Sumi', 
             ename => 'Sumy',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20552 ], 
             childs => [  ], 
        },
        
        967 => {
             name => 'Обнинск', 
             ua_name => 'Обнінськ', 
             tr_name => 'Obninsk', 
             ename => 'Obninsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10693 ], 
             childs => [  ], 
        },
        
        968 => {
             name => 'Череповец', 
             ua_name => 'Череповець', 
             tr_name => 'Cherepovets', 
             ename => 'Cherepovets',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 17, 10853 ], 
             childs => [  ], 
        },
        
        969 => {
             name => 'Выборг', 
             ua_name => 'Виборг', 
             tr_name => 'Vyborg', 
             ename => 'Vyborg',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 17, 10174, 98622 ], 
             childs => [  ], 
        },
        
        970 => {
             name => 'Новороссийск', 
             ua_name => 'Новоросійськ', 
             tr_name => 'Novorossiysk', 
             ename => 'Novorossiysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [  ], 
        },
        
        971 => {
             name => 'Таганрог', 
             ua_name => 'Таганрог', 
             tr_name => 'Taganrog', 
             ename => 'Taganrog',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [  ], 
        },
        
        972 => {
             name => 'Дзержинск (Нижегородская область)', 
             ua_name => 'Дзержинск (Нижегородская область)', 
             tr_name => 'Dzerjinsk', 
             ename => 'Dzerzhinsk (Nizhny Novgorod District)',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [  ], 
        },
        
        973 => {
             name => 'Сургут', 
             ua_name => 'Сургут', 
             tr_name => 'Surgut', 
             ename => 'Surgut',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 52, 11193 ], 
             childs => [  ], 
        },
        
        974 => {
             name => 'Находка', 
             ua_name => 'Находка', 
             tr_name => 'Nahodka', 
             ename => 'Nahodka',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 73, 11409 ], 
             childs => [  ], 
        },
        
        975 => {
             name => 'Бийск', 
             ua_name => 'Бійськ', 
             tr_name => 'Biysk', 
             ename => 'Biysk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11235 ], 
             childs => [  ], 
        },
        
        976 => {
             name => 'Братск', 
             ua_name => 'Братськ', 
             tr_name => 'Bratsk', 
             ename => 'Bratsk',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [  ], 
        },
        
        977 => {
             name => 'Республика Крым', 
             ua_name => 'Республіка Крим', 
             tr_name => 'Kırım Cumhuriyeti', 
             ename => 'Republic of Crimea',             
             media => 0, 
             geo_flag => 1, 
             level => 2, 
             type => 5,             
             parents => [ 0, 225 ], 
             childs => [ 146, 959, 11463, 11464, 11469, 11470, 11471, 11472, 20556, 24696, 24702, 27555, 27693, 28892 ], 
        },
        
        983 => {
             name => 'Турция', 
             ua_name => 'Туреччина', 
             tr_name => 'Türkiye', 
             ename => 'Turkey',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 103668, 103669, 103670, 103671, 103672, 103673, 103674, 103675, 103676, 103677, 103678, 103679, 103680, 103681, 103682, 103683, 103684, 103685, 103686, 103687, 103688, 103689, 103690, 103691, 103692, 103693, 103694, 103695, 103696, 103697, 103698, 103699, 103700, 103701, 103702, 103703, 103704, 103705, 103706, 103707, 103708, 103709, 103710, 103711, 103712, 103713, 103714, 103715, 103716, 103717, 103718, 103719, 103720, 103721, 103722, 103723, 103724, 103725, 103726, 103727, 103728, 103729, 103730, 103731, 103732, 103733, 103734, 103735, 103736, 103737, 103738, 103739, 103740, 103741, 103742, 103743, 103744, 103745, 103746, 103747, 103748 ], 
        },
        
        98580 => {
             name => 'Волоколамский район', 
             ua_name => 'Волоколамський район', 
             tr_name => 'Volokolamski ilçesi', 
             ename => 'Volokolamsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10721 ], 
        },
        
        98581 => {
             name => 'Воскресенский район', 
             ua_name => 'Воскресенський район', 
             tr_name => 'Voskresenski ilçesi', 
             ename => 'Voskresensky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10722, 21632 ], 
        },
        
        98582 => {
             name => 'Дмитровский городской округ', 
             ua_name => 'Дмитровський район', 
             tr_name => 'Dmitrovski ilçesi', 
             ename => 'Dmitrovsky Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10723 ], 
        },
        
        98584 => {
             name => 'Егорьевск (городской округ)', 
             ua_name => 'Єгор\'євський район', 
             tr_name => 'Yegoryevski ilçesi', 
             ename => 'Yegoryevsk Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10727 ], 
        },
        
        98585 => {
             name => 'Зарайск (городской округ)', 
             ua_name => 'Зарайський район', 
             tr_name => 'Zarayski ilçesi', 
             ename => 'Zaraysk Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10728 ], 
        },
        
        98586 => {
             name => 'Истра (городской округ)', 
             ua_name => 'Істринський район', 
             tr_name => 'İstrinski ilçesi', 
             ename => 'Istra Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10731, 21627 ], 
        },
        
        98587 => {
             name => 'Кашира (городской округ)', 
             ua_name => 'Кашира (міський округ)', 
             tr_name => 'Kaşirski ilçesi', 
             ename => 'Kashira Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10732 ], 
        },
        
        98588 => {
             name => 'Клин (городской округ)', 
             ua_name => 'Клинський район', 
             tr_name => 'Klinski ilçesi', 
             ename => 'Klin Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10733 ], 
        },
        
        98590 => {
             name => 'Красногорск (городской округ)', 
             ua_name => 'Красногорський район', 
             tr_name => 'Krasnogorski ilçesi', 
             ename => 'Krasnogorsk Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10735, 21745 ], 
        },
        
        98591 => {
             name => 'Ленинский район', 
             ua_name => 'Ленінський район', 
             tr_name => 'Leninski ilçesi', 
             ename => 'Leninsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10719 ], 
        },
        
        98593 => {
             name => 'Луховицы (городской округ)', 
             ua_name => 'Луховицький район', 
             tr_name => 'Luhovitski ilçesi', 
             ename => 'Lukhovitsy Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10737 ], 
        },
        
        98594 => {
             name => 'Люберцы (городской округ)', 
             ua_name => 'Люберецький район', 
             tr_name => 'Liuberetski ilçesi', 
             ename => 'Lyubertsy Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10738 ], 
        },
        
        98595 => {
             name => 'Можайский (городской округ)', 
             ua_name => 'Можайський район', 
             tr_name => 'Mojayski ilçesi', 
             ename => 'Mozhajskij Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10739 ], 
        },
        
        98596 => {
             name => 'Мытищи (городской округ)', 
             ua_name => 'Митищинський район', 
             tr_name => 'Mytişçinski ilçesi', 
             ename => 'Mytishchi Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10740 ], 
        },
        
        98597 => {
             name => 'Наро-Фоминский городской округ', 
             ua_name => 'Наро-Фомінський район', 
             tr_name => 'Naro-Fominski ilçesi', 
             ename => 'Naro-Fominsky Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10715, 10741 ], 
        },
        
        98598 => {
             name => 'Богородский (городской округ)', 
             ua_name => 'Ногінський район', 
             tr_name => 'Noginski ilçesi', 
             ename => 'Bogorodskij Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10742, 21642, 21656 ], 
        },
        
        98599 => {
             name => 'Одинцовский район', 
             ua_name => 'Одинцовський район', 
             tr_name => 'Odintsovski ilçesi', 
             ename => 'Odintsovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10743, 21625, 21646 ], 
        },
        
        98602 => {
             name => 'Павловский Посад (городской округ)', 
             ua_name => 'Павлово-Посадський район', 
             tr_name => 'Pavlovo-Posadski ilçesi', 
             ename => 'Pavlovsky Posad Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10746 ], 
        },
        
        98604 => {
             name => 'Пушкинский район', 
             ua_name => 'Пушкінський район', 
             tr_name => 'Puşkinski ilçesi', 
             ename => 'Pushkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10748, 21623, 100471 ], 
        },
        
        98605 => {
             name => 'Раменский район', 
             ua_name => 'Раменський район', 
             tr_name => 'Ramenski ilçesi', 
             ename => 'Ramensky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10750 ], 
        },
        
        98606 => {
             name => 'Рузский городской округ', 
             ua_name => 'Рузький район', 
             tr_name => 'Ruzski ilçesi', 
             ename => 'Ruzsky Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10751 ], 
        },
        
        98607 => {
             name => 'Ступино (городской округ)', 
             ua_name => 'Ступинський район', 
             tr_name => 'Stupinski ilçesi', 
             ename => 'Stupino Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10756 ], 
        },
        
        98608 => {
             name => 'Сергиево-Посадский район', 
             ua_name => 'Сергієво-Посадський район', 
             tr_name => 'Sergiyevo-Posadski ilçesi', 
             ename => 'Sergiyevo-Posadsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10752, 21645 ], 
        },
        
        98611 => {
             name => 'Солнечногорский район', 
             ua_name => 'Солнєчногорський район', 
             tr_name => 'Solneçnogorski ilçesi', 
             ename => 'Solnechnogorsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10755 ], 
        },
        
        98614 => {
             name => 'Чехов (городской округ)', 
             ua_name => 'Чеховський район', 
             tr_name => 'Çehovski ilçesi', 
             ename => 'Chekhov Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10761 ], 
        },
        
        98615 => {
             name => 'Шатура (городской округ)', 
             ua_name => 'Шатурський район', 
             tr_name => 'Şaturski ilçesi', 
             ename => 'Shatura Urban Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10762 ], 
        },
        
        98617 => {
             name => 'Щёлковский район', 
             ua_name => 'Щолковський район', 
             tr_name => 'Şçolkovski ilçesi', 
             ename => 'Shchelkovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 1 ], 
             childs => [ 10765 ], 
        },
        
        98620 => {
             name => 'Волховский район', 
             ua_name => 'Волховський район', 
             tr_name => 'Volkhov ilçesi', 
             ename => 'Volkhov district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10864 ], 
        },
        
        98621 => {
             name => 'Всеволожский район', 
             ua_name => 'Всеволожський район', 
             tr_name => 'Vsevolozhsk İlçesi', 
             ename => 'Vsevolozhsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10865 ], 
        },
        
        98622 => {
             name => 'Выборгский район', 
             ua_name => 'Виборзький район', 
             tr_name => 'Vyborg ilçesi', 
             ename => 'Vyborg district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 969 ], 
        },
        
        98623 => {
             name => 'Гатчинский район', 
             ua_name => 'Гатчинський район', 
             tr_name => 'Gatchina ilçesi', 
             ename => 'Gatchina district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10867 ], 
        },
        
        98624 => {
             name => 'Кингисеппский район', 
             ua_name => 'Кінгісеппський район', 
             tr_name => 'Kingisepp İlçesi', 
             ename => 'Kingisepp District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10870 ], 
        },
        
        98625 => {
             name => 'Киришский район', 
             ua_name => 'Кириський район', 
             tr_name => 'Kirishski İlçesi', 
             ename => 'Kirishsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10871 ], 
        },
        
        98626 => {
             name => 'Кировский район', 
             ua_name => 'Кіровський район', 
             tr_name => 'Kirov İlçesi', 
             ename => 'Kirov District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10872 ], 
        },
        
        98629 => {
             name => 'Лужский район', 
             ua_name => 'Лузький район', 
             tr_name => 'Luzhski İlçesi', 
             ename => 'Luzhsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10876 ], 
        },
        
        98630 => {
             name => 'Подпорожский район', 
             ua_name => 'Підпорізький район', 
             tr_name => 'Podporozhski İlçesi', 
             ename => 'Podporozhsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10881, 22829 ], 
        },
        
        98631 => {
             name => 'Приозерский район', 
             ua_name => 'Приозерський район', 
             tr_name => 'Priozersk İlçesi', 
             ename => 'Priozersk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10883 ], 
        },
        
        98632 => {
             name => 'Сланцевский район', 
             ua_name => 'Сланцевський район', 
             tr_name => 'Slantski İlçesi', 
             ename => 'Slantsy District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10888 ], 
        },
        
        98633 => {
             name => 'Тихвинский район', 
             ua_name => 'Тихвінський район', 
             tr_name => 'Tikhvinski İlçesi', 
             ename => 'Tikhvin District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10892 ], 
        },
        
        98634 => {
             name => 'Тосненский район', 
             ua_name => 'Тосненський район', 
             tr_name => 'Tosnenski İlçesi', 
             ename => 'Tosnensky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10174 ], 
             childs => [ 10893 ], 
        },
        
        98697 => {
             name => 'Алексеевский район', 
             ua_name => 'Алексєєвський район', 
             tr_name => 'Alekseevskii İlçesi', 
             ename => 'Alekseevskii District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [ 20192 ], 
        },
        
        98716 => {
             name => 'Шебекинский район', 
             ua_name => 'Шебекінський район', 
             tr_name => 'Shebekinski İlçesi', 
             ename => 'Shebekinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [ 20196 ], 
        },
        
        98717 => {
             name => 'Яковлевский район', 
             ua_name => 'Яковлєвський район', 
             tr_name => 'Yakovlevski İlçesi', 
             ename => 'Yakovlevskij District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10645 ], 
             childs => [ 20587 ], 
        },
        
        98745 => {
             name => 'Александровский район', 
             ua_name => 'Олександрівський район', 
             tr_name => 'Aleksandrovski ilçesi', 
             ename => 'Alexandrovsky district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [ 10656 ], 
        },
        
        98750 => {
             name => 'Киржачский район', 
             ua_name => 'Киржацький район', 
             tr_name => 'Kirjaçski ilçesi', 
             ename => 'Kirzhachsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [ 10663 ], 
        },
        
        98755 => {
             name => 'Петушинский район', 
             ua_name => 'Петушинський район', 
             tr_name => 'Petuşinski ilçesi', 
             ename => 'Petushinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10658 ], 
             childs => [ 37129 ], 
        },
        
        98787 => {
             name => 'Россошанский район', 
             ua_name => 'Россошанський район', 
             tr_name => 'Rossoşanski ilçesi', 
             ename => 'Rossoshansky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10672 ], 
             childs => [ 10681 ], 
        },
        
        98826 => {
             name => 'Малоярославецкий район', 
             ua_name => 'Малоярославецький район', 
             tr_name => 'Maloyaroslavetski İlçesi', 
             ename => 'Maloyaroslavetsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10693 ], 
             childs => [ 10697 ], 
        },
        
        98958 => {
             name => 'Вяземский район', 
             ua_name => 'Вяземський район', 
             tr_name => 'Viazemski ilçesi', 
             ename => 'Vyazemsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [ 10782 ], 
        },
        
        98959 => {
             name => 'Гагаринский район', 
             ua_name => 'Гагарінський район', 
             tr_name => 'Gagarinski ilçesi', 
             ename => 'Gagarinsky district',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [ 10783 ], 
        },
        
        98981 => {
             name => 'Ярцевский район', 
             ua_name => 'Ярцевський район', 
             tr_name => 'Yartsevski İlçesi', 
             ename => 'Yartsevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10795 ], 
             childs => [ 10801 ], 
        },
        
        99008 => {
             name => 'Бологовский район', 
             ua_name => 'Бологовський район', 
             tr_name => 'Bologovski İlçesi', 
             ename => 'Bologovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10805 ], 
        },
        
        99019 => {
             name => 'Конаковский район', 
             ua_name => 'Конаковський район', 
             tr_name => 'Konakovski İlçesi', 
             ename => 'Konakovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10812 ], 
        },
        
        99028 => {
             name => 'Осташковский район', 
             ua_name => 'Осташковський район', 
             tr_name => 'Ostashkovski İlçesi', 
             ename => 'Ostashkovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10818 ], 
        },
        
        99039 => {
             name => 'Удомельский район', 
             ua_name => 'Удомельський район', 
             tr_name => 'Udomelski İlçesi', 
             ename => 'Udomelsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10819 ], 
             childs => [ 10824 ], 
        },
        
        99044 => {
             name => 'Богородицкий район', 
             ua_name => 'Богородицький район', 
             tr_name => 'Bogoroditski ilçesi', 
             ename => 'Bogoroditsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10832 ], 
             childs => [ 20667 ], 
        },
        
        99070 => {
             name => 'Мышкинский район', 
             ua_name => 'Мишкінський район', 
             tr_name => 'Myşkinski ilçesi', 
             ename => 'Myshkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [ 10836 ], 
        },
        
        99078 => {
             name => 'Тутаевский район', 
             ua_name => 'Тутаєвський район', 
             tr_name => 'Tutayevski ilçesi', 
             ename => 'Tutaevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [ 21154 ], 
        },
        
        99079 => {
             name => 'Угличский район', 
             ua_name => 'Углицький район', 
             tr_name => 'Ugliçski ilçesi', 
             ename => 'Uglichesky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 3, 10841 ], 
             childs => [ 10840 ], 
        },
        
        99105 => {
             name => 'Великоустюгский район', 
             ua_name => 'Великоустюзький район', 
             tr_name => 'Velikoustyugski İlçesi', 
             ename => 'Velikoustyugsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10853 ], 
             childs => [ 10854 ], 
        },
        
        99146 => {
             name => 'Боровичский район', 
             ua_name => 'Боровицький район', 
             tr_name => 'Borovichski İlçesi', 
             ename => 'Borovichsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [ 10906 ], 
        },
        
        99147 => {
             name => 'Валдайский район', 
             ua_name => 'Валдайський район', 
             tr_name => 'Valdai İlçesi', 
             ename => 'Valdai District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [ 10907 ], 
        },
        
        99161 => {
             name => 'Старорусский район', 
             ua_name => 'Староруський район', 
             tr_name => 'Old İlçesi', 
             ename => 'Old District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10904 ], 
             childs => [ 10923 ], 
        },
        
        99193 => {
             name => 'Кондопожский район', 
             ua_name => 'Кондопозький район', 
             tr_name => 'Kondopoga İlçesi', 
             ename => 'Kondopoga District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [ 10934 ], 
        },
        
        99203 => {
             name => 'Сегежский район', 
             ua_name => 'Сегезький район', 
             tr_name => 'Segezha İlçesi', 
             ename => 'Segezha District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10933 ], 
             childs => [ 10936 ], 
        },
        
        99210 => {
             name => 'Район Печора', 
             ua_name => 'Печора', 
             tr_name => 'Pechora İlçesi', 
             ename => 'Pechora District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10939 ], 
             childs => [ 10942 ], 
        },
        
        99221 => {
             name => 'Ахтубинский район', 
             ua_name => 'Ахтубінський район', 
             tr_name => 'Ahtubinski ilçesi', 
             ename => 'Akhtubinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10946 ], 
             childs => [ 20167 ], 
        },
        
        99269 => {
             name => 'Белореченский район', 
             ua_name => 'Бєлорєченський район', 
             tr_name => 'Beloreçenski ilçesi', 
             ename => 'Belorechensk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10988 ], 
        },
        
        99274 => {
             name => 'Ейский район', 
             ua_name => 'Єйський район', 
             tr_name => 'Yeyski ilçesi', 
             ename => 'Eisk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10993 ], 
        },
        
        99275 => {
             name => 'Кавказский район', 
             ua_name => 'Кавказький район', 
             tr_name => 'Kavkazski ilçesi', 
             ename => 'Kavkazsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10996 ], 
        },
        
        99281 => {
             name => 'Крымский район', 
             ua_name => 'Кримський район', 
             tr_name => 'Krymski ilçesi', 
             ename => 'Krimsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 10997 ], 
        },
        
        99293 => {
             name => 'Славянский район', 
             ua_name => 'Слов\'янський район', 
             tr_name => 'Slavianski ilçesi', 
             ename => 'Slavyansky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 20704 ], 
        },
        
        99297 => {
             name => 'Тимашевский район', 
             ua_name => 'Тимашевський район', 
             tr_name => 'Timaşovski ilçesi', 
             ename => 'Timashyovsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 21141 ], 
        },
        
        99298 => {
             name => 'Тихорецкий район', 
             ua_name => 'Тихорєцький район', 
             tr_name => 'Tihoretski ilçesi', 
             ename => 'Tikhoretsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 11002 ], 
        },
        
        99299 => {
             name => 'Туапсинский район', 
             ua_name => 'Туапсінський район', 
             tr_name => 'Tuapsinski ilçesi', 
             ename => 'Tuapse District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 10995 ], 
             childs => [ 1058 ], 
        },
        
        994 => {
             name => 'Индия', 
             ua_name => 'Індія', 
             tr_name => 'Hindistan', 
             ename => 'India',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        99411 => {
             name => 'Белокалитвинский район', 
             ua_name => 'Білокалитвінський район', 
             tr_name => 'Belokalitvinski ilçesi', 
             ename => 'Belaya Kalitva District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 26, 11029 ], 
             childs => [ 11034 ], 
        },
        
        99456 => {
             name => 'Будённовский район', 
             ua_name => 'Будьоновський район', 
             tr_name => 'Budyonnovski İlçesi', 
             ename => 'Budyonnovsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 102444, 11069 ], 
             childs => [ 11055 ], 
        },
        
        995 => {
             name => 'Таиланд', 
             ua_name => 'Таїланд', 
             tr_name => 'Tayland', 
             ename => 'Thailand',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        99555 => {
             name => 'Кстовский район', 
             ua_name => 'Кстовський район', 
             tr_name => 'Kstovski İlçesi', 
             ename => 'Kstovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [ 20044 ], 
        },
        
        99560 => {
             name => 'Павловский район', 
             ua_name => 'Павловський район', 
             tr_name => 'Pavlovski İlçesi', 
             ename => 'Pavlovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11079 ], 
             childs => [ 11082 ], 
        },
        
        99675 => {
             name => 'Белебеевский район', 
             ua_name => 'Белебеєвський район', 
             tr_name => 'Belebeyevski ilçesi', 
             ename => 'Belebeevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20714 ], 
        },
        
        99677 => {
             name => 'Белорецкий район', 
             ua_name => 'Бєлорєцький район', 
             tr_name => 'Beloretski ilçesi', 
             ename => 'Beloretsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20259 ], 
        },
        
        99694 => {
             name => 'Ишимбайский район', 
             ua_name => 'Ішимбайський район', 
             tr_name => 'Ishimbayski İlçesi', 
             ename => 'Ishimbaysky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20718 ], 
        },
        
        99703 => {
             name => 'Мелеузовский район', 
             ua_name => 'Мелеузовський район', 
             tr_name => 'Meleuzovski ilçesi', 
             ename => 'Meleuzovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20715 ], 
        },
        
        99712 => {
             name => 'Туймазинский район', 
             ua_name => 'Туймазинський район', 
             tr_name => 'Tuymazinski ilçesi', 
             ename => 'Tuymazinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20717 ], 
        },
        
        99714 => {
             name => 'Учалинский район', 
             ua_name => 'Учалинський район', 
             tr_name => 'Uçalinski ilçesi', 
             ename => 'Uchalinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11111 ], 
             childs => [ 20680 ], 
        },
        
        99737 => {
             name => 'Рузаевский район', 
             ua_name => 'Рузаєвський район', 
             tr_name => 'Ruzaevski İlçesi', 
             ename => 'Ruzaevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11117 ], 
             childs => [ 20010 ], 
        },
        
        99817 => {
             name => 'Балаковский район', 
             ua_name => 'Балаковський район', 
             tr_name => 'Balakovski ilçesi', 
             ename => 'Balakovo District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 11143 ], 
        },
        
        99818 => {
             name => 'Балашовский район', 
             ua_name => 'Балашовський район', 
             tr_name => 'Balaşovski ilçesi', 
             ename => 'Balashov District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 11144 ], 
        },
        
        99832 => {
             name => 'Марксовский район', 
             ua_name => 'Марксовський район', 
             tr_name => 'Marksovski İlçesi', 
             ename => 'Marksovsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 20063 ], 
        },
        
        99850 => {
             name => 'Энгельсский район', 
             ua_name => 'Енгельський район', 
             tr_name => 'Engelsski İlçesi', 
             ename => 'Engelssky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 40, 11146 ], 
             childs => [ 11147 ], 
        },
);


# хэш всех известных регионов (для API c Крымом в корне)
our %GEOREG_API = (
    
        
        0 => {
             name => 'Все', 
             ua_name => 'Всі', 
             tr_name => 'Tümü', 
             ename => 'All',             
             media => 1, 
             geo_flag => 0, 
             level => 0, 
                        
             parents => [  ], 
             childs => [ 225, 166, 111, 183, 241, 10002, 10003, 138, 977 ], 
        },
        
        1 => {
             name => 'Москва и область', 
             ua_name => 'Москва та Московська область', 
             tr_name => 'Moskova ve Moskovskaya oblastı', 
             ename => 'Moscow and Moscow Oblast',             
             media => 1, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 3 ], 
             childs => [ 213, 214, 215, 217, 219, 10716, 10717, 10725, 10729, 10734, 10745, 10747, 10754, 10758, 20523, 20571, 20576, 20728, 21619, 21621, 21630, 21635, 21641, 21647, 21735, 98580, 98581, 98582, 98584, 98585, 98586, 98587, 98588, 98590, 98591, 98593, 98594, 98595, 98596, 98597, 98598, 98599, 98602, 98604, 98605, 98606, 98607, 98608, 98611, 98614, 98615, 98617 ], 
        },
        
        10 => {
             name => 'Орёл', 
             ua_name => 'Орел', 
             tr_name => 'Orel', 
             ename => 'Orel',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 225, 3, 10772 ], 
             childs => [  ], 
        },
        
        100005 => {
             name => 'Ашинский район', 
             ua_name => 'Ашинський район', 
             tr_name => 'Aşinski ilçesi', 
             ename => 'Ashinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [ 11196 ], 
        },
        
        10002 => {
             name => 'Северная Америка', 
             ua_name => 'Північна Америка', 
             tr_name => 'Kuzey Amerika', 
             ename => 'North America',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 84, 95, 20917, 20968 ], 
        },
        
        100020 => {
             name => 'Саткинский район', 
             ua_name => 'Саткінський район', 
             tr_name => 'Satkinski ilçesi', 
             ename => 'Satkinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11225 ], 
             childs => [ 11217 ], 
        },
        
        100028 => {
             name => 'Надымский район', 
             ua_name => 'Надимський район', 
             tr_name => 'Nadymski ilçesi', 
             ename => 'Nadymsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 52, 11232 ], 
             childs => [ 11229 ], 
        },
        
        10003 => {
             name => 'Южная Америка', 
             ua_name => 'Південна Америка', 
             tr_name => 'Güney Amerika', 
             ename => 'South America',             
             media => 1, 
             geo_flag => 0, 
             level => 1, 
             type => 1,             
             parents => [ 0 ], 
             childs => [ 93, 94 ], 
        },
        
        100109 => {
             name => 'Нижнеудинский район', 
             ua_name => 'Нижньоудинський район', 
             tr_name => 'Nijneudinski ilçesi', 
             ename => 'Nizhneudinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 11268 ], 
        },
        
        100112 => {
             name => 'Тайшетский район', 
             ua_name => 'Тайшетський район', 
             tr_name => 'Tayşetski ilçesi', 
             ename => 'Tayshetsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 11270 ], 
        },
        
        100116 => {
             name => 'Усть-Кутский район', 
             ua_name => 'Усть-Кутський район', 
             tr_name => 'Ust-Kutski ilçesi', 
             ename => 'Ust-Kutsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11266 ], 
             childs => [ 20097 ], 
        },
        
        100183 => {
             name => 'Барабинский район', 
             ua_name => 'Барабінський район', 
             tr_name => 'Barabinski İlçesi', 
             ename => 'Barabinsk District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [ 20098 ], 
        },
        
        100189 => {
             name => 'Карасукский район', 
             ua_name => 'Карасуцький район', 
             tr_name => 'Karasukski İlçesi', 
             ename => 'Karasuksky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11316 ], 
             childs => [ 20101 ], 
        },
        
        100244 => {
             name => 'Баргузинский район', 
             ua_name => 'Баргузинський район', 
             tr_name => 'Barguzinski ilçesi', 
             ename => 'Barguzin District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11330 ], 
             childs => [ 21161 ], 
        },
        
        100278 => {
             name => 'Каргасокский район', 
             ua_name => 'Каргасоцький район', 
             tr_name => 'Kargasokski ilçesi', 
             ename => 'Kargasoksky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [ 21675 ], 
        },
        
        100280 => {
             name => 'Колпашевский район', 
             ua_name => 'Колпашевський район', 
             tr_name => 'Kolpaşevski ilçesi', 
             ename => 'Kolpashevsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 59, 11353 ], 
             childs => [ 11349 ], 
        },
        
        100398 => {
             name => 'Амурский район', 
             ua_name => 'Амурський район', 
             tr_name => 'Amur bölgesi', 
             ename => 'Amursky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11457 ], 
             childs => [ 11451 ], 
        },
        
        100471 => {
             name => 'Красноармейск', 
             ua_name => 'Красноармійськ', 
             tr_name => 'Krasnoarmeysk', 
             ename => 'Krasnoarmeysk',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 3, 1, 98604 ], 
             childs => [  ], 
        },
        
        10074 => {
             name => 'Португалия', 
             ua_name => 'Португалія', 
             tr_name => 'Portekiz', 
             ename => 'Portugal',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        10077 => {
             name => 'Румыния', 
             ua_name => 'Румунія', 
             tr_name => 'Romanya', 
             ename => 'Romania',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        10083 => {
             name => 'Хорватия', 
             ua_name => 'Хорватія', 
             tr_name => 'Hırvatistan', 
             ename => 'Croatia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [  ], 
        },
        
        100944 => {
             name => 'Ашкелон', 
             ua_name => 'Ашкелон', 
             tr_name => 'Aşkelon', 
             ename => 'Ashkelon',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 181, 103904 ], 
             childs => [  ], 
        },
        
        10095 => {
             name => 'Индонезия', 
             ua_name => 'Індонезія', 
             tr_name => 'Endonezya', 
             ename => 'Indonesia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        101425 => {
             name => 'Маргилан', 
             ua_name => 'Маргілан', 
             tr_name => 'Mergilân', 
             ename => 'Margilan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        101524 => {
             name => 'Бекабад', 
             ua_name => 'Бекабад', 
             tr_name => 'Bekabat', 
             ename => 'Bekabad',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        101550 => {
             name => 'Ангрен', 
             ua_name => 'Ангрен', 
             tr_name => 'Angren', 
             ename => 'Angren',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 171, 105813, 189657 ], 
             childs => [  ], 
        },
        
        101738 => {
             name => 'Ингольштадт', 
             ua_name => 'Інгольштадт', 
             tr_name => 'Ingolstadt', 
             ename => 'Ingolstadt',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 96, 103750 ], 
             childs => [  ], 
        },
        
        10174 => {
             name => 'Санкт-Петербург и Ленинградская область', 
             ua_name => 'Санкт-Петербург і Ленінградська область', 
             tr_name => 'Saint-Petersburg ve Leningradskaya oblastı', 
             ename => 'Saint-Petersburg and Leningrad Oblast',             
             media => 1, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 2, 10891, 98620, 98621, 98622, 98623, 98624, 98625, 98626, 98629, 98630, 98631, 98632, 98633, 98634 ], 
        },
        
        101749 => {
             name => 'Кандалакшский район', 
             ua_name => 'Кандалакський район', 
             tr_name => 'Kandalakshski İlçesi', 
             ename => 'Kandalakshsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 17, 10897 ], 
             childs => [ 10895 ], 
        },
        
        10176 => {
             name => 'Ненецкий автономный округ', 
             ua_name => 'Ненецький автономний округ', 
             tr_name => 'Nenets özerk okrugu', 
             ename => 'Nenets Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 17 ], 
             childs => [ 10902 ], 
        },
        
        101761 => {
             name => 'Шахрисабз', 
             ua_name => 'Шахрисабз', 
             tr_name => 'Şehrisebz', 
             ename => 'Shahrisabz',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105807 ], 
             childs => [  ], 
        },
        
        101987 => {
             name => 'Нерюнгринский район', 
             ua_name => 'Нерюнгрінський район', 
             tr_name => 'Neryungrinski İlçesi', 
             ename => 'Neryungrinsky District',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 10,             
             parents => [ 0, 225, 73, 11443 ], 
             childs => [ 11437 ], 
        },
        
        102 => {
             name => 'Великобритания', 
             ua_name => 'Великобританія', 
             tr_name => 'Birleşik Krallık', 
             ename => 'United Kingdom',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 111 ], 
             childs => [ 104520 ], 
        },
        
        102089 => {
             name => 'Кобринский район', 
             ua_name => 'Кобринський район', 
             tr_name => 'Kobrinsky İlçesi', 
             ename => 'Kobrinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29632 ], 
             childs => [ 26010 ], 
        },
        
        102103 => {
             name => 'Жлобинский район', 
             ua_name => 'Жлобінський район', 
             tr_name => 'Zhlobinsky İlçesi', 
             ename => 'Zhlobinsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26966 ], 
        },
        
        102104 => {
             name => 'Калинковичский район', 
             ua_name => 'Калинковицький район', 
             tr_name => 'Kalinovichsky İlçesi', 
             ename => 'Kalinovichsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 102235 ], 
        },
        
        102108 => {
             name => 'Мозырский район', 
             ua_name => 'Мозирський район', 
             tr_name => 'Mozirsky İlçesi', 
             ename => 'Mozirsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 21274 ], 
        },
        
        102112 => {
             name => 'Речицкий район', 
             ua_name => 'Речицький район', 
             tr_name => 'Rechitsky İlçesi', 
             ename => 'Rechitsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26008 ], 
        },
        
        102113 => {
             name => 'Рогачёвский район', 
             ua_name => 'Рогачовський район', 
             tr_name => 'Rogachevsky İlçesi', 
             ename => 'Rogachevsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26027 ], 
        },
        
        102114 => {
             name => 'Светлогорский район', 
             ua_name => 'Свєтлогорський район', 
             tr_name => 'Svetlogorsky İlçesi', 
             ename => 'Svetlogorsky district',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29631 ], 
             childs => [ 26004 ], 
        },
        
        102118 => {
             name => 'Волковысский район', 
             ua_name => 'Волковиський район', 
             tr_name => 'Volkovisski İlçesi', 
             ename => 'Volkovisski District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26923 ], 
        },
        
        102125 => {
             name => 'Лидский район', 
             ua_name => 'Лідський район', 
             tr_name => 'Lidsky İlçesi', 
             ename => 'Lidsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 21144 ], 
        },
        
        102126 => {
             name => 'Мостовский район', 
             ua_name => 'Мостовський район', 
             tr_name => 'Mostovsky İlçesi', 
             ename => 'Mostovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26007 ], 
        },
        
        102127 => {
             name => 'Новогрудский район', 
             ua_name => 'Новогрудський район', 
             tr_name => 'Novogrudsky İlçesi', 
             ename => 'Novogrudsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26836 ], 
        },
        
        102131 => {
             name => 'Слонимский район', 
             ua_name => 'Слонімський район', 
             tr_name => 'Slonimsky İlçesi', 
             ename => 'Slonimsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26005 ], 
        },
        
        102132 => {
             name => 'Сморгонский район', 
             ua_name => 'Сморгонський район', 
             tr_name => 'Smorgonsky İlçesi', 
             ename => 'Smorgonsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [ 26017 ], 
        },
        
        102136 => {
             name => 'Быховский район', 
             ua_name => 'Биховський район', 
             tr_name => 'Bykhovsky İlçesi', 
             ename => 'Bikhovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26021 ], 
        },
        
        102138 => {
             name => 'Горецкий район', 
             ua_name => 'Горецький район', 
             tr_name => 'Goretsky İlçesi', 
             ename => 'Goretsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26774 ], 
        },
        
        102141 => {
             name => 'Климовичский район', 
             ua_name => 'Климовицький район', 
             tr_name => 'Klimovichsky İlçesi', 
             ename => 'Klimovichsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26006 ], 
        },
        
        102144 => {
             name => 'Кричевский район', 
             ua_name => 'Кричевський район', 
             tr_name => 'Krichevsky İlçesi', 
             ename => 'Krichevsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26015 ], 
        },
        
        102149 => {
             name => 'Осиповичский район', 
             ua_name => 'Осиповицький район', 
             tr_name => 'Osipovichsky İlçesi', 
             ename => 'Osipovichsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26012 ], 
        },
        
        102154 => {
             name => 'Шкловский район', 
             ua_name => 'Шкловський район', 
             tr_name => 'Shklovsky İlçesi', 
             ename => 'Shklovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29629 ], 
             childs => [ 26016 ], 
        },
        
        102156 => {
             name => 'Борисовский район', 
             ua_name => 'Борисовський район', 
             tr_name => 'Borisovsky İlçesi', 
             ename => 'Borisovsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 21193 ], 
        },
        
        102157 => {
             name => 'Вилейский район', 
             ua_name => 'Вілейський район', 
             tr_name => 'Vileysky İlçesi', 
             ename => 'Vileysky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26745 ], 
        },
        
        102159 => {
             name => 'Дзержинский район', 
             ua_name => 'Дзержинський район', 
             tr_name => 'Dzerzhinsky İlçesi', 
             ename => 'Dzerzhinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26018 ], 
        },
        
        102162 => {
             name => 'Крупский район', 
             ua_name => 'Крупський район', 
             tr_name => 'Krupsky İlçesi', 
             ename => 'Krupsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26022 ], 
        },
        
        102165 => {
             name => 'Молодечненский район', 
             ua_name => 'Молодечненський район', 
             tr_name => 'Molodechnensky İlçesi', 
             ename => 'Molodechnensky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26001 ], 
        },
        
        102169 => {
             name => 'Слуцкий район', 
             ua_name => 'Слуцький район', 
             tr_name => 'Slutsky İlçesi', 
             ename => 'Slutsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26951 ], 
        },
        
        102170 => {
             name => 'Солигорский район', 
             ua_name => 'Солігорський район', 
             tr_name => 'Salihorsky İlçesi', 
             ename => 'Salihorsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29630 ], 
             childs => [ 26003 ], 
        },
        
        102178 => {
             name => 'Верхнедвинский район', 
             ua_name => 'Верхньодвінський район', 
             tr_name => 'Verkhnedvinsky İlçesi', 
             ename => 'Verkhnedvinsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26554 ], 
        },
        
        102180 => {
             name => 'Глубокский район', 
             ua_name => 'Глибоцький район', 
             tr_name => 'Gluboksky İlçesi', 
             ename => 'Gluboksky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26025 ], 
        },
        
        102186 => {
             name => 'Миорский район', 
             ua_name => 'Міорський район', 
             tr_name => 'Miorsky İlçesi', 
             ename => 'Myory District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 21271 ], 
        },
        
        102187 => {
             name => 'Оршанский район', 
             ua_name => 'Оршанський район', 
             tr_name => 'Orshansky İlçesi', 
             ename => 'Orshansky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 10276 ], 
        },
        
        102188 => {
             name => 'Полоцкий район', 
             ua_name => 'Полоцький район', 
             tr_name => 'Polotsky İlçesi', 
             ename => 'Polotsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 10275 ], 
        },
        
        102189 => {
             name => 'Поставский район', 
             ua_name => 'Поставський район', 
             tr_name => 'Pastavsky İlçesi', 
             ename => 'Pastavsky District',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 10,             
             parents => [ 0, 166, 149, 29633 ], 
             childs => [ 26026 ], 
        },
        
        102235 => {
             name => 'Калинковичи', 
             ua_name => 'Калинковичі', 
             tr_name => 'Kalinoviçi', 
             ename => 'Kalinovichi',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29631, 102104 ], 
             childs => [  ], 
        },
        
        10231 => {
             name => 'Республика Алтай', 
             ua_name => 'Республіка Алтай', 
             tr_name => 'Altay Cumhuriyeti', 
             ename => 'Altai Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 11319 ], 
        },
        
        10233 => {
             name => 'Республика Тыва', 
             ua_name => 'Республіка Тива', 
             tr_name => 'Tuva', 
             ename => 'Tyva Republic',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 59 ], 
             childs => [ 11333 ], 
        },
        
        10243 => {
             name => 'Еврейская автономная область', 
             ua_name => 'Єврейська автономна область', 
             tr_name => 'Yahudi Özerk Bölgesi', 
             ename => 'Jewish Autonomous Oblast',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [ 11393 ], 
        },
        
        102444 => {
             name => 'Северный Кавказ', 
             ua_name => 'Північний Кавказ', 
             tr_name => 'Kuzey Kafkasya Federal Bölgesi', 
             ename => 'North Caucasian Federal District',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 4,             
             parents => [ 0, 225 ], 
             childs => [ 11010, 11012, 11013, 11020, 11021, 11024, 11069 ], 
        },
        
        10251 => {
             name => 'Чукотский автономный округ', 
             ua_name => 'Чукотський автономний округ', 
             tr_name => 'Chukotka Özerk Bölgesi', 
             ename => 'Chukotka Autonomous Okrug',             
             media => 0, 
             geo_flag => 1, 
             level => 3, 
             type => 5,             
             parents => [ 0, 225, 73 ], 
             childs => [  ], 
        },
        
        10253 => {
             name => 'Баку', 
             ua_name => 'Баку', 
             tr_name => 'Bakü', 
             ename => 'Baku',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 167 ], 
             childs => [  ], 
        },
        
        10258 => {
             name => 'Ванадзор', 
             ua_name => 'Ванадзор', 
             tr_name => 'Vanadzor', 
             ename => 'Vanadzor',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 168, 105794 ], 
             childs => [  ], 
        },
        
        10259 => {
             name => 'Гюмри', 
             ua_name => 'Гюмрі', 
             tr_name => 'Gümrü', 
             ename => 'Gyumri',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 168, 105795 ], 
             childs => [  ], 
        },
        
        10262 => {
             name => 'Ереван', 
             ua_name => 'Єреван', 
             tr_name => 'Erivan', 
             ename => 'Yerevan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        10274 => {
             name => 'Гродно', 
             ua_name => 'Гродно', 
             tr_name => 'Grodno', 
             ename => 'Grodno',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 149, 29634 ], 
             childs => [  ], 
        },
        
        10275 => {
             name => 'Полоцк', 
             ua_name => 'Полоцьк', 
             tr_name => 'Polotsk', 
             ename => 'Polotsk',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102188 ], 
             childs => [  ], 
        },
        
        10276 => {
             name => 'Орша', 
             ua_name => 'Орша', 
             tr_name => 'Orsha', 
             ename => 'Orsha',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 6,             
             parents => [ 0, 166, 149, 29633, 102187 ], 
             childs => [  ], 
        },
        
        10277 => {
             name => 'Тбилиси', 
             ua_name => 'Тбілісі', 
             tr_name => 'Tiflis', 
             ename => 'Tbilisi',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 183, 169 ], 
             childs => [  ], 
        },
        
        10278 => {
             name => 'Батуми', 
             ua_name => 'Батумі', 
             tr_name => 'Batum', 
             ename => 'Batumi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 169, 122054 ], 
             childs => [  ], 
        },
        
        10285 => {
             name => 'Рустави', 
             ua_name => 'Руставі', 
             tr_name => 'Rustavi (Bostandere)', 
             ename => 'Rustavi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 183, 169, 122062 ], 
             childs => [  ], 
        },
        
        10291 => {
             name => 'Атырау', 
             ua_name => 'Атирау', 
             tr_name => 'Atırav', 
             ename => 'Atyrau',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29407 ], 
             childs => [  ], 
        },
        
        10295 => {
             name => 'Костанай', 
             ua_name => 'Костанай', 
             tr_name => 'Kostanay', 
             ename => 'Kostanai',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29412 ], 
             childs => [  ], 
        },
        
        10298 => {
             name => 'Петропавловск', 
             ua_name => 'Петропавловськ', 
             tr_name => 'Petropavl (Petropavlovsk)', 
             ename => 'Petropavlovsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29416 ], 
             childs => [  ], 
        },
        
        10300 => {
             name => 'Рудный', 
             ua_name => 'Рудний', 
             tr_name => 'Rudny', 
             ename => 'Rudny',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29412 ], 
             childs => [  ], 
        },
        
        10303 => {
             name => 'Талдыкорган', 
             ua_name => 'Талдикорган', 
             tr_name => 'Taldıkorgan', 
             ename => 'Taldikorgan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29406 ], 
             childs => [  ], 
        },
        
        10305 => {
             name => 'Уральск', 
             ua_name => 'Уральськ', 
             tr_name => 'Oral (Uralsk)', 
             ename => 'Uralsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29410 ], 
             childs => [  ], 
        },
        
        10306 => {
             name => 'Усть-Каменогорск', 
             ua_name => 'Усть-Каменогорськ', 
             tr_name => 'Öskemen (Ust-Kamenogorsk)', 
             ename => 'Ust-Kamenogorsk',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29408 ], 
             childs => [  ], 
        },
        
        10308 => {
             name => 'Жезказган', 
             ua_name => 'Жезказган', 
             tr_name => 'Jezkazgan', 
             ename => 'Zhezkazgan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 159, 29411 ], 
             childs => [  ], 
        },
        
        10309 => {
             name => 'Бишкек', 
             ua_name => 'Бішкек', 
             tr_name => 'Bişkek', 
             ename => 'Bishkek',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 207 ], 
             childs => [  ], 
        },
        
        10310 => {
             name => 'Ош', 
             ua_name => 'Ош', 
             tr_name => 'Osh', 
             ename => 'Osh',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 207 ], 
             childs => [  ], 
        },
        
        10313 => {
             name => 'Кишинев', 
             ua_name => 'Кишинів', 
             tr_name => 'Kişinev', 
             ename => 'Kishinev',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 208 ], 
             childs => [  ], 
        },
        
        10328 => {
             name => 'Алмалык', 
             ua_name => 'Алмалик', 
             tr_name => 'Elmalık', 
             ename => 'Almalik',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105813 ], 
             childs => [  ], 
        },
        
        10329 => {
             name => 'Андижан', 
             ua_name => 'Андіжан', 
             tr_name => 'Andican', 
             ename => 'Andijan',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105804 ], 
             childs => [  ], 
        },
        
        10330 => {
             name => 'Бухара', 
             ua_name => 'Бухара', 
             tr_name => 'Buhara', 
             ename => 'Bukhara',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105805 ], 
             childs => [  ], 
        },
        
        10331 => {
             name => 'Карши', 
             ua_name => 'Карші', 
             tr_name => 'Karşı', 
             ename => 'Karshi',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105807 ], 
             childs => [  ], 
        },
        
        10332 => {
             name => 'Коканд', 
             ua_name => 'Коканд', 
             tr_name => 'Kokand', 
             ename => 'Kokand',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        10334 => {
             name => 'Самарканд', 
             ua_name => 'Самарканд', 
             tr_name => 'Semerkant', 
             ename => 'Samarkand',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105810 ], 
             childs => [  ], 
        },
        
        10335 => {
             name => 'Ташкент', 
             ua_name => 'Ташкент', 
             tr_name => 'Taşkent', 
             ename => 'Tashkent',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 6,             
             parents => [ 0, 166, 171 ], 
             childs => [  ], 
        },
        
        10336 => {
             name => 'Фергана', 
             ua_name => 'Фергана', 
             tr_name => 'Fergana', 
             ename => 'Phergana',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105814 ], 
             childs => [  ], 
        },
        
        10337 => {
             name => 'Нукус', 
             ua_name => 'Нукус', 
             tr_name => 'Nukus', 
             ename => 'Nukus',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105816 ], 
             childs => [  ], 
        },
        
        10338 => {
             name => 'Термез', 
             ua_name => 'Термез', 
             tr_name => 'Termez', 
             ename => 'Termez',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 171, 105811 ], 
             childs => [  ], 
        },
        
        10347 => {
             name => 'Кривой Рог', 
             ua_name => 'Кривий Ріг', 
             tr_name => 'Krivoi Rog', 
             ename => 'Kryvyi Rih',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20537 ], 
             childs => [  ], 
        },
        
        10366 => {
             name => 'Мариуполь', 
             ua_name => 'Маріуполь', 
             tr_name => 'Mariupol', 
             ename => 'Mariupol',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20536 ], 
             childs => [  ], 
        },
        
        103668 => {
             name => 'Провинция Агры', 
             ua_name => 'Агри', 
             tr_name => 'Ağrı', 
             ename => 'Agri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103669 => {
             name => 'Провинция Адана', 
             ua_name => 'Адана', 
             tr_name => 'Adana', 
             ename => 'Adana',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103670 => {
             name => 'Провинция Адыяман', 
             ua_name => 'Адияман', 
             tr_name => 'Adıyaman', 
             ename => 'Adiyaman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103671 => {
             name => 'Провинция Айдын', 
             ua_name => 'Айдин', 
             tr_name => 'Aydın', 
             ename => 'Aydin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103672 => {
             name => 'Провинция Аксарай', 
             ua_name => 'Аксарай', 
             tr_name => 'Aksaray', 
             ename => 'Aksaray',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103673 => {
             name => 'Провинция Амасья', 
             ua_name => 'Амасья', 
             tr_name => 'Amasya', 
             ename => 'Amasya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103674 => {
             name => 'Провинция Анкара', 
             ua_name => 'Анкара', 
             tr_name => 'Ankara', 
             ename => 'Ankara',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103675 => {
             name => 'Провинция Анталья', 
             ua_name => 'Анталья', 
             tr_name => 'Antalya', 
             ename => 'Antalya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103676 => {
             name => 'Провинция Ардахан', 
             ua_name => 'Ардахан', 
             tr_name => 'Ardahan', 
             ename => 'Ardahan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103677 => {
             name => 'Провинция Артвин', 
             ua_name => 'Артвін', 
             tr_name => 'Artvin', 
             ename => 'Artvin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103678 => {
             name => 'Провинция Афьонкарахисар', 
             ua_name => 'Афьонкарахісар', 
             tr_name => 'Afyonkarahisar', 
             ename => 'Afyonkarahisar',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103679 => {
             name => 'Провинция Байбурт', 
             ua_name => 'Байбурт', 
             tr_name => 'Bayburt', 
             ename => 'Bayburt',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103680 => {
             name => 'Провинция Балыкесир', 
             ua_name => 'Баликесір', 
             tr_name => 'Balıkesir', 
             ename => 'Balikesir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103681 => {
             name => 'Провинция Бартын', 
             ua_name => 'Бартин', 
             tr_name => 'Bartın', 
             ename => 'Bartin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103682 => {
             name => 'Провинция Батман', 
             ua_name => 'Батман', 
             tr_name => 'Batman', 
             ename => 'Batman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103683 => {
             name => 'Провинция Биледжик', 
             ua_name => 'Біледжик', 
             tr_name => 'Bilecik', 
             ename => 'Bilecik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103684 => {
             name => 'Провинция Бингёль', 
             ua_name => 'Бінґель', 
             tr_name => 'Bingöl', 
             ename => 'Bingol',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103685 => {
             name => 'Провинция Битлис', 
             ua_name => 'Бітліс', 
             tr_name => 'Bitlis', 
             ename => 'Bitlis',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103686 => {
             name => 'Провинция Болу', 
             ua_name => 'Болу', 
             tr_name => 'Bolu', 
             ename => 'Bolu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103687 => {
             name => 'Провинция Бурдур', 
             ua_name => 'Бурдур', 
             tr_name => 'Burdur', 
             ename => 'Burdur',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103688 => {
             name => 'Провинция Бурса', 
             ua_name => 'Бурса', 
             tr_name => 'Bursa', 
             ename => 'Bursa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103689 => {
             name => 'Провинция Ван', 
             ua_name => 'Ван', 
             tr_name => 'Van', 
             ename => 'Van',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        10369 => {
             name => 'Белая Церковь', 
             ua_name => 'Біла Церква', 
             tr_name => 'Belaya Tserkov', 
             ename => 'Bila Tserkva',             
             media => 0, 
             geo_flag => 1, 
             level => 4, 
             type => 6,             
             parents => [ 0, 166, 187, 20544 ], 
             childs => [  ], 
        },
        
        103690 => {
             name => 'Провинция Газиантеп', 
             ua_name => 'Газіантеп', 
             tr_name => 'Gaziantep', 
             ename => 'Gaziantep',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103691 => {
             name => 'Провинция Гиресун', 
             ua_name => 'Гіресун', 
             tr_name => 'Giresun', 
             ename => 'Giresun',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103692 => {
             name => 'Провинция Гюмюшхане', 
             ua_name => 'Ґюмюшхане', 
             tr_name => 'Gümüşhane', 
             ename => 'Gumushane',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103693 => {
             name => 'Провинция Денизли', 
             ua_name => 'Денізлі', 
             tr_name => 'Denizli', 
             ename => 'Denizli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103694 => {
             name => 'Провинция Диярбакыр', 
             ua_name => 'Діярбакир', 
             tr_name => 'Diyarbakır', 
             ename => 'Diyarbakir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103695 => {
             name => 'Провинция Дюздже', 
             ua_name => 'Дюздже', 
             tr_name => 'Düzce', 
             ename => 'Duzce',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103696 => {
             name => 'Провинция Зонгулдак', 
             ua_name => 'Зонгулдак', 
             tr_name => 'Zonguldak', 
             ename => 'Zonguldak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103697 => {
             name => 'Провинция Измир', 
             ua_name => 'Ізмір', 
             tr_name => 'İzmir', 
             ename => 'Izmir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103698 => {
             name => 'Провинция Йозгат', 
             ua_name => 'Йозгат', 
             tr_name => 'Yozgat', 
             ename => 'Yozgat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103699 => {
             name => 'Провинция Кайсери', 
             ua_name => 'Кайсері', 
             tr_name => 'Kayseri', 
             ename => 'Kayseri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103700 => {
             name => 'Провинция Карабюк', 
             ua_name => 'Карабюк', 
             tr_name => 'Karabük', 
             ename => 'Karabuk',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103701 => {
             name => 'Провинция Караман', 
             ua_name => 'Караман', 
             tr_name => 'Karaman', 
             ename => 'Karaman',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103702 => {
             name => 'Провинция Карс', 
             ua_name => 'Карс', 
             tr_name => 'Kars', 
             ename => 'Kars',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103703 => {
             name => 'Провинция Кастамону', 
             ua_name => 'Кастамону', 
             tr_name => 'Kastamonu', 
             ename => 'Kastamonu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103704 => {
             name => 'Провинция Кахраманмараш', 
             ua_name => 'Кахраманмараш', 
             tr_name => 'Kahramanmaraş', 
             ename => 'Kahramanmaras',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103705 => {
             name => 'Провинция Килис', 
             ua_name => 'Кіліс', 
             tr_name => 'Kilis', 
             ename => 'Kilis',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103706 => {
             name => 'Провинция Коджаэли', 
             ua_name => 'Коджаелі', 
             tr_name => 'Kocaeli', 
             ename => 'Kocaeli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103707 => {
             name => 'Провинция Конья', 
             ua_name => 'Конья', 
             tr_name => 'Konya', 
             ename => 'Konya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103708 => {
             name => 'Провинция Кыркларели', 
             ua_name => 'Киркларелі', 
             tr_name => 'Kırklareli', 
             ename => 'Kirklareli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103709 => {
             name => 'Провинция Кыршехир', 
             ua_name => 'Киршехір', 
             tr_name => 'Kırşehir', 
             ename => 'Kirsehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103710 => {
             name => 'Провинция Кырыккале', 
             ua_name => 'Кириккале', 
             tr_name => 'Kırıkkale', 
             ename => 'Kirikkale',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103711 => {
             name => 'Провинция Кютахья', 
             ua_name => 'Кютах\'я', 
             tr_name => 'Kütahya', 
             ename => 'Kutahya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103712 => {
             name => 'Провинция Малатья', 
             ua_name => 'Малатья', 
             tr_name => 'Malatya', 
             ename => 'Malatya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103713 => {
             name => 'Провинция Маниса', 
             ua_name => 'Маніса', 
             tr_name => 'Manisa', 
             ename => 'Manisa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103714 => {
             name => 'Провинция Мардин', 
             ua_name => 'Мардін', 
             tr_name => 'Mardin', 
             ename => 'Mardin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103715 => {
             name => 'Провинция Мерсин', 
             ua_name => 'Мерсін', 
             tr_name => 'Mersin', 
             ename => 'Mersin',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103716 => {
             name => 'Провинция Мугла', 
             ua_name => 'Муґла', 
             tr_name => 'Muğla', 
             ename => 'Mugla',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103717 => {
             name => 'Провинция Муш', 
             ua_name => 'Муш', 
             tr_name => 'Muş', 
             ename => 'Mus',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103718 => {
             name => 'Провинция Невшехир', 
             ua_name => 'Невшехір', 
             tr_name => 'Nevşehir', 
             ename => 'Nevsehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103719 => {
             name => 'Провинция Нигде', 
             ua_name => 'Ніґде', 
             tr_name => 'Niğde', 
             ename => 'Nigde',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103720 => {
             name => 'Провинция Орду', 
             ua_name => 'Орду', 
             tr_name => 'Ordu', 
             ename => 'Ordu',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103721 => {
             name => 'Провинция Османие', 
             ua_name => 'Османіє', 
             tr_name => 'Osmaniye', 
             ename => 'Osmaniye',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103722 => {
             name => 'Провинция Ризе', 
             ua_name => 'Різе', 
             tr_name => 'Rize', 
             ename => 'Rize',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103723 => {
             name => 'Провинция Сакарья', 
             ua_name => 'Сакар\'я', 
             tr_name => 'Sakarya', 
             ename => 'Sakarya',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103724 => {
             name => 'Провинция Самсун', 
             ua_name => 'Самсун', 
             tr_name => 'Samsun', 
             ename => 'Samsun',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103725 => {
             name => 'Провинция Сивас', 
             ua_name => 'Сівас', 
             tr_name => 'Sivas', 
             ename => 'Sivas',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103726 => {
             name => 'Провинция Сиирт', 
             ua_name => 'Сіїрт', 
             tr_name => 'Siirt', 
             ename => 'Siirt',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103727 => {
             name => 'Провинция Синоп', 
             ua_name => 'Сіноп', 
             tr_name => 'Sinop', 
             ename => 'Sinop',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103728 => {
             name => 'Провинция Стамбул', 
             ua_name => 'Стамбул', 
             tr_name => 'İstanbul', 
             ename => 'Istanbul',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103729 => {
             name => 'Провинция Текирдаг', 
             ua_name => 'Текірдаг', 
             tr_name => 'Tekirdağ', 
             ename => 'Tekirdag',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103730 => {
             name => 'Провинция Токат', 
             ua_name => 'Токат', 
             tr_name => 'Tokat', 
             ename => 'Tokat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103731 => {
             name => 'Провинция Трабзон', 
             ua_name => 'Трабзон', 
             tr_name => 'Trabzon', 
             ename => 'Trabzon',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103732 => {
             name => 'Провинция Тунджели', 
             ua_name => 'Тунджелі', 
             tr_name => 'Tunceli', 
             ename => 'Tunceli',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103733 => {
             name => 'Провинция Ушак', 
             ua_name => 'Ушак', 
             tr_name => 'Uşak', 
             ename => 'Usak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103734 => {
             name => 'Провинция Хаккяри', 
             ua_name => 'Хаккярі', 
             tr_name => 'Hakkari', 
             ename => 'Hakkari',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103735 => {
             name => 'Провинция Хатай', 
             ua_name => 'Хатай', 
             tr_name => 'Hatay', 
             ename => 'Hatay',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103736 => {
             name => 'Провинция Чанаккале', 
             ua_name => 'Чанаккале', 
             tr_name => 'Çanakkale', 
             ename => 'Canakkale',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103737 => {
             name => 'Провинция Чанкыры', 
             ua_name => 'Чанкири', 
             tr_name => 'Çankırı', 
             ename => 'Cankiri',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103738 => {
             name => 'Провинция Чорум', 
             ua_name => 'Чорум', 
             tr_name => 'Çorum', 
             ename => 'Corum',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103739 => {
             name => 'Провинция Шанлыурфа', 
             ua_name => 'Шанлиурфа', 
             tr_name => 'Şanlıurfa', 
             ename => 'Sanliurfa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103740 => {
             name => 'Провинция Ширнак', 
             ua_name => 'Ширнак', 
             tr_name => 'Şırnak', 
             ename => 'Sirnak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103741 => {
             name => 'Провинция Ыгдыр', 
             ua_name => 'Игдир', 
             tr_name => 'Iğdır', 
             ename => 'Igdir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103742 => {
             name => 'Провинция Ыспарта', 
             ua_name => 'Испарта', 
             tr_name => 'Isparta', 
             ename => 'Isparta',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103743 => {
             name => 'Провинция Эдирне', 
             ua_name => 'Едірне', 
             tr_name => 'Edirne', 
             ename => 'Edirne',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103744 => {
             name => 'Провинция Элязыг', 
             ua_name => 'Елязиг', 
             tr_name => 'Elazığ', 
             ename => 'Elazig',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103745 => {
             name => 'Провинция Эрзинджан', 
             ua_name => 'Ерзінджан', 
             tr_name => 'Erzincan', 
             ename => 'Erzincan',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103746 => {
             name => 'Провинция Эрзурум', 
             ua_name => 'Ерзурум', 
             tr_name => 'Erzurum', 
             ename => 'Erzurum',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103747 => {
             name => 'Провинция Эскишехир', 
             ua_name => 'Ескішехір', 
             tr_name => 'Eskişehir', 
             ename => 'Eskisehir',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103748 => {
             name => 'Провинция Ялова', 
             ua_name => 'Ялова', 
             tr_name => 'Yalova', 
             ename => 'Yalova',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 983 ], 
             childs => [  ], 
        },
        
        103750 => {
             name => 'Свободное государство Бавария', 
             ua_name => 'Вільна держава Баварія', 
             tr_name => 'Bavyera', 
             ename => 'Free State of Bavaria',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 96 ], 
             childs => [ 101738 ], 
        },
        
        103900 => {
             name => 'Центральный АО', 
             ua_name => 'Центральний АО', 
             tr_name => 'Merkez', 
             ename => 'Central District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 116114 ], 
        },
        
        103901 => {
             name => 'Хайфский АО', 
             ua_name => 'Хайфський АО', 
             tr_name => 'Hayfa Bölgesi', 
             ename => 'Haifa District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 132 ], 
        },
        
        103904 => {
             name => 'Южный АО', 
             ua_name => 'Південний АО', 
             tr_name => 'Güney\'de', 
             ename => 'Southern District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 100944 ], 
        },
        
        103905 => {
             name => 'Тель-Авивский АО', 
             ua_name => 'Тель-Авівський АО', 
             tr_name => 'Tel Aviv Bölgesi', 
             ename => 'Tel Aviv District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 183, 181 ], 
             childs => [ 131 ], 
        },
        
        10391 => {
             name => 'Кембридж', 
             ua_name => 'Кембридж', 
             tr_name => 'Cambridge', 
             ename => 'Cambridge',             
             media => 0, 
             geo_flag => 0, 
             level => 6, 
             type => 6,             
             parents => [ 0, 111, 102, 104520, 104584, 104612 ], 
             childs => [  ], 
        },
        
        104260 => {
             name => 'Вильнюсский уезд', 
             ua_name => 'Вільнюський повіт', 
             tr_name => 'Vilnius Vilayeti', 
             ename => 'Vilnius County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 117 ], 
             childs => [ 11475 ], 
        },
        
        104357 => {
             name => 'Уусимаа', 
             ua_name => 'Уусімаа', 
             tr_name => 'Uusimaa', 
             ename => 'Uusimaa',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 123 ], 
             childs => [ 10493 ], 
        },
        
        104430 => {
             name => 'Тартумаа', 
             ua_name => 'Тартумаа', 
             tr_name => 'Tartu Vilayeti', 
             ename => 'Tartu County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 179 ], 
             childs => [ 11482 ], 
        },
        
        104431 => {
             name => 'Харьюмаа', 
             ua_name => 'Гар\'юмаа', 
             tr_name => 'Harju Vilayeti', 
             ename => 'Harju County',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 179 ], 
             childs => [ 11481 ], 
        },
        
        104492 => {
             name => 'Округ Белград', 
             ua_name => 'Округ Белград', 
             tr_name => 'Belgrad Bölgesi', 
             ename => 'Belgrade District',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 111, 180 ], 
             childs => [ 10522 ], 
        },
        
        104520 => {
             name => 'Англия', 
             ua_name => 'Англія', 
             tr_name => 'İngiltere', 
             ename => 'England',             
             media => 1, 
             geo_flag => 0, 
             level => 3, 
             type => 4,             
             parents => [ 0, 111, 102 ], 
             childs => [ 104584 ], 
        },
        
        104584 => {
             name => 'Восточная Англия', 
             ua_name => 'Східна Англія', 
             tr_name => 'Doğu İngiltere', 
             ename => 'East of England',             
             media => 1, 
             geo_flag => 0, 
             level => 4, 
             type => 2,             
             parents => [ 0, 111, 102, 104520 ], 
             childs => [ 104612 ], 
        },
        
        104612 => {
             name => 'Графство Кембриджшир', 
             ua_name => 'Графство Кембриджшир', 
             tr_name => 'Cambridgeshire County', 
             ename => 'Cambridgeshire County',             
             media => 0, 
             geo_flag => 0, 
             level => 5, 
             type => 5,             
             parents => [ 0, 111, 102, 104520, 104584 ], 
             childs => [ 10391 ], 
        },
        
        10493 => {
             name => 'Хельсинки', 
             ua_name => 'Хельсінкі', 
             tr_name => 'Helsinki', 
             ename => 'Helsinki',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 123, 104357 ], 
             childs => [  ], 
        },
        
        10522 => {
             name => 'Белград', 
             ua_name => 'Белград', 
             tr_name => 'Belgrad', 
             ename => 'Belgrade',             
             media => 0, 
             geo_flag => 0, 
             level => 4, 
             type => 6,             
             parents => [ 0, 111, 180, 104492 ], 
             childs => [  ], 
        },
        
        10540 => {
             name => 'Саудовская Аравия', 
             ua_name => 'Саудівська Аравія', 
             tr_name => 'Suudi Arabistan', 
             ename => 'Saudi Arabia',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 183 ], 
             childs => [  ], 
        },
        
        1056 => {
             name => 'Египет', 
             ua_name => 'Єгипет', 
             tr_name => 'Mısır', 
             ename => 'Egypt',             
             media => 1, 
             geo_flag => 0, 
             level => 2, 
             type => 3,             
             parents => [ 0, 241 ], 
             childs => [  ], 
        },
        
        105789 => {
             name => 'Область Арагацотн', 
             ua_name => 'Область Арагацотн', 
             tr_name => 'Aragatsotn', 
             ename => 'Aragatsotn',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105790 => {
             name => 'Область Арарат', 
             ua_name => 'Область Арарат', 
             tr_name => 'Ararat', 
             ename => 'Ararat',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105791 => {
             name => 'Область Армавир', 
             ua_name => 'Область Армавір', 
             tr_name => 'Armavir Bölgesi (Armenia)', 
             ename => 'Armavir (Armenia)',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105792 => {
             name => 'Область Гехаркуник', 
             ua_name => 'Область Гехаркунік', 
             tr_name => 'Geğarkunik', 
             ename => 'Gegharkunik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105793 => {
             name => 'Область Котайк', 
             ua_name => 'Область Котайк', 
             tr_name => 'Kotayk', 
             ename => 'Kotayk',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105794 => {
             name => 'Область Лори', 
             ua_name => 'Область Лорі', 
             tr_name => 'Lori', 
             ename => 'Lori',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [ 10258 ], 
        },
        
        105795 => {
             name => 'Область Ширак', 
             ua_name => 'Область Ширак', 
             tr_name => 'Şirak', 
             ename => 'Shirak',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [ 10259 ], 
        },
        
        105796 => {
             name => 'Область Сюник', 
             ua_name => 'Область Сюнік', 
             tr_name => 'Sünik', 
             ename => 'Syunik',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105797 => {
             name => 'Область Тавуш', 
             ua_name => 'Область Тавуш', 
             tr_name => 'Tavuş', 
             ename => 'Tavush',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        105798 => {
             name => 'Область Вайоц-Дзор', 
             ua_name => 'Область Вайоц-Дзор', 
             tr_name => 'Vayots Dzor', 
             ename => 'Vayots Dzor',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 168 ], 
             childs => [  ], 
        },
        
        1058 => {
             name => 'Туапсе', 
             ua_name => 'Туапсе', 
             tr_name => 'Tuapse', 
             ename => 'Tuapse',             
             media => 0, 
             geo_flag => 1, 
             level => 5, 
             type => 6,             
             parents => [ 0, 225, 26, 10995, 99299 ], 
             childs => [  ], 
        },
        
        105804 => {
             name => 'Андижанская область', 
             ua_name => 'Андижанська область', 
             tr_name => 'Andican eyaleti', 
             ename => 'Andijan Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10329 ], 
        },
        
        105805 => {
             name => 'Бухарская область', 
             ua_name => 'Бухарська область', 
             tr_name => 'Buhara eyaleti', 
             ename => 'Bukhara Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10330 ], 
        },
        
        105806 => {
             name => 'Джизакская область', 
             ua_name => 'Джиззацька область', 
             tr_name => 'Cizzak eyaleti', 
             ename => 'Jizzakh Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21606 ], 
        },
        
        105807 => {
             name => 'Кашкадарьинская область', 
             ua_name => 'Кашкадар\'їнська область', 
             tr_name => 'Kaşkaderya eyaleti', 
             ename => 'Qashqadaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10331, 101761 ], 
        },
        
        105808 => {
             name => 'Навоийская область', 
             ua_name => 'Навоїйська область', 
             tr_name => 'Nevai eyaleti', 
             ename => 'Navoiy Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21947 ], 
        },
        
        105809 => {
             name => 'Наманганская область', 
             ua_name => 'Наманганська область', 
             tr_name => 'Nemengan eyaleti', 
             ename => 'Namangan Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21314 ], 
        },
        
        105810 => {
             name => 'Самаркандская область', 
             ua_name => 'Самаркандська область', 
             tr_name => 'Semerkant eyaleti', 
             ename => 'Samarqand Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10334 ], 
        },
        
        105811 => {
             name => 'Сурхандарьинская область', 
             ua_name => 'Сурхандар\'їнська область', 
             tr_name => 'Surhanderya eyaleti', 
             ename => 'Surxondaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10338, 196979 ], 
        },
        
        105812 => {
             name => 'Сырдарьинская область', 
             ua_name => 'Сирдар\'їнська область', 
             tr_name => 'Siriderya eyaleti', 
             ename => 'Sirdaryo Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [  ], 
        },
        
        105813 => {
             name => 'Ташкентская область', 
             ua_name => 'Ташкентська область', 
             tr_name => 'Taşkent eyaleti', 
             ename => 'Tashkent Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10328, 101524, 114900, 189657 ], 
        },
        
        105814 => {
             name => 'Ферганская область', 
             ua_name => 'Ферганська область', 
             tr_name => 'Fergana eyaleti', 
             ename => 'Fergana Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 10332, 10336, 101425 ], 
        },
        
        105815 => {
             name => 'Хорезмская область', 
             ua_name => 'Хорезмська область', 
             tr_name => 'Harezm eyaleti', 
             ename => 'Xorazm Province',             
             media => 0, 
             geo_flag => 0, 
             level => 3, 
             type => 5,             
             parents => [ 0, 166, 171 ], 
             childs => [ 21105 ], 
        },
        
        105816 => {
             name => 'Республика Каракалпакстан', 
             ua_name => 'Республіка Каракалпакстан', 
             tr_name => 'Karakalpakistan', 
             ename => 'Republic of Karakalpakstan',             
             media