#!/usr/bin/perl

=pod
    $Id$
    Обновление YaCatalog.pm, генерация YaCatalogLite
    Скачиваем из-под пользователя ppc файл, проверяем, записываем
=cut

use strict;
use warnings;
use File::Slurp;
use Fatal qw/rename/;

use Data::Dumper;
$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent = 1;

my $RSYNC = '/usr/bin/rsync';
my $LIB_ROOT = '/usr/local/lib/site_perl';
my $SOURCE = 'ppcbrasero-proxy.yandex.ru::yaca/current/cat';

# проверка аргументов
if (@ARGV == 1 && $ARGV[0] eq 'init') {
    # если идёт начальная инициализация и файл уже есть - ничего не делаем
    exit if -f "$LIB_ROOT/YaCatalog.pm" && -f "$LIB_ROOT/YaCatalogu.pm" && -f "$LIB_ROOT/YaCatalogLite.pm";
} elsif (@ARGV && (@ARGV != 1 || $ARGV[0] ne 'update')) {
    die "Usage: $0 [init|update]";
}

# скачиваем файл
my $tmpfile = "/tmp/get_yacatalog.$$.tmp";
system("$RSYNC $SOURCE/YaCatalog.pm $tmpfile") == 0
    or die "$RSYNC execution failed: $?";

# скачиваем файл utf8
my $tmpfile_u = "/tmp/get_yacatalogu.$$.tmp";
system("$RSYNC $SOURCE/YaCatalogu.pm $tmpfile_u") == 0
    or die "$RSYNC execution failed: $?";

do $tmpfile_u;

# генерируем файл YaCatalogLite
my $tmpfile_lite = "/tmp/get_yacatalog_lite.$$.tmp";
# фильтруем из YaCatalog только то, что надо, оставляя общую структуру
my %Trees = (
    'cat' => filter_yaca_hash($YaCatalog::Trees{cat}, [qw/path url_name name hide short_engl_name/]),
    );

# создаём текст модуля
my $text = "package YaCatalogLite;

# This file generated from YaCatalogu.pm by $0 at ".scalar(localtime)."

use strict;
use warnings;

use utf8;

our ".Data::Dumper->Dump([\%Trees], ['*Trees'])."

1;
";
# заменяем \x{443} на буквы
$text =~ s/\\x\{([\da-f]{3})\}/chr hex $1/ige;
write_file($tmpfile_lite, {binmode => ":utf8"}, $text);

# проверяем все файлы
eval {
    for my $file ($tmpfile, $tmpfile_u, $tmpfile_lite) {
        %YaCatalog::Trees = %YaCatalogLite::Trees = ();
        do $file;
        %YaCatalog::Trees = %YaCatalogLite::Trees if !%YaCatalog::Trees;
        $YaCatalog::Trees{cat} ||= {};
        my $rubnum = scalar keys %{ $YaCatalog::Trees{cat} }; 
        die "I think, file $file is not complete... Only $rubnum rubrics...\n" if $rubnum < 1000;
    }
};
die $@ if $@;

# записываем файл
write_file("$LIB_ROOT/YaCatalog.pm.tmp", read_file($tmpfile));
write_file("$LIB_ROOT/YaCatalogu.pm.tmp", read_file($tmpfile_u));
write_file("$LIB_ROOT/YaCatalogLite.pm.tmp", read_file($tmpfile_lite));
rename("$LIB_ROOT/YaCatalog.pm.tmp", "$LIB_ROOT/YaCatalog.pm");
rename("$LIB_ROOT/YaCatalogu.pm.tmp", "$LIB_ROOT/YaCatalogu.pm");
rename("$LIB_ROOT/YaCatalogLite.pm.tmp", "$LIB_ROOT/YaCatalogLite.pm");
unlink($tmpfile);
unlink($tmpfile_u);
unlink($tmpfile_lite);

sub filter_yaca_hash {
    my ($hash, $keys) = @_;
    my %RES;
    while(my ($id, $val) = each %$hash) {
        my %data;
        for my $key (@$keys) {
            $data{$key} = $val->{$key} if exists $val->{$key};
        }
        $RES{$id} = \%data;
    }
    return \%RES;
}

