#!/usr/bin/perl

use my_inc "../..";


use strict;
use warnings;

=head1 

    тестовый клиент для запросов к ServiceSOAP

    ./protected/maintenance/ServiceSOAP_client.pl -b 8802 -m setAutobudgetShowStatus --cid_min 1000
    ./protected/maintenance/ServiceSOAP_client.pl -b 8802 -m setAutobudgetShowStatus --pid 1670
    ./protected/maintenance/ServiceSOAP_client.pl -b 8802 -m setAutobudgetShowStatus --pid 1670 --pid 2604
    m dt:ppc 'select p.statusAutobudgetShow, p.pid, cid from phrases p where p.pid in (2601, 1670, 2604)'


    TODO: захардкожено beta1.direct.yandex.ru. Надо или по порту определять или параметром задавать.

=cut


use Data::Dumper;
use SOAP::Lite;

use Yandex::DBTools;
use Yandex::HashUtils;

use Settings;
use ScriptHelper;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $actions = {

    setAutobudgetShowStatus => {
        prepare_data => sub {
            my ($O) = @_;

            my $cond = hash_merge {
                'c.autobudget' => 'Yes',
            }, make_condition($O, [qw/cid cid_min pid pid_min/]);


            my $p = get_all_sql(PPC, 
                ["select p.pid,  
                         c.cid, p.statusAutobudgetShow
                 from phrases p
                     join campaigns c on c.cid = p.cid
                     ",
                 where => $cond,
                 limit => 5
                 ]) || [];

            # меняем statusAutobudgetShow на противоположный
            my %data = map { 
                $_->{pid} => !($_->{statusAutobudgetShow} eq "Yes" ? 1: 0) 
            } @$p;



            return {
                raw_data => $p,
                prepared_data =>[ \%data],
            };
        },
        process_result => sub {
            my ($O, $data, $result) = @_;

            return get_all_sql(PPC, 
                ["select p.pid, c.cid, p.statusAutobudgetShow
                 from phrases p
                     join campaigns c on c.cid = p.cid
                     ",
                 where => {pid => [keys %{$data->{prepared_data}->[0]}]}
                 ]
            );
        }
    },

    someMethod => {
        prepare_data => sub {
            my ($O) = @_;

            return {};
        },
        process_result => sub {
            my ($O, $data, $result) = @_;

            return [];
        }
    },
};

my $cond_fields = {
    cid => 'c.cid',
    cid_min => 'c.cid__gt',
    pid => 'p.pid',
    pid_min => 'p.pid__gt',
};

run() unless caller();

sub run
{
    $Data::Dumper::Sortkeys = 1;
    $Data::Dumper::Indent = 1;

    my $O = parse_options();

    my $method = $O->{method};
    my $beta = $O->{beta};

    print STDERR "beta $beta, method $method\n";

    my $data = $actions->{$method}->{prepare_data}->($O);

    print "data:\n".Dumper($data);


    my $result = SOAP::Lite->new(
        proxy => "http://$beta.beta1.direct.yandex.ru/soap"
    )->uri("ServiceSOAP")
    ->call($method => @{$data->{prepared_data}}
    )->result;

    print "result:\n".Dumper($result);

    my $processed = $actions->{$method}->{process_result}->($O,$data, $result);

    print "postprocessed result:\n".Dumper($processed);

    exit();
}

sub parse_options
{

    my %O;

    extract_script_params(
        "m|method=s"  => \$O{method},
        "b|beta=i"    => \$O{beta},

        "cid=i@"      => \$O{cid},
        "cid_min=i"   => \$O{cid_min},
        "pid=i@"      => \$O{pid},
        "pid_min=i"   => \$O{pid_min},
    );

    $O{method} or die "undefined method";
    $O{beta} or die "undefined beta";

    return \%O;
}


sub make_condition
{
    my ($O, $fields) = @_;

    my $cond = {};

    for my $f (@$fields){
        die "$f" if !exists $cond_fields->{$f};
        $cond->{$cond_fields->{$f}} = $O->{$f} if defined $O->{$f};
    }

    return $cond;
}
