#!/usr/bin/perl

use my_inc "../..";


=pod
    
    $Id$

    Скрипт для отладки Профи-Баблометра 
    (расставляем отладочные печати в perl- и js-коде и дергаем расчет с какими удобно параметрами). 

    Чтобы работала отладочная печать из js, в Yandex::ExecuteJS надо снять комментарий со строчки
    $cx->bind_function(write => sub {print STDERR "js write: ", @_, "\n";});

    Параметров у скрипта нет, фразы/категории/настройки надо вписывать в код.

    multicurrency: работает только с у.е.
    
=cut

use strict;
use warnings;

use ScriptHelper;

use Settings;
use Forecast::Autobudget;
use Yandex::ExecuteJS;
use DirectCache;


use utf8;
use open ':std' => ':utf8';

my $direct_cache = new DirectCache(groups => ['forecast_db_queries']);
$Settings::BS_RANK_PARALLEL_LEVEL = 15;



main();

#....................................................................


sub main
{
    #my $phrases = "кредит наличными, кредит";
    #my $phrases = "техобслуживание кондиционеров,доставка суши,пластиковые окна,автокредит, окна, кондиционер, кредит";
    #my $phrases = "окна, кондиционер, кредит, елка живая";
    #my $phrases = "кондиционер";
    #my $phrases = "доставка пиццы";
    #my $phrases = "696";
    #my $phrases = "";
    my $phrases = "пицца, доставка пиццы, заказ пиццы, пицца на дом, заказать пиццу, pizza, доставка пиццы дом, бесплатная доставка пиццы, пиццерия, заказ пиццы дом, доставка пицы, заказ пицы, доставка еды, пицца круглосуточно, круглосуточная доставка пиццы, пица, доставка пиццы спб, заказ еды, заказать пиццу на дом, пицца спб, доставка пиццы круглосуточно, заказ еды на дом, доставка пиццы санкт петербург, заказ пиццы круглосуточно, пицца санкт петербург";
=for none
    my $phrases = "
заказ компьютеров,
интернет магазин компьютеров,
компьютер -покупать магазин -цена -заказ -продажа -интернет,
компьютер цена,
купить компьютер,
магазин компьютеров -интернет,
монитор,
ноутбук,
продажа компьютеров
";
=cut
    #my $phrases = "авто,авто с пробегом,автомобили и цены,автомобиль,авторынок,из рук в руки авто,иномарки,купить авто,купить автомобиль,купить машину,куплю авто,подержанные авто,подержанные автомобили,покупка автомобиля,продажа авто,продажа автомобилей,продажа машин";
    #my $phrases="шоколад, конфеты, кондитерские изделия,кондитерские изделия оптом, производители кондитерских изделий, продажа кондитерских изделий, торговля кондитерскими изделиями, кондитерка, конфеты оптом, кондитерское производство, оптовая продажа кондитерских изделий";
    #my $minus_words = "поручителей";
    my $geo = 0;

    #my $categories_str = "696,3173,108,10896,10876,10898,10899,10900,10879,413,103,11363";
    #my $categories_str = "696,3173,108,10896";
    my $categories_str = "";
    my $categories = [split m/\s*,\s*/, $categories_str]; 

    $phrases =~ s/^\s*//;
    $phrases =~ s/\s*$//;
    my @src_phrases = split(/\s*[,\n]+\s*/,($phrases||'')); 

    my $conv_unit_rate = 1;
    my $currency = 'YND_FIXED';
    my $opts = {
        cid => 0,       
        purpose => 'advanced_forecast', 
        #purpose => 'slider', 
        phrases=>\@src_phrases,
        categories => $categories,
        phrases_geo => $geo,
        conv_unit_rate => $conv_unit_rate, 
        consider_sitelinks_ctr => 1,
        #period => 'month',
        #advanced_period => {month => 12},
        #advanced_period => {year => 1},
#        minus_words => [split ',', $minus_words],
        currency => $currency,
    };

    my $moneymeter_data = get_moneymeter_data($opts);
    
    #print Dumper_rus($categories);
    #print Dumper_rus($moneymeter_data);
    #print Dumper_rus($moneymeter_data->{data_by_positions});
    #die;

    my $restrictions = {

        #type => 'clicks',
        #type => 'cpc',
        sum  => 6075,
        type => 'sum',
        #type => 'unlim',
        #type => 'cent1',
        clicks => 74000,
        cpc => 0.89,
    };

    my $options = {
        context => 1,
        context_sum_coef => -1, 
        context_price_coef => 1, 
        broadmatch => 0,
        bm_sum_coef => 100,
    };
    delete $moneymeter_data->{key2phrase};
    delete $moneymeter_data->{phrase2key};
    #delete $moneymeter_data->{data_by_positions_old};
    my $B = call_js($Settings::JS_PERL_DIR.'/AdvancedForcast-p.js', "calc_advanced_forecast_p", 
        [$moneymeter_data, $conv_unit_rate, $restrictions, $options, $currency]
    );
    delete $B->{yandex};
    print Dumper_rus($restrictions, $B);
       
    #print Dumper_rus($moneymeter_data);
    my $B2 = call_js($Settings::JS_PERL_DIR.'/AdvancedForcast-p.js', "advanced_forecast_by_positions_p", 
        [$moneymeter_data, $options, {'1f4473547e71e1fb4fb470db5b4fb8ad' => 'first_place'}]
    );

    print Dumper_rus($B2);
}

sub Dumper_rus
{
    my $text = Dumper(@_);
    $text =~ s/\\x\{([\da-f]{2,3})\}/chr hex $1/ige;
    $text =~ s/\&/&amp;/g;
    return $text;
}

