#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

alive.pl

=head1 SYNOPSIS

    alive.pl -f /var/www/ppc.yandex.ru/data/soap-root/alive --max-age 20 -u http://localhost:1480 -t 10
    alive.pl -f /var/www/ppc.yandex.ru/data/soap-root/alive --max-age 20 -monrun

Аргументы: имя файла и маскимальное время жизни файла

=head1 DESCRIPTION

Запрашиваем переданный урл с таймаутом, обновляем файл на диске.
Если файл устарел, удаляем его.

=cut

use strict;
use warnings;

use lib::abs '..';
use Settings;
use ScriptHelper get_file_lock => undef, script_timer => undef;
use File::Slurp;
use File::Touch;
use Yandex::HTTP;
use Yandex::SendMail;


my ($ALIVE_FILE, $MAX_AGE, $MONRUN, $TIMEOUT, $URL);
extract_script_params(
    'file=s' => \$ALIVE_FILE,
    'max-age=i' => \$MAX_AGE,
    'monrun' => \$MONRUN,
    'timeout=i' => \$TIMEOUT,
    'url=s' => \$URL,
);

if ($MONRUN) {
    monrun($ALIVE_FILE, $MAX_AGE);
    exit;
}

while (1) {
    if (-f $ALIVE_FILE && is_file_old($ALIVE_FILE, $MAX_AGE)) {
        remove_file($ALIVE_FILE);
    }
    my $result;
    eval {
        $SIG{ALRM} = sub {die "timeout"};
        alarm $TIMEOUT;
        $result = http_get($URL);
        alarm 0;
    };
    if ($@) {
        error("check failed: $@");
    }
    if ($result) {
        renew_file($ALIVE_FILE, $result);
    } else {
        remove_file($ALIVE_FILE);
    }
    sleep 1;
}


sub error
{
    my $message = shift;
    send_alert($message, "alive check");
    exit 2;
}


sub is_file_old
{
    my ($file, $max_age) = @_;
    return time - (stat($file))[9] > $max_age;
}


sub monrun
{
    my ($file, $max_age) = @_;
    if (!-f $file) {
        print "2;alive file is absent";
    } elsif (is_file_old($file, $max_age)) {
        print "2;alive file too old";
    } else {
        my ($content, $rest) = read_file($file, chomp => 1); # защищаемся от перевода строки
        if ($content eq 'ok' && not defined $rest) {
            print "0;OK";
        } else {
            print "2;alive file doesn't contain 'ok'";
        }
    }
}


sub remove_file
{
    my $file = shift;
    if (-e $file) {
        unlink $file or error("Couldn't unlink file $file: $!");
    }
}


sub renew_file
{
    my ($file, $content) = @_;
    my $previous_content = -f $file ? read_file($file) : '';
    eval {
        if ($content eq $previous_content) {
            touch $file;
        } else {
            write_file($file, {atomic => 1}, $content);
        }
    };
    if ($@) {
        error("Couldn't renew file $file: $@");
    }
}
