#!/usr/bin/perl

use my_inc "../..";


=c
    $Id $
    Тестовый скрипт для работы с API к Директу.
    
    perl api_client.pl --cmd=НАЗВАНИЕ_МЕТОДА [--debug] [--beta]
    
    debug - включает вывод в OUTPUT xml запроса/ответа
    beta - делает запрос на бету API/ иначе на production

=cut

use warnings;
use strict;

use SOAP::Lite;
use LWP::Simple;
use Crypt::SSLeay;

use YAML::Syck;
use Time::HiRes;
use Text::Iconv;
use Getopt::Long;

my $conv = new Text::Iconv('cp1251', 'utf8');
$YAML::Syck::ImplicitUnicode = 1;

=head2 Авторизация скрипта

    Авторизация осуществляется на основе сертификата, выданного Центром Сертификации Яндекс.Директ
    Для этого необходимо инициализировать следующие переменные окружения:

        HTTPS_CERT_FILE - абсолютный путь к пользовательскому сертификату, подписанному Центром Сертификации Яндекс.Директ,
        HTTPS_KEY_FILE - абсолютный путь к файлу с секретным ключом,
        HTTPS_CA_FILE - абсолютный путь к Директ CA файлу, которым подписан пользовательский сертификат,
        HTTPS_CA_DIR - абсолютный путь в каталогу с CA сертификатами.

=cut






# тестовое агентство mirage-agency4
 $ENV{HTTPS_CERT_FILE} = '/home/sergeysl/certs/cert.crt';
 $ENV{HTTPS_KEY_FILE}  = '/home/sergeysl/certs/private.key';

# общие для всех сертификатов данные
$ENV{HTTPS_CA_FILE}   = '/home/sergeysl/certs/cacert.pem';
$ENV{HTTPS_CA_DIR}    = '/home/sergeysl/certs/';

my ($cmd, $beta, $debug) = ('', undef, undef);

GetOptions(
    'cmd=s' => \$cmd,
    'beta' => \$beta,
    'debug' => \$debug,
) || exit(1);

my $soap_options = {
    debug => $debug,
    beta => $beta,
};

my $getPhrasesPriceData = [{
        CampaignID => 987464,
        BannerID => 2051185,
        PhraseID => 23432406,
    }
];

my $updatePricesData = [{
        CampaignID => 635646,
        BannerID => 824972 ,
        PhraseID => 11124877,
        Price => '1.14',
        AutoBroker => 'No',
    },{
        CampaignID => 635646,
        BannerID => 824952,
        PhraseID => 11141888,
        AutoBroker => 'No',
    }
];


my $createNewForecastData = {
    Phrases => [ 'nokia', 
             $conv->convert('кондиционер'), 
             $conv->convert('Яндекс'), 
             $conv->convert('из рук в руки')
           ],
    GeoID => [1,2,-113],
    Categories => [1,2,3]
};

my %CMDS = (
    'GetReportURL'      => 6292,
    'GetReportList'     => {},
    'DeleteReport'      => 6292,
    'GetRegions'        => {},
    'GetRubrics'        => {},    
    'GetBanners'        => {BannerIDS => [2051147]},
    'GetVersion'        => {},
    'PingAPI'           => {Banners => {"login1" => {"FIO" => "Ivanov", "Phone" => "84991234564"}, "login2" => {"FIO" => "Petrov", "Phone" => "84545646"}}},

    'CreateNewForecast' => $createNewForecastData,
    'GetForecastList'   => {},
    'GetForecast'       => 72,
    'DeleteForecastReport' => 72,

    'UpdatePrices'      => $updatePricesData,
    'GetPhrasesPrice'   => $getPhrasesPriceData,

    'GetClientInfo'     => ['sergeysl-agcl', 'sergeysl-agcl2'],     #
    'GetBalance'        => [987370],                                #
    'GetBannersList'    => [987370],                                #
    'GetClientsList'    => {},                                      #
    
    'GetBannerPhrases' => ['2051196'],                              #
    'GetCampaignsList' => ['sergeysl-agcl'],                        #                  
    'CreateOrUpdateCampaign' => {
                                    Login => 'sergeysl-agcl',
                                    CampaignID => undef,
                                    Name => 'API camp: ' . localtime(),
                                    AutoOptimization => 0,
                                    Email => 'sergeysl@yandex-team.ru',
                                    Fio => 'Сергей Лохмачев',
                                    MoneyWarningValue => 20,
                                    SendWarn => 1,
                                    TimeTarget => {
                                        days => [1, 2, 3, 4, 5, 6],
                                        hours => [1, 2,3,4,5,6,7,8,9,10, 11, 12, 13, 15, 17, 22, 23],
                                    },
                                    StartDate => '20080525',
                                    # sms
                                    
                                    SmsSendWarnMoneyOut => 1,
                                    SmsSendModerate     => 1,
                                    SmsSendWarnMoneyIn  => 1,
                                    SmsTimeHourFrom => 1,
                                    SmsTimeMinFrom => 0,
                                    SmsTimeHourTo => 22,
                                    SmsTimeMinTo => 0,
                                },
                             
    StopCampaign      => 987464,
    ResumeCampaign    => 987464,
    ArchiveCampaign   => 987464,
    UnArchiveCampaign => 987464,
    DeleteCampaign    => 987464,
    
    # set banners status
    ModerateBanners  => {cid => 987464, bids => [2051185]},
    StopBanners      => {cid => 987464, bids => [2051185]},
    ResumeBanners    => {cid => 987464, bids => [2051185]},
    ArchiveBanners   => {cid => 987464, bids => [2051185]},
    UnArchiveBanners => {cid => 987464, bids => [2051185]},
    DeleteBanners    => {cid => 987464, bids => [2051185]},
                             
    'CreateOrUpdateBanners' => [
    {
        CampaignID => 987469
        , BannerID => 0
        , Title => 'API title'
        , Text => 'API ban body'
        , Href => 'http://ya.ru/?123'
        , Geo => '2,183,3,5'
        , Phrases => [
            {
                IsRubric => 0
                , Phrase => 'new phras1e'
                , PhraseID => 0
                , AutoBroker => 0
                , Price => 0.11
            },
            {
                IsRubric => 0
                , Phrase => 'this is ph2rase -2'
                , PhraseID => 0
                , AutoBroker => 1
                , Price => 0.11
            },            
        ]

        # contact info
        , ContactInfo => {
              Apart => 2
            , Build => 2
            , City => $conv->convert('Моcква')
            , CityCode => 495
            , ContactEmail => 'sergeysl@yandex-team.ru'
            , ContactPerson => $conv->convert('контактное лицо')
            , Country => $conv->convert('Россия')
            , CountryCode => '+7'
            , ExtraMessage => $conv->convert('подробнее о товаре/услуге')
            , House => '2'
            , ImClient => 'jabber'
            , ImLogin => 'sergeysl@yandex-team.ru'
            , CompanyName => $conv->convert('ФИО2')
            , Phone => '23455'
            , PhoneExt => '223'
            , Street => $conv->convert('улица')
            , WorkTime => '0;4;10;00;18;00;5;6;13;00;16;00'
        }
    },
    ],                                
);

my $result;
my $t = Time::HiRes::time();

if (defined $CMDS{$cmd}) {
    $result = call_method($cmd, $CMDS{$cmd}, $soap_options);
} else {
    die "Method doesn't describe";
}

if ($result) {
    
    if ($cmd eq 'CreateNewForecast') {
        while ( 1 ) {
            print "\nSleep(1) ...\n\n";
            sleep(1);

            my $res = call_method('GetForecast', $result, $soap_options);
            if ($res) {
                print YAML::Syck::Dump($res);
                last;
            }
        }
    } elsif ($cmd eq 'CreateNewReport') {

        my $reportInfo;
        my $counter = 0;

        print "ReportID: $result\n";

        # ждем пока отчет будет создан
        while ((!$reportInfo || $reportInfo->{statusReport} ne 'Done')
                    && $counter++ < 20) {
            print "Sleep(10) ...\n\n";
            sleep(10);
            $reportInfo = call_method('GetReportURL', $result, $soap_options);
        }

        if ($reportInfo->{url}) {
            # выводим отчет в STDOUT
            print "Report url: $reportInfo->{url}\n";
            print "Get report file:\n";
            print get_report( $reportInfo->{url} );
            print "\n";
        } elsif( $counter > 20 ) {
            die "Превышено допустимое количество обращений";
        } else {
            die "Неизвестная ошибка";
        }

    } else {
        print YAML::Syck::Dump($result);
    }
}

print "\nTime processed: ", Time::HiRes::time() - $t, "\n\n";

=head2 call_method(method, data)

    Функция вызывает указанный метод интерфейса программирования приложений Яндекс.Директ ( API )

=cut

sub call_method
{
    my $method_name = shift || return;
    my $method_data = shift;
    my $soap_options = shift;

    my $ltm = Time::HiRes::time();
    print "Call method: $method_name";

    my $soap = SOAP::Lite
        -> uri('API');

    if (defined $soap_options->{debug}) {
        $soap -> on_debug(sub {print join(">\n", split(">", join("", @_)));});
    }

    #if ($soap_options->{beta}) {
        $soap -> proxy('https://beta.direct.yandex.ru:8053/apisoap');
    #} else {
    #   $soap -> proxy('https://soap.direct.yandex.ru/api');
    #}

    my $request = $soap->call($method_name => $method_data);
    printf "(time: %0.4f sec)", Time::HiRes::time() - $ltm; print "\n";
    unless ($request->fault) {
        # в случае успешного выполнения запроса - возвращаем результат
        return $request->result;            
    } else {
        # если возникла ошибка - выводим сообщение в STDERR и завершаем выполнение программы
        print "Error code: ".$request->faultcode.", \nDescribe error: ".$request->faultstring;
        return undef;
    }

    return undef;
}

=head2 get_report(reportURL)

    Фукнкция загружает указанный URL( полученный с помощью метода GetReportURL ) и возвращает содержимое страницы( готовый XML отчет )

=cut

sub get_report
{
    return get(shift);
}
