#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

### Получение токенов

    Справка: 
    http://api.yandex.ru/direct/doc/concepts/auth-token.xml
    http://api.yandex.ru/oauth/doc/dg/tasks/get-oauth-token.xml

    Для отладки можно пользоваться Application ID metallic'a:
    792b078741a3418885efd5832fe8065c

    lena-san-api -- специальный тестовый пользователь, можно использовать 
    token: 53b6cb26771a448e812eb735f2d56b80

### Параметры

    --beta=IIII     -- используемая бета (например 8771)
    --ts1           -- запускать на ТС1
    --ts2           -- запускать на ТС2
    --api-version=V -- версия апи, по умолчанию - 4
    --live          -- использовать live-версию

### Примеры 
 
./protected/maintenance/api_client_json.pl --ts1
./protected/maintenance/api_client_json.pl --ts2
./protected/maintenance/api_client_json.pl --beta 8805
./protected/maintenance/api_client_json.pl --beta=8771 --live

=cut

use warnings;
use strict;

use JSON;

use Getopt::Long;
use LWP::UserAgent;
use Data::Dumper;
$Data::Dumper::Sortkeys = 1;

use utf8;

our $BETA_NO;
our ($TS1, $TS2, $API_VERSION, $LIVE);
our $API_URL;

our %AUTH = (
    login => 'lena-san-api'
    , application_id => '792b078741a3418885efd5832fe8065c'
    , token => '53b6cb26771a448e812eb735f2d56b80'
);

# our %AUTH = (
#     login => 'msa-c23'
#     , application_id => 'ef9eb3be17a146529e27450509e1fba7'
#     , token => 'ad7af2b308a44105b71eb4b1206f4092'
# );

our $CID = 4114909; 



# -----------------------------------------------------------------------------
sub parse_options
{
    GetOptions(
        "beta=s" => \$BETA_NO,
        "ts1" => \$TS1,
        "ts2" => \$TS2,
        "h|help" => \&usage,
        "live" => \$LIVE,
        "api-version=i" => \$API_VERSION,
    ) or die "can't parse options";

    die 'beta or ts1 or ts1 should be specified' unless $BETA_NO || $TS1 || $TS2;

    my $url_version = $API_VERSION ? "v$API_VERSION" : 'v4';
    my $url_live = $LIVE ? "live/" : '';

    if ($BETA_NO) {
        $API_URL = "https://${BETA_NO}.beta.direct.yandex.ru:14443/json-api/$url_version/$url_live";
    } elsif ($TS1) {
        $API_URL = "https://api.test.direct.yandex.ru:14443/json-api/$url_version/$url_live";
    } elsif ($TS2) {
        $API_URL = "https://test2-direct.yandex.ru:14443/json-api/$url_version/$url_live";
    }
}

# Печатает usage-сообщение
sub usage 
{
    system("podselect -section SYNOPSIS -section DESCRIPTION $0 | pod2text-utf8 >&2");
    exit(1);
}

sub test_extended_timetarget {
    print "PingAPI: ", http_post_json($API_URL, {method => 'PingAPI', %AUTH}) . "\n";

    my $camp_json = http_post_json($API_URL, {method => 'GetCampaignParams', param => {CampaignID => $CID}, %AUTH});
    my $camp = from_json($camp_json)->{data};
    print "GetCampaignParams: " . to_json($camp, {pretty => 1}) . "\n";

    $camp->{Name} = "$camp->{Name} / new";
    $camp->{TimeTarget}->{DaysHours}->[0]->{Hours} = [0, 1, 3, 5];

    my $update_res = http_post_json($API_URL, {method => 'CreateOrUpdateCampaign', param => $camp, %AUTH});
    print "CreateOrUpdateCampaign: $update_res\n";
}

# --------------------------------------------------------------------
sub test_update_banner {
    my $new_banner = [{
        CampaignID => 259407
        # , BannerID => 59696990
        , Title => 'API banner title'
        , Text => 'API banner text'
        , Href => 'http://ya.ru/?123'
        , Geo => '0'
        , AutoMinusWords => 'No'
        , Phrases => [
            {
                IsRubric => 'No'
                , Phrase => 'Краб'
                , PhraseID => 0
                , AutoBroker => 0
                , Price => 0.11
            },
            {
                IsRubric => 'No'
                , Phrase => 'Краб морской'
                , PhraseID => 0
                , AutoBroker => 1
                , Price => 0.33
            },            
            {
                IsRubric => 'No'
                , Phrase => 'Донный краб'
                , PhraseID => 0
                , AutoBroker => 1
                , Price => 0.55
            },            
        ]
    }];
    
    my $json = http_post_json($API_URL, {method => 'CreateOrUpdateBanners', param => $new_banner, %AUTH});
    print "\$json = $json\n";
    my $res = from_json($json)->{data};
    print "CreateOrUpdateBanners: " . to_json($res, {pretty => 1}) . "\n";
}

# -----------------------------------------------------------------------------
sub http_post_json {
    my ($url, $content) = @_;
    my $content_json = to_json($content, {utf8  => 1});

    my $ua = LWP::UserAgent->new;

    my $response = $ua->post($url, Content => $content_json);

    if ($response->is_success) {
        return $response->content;
    } else {
        die $response->status_line;
    }
}

# -----------------------------------------------------------------------------
parse_options();
# test_extended_timetarget();
# test_update_banner();
