#!/usr/bin/perl

use Path::Tiny;
use Getopt::Long;

use Direct::Modern;
use Yandex::Shell;

use my_inc '../../../';
use Settings;

$Yandex::Shell::PRINT_COMMANDS = 1;

my $STOP_TIMEOUT = 60; #seconds

my $type_def = {
    json => { pidfile => "api5_json_coverage_starman.pid", psgi => 'json' },
    soap => { pidfile => "api5_soap_coverage_starman.pid", psgi => 'xml' },
    xml => { pidfile => "api5_xml_coverage_starman.pid", psgi => 'xml' },
};

my ($type, $stop, $host_number);
GetOptions(
    stop => \$stop,
    'type=s' => \$type,
    'host=i' => \$host_number
);

die "no type specified\nUsage: $0 -t (xml|json) --host <host_number> [--stop]\n"
    unless $type && $host_number && exists $type_def->{$type};

my $pidfile = "$Settings::ROOT/protected/run/". $type_def->{$type}{pidfile};
my $psgi_app = "$Settings::ROOT/api/psgi/v5/" . $type_def->{$type}{psgi} . ".psgi";

if ($stop) {
    # такой хак нужен т.к. Net::Server убивает pid-файл до того как умирает сам,
    # чем обманывает wait_until_stop, который смотрит на файл проверяя запущен ли скрипт
    stop();
} else {
    start();
}

sub stop {
    if (-e $pidfile) {
        my $pid = path($pidfile)->slurp;
        chomp $pid;
        if (running($pid)) {
            kill 15 => $pid;
            my $start = time;
            while (running($pid)) {
                sleep 1;
                if (time - $start > $STOP_TIMEOUT) {
                    die "failed to stop in $STOP_TIMEOUT seconds";
                }
            }
        }
    } else {
        die "already stopped";
    }
}

sub start {
    unlink $pidfile if -e $pidfile;

    my @cmd = (
        'perl',
        '-MDevel::Cover',
        '/usr/bin/plackup',
        ( map { "-I$_" } @my_inc::MY_INC ),
        '--server' => 'Starman',
        '--port' => $Settings::BETA_PORT,
        '--host' => "127.0.0.$host_number",
        $psgi_app,
        '--workers' => 10,
        '--pid' => $pidfile,
    );

    yash_system @cmd;
}

sub running {
    my $pid = shift;
    if (kill 0 => $pid) {
        my $cmdline = path("/proc/$pid/cmdline")->slurp();
        if ($cmdline =~ /^starman master/) {
            return 1;
        }
    }
    return;
}
