#!/usr/bin/perl
use strict;
use warnings;

use File::Basename 'basename';
use File::Temp;

use ProjectSpecific;
use Yandex::Shell;

use my_inc '../../..';
use Settings;

$Yandex::Shell::PRINT_COMMANDS = 1;

yash_system('direct-mk', 'service', 'api5_coverage', 'stop');
yash_system('cover');

my $tempdir = File::Temp->newdir( "$Settings::ROOT/data/api5-coverage-XXXXX", CLEANUP => 0 );
yash_system( 'cp', '-aT', "$Settings::ROOT/cover_db", "$tempdir" );
yash_system( 'rm', '-rf', "$Settings::ROOT/cover_db" );

my $coverage_dir_basename = basename($tempdir);
my $url = ProjectSpecific::beta_url($Settings::BETA_PORT) . "/$coverage_dir_basename/coverage.html";
print $url, "\n";
